/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.systemui.statusbar.notification.collection.notifcollection;

import com.android.systemui.statusbar.notification.NotificationEntryManager;
import com.android.systemui.statusbar.notification.collection.NotifPipeline;
import com.android.systemui.statusbar.notification.collection.NotificationEntry;

import java.util.Collection;

/**
 * A notification collection that manages the list of {@link NotificationEntry}s that will be
 * rendered.
 *
 * TODO: (b/145659174) Once we fully switch off {@link NotificationEntryManager} to
 * {@link NotifPipeline}, we probably won't need this, but having it for now makes it easy to
 * switch between the two.
 */
public interface CommonNotifCollection {
    /**
     * Registers a listener to be informed when notifications are created, added, updated, removed,
     * or deleted.
     */
    void addCollectionListener(NotifCollectionListener listener);

    /**
     * Returns the list of all known notifications, i.e. the notifications that are currently posted
     * to the phone. In general, this tracks closely to the list maintained by NotificationManager,
     * but it can diverge slightly due to lifetime extenders.
     *
     * The returned collection is read-only, unsorted, unfiltered, and ungrouped.
     */
    Collection<NotificationEntry> getAllNotifs();
}
