/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.animation.AnimationUtils;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatorInflater {
    private static final int TOGETHER = 0;
    private static final int SEQUENTIALLY = 1;
    private static final int VALUE_TYPE_FLOAT = 0;
    private static final int VALUE_TYPE_INT = 1;
    private static final int VALUE_TYPE_COLOR = 4;
    private static final int VALUE_TYPE_CUSTOM = 5;

    public static Animator loadAnimator(Context context, int id2) throws Resources.NotFoundException {
        XmlResourceParser parser = null;
        try {
            parser = context.getResources().getAnimation(id2);
            Animator animator2 = AnimatorInflater.createAnimatorFromXml(context, parser);
            return animator2;
        }
        catch (XmlPullParserException ex) {
            Resources.NotFoundException rnf = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(ex);
            throw rnf;
        }
        catch (IOException ex) {
            Resources.NotFoundException rnf = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(id2));
            rnf.initCause(ex);
            throw rnf;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    private static Animator createAnimatorFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return AnimatorInflater.createAnimatorFromXml(c, parser, Xml.asAttributeSet(parser), null, 0);
    }

    private static Animator createAnimatorFromXml(Context c, XmlPullParser parser, AttributeSet attrs, AnimatorSet parent, int sequenceOrdering) throws XmlPullParserException, IOException {
        int type;
        Animator anim2 = null;
        ArrayList<ObjectAnimator> childAnims = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("objectAnimator")) {
                anim2 = AnimatorInflater.loadObjectAnimator(c, attrs);
            } else if (name.equals("animator")) {
                anim2 = AnimatorInflater.loadAnimator(c, attrs, null);
            } else if (name.equals("set")) {
                anim2 = new AnimatorSet();
                TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.AnimatorSet);
                int ordering = a.getInt(0, 0);
                AnimatorInflater.createAnimatorFromXml(c, parser, attrs, (AnimatorSet)anim2, ordering);
                a.recycle();
            } else {
                throw new RuntimeException("Unknown animator name: " + parser.getName());
            }
            if (parent == null) continue;
            if (childAnims == null) {
                childAnims = new ArrayList<ObjectAnimator>();
            }
            childAnims.add((ObjectAnimator)anim2);
        }
        if (parent != null && childAnims != null) {
            Animator[] animsArray = new Animator[childAnims.size()];
            int index = 0;
            for (Animator animator2 : childAnims) {
                animsArray[index++] = animator2;
            }
            if (sequenceOrdering == 0) {
                parent.playTogether(animsArray);
            } else {
                parent.playSequentially(animsArray);
            }
        }
        return anim2;
    }

    private static ObjectAnimator loadObjectAnimator(Context context, AttributeSet attrs) throws Resources.NotFoundException {
        ObjectAnimator anim2 = new ObjectAnimator();
        AnimatorInflater.loadAnimator(context, attrs, anim2);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PropertyAnimator);
        String propertyName = a.getString(0);
        anim2.setPropertyName(propertyName);
        a.recycle();
        return anim2;
    }

    private static ValueAnimator loadAnimator(Context context, AttributeSet attrs, ValueAnimator anim2) throws Resources.NotFoundException {
        int resID;
        int toType;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Animator);
        long duration = a.getInt(1, 300);
        long startDelay = a.getInt(2, 0);
        int valueType = a.getInt(7, 0);
        if (anim2 == null) {
            anim2 = new ValueAnimator();
        }
        TypeEvaluator evaluator = null;
        int valueFromIndex = 5;
        int valueToIndex = 6;
        boolean getFloats = valueType == 0;
        TypedValue tvFrom = a.peekValue(valueFromIndex);
        boolean hasFrom = tvFrom != null;
        int fromType = hasFrom ? tvFrom.type : 0;
        TypedValue tvTo = a.peekValue(valueToIndex);
        boolean hasTo = tvTo != null;
        int n = toType = hasTo ? tvTo.type : 0;
        if (hasFrom && fromType >= 28 && fromType <= 31 || hasTo && toType >= 28 && toType <= 31) {
            getFloats = false;
            anim2.setEvaluator(new ArgbEvaluator());
        }
        if (getFloats) {
            if (hasFrom) {
                float valueFrom = fromType == 5 ? a.getDimension(valueFromIndex, 0.0f) : a.getFloat(valueFromIndex, 0.0f);
                if (hasTo) {
                    float valueTo = toType == 5 ? a.getDimension(valueToIndex, 0.0f) : a.getFloat(valueToIndex, 0.0f);
                    anim2.setFloatValues(valueFrom, valueTo);
                } else {
                    anim2.setFloatValues(valueFrom);
                }
            } else {
                float valueTo = toType == 5 ? a.getDimension(valueToIndex, 0.0f) : a.getFloat(valueToIndex, 0.0f);
                anim2.setFloatValues(valueTo);
            }
        } else if (hasFrom) {
            int valueFrom = fromType == 5 ? (int)a.getDimension(valueFromIndex, 0.0f) : (fromType >= 28 && fromType <= 31 ? a.getColor(valueFromIndex, 0) : a.getInt(valueFromIndex, 0));
            if (hasTo) {
                int valueTo = toType == 5 ? (int)a.getDimension(valueToIndex, 0.0f) : (toType >= 28 && toType <= 31 ? a.getColor(valueToIndex, 0) : a.getInt(valueToIndex, 0));
                anim2.setIntValues(valueFrom, valueTo);
            } else {
                anim2.setIntValues(valueFrom);
            }
        } else if (hasTo) {
            int valueTo = toType == 5 ? (int)a.getDimension(valueToIndex, 0.0f) : (toType >= 28 && toType <= 31 ? a.getColor(valueToIndex, 0) : a.getInt(valueToIndex, 0));
            anim2.setIntValues(valueTo);
        }
        anim2.setDuration(duration);
        anim2.setStartDelay(startDelay);
        if (a.hasValue(3)) {
            anim2.setRepeatCount(a.getInt(3, 0));
        }
        if (a.hasValue(4)) {
            anim2.setRepeatMode(a.getInt(4, 1));
        }
        if (evaluator != null) {
            anim2.setEvaluator(evaluator);
        }
        if ((resID = a.getResourceId(0, 0)) > 0) {
            anim2.setInterpolator(AnimationUtils.loadInterpolator(context, resID));
        }
        a.recycle();
        return anim2;
    }
}

