/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.NativeAllocatorTag;
import android.filterfw.core.Program;
import android.filterfw.core.StopWatchMap;
import android.filterfw.core.VertexFrame;
import android.filterfw.geometry.Quad;
import android.opengl.GLES20;

public class ShaderProgram
extends Program {
    private int shaderProgramId;
    private int mMaxTileSize = 0;
    private GLEnvironment mGLEnvironment;
    private StopWatchMap mTimer = null;

    private void setTimer() {
        this.mTimer = new StopWatchMap();
    }

    private ShaderProgram() {
    }

    private ShaderProgram(NativeAllocatorTag tag) {
    }

    public ShaderProgram(FilterContext context, String fragmentShader) {
        this.mGLEnvironment = ShaderProgram.getGLEnvironment(context);
        this.allocate(this.mGLEnvironment, null, fragmentShader);
        if (!this.compileAndLink()) {
            throw new RuntimeException("Could not compile and link shader!");
        }
        this.setTimer();
    }

    public ShaderProgram(FilterContext context, String vertexShader, String fragmentShader) {
        this.mGLEnvironment = ShaderProgram.getGLEnvironment(context);
        this.allocate(this.mGLEnvironment, vertexShader, fragmentShader);
        if (!this.compileAndLink()) {
            throw new RuntimeException("Could not compile and link shader!");
        }
        this.setTimer();
    }

    public static ShaderProgram createIdentity(FilterContext context) {
        ShaderProgram program = ShaderProgram.nativeCreateIdentity(ShaderProgram.getGLEnvironment(context));
        program.setTimer();
        return program;
    }

    protected void finalize() throws Throwable {
        this.deallocate();
    }

    public GLEnvironment getGLEnvironment() {
        return this.mGLEnvironment;
    }

    public void process(Frame[] inputs, Frame output) {
        if (this.mTimer.LOG_MFF_RUNNING_TIMES) {
            this.mTimer.start("glFinish");
            GLES20.glFinish();
            this.mTimer.stop("glFinish");
        }
        GLFrame[] glInputs = new GLFrame[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            if (!(inputs[i] instanceof GLFrame)) {
                throw new RuntimeException("ShaderProgram got non-GL frame as input " + i + "!");
            }
            glInputs[i] = (GLFrame)inputs[i];
        }
        GLFrame glOutput = null;
        if (!(output instanceof GLFrame)) {
            throw new RuntimeException("ShaderProgram got non-GL output frame!");
        }
        glOutput = (GLFrame)output;
        if (this.mMaxTileSize > 0) {
            int xTiles = (output.getFormat().getWidth() + this.mMaxTileSize - 1) / this.mMaxTileSize;
            int yTiles = (output.getFormat().getHeight() + this.mMaxTileSize - 1) / this.mMaxTileSize;
            this.setShaderTileCounts(xTiles, yTiles);
        }
        if (!this.shaderProcess(glInputs, glOutput)) {
            throw new RuntimeException("Error executing ShaderProgram!");
        }
        if (this.mTimer.LOG_MFF_RUNNING_TIMES) {
            GLES20.glFinish();
        }
    }

    public void setHostValue(String variableName, Object value) {
        if (!this.setUniformValue(variableName, value)) {
            throw new RuntimeException("Error setting uniform value for variable '" + variableName + "'!");
        }
    }

    public Object getHostValue(String variableName) {
        return this.getUniformValue(variableName);
    }

    public void setAttributeValues(String attributeName, float[] data, int componentCount) {
        if (!this.setShaderAttributeValues(attributeName, data, componentCount)) {
            throw new RuntimeException("Error setting attribute value for attribute '" + attributeName + "'!");
        }
    }

    public void setAttributeValues(String attributeName, VertexFrame vertexData, int type, int componentCount, int strideInBytes, int offsetInBytes, boolean normalize) {
        if (!this.setShaderAttributeVertexFrame(attributeName, vertexData, type, componentCount, strideInBytes, offsetInBytes, normalize)) {
            throw new RuntimeException("Error setting attribute value for attribute '" + attributeName + "'!");
        }
    }

    public void setSourceRegion(Quad region) {
        this.setSourceRegion(region.p0.x, region.p0.y, region.p1.x, region.p1.y, region.p2.x, region.p2.y, region.p3.x, region.p3.y);
    }

    public void setTargetRegion(Quad region) {
        this.setTargetRegion(region.p0.x, region.p0.y, region.p1.x, region.p1.y, region.p2.x, region.p2.y, region.p3.x, region.p3.y);
    }

    public void setSourceRect(float x, float y, float width, float height) {
        this.setSourceRegion(x, y, x + width, y, x, y + height, x + width, y + height);
    }

    public void setTargetRect(float x, float y, float width, float height) {
        this.setTargetRegion(x, y, x + width, y, x, y + height, x + width, y + height);
    }

    public void setClearsOutput(boolean clears) {
        if (!this.setShaderClearsOutput(clears)) {
            throw new RuntimeException("Could not set clears-output flag to " + clears + "!");
        }
    }

    public void setClearColor(float r, float g, float b) {
        if (!this.setShaderClearColor(r, g, b)) {
            throw new RuntimeException("Could not set clear color to " + r + "," + g + "," + b + "!");
        }
    }

    public void setBlendEnabled(boolean enable) {
        if (!this.setShaderBlendEnabled(enable)) {
            throw new RuntimeException("Could not set Blending " + enable + "!");
        }
    }

    public void setBlendFunc(int sfactor, int dfactor) {
        if (!this.setShaderBlendFunc(sfactor, dfactor)) {
            throw new RuntimeException("Could not set BlendFunc " + sfactor + "," + dfactor + "!");
        }
    }

    public void setDrawMode(int drawMode) {
        if (!this.setShaderDrawMode(drawMode)) {
            throw new RuntimeException("Could not set GL draw-mode to " + drawMode + "!");
        }
    }

    public void setVertexCount(int count) {
        if (!this.setShaderVertexCount(count)) {
            throw new RuntimeException("Could not set GL vertex count to " + count + "!");
        }
    }

    public void setMaximumTileSize(int size) {
        this.mMaxTileSize = size;
    }

    public void beginDrawing() {
        if (!this.beginShaderDrawing()) {
            throw new RuntimeException("Could not prepare shader-program for drawing!");
        }
    }

    private static GLEnvironment getGLEnvironment(FilterContext context) {
        GLEnvironment result;
        GLEnvironment gLEnvironment = result = context != null ? context.getGLEnvironment() : null;
        if (result == null) {
            throw new NullPointerException("Attempting to create ShaderProgram with no GL environment in place!");
        }
        return result;
    }

    private native boolean allocate(GLEnvironment var1, String var2, String var3);

    private native boolean deallocate();

    private native boolean compileAndLink();

    private native boolean shaderProcess(GLFrame[] var1, GLFrame var2);

    private native boolean setUniformValue(String var1, Object var2);

    private native Object getUniformValue(String var1);

    public native boolean setSourceRegion(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    private native boolean setTargetRegion(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    private static native ShaderProgram nativeCreateIdentity(GLEnvironment var0);

    private native boolean setShaderClearsOutput(boolean var1);

    private native boolean setShaderBlendEnabled(boolean var1);

    private native boolean setShaderBlendFunc(int var1, int var2);

    private native boolean setShaderClearColor(float var1, float var2, float var3);

    private native boolean setShaderDrawMode(int var1);

    private native boolean setShaderTileCounts(int var1, int var2);

    private native boolean setShaderVertexCount(int var1);

    private native boolean beginShaderDrawing();

    private native boolean setShaderAttributeValues(String var1, float[] var2, int var3);

    private native boolean setShaderAttributeVertexFrame(String var1, VertexFrame var2, int var3, int var4, int var5, int var6, boolean var7);

    static {
        System.loadLibrary("filterfw");
    }
}

