/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import java.io.InputStream;
import java.io.OutputStream;

public class Picture {
    private Canvas mRecordingCanvas;
    private final int mNativePicture;
    public final boolean createdFromStream;
    private static final int WORKING_STREAM_STORAGE = 16384;

    public Picture() {
        this(Picture.nativeConstructor(0), false);
    }

    public Picture(Picture src) {
        this(Picture.nativeConstructor(src != null ? src.mNativePicture : 0), false);
    }

    public Canvas beginRecording(int width, int height) {
        int ni = Picture.nativeBeginRecording(this.mNativePicture, width, height);
        this.mRecordingCanvas = new RecordingCanvas(this, ni);
        return this.mRecordingCanvas;
    }

    public void endRecording() {
        if (this.mRecordingCanvas != null) {
            this.mRecordingCanvas = null;
            Picture.nativeEndRecording(this.mNativePicture);
        }
    }

    public native int getWidth();

    public native int getHeight();

    public void draw(Canvas canvas) {
        if (this.mRecordingCanvas != null) {
            this.endRecording();
        }
        Picture.nativeDraw(canvas.mNativeCanvas, this.mNativePicture);
    }

    @Deprecated
    public static Picture createFromStream(InputStream stream) {
        return new Picture(Picture.nativeCreateFromStream(stream, new byte[16384]), true);
    }

    @Deprecated
    public void writeToStream(OutputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        if (!Picture.nativeWriteToStream(this.mNativePicture, stream, new byte[16384])) {
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Picture.nativeDestructor(this.mNativePicture);
        }
        finally {
            super.finalize();
        }
    }

    final int ni() {
        return this.mNativePicture;
    }

    private Picture(int nativePicture, boolean fromStream) {
        if (nativePicture == 0) {
            throw new RuntimeException();
        }
        this.mNativePicture = nativePicture;
        this.createdFromStream = fromStream;
    }

    private static native int nativeConstructor(int var0);

    private static native int nativeCreateFromStream(InputStream var0, byte[] var1);

    private static native int nativeBeginRecording(int var0, int var1, int var2);

    private static native void nativeEndRecording(int var0);

    private static native void nativeDraw(int var0, int var1);

    private static native boolean nativeWriteToStream(int var0, OutputStream var1, byte[] var2);

    private static native void nativeDestructor(int var0);

    private static class RecordingCanvas
    extends Canvas {
        private final Picture mPicture;

        public RecordingCanvas(Picture pict, int nativeCanvas) {
            super(nativeCanvas);
            this.mPicture = pict;
        }

        public void setBitmap(Bitmap bitmap) {
            throw new RuntimeException("Cannot call setBitmap on a picture canvas");
        }

        public void drawPicture(Picture picture) {
            if (this.mPicture == picture) {
                throw new RuntimeException("Cannot draw a picture into its recording canvas");
            }
            super.drawPicture(picture);
        }
    }
}

