/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decorator<T>
implements InvocationHandler {
    private final T mObject;
    private final DecoratorListener mListener;

    public static <T> T newInstance(T obj, DecoratorListener listener) {
        return (T)Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), new Decorator<T>(obj, listener));
    }

    private Decorator(T obj, DecoratorListener listener) {
        this.mObject = obj;
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result = null;
        try {
            this.mListener.onBeforeInvocation(m, args);
            result = m.invoke(this.mObject, args);
            this.mListener.onAfterInvocation(m, args, result);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (!this.mListener.onCatchException(m, args, t)) {
                throw t;
            }
        }
        finally {
            this.mListener.onFinally(m, args);
        }
        return result;
    }

    public static interface DecoratorListener {
        public void onBeforeInvocation(Method var1, Object[] var2);

        public void onAfterInvocation(Method var1, Object[] var2, Object var3);

        public boolean onCatchException(Method var1, Object[] var2, Throwable var3);

        public void onFinally(Method var1, Object[] var2);
    }
}

