/*
 * Decompiled with CFR 0.152.
 */
package android.media.videoeditor;

import android.media.videoeditor.Effect;
import android.media.videoeditor.EffectColor;
import android.media.videoeditor.MediaArtistNativeHelper;
import android.media.videoeditor.MediaItem;
import android.media.videoeditor.MediaVideoItem;
import android.media.videoeditor.Overlay;
import android.media.videoeditor.OverlayFrame;
import android.media.videoeditor.TransitionAlpha;
import android.media.videoeditor.TransitionCrossfade;
import android.media.videoeditor.TransitionFadeBlack;
import android.media.videoeditor.TransitionSliding;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transition {
    private static final int BEHAVIOR_MIN_VALUE = 0;
    public static final int BEHAVIOR_SPEED_UP = 0;
    public static final int BEHAVIOR_SPEED_DOWN = 1;
    public static final int BEHAVIOR_LINEAR = 2;
    public static final int BEHAVIOR_MIDDLE_SLOW = 3;
    public static final int BEHAVIOR_MIDDLE_FAST = 4;
    private static final int BEHAVIOR_MAX_VALUE = 4;
    private final String mUniqueId;
    private final MediaItem mAfterMediaItem;
    private final MediaItem mBeforeMediaItem;
    protected final int mBehavior;
    protected long mDurationMs;
    protected String mFilename;
    protected MediaArtistNativeHelper mNativeHelper;

    private Transition() {
        this(null, null, null, 0L, 0);
    }

    protected Transition(String transitionId, MediaItem afterMediaItem, MediaItem beforeMediaItem, long durationMs, int behavior) {
        if (behavior < 0 || behavior > 4) {
            throw new IllegalArgumentException("Invalid behavior: " + behavior);
        }
        if (afterMediaItem == null && beforeMediaItem == null) {
            throw new IllegalArgumentException("Null media items");
        }
        this.mUniqueId = transitionId;
        this.mAfterMediaItem = afterMediaItem;
        this.mBeforeMediaItem = beforeMediaItem;
        this.mDurationMs = durationMs;
        this.mBehavior = behavior;
        this.mNativeHelper = null;
        if (durationMs > this.getMaximumDuration()) {
            throw new IllegalArgumentException("The duration is too large");
        }
        this.mNativeHelper = afterMediaItem != null ? afterMediaItem.getNativeContext() : beforeMediaItem.getNativeContext();
    }

    public String getId() {
        return this.mUniqueId;
    }

    public MediaItem getAfterMediaItem() {
        return this.mAfterMediaItem;
    }

    public MediaItem getBeforeMediaItem() {
        return this.mBeforeMediaItem;
    }

    public void setDuration(long durationMs) {
        if (durationMs > this.getMaximumDuration()) {
            throw new IllegalArgumentException("The duration is too large");
        }
        this.mDurationMs = durationMs;
        this.invalidate();
        this.mNativeHelper.setGeneratePreview(true);
    }

    public long getDuration() {
        return this.mDurationMs;
    }

    public long getMaximumDuration() {
        if (this.mAfterMediaItem == null) {
            return this.mBeforeMediaItem.getTimelineDuration() / 2L;
        }
        if (this.mBeforeMediaItem == null) {
            return this.mAfterMediaItem.getTimelineDuration() / 2L;
        }
        return Math.min(this.mAfterMediaItem.getTimelineDuration(), this.mBeforeMediaItem.getTimelineDuration()) / 2L;
    }

    public int getBehavior() {
        return this.mBehavior;
    }

    MediaArtistNativeHelper.TransitionSettings getTransitionSettings() {
        TransitionAlpha transitionAlpha = null;
        TransitionSliding transitionSliding = null;
        TransitionCrossfade transitionCrossfade = null;
        TransitionFadeBlack transitionFadeBlack = null;
        MediaArtistNativeHelper.TransitionSettings transitionSetting = null;
        transitionSetting = new MediaArtistNativeHelper.TransitionSettings();
        transitionSetting.duration = (int)this.getDuration();
        if (this instanceof TransitionAlpha) {
            transitionAlpha = (TransitionAlpha)this;
            transitionSetting.videoTransitionType = 257;
            transitionSetting.audioTransitionType = 1;
            transitionSetting.transitionBehaviour = this.mNativeHelper.getVideoTransitionBehaviour(transitionAlpha.getBehavior());
            transitionSetting.alphaSettings = new MediaArtistNativeHelper.AlphaMagicSettings();
            transitionSetting.slideSettings = null;
            transitionSetting.alphaSettings.file = transitionAlpha.getPNGMaskFilename();
            transitionSetting.alphaSettings.blendingPercent = transitionAlpha.getBlendingPercent();
            transitionSetting.alphaSettings.invertRotation = transitionAlpha.isInvert();
            transitionSetting.alphaSettings.rgbWidth = transitionAlpha.getRGBFileWidth();
            transitionSetting.alphaSettings.rgbHeight = transitionAlpha.getRGBFileHeight();
        } else if (this instanceof TransitionSliding) {
            transitionSliding = (TransitionSliding)this;
            transitionSetting.videoTransitionType = 258;
            transitionSetting.audioTransitionType = 1;
            transitionSetting.transitionBehaviour = this.mNativeHelper.getVideoTransitionBehaviour(transitionSliding.getBehavior());
            transitionSetting.alphaSettings = null;
            transitionSetting.slideSettings = new MediaArtistNativeHelper.SlideTransitionSettings();
            transitionSetting.slideSettings.direction = this.mNativeHelper.getSlideSettingsDirection(transitionSliding.getDirection());
        } else if (this instanceof TransitionCrossfade) {
            transitionCrossfade = (TransitionCrossfade)this;
            transitionSetting.videoTransitionType = 1;
            transitionSetting.audioTransitionType = 1;
            transitionSetting.transitionBehaviour = this.mNativeHelper.getVideoTransitionBehaviour(transitionCrossfade.getBehavior());
            transitionSetting.alphaSettings = null;
            transitionSetting.slideSettings = null;
        } else if (this instanceof TransitionFadeBlack) {
            transitionFadeBlack = (TransitionFadeBlack)this;
            transitionSetting.videoTransitionType = 259;
            transitionSetting.audioTransitionType = 1;
            transitionSetting.transitionBehaviour = this.mNativeHelper.getVideoTransitionBehaviour(transitionFadeBlack.getBehavior());
            transitionSetting.alphaSettings = null;
            transitionSetting.slideSettings = null;
        }
        return transitionSetting;
    }

    List<MediaArtistNativeHelper.EffectSettings> isEffectandOverlayOverlapping(MediaItem m, MediaArtistNativeHelper.ClipSettings clipSettings, int clipNo) {
        MediaArtistNativeHelper.EffectSettings tmpEffectSettings;
        ArrayList<MediaArtistNativeHelper.EffectSettings> effectSettings = new ArrayList<MediaArtistNativeHelper.EffectSettings>();
        List<Overlay> overlays = m.getAllOverlays();
        for (Overlay overlay : overlays) {
            tmpEffectSettings = this.mNativeHelper.getOverlaySettings((OverlayFrame)overlay);
            this.mNativeHelper.adjustEffectsStartTimeAndDuration(tmpEffectSettings, clipSettings.beginCutTime, clipSettings.endCutTime);
            if (tmpEffectSettings.duration == 0) continue;
            effectSettings.add(tmpEffectSettings);
        }
        List<Effect> effects = m.getAllEffects();
        for (Effect effect : effects) {
            if (!(effect instanceof EffectColor)) continue;
            tmpEffectSettings = this.mNativeHelper.getEffectSettings((EffectColor)effect);
            this.mNativeHelper.adjustEffectsStartTimeAndDuration(tmpEffectSettings, clipSettings.beginCutTime, clipSettings.endCutTime);
            if (tmpEffectSettings.duration == 0) continue;
            if (m instanceof MediaVideoItem) {
                tmpEffectSettings.fiftiesFrameRate = this.mNativeHelper.GetClosestVideoFrameRate(((MediaVideoItem)m).getFps());
            }
            effectSettings.add(tmpEffectSettings);
        }
        return effectSettings;
    }

    void generate() {
        MediaItem m1 = this.getAfterMediaItem();
        MediaItem m2 = this.getBeforeMediaItem();
        MediaArtistNativeHelper.ClipSettings clipSettings1 = new MediaArtistNativeHelper.ClipSettings();
        MediaArtistNativeHelper.ClipSettings clipSettings2 = new MediaArtistNativeHelper.ClipSettings();
        MediaArtistNativeHelper.TransitionSettings transitionSetting = null;
        MediaArtistNativeHelper.EditSettings editSettings = new MediaArtistNativeHelper.EditSettings();
        String output = null;
        if (this.mNativeHelper == null) {
            if (m1 != null) {
                this.mNativeHelper = m1.getNativeContext();
            } else if (m2 != null) {
                this.mNativeHelper = m2.getNativeContext();
            }
        }
        transitionSetting = this.getTransitionSettings();
        if (m1 != null && m2 != null) {
            clipSettings1 = m1.getClipSettings();
            clipSettings2 = m2.getClipSettings();
            clipSettings1.beginCutTime = (int)((long)clipSettings1.endCutTime - this.mDurationMs);
            clipSettings2.endCutTime = (int)((long)clipSettings2.beginCutTime + this.mDurationMs);
            List<MediaArtistNativeHelper.EffectSettings> effectSettings_clip1 = this.isEffectandOverlayOverlapping(m1, clipSettings1, 1);
            List<MediaArtistNativeHelper.EffectSettings> effectSettings_clip2 = this.isEffectandOverlayOverlapping(m2, clipSettings2, 2);
            for (int index = 0; index < effectSettings_clip2.size(); ++index) {
                effectSettings_clip2.get((int)index).startTime = (int)((long)effectSettings_clip2.get((int)index).startTime + this.mDurationMs);
            }
            editSettings.effectSettingsArray = new MediaArtistNativeHelper.EffectSettings[effectSettings_clip1.size() + effectSettings_clip2.size()];
            int i = 0;
            int j = 0;
            while (i < effectSettings_clip1.size()) {
                editSettings.effectSettingsArray[j] = effectSettings_clip1.get(i);
                ++i;
                ++j;
            }
            i = 0;
            while (i < effectSettings_clip2.size()) {
                editSettings.effectSettingsArray[j] = effectSettings_clip2.get(i);
                ++i;
                ++j;
            }
        } else if (m1 == null && m2 != null) {
            m2.generateBlankFrame(clipSettings1);
            clipSettings2 = m2.getClipSettings();
            clipSettings1.endCutTime = (int)(this.mDurationMs + 50L);
            clipSettings2.endCutTime = (int)((long)clipSettings2.beginCutTime + this.mDurationMs);
            List<MediaArtistNativeHelper.EffectSettings> effectSettings_clip2 = this.isEffectandOverlayOverlapping(m2, clipSettings2, 2);
            for (int index = 0; index < effectSettings_clip2.size(); ++index) {
                effectSettings_clip2.get((int)index).startTime = (int)((long)effectSettings_clip2.get((int)index).startTime + this.mDurationMs);
            }
            editSettings.effectSettingsArray = new MediaArtistNativeHelper.EffectSettings[effectSettings_clip2.size()];
            int i = 0;
            int j = 0;
            while (i < effectSettings_clip2.size()) {
                editSettings.effectSettingsArray[j] = effectSettings_clip2.get(i);
                ++i;
                ++j;
            }
        } else if (m1 != null && m2 == null) {
            clipSettings1 = m1.getClipSettings();
            m1.generateBlankFrame(clipSettings2);
            clipSettings1.beginCutTime = (int)((long)clipSettings1.endCutTime - this.mDurationMs);
            clipSettings2.endCutTime = (int)(this.mDurationMs + 50L);
            List<MediaArtistNativeHelper.EffectSettings> effectSettings_clip1 = this.isEffectandOverlayOverlapping(m1, clipSettings1, 1);
            editSettings.effectSettingsArray = new MediaArtistNativeHelper.EffectSettings[effectSettings_clip1.size()];
            int i = 0;
            int j = 0;
            while (i < effectSettings_clip1.size()) {
                editSettings.effectSettingsArray[j] = effectSettings_clip1.get(i);
                ++i;
                ++j;
            }
        }
        editSettings.clipSettingsArray = new MediaArtistNativeHelper.ClipSettings[2];
        editSettings.clipSettingsArray[0] = clipSettings1;
        editSettings.clipSettingsArray[1] = clipSettings2;
        editSettings.backgroundMusicSettings = null;
        editSettings.transitionSettingsArray = new MediaArtistNativeHelper.TransitionSettings[1];
        editSettings.transitionSettingsArray[0] = transitionSetting;
        output = this.mNativeHelper.generateTransitionClip(editSettings, this.mUniqueId, m1, m2, this);
        this.setFilename(output);
    }

    void setFilename(String filename) {
        this.mFilename = filename;
    }

    String getFilename() {
        return this.mFilename;
    }

    void invalidate() {
        if (this.mFilename != null) {
            new File(this.mFilename).delete();
            this.mFilename = null;
        }
    }

    boolean isGenerated() {
        return this.mFilename != null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Transition)) {
            return false;
        }
        return this.mUniqueId.equals(((Transition)object).mUniqueId);
    }

    public int hashCode() {
        return this.mUniqueId.hashCode();
    }
}

