/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.content.Context;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.print.ILayoutResultCallback;
import android.print.IPrintDocumentAdapter;
import android.print.IPrintJobStateChangeListener;
import android.print.IPrintManager;
import android.print.IWriteResultCallback;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.print.PrintJob;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterDiscoverySession;
import android.printservice.PrintServiceInfo;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.os.SomeArgs;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrintManager {
    private static final String LOG_TAG = "PrintManager";
    private static final boolean DEBUG = false;
    private static final int MSG_NOTIFY_PRINT_JOB_STATE_CHANGED = 1;
    public static final String ACTION_PRINT_DIALOG = "android.print.PRINT_DIALOG";
    public static final String EXTRA_PRINT_DIALOG_INTENT = "android.print.intent.extra.EXTRA_PRINT_DIALOG_INTENT";
    public static final String EXTRA_PRINT_JOB = "android.print.intent.extra.EXTRA_PRINT_JOB";
    public static final String EXTRA_PRINT_DOCUMENT_ADAPTER = "android.print.intent.extra.EXTRA_PRINT_DOCUMENT_ADAPTER";
    public static final int APP_ID_ANY = -2;
    private final Context mContext;
    private final IPrintManager mService;
    private final int mUserId;
    private final int mAppId;
    private final Handler mHandler;
    private Map<PrintJobStateChangeListener, PrintJobStateChangeListenerWrapper> mPrintJobStateChangeListeners;

    public PrintManager(Context context, IPrintManager service, int userId, int appId) {
        this.mContext = context;
        this.mService = service;
        this.mUserId = userId;
        this.mAppId = appId;
        this.mHandler = new Handler(context.getMainLooper(), null, false){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        SomeArgs args = (SomeArgs)message.obj;
                        PrintJobStateChangeListenerWrapper wrapper = (PrintJobStateChangeListenerWrapper)args.arg1;
                        PrintJobStateChangeListener listener = wrapper.getListener();
                        if (listener != null) {
                            PrintJobId printJobId = (PrintJobId)args.arg2;
                            listener.onPrintJobStateChanged(printJobId);
                        }
                        args.recycle();
                    }
                }
            }
        };
    }

    public PrintManager getGlobalPrintManagerForUser(int userId) {
        return new PrintManager(this.mContext, this.mService, userId, -2);
    }

    PrintJobInfo getPrintJobInfo(PrintJobId printJobId) {
        try {
            return this.mService.getPrintJobInfo(printJobId, this.mAppId, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting a print job info:" + printJobId, re);
            return null;
        }
    }

    public void addPrintJobStateChangeListener(PrintJobStateChangeListener listener) {
        if (this.mPrintJobStateChangeListeners == null) {
            this.mPrintJobStateChangeListeners = new ArrayMap<PrintJobStateChangeListener, PrintJobStateChangeListenerWrapper>();
        }
        PrintJobStateChangeListenerWrapper wrappedListener = new PrintJobStateChangeListenerWrapper(listener, this.mHandler);
        try {
            this.mService.addPrintJobStateChangeListener(wrappedListener, this.mAppId, this.mUserId);
            this.mPrintJobStateChangeListeners.put(listener, wrappedListener);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error adding print job state change listener", re);
        }
    }

    public void removePrintJobStateChangeListener(PrintJobStateChangeListener listener) {
        if (this.mPrintJobStateChangeListeners == null) {
            return;
        }
        PrintJobStateChangeListenerWrapper wrappedListener = this.mPrintJobStateChangeListeners.remove(listener);
        if (wrappedListener == null) {
            return;
        }
        if (this.mPrintJobStateChangeListeners.isEmpty()) {
            this.mPrintJobStateChangeListeners = null;
        }
        wrappedListener.destroy();
        try {
            this.mService.removePrintJobStateChangeListener(wrappedListener, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error removing print job state change listener", re);
        }
    }

    public PrintJob getPrintJob(PrintJobId printJobId) {
        try {
            PrintJobInfo printJob = this.mService.getPrintJobInfo(printJobId, this.mAppId, this.mUserId);
            if (printJob != null) {
                return new PrintJob(printJob, this);
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting print job", re);
        }
        return null;
    }

    public List<PrintJob> getPrintJobs() {
        try {
            List<PrintJobInfo> printJobInfos = this.mService.getPrintJobInfos(this.mAppId, this.mUserId);
            if (printJobInfos == null) {
                return Collections.emptyList();
            }
            int printJobCount = printJobInfos.size();
            ArrayList<PrintJob> printJobs = new ArrayList<PrintJob>(printJobCount);
            for (int i = 0; i < printJobCount; ++i) {
                printJobs.add(new PrintJob(printJobInfos.get(i), this));
            }
            return printJobs;
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting print jobs", re);
            return Collections.emptyList();
        }
    }

    void cancelPrintJob(PrintJobId printJobId) {
        try {
            this.mService.cancelPrintJob(printJobId, this.mAppId, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error cancleing a print job: " + printJobId, re);
        }
    }

    void restartPrintJob(PrintJobId printJobId) {
        try {
            this.mService.restartPrintJob(printJobId, this.mAppId, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error restarting a print job: " + printJobId, re);
        }
    }

    public PrintJob print(String printJobName, PrintDocumentAdapter documentAdapter, PrintAttributes attributes) {
        if (TextUtils.isEmpty(printJobName)) {
            throw new IllegalArgumentException("priintJobName cannot be empty");
        }
        PrintDocumentAdapterDelegate delegate = new PrintDocumentAdapterDelegate(documentAdapter, this.mContext.getMainLooper());
        try {
            Bundle result = this.mService.print(printJobName, delegate, attributes, this.mContext.getPackageName(), this.mAppId, this.mUserId);
            if (result != null) {
                PrintJobInfo printJob = (PrintJobInfo)result.getParcelable(EXTRA_PRINT_JOB);
                IntentSender intent = (IntentSender)result.getParcelable(EXTRA_PRINT_DIALOG_INTENT);
                if (printJob == null || intent == null) {
                    return null;
                }
                try {
                    this.mContext.startIntentSender(intent, null, 0, 0, 0);
                    return new PrintJob(printJob, this);
                }
                catch (IntentSender.SendIntentException sie) {
                    Log.e(LOG_TAG, "Couldn't start print job config activity.", sie);
                }
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error creating a print job", re);
        }
        return null;
    }

    public List<PrintServiceInfo> getEnabledPrintServices() {
        try {
            List<PrintServiceInfo> enabledServices = this.mService.getEnabledPrintServices(this.mUserId);
            if (enabledServices != null) {
                return enabledServices;
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting the enabled print services", re);
        }
        return Collections.emptyList();
    }

    public List<PrintServiceInfo> getInstalledPrintServices() {
        try {
            List<PrintServiceInfo> installedServices = this.mService.getInstalledPrintServices(this.mUserId);
            if (installedServices != null) {
                return installedServices;
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting the installed print services", re);
        }
        return Collections.emptyList();
    }

    public PrinterDiscoverySession createPrinterDiscoverySession() {
        return new PrinterDiscoverySession(this.mService, this.mContext, this.mUserId);
    }

    private static final class PrintJobStateChangeListenerWrapper
    extends IPrintJobStateChangeListener.Stub {
        private final WeakReference<PrintJobStateChangeListener> mWeakListener;
        private final WeakReference<Handler> mWeakHandler;

        public PrintJobStateChangeListenerWrapper(PrintJobStateChangeListener listener, Handler handler) {
            this.mWeakListener = new WeakReference<PrintJobStateChangeListener>(listener);
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        public void onPrintJobStateChanged(PrintJobId printJobId) {
            Handler handler = (Handler)this.mWeakHandler.get();
            PrintJobStateChangeListener listener = (PrintJobStateChangeListener)this.mWeakListener.get();
            if (handler != null && listener != null) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = this;
                args.arg2 = printJobId;
                handler.obtainMessage(1, args).sendToTarget();
            }
        }

        public void destroy() {
            this.mWeakListener.clear();
        }

        public PrintJobStateChangeListener getListener() {
            return (PrintJobStateChangeListener)this.mWeakListener.get();
        }
    }

    private static final class PrintDocumentAdapterDelegate
    extends IPrintDocumentAdapter.Stub {
        private final Object mLock = new Object();
        private CancellationSignal mLayoutOrWriteCancellation;
        private PrintDocumentAdapter mDocumentAdapter;
        private Handler mHandler;
        private LayoutSpec mLastLayoutSpec;
        private WriteSpec mLastWriteSpec;
        private boolean mStartReqeusted;
        private boolean mStarted;
        private boolean mFinishRequested;
        private boolean mFinished;

        public PrintDocumentAdapterDelegate(PrintDocumentAdapter documentAdapter, Looper looper) {
            this.mDocumentAdapter = documentAdapter;
            this.mHandler = new MyHandler(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mStartReqeusted || this.mFinishRequested) {
                    return;
                }
                this.mStartReqeusted = true;
                this.doPendingWorkLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layout(PrintAttributes oldAttributes, PrintAttributes newAttributes, ILayoutResultCallback callback, Bundle metadata, int sequence) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mStartReqeusted || this.mFinishRequested) {
                    return;
                }
                if (this.mLastWriteSpec != null) {
                    IoUtils.closeQuietly(this.mLastWriteSpec.fd);
                    this.mLastWriteSpec = null;
                }
                this.mLastLayoutSpec = new LayoutSpec();
                this.mLastLayoutSpec.callback = callback;
                this.mLastLayoutSpec.oldAttributes = oldAttributes;
                this.mLastLayoutSpec.newAttributes = newAttributes;
                this.mLastLayoutSpec.metadata = metadata;
                this.mLastLayoutSpec.sequence = sequence;
                if (this.cancelPreviousCancellableOperationLocked()) {
                    return;
                }
                this.doPendingWorkLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(PageRange[] pages, ParcelFileDescriptor fd, IWriteResultCallback callback, int sequence) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mStartReqeusted || this.mFinishRequested) {
                    return;
                }
                if (this.mLastWriteSpec != null) {
                    IoUtils.closeQuietly(this.mLastWriteSpec.fd);
                    this.mLastWriteSpec = null;
                }
                this.mLastWriteSpec = new WriteSpec();
                this.mLastWriteSpec.callback = callback;
                this.mLastWriteSpec.pages = pages;
                this.mLastWriteSpec.fd = fd;
                this.mLastWriteSpec.sequence = sequence;
                if (this.cancelPreviousCancellableOperationLocked()) {
                    return;
                }
                this.doPendingWorkLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mStartReqeusted || this.mFinishRequested) {
                    return;
                }
                this.mFinishRequested = true;
                if (this.mLastLayoutSpec != null || this.mLastWriteSpec != null) {
                    return;
                }
                this.doPendingWorkLocked();
            }
        }

        private boolean isFinished() {
            return this.mDocumentAdapter == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFinish() {
            this.mDocumentAdapter = null;
            this.mHandler = null;
            Object object = this.mLock;
            synchronized (object) {
                this.mLayoutOrWriteCancellation = null;
            }
        }

        private boolean cancelPreviousCancellableOperationLocked() {
            if (this.mLayoutOrWriteCancellation != null) {
                this.mLayoutOrWriteCancellation.cancel();
                return true;
            }
            return false;
        }

        private void doPendingWorkLocked() {
            if (this.mStartReqeusted && !this.mStarted) {
                this.mStarted = true;
                this.mHandler.sendEmptyMessage(1);
            } else if (this.mLastLayoutSpec != null) {
                this.mHandler.sendEmptyMessage(2);
            } else if (this.mLastWriteSpec != null) {
                this.mHandler.sendEmptyMessage(3);
            } else if (this.mFinishRequested && !this.mFinished) {
                this.mFinished = true;
                this.mHandler.sendEmptyMessage(4);
            }
        }

        private final class MyWriteResultCallback
        extends PrintDocumentAdapter.WriteResultCallback {
            private ParcelFileDescriptor mFd;
            private int mSequence;
            private IWriteResultCallback mCallback;

            public MyWriteResultCallback(IWriteResultCallback callback, ParcelFileDescriptor fd, int sequence) {
                this.mFd = fd;
                this.mSequence = sequence;
                this.mCallback = callback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onWriteFinished(PageRange[] pages) {
                IWriteResultCallback callback;
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    callback = this.mCallback;
                    this.clearLocked();
                }
                if (pages == null) {
                    throw new IllegalArgumentException("pages cannot be null");
                }
                if (pages.length == 0) {
                    throw new IllegalArgumentException("pages cannot be empty");
                }
                if (callback != null) {
                    try {
                        callback.onWriteFinished(pages, this.mSequence);
                    }
                    catch (RemoteException re) {
                        Log.e(PrintManager.LOG_TAG, "Error calling onWriteFinished", re);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onWriteFailed(CharSequence error) {
                IWriteResultCallback callback;
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    callback = this.mCallback;
                    this.clearLocked();
                }
                if (callback != null) {
                    try {
                        callback.onWriteFailed(error, this.mSequence);
                    }
                    catch (RemoteException re) {
                        Log.e(PrintManager.LOG_TAG, "Error calling onWriteFailed", re);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onWriteCancelled() {
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    this.clearLocked();
                }
            }

            private void clearLocked() {
                PrintDocumentAdapterDelegate.this.mLayoutOrWriteCancellation = null;
                IoUtils.closeQuietly(this.mFd);
                this.mCallback = null;
                this.mFd = null;
                PrintDocumentAdapterDelegate.this.doPendingWorkLocked();
            }
        }

        private final class MyLayoutResultCallback
        extends PrintDocumentAdapter.LayoutResultCallback {
            private ILayoutResultCallback mCallback;
            private final int mSequence;

            public MyLayoutResultCallback(ILayoutResultCallback callback, int sequence) {
                this.mCallback = callback;
                this.mSequence = sequence;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLayoutFinished(PrintDocumentInfo info, boolean changed) {
                ILayoutResultCallback callback;
                if (info == null) {
                    throw new NullPointerException("document info cannot be null");
                }
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    callback = this.mCallback;
                    this.clearLocked();
                }
                if (callback != null) {
                    try {
                        callback.onLayoutFinished(info, changed, this.mSequence);
                    }
                    catch (RemoteException re) {
                        Log.e(PrintManager.LOG_TAG, "Error calling onLayoutFinished", re);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLayoutFailed(CharSequence error) {
                ILayoutResultCallback callback;
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    callback = this.mCallback;
                    this.clearLocked();
                }
                if (callback != null) {
                    try {
                        callback.onLayoutFailed(error, this.mSequence);
                    }
                    catch (RemoteException re) {
                        Log.e(PrintManager.LOG_TAG, "Error calling onLayoutFailed", re);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLayoutCancelled() {
                Object object = PrintDocumentAdapterDelegate.this.mLock;
                synchronized (object) {
                    this.clearLocked();
                }
            }

            private void clearLocked() {
                PrintDocumentAdapterDelegate.this.mLayoutOrWriteCancellation = null;
                this.mCallback = null;
                PrintDocumentAdapterDelegate.this.doPendingWorkLocked();
            }
        }

        private final class MyHandler
        extends Handler {
            public static final int MSG_START = 1;
            public static final int MSG_LAYOUT = 2;
            public static final int MSG_WRITE = 3;
            public static final int MSG_FINISH = 4;

            public MyHandler(Looper looper) {
                super(looper, null, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message message) {
                if (PrintDocumentAdapterDelegate.this.isFinished()) {
                    return;
                }
                switch (message.what) {
                    case 1: {
                        PrintDocumentAdapterDelegate.this.mDocumentAdapter.onStart();
                        break;
                    }
                    case 2: {
                        CancellationSignal cancellation;
                        LayoutSpec layoutSpec;
                        Object object = PrintDocumentAdapterDelegate.this.mLock;
                        synchronized (object) {
                            layoutSpec = PrintDocumentAdapterDelegate.this.mLastLayoutSpec;
                            PrintDocumentAdapterDelegate.this.mLastLayoutSpec = null;
                            cancellation = new CancellationSignal();
                            PrintDocumentAdapterDelegate.this.mLayoutOrWriteCancellation = cancellation;
                        }
                        if (layoutSpec == null) break;
                        PrintDocumentAdapterDelegate.this.mDocumentAdapter.onLayout(layoutSpec.oldAttributes, layoutSpec.newAttributes, cancellation, new MyLayoutResultCallback(layoutSpec.callback, layoutSpec.sequence), layoutSpec.metadata);
                        break;
                    }
                    case 3: {
                        CancellationSignal cancellation;
                        WriteSpec writeSpec;
                        Object object = PrintDocumentAdapterDelegate.this.mLock;
                        synchronized (object) {
                            writeSpec = PrintDocumentAdapterDelegate.this.mLastWriteSpec;
                            PrintDocumentAdapterDelegate.this.mLastWriteSpec = null;
                            cancellation = new CancellationSignal();
                            PrintDocumentAdapterDelegate.this.mLayoutOrWriteCancellation = cancellation;
                        }
                        if (writeSpec == null) break;
                        PrintDocumentAdapterDelegate.this.mDocumentAdapter.onWrite(writeSpec.pages, writeSpec.fd, cancellation, new MyWriteResultCallback(writeSpec.callback, writeSpec.fd, writeSpec.sequence));
                        break;
                    }
                    case 4: {
                        PrintDocumentAdapterDelegate.this.mDocumentAdapter.onFinish();
                        PrintDocumentAdapterDelegate.this.doFinish();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown message: " + message.what);
                    }
                }
            }
        }

        private class WriteSpec {
            IWriteResultCallback callback;
            PageRange[] pages;
            ParcelFileDescriptor fd;
            int sequence;

            private WriteSpec() {
            }
        }

        private class LayoutSpec {
            ILayoutResultCallback callback;
            PrintAttributes oldAttributes;
            PrintAttributes newAttributes;
            Bundle metadata;
            int sequence;

            private LayoutSpec() {
            }
        }
    }

    public static interface PrintJobStateChangeListener {
        public void onPrintJobStateChanged(PrintJobId var1);
    }
}

