/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.INotificationManager;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.notification.INotificationListener;
import android.service.notification.StatusBarNotification;
import android.util.Log;

public abstract class NotificationListenerService
extends Service {
    private final String TAG = NotificationListenerService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
    private INotificationListenerWrapper mWrapper = null;
    private INotificationManager mNoMan;
    public static final String SERVICE_INTERFACE = "android.service.notification.NotificationListenerService";

    public abstract void onNotificationPosted(StatusBarNotification var1);

    public abstract void onNotificationRemoved(StatusBarNotification var1);

    private final INotificationManager getNotificationInterface() {
        if (this.mNoMan == null) {
            this.mNoMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        }
        return this.mNoMan;
    }

    public final void cancelNotification(String pkg, String tag, int id2) {
        try {
            this.getNotificationInterface().cancelNotificationFromListener(this.mWrapper, pkg, tag, id2);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public final void cancelAllNotifications() {
        try {
            this.getNotificationInterface().cancelAllNotificationsFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    public StatusBarNotification[] getActiveNotifications() {
        try {
            return this.getNotificationInterface().getActiveNotificationsFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return null;
        }
    }

    public IBinder onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new INotificationListenerWrapper();
        }
        return this.mWrapper;
    }

    private class INotificationListenerWrapper
    extends INotificationListener.Stub {
        private INotificationListenerWrapper() {
        }

        public void onNotificationPosted(StatusBarNotification sbn) {
            try {
                NotificationListenerService.this.onNotificationPosted(sbn);
            }
            catch (Throwable t) {
                Log.w(NotificationListenerService.this.TAG, "Error running onNotificationPosted", t);
            }
        }

        public void onNotificationRemoved(StatusBarNotification sbn) {
            try {
                NotificationListenerService.this.onNotificationRemoved(sbn);
            }
            catch (Throwable t) {
                Log.w(NotificationListenerService.this.TAG, "Error running onNotificationRemoved", t);
            }
        }
    }
}

