/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.app.Service;
import android.content.Intent;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.provider.Settings;
import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.AudioPlaybackHandler;
import android.speech.tts.AudioPlaybackQueueItem;
import android.speech.tts.EventLogger;
import android.speech.tts.FileSynthesisCallback;
import android.speech.tts.ITextToSpeechCallback;
import android.speech.tts.ITextToSpeechService;
import android.speech.tts.PlaybackSynthesisCallback;
import android.speech.tts.SilencePlaybackQueueItem;
import android.speech.tts.SynthesisCallback;
import android.speech.tts.SynthesisRequest;
import android.speech.tts.TextToSpeech;
import android.speech.tts.TtsEngines;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextToSpeechService
extends Service {
    private static final boolean DBG = false;
    private static final String TAG = "TextToSpeechService";
    private static final String SYNTH_THREAD_NAME = "SynthThread";
    private SynthHandler mSynthHandler;
    private AudioPlaybackHandler mAudioPlaybackHandler;
    private TtsEngines mEngineHelper;
    private CallbackMap mCallbacks;
    private String mPackageName;
    private final ITextToSpeechService.Stub mBinder = new ITextToSpeechService.Stub(){

        public int speak(IBinder caller, String text, int queueMode, Bundle params) {
            if (!this.checkNonNull(caller, text, params)) {
                return -1;
            }
            SynthesisSpeechItem item = new SynthesisSpeechItem(caller, Binder.getCallingUid(), Binder.getCallingPid(), params, text);
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(queueMode, item);
        }

        public int synthesizeToFileDescriptor(IBinder caller, String text, ParcelFileDescriptor fileDescriptor, Bundle params) {
            if (!this.checkNonNull(caller, text, fileDescriptor, params)) {
                return -1;
            }
            ParcelFileDescriptor sameFileDescriptor = ParcelFileDescriptor.adoptFd(fileDescriptor.detachFd());
            SynthesisToFileOutputStreamSpeechItem item = new SynthesisToFileOutputStreamSpeechItem(caller, Binder.getCallingUid(), Binder.getCallingPid(), params, text, new ParcelFileDescriptor.AutoCloseOutputStream(sameFileDescriptor));
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(1, item);
        }

        public int playAudio(IBinder caller, Uri audioUri, int queueMode, Bundle params) {
            if (!this.checkNonNull(caller, audioUri, params)) {
                return -1;
            }
            AudioSpeechItem item = new AudioSpeechItem(caller, Binder.getCallingUid(), Binder.getCallingPid(), params, audioUri);
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(queueMode, item);
        }

        public int playSilence(IBinder caller, long duration, int queueMode, Bundle params) {
            if (!this.checkNonNull(caller, params)) {
                return -1;
            }
            SilenceSpeechItem item = new SilenceSpeechItem(caller, Binder.getCallingUid(), Binder.getCallingPid(), params, duration);
            return TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(queueMode, item);
        }

        public boolean isSpeaking() {
            return TextToSpeechService.this.mSynthHandler.isSpeaking() || TextToSpeechService.this.mAudioPlaybackHandler.isSpeaking();
        }

        public int stop(IBinder caller) {
            if (!this.checkNonNull(caller)) {
                return -1;
            }
            return TextToSpeechService.this.mSynthHandler.stopForApp(caller);
        }

        public String[] getLanguage() {
            return TextToSpeechService.this.onGetLanguage();
        }

        public String[] getClientDefaultLanguage() {
            return TextToSpeechService.this.getSettingsLocale();
        }

        public int isLanguageAvailable(String lang, String country, String variant) {
            if (!this.checkNonNull(lang)) {
                return -1;
            }
            return TextToSpeechService.this.onIsLanguageAvailable(lang, country, variant);
        }

        public String[] getFeaturesForLanguage(String lang, String country, String variant) {
            Set<String> features = TextToSpeechService.this.onGetFeaturesForLanguage(lang, country, variant);
            String[] featuresArray = null;
            if (features != null) {
                featuresArray = new String[features.size()];
                features.toArray(featuresArray);
            } else {
                featuresArray = new String[]{};
            }
            return featuresArray;
        }

        public int loadLanguage(IBinder caller, String lang, String country, String variant) {
            if (!this.checkNonNull(lang)) {
                return -1;
            }
            int retVal = TextToSpeechService.this.onIsLanguageAvailable(lang, country, variant);
            if (retVal == 0 || retVal == 1 || retVal == 2) {
                LoadLanguageItem item = new LoadLanguageItem(caller, Binder.getCallingUid(), Binder.getCallingPid(), null, lang, country, variant);
                if (TextToSpeechService.this.mSynthHandler.enqueueSpeechItem(1, item) != 0) {
                    return -1;
                }
            }
            return retVal;
        }

        public void setCallback(IBinder caller, ITextToSpeechCallback cb) {
            if (!this.checkNonNull(caller)) {
                return;
            }
            TextToSpeechService.this.mCallbacks.setCallback(caller, cb);
        }

        private String intern(String in) {
            return in.intern();
        }

        private boolean checkNonNull(Object ... args) {
            for (Object o : args) {
                if (o != null) continue;
                return false;
            }
            return true;
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        SynthThread synthThread = new SynthThread();
        synthThread.start();
        this.mSynthHandler = new SynthHandler(synthThread.getLooper());
        this.mAudioPlaybackHandler = new AudioPlaybackHandler();
        this.mAudioPlaybackHandler.start();
        this.mEngineHelper = new TtsEngines(this);
        this.mCallbacks = new CallbackMap();
        this.mPackageName = this.getApplicationInfo().packageName;
        String[] defaultLocale = this.getSettingsLocale();
        this.onLoadLanguage(defaultLocale[0], defaultLocale[1], defaultLocale[2]);
    }

    @Override
    public void onDestroy() {
        this.mSynthHandler.quit();
        this.mAudioPlaybackHandler.quit();
        this.mCallbacks.kill();
        super.onDestroy();
    }

    protected abstract int onIsLanguageAvailable(String var1, String var2, String var3);

    protected abstract String[] onGetLanguage();

    protected abstract int onLoadLanguage(String var1, String var2, String var3);

    protected abstract void onStop();

    protected abstract void onSynthesizeText(SynthesisRequest var1, SynthesisCallback var2);

    protected Set<String> onGetFeaturesForLanguage(String lang, String country, String variant) {
        return null;
    }

    private int getDefaultSpeechRate() {
        return this.getSecureSettingInt("tts_default_rate", 100);
    }

    private String[] getSettingsLocale() {
        String locale = this.mEngineHelper.getLocalePrefForEngine(this.mPackageName);
        return TtsEngines.parseLocalePref(locale);
    }

    private int getSecureSettingInt(String name, int defaultValue) {
        return Settings.Secure.getInt(this.getContentResolver(), name, defaultValue);
    }

    @Override
    public IBinder onBind(Intent intent) {
        if ("android.intent.action.TTS_SERVICE".equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallbackMap
    extends RemoteCallbackList<ITextToSpeechCallback> {
        private final HashMap<IBinder, ITextToSpeechCallback> mCallerToCallback = new HashMap();

        private CallbackMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCallback(IBinder caller, ITextToSpeechCallback cb) {
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                ITextToSpeechCallback old;
                if (cb != null) {
                    this.register(cb, caller);
                    old = this.mCallerToCallback.put(caller, cb);
                } else {
                    old = this.mCallerToCallback.remove(caller);
                }
                if (old != null && old != cb) {
                    this.unregister(old);
                }
            }
        }

        public void dispatchOnDone(Object callerIdentity, String utteranceId) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onDone(utteranceId);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback onDone failed: " + e);
            }
        }

        public void dispatchOnStart(Object callerIdentity, String utteranceId) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onStart(utteranceId);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback onStart failed: " + e);
            }
        }

        public void dispatchOnError(Object callerIdentity, String utteranceId) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onError(utteranceId);
            }
            catch (RemoteException e) {
                Log.e(TextToSpeechService.TAG, "Callback onError failed: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallbackDied(ITextToSpeechCallback callback, Object cookie) {
            IBinder caller = (IBinder)cookie;
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                this.mCallerToCallback.remove(caller);
            }
            TextToSpeechService.this.mSynthHandler.stopForApp(caller);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void kill() {
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                this.mCallerToCallback.clear();
                super.kill();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ITextToSpeechCallback getCallbackFor(Object caller) {
            ITextToSpeechCallback cb;
            IBinder asBinder = (IBinder)caller;
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                cb = this.mCallerToCallback.get(asBinder);
            }
            return cb;
        }
    }

    private class LoadLanguageItem
    extends SpeechItem {
        private final String mLanguage;
        private final String mCountry;
        private final String mVariant;

        public LoadLanguageItem(Object callerIdentity, int callerUid, int callerPid, Bundle params, String language, String country, String variant) {
            super(callerIdentity, callerUid, callerPid, params);
            this.mLanguage = language;
            this.mCountry = country;
            this.mVariant = variant;
        }

        public boolean isValid() {
            return true;
        }

        protected int playImpl() {
            int result = TextToSpeechService.this.onLoadLanguage(this.mLanguage, this.mCountry, this.mVariant);
            if (result == 0 || result == 1 || result == 2) {
                return 0;
            }
            return -1;
        }

        protected void stopImpl() {
        }
    }

    private class SilenceSpeechItem
    extends UtteranceSpeechItem {
        private final long mDuration;

        public SilenceSpeechItem(Object callerIdentity, int callerUid, int callerPid, Bundle params, long duration) {
            super(callerIdentity, callerUid, callerPid, params);
            this.mDuration = duration;
        }

        public boolean isValid() {
            return true;
        }

        protected int playImpl() {
            TextToSpeechService.this.mAudioPlaybackHandler.enqueue(new SilencePlaybackQueueItem(this, this.getCallerIdentity(), this.mDuration));
            return 0;
        }

        protected void stopImpl() {
        }
    }

    private class AudioSpeechItem
    extends UtteranceSpeechItem {
        private final AudioPlaybackQueueItem mItem;

        public AudioSpeechItem(Object callerIdentity, int callerUid, int callerPid, Bundle params, Uri uri) {
            super(callerIdentity, callerUid, callerPid, params);
            this.mItem = new AudioPlaybackQueueItem(this, this.getCallerIdentity(), TextToSpeechService.this, uri, this.getStreamType());
        }

        public boolean isValid() {
            return true;
        }

        protected int playImpl() {
            TextToSpeechService.this.mAudioPlaybackHandler.enqueue(this.mItem);
            return 0;
        }

        protected void stopImpl() {
        }
    }

    private class SynthesisToFileOutputStreamSpeechItem
    extends SynthesisSpeechItem {
        private final FileOutputStream mFileOutputStream;

        public SynthesisToFileOutputStreamSpeechItem(Object callerIdentity, int callerUid, int callerPid, Bundle params, String text, FileOutputStream fileOutputStream) {
            super(callerIdentity, callerUid, callerPid, params, text);
            this.mFileOutputStream = fileOutputStream;
        }

        protected AbstractSynthesisCallback createSynthesisCallback() {
            return new FileSynthesisCallback(this.mFileOutputStream.getChannel());
        }

        protected int playImpl() {
            this.dispatchOnStart();
            int status = super.playImpl();
            if (status == 0) {
                this.dispatchOnDone();
            } else {
                this.dispatchOnError();
            }
            try {
                this.mFileOutputStream.close();
            }
            catch (IOException e) {
                Log.w(TextToSpeechService.TAG, "Failed to close output file", e);
            }
            return status;
        }
    }

    class SynthesisSpeechItem
    extends UtteranceSpeechItem {
        private final String mText;
        private final SynthesisRequest mSynthesisRequest;
        private final String[] mDefaultLocale;
        private AbstractSynthesisCallback mSynthesisCallback;
        private final EventLogger mEventLogger;
        private final int mCallerUid;

        public SynthesisSpeechItem(Object callerIdentity, int callerUid, int callerPid, Bundle params, String text) {
            super(callerIdentity, callerUid, callerPid, params);
            this.mText = text;
            this.mCallerUid = callerUid;
            this.mSynthesisRequest = new SynthesisRequest(this.mText, this.mParams);
            this.mDefaultLocale = TextToSpeechService.this.getSettingsLocale();
            this.setRequestParams(this.mSynthesisRequest);
            this.mEventLogger = new EventLogger(this.mSynthesisRequest, callerUid, callerPid, TextToSpeechService.this.mPackageName);
        }

        public String getText() {
            return this.mText;
        }

        public boolean isValid() {
            if (this.mText == null) {
                Log.e(TextToSpeechService.TAG, "null synthesis text");
                return false;
            }
            if (this.mText.length() >= TextToSpeech.getMaxSpeechInputLength()) {
                Log.w(TextToSpeechService.TAG, "Text too long: " + this.mText.length() + " chars");
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int playImpl() {
            AbstractSynthesisCallback synthesisCallback;
            this.mEventLogger.onRequestProcessingStart();
            SynthesisSpeechItem synthesisSpeechItem = this;
            synchronized (synthesisSpeechItem) {
                if (this.isStopped()) {
                    return -1;
                }
                synthesisCallback = this.mSynthesisCallback = this.createSynthesisCallback();
            }
            TextToSpeechService.this.onSynthesizeText(this.mSynthesisRequest, synthesisCallback);
            return synthesisCallback.isDone() ? 0 : -1;
        }

        protected AbstractSynthesisCallback createSynthesisCallback() {
            return new PlaybackSynthesisCallback(this.getStreamType(), this.getVolume(), this.getPan(), TextToSpeechService.this.mAudioPlaybackHandler, this, this.getCallerIdentity(), this.mEventLogger);
        }

        private void setRequestParams(SynthesisRequest request) {
            request.setLanguage(this.getLanguage(), this.getCountry(), this.getVariant());
            request.setSpeechRate(this.getSpeechRate());
            request.setCallerUid(this.mCallerUid);
            request.setPitch(this.getPitch());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopImpl() {
            AbstractSynthesisCallback synthesisCallback;
            SynthesisSpeechItem synthesisSpeechItem = this;
            synchronized (synthesisSpeechItem) {
                synthesisCallback = this.mSynthesisCallback;
            }
            if (synthesisCallback != null) {
                synthesisCallback.stop();
                TextToSpeechService.this.onStop();
            }
        }

        public String getLanguage() {
            return this.getStringParam("language", this.mDefaultLocale[0]);
        }

        private boolean hasLanguage() {
            return !TextUtils.isEmpty(this.getStringParam("language", null));
        }

        private String getCountry() {
            if (!this.hasLanguage()) {
                return this.mDefaultLocale[1];
            }
            return this.getStringParam("country", "");
        }

        private String getVariant() {
            if (!this.hasLanguage()) {
                return this.mDefaultLocale[2];
            }
            return this.getStringParam("variant", "");
        }

        private int getSpeechRate() {
            return this.getIntParam("rate", TextToSpeechService.this.getDefaultSpeechRate());
        }

        private int getPitch() {
            return this.getIntParam("pitch", 100);
        }
    }

    private abstract class UtteranceSpeechItem
    extends SpeechItem
    implements UtteranceProgressDispatcher {
        public UtteranceSpeechItem(Object caller, int callerUid, int callerPid, Bundle params) {
            super(caller, callerUid, callerPid, params);
        }

        public void dispatchOnDone() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnDone(this.getCallerIdentity(), utteranceId);
            }
        }

        public void dispatchOnStart() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnStart(this.getCallerIdentity(), utteranceId);
            }
        }

        public void dispatchOnError() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                TextToSpeechService.this.mCallbacks.dispatchOnError(this.getCallerIdentity(), utteranceId);
            }
        }

        public int getStreamType() {
            return this.getIntParam("streamType", 3);
        }

        public float getVolume() {
            return this.getFloatParam("volume", 1.0f);
        }

        public float getPan() {
            return this.getFloatParam("pan", 0.0f);
        }

        public String getUtteranceId() {
            return this.getStringParam("utteranceId", null);
        }

        protected String getStringParam(String key, String defaultValue) {
            return this.mParams == null ? defaultValue : this.mParams.getString(key, defaultValue);
        }

        protected int getIntParam(String key, int defaultValue) {
            return this.mParams == null ? defaultValue : this.mParams.getInt(key, defaultValue);
        }

        protected float getFloatParam(String key, float defaultValue) {
            return this.mParams == null ? defaultValue : this.mParams.getFloat(key, defaultValue);
        }
    }

    private abstract class SpeechItem {
        private final Object mCallerIdentity;
        protected final Bundle mParams;
        private final int mCallerUid;
        private final int mCallerPid;
        private boolean mStarted = false;
        private boolean mStopped = false;

        public SpeechItem(Object caller, int callerUid, int callerPid, Bundle params) {
            this.mCallerIdentity = caller;
            this.mParams = params;
            this.mCallerUid = callerUid;
            this.mCallerPid = callerPid;
        }

        public Object getCallerIdentity() {
            return this.mCallerIdentity;
        }

        public int getCallerUid() {
            return this.mCallerUid;
        }

        public int getCallerPid() {
            return this.mCallerPid;
        }

        public abstract boolean isValid();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int play() {
            SpeechItem speechItem = this;
            synchronized (speechItem) {
                if (this.mStarted) {
                    throw new IllegalStateException("play() called twice");
                }
                this.mStarted = true;
            }
            return this.playImpl();
        }

        protected abstract int playImpl();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            SpeechItem speechItem = this;
            synchronized (speechItem) {
                if (this.mStopped) {
                    throw new IllegalStateException("stop() called twice");
                }
                this.mStopped = true;
            }
            this.stopImpl();
        }

        protected abstract void stopImpl();

        protected synchronized boolean isStopped() {
            return this.mStopped;
        }
    }

    static interface UtteranceProgressDispatcher {
        public void dispatchOnDone();

        public void dispatchOnStart();

        public void dispatchOnError();
    }

    private class SynthHandler
    extends Handler {
        private SpeechItem mCurrentSpeechItem;

        public SynthHandler(Looper looper) {
            super(looper);
            this.mCurrentSpeechItem = null;
        }

        private synchronized SpeechItem getCurrentSpeechItem() {
            return this.mCurrentSpeechItem;
        }

        private synchronized SpeechItem setCurrentSpeechItem(SpeechItem speechItem) {
            SpeechItem old = this.mCurrentSpeechItem;
            this.mCurrentSpeechItem = speechItem;
            return old;
        }

        private synchronized SpeechItem maybeRemoveCurrentSpeechItem(Object callerIdentity) {
            if (this.mCurrentSpeechItem != null && this.mCurrentSpeechItem.getCallerIdentity() == callerIdentity) {
                SpeechItem current = this.mCurrentSpeechItem;
                this.mCurrentSpeechItem = null;
                return current;
            }
            return null;
        }

        public boolean isSpeaking() {
            return this.getCurrentSpeechItem() != null;
        }

        public void quit() {
            this.getLooper().quit();
            SpeechItem current = this.setCurrentSpeechItem(null);
            if (current != null) {
                current.stop();
            }
        }

        public int enqueueSpeechItem(int queueMode, final SpeechItem speechItem) {
            UtteranceProgressDispatcher utterenceProgress = null;
            if (speechItem instanceof UtteranceProgressDispatcher) {
                utterenceProgress = (UtteranceProgressDispatcher)((Object)speechItem);
            }
            if (!speechItem.isValid()) {
                if (utterenceProgress != null) {
                    utterenceProgress.dispatchOnError();
                }
                return -1;
            }
            if (queueMode == 0) {
                this.stopForApp(speechItem.getCallerIdentity());
            } else if (queueMode == 2) {
                this.stopAll();
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    SynthHandler.this.setCurrentSpeechItem(speechItem);
                    speechItem.play();
                    SynthHandler.this.setCurrentSpeechItem(null);
                }
            };
            Message msg = Message.obtain((Handler)this, runnable);
            msg.obj = speechItem.getCallerIdentity();
            if (this.sendMessage(msg)) {
                return 0;
            }
            Log.w(TextToSpeechService.TAG, "SynthThread has quit");
            if (utterenceProgress != null) {
                utterenceProgress.dispatchOnError();
            }
            return -1;
        }

        public int stopForApp(Object callerIdentity) {
            if (callerIdentity == null) {
                return -1;
            }
            this.removeCallbacksAndMessages(callerIdentity);
            SpeechItem current = this.maybeRemoveCurrentSpeechItem(callerIdentity);
            if (current != null) {
                current.stop();
            }
            TextToSpeechService.this.mAudioPlaybackHandler.stopForApp(callerIdentity);
            return 0;
        }

        public int stopAll() {
            SpeechItem current = this.setCurrentSpeechItem(null);
            if (current != null) {
                current.stop();
            }
            this.removeCallbacksAndMessages(null);
            TextToSpeechService.this.mAudioPlaybackHandler.stop();
            return 0;
        }
    }

    private class SynthThread
    extends HandlerThread
    implements MessageQueue.IdleHandler {
        private boolean mFirstIdle;

        public SynthThread() {
            super(TextToSpeechService.SYNTH_THREAD_NAME, 0);
            this.mFirstIdle = true;
        }

        protected void onLooperPrepared() {
            this.getLooper().getQueue().addIdleHandler(this);
        }

        public boolean queueIdle() {
            if (this.mFirstIdle) {
                this.mFirstIdle = false;
            } else {
                this.broadcastTtsQueueProcessingCompleted();
            }
            return true;
        }

        private void broadcastTtsQueueProcessingCompleted() {
            Intent i = new Intent("android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED");
            TextToSpeechService.this.sendBroadcast(i);
        }
    }
}

