/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.Spannable;
import android.text.method.BaseMovementMethod;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.MotionEvent;
import android.widget.TextView;

public class ScrollingMovementMethod
extends BaseMovementMethod
implements MovementMethod {
    private static ScrollingMovementMethod sInstance;

    protected boolean left(TextView widget, Spannable buffer) {
        return this.scrollLeft(widget, buffer, 1);
    }

    protected boolean right(TextView widget, Spannable buffer) {
        return this.scrollRight(widget, buffer, 1);
    }

    protected boolean up(TextView widget, Spannable buffer) {
        return this.scrollUp(widget, buffer, 1);
    }

    protected boolean down(TextView widget, Spannable buffer) {
        return this.scrollDown(widget, buffer, 1);
    }

    protected boolean pageUp(TextView widget, Spannable buffer) {
        return this.scrollPageUp(widget, buffer);
    }

    protected boolean pageDown(TextView widget, Spannable buffer) {
        return this.scrollPageDown(widget, buffer);
    }

    protected boolean top(TextView widget, Spannable buffer) {
        return this.scrollTop(widget, buffer);
    }

    protected boolean bottom(TextView widget, Spannable buffer) {
        return this.scrollBottom(widget, buffer);
    }

    protected boolean lineStart(TextView widget, Spannable buffer) {
        return this.scrollLineStart(widget, buffer);
    }

    protected boolean lineEnd(TextView widget, Spannable buffer) {
        return this.scrollLineEnd(widget, buffer);
    }

    protected boolean home(TextView widget, Spannable buffer) {
        return this.top(widget, buffer);
    }

    protected boolean end(TextView widget, Spannable buffer) {
        return this.bottom(widget, buffer);
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        return Touch.onTouchEvent(widget, buffer, event);
    }

    public void onTakeFocus(TextView widget, Spannable text, int dir) {
        Layout layout2 = widget.getLayout();
        if (layout2 != null && (dir & 2) != 0) {
            widget.scrollTo(widget.getScrollX(), layout2.getLineTop(0));
        }
        if (layout2 != null && (dir & 1) != 0) {
            int padding = widget.getTotalPaddingTop() + widget.getTotalPaddingBottom();
            int line = layout2.getLineCount() - 1;
            widget.scrollTo(widget.getScrollX(), layout2.getLineTop(line + 1) - (widget.getHeight() - padding));
        }
    }

    public static MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new ScrollingMovementMethod();
        }
        return sInstance;
    }
}

