/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import android.view.IWindow;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessibilityManager {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManager";
    public static final int STATE_FLAG_ACCESSIBILITY_ENABLED = 1;
    public static final int STATE_FLAG_TOUCH_EXPLORATION_ENABLED = 2;
    static final Object sInstanceSync = new Object();
    private static AccessibilityManager sInstance;
    private static final int DO_SET_STATE = 10;
    final IAccessibilityManager mService;
    final int mUserId;
    final Handler mHandler;
    boolean mIsEnabled;
    boolean mIsTouchExplorationEnabled;
    private final CopyOnWriteArrayList<AccessibilityStateChangeListener> mAccessibilityStateChangeListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TouchExplorationStateChangeListener> mTouchExplorationStateChangeListeners = new CopyOnWriteArrayList();
    final IAccessibilityManagerClient.Stub mClient = new IAccessibilityManagerClient.Stub(){

        public void setState(int state) {
            AccessibilityManager.this.mHandler.obtainMessage(10, state, 0).sendToTarget();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityManager getInstance(Context context) {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                int userId = Binder.getCallingUid() == 1000 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS") == 0 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0 ? -2 : UserHandle.myUserId();
                IBinder iBinder = ServiceManager.getService("accessibility");
                IAccessibilityManager service = IAccessibilityManager.Stub.asInterface(iBinder);
                sInstance = new AccessibilityManager(context, service, userId);
            }
        }
        return sInstance;
    }

    public AccessibilityManager(Context context, IAccessibilityManager service, int userId) {
        this.mHandler = new MyHandler(context.getMainLooper());
        this.mService = service;
        this.mUserId = userId;
        try {
            int stateFlags = this.mService.addClient(this.mClient, userId);
            this.setState(stateFlags);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "AccessibilityManagerService is dead", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Handler handler = this.mHandler;
        synchronized (handler) {
            return this.mIsEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTouchExplorationEnabled() {
        Handler handler = this.mHandler;
        synchronized (handler) {
            return this.mIsTouchExplorationEnabled;
        }
    }

    public IAccessibilityManagerClient getClient() {
        return (IAccessibilityManagerClient)((Object)this.mClient.asBinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAccessibilityEvent(AccessibilityEvent event) {
        if (!this.mIsEnabled) {
            throw new IllegalStateException("Accessibility off. Did you forget to check that?");
        }
        boolean doRecycle = false;
        try {
            event.setEventTime(SystemClock.uptimeMillis());
            long identityToken = Binder.clearCallingIdentity();
            doRecycle = this.mService.sendAccessibilityEvent(event, this.mUserId);
            Binder.restoreCallingIdentity(identityToken);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error during sending " + event + " ", re);
        }
        finally {
            if (doRecycle) {
                event.recycle();
            }
        }
    }

    public void interrupt() {
        if (!this.mIsEnabled) {
            throw new IllegalStateException("Accessibility off. Did you forget to check that?");
        }
        try {
            this.mService.interrupt(this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while requesting interrupt from all services. ", re);
        }
    }

    @Deprecated
    public List<ServiceInfo> getAccessibilityServiceList() {
        List<AccessibilityServiceInfo> infos = this.getInstalledAccessibilityServiceList();
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        int infoCount = infos.size();
        for (int i = 0; i < infoCount; ++i) {
            AccessibilityServiceInfo info = infos.get(i);
            services.add(info.getResolveInfo().serviceInfo);
        }
        return Collections.unmodifiableList(services);
    }

    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        List<AccessibilityServiceInfo> services = null;
        try {
            services = this.mService.getInstalledAccessibilityServiceList(this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", re);
        }
        return Collections.unmodifiableList(services);
    }

    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags) {
        List<AccessibilityServiceInfo> services = null;
        try {
            services = this.mService.getEnabledAccessibilityServiceList(feedbackTypeFlags, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", re);
        }
        return Collections.unmodifiableList(services);
    }

    public boolean addAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        return this.mAccessibilityStateChangeListeners.add(listener);
    }

    public boolean removeAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        return this.mAccessibilityStateChangeListeners.remove(listener);
    }

    public boolean addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        return this.mTouchExplorationStateChangeListeners.add(listener);
    }

    public boolean removeTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        return this.mTouchExplorationStateChangeListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int stateFlags) {
        boolean enabled = (stateFlags & 1) != 0;
        boolean touchExplorationEnabled = (stateFlags & 2) != 0;
        Handler handler = this.mHandler;
        synchronized (handler) {
            boolean wasEnabled = this.mIsEnabled;
            boolean wasTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
            this.mIsEnabled = enabled;
            this.mIsTouchExplorationEnabled = touchExplorationEnabled;
            if (wasEnabled != enabled) {
                this.notifyAccessibilityStateChangedLh();
            }
            if (wasTouchExplorationEnabled != touchExplorationEnabled) {
                this.notifyTouchExplorationStateChangedLh();
            }
        }
    }

    private void notifyAccessibilityStateChangedLh() {
        int listenerCount = this.mAccessibilityStateChangeListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            this.mAccessibilityStateChangeListeners.get(i).onAccessibilityStateChanged(this.mIsEnabled);
        }
    }

    private void notifyTouchExplorationStateChangedLh() {
        int listenerCount = this.mTouchExplorationStateChangeListeners.size();
        for (int i = 0; i < listenerCount; ++i) {
            this.mTouchExplorationStateChangeListeners.get(i).onTouchExplorationStateChanged(this.mIsTouchExplorationEnabled);
        }
    }

    public int addAccessibilityInteractionConnection(IWindow windowToken, IAccessibilityInteractionConnection connection) {
        try {
            return this.mService.addAccessibilityInteractionConnection(windowToken, connection, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while adding an accessibility interaction connection. ", re);
            return -1;
        }
    }

    public void removeAccessibilityInteractionConnection(IWindow windowToken) {
        try {
            this.mService.removeAccessibilityInteractionConnection(windowToken);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while removing an accessibility interaction connection. ", re);
        }
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper mainLooper) {
            super(mainLooper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 10: {
                    AccessibilityManager.this.setState(message.arg1);
                    return;
                }
            }
            Log.w(AccessibilityManager.LOG_TAG, "Unknown message type: " + message.what);
        }
    }

    public static interface TouchExplorationStateChangeListener {
        public void onTouchExplorationStateChanged(boolean var1);
    }

    public static interface AccessibilityStateChangeListener {
        public void onAccessibilityStateChanged(boolean var1);
    }
}

