/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Slog;
import android.view.textservice.SpellCheckerInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpellCheckerSubtype
implements Parcelable {
    private static final String TAG = SpellCheckerSubtype.class.getSimpleName();
    private static final String EXTRA_VALUE_PAIR_SEPARATOR = ",";
    private static final String EXTRA_VALUE_KEY_VALUE_SEPARATOR = "=";
    private final int mSubtypeHashCode;
    private final int mSubtypeNameResId;
    private final String mSubtypeLocale;
    private final String mSubtypeExtraValue;
    private HashMap<String, String> mExtraValueHashMapCache;
    public static final Parcelable.Creator<SpellCheckerSubtype> CREATOR = new Parcelable.Creator<SpellCheckerSubtype>(){

        @Override
        public SpellCheckerSubtype createFromParcel(Parcel source) {
            return new SpellCheckerSubtype(source);
        }

        public SpellCheckerSubtype[] newArray(int size) {
            return new SpellCheckerSubtype[size];
        }
    };

    public SpellCheckerSubtype(int nameId, String locale, String extraValue) {
        this.mSubtypeNameResId = nameId;
        this.mSubtypeLocale = locale != null ? locale : "";
        this.mSubtypeExtraValue = extraValue != null ? extraValue : "";
        this.mSubtypeHashCode = SpellCheckerSubtype.hashCodeInternal(this.mSubtypeLocale, this.mSubtypeExtraValue);
    }

    SpellCheckerSubtype(Parcel source) {
        this.mSubtypeNameResId = source.readInt();
        String s = source.readString();
        this.mSubtypeLocale = s != null ? s : "";
        s = source.readString();
        this.mSubtypeExtraValue = s != null ? s : "";
        this.mSubtypeHashCode = SpellCheckerSubtype.hashCodeInternal(this.mSubtypeLocale, this.mSubtypeExtraValue);
    }

    public int getNameResId() {
        return this.mSubtypeNameResId;
    }

    public String getLocale() {
        return this.mSubtypeLocale;
    }

    public String getExtraValue() {
        return this.mSubtypeExtraValue;
    }

    private HashMap<String, String> getExtraValueHashMap() {
        if (this.mExtraValueHashMapCache == null) {
            this.mExtraValueHashMapCache = new HashMap();
            String[] pairs = this.mSubtypeExtraValue.split(EXTRA_VALUE_PAIR_SEPARATOR);
            int N = pairs.length;
            for (int i = 0; i < N; ++i) {
                String[] pair = pairs[i].split(EXTRA_VALUE_KEY_VALUE_SEPARATOR);
                if (pair.length == 1) {
                    this.mExtraValueHashMapCache.put(pair[0], null);
                    continue;
                }
                if (pair.length <= 1) continue;
                if (pair.length > 2) {
                    Slog.w(TAG, "ExtraValue has two or more '='s");
                }
                this.mExtraValueHashMapCache.put(pair[0], pair[1]);
            }
        }
        return this.mExtraValueHashMapCache;
    }

    public boolean containsExtraValueKey(String key) {
        return this.getExtraValueHashMap().containsKey(key);
    }

    public String getExtraValueOf(String key) {
        return this.getExtraValueHashMap().get(key);
    }

    public int hashCode() {
        return this.mSubtypeHashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof SpellCheckerSubtype) {
            SpellCheckerSubtype subtype = (SpellCheckerSubtype)o;
            return subtype.hashCode() == this.hashCode() && subtype.getNameResId() == this.getNameResId() && subtype.getLocale().equals(this.getLocale()) && subtype.getExtraValue().equals(this.getExtraValue());
        }
        return false;
    }

    public static Locale constructLocaleFromString(String localeStr) {
        if (TextUtils.isEmpty(localeStr)) {
            return null;
        }
        String[] localeParams = localeStr.split("_", 3);
        if (localeParams.length == 1) {
            return new Locale(localeParams[0]);
        }
        if (localeParams.length == 2) {
            return new Locale(localeParams[0], localeParams[1]);
        }
        if (localeParams.length == 3) {
            return new Locale(localeParams[0], localeParams[1], localeParams[2]);
        }
        return null;
    }

    public CharSequence getDisplayName(Context context, String packageName, ApplicationInfo appInfo) {
        String localeStr;
        Locale locale = SpellCheckerSubtype.constructLocaleFromString(this.mSubtypeLocale);
        String string2 = localeStr = locale != null ? locale.getDisplayName() : this.mSubtypeLocale;
        if (this.mSubtypeNameResId == 0) {
            return localeStr;
        }
        CharSequence subtypeName = context.getPackageManager().getText(packageName, this.mSubtypeNameResId, appInfo);
        if (!TextUtils.isEmpty(subtypeName)) {
            return String.format(((Object)subtypeName).toString(), localeStr);
        }
        return localeStr;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeInt(this.mSubtypeNameResId);
        dest.writeString(this.mSubtypeLocale);
        dest.writeString(this.mSubtypeExtraValue);
    }

    private static int hashCodeInternal(String locale, String extraValue) {
        return Arrays.hashCode(new Object[]{locale, extraValue});
    }

    public static List<SpellCheckerSubtype> sort(Context context, int flags, SpellCheckerInfo sci, List<SpellCheckerSubtype> subtypeList) {
        if (sci == null) {
            return subtypeList;
        }
        HashSet<SpellCheckerSubtype> subtypesSet = new HashSet<SpellCheckerSubtype>(subtypeList);
        ArrayList<SpellCheckerSubtype> sortedList = new ArrayList<SpellCheckerSubtype>();
        int N = sci.getSubtypeCount();
        for (int i = 0; i < N; ++i) {
            SpellCheckerSubtype subtype = sci.getSubtypeAt(i);
            if (!subtypesSet.contains(subtype)) continue;
            sortedList.add(subtype);
            subtypesSet.remove(subtype);
        }
        for (SpellCheckerSubtype subtype : subtypesSet) {
            sortedList.add(subtype);
        }
        return sortedList;
    }
}

