/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import com.android.internal.R;

public class TabWidget
extends LinearLayout
implements View.OnFocusChangeListener {
    private OnTabSelectionChanged mSelectionChangedListener;
    private int mSelectedTab = -1;
    private Drawable mLeftStrip;
    private Drawable mRightStrip;
    private boolean mDrawBottomStrips = true;
    private boolean mStripMoved;
    private final Rect mBounds = new Rect();
    private int mImposedTabsHeight = -1;
    private int[] mImposedTabWidths;

    public TabWidget(Context context) {
        this(context, null);
    }

    public TabWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 16842883);
    }

    public TabWidget(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabWidget, defStyle, 0);
        this.setStripEnabled(a.getBoolean(3, true));
        this.setLeftStripDrawable(a.getDrawable(1));
        this.setRightStripDrawable(a.getDrawable(2));
        a.recycle();
        this.initTabWidget();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mStripMoved = true;
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.mSelectedTab == -1) {
            return i;
        }
        if (i == childCount - 1) {
            return this.mSelectedTab;
        }
        if (i >= this.mSelectedTab) {
            return i + 1;
        }
        return i;
    }

    private void initTabWidget() {
        this.setChildrenDrawingOrderEnabled(true);
        Context context = this.mContext;
        Resources resources = context.getResources();
        if (context.getApplicationInfo().targetSdkVersion <= 4) {
            if (this.mLeftStrip == null) {
                this.mLeftStrip = resources.getDrawable(17303056);
            }
            if (this.mRightStrip == null) {
                this.mRightStrip = resources.getDrawable(17303058);
            }
        } else {
            if (this.mLeftStrip == null) {
                this.mLeftStrip = resources.getDrawable(17303055);
            }
            if (this.mRightStrip == null) {
                this.mRightStrip = resources.getDrawable(17303057);
            }
        }
        this.setFocusable(true);
        this.setOnFocusChangeListener(this);
    }

    void measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        if (!this.isMeasureWithLargestChildEnabled() && this.mImposedTabsHeight >= 0) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(totalWidth + this.mImposedTabWidths[childIndex], 0x40000000);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.mImposedTabsHeight, 0x40000000);
        }
        super.measureChildBeforeLayout(child, childIndex, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode(widthMeasureSpec) == 0) {
            super.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int unspecifiedWidth = View.MeasureSpec.makeMeasureSpec(0, 0);
        this.mImposedTabsHeight = -1;
        super.measureHorizontal(unspecifiedWidth, heightMeasureSpec);
        int extraWidth = this.getMeasuredWidth() - View.MeasureSpec.getSize(widthMeasureSpec);
        if (extraWidth > 0) {
            View child;
            int i;
            int count = this.getChildCount();
            int childCount = 0;
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                ++childCount;
            }
            if (childCount > 0) {
                if (this.mImposedTabWidths == null || this.mImposedTabWidths.length != count) {
                    this.mImposedTabWidths = new int[count];
                }
                for (i = 0; i < count; ++i) {
                    int newWidth;
                    child = this.getChildAt(i);
                    if (child.getVisibility() == 8) continue;
                    int childWidth = child.getMeasuredWidth();
                    int delta = extraWidth / childCount;
                    this.mImposedTabWidths[i] = newWidth = Math.max(0, childWidth - delta);
                    extraWidth -= childWidth - newWidth;
                    --childCount;
                    this.mImposedTabsHeight = Math.max(this.mImposedTabsHeight, child.getMeasuredHeight());
                }
            }
        }
        super.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
    }

    public View getChildTabViewAt(int index) {
        return this.getChildAt(index);
    }

    public int getTabCount() {
        return this.getChildCount();
    }

    public void setDividerDrawable(Drawable drawable2) {
        super.setDividerDrawable(drawable2);
    }

    public void setDividerDrawable(int resId) {
        this.setDividerDrawable(this.getResources().getDrawable(resId));
    }

    public void setLeftStripDrawable(Drawable drawable2) {
        this.mLeftStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    public void setLeftStripDrawable(int resId) {
        this.setLeftStripDrawable(this.getResources().getDrawable(resId));
    }

    public void setRightStripDrawable(Drawable drawable2) {
        this.mRightStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    public void setRightStripDrawable(int resId) {
        this.setRightStripDrawable(this.getResources().getDrawable(resId));
    }

    public void setStripEnabled(boolean stripEnabled) {
        this.mDrawBottomStrips = stripEnabled;
        this.invalidate();
    }

    public boolean isStripEnabled() {
        return this.mDrawBottomStrips;
    }

    public void childDrawableStateChanged(View child) {
        if (this.getTabCount() > 0 && child == this.getChildTabViewAt(this.mSelectedTab)) {
            this.invalidate();
        }
        super.childDrawableStateChanged(child);
    }

    public void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.getTabCount() == 0) {
            return;
        }
        if (!this.mDrawBottomStrips) {
            return;
        }
        View selectedChild = this.getChildTabViewAt(this.mSelectedTab);
        Drawable leftStrip = this.mLeftStrip;
        Drawable rightStrip = this.mRightStrip;
        leftStrip.setState(selectedChild.getDrawableState());
        rightStrip.setState(selectedChild.getDrawableState());
        if (this.mStripMoved) {
            Rect bounds = this.mBounds;
            bounds.left = selectedChild.getLeft();
            bounds.right = selectedChild.getRight();
            int myHeight = this.getHeight();
            leftStrip.setBounds(Math.min(0, bounds.left - leftStrip.getIntrinsicWidth()), myHeight - leftStrip.getIntrinsicHeight(), bounds.left, myHeight);
            rightStrip.setBounds(bounds.right, myHeight - rightStrip.getIntrinsicHeight(), Math.max(this.getWidth(), bounds.right + rightStrip.getIntrinsicWidth()), myHeight);
            this.mStripMoved = false;
        }
        leftStrip.draw(canvas);
        rightStrip.draw(canvas);
    }

    public void setCurrentTab(int index) {
        if (index < 0 || index >= this.getTabCount() || index == this.mSelectedTab) {
            return;
        }
        if (this.mSelectedTab != -1) {
            this.getChildTabViewAt(this.mSelectedTab).setSelected(false);
        }
        this.mSelectedTab = index;
        this.getChildTabViewAt(this.mSelectedTab).setSelected(true);
        this.mStripMoved = true;
        if (this.isShown()) {
            this.sendAccessibilityEvent(4);
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        View tabView;
        this.onPopulateAccessibilityEvent(event);
        if (this.mSelectedTab != -1 && (tabView = this.getChildTabViewAt(this.mSelectedTab)) != null && tabView.getVisibility() == 0) {
            return tabView.dispatchPopulateAccessibilityEvent(event);
        }
        return false;
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(TabWidget.class.getName());
        event.setItemCount(this.getTabCount());
        event.setCurrentItemIndex(this.mSelectedTab);
    }

    public void sendAccessibilityEventUnchecked(AccessibilityEvent event) {
        if (event.getEventType() == 8 && this.isFocused()) {
            event.recycle();
            return;
        }
        super.sendAccessibilityEventUnchecked(event);
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(TabWidget.class.getName());
    }

    public void focusCurrentTab(int index) {
        int oldTab = this.mSelectedTab;
        this.setCurrentTab(index);
        if (oldTab != index) {
            this.getChildTabViewAt(index).requestFocus();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildTabViewAt(i);
            child.setEnabled(enabled);
        }
    }

    public void addView(View child) {
        if (child.getLayoutParams() == null) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1, 1.0f);
            lp.setMargins(0, 0, 0, 0);
            child.setLayoutParams(lp);
        }
        child.setFocusable(true);
        child.setClickable(true);
        super.addView(child);
        child.setOnClickListener(new TabClickListener(this.getTabCount() - 1));
        child.setOnFocusChangeListener(this);
    }

    public void removeAllViews() {
        super.removeAllViews();
        this.mSelectedTab = -1;
    }

    void setTabSelectionListener(OnTabSelectionChanged listener) {
        this.mSelectionChangedListener = listener;
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (v == this && hasFocus && this.getTabCount() > 0) {
            this.getChildTabViewAt(this.mSelectedTab).requestFocus();
            return;
        }
        if (hasFocus) {
            int numTabs = this.getTabCount();
            for (int i = 0; i < numTabs; ++i) {
                if (this.getChildTabViewAt(i) != v) continue;
                this.setCurrentTab(i);
                this.mSelectionChangedListener.onTabSelectionChanged(i, false);
                if (!this.isShown()) break;
                this.sendAccessibilityEvent(8);
                break;
            }
        }
    }

    static interface OnTabSelectionChanged {
        public void onTabSelectionChanged(int var1, boolean var2);
    }

    private class TabClickListener
    implements View.OnClickListener {
        private final int mTabIndex;

        private TabClickListener(int tabIndex) {
            this.mTabIndex = tabIndex;
        }

        public void onClick(View v) {
            TabWidget.this.mSelectionChangedListener.onTabSelectionChanged(this.mTabIndex, true);
        }
    }
}

