/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentValues;
import android.database.Cursor;
import com.android.internal.util.HexDump;
import java.util.Arrays;
import java.util.Date;

public final class InboundSmsTracker {
    private final byte[] mPdu;
    private final long mTimestamp;
    private final int mDestPort;
    private final boolean mIs3gpp2;
    private final boolean mIs3gpp2WapPdu;
    private final String mAddress;
    private final int mReferenceNumber;
    private final int mSequenceNumber;
    private final int mMessageCount;
    private String mDeleteWhere;
    private String[] mDeleteWhereArgs;
    private static final int DEST_PORT_FLAG_NO_PORT = 65536;
    private static final int DEST_PORT_FLAG_3GPP = 131072;
    private static final int DEST_PORT_FLAG_3GPP2 = 262144;
    private static final int DEST_PORT_FLAG_3GPP2_WAP_PDU = 524288;
    private static final int DEST_PORT_MASK = 65535;

    InboundSmsTracker(byte[] pdu, long timestamp, int destPort, boolean is3gpp2, boolean is3gpp2WapPdu) {
        this.mPdu = pdu;
        this.mTimestamp = timestamp;
        this.mDestPort = destPort;
        this.mIs3gpp2 = is3gpp2;
        this.mIs3gpp2WapPdu = is3gpp2WapPdu;
        this.mAddress = null;
        this.mReferenceNumber = -1;
        this.mSequenceNumber = this.getIndexOffset();
        this.mMessageCount = 1;
    }

    public InboundSmsTracker(byte[] pdu, long timestamp, int destPort, boolean is3gpp2, String address, int referenceNumber, int sequenceNumber, int messageCount, boolean is3gpp2WapPdu) {
        this.mPdu = pdu;
        this.mTimestamp = timestamp;
        this.mDestPort = destPort;
        this.mIs3gpp2 = is3gpp2;
        this.mIs3gpp2WapPdu = is3gpp2WapPdu;
        this.mAddress = address;
        this.mReferenceNumber = referenceNumber;
        this.mSequenceNumber = sequenceNumber;
        this.mMessageCount = messageCount;
    }

    InboundSmsTracker(Cursor cursor, boolean isCurrentFormat3gpp2) {
        this.mPdu = HexDump.hexStringToByteArray(cursor.getString(0));
        if (cursor.isNull(2)) {
            this.mDestPort = -1;
            this.mIs3gpp2 = isCurrentFormat3gpp2;
            this.mIs3gpp2WapPdu = false;
        } else {
            int destPort = cursor.getInt(2);
            this.mIs3gpp2 = (destPort & 0x20000) != 0 ? false : ((destPort & 0x40000) != 0 ? true : isCurrentFormat3gpp2);
            this.mIs3gpp2WapPdu = (destPort & 0x80000) != 0;
            this.mDestPort = InboundSmsTracker.getRealDestPort(destPort);
        }
        this.mTimestamp = cursor.getLong(3);
        if (cursor.isNull(5)) {
            long rowId = cursor.getLong(7);
            this.mAddress = null;
            this.mReferenceNumber = -1;
            this.mSequenceNumber = this.getIndexOffset();
            this.mMessageCount = 1;
            this.mDeleteWhere = "_id=?";
            this.mDeleteWhereArgs = new String[]{Long.toString(rowId)};
        } else {
            this.mAddress = cursor.getString(6);
            this.mReferenceNumber = cursor.getInt(4);
            this.mMessageCount = cursor.getInt(5);
            this.mSequenceNumber = cursor.getInt(1);
            int index = this.mSequenceNumber - this.getIndexOffset();
            if (index < 0 || index >= this.mMessageCount) {
                throw new IllegalArgumentException("invalid PDU sequence " + this.mSequenceNumber + " of " + this.mMessageCount);
            }
            this.mDeleteWhere = "address=? AND reference_number=? AND count=?";
            this.mDeleteWhereArgs = new String[]{this.mAddress, Integer.toString(this.mReferenceNumber), Integer.toString(this.mMessageCount)};
        }
    }

    ContentValues getContentValues() {
        ContentValues values = new ContentValues();
        values.put("pdu", HexDump.toHexString(this.mPdu));
        values.put("date", this.mTimestamp);
        int destPort = this.mDestPort == -1 ? 65536 : this.mDestPort & 0xFFFF;
        destPort = this.mIs3gpp2 ? (destPort |= 0x40000) : (destPort |= 0x20000);
        if (this.mIs3gpp2WapPdu) {
            destPort |= 0x80000;
        }
        values.put("destination_port", destPort);
        if (this.mAddress != null) {
            values.put("address", this.mAddress);
            values.put("reference_number", this.mReferenceNumber);
            values.put("sequence", this.mSequenceNumber);
            values.put("count", this.mMessageCount);
        }
        return values;
    }

    static int getRealDestPort(int destPort) {
        if ((destPort & 0x10000) != 0) {
            return -1;
        }
        return destPort & 0xFFFF;
    }

    void setDeleteWhere(String deleteWhere, String[] deleteWhereArgs) {
        this.mDeleteWhere = deleteWhere;
        this.mDeleteWhereArgs = deleteWhereArgs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SmsTracker{timestamp=");
        builder.append(new Date(this.mTimestamp));
        builder.append(" destPort=").append(this.mDestPort);
        builder.append(" is3gpp2=").append(this.mIs3gpp2);
        if (this.mAddress != null) {
            builder.append(" address=").append(this.mAddress);
            builder.append(" refNumber=").append(this.mReferenceNumber);
            builder.append(" seqNumber=").append(this.mSequenceNumber);
            builder.append(" msgCount=").append(this.mMessageCount);
        }
        if (this.mDeleteWhere != null) {
            builder.append(" deleteWhere(").append(this.mDeleteWhere);
            builder.append(") deleteArgs=(").append(Arrays.toString(this.mDeleteWhereArgs));
            builder.append(')');
        }
        builder.append('}');
        return builder.toString();
    }

    byte[] getPdu() {
        return this.mPdu;
    }

    long getTimestamp() {
        return this.mTimestamp;
    }

    int getDestPort() {
        return this.mDestPort;
    }

    boolean is3gpp2() {
        return this.mIs3gpp2;
    }

    String getFormat() {
        return this.mIs3gpp2 ? "3gpp2" : "3gpp";
    }

    int getIndexOffset() {
        return this.mIs3gpp2 && this.mIs3gpp2WapPdu ? 0 : 1;
    }

    String getAddress() {
        return this.mAddress;
    }

    int getReferenceNumber() {
        return this.mReferenceNumber;
    }

    int getSequenceNumber() {
        return this.mSequenceNumber;
    }

    int getMessageCount() {
        return this.mMessageCount;
    }

    String getDeleteWhere() {
        return this.mDeleteWhere;
    }

    String[] getDeleteWhereArgs() {
        return this.mDeleteWhereArgs;
    }
}

