/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmCallTracker;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;

public class GsmConnection
extends Connection {
    private static final String LOG_TAG = "GsmConnection";
    private static final boolean DBG = true;
    GsmCallTracker mOwner;
    GsmCall mParent;
    String mAddress;
    String mDialString;
    String mPostDialString;
    boolean mIsIncoming;
    boolean mDisconnected;
    int mIndex;
    long mCreateTime;
    long mConnectTime;
    long mDisconnectTime;
    long mConnectTimeReal;
    long mDuration;
    long mHoldingStartTime;
    int mNextPostDialChar;
    Connection.DisconnectCause mCause = Connection.DisconnectCause.NOT_DISCONNECTED;
    Connection.PostDialState mPostDialState = Connection.PostDialState.NOT_STARTED;
    int mNumberPresentation = PhoneConstants.PRESENTATION_ALLOWED;
    UUSInfo mUusInfo;
    Handler mHandler;
    private PowerManager.WakeLock mPartialWakeLock;
    static final int EVENT_DTMF_DONE = 1;
    static final int EVENT_PAUSE_DONE = 2;
    static final int EVENT_NEXT_POST_DIAL = 3;
    static final int EVENT_WAKE_LOCK_TIMEOUT = 4;
    static final int PAUSE_DELAY_MILLIS = 3000;
    static final int WAKE_LOCK_TIMEOUT_MILLIS = 60000;

    GsmConnection(Context context, DriverCall dc, GsmCallTracker ct, int index) {
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this.mOwner.getLooper());
        this.mAddress = dc.number;
        this.mIsIncoming = dc.isMT;
        this.mCreateTime = System.currentTimeMillis();
        this.mCnapName = dc.name;
        this.mCnapNamePresentation = dc.namePresentation;
        this.mNumberPresentation = dc.numberPresentation;
        this.mUusInfo = dc.uusInfo;
        this.mIndex = index;
        this.mParent = this.parentFromDCState(dc.state);
        this.mParent.attach(this, dc);
    }

    GsmConnection(Context context, String dialString, GsmCallTracker ct, GsmCall parent) {
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.mOwner = ct;
        this.mHandler = new MyHandler(this.mOwner.getLooper());
        this.mDialString = dialString;
        this.mAddress = PhoneNumberUtils.extractNetworkPortionAlt(dialString);
        this.mPostDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.mIndex = -1;
        this.mIsIncoming = false;
        this.mCnapName = null;
        this.mCnapNamePresentation = PhoneConstants.PRESENTATION_ALLOWED;
        this.mNumberPresentation = PhoneConstants.PRESENTATION_ALLOWED;
        this.mCreateTime = System.currentTimeMillis();
        this.mParent = parent;
        parent.attachFake(this, Call.State.DIALING);
    }

    public void dispose() {
    }

    static boolean equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    boolean compareTo(DriverCall c) {
        if (!this.mIsIncoming && !c.isMT) {
            return true;
        }
        String cAddress = PhoneNumberUtils.stringFromStringAndTOA(c.number, c.TOA);
        return this.mIsIncoming == c.isMT && GsmConnection.equalsHandlesNulls(this.mAddress, cAddress);
    }

    public String getAddress() {
        return this.mAddress;
    }

    public GsmCall getCall() {
        return this.mParent;
    }

    public long getCreateTime() {
        return this.mCreateTime;
    }

    public long getConnectTime() {
        return this.mConnectTime;
    }

    public long getDisconnectTime() {
        return this.mDisconnectTime;
    }

    public long getDurationMillis() {
        if (this.mConnectTimeReal == 0L) {
            return 0L;
        }
        if (this.mDuration == 0L) {
            return SystemClock.elapsedRealtime() - this.mConnectTimeReal;
        }
        return this.mDuration;
    }

    public long getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.mHoldingStartTime;
    }

    public Connection.DisconnectCause getDisconnectCause() {
        return this.mCause;
    }

    public boolean isIncoming() {
        return this.mIsIncoming;
    }

    public Call.State getState() {
        if (this.mDisconnected) {
            return Call.State.DISCONNECTED;
        }
        return super.getState();
    }

    public void hangup() throws CallStateException {
        if (this.mDisconnected) {
            throw new CallStateException("disconnected");
        }
        this.mOwner.hangup(this);
    }

    public void separate() throws CallStateException {
        if (this.mDisconnected) {
            throw new CallStateException("disconnected");
        }
        this.mOwner.separate(this);
    }

    public Connection.PostDialState getPostDialState() {
        return this.mPostDialState;
    }

    public void proceedAfterWaitChar() {
        if (this.mPostDialState != Connection.PostDialState.WAIT) {
            Rlog.w(LOG_TAG, "GsmConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        this.processNextPostDialChar();
    }

    public void proceedAfterWildChar(String str) {
        if (this.mPostDialState != Connection.PostDialState.WILD) {
            Rlog.w(LOG_TAG, "GsmConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was " + (Object)((Object)this.mPostDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        StringBuilder buf = new StringBuilder(str);
        buf.append(this.mPostDialString.substring(this.mNextPostDialChar));
        this.mPostDialString = buf.toString();
        this.mNextPostDialChar = 0;
        this.log("proceedAfterWildChar: new postDialString is " + this.mPostDialString);
        this.processNextPostDialChar();
    }

    public void cancelPostDial() {
        this.setPostDialState(Connection.PostDialState.CANCELLED);
    }

    void onHangupLocal() {
        this.mCause = Connection.DisconnectCause.LOCAL;
    }

    Connection.DisconnectCause disconnectCauseFromCode(int causeCode) {
        IccCardApplicationStatus.AppState uiccAppState;
        switch (causeCode) {
            case 17: {
                return Connection.DisconnectCause.BUSY;
            }
            case 34: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 58: {
                return Connection.DisconnectCause.CONGESTION;
            }
            case 68: {
                return Connection.DisconnectCause.LIMIT_EXCEEDED;
            }
            case 240: {
                return Connection.DisconnectCause.CALL_BARRED;
            }
            case 241: {
                return Connection.DisconnectCause.FDN_BLOCKED;
            }
            case 1: {
                return Connection.DisconnectCause.UNOBTAINABLE_NUMBER;
            }
        }
        GSMPhone phone = this.mOwner.mPhone;
        int serviceState = phone.getServiceState().getState();
        UiccCardApplication cardApp = UiccController.getInstance().getUiccCardApplication(1);
        IccCardApplicationStatus.AppState appState = uiccAppState = cardApp != null ? cardApp.getState() : IccCardApplicationStatus.AppState.APPSTATE_UNKNOWN;
        if (serviceState == 3) {
            return Connection.DisconnectCause.POWER_OFF;
        }
        if (serviceState == 1 || serviceState == 2) {
            return Connection.DisconnectCause.OUT_OF_SERVICE;
        }
        if (uiccAppState != IccCardApplicationStatus.AppState.APPSTATE_READY) {
            return Connection.DisconnectCause.ICC_ERROR;
        }
        if (causeCode == 65535) {
            if (phone.mSST.mRestrictedState.isCsRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED;
            }
            if (phone.mSST.mRestrictedState.isCsEmergencyRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED_EMERGENCY;
            }
            if (phone.mSST.mRestrictedState.isCsNormalRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED_NORMAL;
            }
            return Connection.DisconnectCause.ERROR_UNSPECIFIED;
        }
        if (causeCode == 16) {
            return Connection.DisconnectCause.NORMAL;
        }
        return Connection.DisconnectCause.ERROR_UNSPECIFIED;
    }

    void onRemoteDisconnect(int causeCode) {
        this.onDisconnect(this.disconnectCauseFromCode(causeCode));
    }

    boolean onDisconnect(Connection.DisconnectCause cause) {
        boolean changed = false;
        this.mCause = cause;
        if (!this.mDisconnected) {
            this.mIndex = -1;
            this.mDisconnectTime = System.currentTimeMillis();
            this.mDuration = SystemClock.elapsedRealtime() - this.mConnectTimeReal;
            this.mDisconnected = true;
            Rlog.d(LOG_TAG, "onDisconnect: cause=" + (Object)((Object)cause));
            this.mOwner.mPhone.notifyDisconnect(this);
            if (this.mParent != null) {
                changed = this.mParent.connectionDisconnected(this);
            }
        }
        this.releaseWakeLock();
        return changed;
    }

    boolean update(DriverCall dc) {
        boolean changed = false;
        boolean wasConnectingInOrOut = this.isConnectingInOrOut();
        boolean wasHolding = this.getState() == Call.State.HOLDING;
        GsmCall newParent = this.parentFromDCState(dc.state);
        if (!GsmConnection.equalsHandlesNulls(this.mAddress, dc.number)) {
            this.log("update: phone # changed!");
            this.mAddress = dc.number;
            changed = true;
        }
        if (TextUtils.isEmpty(dc.name)) {
            if (!TextUtils.isEmpty(this.mCnapName)) {
                changed = true;
                this.mCnapName = "";
            }
        } else if (!dc.name.equals(this.mCnapName)) {
            changed = true;
            this.mCnapName = dc.name;
        }
        this.log("--dssds----" + this.mCnapName);
        this.mCnapNamePresentation = dc.namePresentation;
        this.mNumberPresentation = dc.numberPresentation;
        if (newParent != this.mParent) {
            if (this.mParent != null) {
                this.mParent.detach(this);
            }
            newParent.attach(this, dc);
            this.mParent = newParent;
            changed = true;
        } else {
            boolean parentStateChange = this.mParent.update(this, dc);
            changed = changed || parentStateChange;
        }
        this.log("update: parent=" + this.mParent + ", hasNewParent=" + (newParent != this.mParent) + ", wasConnectingInOrOut=" + wasConnectingInOrOut + ", wasHolding=" + wasHolding + ", isConnectingInOrOut=" + this.isConnectingInOrOut() + ", changed=" + changed);
        if (wasConnectingInOrOut && !this.isConnectingInOrOut()) {
            this.onConnectedInOrOut();
        }
        if (changed && !wasHolding && this.getState() == Call.State.HOLDING) {
            this.onStartedHolding();
        }
        return changed;
    }

    void fakeHoldBeforeDial() {
        if (this.mParent != null) {
            this.mParent.detach(this);
        }
        this.mParent = this.mOwner.mBackgroundCall;
        this.mParent.attachFake(this, Call.State.HOLDING);
        this.onStartedHolding();
    }

    int getGSMIndex() throws CallStateException {
        if (this.mIndex >= 0) {
            return this.mIndex + 1;
        }
        throw new CallStateException("GSM index not yet assigned");
    }

    void onConnectedInOrOut() {
        this.mConnectTime = System.currentTimeMillis();
        this.mConnectTimeReal = SystemClock.elapsedRealtime();
        this.mDuration = 0L;
        this.log("onConnectedInOrOut: connectTime=" + this.mConnectTime);
        if (!this.mIsIncoming) {
            this.processNextPostDialChar();
        }
        this.releaseWakeLock();
    }

    void onStartedHolding() {
        this.mHoldingStartTime = SystemClock.elapsedRealtime();
    }

    private boolean processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            this.mOwner.mCi.sendDtmf(c, this.mHandler.obtainMessage(1));
        } else if (c == ',') {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 3000L);
        } else if (c == ';') {
            this.setPostDialState(Connection.PostDialState.WAIT);
        } else if (c == 'N') {
            this.setPostDialState(Connection.PostDialState.WILD);
        } else {
            return false;
        }
        return true;
    }

    public String getRemainingPostDialString() {
        if (this.mPostDialState == Connection.PostDialState.CANCELLED || this.mPostDialState == Connection.PostDialState.COMPLETE || this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            return "";
        }
        return this.mPostDialString.substring(this.mNextPostDialChar);
    }

    protected void finalize() {
        if (this.mPartialWakeLock.isHeld()) {
            Rlog.e(LOG_TAG, "[GSMConn] UNEXPECTED; mPartialWakeLock is held when finalizing.");
        }
        this.releaseWakeLock();
    }

    private void processNextPostDialChar() {
        Message notifyMessage;
        char c = '\u0000';
        if (this.mPostDialState == Connection.PostDialState.CANCELLED) {
            return;
        }
        if (this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            this.setPostDialState(Connection.PostDialState.COMPLETE);
            c = '\u0000';
        } else {
            this.setPostDialState(Connection.PostDialState.STARTED);
            c = this.mPostDialString.charAt(this.mNextPostDialChar++);
            boolean isValid = this.processPostDialChar(c);
            if (!isValid) {
                this.mHandler.obtainMessage(3).sendToTarget();
                Rlog.e("GSM", "processNextPostDialChar: c=" + c + " isn't valid!");
                return;
            }
        }
        Registrant postDialHandler = this.mOwner.mPhone.mPostDialHandler;
        if (postDialHandler != null && (notifyMessage = postDialHandler.messageForRegistrant()) != null) {
            Connection.PostDialState state = this.mPostDialState;
            AsyncResult ar = AsyncResult.forMessage(notifyMessage);
            ar.result = this;
            ar.userObj = state;
            notifyMessage.arg1 = c;
            notifyMessage.sendToTarget();
        }
    }

    private boolean isConnectingInOrOut() {
        return this.mParent == null || this.mParent == this.mOwner.mRingingCall || this.mParent.mState == Call.State.DIALING || this.mParent.mState == Call.State.ALERTING;
    }

    private GsmCall parentFromDCState(DriverCall.State state) {
        switch (state) {
            case ACTIVE: 
            case DIALING: 
            case ALERTING: {
                return this.mOwner.mForegroundCall;
            }
            case HOLDING: {
                return this.mOwner.mBackgroundCall;
            }
            case INCOMING: 
            case WAITING: {
                return this.mOwner.mRingingCall;
            }
        }
        throw new RuntimeException("illegal call state: " + (Object)((Object)state));
    }

    private void setPostDialState(Connection.PostDialState s) {
        if (this.mPostDialState != Connection.PostDialState.STARTED && s == Connection.PostDialState.STARTED) {
            this.acquireWakeLock();
            Message msg = this.mHandler.obtainMessage(4);
            this.mHandler.sendMessageDelayed(msg, 60000L);
        } else if (this.mPostDialState == Connection.PostDialState.STARTED && s != Connection.PostDialState.STARTED) {
            this.mHandler.removeMessages(4);
            this.releaseWakeLock();
        }
        this.mPostDialState = s;
    }

    private void createWakeLock(Context context) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mPartialWakeLock = pm.newWakeLock(1, LOG_TAG);
    }

    private void acquireWakeLock() {
        this.log("acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakeLock() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            if (this.mPartialWakeLock.isHeld()) {
                this.log("releaseWakeLock");
                this.mPartialWakeLock.release();
            }
        }
    }

    private void log(String msg) {
        Rlog.d(LOG_TAG, "[GSMConn] " + msg);
    }

    public int getNumberPresentation() {
        return this.mNumberPresentation;
    }

    public UUSInfo getUUSInfo() {
        return this.mUusInfo;
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper l) {
            super(l);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: 
                case 3: {
                    GsmConnection.this.processNextPostDialChar();
                    break;
                }
                case 4: {
                    GsmConnection.this.releaseWakeLock();
                }
            }
        }
    }
}

