/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.CsimFileHandler;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IsimFileHandler;
import com.android.internal.telephony.uicc.IsimUiccRecords;
import com.android.internal.telephony.uicc.RuimFileHandler;
import com.android.internal.telephony.uicc.RuimRecords;
import com.android.internal.telephony.uicc.SIMFileHandler;
import com.android.internal.telephony.uicc.SIMRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UsimFileHandler;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class UiccCardApplication {
    private static final String LOG_TAG = "UiccCardApplication";
    private static final boolean DBG = true;
    private static final int EVENT_QUERY_FACILITY_FDN_DONE = 1;
    private static final int EVENT_CHANGE_FACILITY_FDN_DONE = 2;
    private static final int EVENT_QUERY_FACILITY_LOCK_DONE = 3;
    private static final int EVENT_CHANGE_FACILITY_LOCK_DONE = 4;
    private final Object mLock = new Object();
    private UiccCard mUiccCard;
    private IccCardApplicationStatus.AppState mAppState;
    private IccCardApplicationStatus.AppType mAppType;
    private IccCardApplicationStatus.PersoSubState mPersoSubState;
    private String mAid;
    private String mAppLabel;
    private boolean mPin1Replaced;
    private IccCardStatus.PinState mPin1State;
    private IccCardStatus.PinState mPin2State;
    private boolean mIccFdnEnabled;
    private boolean mDesiredFdnEnabled;
    private boolean mIccLockEnabled;
    private boolean mDesiredPinLocked;
    private CommandsInterface mCi;
    private Context mContext;
    private IccRecords mIccRecords;
    private IccFileHandler mIccFh;
    private boolean mDestroyed;
    private RegistrantList mReadyRegistrants = new RegistrantList();
    private RegistrantList mPinLockedRegistrants = new RegistrantList();
    private RegistrantList mNetworkLockedRegistrants = new RegistrantList();
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (UiccCardApplication.this.mDestroyed) {
                UiccCardApplication.this.loge("Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
                return;
            }
            switch (msg.what) {
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    UiccCardApplication.this.onQueryFdnEnabled(ar);
                    break;
                }
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    UiccCardApplication.this.onChangeFdnDone(ar);
                    break;
                }
                case 3: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    UiccCardApplication.this.onQueryFacilityLock(ar);
                    break;
                }
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    UiccCardApplication.this.onChangeFacilityLock(ar);
                    break;
                }
                default: {
                    UiccCardApplication.this.loge("Unknown Event " + msg.what);
                }
            }
        }
    };

    UiccCardApplication(UiccCard uiccCard, IccCardApplicationStatus as, Context c, CommandsInterface ci) {
        this.log("Creating UiccApp: " + as);
        this.mUiccCard = uiccCard;
        this.mAppState = as.app_state;
        this.mAppType = as.app_type;
        this.mPersoSubState = as.perso_substate;
        this.mAid = as.aid;
        this.mAppLabel = as.app_label;
        this.mPin1Replaced = as.pin1_replaced != 0;
        this.mPin1State = as.pin1;
        this.mPin2State = as.pin2;
        this.mContext = c;
        this.mCi = ci;
        this.mIccFh = this.createIccFileHandler(as.app_type);
        this.mIccRecords = this.createIccRecords(as.app_type, this.mContext, this.mCi);
        if (this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_READY) {
            this.queryFdn();
            this.queryPin1State();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(IccCardApplicationStatus as, Context c, CommandsInterface ci) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                this.loge("Application updated after destroyed! Fix me!");
                return;
            }
            this.log((Object)((Object)this.mAppType) + " update. New " + as);
            this.mContext = c;
            this.mCi = ci;
            IccCardApplicationStatus.AppType oldAppType = this.mAppType;
            IccCardApplicationStatus.AppState oldAppState = this.mAppState;
            IccCardApplicationStatus.PersoSubState oldPersoSubState = this.mPersoSubState;
            this.mAppType = as.app_type;
            this.mAppState = as.app_state;
            this.mPersoSubState = as.perso_substate;
            this.mAid = as.aid;
            this.mAppLabel = as.app_label;
            this.mPin1Replaced = as.pin1_replaced != 0;
            this.mPin1State = as.pin1;
            this.mPin2State = as.pin2;
            if (this.mAppType != oldAppType) {
                if (this.mIccFh != null) {
                    this.mIccFh.dispose();
                }
                if (this.mIccRecords != null) {
                    this.mIccRecords.dispose();
                }
                this.mIccFh = this.createIccFileHandler(as.app_type);
                this.mIccRecords = this.createIccRecords(as.app_type, c, ci);
            }
            if (this.mPersoSubState != oldPersoSubState && this.mPersoSubState == IccCardApplicationStatus.PersoSubState.PERSOSUBSTATE_SIM_NETWORK) {
                this.notifyNetworkLockedRegistrantsIfNeeded(null);
            }
            if (this.mAppState != oldAppState) {
                this.log((Object)((Object)oldAppType) + " changed state: " + (Object)((Object)oldAppState) + " -> " + (Object)((Object)this.mAppState));
                if (this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_READY) {
                    this.queryFdn();
                    this.queryPin1State();
                }
                this.notifyPinLockedRegistrantsIfNeeded(null);
                this.notifyReadyRegistrantsIfNeeded(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Object object = this.mLock;
        synchronized (object) {
            this.log((Object)((Object)this.mAppType) + " being Disposed");
            this.mDestroyed = true;
            if (this.mIccRecords != null) {
                this.mIccRecords.dispose();
            }
            if (this.mIccFh != null) {
                this.mIccFh.dispose();
            }
            this.mIccRecords = null;
            this.mIccFh = null;
        }
    }

    private IccRecords createIccRecords(IccCardApplicationStatus.AppType type, Context c, CommandsInterface ci) {
        if (type == IccCardApplicationStatus.AppType.APPTYPE_USIM || type == IccCardApplicationStatus.AppType.APPTYPE_SIM) {
            return new SIMRecords(this, c, ci);
        }
        if (type == IccCardApplicationStatus.AppType.APPTYPE_RUIM || type == IccCardApplicationStatus.AppType.APPTYPE_CSIM) {
            return new RuimRecords(this, c, ci);
        }
        if (type == IccCardApplicationStatus.AppType.APPTYPE_ISIM) {
            return new IsimUiccRecords(this, c, ci);
        }
        return null;
    }

    private IccFileHandler createIccFileHandler(IccCardApplicationStatus.AppType type) {
        switch (type) {
            case APPTYPE_SIM: {
                return new SIMFileHandler(this, this.mAid, this.mCi);
            }
            case APPTYPE_RUIM: {
                return new RuimFileHandler(this, this.mAid, this.mCi);
            }
            case APPTYPE_USIM: {
                return new UsimFileHandler(this, this.mAid, this.mCi);
            }
            case APPTYPE_CSIM: {
                return new CsimFileHandler(this, this.mAid, this.mCi);
            }
            case APPTYPE_ISIM: {
                return new IsimFileHandler(this, this.mAid, this.mCi);
            }
        }
        return null;
    }

    private void queryFdn() {
        int serviceClassX = 7;
        this.mCi.queryFacilityLockForApp("FD", "", serviceClassX, this.mAid, this.mHandler.obtainMessage(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQueryFdnEnabled(AsyncResult ar) {
        Object object = this.mLock;
        synchronized (object) {
            if (ar.exception != null) {
                this.log("Error in querying facility lock:" + ar.exception);
                return;
            }
            int[] ints = (int[])ar.result;
            if (ints.length != 0) {
                this.mIccFdnEnabled = 0 != ints[0];
                this.log("Query facility lock : " + this.mIccFdnEnabled);
            } else {
                this.loge("Bogus facility lock response");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChangeFdnDone(AsyncResult ar) {
        Object object = this.mLock;
        synchronized (object) {
            if (ar.exception == null) {
                this.mIccFdnEnabled = this.mDesiredFdnEnabled;
                this.log("EVENT_CHANGE_FACILITY_FDN_DONE: mIccFdnEnabled=" + this.mIccFdnEnabled);
            } else {
                this.loge("Error change facility fdn with exception " + ar.exception);
            }
            Message response = (Message)ar.userObj;
            AsyncResult.forMessage((Message)response).exception = ar.exception;
            response.sendToTarget();
        }
    }

    private void queryPin1State() {
        int serviceClassX = 7;
        this.mCi.queryFacilityLockForApp("SC", "", serviceClassX, this.mAid, this.mHandler.obtainMessage(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQueryFacilityLock(AsyncResult ar) {
        block12: {
            Object object = this.mLock;
            synchronized (object) {
                block11: {
                    if (ar.exception != null) {
                        this.log("Error in querying facility lock:" + ar.exception);
                        return;
                    }
                    int[] ints = (int[])ar.result;
                    if (ints.length == 0) break block11;
                    this.log("Query facility lock : " + ints[0]);
                    boolean bl = this.mIccLockEnabled = ints[0] != 0;
                    if (this.mIccLockEnabled) {
                        this.mPinLockedRegistrants.notifyRegistrants();
                    }
                    switch (this.mPin1State) {
                        case PINSTATE_DISABLED: {
                            if (this.mIccLockEnabled) {
                                this.loge("QUERY_FACILITY_LOCK:enabled GET_SIM_STATUS.Pin1:disabled. Fixme");
                                break;
                            }
                            break block12;
                        }
                        case PINSTATE_ENABLED_NOT_VERIFIED: 
                        case PINSTATE_ENABLED_VERIFIED: 
                        case PINSTATE_ENABLED_BLOCKED: 
                        case PINSTATE_ENABLED_PERM_BLOCKED: {
                            if (!this.mIccLockEnabled) {
                                this.loge("QUERY_FACILITY_LOCK:disabled GET_SIM_STATUS.Pin1:enabled. Fixme");
                            }
                        }
                        default: {
                            this.log("Ignoring: pin1state=" + (Object)((Object)this.mPin1State));
                            break;
                        }
                    }
                    break block12;
                }
                this.loge("Bogus facility lock response");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChangeFacilityLock(AsyncResult ar) {
        Object object = this.mLock;
        synchronized (object) {
            if (ar.exception == null) {
                this.mIccLockEnabled = this.mDesiredPinLocked;
                this.log("EVENT_CHANGE_FACILITY_LOCK_DONE: mIccLockEnabled= " + this.mIccLockEnabled);
            } else {
                this.loge("Error change facility lock with exception " + ar.exception);
            }
            AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
            ((Message)ar.userObj).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForReady(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mReadyRegistrants.add(r);
            this.notifyReadyRegistrantsIfNeeded(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForReady(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mReadyRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mPinLockedRegistrants.add(r);
            this.notifyPinLockedRegistrantsIfNeeded(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPinLockedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForNetworkLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mNetworkLockedRegistrants.add(r);
            this.notifyNetworkLockedRegistrantsIfNeeded(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForNetworkLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNetworkLockedRegistrants.remove(h);
        }
    }

    private void notifyReadyRegistrantsIfNeeded(Registrant r) {
        if (this.mDestroyed) {
            return;
        }
        if (this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_READY) {
            if (this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_NOT_VERIFIED || this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_BLOCKED || this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_PERM_BLOCKED) {
                this.loge("Sanity check failed! APPSTATE is ready while PIN1 is not verified!!!");
                return;
            }
            if (r == null) {
                this.log("Notifying registrants: READY");
                this.mReadyRegistrants.notifyRegistrants();
            } else {
                this.log("Notifying 1 registrant: READY");
                r.notifyRegistrant(new AsyncResult(null, null, null));
            }
        }
    }

    private void notifyPinLockedRegistrantsIfNeeded(Registrant r) {
        if (this.mDestroyed) {
            return;
        }
        if (this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_PIN || this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_PUK) {
            if (this.mPin1State == IccCardStatus.PinState.PINSTATE_ENABLED_VERIFIED || this.mPin1State == IccCardStatus.PinState.PINSTATE_DISABLED) {
                this.loge("Sanity check failed! APPSTATE is locked while PIN1 is not!!!");
                return;
            }
            if (r == null) {
                this.log("Notifying registrants: LOCKED");
                this.mPinLockedRegistrants.notifyRegistrants();
            } else {
                this.log("Notifying 1 registrant: LOCKED");
                r.notifyRegistrant(new AsyncResult(null, null, null));
            }
        }
    }

    private void notifyNetworkLockedRegistrantsIfNeeded(Registrant r) {
        if (this.mDestroyed) {
            return;
        }
        if (this.mAppState == IccCardApplicationStatus.AppState.APPSTATE_SUBSCRIPTION_PERSO && this.mPersoSubState == IccCardApplicationStatus.PersoSubState.PERSOSUBSTATE_SIM_NETWORK) {
            if (r == null) {
                this.log("Notifying registrants: NETWORK_LOCKED");
                this.mNetworkLockedRegistrants.notifyRegistrants();
            } else {
                this.log("Notifying 1 registrant: NETWORK_LOCED");
                r.notifyRegistrant(new AsyncResult(null, null, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardApplicationStatus.AppState getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAppState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardApplicationStatus.AppType getType() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAppType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardApplicationStatus.PersoSubState getPersoSubState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPersoSubState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAid() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccCardStatus.PinState getPin1State() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPin1Replaced) {
                return this.mUiccCard.getUniversalPinState();
            }
            return this.mPin1State;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccFileHandler getIccFileHandler() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccFh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IccRecords getIccRecords() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyPin(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCi.supplyIccPin(pin, onComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyPuk(String puk, String newPin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCi.supplyIccPuk(puk, newPin, onComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyPin2(String pin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCi.supplyIccPin2(pin2, onComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyPuk2(String puk2, String newPin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCi.supplyIccPuk2(puk2, newPin2, onComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplyNetworkDepersonalization(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.log("supplyNetworkDepersonalization");
            this.mCi.supplyNetworkDepersonalization(pin, onComplete);
        }
    }

    public boolean getIccLockEnabled() {
        return this.mIccLockEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIccFdnEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccFdnEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            int serviceClassX = 7;
            this.mDesiredPinLocked = enabled;
            this.mCi.setFacilityLockForApp("SC", enabled, password, serviceClassX, this.mAid, this.mHandler.obtainMessage(4, onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            int serviceClassX = 15;
            this.mDesiredFdnEnabled = enabled;
            this.mCi.setFacilityLockForApp("FD", enabled, password, serviceClassX, this.mAid, this.mHandler.obtainMessage(2, onComplete));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.log("changeIccLockPassword");
            this.mCi.changeIccPinForApp(oldPassword, newPassword, this.mAid, onComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            this.log("changeIccFdnPassword");
            this.mCi.changeIccPin2ForApp(oldPassword, newPassword, this.mAid, onComplete);
        }
    }

    private void log(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("UiccCardApplication: " + this);
        pw.println(" mUiccCard=" + this.mUiccCard);
        pw.println(" mAppState=" + (Object)((Object)this.mAppState));
        pw.println(" mAppType=" + (Object)((Object)this.mAppType));
        pw.println(" mPersoSubState=" + (Object)((Object)this.mPersoSubState));
        pw.println(" mAid=" + this.mAid);
        pw.println(" mAppLabel=" + this.mAppLabel);
        pw.println(" mPin1Replaced=" + this.mPin1Replaced);
        pw.println(" mPin1State=" + (Object)((Object)this.mPin1State));
        pw.println(" mPin2State=" + (Object)((Object)this.mPin2State));
        pw.println(" mIccFdnEnabled=" + this.mIccFdnEnabled);
        pw.println(" mDesiredFdnEnabled=" + this.mDesiredFdnEnabled);
        pw.println(" mIccLockEnabled=" + this.mIccLockEnabled);
        pw.println(" mDesiredPinLocked=" + this.mDesiredPinLocked);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mIccRecords=" + this.mIccRecords);
        pw.println(" mIccFh=" + this.mIccFh);
        pw.println(" mDestroyed=" + this.mDestroyed);
        pw.println(" mReadyRegistrants: size=" + this.mReadyRegistrants.size());
        for (i = 0; i < this.mReadyRegistrants.size(); ++i) {
            pw.println("  mReadyRegistrants[" + i + "]=" + ((Registrant)this.mReadyRegistrants.get(i)).getHandler());
        }
        pw.println(" mPinLockedRegistrants: size=" + this.mPinLockedRegistrants.size());
        for (i = 0; i < this.mPinLockedRegistrants.size(); ++i) {
            pw.println("  mPinLockedRegistrants[" + i + "]=" + ((Registrant)this.mPinLockedRegistrants.get(i)).getHandler());
        }
        pw.println(" mNetworkLockedRegistrants: size=" + this.mNetworkLockedRegistrants.size());
        for (i = 0; i < this.mNetworkLockedRegistrants.size(); ++i) {
            pw.println("  mNetworkLockedRegistrants[" + i + "]=" + ((Registrant)this.mNetworkLockedRegistrants.get(i)).getHandler());
        }
        pw.flush();
    }
}

