/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.android_webview;

import android.content.Context;
import com.android.org.chromium.base.PathUtils;
import com.android.org.chromium.base.ThreadUtils;
import com.android.org.chromium.content.app.LibraryLoader;
import com.android.org.chromium.content.browser.AndroidBrowserProcess;
import com.android.org.chromium.content.common.ProcessInitException;

public abstract class AwBrowserProcess {
    private static final String PRIVATE_DATA_DIRECTORY_SUFFIX = "webview";

    public static void loadLibrary() {
        PathUtils.setPrivateDataDirectorySuffix(PRIVATE_DATA_DIRECTORY_SUFFIX);
        try {
            LibraryLoader.loadNow();
        }
        catch (ProcessInitException e) {
            throw new RuntimeException("Cannot load WebView", e);
        }
    }

    public static void start(final Context context) {
        ThreadUtils.runOnUiThreadBlocking(new Runnable(){

            public void run() {
                try {
                    LibraryLoader.ensureInitialized();
                    AndroidBrowserProcess.init(context, 0);
                }
                catch (ProcessInitException e) {
                    throw new RuntimeException("Cannot initialize WebView", e);
                }
            }
        });
    }
}

