/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.android_webview;

import android.webkit.ValueCallback;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.base.ThreadUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="android_webview")
public class AwQuotaManagerBridge {
    private static AwQuotaManagerBridge sInstance;
    private int mNativeAwQuotaManagerBridgeImpl;
    private int mNextId;
    private Map<Integer, ValueCallback<Origins>> mPendingGetOriginCallbacks;
    private Map<Integer, ValueCallback<Long>> mPendingGetQuotaForOriginCallbacks;
    private Map<Integer, ValueCallback<Long>> mPendingGetUsageForOriginCallbacks;

    private static native int nativeGetDefaultNativeAwQuotaManagerBridge();

    public static AwQuotaManagerBridge getInstance() {
        ThreadUtils.assertOnUiThread();
        if (sInstance == null) {
            sInstance = new AwQuotaManagerBridge(AwQuotaManagerBridge.nativeGetDefaultNativeAwQuotaManagerBridge());
        }
        return sInstance;
    }

    private AwQuotaManagerBridge(int nativeAwQuotaManagerBridgeImpl) {
        this.mNativeAwQuotaManagerBridgeImpl = nativeAwQuotaManagerBridgeImpl;
        this.mPendingGetOriginCallbacks = new HashMap<Integer, ValueCallback<Origins>>();
        this.mPendingGetQuotaForOriginCallbacks = new HashMap<Integer, ValueCallback<Long>>();
        this.mPendingGetUsageForOriginCallbacks = new HashMap<Integer, ValueCallback<Long>>();
        this.nativeInit(this.mNativeAwQuotaManagerBridgeImpl);
    }

    private int getNextId() {
        ThreadUtils.assertOnUiThread();
        return ++this.mNextId;
    }

    public void deleteAllData() {
        this.nativeDeleteAllData(this.mNativeAwQuotaManagerBridgeImpl);
    }

    public void deleteOrigin(String origin) {
        this.nativeDeleteOrigin(this.mNativeAwQuotaManagerBridgeImpl, origin);
    }

    public void getOrigins(ValueCallback<Origins> callback) {
        int callbackId = this.getNextId();
        assert (!this.mPendingGetOriginCallbacks.containsKey(callbackId));
        this.mPendingGetOriginCallbacks.put(callbackId, callback);
        this.nativeGetOrigins(this.mNativeAwQuotaManagerBridgeImpl, callbackId);
    }

    public void getQuotaForOrigin(String origin, ValueCallback<Long> callback) {
        int callbackId = this.getNextId();
        assert (!this.mPendingGetQuotaForOriginCallbacks.containsKey(callbackId));
        this.mPendingGetQuotaForOriginCallbacks.put(callbackId, callback);
        this.nativeGetUsageAndQuotaForOrigin(this.mNativeAwQuotaManagerBridgeImpl, origin, callbackId, true);
    }

    public void getUsageForOrigin(String origin, ValueCallback<Long> callback) {
        int callbackId = this.getNextId();
        assert (!this.mPendingGetUsageForOriginCallbacks.containsKey(callbackId));
        this.mPendingGetUsageForOriginCallbacks.put(callbackId, callback);
        this.nativeGetUsageAndQuotaForOrigin(this.mNativeAwQuotaManagerBridgeImpl, origin, callbackId, false);
    }

    @CalledByNative
    private void onGetOriginsCallback(int callbackId, String[] origin, long[] usages, long[] quotas) {
        assert (this.mPendingGetOriginCallbacks.containsKey(callbackId));
        this.mPendingGetOriginCallbacks.remove(callbackId).onReceiveValue(new Origins(origin, usages, quotas));
    }

    @CalledByNative
    private void onGetUsageAndQuotaForOriginCallback(int callbackId, boolean isQuota, long usage, long quota) {
        if (isQuota) {
            assert (this.mPendingGetQuotaForOriginCallbacks.containsKey(callbackId));
            this.mPendingGetQuotaForOriginCallbacks.remove(callbackId).onReceiveValue(quota);
        } else {
            assert (this.mPendingGetUsageForOriginCallbacks.containsKey(callbackId));
            this.mPendingGetUsageForOriginCallbacks.remove(callbackId).onReceiveValue(usage);
        }
    }

    private native void nativeInit(int var1);

    private native void nativeDeleteAllData(int var1);

    private native void nativeDeleteOrigin(int var1, String var2);

    private native void nativeGetOrigins(int var1, int var2);

    private native void nativeGetUsageAndQuotaForOrigin(int var1, String var2, int var3, boolean var4);

    public static class Origins {
        public final String[] mOrigins;
        public final long[] mUsages;
        public final long[] mQuotas;

        Origins(String[] origins, long[] usages, long[] quotas) {
            this.mOrigins = origins;
            this.mUsages = usages;
            this.mQuotas = quotas;
        }
    }
}

