/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.android_webview;

import android.graphics.Rect;
import android.widget.OverScroller;
import com.android.org.chromium.android_webview.OverScrollGlow;
import com.android.org.chromium.com.google.common.annotations.VisibleForTesting;

@VisibleForTesting
public class AwScrollOffsetManager {
    private static final int PAGE_SCROLL_OVERLAP = 24;
    private static final int STD_SCROLL_ANIMATION_SPEED_PIX_PER_SEC = 480;
    private static final int MAX_SCROLL_ANIMATION_DURATION_MILLISEC = 750;
    private final Delegate mDelegate;
    private int mNativeScrollX;
    private int mNativeScrollY;
    private int mMaxHorizontalScrollOffset;
    private int mMaxVerticalScrollOffset;
    private int mContainerViewWidth;
    private int mContainerViewHeight;
    private boolean mProcessingTouchEvent;
    private boolean mFlinging;
    private boolean mApplyDeferredNativeScroll;
    private int mDeferredNativeScrollX;
    private int mDeferredNativeScrollY;
    private int mLastFlingVelocityX;
    private int mLastFlingVelocityY;
    private OverScroller mScroller;

    public AwScrollOffsetManager(Delegate delegate, OverScroller overScroller) {
        this.mDelegate = delegate;
        this.mScroller = overScroller;
    }

    public int computeHorizontalScrollRange() {
        return this.mContainerViewWidth + this.mMaxHorizontalScrollOffset;
    }

    public int computeMaximumHorizontalScrollOffset() {
        return this.mMaxHorizontalScrollOffset;
    }

    public int computeHorizontalScrollOffset() {
        return this.mDelegate.getContainerViewScrollX();
    }

    public int computeVerticalScrollRange() {
        return this.mContainerViewHeight + this.mMaxVerticalScrollOffset;
    }

    public int computeMaximumVerticalScrollOffset() {
        return this.mMaxVerticalScrollOffset;
    }

    public int computeVerticalScrollOffset() {
        return this.mDelegate.getContainerViewScrollY();
    }

    public int computeVerticalScrollExtent() {
        return this.mContainerViewHeight;
    }

    public void setMaxScrollOffset(int width, int height) {
        this.mMaxHorizontalScrollOffset = width;
        this.mMaxVerticalScrollOffset = height;
    }

    public void setContainerViewSize(int width, int height) {
        this.mContainerViewWidth = width;
        this.mContainerViewHeight = height;
    }

    public void syncScrollOffsetFromOnDraw() {
        this.onContainerViewScrollChanged(this.mDelegate.getContainerViewScrollX(), this.mDelegate.getContainerViewScrollY());
    }

    public void setProcessingTouchEvent(boolean processingTouchEvent) {
        assert (this.mProcessingTouchEvent != processingTouchEvent);
        this.mProcessingTouchEvent = processingTouchEvent;
        if (!this.mProcessingTouchEvent && this.mApplyDeferredNativeScroll) {
            this.mApplyDeferredNativeScroll = false;
            this.scrollNativeTo(this.mDeferredNativeScrollX, this.mDeferredNativeScrollY);
        }
    }

    public void scrollContainerViewTo(int x, int y) {
        this.mNativeScrollX = x;
        this.mNativeScrollY = y;
        int scrollX = this.mDelegate.getContainerViewScrollX();
        int scrollY = this.mDelegate.getContainerViewScrollY();
        int deltaX = x - scrollX;
        int deltaY = y - scrollY;
        int scrollRangeX = this.computeMaximumHorizontalScrollOffset();
        int scrollRangeY = this.computeMaximumVerticalScrollOffset();
        this.mDelegate.overScrollContainerViewBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, this.mProcessingTouchEvent);
    }

    public boolean isFlingActive() {
        return this.mFlinging;
    }

    public void overScrollBy(int deltaX, int deltaY) {
        this.scrollBy(deltaX, deltaY);
    }

    private void scrollBy(int deltaX, int deltaY) {
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        int scrollX = this.mDelegate.getContainerViewScrollX();
        int scrollY = this.mDelegate.getContainerViewScrollY();
        int scrollRangeX = this.computeMaximumHorizontalScrollOffset();
        int scrollRangeY = this.computeMaximumVerticalScrollOffset();
        this.mDelegate.overScrollContainerViewBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, this.mProcessingTouchEvent);
    }

    private int clampHorizontalScroll(int scrollX) {
        scrollX = Math.max(0, scrollX);
        scrollX = Math.min(this.computeMaximumHorizontalScrollOffset(), scrollX);
        return scrollX;
    }

    private int clampVerticalScroll(int scrollY) {
        scrollY = Math.max(0, scrollY);
        scrollY = Math.min(this.computeMaximumVerticalScrollOffset(), scrollY);
        return scrollY;
    }

    public void onContainerViewOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        scrollX = this.clampHorizontalScroll(scrollX);
        scrollY = this.clampVerticalScroll(scrollY);
        this.mDelegate.scrollContainerViewTo(scrollX, scrollY);
        this.scrollNativeTo(this.mDelegate.getContainerViewScrollX(), this.mDelegate.getContainerViewScrollY());
    }

    public void onContainerViewScrollChanged(int x, int y) {
        this.scrollNativeTo(x, y);
    }

    private void scrollNativeTo(int x, int y) {
        x = this.clampHorizontalScroll(x);
        y = this.clampVerticalScroll(y);
        if (this.mProcessingTouchEvent) {
            this.mDeferredNativeScrollX = x;
            this.mDeferredNativeScrollY = y;
            this.mApplyDeferredNativeScroll = true;
            return;
        }
        if (x == this.mNativeScrollX && y == this.mNativeScrollY) {
            return;
        }
        this.mNativeScrollX = x;
        this.mNativeScrollY = y;
        this.mDelegate.scrollNativeTo(x, y);
    }

    public void onFlingStartGesture(int velocityX, int velocityY) {
        this.mLastFlingVelocityX = velocityX;
        this.mLastFlingVelocityY = velocityY;
    }

    public void onFlingCancelGesture() {
        this.mScroller.forceFinished(true);
    }

    public void onUnhandledFlingStartEvent() {
        this.flingScroll(-this.mLastFlingVelocityX, -this.mLastFlingVelocityY);
    }

    public void flingScroll(int velocityX, int velocityY) {
        int scrollX = this.mDelegate.getContainerViewScrollX();
        int scrollY = this.mDelegate.getContainerViewScrollY();
        int scrollRangeX = this.computeMaximumHorizontalScrollOffset();
        int scrollRangeY = this.computeMaximumVerticalScrollOffset();
        this.mScroller.fling(scrollX, scrollY, velocityX, velocityY, 0, scrollRangeX, 0, scrollRangeY);
        this.mFlinging = true;
        this.mDelegate.invalidate();
    }

    public void computeScrollAndAbsorbGlow(OverScrollGlow overScrollGlow) {
        boolean stillAnimating = this.mScroller.computeScrollOffset();
        if (!stillAnimating) {
            this.mFlinging = false;
            return;
        }
        int oldX = this.mDelegate.getContainerViewScrollX();
        int oldY = this.mDelegate.getContainerViewScrollY();
        int x = this.mScroller.getCurrX();
        int y = this.mScroller.getCurrY();
        int scrollRangeX = this.computeMaximumHorizontalScrollOffset();
        int scrollRangeY = this.computeMaximumVerticalScrollOffset();
        if (overScrollGlow != null) {
            overScrollGlow.absorbGlow(x, y, oldX, oldY, scrollRangeX, scrollRangeY, this.mScroller.getCurrVelocity());
        }
        this.scrollBy(x - oldX, y - oldY);
        this.mDelegate.invalidate();
    }

    private static int computeDurationInMilliSec(int dx, int dy) {
        int distance = Math.max(Math.abs(dx), Math.abs(dy));
        int duration = distance * 1000 / 480;
        return Math.min(duration, 750);
    }

    private boolean animateScrollTo(int x, int y) {
        int scrollX = this.mDelegate.getContainerViewScrollX();
        int scrollY = this.mDelegate.getContainerViewScrollY();
        x = this.clampHorizontalScroll(x);
        y = this.clampVerticalScroll(y);
        int dx = x - scrollX;
        int dy = y - scrollY;
        if (dx == 0 && dy == 0) {
            return false;
        }
        this.mScroller.startScroll(scrollX, scrollY, dx, dy, AwScrollOffsetManager.computeDurationInMilliSec(dx, dy));
        this.mDelegate.invalidate();
        return true;
    }

    public boolean pageUp(boolean top) {
        int scrollX = this.mDelegate.getContainerViewScrollX();
        int scrollY = this.mDelegate.getContainerViewScrollY();
        if (top) {
            return this.animateScrollTo(scrollX, 0);
        }
        int dy = -this.mContainerViewHeight / 2;
        if (this.mContainerViewHeight > 48) {
            dy = -this.mContainerViewHeight + 24;
        }
        return this.animateScrollTo(scrollX, scrollY + dy);
    }

    public boolean pageDown(boolean bottom) {
        int scrollX = this.mDelegate.getContainerViewScrollX();
        int scrollY = this.mDelegate.getContainerViewScrollY();
        if (bottom) {
            return this.animateScrollTo(scrollX, this.computeVerticalScrollRange());
        }
        int dy = this.mContainerViewHeight / 2;
        if (this.mContainerViewHeight > 48) {
            dy = this.mContainerViewHeight - 24;
        }
        return this.animateScrollTo(scrollX, scrollY + dy);
    }

    public boolean requestChildRectangleOnScreen(int childOffsetX, int childOffsetY, Rect rect, boolean immediate) {
        int scrollX = this.mDelegate.getContainerViewScrollX();
        int scrollY = this.mDelegate.getContainerViewScrollY();
        rect.offset(childOffsetX, childOffsetY);
        int screenTop = scrollY;
        int screenBottom = scrollY + this.mContainerViewHeight;
        int scrollYDelta = 0;
        if (rect.bottom > screenBottom) {
            int oneThirdOfScreenHeight = this.mContainerViewHeight / 3;
            scrollYDelta = rect.width() > 2 * oneThirdOfScreenHeight ? rect.top - screenTop : rect.top - (screenTop + oneThirdOfScreenHeight);
        } else if (rect.top < screenTop) {
            scrollYDelta = rect.top - screenTop;
        }
        int screenLeft = scrollX;
        int screenRight = scrollX + this.mContainerViewWidth;
        int scrollXDelta = 0;
        if (rect.right > screenRight && rect.left > screenLeft) {
            scrollXDelta = rect.width() > this.mContainerViewWidth ? (scrollXDelta += rect.left - screenLeft) : (scrollXDelta += rect.right - screenRight);
        } else if (rect.left < screenLeft) {
            scrollXDelta -= screenLeft - rect.left;
        }
        if (scrollYDelta == 0 && scrollXDelta == 0) {
            return false;
        }
        if (immediate) {
            this.scrollBy(scrollXDelta, scrollYDelta);
            return true;
        }
        return this.animateScrollTo(scrollX + scrollXDelta, scrollY + scrollYDelta);
    }

    public static interface Delegate {
        public void overScrollContainerViewBy(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

        public void scrollContainerViewTo(int var1, int var2);

        public void scrollNativeTo(int var1, int var2);

        public int getContainerViewScrollX();

        public int getContainerViewScrollY();

        public void invalidate();
    }
}

