/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser;

import android.content.Context;
import com.android.org.chromium.base.CalledByNative;
import com.android.org.chromium.base.JNINamespace;
import com.android.org.chromium.content.browser.ContentViewCore;
import com.android.org.chromium.content.browser.ContentViewDownloadDelegate;

@JNINamespace(value="content")
public class DownloadController {
    private static final String LOGTAG = "DownloadController";
    private static DownloadController sInstance;
    private static DownloadNotificationService sDownloadNotificationService;

    @CalledByNative
    public static DownloadController getInstance() {
        if (sInstance == null) {
            sInstance = new DownloadController();
        }
        return sInstance;
    }

    private DownloadController() {
        this.nativeInit();
    }

    private static ContentViewDownloadDelegate downloadDelegateFromView(ContentViewCore view) {
        return view.getDownloadDelegate();
    }

    public static void setDownloadNotificationService(DownloadNotificationService service) {
        sDownloadNotificationService = service;
    }

    @CalledByNative
    public void newHttpGetDownload(ContentViewCore view, String url, String userAgent, String contentDisposition, String mimetype, String cookie, String referer, long contentLength) {
        ContentViewDownloadDelegate downloadDelagate = DownloadController.downloadDelegateFromView(view);
        if (downloadDelagate != null) {
            downloadDelagate.requestHttpGetDownload(url, userAgent, contentDisposition, mimetype, cookie, referer, contentLength);
        }
    }

    @CalledByNative
    public void onDownloadStarted(ContentViewCore view, String filename, String mimeType) {
        ContentViewDownloadDelegate downloadDelagate = DownloadController.downloadDelegateFromView(view);
        if (downloadDelagate != null) {
            downloadDelagate.onDownloadStarted(filename, mimeType);
        }
    }

    @CalledByNative
    public void onDownloadCompleted(Context context, String url, String mimetype, String filename, String path, long contentLength, boolean successful) {
        if (sDownloadNotificationService != null) {
            sDownloadNotificationService.onDownloadCompleted(context, url, mimetype, path, filename, contentLength, successful);
        }
    }

    @CalledByNative
    public void onDangerousDownload(ContentViewCore view, String filename, int downloadId) {
        ContentViewDownloadDelegate downloadDelagate = DownloadController.downloadDelegateFromView(view);
        if (downloadDelagate != null) {
            downloadDelagate.onDangerousDownload(filename, downloadId);
        }
    }

    private native void nativeInit();

    public static interface DownloadNotificationService {
        public void onDownloadCompleted(Context var1, String var2, String var3, String var4, String var5, long var6, boolean var8);
    }
}

