/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.input;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.widget.PopupWindow;
import com.android.org.chromium.content.browser.input.CursorController;
import com.android.org.chromium.content.browser.input.InsertionHandleController;

public class HandleView
extends View {
    private static final float FADE_DURATION = 200.0f;
    private Drawable mDrawable;
    private final PopupWindow mContainer;
    private int mPositionX;
    private int mPositionY;
    private final CursorController mController;
    private boolean mIsDragging;
    private float mTouchToWindowOffsetX;
    private float mTouchToWindowOffsetY;
    private float mHotspotX;
    private float mHotspotY;
    private int mLineOffsetY;
    private int mLastParentX;
    private int mLastParentY;
    private float mDownPositionX;
    private float mDownPositionY;
    private int mContainerPositionX;
    private int mContainerPositionY;
    private long mTouchTimer;
    private boolean mIsInsertionHandle = false;
    private float mAlpha;
    private long mFadeStartTime;
    private View mParent;
    private InsertionHandleController.PastePopupMenu mPastePopupWindow;
    private final int mTextSelectHandleLeftRes;
    private final int mTextSelectHandleRightRes;
    private final int mTextSelectHandleRes;
    private Drawable mSelectHandleLeft;
    private Drawable mSelectHandleRight;
    private Drawable mSelectHandleCenter;
    private final int[] mTempCoords = new int[2];
    private final Rect mTempRect = new Rect();
    static final int LEFT = 0;
    static final int CENTER = 1;
    static final int RIGHT = 2;
    private static final float LINE_OFFSET_Y_DIP = 5.0f;
    private static final int[] TEXT_VIEW_HANDLE_ATTRS = new int[]{16843461, 16843463, 16843462};

    HandleView(CursorController controller, int pos, View parent) {
        super(parent.getContext());
        Context context = parent.getContext();
        this.mParent = parent;
        this.mController = controller;
        this.mContainer = new PopupWindow(context, null, 16843464);
        this.mContainer.setSplitTouchEnabled(true);
        this.mContainer.setClippingEnabled(false);
        TypedArray a = context.obtainStyledAttributes(TEXT_VIEW_HANDLE_ATTRS);
        this.mTextSelectHandleLeftRes = a.getResourceId(a.getIndex(0), 0);
        this.mTextSelectHandleRes = a.getResourceId(a.getIndex(1), 0);
        this.mTextSelectHandleRightRes = a.getResourceId(a.getIndex(2), 0);
        a.recycle();
        this.setOrientation(pos);
        this.mLineOffsetY = (int)TypedValue.applyDimension(1, 5.0f, context.getResources().getDisplayMetrics());
        this.mAlpha = 1.0f;
    }

    void setOrientation(int pos) {
        switch (pos) {
            case 0: {
                if (this.mSelectHandleLeft == null) {
                    this.mSelectHandleLeft = this.getContext().getResources().getDrawable(this.mTextSelectHandleLeftRes);
                }
                this.mDrawable = this.mSelectHandleLeft;
                int handleWidth = this.mDrawable.getIntrinsicWidth();
                this.mHotspotX = (float)(handleWidth * 3) / 4.0f;
                break;
            }
            case 2: {
                if (this.mSelectHandleRight == null) {
                    this.mSelectHandleRight = this.getContext().getResources().getDrawable(this.mTextSelectHandleRightRes);
                }
                this.mDrawable = this.mSelectHandleRight;
                int handleWidth = this.mDrawable.getIntrinsicWidth();
                this.mHotspotX = (float)handleWidth / 4.0f;
                break;
            }
            default: {
                if (this.mSelectHandleCenter == null) {
                    this.mSelectHandleCenter = this.getContext().getResources().getDrawable(this.mTextSelectHandleRes);
                }
                this.mDrawable = this.mSelectHandleCenter;
                int handleWidth = this.mDrawable.getIntrinsicWidth();
                this.mHotspotX = (float)handleWidth / 2.0f;
                this.mIsInsertionHandle = true;
            }
        }
        this.mHotspotY = 0.0f;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
    }

    private void updateContainerPosition() {
        int[] coords = this.mTempCoords;
        this.mParent.getLocationInWindow(coords);
        this.mContainerPositionX = coords[0] + this.mPositionX;
        this.mContainerPositionY = coords[1] + this.mPositionY;
    }

    void show() {
        if (!this.isPositionVisible()) {
            this.hide();
            return;
        }
        this.mContainer.setContentView(this);
        this.updateContainerPosition();
        this.mContainer.showAtLocation(this.mParent, 0, this.mContainerPositionX, this.mContainerPositionY);
        if (this.mPastePopupWindow != null) {
            this.mPastePopupWindow.hide();
        }
    }

    void hide() {
        this.mIsDragging = false;
        this.mContainer.dismiss();
        if (this.mPastePopupWindow != null) {
            this.mPastePopupWindow.hide();
        }
    }

    boolean isShowing() {
        return this.mContainer.isShowing();
    }

    private boolean isPositionVisible() {
        if (this.mIsDragging) {
            return true;
        }
        Rect clip = this.mTempRect;
        clip.left = 0;
        clip.top = 0;
        clip.right = this.mParent.getWidth();
        clip.bottom = this.mParent.getHeight();
        ViewParent parent = this.mParent.getParent();
        if (parent == null || !parent.getChildVisibleRect(this.mParent, clip, null)) {
            return false;
        }
        int[] coords = this.mTempCoords;
        this.mParent.getLocationInWindow(coords);
        int posX = coords[0] + this.mPositionX + (int)this.mHotspotX;
        int posY = coords[1] + this.mPositionY + (int)this.mHotspotY;
        return posX >= clip.left && posX <= clip.right && posY >= clip.top && posY <= clip.bottom;
    }

    void moveTo(int x, int y) {
        this.mPositionX = x;
        this.mPositionY = y;
        if (this.isPositionVisible()) {
            int[] coords = null;
            if (this.mContainer.isShowing()) {
                coords = this.mTempCoords;
                this.mParent.getLocationInWindow(coords);
                int containerPositionX = coords[0] + this.mPositionX;
                int containerPositionY = coords[1] + this.mPositionY;
                if (containerPositionX != this.mContainerPositionX || containerPositionY != this.mContainerPositionY) {
                    this.mContainerPositionX = containerPositionX;
                    this.mContainerPositionY = containerPositionY;
                    this.mContainer.update(this.mContainerPositionX, this.mContainerPositionY, this.getRight() - this.getLeft(), this.getBottom() - this.getTop());
                    if (this.mPastePopupWindow != null) {
                        this.mPastePopupWindow.hide();
                    }
                }
            } else {
                this.show();
            }
            if (this.mIsDragging) {
                if (coords == null) {
                    coords = this.mTempCoords;
                    this.mParent.getLocationInWindow(coords);
                }
                if (coords[0] != this.mLastParentX || coords[1] != this.mLastParentY) {
                    this.mTouchToWindowOffsetX += (float)(coords[0] - this.mLastParentX);
                    this.mTouchToWindowOffsetY += (float)(coords[1] - this.mLastParentY);
                    this.mLastParentX = coords[0];
                    this.mLastParentY = coords[1];
                }
                if (this.mPastePopupWindow != null) {
                    this.mPastePopupWindow.hide();
                }
            }
        } else {
            this.hide();
        }
    }

    protected void onDraw(Canvas c) {
        this.updateAlpha();
        this.updateContainerPosition();
        this.mContainer.update(this.mContainerPositionX, this.mContainerPositionY, this.getRight() - this.getLeft(), this.getBottom() - this.getTop());
        this.mDrawable.setBounds(0, 0, this.getRight() - this.getLeft(), this.getBottom() - this.getTop());
        this.mDrawable.draw(c);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getActionMasked()) {
            case 0: {
                this.mDownPositionX = ev.getRawX();
                this.mDownPositionY = ev.getRawY();
                this.mTouchToWindowOffsetX = this.mDownPositionX - (float)this.mPositionX;
                this.mTouchToWindowOffsetY = this.mDownPositionY - (float)this.mPositionY;
                int[] coords = this.mTempCoords;
                this.mParent.getLocationInWindow(coords);
                this.mLastParentX = coords[0];
                this.mLastParentY = coords[1];
                this.mIsDragging = true;
                this.mController.beforeStartUpdatingPosition(this);
                this.mTouchTimer = SystemClock.uptimeMillis();
                break;
            }
            case 2: {
                this.updatePosition(ev.getRawX(), ev.getRawY());
                break;
            }
            case 1: {
                long delay;
                if (this.mIsInsertionHandle && (delay = SystemClock.uptimeMillis() - this.mTouchTimer) < (long)ViewConfiguration.getTapTimeout()) {
                    if (this.mPastePopupWindow != null && this.mPastePopupWindow.isShowing()) {
                        this.mPastePopupWindow.hide();
                    } else {
                        this.showPastePopupWindow();
                    }
                }
                this.mIsDragging = false;
                break;
            }
            case 3: {
                this.mIsDragging = false;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    boolean isDragging() {
        return this.mIsDragging;
    }

    int getPositionX() {
        return this.mPositionX;
    }

    int getPositionY() {
        return this.mPositionY;
    }

    private void updatePosition(float rawX, float rawY) {
        float newPosX = rawX - this.mTouchToWindowOffsetX + this.mHotspotX;
        float newPosY = rawY - this.mTouchToWindowOffsetY + this.mHotspotY - (float)this.mLineOffsetY;
        this.mController.updatePosition(this, Math.round(newPosX), Math.round(newPosY));
    }

    void positionAt(int x, int y) {
        this.moveTo((int)((float)x - this.mHotspotX), (int)((float)y - this.mHotspotY));
    }

    int getAdjustedPositionX() {
        return (int)((float)this.mPositionX + this.mHotspotX);
    }

    int getAdjustedPositionY() {
        return (int)((float)this.mPositionY + this.mHotspotY);
    }

    int getLineAdjustedPositionY() {
        return (int)((float)this.mPositionY + this.mHotspotY - (float)this.mLineOffsetY);
    }

    Drawable getDrawable() {
        return this.mDrawable;
    }

    private void updateAlpha() {
        if (this.mAlpha == 1.0f) {
            return;
        }
        this.mAlpha = Math.min(1.0f, (float)(System.currentTimeMillis() - this.mFadeStartTime) / 200.0f);
        this.mDrawable.setAlpha((int)(255.0f * this.mAlpha));
        this.invalidate();
    }

    void beginFadeIn() {
        if (this.getVisibility() == 0) {
            return;
        }
        this.mAlpha = 0.0f;
        this.mFadeStartTime = System.currentTimeMillis();
        this.setVisibility(0);
    }

    void showPastePopupWindow() {
        InsertionHandleController ihc = (InsertionHandleController)this.mController;
        if (this.mIsInsertionHandle && ihc.canPaste()) {
            if (this.mPastePopupWindow == null) {
                this.mPastePopupWindow = new InsertionHandleController.PastePopupMenu(ihc);
            }
            this.mPastePopupWindow.show();
        }
    }
}

