/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.content.browser.input;

import android.app.TimePickerDialog;
import android.content.Context;
import android.text.format.Time;
import android.widget.TimePicker;

public class TimeDialog
extends TimePickerDialog {
    private Time mMinTime;
    private Time mMaxTime;

    public static TimeDialog create(Context context, TimePickerDialog.OnTimeSetListener callBack, int hour, int minute, boolean is24HourView, long min, long max) {
        Time time = TimeDialog.getBoundedTime(hour, minute, min, max);
        return new TimeDialog(context, callBack, time.hour, time.minute, is24HourView, min, max);
    }

    private TimeDialog(Context context, TimePickerDialog.OnTimeSetListener callBack, int hourOfDay, int minute, boolean is24HourView, long min, long max) {
        super(context, callBack, hourOfDay, minute, is24HourView);
        if (min >= max) {
            this.mMinTime = TimeDialog.getTimeForHourAndMinute(0, 0);
            this.mMaxTime = TimeDialog.getTimeForHourAndMinute(23, 59);
        } else {
            this.mMinTime = TimeDialog.getTimeForMillis(min);
            this.mMaxTime = TimeDialog.getTimeForMillis(max);
        }
    }

    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        Time time = TimeDialog.getBoundedTime(hourOfDay, minute, this.mMinTime.toMillis(true), this.mMaxTime.toMillis(true));
        super.onTimeChanged(view, time.hour, time.minute);
        this.updateTime(time.hour, time.minute);
    }

    private static Time getBoundedTime(int hour, int minute, long min, long max) {
        Time time = TimeDialog.getTimeForHourAndMinute(hour, minute);
        if (time.toMillis(true) < min) {
            return TimeDialog.getTimeForMillis(min);
        }
        if (time.toMillis(true) > max) {
            return TimeDialog.getTimeForMillis(max);
        }
        return time;
    }

    private static Time getTimeForMillis(long millis) {
        Time time = new Time("GMT");
        time.set(millis);
        return time;
    }

    private static Time getTimeForHourAndMinute(int hour, int minute) {
        Time time = new Time("GMT");
        time.set(0, minute, hour, 1, 0, 1970);
        return time;
    }
}

