/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.chromium.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.android.org.chromium.ui.ColorPickerAdvanced;
import com.android.org.chromium.ui.ColorPickerSimple;
import com.android.org.chromium.ui.OnColorChangedListener;
import com.android.org.chromium.ui.R;

public class ColorPickerDialog
extends AlertDialog
implements OnColorChangedListener {
    private final ColorPickerAdvanced mAdvancedColorPicker;
    private final ColorPickerSimple mSimpleColorPicker;
    private final Button mMoreButton;
    private final View mCurrentColorView;
    private final OnColorChangedListener mListener;
    private final int mInitialColor;
    private int mCurrentColor;

    public ColorPickerDialog(Context context, OnColorChangedListener listener, int color2) {
        super(context, 0);
        this.mListener = listener;
        this.mCurrentColor = this.mInitialColor = color2;
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View title = inflater.inflate(R.layout.color_picker_dialog_title, null);
        this.setCustomTitle(title);
        this.mCurrentColorView = title.findViewById(R.id.selected_color_view);
        TextView titleText = (TextView)title.findViewById(R.id.title);
        titleText.setText(R.string.color_picker_dialog_title);
        String positiveButtonText = context.getString(R.string.color_picker_button_set);
        this.setButton(-1, (CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                ColorPickerDialog.this.tryNotifyColorSet(ColorPickerDialog.this.mCurrentColor);
            }
        });
        String negativeButtonText = context.getString(R.string.color_picker_button_cancel);
        this.setButton(-2, (CharSequence)negativeButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                ColorPickerDialog.this.tryNotifyColorSet(ColorPickerDialog.this.mInitialColor);
            }
        });
        this.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface arg0) {
                ColorPickerDialog.this.tryNotifyColorSet(ColorPickerDialog.this.mInitialColor);
            }
        });
        View content = inflater.inflate(R.layout.color_picker_dialog_content, null);
        this.setView(content);
        this.mMoreButton = (Button)content.findViewById(R.id.more_colors_button);
        this.mMoreButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ColorPickerDialog.this.showAdvancedView();
            }
        });
        this.mAdvancedColorPicker = (ColorPickerAdvanced)content.findViewById(R.id.color_picker_advanced);
        this.mAdvancedColorPicker.setVisibility(8);
        this.mSimpleColorPicker = (ColorPickerSimple)content.findViewById(R.id.color_picker_simple);
        this.mSimpleColorPicker.init(this);
        this.updateCurrentColor(this.mInitialColor);
    }

    public void onColorChanged(int color2) {
        this.updateCurrentColor(color2);
    }

    private void showAdvancedView() {
        View buttonBorder = this.findViewById(R.id.more_colors_button_border);
        buttonBorder.setVisibility(8);
        View simpleViewBorder = this.findViewById(R.id.color_picker_simple_border);
        simpleViewBorder.setVisibility(8);
        this.mAdvancedColorPicker.setVisibility(0);
        this.mAdvancedColorPicker.setListener(this);
        this.mAdvancedColorPicker.setColor(this.mCurrentColor);
    }

    private void tryNotifyColorSet(int color2) {
        if (this.mListener != null) {
            this.mListener.onColorChanged(color2);
        }
    }

    private void updateCurrentColor(int color2) {
        this.mCurrentColor = color2;
        if (this.mCurrentColorView != null) {
            this.mCurrentColorView.setBackgroundColor(color2);
        }
    }
}

