/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import android.util.Slog;
import java.io.FileNotFoundException;
import java.io.FileReader;

final class DockObserver
extends UEventObserver {
    private static final String TAG = DockObserver.class.getSimpleName();
    private static final String DOCK_UEVENT_MATCH = "DEVPATH=/devices/virtual/switch/dock";
    private static final String DOCK_STATE_PATH = "/sys/class/switch/dock/state";
    private static final int MSG_DOCK_STATE_CHANGED = 0;
    private final Object mLock = new Object();
    private int mDockState = 0;
    private int mPreviousDockState = 0;
    private boolean mSystemReady;
    private final Context mContext;
    private final PowerManager mPowerManager;
    private final PowerManager.WakeLock mWakeLock;
    private final Handler mHandler = new Handler(true){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    DockObserver.this.handleDockStateChange();
                }
            }
        }
    };

    public DockObserver(Context context) {
        this.mContext = context;
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = this.mPowerManager.newWakeLock(1, TAG);
        this.init();
        this.startObserving(DOCK_UEVENT_MATCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUEvent(UEventObserver.UEvent event) {
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "Dock UEVENT: " + event.toString());
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                int newState = Integer.parseInt(event.get("SWITCH_STATE"));
                if (newState != this.mDockState) {
                    this.mPreviousDockState = this.mDockState;
                    this.mDockState = newState;
                    if (this.mSystemReady) {
                        this.mPowerManager.wakeUp(SystemClock.uptimeMillis());
                        this.updateLocked();
                    }
                }
            }
            catch (NumberFormatException e) {
                Slog.e(TAG, "Could not parse switch state from event " + event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                char[] buffer = new char[1024];
                FileReader file = new FileReader(DOCK_STATE_PATH);
                try {
                    int len = file.read(buffer, 0, 1024);
                    this.mPreviousDockState = this.mDockState = Integer.valueOf(new String(buffer, 0, len).trim()).intValue();
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    file.close();
                    throw throwable;
                }
                file.close();
                {
                }
            }
            catch (FileNotFoundException e) {
                Slog.w(TAG, "This kernel does not have dock station support");
            }
            catch (Exception e) {
                Slog.e(TAG, "", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDockState != 0) {
                this.updateLocked();
            }
            this.mSystemReady = true;
        }
    }

    private void updateLocked() {
        this.mWakeLock.acquire();
        this.mHandler.sendEmptyMessage(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDockStateChange() {
        Object object = this.mLock;
        synchronized (object) {
            Slog.i(TAG, "Dock state changed: " + this.mDockState);
            ContentResolver cr = this.mContext.getContentResolver();
            if (Settings.Global.getInt(cr, "device_provisioned", 0) == 0) {
                Slog.i(TAG, "Device not provisioned, skipping dock broadcast");
                return;
            }
            Intent intent = new Intent("android.intent.action.DOCK_EVENT");
            intent.addFlags(0x20000000);
            intent.putExtra("android.intent.extra.DOCK_STATE", this.mDockState);
            if (Settings.Global.getInt(cr, "dock_sounds_enabled", 1) == 1) {
                Ringtone sfx;
                Uri soundUri;
                String soundPath;
                String whichSound = null;
                if (this.mDockState == 0) {
                    if (this.mPreviousDockState == 1 || this.mPreviousDockState == 3 || this.mPreviousDockState == 4) {
                        whichSound = "desk_undock_sound";
                    } else if (this.mPreviousDockState == 2) {
                        whichSound = "car_undock_sound";
                    }
                } else if (this.mDockState == 1 || this.mDockState == 3 || this.mDockState == 4) {
                    whichSound = "desk_dock_sound";
                } else if (this.mDockState == 2) {
                    whichSound = "car_dock_sound";
                }
                if (whichSound != null && (soundPath = Settings.Global.getString(cr, whichSound)) != null && (soundUri = Uri.parse("file://" + soundPath)) != null && (sfx = RingtoneManager.getRingtone(this.mContext, soundUri)) != null) {
                    sfx.setStreamType(1);
                    sfx.play();
                }
            }
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            this.mWakeLock.release();
        }
    }
}

