/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Slog;
import com.android.server.BatteryService;
import com.android.server.EventLogTags;

public class IdleMaintenanceService
extends BroadcastReceiver {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = IdleMaintenanceService.class.getSimpleName();
    private static final int LAST_USER_ACTIVITY_TIME_INVALID = -1;
    private static final long MIN_IDLE_MAINTENANCE_INTERVAL_MILLIS = 86400000L;
    private static final int MIN_BATTERY_LEVEL_IDLE_MAINTENANCE_START_CHARGING = 30;
    private static final int MIN_BATTERY_LEVEL_IDLE_MAINTENANCE_START_NOT_CHARGING = 80;
    private static final int MIN_BATTERY_LEVEL_IDLE_MAINTENANCE_RUNNING = 20;
    private static final long MIN_USER_INACTIVITY_IDLE_MAINTENANCE_START = 4260000L;
    private static final long MAX_IDLE_MAINTENANCE_DURATION = 4260000L;
    private static final String ACTION_UPDATE_IDLE_MAINTENANCE_STATE = "com.android.server.IdleMaintenanceService.action.UPDATE_IDLE_MAINTENANCE_STATE";
    private static final String ACTION_FORCE_IDLE_MAINTENANCE = "com.android.server.IdleMaintenanceService.action.FORCE_IDLE_MAINTENANCE";
    private static final Intent sIdleMaintenanceStartIntent = new Intent("android.intent.action.ACTION_IDLE_MAINTENANCE_START");
    private static final Intent sIdleMaintenanceEndIntent;
    private final AlarmManager mAlarmService;
    private final BatteryService mBatteryService;
    private final PendingIntent mUpdateIdleMaintenanceStatePendingIntent;
    private final Context mContext;
    private final PowerManager.WakeLock mWakeLock;
    private final Handler mHandler;
    private long mLastIdleMaintenanceStartTimeMillis;
    private long mLastUserActivityElapsedTimeMillis = -1L;
    private boolean mIdleMaintenanceStarted;

    public IdleMaintenanceService(Context context, BatteryService batteryService) {
        this.mContext = context;
        this.mBatteryService = batteryService;
        this.mAlarmService = (AlarmManager)context.getSystemService("alarm");
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, LOG_TAG);
        this.mHandler = new Handler(this.mContext.getMainLooper());
        Intent intent = new Intent(ACTION_UPDATE_IDLE_MAINTENANCE_STATE);
        intent.setFlags(0x40000000);
        this.mUpdateIdleMaintenanceStatePendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
        this.register(this.mHandler);
    }

    public void register(Handler handler) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION_UPDATE_IDLE_MAINTENANCE_STATE);
        intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.DREAMING_STARTED");
        intentFilter.addAction("android.intent.action.DREAMING_STOPPED");
        this.mContext.registerReceiverAsUser(this, UserHandle.ALL, intentFilter, null, this.mHandler);
        intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION_FORCE_IDLE_MAINTENANCE);
        this.mContext.registerReceiverAsUser(this, UserHandle.ALL, intentFilter, "android.permission.SET_ACTIVITY_WATCHER", this.mHandler);
    }

    private void scheduleUpdateIdleMaintenanceState(long delayMillis) {
        long triggetRealTimeMillis = SystemClock.elapsedRealtime() + delayMillis;
        this.mAlarmService.set(2, triggetRealTimeMillis, this.mUpdateIdleMaintenanceStatePendingIntent);
    }

    private void unscheduleUpdateIdleMaintenanceState() {
        this.mAlarmService.cancel(this.mUpdateIdleMaintenanceStatePendingIntent);
    }

    private void updateIdleMaintenanceState(boolean noisy) {
        if (this.mIdleMaintenanceStarted) {
            if (!this.lastUserActivityPermitsIdleMaintenanceRunning() || !this.batteryLevelAndMaintenanceTimeoutPermitsIdleMaintenanceRunning()) {
                this.unscheduleUpdateIdleMaintenanceState();
                this.mIdleMaintenanceStarted = false;
                EventLogTags.writeIdleMaintenanceWindowFinish(SystemClock.elapsedRealtime(), this.mLastUserActivityElapsedTimeMillis, this.mBatteryService.getBatteryLevel(), this.isBatteryCharging() ? 1 : 0);
                this.sendIdleMaintenanceEndIntent();
                if (!this.batteryLevelAndMaintenanceTimeoutPermitsIdleMaintenanceRunning()) {
                    this.scheduleUpdateIdleMaintenanceState(this.getNextIdleMaintenanceIntervalStartFromNow());
                }
            }
        } else if (this.deviceStatePermitsIdleMaintenanceStart(noisy) && this.lastUserActivityPermitsIdleMaintenanceStart(noisy) && this.lastRunPermitsIdleMaintenanceStart(noisy)) {
            this.scheduleUpdateIdleMaintenanceState(4260000L);
            this.mIdleMaintenanceStarted = true;
            EventLogTags.writeIdleMaintenanceWindowStart(SystemClock.elapsedRealtime(), this.mLastUserActivityElapsedTimeMillis, this.mBatteryService.getBatteryLevel(), this.isBatteryCharging() ? 1 : 0);
            this.mLastIdleMaintenanceStartTimeMillis = SystemClock.elapsedRealtime();
            this.sendIdleMaintenanceStartIntent();
        } else if (this.lastUserActivityPermitsIdleMaintenanceStart(noisy)) {
            if (this.lastRunPermitsIdleMaintenanceStart(noisy)) {
                this.scheduleUpdateIdleMaintenanceState(4260000L);
            } else {
                this.scheduleUpdateIdleMaintenanceState(this.getNextIdleMaintenanceIntervalStartFromNow());
            }
        }
    }

    private long getNextIdleMaintenanceIntervalStartFromNow() {
        return this.mLastIdleMaintenanceStartTimeMillis + 86400000L - SystemClock.elapsedRealtime();
    }

    private void sendIdleMaintenanceStartIntent() {
        this.mWakeLock.acquire();
        try {
            ActivityManagerNative.getDefault().performIdleMaintenance();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mContext.sendOrderedBroadcastAsUser(sIdleMaintenanceStartIntent, UserHandle.ALL, null, this, this.mHandler, -1, null, null);
    }

    private void sendIdleMaintenanceEndIntent() {
        this.mWakeLock.acquire();
        this.mContext.sendOrderedBroadcastAsUser(sIdleMaintenanceEndIntent, UserHandle.ALL, null, this, this.mHandler, -1, null, null);
    }

    private boolean deviceStatePermitsIdleMaintenanceStart(boolean noisy) {
        boolean allowed;
        int minBatteryLevel = this.isBatteryCharging() ? 30 : 80;
        boolean bl = allowed = this.mLastUserActivityElapsedTimeMillis != -1L && this.mBatteryService.getBatteryLevel() > minBatteryLevel;
        if (!allowed && noisy) {
            Slog.i("IdleMaintenance", "Idle maintenance not allowed due to power");
        }
        return allowed;
    }

    private boolean lastUserActivityPermitsIdleMaintenanceStart(boolean noisy) {
        boolean allowed;
        boolean bl = allowed = this.mLastUserActivityElapsedTimeMillis != -1L && SystemClock.elapsedRealtime() - this.mLastUserActivityElapsedTimeMillis > 4260000L;
        if (!allowed && noisy) {
            Slog.i("IdleMaintenance", "Idle maintenance not allowed due to last user activity");
        }
        return allowed;
    }

    private boolean lastRunPermitsIdleMaintenanceStart(boolean noisy) {
        boolean allowed;
        boolean bl = allowed = SystemClock.elapsedRealtime() - this.mLastIdleMaintenanceStartTimeMillis > 86400000L;
        if (!allowed && noisy) {
            Slog.i("IdleMaintenance", "Idle maintenance not allowed due time since last");
        }
        return allowed;
    }

    private boolean lastUserActivityPermitsIdleMaintenanceRunning() {
        return this.mLastUserActivityElapsedTimeMillis != -1L;
    }

    private boolean batteryLevelAndMaintenanceTimeoutPermitsIdleMaintenanceRunning() {
        return this.mBatteryService.getBatteryLevel() > 20 && this.mLastIdleMaintenanceStartTimeMillis + 4260000L > SystemClock.elapsedRealtime();
    }

    private boolean isBatteryCharging() {
        return this.mBatteryService.getPlugType() > 0 && this.mBatteryService.getInvalidCharger() == 0;
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("android.intent.action.BATTERY_CHANGED".equals(action)) {
            if (this.mIdleMaintenanceStarted) {
                this.updateIdleMaintenanceState(false);
            }
        } else if ("android.intent.action.SCREEN_ON".equals(action) || "android.intent.action.DREAMING_STOPPED".equals(action)) {
            this.mLastUserActivityElapsedTimeMillis = -1L;
            this.unscheduleUpdateIdleMaintenanceState();
            this.updateIdleMaintenanceState(false);
        } else if ("android.intent.action.SCREEN_OFF".equals(action) || "android.intent.action.DREAMING_STARTED".equals(action)) {
            this.mLastUserActivityElapsedTimeMillis = SystemClock.elapsedRealtime();
            this.scheduleUpdateIdleMaintenanceState(4260000L);
        } else if (ACTION_UPDATE_IDLE_MAINTENANCE_STATE.equals(action)) {
            this.updateIdleMaintenanceState(false);
        } else if (ACTION_FORCE_IDLE_MAINTENANCE.equals(action)) {
            long now = SystemClock.elapsedRealtime() - 1L;
            this.mLastUserActivityElapsedTimeMillis = now - 4260000L;
            this.mLastIdleMaintenanceStartTimeMillis = now - 86400000L;
            this.updateIdleMaintenanceState(true);
        } else if ("android.intent.action.ACTION_IDLE_MAINTENANCE_START".equals(action) || "android.intent.action.ACTION_IDLE_MAINTENANCE_END".equals(action)) {
            this.mWakeLock.release();
        }
    }

    static {
        sIdleMaintenanceStartIntent.setFlags(0x40000000);
        sIdleMaintenanceEndIntent = new Intent("android.intent.action.ACTION_IDLE_MAINTENANCE_END");
        sIdleMaintenanceEndIntent.setFlags(0x40000000);
    }
}

