/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.app.StatusBarManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.database.ContentObserver;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.hardware.input.InputManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pools;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.IWindow;
import android.view.IWindowManager;
import android.view.InputEventConsistencyVerifier;
import android.view.KeyEvent;
import android.view.MagnificationSpec;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import com.android.internal.content.PackageMonitor;
import com.android.internal.statusbar.IStatusBarService;
import com.android.server.accessibility.AccessibilityInputFilter;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibilityManagerService
extends IAccessibilityManager.Stub {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManagerService";
    private static final int WAIT_FOR_USER_STATE_FULLY_INITIALIZED_MILLIS = 3000;
    private static final String FUNCTION_REGISTER_UI_TEST_AUTOMATION_SERVICE = "registerUiTestAutomationService";
    private static final String TEMPORARY_ENABLE_ACCESSIBILITY_UNTIL_KEYGUARD_REMOVED = "temporaryEnableAccessibilityStateUntilKeyguardRemoved";
    private static final ComponentName sFakeAccessibilityServiceComponentName = new ComponentName("foo.bar", "FakeService");
    private static final String FUNCTION_DUMP = "dump";
    private static final char COMPONENT_NAME_SEPARATOR = ':';
    private static final int OWN_PROCESS_ID = Process.myPid();
    private static final int MAX_POOL_SIZE = 10;
    private static int sIdCounter = 0;
    private static int sNextWindowId;
    private final Context mContext;
    private final Object mLock = new Object();
    private final Pools.Pool<PendingEvent> mPendingEventPool = new Pools.SimplePool<PendingEvent>(10);
    private final TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
    private final List<AccessibilityServiceInfo> mEnabledServicesForFeedbackTempList = new ArrayList<AccessibilityServiceInfo>();
    private final Rect mTempRect = new Rect();
    private final Point mTempPoint = new Point();
    private final Display mDefaultDisplay;
    private final PackageManager mPackageManager;
    private final IWindowManager mWindowManagerService;
    private final SecurityPolicy mSecurityPolicy;
    private final MainHandler mMainHandler;
    private Service mQueryBridge;
    private AlertDialog mEnableTouchExplorationDialog;
    private AccessibilityInputFilter mInputFilter;
    private boolean mHasInputFilter;
    private final Set<ComponentName> mTempComponentNameSet = new HashSet<ComponentName>();
    private final List<AccessibilityServiceInfo> mTempAccessibilityServiceInfoList = new ArrayList<AccessibilityServiceInfo>();
    private final RemoteCallbackList<IAccessibilityManagerClient> mGlobalClients = new RemoteCallbackList();
    private final SparseArray<AccessibilityConnectionWrapper> mGlobalInteractionConnections = new SparseArray();
    private final SparseArray<IBinder> mGlobalWindowTokens = new SparseArray();
    private final SparseArray<UserState> mUserStates = new SparseArray();
    private int mCurrentUserId = 0;
    private boolean mInitialized;

    private UserState getCurrentUserStateLocked() {
        return this.getUserStateLocked(this.mCurrentUserId);
    }

    private UserState getUserStateLocked(int userId) {
        UserState state = this.mUserStates.get(userId);
        if (state == null) {
            state = new UserState(userId);
            this.mUserStates.put(userId, state);
        }
        return state;
    }

    public AccessibilityManagerService(Context context) {
        this.mContext = context;
        this.mPackageManager = this.mContext.getPackageManager();
        this.mWindowManagerService = (IWindowManager)((Object)ServiceManager.getService("window"));
        this.mSecurityPolicy = new SecurityPolicy();
        this.mMainHandler = new MainHandler(this.mContext.getMainLooper());
        DisplayManager displayManager = (DisplayManager)this.mContext.getSystemService("display");
        this.mDefaultDisplay = displayManager.getDisplay(0);
        this.registerBroadcastReceivers();
        new AccessibilityContentObserver(this.mMainHandler).register(context.getContentResolver());
    }

    private void registerBroadcastReceivers() {
        PackageMonitor monitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSomePackagesChanged() {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    if (this.getChangingUserId() != AccessibilityManagerService.this.mCurrentUserId) {
                        return;
                    }
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    userState.mInstalledServices.clear();
                    if (userState.mUiAutomationService == null && AccessibilityManagerService.this.readConfigurationForUserStateLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onPackageRemoved(String packageName, int uid) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    int userId = this.getChangingUserId();
                    if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                        return;
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    Iterator<ComponentName> it = userState.mEnabledServices.iterator();
                    while (it.hasNext()) {
                        ComponentName comp = it.next();
                        String compPkg = comp.getPackageName();
                        if (!compPkg.equals(packageName)) continue;
                        it.remove();
                        AccessibilityManagerService.this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, userId);
                        userState.mTouchExplorationGrantedServices.remove(comp);
                        AccessibilityManagerService.this.persistComponentNamesToSettingLocked("touch_exploration_granted_accessibility_services", userState.mTouchExplorationGrantedServices, userId);
                        if (userState.mUiAutomationService == null) {
                            AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                        }
                        return;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    int userId = this.getChangingUserId();
                    if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                        return false;
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    Iterator<ComponentName> it = userState.mEnabledServices.iterator();
                    while (it.hasNext()) {
                        ComponentName comp = it.next();
                        String compPkg = comp.getPackageName();
                        for (String pkg : packages) {
                            if (!compPkg.equals(pkg)) continue;
                            if (!doit) {
                                return true;
                            }
                            it.remove();
                            AccessibilityManagerService.this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, userId);
                            if (userState.mUiAutomationService != null) continue;
                            AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                        }
                    }
                    return false;
                }
            }
        };
        monitor.register(this.mContext, null, UserHandle.ALL, true);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                UserState userState;
                String action = intent.getAction();
                if ("android.intent.action.USER_SWITCHED".equals(action)) {
                    AccessibilityManagerService.this.switchUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                    AccessibilityManagerService.this.removeUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.USER_PRESENT".equals(action) && (userState = AccessibilityManagerService.this.getCurrentUserStateLocked()).mUiAutomationService == null && AccessibilityManagerService.this.readConfigurationForUserStateLocked(userState)) {
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
            }
        }, UserHandle.ALL, intentFilter, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addClient(IAccessibilityManagerClient client, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            if (this.mSecurityPolicy.isCallerInteractingAcrossUsers(userId)) {
                this.mGlobalClients.register(client);
                return userState.getClientState();
            }
            userState.mClients.register(client);
            return resolvedUserId == this.mCurrentUserId ? userState.getClientState() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendAccessibilityEvent(AccessibilityEvent event, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            if (resolvedUserId != this.mCurrentUserId) {
                return true;
            }
            if (this.mSecurityPolicy.canDispatchAccessibilityEvent(event)) {
                this.mSecurityPolicy.updateEventSourceLocked(event);
                this.mMainHandler.obtainMessage(4, event.getWindowId(), event.getEventType()).sendToTarget();
                this.notifyAccessibilityServicesDelayedLocked(event, false);
                this.notifyAccessibilityServicesDelayedLocked(event, true);
            }
            if (this.mHasInputFilter && this.mInputFilter != null) {
                this.mMainHandler.obtainMessage(1, AccessibilityEvent.obtain(event)).sendToTarget();
            }
            event.recycle();
            this.getUserStateLocked((int)resolvedUserId).mHandledFeedbackTypes = 0;
        }
        return OWN_PROCESS_ID != Binder.getCallingPid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            if (userState.mUiAutomationService != null) {
                ArrayList<AccessibilityServiceInfo> installedServices = new ArrayList<AccessibilityServiceInfo>();
                installedServices.addAll(userState.mInstalledServices);
                installedServices.remove(userState.mUiAutomationService);
                return installedServices;
            }
            return userState.mInstalledServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackType, int userId) {
        List<AccessibilityServiceInfo> result = null;
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            if (userState.mUiAutomationService != null) {
                return Collections.emptyList();
            }
            result = this.mEnabledServicesForFeedbackTempList;
            result.clear();
            CopyOnWriteArrayList<Service> services = userState.mBoundServices;
            while (feedbackType != 0) {
                int feedbackTypeBit = 1 << Integer.numberOfTrailingZeros(feedbackType);
                feedbackType &= ~feedbackTypeBit;
                int serviceCount = services.size();
                for (int i = 0; i < serviceCount; ++i) {
                    Service service = (Service)services.get(i);
                    if ((service.mFeedbackType & feedbackTypeBit) == 0) continue;
                    result.add(service.mAccessibilityServiceInfo);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt(int userId) {
        CopyOnWriteArrayList<Service> services;
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            if (resolvedUserId != this.mCurrentUserId) {
                return;
            }
            services = this.getUserStateLocked((int)resolvedUserId).mBoundServices;
        }
        int count = services.size();
        for (int i = 0; i < count; ++i) {
            Service service = services.get(i);
            try {
                service.mServiceInterface.onInterrupt();
                continue;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error during sending interrupt request to " + service.mService, re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addAccessibilityInteractionConnection(IWindow windowToken, IAccessibilityInteractionConnection connection, int userId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            int windowId = sNextWindowId++;
            if (this.mSecurityPolicy.isCallerInteractingAcrossUsers(userId)) {
                AccessibilityConnectionWrapper wrapper = new AccessibilityConnectionWrapper(windowId, connection, -1);
                wrapper.linkToDeath();
                this.mGlobalInteractionConnections.put(windowId, wrapper);
                this.mGlobalWindowTokens.put(windowId, windowToken.asBinder());
            } else {
                AccessibilityConnectionWrapper wrapper = new AccessibilityConnectionWrapper(windowId, connection, resolvedUserId);
                wrapper.linkToDeath();
                UserState userState = this.getUserStateLocked(resolvedUserId);
                userState.mInteractionConnections.put(windowId, wrapper);
                userState.mWindowTokens.put(windowId, windowToken.asBinder());
            }
            return windowId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccessibilityInteractionConnection(IWindow window) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
            IBinder token = window.asBinder();
            int removedWindowId = this.removeAccessibilityInteractionConnectionInternalLocked(token, this.mGlobalWindowTokens, this.mGlobalInteractionConnections);
            if (removedWindowId >= 0) {
                return;
            }
            int userCount = this.mUserStates.size();
            for (int i = 0; i < userCount; ++i) {
                UserState userState = this.mUserStates.valueAt(i);
                int removedWindowIdForUser = this.removeAccessibilityInteractionConnectionInternalLocked(token, userState.mWindowTokens, userState.mInteractionConnections);
                if (removedWindowIdForUser < 0) continue;
                return;
            }
        }
    }

    private int removeAccessibilityInteractionConnectionInternalLocked(IBinder windowToken, SparseArray<IBinder> windowTokens, SparseArray<AccessibilityConnectionWrapper> interactionConnections) {
        int count = windowTokens.size();
        for (int i = 0; i < count; ++i) {
            if (windowTokens.valueAt(i) != windowToken) continue;
            int windowId = windowTokens.keyAt(i);
            windowTokens.removeAt(i);
            AccessibilityConnectionWrapper wrapper = interactionConnections.get(windowId);
            wrapper.unlinkToDeath();
            interactionConnections.remove(windowId);
            return windowId;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUiTestAutomationService(IBinder owner, IAccessibilityServiceClient serviceClient, AccessibilityServiceInfo accessibilityServiceInfo) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.RETRIEVE_WINDOW_CONTENT", FUNCTION_REGISTER_UI_TEST_AUTOMATION_SERVICE);
        accessibilityServiceInfo.setComponentName(sFakeAccessibilityServiceComponentName);
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService != null) {
                throw new IllegalStateException("UiAutomationService " + serviceClient + "already registered!");
            }
            try {
                owner.linkToDeath(userState.mUiAutomationSerivceOnwerDeathRecipient, 0);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Couldn't register for the death of a UiTestAutomationService!", re);
                return;
            }
            userState.mUiAutomationServiceOwner = owner;
            userState.mUiAutomationServiceClient = serviceClient;
            userState.mIsAccessibilityEnabled = true;
            userState.mIsTouchExplorationEnabled = false;
            userState.mIsEnhancedWebAccessibilityEnabled = false;
            userState.mIsDisplayMagnificationEnabled = false;
            userState.mInstalledServices.add(accessibilityServiceInfo);
            userState.mEnabledServices.clear();
            userState.mEnabledServices.add(sFakeAccessibilityServiceComponentName);
            userState.mTouchExplorationGrantedServices.add(sFakeAccessibilityServiceComponentName);
            this.onUserStateChangedLocked(userState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterUiTestAutomationService(IAccessibilityServiceClient serviceClient) {
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService == null || serviceClient == null || userState.mUiAutomationService == null || ((UserState)userState).mUiAutomationService.mServiceInterface == null || ((UserState)userState).mUiAutomationService.mServiceInterface.asBinder() != serviceClient.asBinder()) {
                throw new IllegalStateException("UiAutomationService " + serviceClient + " not registered!");
            }
            userState.mUiAutomationService.binderDied();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void temporaryEnableAccessibilityStateUntilKeyguardRemoved(ComponentName service, boolean touchExplorationEnabled) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.TEMPORARY_ENABLE_ACCESSIBILITY", TEMPORARY_ENABLE_ACCESSIBILITY_UNTIL_KEYGUARD_REMOVED);
        try {
            if (!this.mWindowManagerService.isKeyguardLocked()) {
                return;
            }
        }
        catch (RemoteException re) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService != null) {
                return;
            }
            userState.mIsAccessibilityEnabled = true;
            userState.mIsTouchExplorationEnabled = touchExplorationEnabled;
            userState.mIsEnhancedWebAccessibilityEnabled = false;
            userState.mIsDisplayMagnificationEnabled = false;
            userState.mEnabledServices.clear();
            userState.mEnabledServices.add(service);
            userState.mBindingServices.clear();
            userState.mTouchExplorationGrantedServices.clear();
            userState.mTouchExplorationGrantedServices.add(service);
            this.onUserStateChangedLocked(userState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onGesture(int gestureId) {
        Object object = this.mLock;
        synchronized (object) {
            boolean handled = this.notifyGestureLocked(gestureId, false);
            if (!handled) {
                handled = this.notifyGestureLocked(gestureId, true);
            }
            return handled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean notifyKeyEvent(KeyEvent event, int policyFlags) {
        Object object = this.mLock;
        synchronized (object) {
            KeyEvent localClone = KeyEvent.obtain(event);
            boolean handled = this.notifyKeyEventLocked(localClone, policyFlags, false);
            if (!handled) {
                handled = this.notifyKeyEventLocked(localClone, policyFlags, true);
            }
            return handled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getAccessibilityFocusBoundsInActiveWindow(Rect outBounds) {
        AccessibilityNodeInfo focus;
        AccessibilityInteractionClient client;
        int connectionId;
        Service service;
        block6: {
            AccessibilityNodeInfo root;
            block5: {
                service = this.getQueryBridge();
                connectionId = service.mId;
                client = AccessibilityInteractionClient.getInstance();
                client.addConnection(connectionId, service);
                try {
                    root = AccessibilityInteractionClient.getInstance().getRootInActiveWindow(connectionId);
                    if (root != null) break block5;
                    boolean bl = false;
                    Object var11_8 = null;
                    client.removeConnection(connectionId);
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    client.removeConnection(connectionId);
                    throw throwable;
                }
            }
            focus = root.findFocus(2);
            if (focus != null) break block6;
            boolean bl = false;
            Object var11_9 = null;
            client.removeConnection(connectionId);
            return bl;
        }
        focus.getBoundsInScreen(outBounds);
        MagnificationSpec spec = service.getCompatibleMagnificationSpec(focus.getWindowId());
        if (spec != null && !spec.isNop()) {
            outBounds.offset((int)(-spec.offsetX), (int)(-spec.offsetY));
            outBounds.scale(1.0f / spec.scale);
        }
        Rect windowBounds = this.mTempRect;
        this.getActiveWindowBounds(windowBounds);
        outBounds.intersect(windowBounds);
        this.mDefaultDisplay.getRealSize(this.mTempPoint);
        outBounds.intersect(0, 0, this.mTempPoint.x, this.mTempPoint.y);
        boolean bl = true;
        Object var11_10 = null;
        client.removeConnection(connectionId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getActiveWindowBounds(Rect outBounds) {
        IBinder token;
        Object object = this.mLock;
        synchronized (object) {
            int windowId = this.mSecurityPolicy.mActiveWindowId;
            token = this.mGlobalWindowTokens.get(windowId);
            if (token == null) {
                token = this.getCurrentUserStateLocked().mWindowTokens.get(windowId);
            }
        }
        try {
            this.mWindowManagerService.getWindowFrame(token, outBounds);
            if (!outBounds.isEmpty()) {
                return true;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    int getActiveWindowId() {
        return this.mSecurityPolicy.mActiveWindowId;
    }

    void onTouchInteractionStart() {
        this.mSecurityPolicy.onTouchInteractionStart();
    }

    void onTouchInteractionEnd() {
        this.mSecurityPolicy.onTouchInteractionEnd();
    }

    void onMagnificationStateChanged() {
        this.notifyClearAccessibilityNodeInfoCacheLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            UserManager userManager;
            if (this.mCurrentUserId == userId && this.mInitialized) {
                return;
            }
            UserState oldUserState = this.getUserStateLocked(this.mCurrentUserId);
            oldUserState.onSwitchToAnotherUser();
            if (oldUserState.mClients.getRegisteredCallbackCount() > 0) {
                this.mMainHandler.obtainMessage(3, oldUserState.mUserId, 0).sendToTarget();
            }
            boolean announceNewUser = (userManager = (UserManager)this.mContext.getSystemService("user")).getUsers().size() > 1;
            this.mCurrentUserId = userId;
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService != null) {
                userState.mUiAutomationService.binderDied();
            }
            this.readConfigurationForUserStateLocked(userState);
            this.onUserStateChangedLocked(userState);
            if (announceNewUser) {
                this.mMainHandler.sendEmptyMessageDelayed(5, 3000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUserStates.remove(userId);
        }
    }

    private Service getQueryBridge() {
        if (this.mQueryBridge == null) {
            AccessibilityServiceInfo info = new AccessibilityServiceInfo();
            info.setCapabilities(1);
            this.mQueryBridge = new Service(-10000, sFakeAccessibilityServiceComponentName, info);
        }
        return this.mQueryBridge;
    }

    private boolean notifyGestureLocked(int gestureId, boolean isDefault) {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            if (!service.mRequestTouchExplorationMode || service.mIsDefault != isDefault) continue;
            service.notifyGesture(gestureId);
            return true;
        }
        return false;
    }

    private boolean notifyKeyEventLocked(KeyEvent event, int policyFlags, boolean isDefault) {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            if (!service.mRequestFilterKeyEvents || (service.mAccessibilityServiceInfo.getCapabilities() & 8) == 0 || service.mIsDefault != isDefault) continue;
            service.notifyKeyEvent(event, policyFlags);
            return true;
        }
        return false;
    }

    private void notifyClearAccessibilityNodeInfoCacheLocked() {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            service.notifyClearAccessibilityNodeInfoCache();
        }
    }

    private void removeAccessibilityInteractionConnectionLocked(int windowId, int userId) {
        if (userId == -1) {
            this.mGlobalWindowTokens.remove(windowId);
            this.mGlobalInteractionConnections.remove(windowId);
        } else {
            UserState userState = this.getCurrentUserStateLocked();
            userState.mWindowTokens.remove(windowId);
            userState.mInteractionConnections.remove(windowId);
        }
    }

    private boolean readInstalledAccessibilityServiceLocked(UserState userState) {
        this.mTempAccessibilityServiceInfoList.clear();
        List<ResolveInfo> installedServices = this.mPackageManager.queryIntentServicesAsUser(new Intent("android.accessibilityservice.AccessibilityService"), 132, this.mCurrentUserId);
        int count = installedServices.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = installedServices.get(i);
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (!"android.permission.BIND_ACCESSIBILITY_SERVICE".equals(serviceInfo.permission)) {
                Slog.w(LOG_TAG, "Skipping accessibilty service " + new ComponentName(serviceInfo.packageName, serviceInfo.name).flattenToShortString() + ": it does not require the permission " + "android.permission.BIND_ACCESSIBILITY_SERVICE");
                continue;
            }
            try {
                AccessibilityServiceInfo accessibilityServiceInfo = new AccessibilityServiceInfo(resolveInfo, this.mContext);
                this.mTempAccessibilityServiceInfoList.add(accessibilityServiceInfo);
                continue;
            }
            catch (XmlPullParserException xppe) {
                Slog.e(LOG_TAG, "Error while initializing AccessibilityServiceInfo", xppe);
                continue;
            }
            catch (IOException ioe) {
                Slog.e(LOG_TAG, "Error while initializing AccessibilityServiceInfo", ioe);
            }
        }
        if (!((Object)this.mTempAccessibilityServiceInfoList).equals(userState.mInstalledServices)) {
            userState.mInstalledServices.clear();
            userState.mInstalledServices.addAll(this.mTempAccessibilityServiceInfoList);
            this.mTempAccessibilityServiceInfoList.clear();
            return true;
        }
        this.mTempAccessibilityServiceInfoList.clear();
        return false;
    }

    private boolean readEnabledAccessibilityServicesLocked(UserState userState) {
        this.mTempComponentNameSet.clear();
        this.readComponentNamesFromSettingLocked("enabled_accessibility_services", userState.mUserId, this.mTempComponentNameSet);
        if (!((Object)this.mTempComponentNameSet).equals(userState.mEnabledServices)) {
            userState.mEnabledServices.clear();
            userState.mEnabledServices.addAll(this.mTempComponentNameSet);
            this.mTempComponentNameSet.clear();
            return true;
        }
        this.mTempComponentNameSet.clear();
        return false;
    }

    private boolean readTouchExplorationGrantedAccessibilityServicesLocked(UserState userState) {
        this.mTempComponentNameSet.clear();
        this.readComponentNamesFromSettingLocked("touch_exploration_granted_accessibility_services", userState.mUserId, this.mTempComponentNameSet);
        if (!((Object)this.mTempComponentNameSet).equals(userState.mTouchExplorationGrantedServices)) {
            userState.mTouchExplorationGrantedServices.clear();
            userState.mTouchExplorationGrantedServices.addAll(this.mTempComponentNameSet);
            this.mTempComponentNameSet.clear();
            return true;
        }
        this.mTempComponentNameSet.clear();
        return false;
    }

    private void notifyAccessibilityServicesDelayedLocked(AccessibilityEvent event, boolean isDefault) {
        try {
            UserState state = this.getCurrentUserStateLocked();
            int count = state.mBoundServices.size();
            for (int i = 0; i < count; ++i) {
                Service service = state.mBoundServices.get(i);
                if (service.mIsDefault != isDefault || !this.canDispathEventLocked(service, event, state.mHandledFeedbackTypes)) continue;
                state.mHandledFeedbackTypes |= service.mFeedbackType;
                service.notifyAccessibilityEvent(event);
            }
        }
        catch (IndexOutOfBoundsException oobe) {
            return;
        }
    }

    private void addServiceLocked(Service service, UserState userState) {
        try {
            service.linkToOwnDeathLocked();
            userState.mBoundServices.add(service);
            userState.mComponentNameToServiceMap.put(service.mComponentName, service);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void removeServiceLocked(Service service, UserState userState) {
        userState.mBoundServices.remove(service);
        userState.mComponentNameToServiceMap.remove(service.mComponentName);
        service.unlinkToOwnDeathLocked();
    }

    private boolean canDispathEventLocked(Service service, AccessibilityEvent event, int handledFeedbackTypes) {
        int feedbackType;
        if (!service.canReceiveEventsLocked()) {
            return false;
        }
        if (!event.isImportantForAccessibility() && (service.mFetchFlags & 8) == 0) {
            return false;
        }
        int eventType = event.getEventType();
        if ((service.mEventTypes & eventType) != eventType) {
            return false;
        }
        Set<String> packageNames = service.mPackageNames;
        CharSequence packageName = event.getPackageName();
        return !(!packageNames.isEmpty() && !packageNames.contains(packageName) || (handledFeedbackTypes & (feedbackType = service.mFeedbackType)) == feedbackType && feedbackType != 16);
    }

    private void unbindAllServicesLocked(UserState userState) {
        CopyOnWriteArrayList<Service> services = userState.mBoundServices;
        int count = services.size();
        for (int i = 0; i < count; ++i) {
            Service service = (Service)services.get(i);
            if (!service.unbindLocked()) continue;
            --i;
            --count;
        }
    }

    private void readComponentNamesFromSettingLocked(String settingName, int userId, Set<ComponentName> outComponentNames) {
        String settingValue = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), settingName, userId);
        outComponentNames.clear();
        if (settingValue != null) {
            TextUtils.SimpleStringSplitter splitter = this.mStringColonSplitter;
            splitter.setString(settingValue);
            while (splitter.hasNext()) {
                ComponentName enabledService;
                String str = splitter.next();
                if (str == null || str.length() <= 0 || (enabledService = ComponentName.unflattenFromString(str)) == null) continue;
                outComponentNames.add(enabledService);
            }
        }
    }

    private void persistComponentNamesToSettingLocked(String settingName, Set<ComponentName> componentNames, int userId) {
        StringBuilder builder = new StringBuilder();
        for (ComponentName componentName : componentNames) {
            if (builder.length() > 0) {
                builder.append(':');
            }
            builder.append(componentName.flattenToShortString());
        }
        Settings.Secure.putStringForUser(this.mContext.getContentResolver(), settingName, builder.toString(), userId);
    }

    private void manageServicesLocked(UserState userState) {
        Map<ComponentName, Service> componentNameToServiceMap = userState.mComponentNameToServiceMap;
        boolean isEnabled = userState.mIsAccessibilityEnabled;
        int count = userState.mInstalledServices.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityServiceInfo installedService = userState.mInstalledServices.get(i);
            ComponentName componentName = ComponentName.unflattenFromString(installedService.getId());
            Service service = componentNameToServiceMap.get(componentName);
            if (isEnabled) {
                if (userState.mBindingServices.contains(componentName)) continue;
                if (userState.mEnabledServices.contains(componentName)) {
                    if (service == null) {
                        service = new Service(userState.mUserId, componentName, installedService);
                    } else if (userState.mBoundServices.contains(service)) continue;
                    service.bindLocked();
                    continue;
                }
                if (service == null) continue;
                service.unbindLocked();
                continue;
            }
            if (service != null) {
                service.unbindLocked();
                continue;
            }
            userState.mBindingServices.remove(componentName);
        }
        if (isEnabled && userState.mEnabledServices.isEmpty()) {
            userState.mIsAccessibilityEnabled = false;
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_enabled", 0, userState.mUserId);
        }
    }

    private void scheduleUpdateClientsIfNeededLocked(UserState userState) {
        int clientState = userState.getClientState();
        if (userState.mLastSentClientState != clientState && (this.mGlobalClients.getRegisteredCallbackCount() > 0 || userState.mClients.getRegisteredCallbackCount() > 0)) {
            userState.mLastSentClientState = clientState;
            this.mMainHandler.obtainMessage(2, clientState, userState.mUserId).sendToTarget();
        }
    }

    private void scheduleUpdateInputFilter(UserState userState) {
        this.mMainHandler.obtainMessage(6, userState).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInputFilter(UserState userState) {
        boolean setInputFilter = false;
        AccessibilityInputFilter inputFilter = null;
        Object object = this.mLock;
        synchronized (object) {
            int flags = 0;
            if (userState.mIsDisplayMagnificationEnabled) {
                flags |= 1;
            }
            if (userState.mIsAccessibilityEnabled && userState.mIsTouchExplorationEnabled) {
                flags |= 2;
            }
            if (userState.mIsFilterKeyEventsEnabled) {
                flags |= 4;
            }
            if (flags != 0) {
                if (!this.mHasInputFilter) {
                    this.mHasInputFilter = true;
                    if (this.mInputFilter == null) {
                        this.mInputFilter = new AccessibilityInputFilter(this.mContext, this);
                    }
                    inputFilter = this.mInputFilter;
                    setInputFilter = true;
                }
                this.mInputFilter.setEnabledFeatures(flags);
            } else if (this.mHasInputFilter) {
                this.mHasInputFilter = false;
                this.mInputFilter.disableFeatures();
                inputFilter = null;
                setInputFilter = true;
            }
        }
        if (setInputFilter) {
            try {
                this.mWindowManagerService.setInputFilter(inputFilter);
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showEnableTouchExplorationDialog(final Service service) {
        Object object = this.mLock;
        synchronized (object) {
            String label = ((Object)service.mResolveInfo.loadLabel(this.mContext.getPackageManager())).toString();
            final UserState state = this.getCurrentUserStateLocked();
            if (state.mIsTouchExplorationEnabled) {
                return;
            }
            if (this.mEnableTouchExplorationDialog != null && this.mEnableTouchExplorationDialog.isShowing()) {
                return;
            }
            this.mEnableTouchExplorationDialog = new AlertDialog.Builder(this.mContext).setIconAttribute(16843605).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    state.mTouchExplorationGrantedServices.add(service.mComponentName);
                    AccessibilityManagerService.this.persistComponentNamesToSettingLocked("touch_exploration_granted_accessibility_services", state.mTouchExplorationGrantedServices, state.mUserId);
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(service.mUserId);
                    userState.mIsTouchExplorationEnabled = true;
                    Settings.Secure.putIntForUser(AccessibilityManagerService.this.mContext.getContentResolver(), "touch_exploration_enabled", 1, service.mUserId);
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).setTitle(17040328).setMessage(this.mContext.getString(17040329, label)).create();
            this.mEnableTouchExplorationDialog.getWindow().setType(2003);
            this.mEnableTouchExplorationDialog.getWindow().getAttributes().privateFlags |= 0x10;
            this.mEnableTouchExplorationDialog.setCanceledOnTouchOutside(true);
            this.mEnableTouchExplorationDialog.show();
        }
    }

    private void onUserStateChangedLocked(UserState userState) {
        this.mInitialized = true;
        this.updateLegacyCapabilities(userState);
        this.updateServicesLocked(userState);
        this.updateFilterKeyEventsLocked(userState);
        this.updateTouchExplorationLocked(userState);
        this.updateEnhancedWebAccessibilityLocked(userState);
        this.scheduleUpdateInputFilter(userState);
        this.scheduleUpdateClientsIfNeededLocked(userState);
    }

    private void updateLegacyCapabilities(UserState userState) {
        int installedServiceCount = userState.mInstalledServices.size();
        for (int i = 0; i < installedServiceCount; ++i) {
            ComponentName componentName;
            AccessibilityServiceInfo serviceInfo = userState.mInstalledServices.get(i);
            ResolveInfo resolveInfo = serviceInfo.getResolveInfo();
            if ((serviceInfo.getCapabilities() & 2) != 0 || resolveInfo.serviceInfo.applicationInfo.targetSdkVersion > 17 || !userState.mTouchExplorationGrantedServices.contains(componentName = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name))) continue;
            serviceInfo.setCapabilities(serviceInfo.getCapabilities() | 2);
        }
    }

    private void updateFilterKeyEventsLocked(UserState userState) {
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            Service service = userState.mBoundServices.get(i);
            if (!service.mRequestFilterKeyEvents || (service.mAccessibilityServiceInfo.getCapabilities() & 8) == 0) continue;
            userState.mIsFilterKeyEventsEnabled = true;
            return;
        }
        userState.mIsFilterKeyEventsEnabled = false;
    }

    private void updateServicesLocked(UserState userState) {
        if (userState.mIsAccessibilityEnabled) {
            this.manageServicesLocked(userState);
        } else {
            this.unbindAllServicesLocked(userState);
        }
    }

    private boolean readConfigurationForUserStateLocked(UserState userState) {
        boolean somthingChanged = false;
        somthingChanged |= this.readAccessibilityEnabledSettingLocked(userState);
        somthingChanged |= this.readInstalledAccessibilityServiceLocked(userState);
        somthingChanged |= this.readEnabledAccessibilityServicesLocked(userState);
        somthingChanged |= this.readTouchExplorationGrantedAccessibilityServicesLocked(userState);
        somthingChanged |= this.readTouchExplorationEnabledSettingLocked(userState);
        somthingChanged |= this.readEnhancedWebAccessibilityEnabledChangedLocked(userState);
        return somthingChanged |= this.readDisplayMagnificationEnabledSettingLocked(userState);
    }

    private boolean readAccessibilityEnabledSettingLocked(UserState userState) {
        boolean accessibilityEnabled;
        boolean bl = accessibilityEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_enabled", 0, userState.mUserId) == 1;
        if (accessibilityEnabled != userState.mIsAccessibilityEnabled) {
            userState.mIsAccessibilityEnabled = accessibilityEnabled;
            return true;
        }
        return false;
    }

    private boolean readTouchExplorationEnabledSettingLocked(UserState userState) {
        boolean touchExplorationEnabled;
        boolean bl = touchExplorationEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "touch_exploration_enabled", 0, userState.mUserId) == 1;
        if (touchExplorationEnabled != userState.mIsTouchExplorationEnabled) {
            userState.mIsTouchExplorationEnabled = touchExplorationEnabled;
            return true;
        }
        return false;
    }

    private boolean readDisplayMagnificationEnabledSettingLocked(UserState userState) {
        boolean displayMagnificationEnabled;
        boolean bl = displayMagnificationEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_display_magnification_enabled", 0, userState.mUserId) == 1;
        if (displayMagnificationEnabled != userState.mIsDisplayMagnificationEnabled) {
            userState.mIsDisplayMagnificationEnabled = displayMagnificationEnabled;
            return true;
        }
        return false;
    }

    private boolean readEnhancedWebAccessibilityEnabledChangedLocked(UserState userState) {
        boolean enhancedWeAccessibilityEnabled;
        boolean bl = enhancedWeAccessibilityEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_script_injection", 0, userState.mUserId) == 1;
        if (enhancedWeAccessibilityEnabled != userState.mIsEnhancedWebAccessibilityEnabled) {
            userState.mIsEnhancedWebAccessibilityEnabled = enhancedWeAccessibilityEnabled;
            return true;
        }
        return false;
    }

    private void updateTouchExplorationLocked(UserState userState) {
        boolean enabled = false;
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            Service service = userState.mBoundServices.get(i);
            if (!this.canRequestAndRequestsTouchExplorationLocked(service)) continue;
            enabled = true;
            break;
        }
        if (enabled != userState.mIsTouchExplorationEnabled) {
            userState.mIsTouchExplorationEnabled = enabled;
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "touch_exploration_enabled", enabled ? 1 : 0, userState.mUserId);
        }
        try {
            this.mWindowManagerService.setTouchExplorationEnabled(enabled);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private boolean canRequestAndRequestsTouchExplorationLocked(Service service) {
        if (!service.canReceiveEventsLocked() || !service.mRequestTouchExplorationMode) {
            return false;
        }
        if (service.mIsAutomation) {
            return true;
        }
        if (service.mResolveInfo.serviceInfo.applicationInfo.targetSdkVersion <= 17) {
            UserState userState = this.getUserStateLocked(service.mUserId);
            if (userState.mTouchExplorationGrantedServices.contains(service.mComponentName)) {
                return true;
            }
            if (this.mEnableTouchExplorationDialog == null || !this.mEnableTouchExplorationDialog.isShowing()) {
                this.mMainHandler.obtainMessage(7, service).sendToTarget();
            }
        } else if ((service.mAccessibilityServiceInfo.getCapabilities() & 2) != 0) {
            return true;
        }
        return false;
    }

    private void updateEnhancedWebAccessibilityLocked(UserState userState) {
        boolean enabled = false;
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            Service service = userState.mBoundServices.get(i);
            if (!this.canRequestAndRequestsEnhancedWebAccessibilityLocked(service)) continue;
            enabled = true;
            break;
        }
        if (enabled != userState.mIsEnhancedWebAccessibilityEnabled) {
            userState.mIsEnhancedWebAccessibilityEnabled = enabled;
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_script_injection", enabled ? 1 : 0, userState.mUserId);
        }
    }

    private boolean canRequestAndRequestsEnhancedWebAccessibilityLocked(Service service) {
        if (!service.canReceiveEventsLocked() || !service.mRequestEnhancedWebAccessibility) {
            return false;
        }
        return service.mIsAutomation || (service.mAccessibilityServiceInfo.getCapabilities() & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.DUMP", FUNCTION_DUMP);
        Object object = this.mLock;
        synchronized (object) {
            pw.println("ACCESSIBILITY MANAGER (dumpsys accessibility)");
            pw.println();
            int userCount = this.mUserStates.size();
            for (int i = 0; i < userCount; ++i) {
                UserState userState = this.mUserStates.valueAt(i);
                pw.append("User state[attributes:{id=" + userState.mUserId);
                pw.append(", currentUser=" + (userState.mUserId == this.mCurrentUserId));
                pw.append(", accessibilityEnabled=" + userState.mIsAccessibilityEnabled);
                pw.append(", touchExplorationEnabled=" + userState.mIsTouchExplorationEnabled);
                pw.append(", displayMagnificationEnabled=" + userState.mIsDisplayMagnificationEnabled);
                if (userState.mUiAutomationService != null) {
                    pw.append(", ");
                    userState.mUiAutomationService.dump(fd, pw, args);
                    pw.println();
                }
                pw.append("}");
                pw.println();
                pw.append("           services:{");
                int serviceCount = userState.mBoundServices.size();
                for (int j = 0; j < serviceCount; ++j) {
                    if (j > 0) {
                        pw.append(", ");
                        pw.println();
                        pw.append("                     ");
                    }
                    Service service = userState.mBoundServices.get(j);
                    service.dump(fd, pw, args);
                }
                pw.println("}]");
                pw.println();
            }
        }
    }

    private PendingEvent obtainPendingEventLocked(KeyEvent event, int policyFlags, int sequence) {
        PendingEvent pendingEvent = this.mPendingEventPool.acquire();
        if (pendingEvent == null) {
            pendingEvent = new PendingEvent();
        }
        pendingEvent.event = event;
        pendingEvent.policyFlags = policyFlags;
        pendingEvent.sequence = sequence;
        return pendingEvent;
    }

    private void recyclePendingEventLocked(PendingEvent pendingEvent) {
        pendingEvent.clear();
        this.mPendingEventPool.release(pendingEvent);
    }

    private final class AccessibilityContentObserver
    extends ContentObserver {
        private final Uri mAccessibilityEnabledUri;
        private final Uri mTouchExplorationEnabledUri;
        private final Uri mDisplayMagnificationEnabledUri;
        private final Uri mEnabledAccessibilityServicesUri;
        private final Uri mTouchExplorationGrantedAccessibilityServicesUri;
        private final Uri mEnhancedWebAccessibilityUri;

        public AccessibilityContentObserver(Handler handler) {
            super(handler);
            this.mAccessibilityEnabledUri = Settings.Secure.getUriFor("accessibility_enabled");
            this.mTouchExplorationEnabledUri = Settings.Secure.getUriFor("touch_exploration_enabled");
            this.mDisplayMagnificationEnabledUri = Settings.Secure.getUriFor("accessibility_display_magnification_enabled");
            this.mEnabledAccessibilityServicesUri = Settings.Secure.getUriFor("enabled_accessibility_services");
            this.mTouchExplorationGrantedAccessibilityServicesUri = Settings.Secure.getUriFor("touch_exploration_granted_accessibility_services");
            this.mEnhancedWebAccessibilityUri = Settings.Secure.getUriFor("accessibility_script_injection");
        }

        public void register(ContentResolver contentResolver) {
            contentResolver.registerContentObserver(this.mAccessibilityEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mTouchExplorationEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayMagnificationEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mEnabledAccessibilityServicesUri, false, this, -1);
            contentResolver.registerContentObserver(this.mTouchExplorationGrantedAccessibilityServicesUri, false, this, -1);
            contentResolver.registerContentObserver(this.mEnhancedWebAccessibilityUri, false, this, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange, Uri uri) {
            if (this.mAccessibilityEnabledUri.equals(uri)) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    if (userState.mUiAutomationService == null && AccessibilityManagerService.this.readAccessibilityEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }
            if (this.mTouchExplorationEnabledUri.equals(uri)) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    if (userState.mUiAutomationService == null && AccessibilityManagerService.this.readTouchExplorationEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }
            if (this.mDisplayMagnificationEnabledUri.equals(uri)) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    if (userState.mUiAutomationService == null && AccessibilityManagerService.this.readDisplayMagnificationEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }
            if (this.mEnabledAccessibilityServicesUri.equals(uri)) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    if (userState.mUiAutomationService == null && AccessibilityManagerService.this.readEnabledAccessibilityServicesLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }
            if (this.mTouchExplorationGrantedAccessibilityServicesUri.equals(uri)) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    if (userState.mUiAutomationService == null && AccessibilityManagerService.this.readTouchExplorationGrantedAccessibilityServicesLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }
            if (this.mEnhancedWebAccessibilityUri.equals(uri)) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    if (userState.mUiAutomationService == null && AccessibilityManagerService.this.readEnhancedWebAccessibilityEnabledChangedLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }
        }
    }

    private class UserState {
        public final int mUserId;
        public final RemoteCallbackList<IAccessibilityManagerClient> mClients = new RemoteCallbackList();
        public final SparseArray<AccessibilityConnectionWrapper> mInteractionConnections = new SparseArray();
        public final SparseArray<IBinder> mWindowTokens = new SparseArray();
        public final CopyOnWriteArrayList<Service> mBoundServices = new CopyOnWriteArrayList();
        public final Map<ComponentName, Service> mComponentNameToServiceMap = new HashMap<ComponentName, Service>();
        public final List<AccessibilityServiceInfo> mInstalledServices = new ArrayList<AccessibilityServiceInfo>();
        public final Set<ComponentName> mBindingServices = new HashSet<ComponentName>();
        public final Set<ComponentName> mEnabledServices = new HashSet<ComponentName>();
        public final Set<ComponentName> mTouchExplorationGrantedServices = new HashSet<ComponentName>();
        public int mHandledFeedbackTypes = 0;
        public int mLastSentClientState = -1;
        public boolean mIsAccessibilityEnabled;
        public boolean mIsTouchExplorationEnabled;
        public boolean mIsEnhancedWebAccessibilityEnabled;
        public boolean mIsDisplayMagnificationEnabled;
        public boolean mIsFilterKeyEventsEnabled;
        private Service mUiAutomationService;
        private IAccessibilityServiceClient mUiAutomationServiceClient;
        private IBinder mUiAutomationServiceOwner;
        private final IBinder.DeathRecipient mUiAutomationSerivceOnwerDeathRecipient = new IBinder.DeathRecipient(){

            public void binderDied() {
                UserState.this.mUiAutomationServiceOwner.unlinkToDeath(UserState.this.mUiAutomationSerivceOnwerDeathRecipient, 0);
                UserState.this.mUiAutomationServiceOwner = null;
                if (UserState.this.mUiAutomationService != null) {
                    UserState.this.mUiAutomationService.binderDied();
                }
            }
        };

        public UserState(int userId) {
            this.mUserId = userId;
        }

        public int getClientState() {
            int clientState = 0;
            if (this.mIsAccessibilityEnabled) {
                clientState |= 1;
            }
            if (this.mIsAccessibilityEnabled && this.mIsTouchExplorationEnabled) {
                clientState |= 2;
            }
            return clientState;
        }

        public void onSwitchToAnotherUser() {
            if (this.mUiAutomationService != null) {
                this.mUiAutomationService.binderDied();
            }
            AccessibilityManagerService.this.unbindAllServicesLocked(this);
            this.mBoundServices.clear();
            this.mBindingServices.clear();
            this.mHandledFeedbackTypes = 0;
            this.mLastSentClientState = -1;
            this.mEnabledServices.clear();
            this.mTouchExplorationGrantedServices.clear();
            this.mIsAccessibilityEnabled = false;
            this.mIsTouchExplorationEnabled = false;
            this.mIsEnhancedWebAccessibilityEnabled = false;
            this.mIsDisplayMagnificationEnabled = false;
        }

        public void destroyUiAutomationService() {
            this.mUiAutomationService = null;
            this.mUiAutomationServiceClient = null;
            if (this.mUiAutomationServiceOwner != null) {
                this.mUiAutomationServiceOwner.unlinkToDeath(this.mUiAutomationSerivceOnwerDeathRecipient, 0);
                this.mUiAutomationServiceOwner = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SecurityPolicy {
        private static final int VALID_ACTIONS = 0x1FFFFF;
        private static final int RETRIEVAL_ALLOWING_EVENT_TYPES = 113087;
        private int mActiveWindowId;
        private boolean mTouchInteractionInProgress;

        SecurityPolicy() {
        }

        private boolean canDispatchAccessibilityEvent(AccessibilityEvent event) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 32: 
                case 64: 
                case 128: 
                case 256: 
                case 512: 
                case 1024: 
                case 262144: 
                case 524288: 
                case 0x100000: 
                case 0x200000: {
                    return true;
                }
            }
            return event.getWindowId() == this.mActiveWindowId;
        }

        public void updateEventSourceLocked(AccessibilityEvent event) {
            if ((event.getEventType() & 0x1B9BF) == 0) {
                event.setSource(null);
            }
        }

        public void updateActiveWindow(int windowId, int eventType) {
            switch (eventType) {
                case 32: {
                    if (this.getFocusedWindowId() != windowId) break;
                    this.mActiveWindowId = windowId;
                    break;
                }
                case 128: {
                    if (!this.mTouchInteractionInProgress) break;
                    this.mActiveWindowId = windowId;
                }
            }
        }

        public void onTouchInteractionStart() {
            this.mTouchInteractionInProgress = true;
        }

        public void onTouchInteractionEnd() {
            this.mTouchInteractionInProgress = false;
            this.mActiveWindowId = this.getFocusedWindowId();
        }

        public int getRetrievalAllowingWindowLocked() {
            return this.mActiveWindowId;
        }

        public boolean canGetAccessibilityNodeInfoLocked(Service service, int windowId) {
            return this.canRetrieveWindowContent(service) && this.isRetrievalAllowingWindow(windowId);
        }

        public boolean canPerformActionLocked(Service service, int windowId, int action, Bundle arguments) {
            return this.canRetrieveWindowContent(service) && this.isRetrievalAllowingWindow(windowId) && this.isActionPermitted(action);
        }

        public boolean canRetrieveWindowContent(Service service) {
            return (service.mAccessibilityServiceInfo.getCapabilities() & 1) != 0;
        }

        public void enforceCanRetrieveWindowContent(Service service) throws RemoteException {
            if (!this.canRetrieveWindowContent(service)) {
                Slog.e(AccessibilityManagerService.LOG_TAG, "Accessibility serivce " + service.mComponentName + " does not " + "declare android:canRetrieveWindowContent.");
                throw new RemoteException();
            }
        }

        public int resolveCallingUserIdEnforcingPermissionsLocked(int userId) {
            int callingUid = Binder.getCallingUid();
            if (callingUid == 0 || callingUid == 1000 || callingUid == 2000) {
                return AccessibilityManagerService.this.mCurrentUserId;
            }
            int callingUserId = UserHandle.getUserId(callingUid);
            if (callingUserId == userId) {
                return userId;
            }
            if (!this.hasPermission("android.permission.INTERACT_ACROSS_USERS") && !this.hasPermission("android.permission.INTERACT_ACROSS_USERS_FULL")) {
                throw new SecurityException("Call from user " + callingUserId + " as user " + userId + " without permission INTERACT_ACROSS_USERS or " + "INTERACT_ACROSS_USERS_FULL not allowed.");
            }
            if (userId == -2 || userId == -3) {
                return AccessibilityManagerService.this.mCurrentUserId;
            }
            throw new IllegalArgumentException("Calling user can be changed to only UserHandle.USER_CURRENT or UserHandle.USER_CURRENT_OR_SELF.");
        }

        public boolean isCallerInteractingAcrossUsers(int userId) {
            int callingUid = Binder.getCallingUid();
            return Binder.getCallingPid() == Process.myPid() || callingUid == 2000 || userId == -2 || userId == -3;
        }

        private boolean isRetrievalAllowingWindow(int windowId) {
            return this.mActiveWindowId == windowId;
        }

        private boolean isActionPermitted(int action) {
            return (0x1FFFFF & action) != 0;
        }

        private void enforceCallingPermission(String permission2, String function) {
            if (OWN_PROCESS_ID == Binder.getCallingPid()) {
                return;
            }
            if (!this.hasPermission(permission2)) {
                throw new SecurityException("You do not have " + permission2 + " required to call " + function + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            }
        }

        private boolean hasPermission(String permission2) {
            return AccessibilityManagerService.this.mContext.checkCallingPermission(permission2) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getFocusedWindowId() {
            try {
                IBinder token = AccessibilityManagerService.this.mWindowManagerService.getFocusedWindowToken();
                if (token != null) {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        int windowId = this.getFocusedWindowIdLocked(token, AccessibilityManagerService.this.mGlobalWindowTokens);
                        if (windowId < 0) {
                            windowId = this.getFocusedWindowIdLocked(token, ((AccessibilityManagerService)AccessibilityManagerService.this).getCurrentUserStateLocked().mWindowTokens);
                        }
                        return windowId;
                    }
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return -1;
        }

        private int getFocusedWindowIdLocked(IBinder token, SparseArray<IBinder> windows) {
            int windowCount = windows.size();
            for (int i = 0; i < windowCount; ++i) {
                if (windows.valueAt(i) != token) continue;
                return windows.keyAt(i);
            }
            return -1;
        }
    }

    private static final class PendingEvent {
        PendingEvent next;
        KeyEvent event;
        int policyFlags;
        int sequence;
        boolean handled;

        private PendingEvent() {
        }

        public void clear() {
            if (this.event != null) {
                this.event.recycle();
                this.event = null;
            }
            this.next = null;
            this.policyFlags = 0;
            this.sequence = 0;
            this.handled = false;
        }
    }

    class Service
    extends IAccessibilityServiceConnection.Stub
    implements ServiceConnection,
    IBinder.DeathRecipient {
        final int mUserId;
        int mId = 0;
        AccessibilityServiceInfo mAccessibilityServiceInfo;
        IBinder mService;
        IAccessibilityServiceClient mServiceInterface;
        int mEventTypes;
        int mFeedbackType;
        Set<String> mPackageNames = new HashSet<String>();
        boolean mIsDefault;
        boolean mRequestTouchExplorationMode;
        boolean mRequestEnhancedWebAccessibility;
        boolean mRequestFilterKeyEvents;
        int mFetchFlags;
        long mNotificationTimeout;
        ComponentName mComponentName;
        Intent mIntent;
        boolean mIsAutomation;
        final Rect mTempBounds = new Rect();
        final ResolveInfo mResolveInfo;
        final SparseArray<AccessibilityEvent> mPendingEvents = new SparseArray();
        final KeyEventDispatcher mKeyEventDispatcher = new KeyEventDispatcher();
        boolean mWasConnectedAndDied;
        public Handler mEventDispatchHandler = new Handler(AccessibilityManagerService.access$2700(AccessibilityManagerService.this).getLooper()){

            public void handleMessage(Message message) {
                int eventType = message.what;
                Service.this.notifyAccessibilityEventInternal(eventType);
            }
        };
        public InvocationHandler mInvocationHandler = new InvocationHandler(AccessibilityManagerService.access$2700(AccessibilityManagerService.this).getLooper());

        public Service(int userId, ComponentName componentName, AccessibilityServiceInfo accessibilityServiceInfo) {
            this.mUserId = userId;
            this.mResolveInfo = accessibilityServiceInfo.getResolveInfo();
            this.mId = sIdCounter++;
            this.mComponentName = componentName;
            this.mAccessibilityServiceInfo = accessibilityServiceInfo;
            this.mIsAutomation = sFakeAccessibilityServiceComponentName.equals(componentName);
            if (!this.mIsAutomation) {
                this.mIntent = new Intent().setComponent(this.mComponentName);
                this.mIntent.putExtra("android.intent.extra.client_label", 17040557);
                this.mIntent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(AccessibilityManagerService.this.mContext, 0, new Intent("android.settings.ACCESSIBILITY_SETTINGS"), 0));
            }
            this.setDynamicallyConfigurableProperties(accessibilityServiceInfo);
        }

        public void setDynamicallyConfigurableProperties(AccessibilityServiceInfo info) {
            this.mEventTypes = info.eventTypes;
            this.mFeedbackType = info.feedbackType;
            String[] packageNames = info.packageNames;
            if (packageNames != null) {
                this.mPackageNames.addAll(Arrays.asList(packageNames));
            }
            this.mNotificationTimeout = info.notificationTimeout;
            boolean bl = this.mIsDefault = (info.flags & 1) != 0;
            if (this.mIsAutomation || info.getResolveInfo().serviceInfo.applicationInfo.targetSdkVersion >= 16) {
                this.mFetchFlags = (info.flags & 2) != 0 ? (this.mFetchFlags |= 8) : (this.mFetchFlags &= 0xFFFFFFF7);
            }
            this.mFetchFlags = (info.flags & 0x10) != 0 ? (this.mFetchFlags |= 0x10) : (this.mFetchFlags &= 0xFFFFFFEF);
            this.mRequestTouchExplorationMode = (info.flags & 4) != 0;
            this.mRequestEnhancedWebAccessibility = (info.flags & 8) != 0;
            this.mRequestFilterKeyEvents = (info.flags & 0x20) != 0;
        }

        public boolean bindLocked() {
            UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
            if (!this.mIsAutomation) {
                if (this.mService == null && AccessibilityManagerService.this.mContext.bindServiceAsUser(this.mIntent, this, 1, new UserHandle(this.mUserId))) {
                    userState.mBindingServices.add(this.mComponentName);
                }
            } else {
                userState.mBindingServices.add(this.mComponentName);
                this.mService = userState.mUiAutomationServiceClient.asBinder();
                this.onServiceConnected(this.mComponentName, this.mService);
                userState.mUiAutomationService = this;
            }
            return false;
        }

        public boolean unbindLocked() {
            if (this.mService == null) {
                return false;
            }
            UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
            this.mKeyEventDispatcher.flush();
            if (!this.mIsAutomation) {
                AccessibilityManagerService.this.mContext.unbindService(this);
            } else {
                userState.destroyUiAutomationService();
            }
            AccessibilityManagerService.this.removeServiceLocked(this, userState);
            this.resetLocked();
            return true;
        }

        public boolean canReceiveEventsLocked() {
            return this.mEventTypes != 0 && this.mFeedbackType != 0 && this.mService != null;
        }

        public void setOnKeyEventResult(boolean handled, int sequence) {
            this.mKeyEventDispatcher.setOnKeyEventResult(handled, sequence);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AccessibilityServiceInfo getServiceInfo() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                return this.mAccessibilityServiceInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setServiceInfo(AccessibilityServiceInfo info) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    AccessibilityServiceInfo oldInfo = this.mAccessibilityServiceInfo;
                    if (oldInfo != null) {
                        oldInfo.updateDynamicallyConfigurableProperties(info);
                        this.setDynamicallyConfigurableProperties(oldInfo);
                    } else {
                        this.setDynamicallyConfigurableProperties(info);
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                Binder.restoreCallingIdentity(identity);
                throw throwable;
            }
            Binder.restoreCallingIdentity(identity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder service) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mService = service;
                this.mServiceInterface = IAccessibilityServiceClient.Stub.asInterface(service);
                UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
                AccessibilityManagerService.this.addServiceLocked(this, userState);
                if (userState.mBindingServices.contains(this.mComponentName) || this.mWasConnectedAndDied) {
                    userState.mBindingServices.remove(this.mComponentName);
                    this.mWasConnectedAndDied = false;
                    try {
                        this.mServiceInterface.setConnection(this, this.mId);
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                    catch (RemoteException re) {
                        Slog.w(AccessibilityManagerService.LOG_TAG, "Error while setting connection for service: " + service, re);
                        this.binderDied();
                    }
                } else {
                    this.binderDied();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean findAccessibilityNodeInfosByViewId(int accessibilityWindowId, long accessibilityNodeId, String viewIdResName, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            boolean bl;
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                AccessibilityManagerService.this.mSecurityPolicy.enforceCanRetrieveWindowContent(this);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowContent(this);
                if (!permissionGranted) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            MagnificationSpec spec = this.getCompatibleMagnificationSpec(resolvedWindowId);
            try {
                connection.findAccessibilityNodeInfosByViewId(accessibilityNodeId, viewIdResName, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                bl = true;
                Object var17_18 = null;
            }
            catch (RemoteException re) {
                try {
                    Object var17_19 = null;
                }
                catch (Throwable throwable) {
                    Object var17_20 = null;
                    Binder.restoreCallingIdentity(identityToken);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identityToken);
                return false;
            }
            Binder.restoreCallingIdentity(identityToken);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean findAccessibilityNodeInfosByText(int accessibilityWindowId, long accessibilityNodeId, String text, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            boolean bl;
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                AccessibilityManagerService.this.mSecurityPolicy.enforceCanRetrieveWindowContent(this);
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            MagnificationSpec spec = this.getCompatibleMagnificationSpec(resolvedWindowId);
            try {
                connection.findAccessibilityNodeInfosByText(accessibilityNodeId, text, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                bl = true;
                Object var17_18 = null;
            }
            catch (RemoteException re) {
                try {
                    Object var17_19 = null;
                }
                catch (Throwable throwable) {
                    Object var17_20 = null;
                    Binder.restoreCallingIdentity(identityToken);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identityToken);
                return false;
            }
            Binder.restoreCallingIdentity(identityToken);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean findAccessibilityNodeInfoByAccessibilityId(int accessibilityWindowId, long accessibilityNodeId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, long interrogatingTid) throws RemoteException {
            boolean bl;
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                AccessibilityManagerService.this.mSecurityPolicy.enforceCanRetrieveWindowContent(this);
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            MagnificationSpec spec = this.getCompatibleMagnificationSpec(resolvedWindowId);
            try {
                connection.findAccessibilityNodeInfoByAccessibilityId(accessibilityNodeId, interactionId, callback, this.mFetchFlags | flags, interrogatingPid, interrogatingTid, spec);
                bl = true;
                Object var17_18 = null;
            }
            catch (RemoteException re) {
                try {
                    Object var17_19 = null;
                }
                catch (Throwable throwable) {
                    Object var17_20 = null;
                    Binder.restoreCallingIdentity(identityToken);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identityToken);
                return false;
            }
            Binder.restoreCallingIdentity(identityToken);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean findFocus(int accessibilityWindowId, long accessibilityNodeId, int focusType, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            boolean bl;
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                AccessibilityManagerService.this.mSecurityPolicy.enforceCanRetrieveWindowContent(this);
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            MagnificationSpec spec = this.getCompatibleMagnificationSpec(resolvedWindowId);
            try {
                connection.findFocus(accessibilityNodeId, focusType, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                bl = true;
                Object var17_18 = null;
            }
            catch (RemoteException re) {
                try {
                    Object var17_19 = null;
                }
                catch (Throwable throwable) {
                    Object var17_20 = null;
                    Binder.restoreCallingIdentity(identityToken);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identityToken);
                return false;
            }
            Binder.restoreCallingIdentity(identityToken);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean focusSearch(int accessibilityWindowId, long accessibilityNodeId, int direction, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            boolean bl;
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                AccessibilityManagerService.this.mSecurityPolicy.enforceCanRetrieveWindowContent(this);
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            MagnificationSpec spec = this.getCompatibleMagnificationSpec(resolvedWindowId);
            try {
                connection.focusSearch(accessibilityNodeId, direction, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                bl = true;
                Object var17_18 = null;
            }
            catch (RemoteException re) {
                try {
                    Object var17_19 = null;
                }
                catch (Throwable throwable) {
                    Object var17_20 = null;
                    Binder.restoreCallingIdentity(identityToken);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identityToken);
                return false;
            }
            Binder.restoreCallingIdentity(identityToken);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean performAccessibilityAction(int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                AccessibilityManagerService.this.mSecurityPolicy.enforceCanRetrieveWindowContent(this);
                int resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canPerformActionLocked(this, resolvedWindowId, action, arguments);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            try {
                try {
                    connection.performAccessibilityAction(accessibilityNodeId, action, arguments, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid);
                }
                catch (RemoteException re) {
                    Object var17_16 = null;
                    Binder.restoreCallingIdentity(identityToken);
                    return true;
                }
                Object var17_15 = null;
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                Binder.restoreCallingIdentity(identityToken);
                throw throwable;
            }
            Binder.restoreCallingIdentity(identityToken);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean performGlobalAction(int action) {
            boolean bl;
            long identity;
            block17: {
                boolean bl2;
                block16: {
                    boolean bl3;
                    block15: {
                        boolean bl4;
                        block14: {
                            boolean bl5;
                            block13: {
                                boolean bl6;
                                block12: {
                                    Object object = AccessibilityManagerService.this.mLock;
                                    synchronized (object) {
                                        int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
                                        if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                                            return false;
                                        }
                                    }
                                    identity = Binder.clearCallingIdentity();
                                    try {
                                        switch (action) {
                                            case 1: {
                                                this.sendDownAndUpKeyEvents(4);
                                                bl6 = true;
                                                Object var6_11 = null;
                                                break block12;
                                            }
                                            case 2: {
                                                this.sendDownAndUpKeyEvents(3);
                                                bl5 = true;
                                                break block13;
                                            }
                                            case 3: {
                                                this.openRecents();
                                                bl4 = true;
                                                break block14;
                                            }
                                            case 4: {
                                                this.expandNotifications();
                                                bl3 = true;
                                                break block15;
                                            }
                                            case 5: {
                                                this.expandQuickSettings();
                                                bl2 = true;
                                                break block16;
                                            }
                                            default: {
                                                bl = false;
                                                break;
                                            }
                                        }
                                        break block17;
                                    }
                                    catch (Throwable throwable) {
                                        Object var6_17 = null;
                                        Binder.restoreCallingIdentity(identity);
                                        throw throwable;
                                    }
                                }
                                Binder.restoreCallingIdentity(identity);
                                return bl6;
                            }
                            Object var6_12 = null;
                            Binder.restoreCallingIdentity(identity);
                            return bl5;
                        }
                        Object var6_13 = null;
                        Binder.restoreCallingIdentity(identity);
                        return bl4;
                    }
                    Object var6_14 = null;
                    Binder.restoreCallingIdentity(identity);
                    return bl3;
                }
                Object var6_15 = null;
                Binder.restoreCallingIdentity(identity);
                return bl2;
            }
            Object var6_16 = null;
            Binder.restoreCallingIdentity(identity);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            AccessibilityManagerService.this.mSecurityPolicy.enforceCallingPermission("android.permission.DUMP", AccessibilityManagerService.FUNCTION_DUMP);
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                pw.append("Service[label=" + this.mAccessibilityServiceInfo.getResolveInfo().loadLabel(AccessibilityManagerService.this.mContext.getPackageManager()));
                pw.append(", feedbackType" + AccessibilityServiceInfo.feedbackTypeToString(this.mFeedbackType));
                pw.append(", capabilities=" + this.mAccessibilityServiceInfo.getCapabilities());
                pw.append(", eventTypes=" + AccessibilityEvent.eventTypeToString(this.mEventTypes));
                pw.append(", notificationTimeout=" + this.mNotificationTimeout);
                pw.append("]");
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }

        public void linkToOwnDeathLocked() throws RemoteException {
            this.mService.linkToDeath(this, 0);
        }

        public void unlinkToOwnDeathLocked() {
            this.mService.unlinkToDeath(this, 0);
        }

        public void resetLocked() {
            try {
                this.mServiceInterface.setConnection(null, this.mId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mService = null;
            this.mServiceInterface = null;
        }

        public boolean isConnectedLocked() {
            return this.mService != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isConnectedLocked()) {
                    return;
                }
                this.mWasConnectedAndDied = true;
                this.mKeyEventDispatcher.flush();
                UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
                AccessibilityManagerService.this.removeServiceLocked(this, userState);
                this.resetLocked();
                if (this.mIsAutomation) {
                    userState.mInstalledServices.remove(this.mAccessibilityServiceInfo);
                    userState.mEnabledServices.remove(this.mComponentName);
                    userState.destroyUiAutomationService();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyAccessibilityEvent(AccessibilityEvent event) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int eventType = event.getEventType();
                AccessibilityEvent newEvent = AccessibilityEvent.obtain(event);
                AccessibilityEvent oldEvent = this.mPendingEvents.get(eventType);
                this.mPendingEvents.put(eventType, newEvent);
                int what = eventType;
                if (oldEvent != null) {
                    this.mEventDispatchHandler.removeMessages(what);
                    oldEvent.recycle();
                }
                Message message = this.mEventDispatchHandler.obtainMessage(what);
                this.mEventDispatchHandler.sendMessageDelayed(message, this.mNotificationTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAccessibilityEventInternal(int eventType) {
            AccessibilityEvent event;
            IAccessibilityServiceClient listener;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
                if (listener == null) {
                    return;
                }
                event = this.mPendingEvents.get(eventType);
                if (event == null) {
                    return;
                }
                this.mPendingEvents.remove(eventType);
                if (AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowContent(this)) {
                    event.setConnectionId(this.mId);
                } else {
                    event.setSource(null);
                }
                event.setSealed(true);
            }
            try {
                try {
                    listener.onAccessibilityEvent(event);
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error during sending " + event + " to " + listener, re);
                    Object var7_8 = null;
                    event.recycle();
                }
                Object var7_7 = null;
                event.recycle();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                event.recycle();
                throw throwable;
            }
        }

        public void notifyGesture(int gestureId) {
            this.mInvocationHandler.obtainMessage(1, gestureId, 0).sendToTarget();
        }

        public void notifyKeyEvent(KeyEvent event, int policyFlags) {
            this.mInvocationHandler.obtainMessage(2, policyFlags, 0, event).sendToTarget();
        }

        public void notifyClearAccessibilityNodeInfoCache() {
            this.mInvocationHandler.sendEmptyMessage(3);
        }

        private void notifyGestureInternal(int gestureId) {
            IAccessibilityServiceClient listener = this.mServiceInterface;
            if (listener != null) {
                try {
                    listener.onGesture(gestureId);
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error during sending gesture " + gestureId + " to " + this.mService, re);
                }
            }
        }

        private void notifyKeyEventInternal(KeyEvent event, int policyFlags) {
            this.mKeyEventDispatcher.notifyKeyEvent(event, policyFlags);
        }

        private void notifyClearAccessibilityNodeInfoCacheInternal() {
            IAccessibilityServiceClient listener = this.mServiceInterface;
            if (listener != null) {
                try {
                    listener.clearAccessibilityNodeInfoCache();
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error during requesting accessibility info cache to be cleared.", re);
                }
            }
        }

        private void sendDownAndUpKeyEvents(int keyCode) {
            long token = Binder.clearCallingIdentity();
            long downTime = SystemClock.uptimeMillis();
            KeyEvent down = KeyEvent.obtain(downTime, downTime, 0, keyCode, 0, 0, -1, 0, 8, 257, null);
            InputManager.getInstance().injectInputEvent(down, 0);
            down.recycle();
            long upTime = SystemClock.uptimeMillis();
            KeyEvent up = KeyEvent.obtain(downTime, upTime, 1, keyCode, 0, 0, -1, 0, 8, 257, null);
            InputManager.getInstance().injectInputEvent(up, 0);
            up.recycle();
            Binder.restoreCallingIdentity(token);
        }

        private void expandNotifications() {
            long token = Binder.clearCallingIdentity();
            StatusBarManager statusBarManager = (StatusBarManager)AccessibilityManagerService.this.mContext.getSystemService("statusbar");
            statusBarManager.expandNotificationsPanel();
            Binder.restoreCallingIdentity(token);
        }

        private void expandQuickSettings() {
            long token = Binder.clearCallingIdentity();
            StatusBarManager statusBarManager = (StatusBarManager)AccessibilityManagerService.this.mContext.getSystemService("statusbar");
            statusBarManager.expandSettingsPanel();
            Binder.restoreCallingIdentity(token);
        }

        private void openRecents() {
            long token = Binder.clearCallingIdentity();
            IStatusBarService statusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
            try {
                statusBarService.toggleRecentApps();
            }
            catch (RemoteException e) {
                Slog.e(AccessibilityManagerService.LOG_TAG, "Error toggling recent apps.");
            }
            Binder.restoreCallingIdentity(token);
        }

        private IAccessibilityInteractionConnection getConnectionLocked(int windowId) {
            AccessibilityConnectionWrapper wrapper = (AccessibilityConnectionWrapper)AccessibilityManagerService.this.mGlobalInteractionConnections.get(windowId);
            if (wrapper == null) {
                wrapper = ((AccessibilityManagerService)AccessibilityManagerService.this).getCurrentUserStateLocked().mInteractionConnections.get(windowId);
            }
            if (wrapper != null && wrapper.mConnection != null) {
                return wrapper.mConnection;
            }
            return null;
        }

        private int resolveAccessibilityWindowIdLocked(int accessibilityWindowId) {
            if (accessibilityWindowId == -1) {
                return AccessibilityManagerService.this.mSecurityPolicy.mActiveWindowId;
            }
            return accessibilityWindowId;
        }

        private MagnificationSpec getCompatibleMagnificationSpec(int windowId) {
            try {
                IBinder windowToken = (IBinder)AccessibilityManagerService.this.mGlobalWindowTokens.get(windowId);
                if (windowToken == null) {
                    windowToken = ((AccessibilityManagerService)AccessibilityManagerService.this).getCurrentUserStateLocked().mWindowTokens.get(windowId);
                }
                if (windowToken != null) {
                    return AccessibilityManagerService.this.mWindowManagerService.getCompatibleMagnificationSpecForWindow(windowToken);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return null;
        }

        private final class KeyEventDispatcher {
            private static final long ON_KEY_EVENT_TIMEOUT_MILLIS = 500L;
            private PendingEvent mPendingEvents;
            private final InputEventConsistencyVerifier mSentEventsVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0, KeyEventDispatcher.class.getSimpleName()) : null;

            private KeyEventDispatcher() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notifyKeyEvent(KeyEvent event, int policyFlags) {
                PendingEvent pendingEvent;
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    pendingEvent = this.addPendingEventLocked(event, policyFlags);
                }
                Message message = Service.this.mInvocationHandler.obtainMessage(4, pendingEvent);
                Service.this.mInvocationHandler.sendMessageDelayed(message, 500L);
                try {
                    Service.this.mServiceInterface.onKeyEvent(pendingEvent.event, pendingEvent.sequence);
                }
                catch (RemoteException re) {
                    this.setOnKeyEventResult(false, pendingEvent.sequence);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setOnKeyEventResult(boolean handled, int sequence) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    PendingEvent pendingEvent = this.removePendingEventLocked(sequence);
                    if (pendingEvent != null) {
                        Service.this.mInvocationHandler.removeMessages(4, pendingEvent);
                        pendingEvent.handled = handled;
                        this.finishPendingEventLocked(pendingEvent);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void flush() {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    this.cancelAllPendingEventsLocked();
                    if (this.mSentEventsVerifier != null) {
                        this.mSentEventsVerifier.reset();
                    }
                }
            }

            private PendingEvent addPendingEventLocked(KeyEvent event, int policyFlags) {
                int sequence = event.getSequenceNumber();
                PendingEvent pendingEvent = AccessibilityManagerService.this.obtainPendingEventLocked(event, policyFlags, sequence);
                pendingEvent.next = this.mPendingEvents;
                this.mPendingEvents = pendingEvent;
                return pendingEvent;
            }

            private PendingEvent removePendingEventLocked(int sequence) {
                PendingEvent previous = null;
                PendingEvent current = this.mPendingEvents;
                while (current != null) {
                    if (current.sequence == sequence) {
                        if (previous != null) {
                            previous.next = current.next;
                        } else {
                            this.mPendingEvents = current.next;
                        }
                        current.next = null;
                        return current;
                    }
                    previous = current;
                    current = current.next;
                }
                return null;
            }

            private void finishPendingEventLocked(PendingEvent pendingEvent) {
                if (!pendingEvent.handled) {
                    this.sendKeyEventToInputFilter(pendingEvent.event, pendingEvent.policyFlags);
                }
                pendingEvent.event = null;
                AccessibilityManagerService.this.recyclePendingEventLocked(pendingEvent);
            }

            private void sendKeyEventToInputFilter(KeyEvent event, int policyFlags) {
                if (this.mSentEventsVerifier != null) {
                    this.mSentEventsVerifier.onKeyEvent(event, 0);
                }
                AccessibilityManagerService.this.mMainHandler.obtainMessage(8, policyFlags |= 0x40000000, 0, event).sendToTarget();
            }

            private void cancelAllPendingEventsLocked() {
                while (this.mPendingEvents != null) {
                    PendingEvent pendingEvent = this.removePendingEventLocked(this.mPendingEvents.sequence);
                    pendingEvent.handled = false;
                    Service.this.mInvocationHandler.removeMessages(4, pendingEvent);
                    this.finishPendingEventLocked(pendingEvent);
                }
            }
        }

        private final class InvocationHandler
        extends Handler {
            public static final int MSG_ON_GESTURE = 1;
            public static final int MSG_ON_KEY_EVENT = 2;
            public static final int MSG_CLEAR_ACCESSIBILITY_NODE_INFO_CACHE = 3;
            public static final int MSG_ON_KEY_EVENT_TIMEOUT = 4;

            public InvocationHandler(Looper looper) {
                super(looper, null, true);
            }

            public void handleMessage(Message message) {
                int type = message.what;
                switch (type) {
                    case 1: {
                        int gestureId = message.arg1;
                        Service.this.notifyGestureInternal(gestureId);
                        break;
                    }
                    case 2: {
                        KeyEvent event = (KeyEvent)message.obj;
                        int policyFlags = message.arg1;
                        Service.this.notifyKeyEventInternal(event, policyFlags);
                        break;
                    }
                    case 3: {
                        Service.this.notifyClearAccessibilityNodeInfoCacheInternal();
                        break;
                    }
                    case 4: {
                        PendingEvent eventState = (PendingEvent)message.obj;
                        Service.this.setOnKeyEventResult(false, eventState.sequence);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown message: " + type);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MainHandler
    extends Handler {
        public static final int MSG_SEND_ACCESSIBILITY_EVENT_TO_INPUT_FILTER = 1;
        public static final int MSG_SEND_STATE_TO_CLIENTS = 2;
        public static final int MSG_SEND_CLEARED_STATE_TO_CLIENTS_FOR_USER = 3;
        public static final int MSG_UPDATE_ACTIVE_WINDOW = 4;
        public static final int MSG_ANNOUNCE_NEW_USER_IF_NEEDED = 5;
        public static final int MSG_UPDATE_INPUT_FILTER = 6;
        public static final int MSG_SHOW_ENABLED_TOUCH_EXPLORATION_DIALOG = 7;
        public static final int MSG_SEND_KEY_EVENT_TO_INPUT_FILTER = 8;

        public MainHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            int type = msg.what;
            switch (type) {
                case 1: {
                    AccessibilityEvent event = (AccessibilityEvent)msg.obj;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mHasInputFilter && AccessibilityManagerService.this.mInputFilter != null) {
                            AccessibilityManagerService.this.mInputFilter.notifyAccessibilityEvent(event);
                        }
                    }
                    event.recycle();
                    break;
                }
                case 8: {
                    KeyEvent event = (KeyEvent)msg.obj;
                    int policyFlags = msg.arg1;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mHasInputFilter && AccessibilityManagerService.this.mInputFilter != null) {
                            AccessibilityManagerService.this.mInputFilter.sendInputEvent(event, policyFlags);
                        }
                    }
                    event.recycle();
                    break;
                }
                case 2: {
                    int clientState = msg.arg1;
                    int userId = msg.arg2;
                    this.sendStateToClients(clientState, AccessibilityManagerService.this.mGlobalClients);
                    this.sendStateToClientsForUser(clientState, userId);
                    break;
                }
                case 3: {
                    int userId = msg.arg1;
                    this.sendStateToClientsForUser(0, userId);
                    break;
                }
                case 4: {
                    int windowId = msg.arg1;
                    int eventType = msg.arg2;
                    AccessibilityManagerService.this.mSecurityPolicy.updateActiveWindow(windowId, eventType);
                    break;
                }
                case 5: {
                    this.announceNewUserIfNeeded();
                    break;
                }
                case 6: {
                    UserState userState = (UserState)msg.obj;
                    AccessibilityManagerService.this.updateInputFilter(userState);
                    break;
                }
                case 7: {
                    Service service = (Service)msg.obj;
                    AccessibilityManagerService.this.showEnableTouchExplorationDialog(service);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void announceNewUserIfNeeded() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                if (userState.mIsAccessibilityEnabled) {
                    UserManager userManager = (UserManager)AccessibilityManagerService.this.mContext.getSystemService("user");
                    String message = AccessibilityManagerService.this.mContext.getString(17040760, userManager.getUserInfo((int)((AccessibilityManagerService)AccessibilityManagerService.this).mCurrentUserId).name);
                    AccessibilityEvent event = AccessibilityEvent.obtain(16384);
                    event.getText().add(message);
                    event.setWindowId(AccessibilityManagerService.this.mSecurityPolicy.getRetrievalAllowingWindowLocked());
                    AccessibilityManagerService.this.sendAccessibilityEvent(event, AccessibilityManagerService.this.mCurrentUserId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendStateToClientsForUser(int clientState, int userId) {
            UserState userState;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                userState = AccessibilityManagerService.this.getUserStateLocked(userId);
            }
            this.sendStateToClients(clientState, userState.mClients);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendStateToClients(int clientState, RemoteCallbackList<IAccessibilityManagerClient> clients) {
            try {
                int userClientCount = clients.beginBroadcast();
                for (int i = 0; i < userClientCount; ++i) {
                    IAccessibilityManagerClient client = clients.getBroadcastItem(i);
                    try {
                        client.setState(clientState);
                        continue;
                    }
                    catch (RemoteException re) {
                        // empty catch block
                    }
                }
                Object var8_7 = null;
                clients.finishBroadcast();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                clients.finishBroadcast();
                throw throwable;
            }
        }
    }

    private class AccessibilityConnectionWrapper
    implements IBinder.DeathRecipient {
        private final int mWindowId;
        private final int mUserId;
        private final IAccessibilityInteractionConnection mConnection;

        public AccessibilityConnectionWrapper(int windowId, IAccessibilityInteractionConnection connection, int userId) {
            this.mWindowId = windowId;
            this.mUserId = userId;
            this.mConnection = connection;
        }

        public void linkToDeath() throws RemoteException {
            this.mConnection.asBinder().linkToDeath(this, 0);
        }

        public void unlinkToDeath() {
            this.mConnection.asBinder().unlinkToDeath(this, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            this.unlinkToDeath();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.removeAccessibilityInteractionConnectionLocked(this.mWindowId, this.mUserId);
            }
        }
    }
}

