/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.content.Context;
import android.gesture.Gesture;
import android.gesture.GestureLibraries;
import android.gesture.GestureLibrary;
import android.gesture.GesturePoint;
import android.gesture.GestureStroke;
import android.gesture.Prediction;
import android.graphics.Rect;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Slog;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.android.server.accessibility.AccessibilityManagerService;
import com.android.server.accessibility.EventStreamTransformation;
import com.android.server.accessibility.GestureUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class TouchExplorer
implements EventStreamTransformation {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "TouchExplorer";
    private static final int STATE_TOUCH_EXPLORING = 1;
    private static final int STATE_DRAGGING = 2;
    private static final int STATE_DELEGATING = 4;
    private static final int STATE_GESTURE_DETECTING = 5;
    private static final float MAX_DRAGGING_ANGLE_COS = 0.52532196f;
    private static final int ALL_POINTER_ID_BITS = -1;
    private static final int MAX_POINTER_COUNT = 32;
    private static final int INVALID_POINTER_ID = -1;
    private static final int GESTURE_DETECTION_VELOCITY_DIP = 1000;
    private static final int MIN_POINTER_DISTANCE_TO_USE_MIDDLE_LOCATION_DIP = 200;
    private static final int EXIT_GESTURE_DETECTION_TIMEOUT = 2000;
    private final int mDetermineUserIntentTimeout;
    private final int mTapTimeout;
    private final int mDoubleTapTimeout;
    private final int mTouchSlop;
    private final int mDoubleTapSlop;
    private int mCurrentState = 1;
    private int mDraggingPointerId;
    private final Handler mHandler;
    private final SendHoverEnterAndMoveDelayed mSendHoverEnterAndMoveDelayed;
    private final SendHoverExitDelayed mSendHoverExitDelayed;
    private final SendAccessibilityEventDelayed mSendTouchExplorationEndDelayed;
    private final SendAccessibilityEventDelayed mSendTouchInteractionEndDelayed;
    private final PerformLongPressDelayed mPerformLongPressDelayed;
    private final ExitGestureDetectionModeDelayed mExitGestureDetectionModeDelayed;
    private final DoubleTapDetector mDoubleTapDetector;
    private final int mScaledMinPointerDistanceToUseMiddleLocation;
    private final int mScaledGestureDetectionVelocity;
    private EventStreamTransformation mNext;
    private final VelocityTracker mVelocityTracker = VelocityTracker.obtain();
    private final ReceivedPointerTracker mReceivedPointerTracker;
    private final InjectedPointerTracker mInjectedPointerTracker;
    private final AccessibilityManagerService mAms;
    private final Rect mTempRect = new Rect();
    private final Context mContext;
    private float mPreviousX;
    private float mPreviousY;
    private final ArrayList<GesturePoint> mStrokeBuffer = new ArrayList(100);
    private static final int TOUCH_TOLERANCE = 3;
    private static final float MIN_PREDICTION_SCORE = 2.0f;
    private GestureLibrary mGestureLibrary;
    private int mLongPressingPointerId = -1;
    private int mLongPressingPointerDeltaX;
    private int mLongPressingPointerDeltaY;
    private int mLastTouchedWindowId;
    private boolean mTouchExplorationInProgress;

    public TouchExplorer(Context context, AccessibilityManagerService service) {
        this.mContext = context;
        this.mAms = service;
        this.mReceivedPointerTracker = new ReceivedPointerTracker();
        this.mInjectedPointerTracker = new InjectedPointerTracker();
        this.mTapTimeout = ViewConfiguration.getTapTimeout();
        this.mDetermineUserIntentTimeout = ViewConfiguration.getDoubleTapTimeout();
        this.mDoubleTapTimeout = ViewConfiguration.getDoubleTapTimeout();
        this.mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.mDoubleTapSlop = ViewConfiguration.get(context).getScaledDoubleTapSlop();
        this.mHandler = new Handler(context.getMainLooper());
        this.mPerformLongPressDelayed = new PerformLongPressDelayed();
        this.mExitGestureDetectionModeDelayed = new ExitGestureDetectionModeDelayed();
        this.mGestureLibrary = GestureLibraries.fromRawResource(context, 0x1100000);
        this.mGestureLibrary.setOrientationStyle(8);
        this.mGestureLibrary.setSequenceType(2);
        this.mGestureLibrary.load();
        this.mSendHoverEnterAndMoveDelayed = new SendHoverEnterAndMoveDelayed();
        this.mSendHoverExitDelayed = new SendHoverExitDelayed();
        this.mSendTouchExplorationEndDelayed = new SendAccessibilityEventDelayed(1024, this.mDetermineUserIntentTimeout);
        this.mSendTouchInteractionEndDelayed = new SendAccessibilityEventDelayed(0x200000, this.mDetermineUserIntentTimeout);
        this.mDoubleTapDetector = new DoubleTapDetector();
        float density = context.getResources().getDisplayMetrics().density;
        this.mScaledMinPointerDistanceToUseMiddleLocation = (int)(200.0f * density);
        this.mScaledGestureDetectionVelocity = (int)(1000.0f * density);
    }

    public void clear() {
        MotionEvent event = this.mReceivedPointerTracker.getLastReceivedEvent();
        if (event != null) {
            this.clear(this.mReceivedPointerTracker.getLastReceivedEvent(), 0x2000000);
        }
    }

    public void onDestroy() {
    }

    private void clear(MotionEvent event, int policyFlags) {
        switch (this.mCurrentState) {
            case 1: {
                this.sendHoverExitAndTouchExplorationGestureEndIfNeeded(policyFlags);
                break;
            }
            case 2: {
                this.mDraggingPointerId = -1;
                this.sendUpForInjectedDownPointers(event, policyFlags);
                break;
            }
            case 4: {
                this.sendUpForInjectedDownPointers(event, policyFlags);
                break;
            }
            case 5: {
                this.mStrokeBuffer.clear();
            }
        }
        this.mSendHoverEnterAndMoveDelayed.cancel();
        this.mSendHoverExitDelayed.cancel();
        this.mPerformLongPressDelayed.cancel();
        this.mExitGestureDetectionModeDelayed.cancel();
        this.mSendTouchExplorationEndDelayed.cancel();
        this.mSendTouchInteractionEndDelayed.cancel();
        this.mReceivedPointerTracker.clear();
        this.mInjectedPointerTracker.clear();
        this.mDoubleTapDetector.clear();
        this.mLongPressingPointerId = -1;
        this.mLongPressingPointerDeltaX = 0;
        this.mLongPressingPointerDeltaY = 0;
        this.mCurrentState = 1;
        if (this.mNext != null) {
            this.mNext.clear();
        }
        this.mTouchExplorationInProgress = false;
        this.mAms.onTouchInteractionEnd();
    }

    public void setNext(EventStreamTransformation next) {
        this.mNext = next;
    }

    public void onMotionEvent(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        this.mReceivedPointerTracker.onMotionEvent(rawEvent);
        switch (this.mCurrentState) {
            case 1: {
                this.handleMotionEventStateTouchExploring(event, rawEvent, policyFlags);
                break;
            }
            case 2: {
                this.handleMotionEventStateDragging(event, policyFlags);
                break;
            }
            case 4: {
                this.handleMotionEventStateDelegating(event, policyFlags);
                break;
            }
            case 5: {
                this.handleMotionEventGestureDetecting(rawEvent, policyFlags);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal state: " + this.mCurrentState);
            }
        }
    }

    public void onAccessibilityEvent(AccessibilityEvent event) {
        int eventType = event.getEventType();
        if (this.mSendTouchExplorationEndDelayed.isPending() && eventType == 256) {
            this.mSendTouchExplorationEndDelayed.cancel();
            this.sendAccessibilityEvent(1024);
        }
        if (this.mSendTouchInteractionEndDelayed.isPending() && eventType == 256) {
            this.mSendTouchInteractionEndDelayed.cancel();
            this.sendAccessibilityEvent(0x200000);
        }
        switch (eventType) {
            case 32: 
            case 32768: {
                if (this.mInjectedPointerTracker.mLastInjectedHoverEventForClick != null) {
                    this.mInjectedPointerTracker.mLastInjectedHoverEventForClick.recycle();
                    this.mInjectedPointerTracker.mLastInjectedHoverEventForClick = null;
                }
                this.mLastTouchedWindowId = -1;
                break;
            }
            case 128: 
            case 256: {
                this.mLastTouchedWindowId = event.getWindowId();
            }
        }
        if (this.mNext != null) {
            this.mNext.onAccessibilityEvent(event);
        }
    }

    private void handleMotionEventStateTouchExploring(MotionEvent event, MotionEvent rawEvent, int policyFlags) {
        ReceivedPointerTracker receivedTracker = this.mReceivedPointerTracker;
        this.mVelocityTracker.addMovement(rawEvent);
        this.mDoubleTapDetector.onMotionEvent(event, policyFlags);
        block0 : switch (event.getActionMasked()) {
            case 0: {
                this.mAms.onTouchInteractionStart();
                this.handleMotionEventGestureDetecting(rawEvent, policyFlags);
                this.sendAccessibilityEvent(0x100000);
                this.mSendHoverEnterAndMoveDelayed.cancel();
                this.mSendHoverExitDelayed.cancel();
                this.mPerformLongPressDelayed.cancel();
                if (this.mSendTouchExplorationEndDelayed.isPending()) {
                    this.mSendTouchExplorationEndDelayed.forceSendAndRemove();
                }
                if (this.mSendTouchInteractionEndDelayed.isPending()) {
                    this.mSendTouchInteractionEndDelayed.forceSendAndRemove();
                }
                if (this.mDoubleTapDetector.firstTapDetected()) {
                    this.mPerformLongPressDelayed.post(event, policyFlags);
                    break;
                }
                if (this.mTouchExplorationInProgress) break;
                if (!this.mSendHoverEnterAndMoveDelayed.isPending()) {
                    int pointerId = receivedTracker.getPrimaryPointerId();
                    int pointerIdBits = 1 << pointerId;
                    this.mSendHoverEnterAndMoveDelayed.post(event, true, pointerIdBits, policyFlags);
                }
                this.mSendHoverEnterAndMoveDelayed.addEvent(event);
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                int pointerId = receivedTracker.getPrimaryPointerId();
                int pointerIndex = event.findPointerIndex(pointerId);
                int pointerIdBits = 1 << pointerId;
                switch (event.getPointerCount()) {
                    case 1: {
                        float deltaY;
                        float deltaX;
                        double moveDelta;
                        if (this.mSendHoverEnterAndMoveDelayed.isPending()) {
                            this.handleMotionEventGestureDetecting(rawEvent, policyFlags);
                            this.mSendHoverEnterAndMoveDelayed.addEvent(event);
                            float deltaX2 = receivedTracker.getReceivedPointerDownX(pointerId) - rawEvent.getX(pointerIndex);
                            float deltaY2 = receivedTracker.getReceivedPointerDownY(pointerId) - rawEvent.getY(pointerIndex);
                            double moveDelta2 = Math.hypot(deltaX2, deltaY2);
                            if (!(moveDelta2 > (double)this.mDoubleTapSlop)) break block0;
                            this.mVelocityTracker.computeCurrentVelocity(1000);
                            float maxAbsVelocity = Math.max(Math.abs(this.mVelocityTracker.getXVelocity(pointerId)), Math.abs(this.mVelocityTracker.getYVelocity(pointerId)));
                            if (maxAbsVelocity > (float)this.mScaledGestureDetectionVelocity) {
                                this.mCurrentState = 5;
                                this.mVelocityTracker.clear();
                                this.mSendHoverEnterAndMoveDelayed.cancel();
                                this.mSendHoverExitDelayed.cancel();
                                this.mPerformLongPressDelayed.cancel();
                                this.mExitGestureDetectionModeDelayed.post();
                                this.sendAccessibilityEvent(262144);
                                break;
                            }
                            this.mSendHoverEnterAndMoveDelayed.forceSendAndRemove();
                            this.mSendHoverExitDelayed.cancel();
                            this.mPerformLongPressDelayed.cancel();
                            this.sendMotionEvent(event, 7, pointerIdBits, policyFlags);
                            break;
                        }
                        if (this.mPerformLongPressDelayed.isPending() && (moveDelta = Math.hypot(deltaX = receivedTracker.getReceivedPointerDownX(pointerId) - rawEvent.getX(pointerIndex), deltaY = receivedTracker.getReceivedPointerDownY(pointerId) - rawEvent.getY(pointerIndex))) > (double)this.mTouchSlop) {
                            this.mPerformLongPressDelayed.cancel();
                        }
                        if (this.mDoubleTapDetector.firstTapDetected()) break;
                        this.sendTouchExplorationGestureStartAndHoverEnterIfNeeded(policyFlags);
                        this.sendMotionEvent(event, 7, pointerIdBits, policyFlags);
                        break;
                    }
                    case 2: {
                        if (this.mSendHoverEnterAndMoveDelayed.isPending()) {
                            this.mSendHoverEnterAndMoveDelayed.cancel();
                            this.mSendHoverExitDelayed.cancel();
                            this.mPerformLongPressDelayed.cancel();
                        } else {
                            this.mPerformLongPressDelayed.cancel();
                            float deltaX = receivedTracker.getReceivedPointerDownX(pointerId) - rawEvent.getX(pointerIndex);
                            float deltaY = receivedTracker.getReceivedPointerDownY(pointerId) - rawEvent.getY(pointerIndex);
                            double moveDelta = Math.hypot(deltaX, deltaY);
                            if (moveDelta < (double)this.mDoubleTapSlop) break;
                            this.sendHoverExitAndTouchExplorationGestureEndIfNeeded(policyFlags);
                        }
                        this.mStrokeBuffer.clear();
                        if (this.isDraggingGesture(event)) {
                            this.mCurrentState = 2;
                            this.mDraggingPointerId = pointerId;
                            event.setEdgeFlags(receivedTracker.getLastReceivedDownEdgeFlags());
                            this.sendMotionEvent(event, 0, pointerIdBits, policyFlags);
                        } else {
                            this.mCurrentState = 4;
                            this.sendDownForAllNotInjectedPointers(event, policyFlags);
                        }
                        this.mVelocityTracker.clear();
                        break;
                    }
                    default: {
                        if (this.mSendHoverEnterAndMoveDelayed.isPending()) {
                            this.mSendHoverEnterAndMoveDelayed.cancel();
                            this.mSendHoverExitDelayed.cancel();
                            this.mPerformLongPressDelayed.cancel();
                        } else {
                            this.mPerformLongPressDelayed.cancel();
                            this.sendHoverExitAndTouchExplorationGestureEndIfNeeded(policyFlags);
                        }
                        this.mCurrentState = 4;
                        this.sendDownForAllNotInjectedPointers(event, policyFlags);
                        this.mVelocityTracker.clear();
                        break;
                    }
                }
                break;
            }
            case 1: {
                this.mAms.onTouchInteractionEnd();
                this.mStrokeBuffer.clear();
                int pointerId = event.getPointerId(event.getActionIndex());
                int pointerIdBits = 1 << pointerId;
                this.mPerformLongPressDelayed.cancel();
                this.mVelocityTracker.clear();
                if (this.mSendHoverEnterAndMoveDelayed.isPending()) {
                    this.mSendHoverExitDelayed.post(event, pointerIdBits, policyFlags);
                } else {
                    this.sendHoverExitAndTouchExplorationGestureEndIfNeeded(policyFlags);
                }
                if (this.mSendTouchInteractionEndDelayed.isPending()) break;
                this.mSendTouchInteractionEndDelayed.post();
                break;
            }
            case 3: {
                this.clear(event, policyFlags);
            }
        }
    }

    private void handleMotionEventStateDragging(MotionEvent event, int policyFlags) {
        int pointerIdBits = 1 << this.mDraggingPointerId;
        block0 : switch (event.getActionMasked()) {
            case 0: {
                throw new IllegalStateException("Dragging state can be reached only if two pointers are already down");
            }
            case 5: {
                this.mCurrentState = 4;
                if (this.mDraggingPointerId != -1) {
                    this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                }
                this.sendDownForAllNotInjectedPointers(event, policyFlags);
                break;
            }
            case 2: {
                switch (event.getPointerCount()) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        if (this.isDraggingGesture(event)) {
                            float secondPtrY;
                            float deltaY;
                            float firstPtrX = event.getX(0);
                            float firstPtrY = event.getY(0);
                            float secondPtrX = event.getX(1);
                            float deltaX = firstPtrX - secondPtrX;
                            double distance = Math.hypot(deltaX, deltaY = firstPtrY - (secondPtrY = event.getY(1)));
                            if (distance > (double)this.mScaledMinPointerDistanceToUseMiddleLocation) {
                                event.setLocation(deltaX / 2.0f, deltaY / 2.0f);
                            }
                            this.sendMotionEvent(event, 2, pointerIdBits, policyFlags);
                            break block0;
                        }
                        this.mCurrentState = 4;
                        this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                        this.sendDownForAllNotInjectedPointers(event, policyFlags);
                        break block0;
                    }
                }
                this.mCurrentState = 4;
                this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                this.sendDownForAllNotInjectedPointers(event, policyFlags);
                break;
            }
            case 6: {
                int pointerId = event.getPointerId(event.getActionIndex());
                if (pointerId != this.mDraggingPointerId) break;
                this.mDraggingPointerId = -1;
                this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                break;
            }
            case 1: {
                this.mAms.onTouchInteractionEnd();
                this.sendAccessibilityEvent(0x200000);
                int pointerId = event.getPointerId(event.getActionIndex());
                if (pointerId == this.mDraggingPointerId) {
                    this.mDraggingPointerId = -1;
                    this.sendMotionEvent(event, 1, pointerIdBits, policyFlags);
                }
                this.mCurrentState = 1;
                break;
            }
            case 3: {
                this.clear(event, policyFlags);
            }
        }
    }

    private void handleMotionEventStateDelegating(MotionEvent event, int policyFlags) {
        switch (event.getActionMasked()) {
            case 0: {
                throw new IllegalStateException("Delegating state can only be reached if there is at least one pointer down!");
            }
            case 1: {
                this.mAms.onTouchInteractionEnd();
                this.sendAccessibilityEvent(0x200000);
                this.mLongPressingPointerId = -1;
                this.mLongPressingPointerDeltaX = 0;
                this.mLongPressingPointerDeltaY = 0;
                this.mCurrentState = 1;
                break;
            }
            case 3: {
                this.clear(event, policyFlags);
            }
        }
        this.sendMotionEvent(event, event.getAction(), -1, policyFlags);
    }

    private void handleMotionEventGestureDetecting(MotionEvent event, int policyFlags) {
        switch (event.getActionMasked()) {
            case 0: {
                float x = event.getX();
                float y = event.getY();
                this.mPreviousX = x;
                this.mPreviousY = y;
                this.mStrokeBuffer.add(new GesturePoint(x, y, event.getEventTime()));
                break;
            }
            case 2: {
                float x = event.getX();
                float y = event.getY();
                float dX = Math.abs(x - this.mPreviousX);
                float dY = Math.abs(y - this.mPreviousY);
                if (!(dX >= 3.0f) && !(dY >= 3.0f)) break;
                this.mPreviousX = x;
                this.mPreviousY = y;
                this.mStrokeBuffer.add(new GesturePoint(x, y, event.getEventTime()));
                break;
            }
            case 1: {
                this.mAms.onTouchInteractionEnd();
                this.sendAccessibilityEvent(524288);
                this.sendAccessibilityEvent(0x200000);
                float x = event.getX();
                float y = event.getY();
                this.mStrokeBuffer.add(new GesturePoint(x, y, event.getEventTime()));
                Gesture gesture = new Gesture();
                gesture.addStroke(new GestureStroke(this.mStrokeBuffer));
                ArrayList<Prediction> predictions = this.mGestureLibrary.recognize(gesture);
                if (!predictions.isEmpty()) {
                    Prediction bestPrediction = predictions.get(0);
                    if (bestPrediction.score >= 2.0) {
                        try {
                            int gestureId = Integer.parseInt(bestPrediction.name);
                            this.mAms.onGesture(gestureId);
                        }
                        catch (NumberFormatException nfe) {
                            Slog.w(LOG_TAG, "Non numeric gesture id:" + bestPrediction.name);
                        }
                    }
                }
                this.mStrokeBuffer.clear();
                this.mExitGestureDetectionModeDelayed.cancel();
                this.mCurrentState = 1;
                break;
            }
            case 3: {
                this.clear(event, policyFlags);
            }
        }
    }

    private void sendAccessibilityEvent(int type) {
        AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(this.mContext);
        if (accessibilityManager.isEnabled()) {
            AccessibilityEvent event = AccessibilityEvent.obtain(type);
            event.setWindowId(this.mAms.getActiveWindowId());
            accessibilityManager.sendAccessibilityEvent(event);
            switch (type) {
                case 512: {
                    this.mTouchExplorationInProgress = true;
                    break;
                }
                case 1024: {
                    this.mTouchExplorationInProgress = false;
                }
            }
        }
    }

    private void sendDownForAllNotInjectedPointers(MotionEvent prototype, int policyFlags) {
        InjectedPointerTracker injectedPointers = this.mInjectedPointerTracker;
        int pointerIdBits = 0;
        int pointerCount = prototype.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            int pointerId = prototype.getPointerId(i);
            if (injectedPointers.isInjectedPointerDown(pointerId)) continue;
            int action = this.computeInjectionAction(0, i);
            this.sendMotionEvent(prototype, action, pointerIdBits |= 1 << pointerId, policyFlags);
        }
    }

    private void sendHoverExitAndTouchExplorationGestureEndIfNeeded(int policyFlags) {
        MotionEvent event = this.mInjectedPointerTracker.getLastInjectedHoverEvent();
        if (event != null && event.getActionMasked() != 10) {
            int pointerIdBits = event.getPointerIdBits();
            if (!this.mSendTouchExplorationEndDelayed.isPending()) {
                this.mSendTouchExplorationEndDelayed.post();
            }
            this.sendMotionEvent(event, 10, pointerIdBits, policyFlags);
        }
    }

    private void sendTouchExplorationGestureStartAndHoverEnterIfNeeded(int policyFlags) {
        MotionEvent event = this.mInjectedPointerTracker.getLastInjectedHoverEvent();
        if (event != null && event.getActionMasked() == 10) {
            int pointerIdBits = event.getPointerIdBits();
            this.sendAccessibilityEvent(512);
            this.sendMotionEvent(event, 9, pointerIdBits, policyFlags);
        }
    }

    private void sendUpForInjectedDownPointers(MotionEvent prototype, int policyFlags) {
        InjectedPointerTracker injectedTracked = this.mInjectedPointerTracker;
        int pointerIdBits = 0;
        int pointerCount = prototype.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            int pointerId = prototype.getPointerId(i);
            if (!injectedTracked.isInjectedPointerDown(pointerId)) continue;
            int action = this.computeInjectionAction(1, i);
            this.sendMotionEvent(prototype, action, pointerIdBits |= 1 << pointerId, policyFlags);
        }
    }

    private void sendActionDownAndUp(MotionEvent prototype, int policyFlags) {
        int pointerId = prototype.getPointerId(prototype.getActionIndex());
        int pointerIdBits = 1 << pointerId;
        this.sendMotionEvent(prototype, 0, pointerIdBits, policyFlags);
        this.sendMotionEvent(prototype, 1, pointerIdBits, policyFlags);
    }

    private void sendMotionEvent(MotionEvent prototype, int action, int pointerIdBits, int policyFlags) {
        prototype.setAction(action);
        MotionEvent event = null;
        event = pointerIdBits == -1 ? prototype : prototype.split(pointerIdBits);
        if (action == 0) {
            event.setDownTime(event.getEventTime());
        } else {
            event.setDownTime(this.mInjectedPointerTracker.getLastInjectedDownEventTime());
        }
        if (this.mLongPressingPointerId >= 0) {
            int remappedIndex = event.findPointerIndex(this.mLongPressingPointerId);
            int pointerCount = event.getPointerCount();
            MotionEvent.PointerProperties[] props = MotionEvent.PointerProperties.createArray(pointerCount);
            MotionEvent.PointerCoords[] coords = MotionEvent.PointerCoords.createArray(pointerCount);
            for (int i = 0; i < pointerCount; ++i) {
                event.getPointerProperties(i, props[i]);
                event.getPointerCoords(i, coords[i]);
                if (i != remappedIndex) continue;
                coords[i].x -= (float)this.mLongPressingPointerDeltaX;
                coords[i].y -= (float)this.mLongPressingPointerDeltaY;
            }
            MotionEvent remapped = MotionEvent.obtain(event.getDownTime(), event.getEventTime(), event.getAction(), event.getPointerCount(), props, coords, event.getMetaState(), event.getButtonState(), 1.0f, 1.0f, event.getDeviceId(), event.getEdgeFlags(), event.getSource(), event.getFlags());
            if (event != prototype) {
                event.recycle();
            }
            event = remapped;
        }
        policyFlags |= 0x40000000;
        if (this.mNext != null) {
            this.mNext.onMotionEvent(event, null, policyFlags);
        }
        this.mInjectedPointerTracker.onMotionEvent(event);
        if (event != prototype) {
            event.recycle();
        }
    }

    private int computeInjectionAction(int actionMasked, int pointerIndex) {
        switch (actionMasked) {
            case 0: 
            case 5: {
                InjectedPointerTracker injectedTracker = this.mInjectedPointerTracker;
                if (injectedTracker.getInjectedPointerDownCount() == 0) {
                    return 0;
                }
                return pointerIndex << 8 | 5;
            }
            case 6: {
                InjectedPointerTracker injectedTracker = this.mInjectedPointerTracker;
                if (injectedTracker.getInjectedPointerDownCount() == 1) {
                    return 1;
                }
                return pointerIndex << 8 | 6;
            }
        }
        return actionMasked;
    }

    private boolean isDraggingGesture(MotionEvent event) {
        ReceivedPointerTracker receivedTracker = this.mReceivedPointerTracker;
        float firstPtrX = event.getX(0);
        float firstPtrY = event.getY(0);
        float secondPtrX = event.getX(1);
        float secondPtrY = event.getY(1);
        float firstPtrDownX = receivedTracker.getReceivedPointerDownX(0);
        float firstPtrDownY = receivedTracker.getReceivedPointerDownY(0);
        float secondPtrDownX = receivedTracker.getReceivedPointerDownX(1);
        float secondPtrDownY = receivedTracker.getReceivedPointerDownY(1);
        return GestureUtils.isDraggingGesture(firstPtrDownX, firstPtrDownY, secondPtrDownX, secondPtrDownY, firstPtrX, firstPtrY, secondPtrX, secondPtrY, 0.52532196f);
    }

    private static String getStateSymbolicName(int state) {
        switch (state) {
            case 1: {
                return "STATE_TOUCH_EXPLORING";
            }
            case 2: {
                return "STATE_DRAGGING";
            }
            case 4: {
                return "STATE_DELEGATING";
            }
            case 5: {
                return "STATE_GESTURE_DETECTING";
            }
        }
        throw new IllegalArgumentException("Unknown state: " + state);
    }

    public String toString() {
        return LOG_TAG;
    }

    class ReceivedPointerTracker {
        private static final String LOG_TAG_RECEIVED_POINTER_TRACKER = "ReceivedPointerTracker";
        private final float[] mReceivedPointerDownX = new float[32];
        private final float[] mReceivedPointerDownY = new float[32];
        private final long[] mReceivedPointerDownTime = new long[32];
        private int mReceivedPointersDown;
        private int mLastReceivedDownEdgeFlags;
        private int mPrimaryPointerId;
        private long mLastReceivedUpPointerDownTime;
        private int mLastReceivedUpPointerId;
        private float mLastReceivedUpPointerDownX;
        private float mLastReceivedUpPointerDownY;
        private MotionEvent mLastReceivedEvent;

        ReceivedPointerTracker() {
        }

        public void clear() {
            Arrays.fill(this.mReceivedPointerDownX, 0.0f);
            Arrays.fill(this.mReceivedPointerDownY, 0.0f);
            Arrays.fill(this.mReceivedPointerDownTime, 0L);
            this.mReceivedPointersDown = 0;
            this.mPrimaryPointerId = 0;
            this.mLastReceivedUpPointerDownTime = 0L;
            this.mLastReceivedUpPointerId = 0;
            this.mLastReceivedUpPointerDownX = 0.0f;
            this.mLastReceivedUpPointerDownY = 0.0f;
        }

        public void onMotionEvent(MotionEvent event) {
            if (this.mLastReceivedEvent != null) {
                this.mLastReceivedEvent.recycle();
            }
            this.mLastReceivedEvent = MotionEvent.obtain(event);
            int action = event.getActionMasked();
            switch (action) {
                case 0: {
                    this.handleReceivedPointerDown(event.getActionIndex(), event);
                    break;
                }
                case 5: {
                    this.handleReceivedPointerDown(event.getActionIndex(), event);
                    break;
                }
                case 1: {
                    this.handleReceivedPointerUp(event.getActionIndex(), event);
                    break;
                }
                case 6: {
                    this.handleReceivedPointerUp(event.getActionIndex(), event);
                }
            }
        }

        public MotionEvent getLastReceivedEvent() {
            return this.mLastReceivedEvent;
        }

        public int getReceivedPointerDownCount() {
            return Integer.bitCount(this.mReceivedPointersDown);
        }

        public boolean isReceivedPointerDown(int pointerId) {
            int pointerFlag = 1 << pointerId;
            return (this.mReceivedPointersDown & pointerFlag) != 0;
        }

        public float getReceivedPointerDownX(int pointerId) {
            return this.mReceivedPointerDownX[pointerId];
        }

        public float getReceivedPointerDownY(int pointerId) {
            return this.mReceivedPointerDownY[pointerId];
        }

        public long getReceivedPointerDownTime(int pointerId) {
            return this.mReceivedPointerDownTime[pointerId];
        }

        public int getPrimaryPointerId() {
            if (this.mPrimaryPointerId == -1) {
                this.mPrimaryPointerId = this.findPrimaryPointerId();
            }
            return this.mPrimaryPointerId;
        }

        public long getLastReceivedUpPointerDownTime() {
            return this.mLastReceivedUpPointerDownTime;
        }

        public float getLastReceivedUpPointerDownX() {
            return this.mLastReceivedUpPointerDownX;
        }

        public float getLastReceivedUpPointerDownY() {
            return this.mLastReceivedUpPointerDownY;
        }

        public int getLastReceivedDownEdgeFlags() {
            return this.mLastReceivedDownEdgeFlags;
        }

        private void handleReceivedPointerDown(int pointerIndex, MotionEvent event) {
            int pointerId = event.getPointerId(pointerIndex);
            int pointerFlag = 1 << pointerId;
            this.mLastReceivedUpPointerId = 0;
            this.mLastReceivedUpPointerDownTime = 0L;
            this.mLastReceivedUpPointerDownX = 0.0f;
            this.mLastReceivedUpPointerDownX = 0.0f;
            this.mLastReceivedDownEdgeFlags = event.getEdgeFlags();
            this.mReceivedPointersDown |= pointerFlag;
            this.mReceivedPointerDownX[pointerId] = event.getX(pointerIndex);
            this.mReceivedPointerDownY[pointerId] = event.getY(pointerIndex);
            this.mReceivedPointerDownTime[pointerId] = event.getEventTime();
            this.mPrimaryPointerId = pointerId;
        }

        private void handleReceivedPointerUp(int pointerIndex, MotionEvent event) {
            int pointerId = event.getPointerId(pointerIndex);
            int pointerFlag = 1 << pointerId;
            this.mLastReceivedUpPointerId = pointerId;
            this.mLastReceivedUpPointerDownTime = this.getReceivedPointerDownTime(pointerId);
            this.mLastReceivedUpPointerDownX = this.mReceivedPointerDownX[pointerId];
            this.mLastReceivedUpPointerDownY = this.mReceivedPointerDownY[pointerId];
            this.mReceivedPointersDown &= ~pointerFlag;
            this.mReceivedPointerDownX[pointerId] = 0.0f;
            this.mReceivedPointerDownY[pointerId] = 0.0f;
            this.mReceivedPointerDownTime[pointerId] = 0L;
            if (this.mPrimaryPointerId == pointerId) {
                this.mPrimaryPointerId = -1;
            }
        }

        private int findPrimaryPointerId() {
            int pointerId;
            int primaryPointerId = -1;
            long minDownTime = Long.MAX_VALUE;
            for (int pointerIdBits = this.mReceivedPointersDown; pointerIdBits > 0; pointerIdBits &= ~(1 << pointerId)) {
                pointerId = Integer.numberOfTrailingZeros(pointerIdBits);
                long downPointerTime = this.mReceivedPointerDownTime[pointerId];
                if (downPointerTime >= minDownTime) continue;
                minDownTime = downPointerTime;
                primaryPointerId = pointerId;
            }
            return primaryPointerId;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("=========================");
            builder.append("\nDown pointers #");
            builder.append(this.getReceivedPointerDownCount());
            builder.append(" [ ");
            for (int i = 0; i < 32; ++i) {
                if (!this.isReceivedPointerDown(i)) continue;
                builder.append(i);
                builder.append(" ");
            }
            builder.append("]");
            builder.append("\nPrimary pointer id [ ");
            builder.append(this.getPrimaryPointerId());
            builder.append(" ]");
            builder.append("\n=========================");
            return builder.toString();
        }
    }

    class InjectedPointerTracker {
        private static final String LOG_TAG_INJECTED_POINTER_TRACKER = "InjectedPointerTracker";
        private int mInjectedPointersDown;
        private long mLastInjectedDownEventTime;
        private MotionEvent mLastInjectedHoverEvent;
        private MotionEvent mLastInjectedHoverEventForClick;

        InjectedPointerTracker() {
        }

        public void onMotionEvent(MotionEvent event) {
            int action = event.getActionMasked();
            switch (action) {
                case 0: 
                case 5: {
                    int pointerId = event.getPointerId(event.getActionIndex());
                    int pointerFlag = 1 << pointerId;
                    this.mInjectedPointersDown |= pointerFlag;
                    this.mLastInjectedDownEventTime = event.getDownTime();
                    break;
                }
                case 1: 
                case 6: {
                    int pointerId = event.getPointerId(event.getActionIndex());
                    int pointerFlag = 1 << pointerId;
                    this.mInjectedPointersDown &= ~pointerFlag;
                    if (this.mInjectedPointersDown != 0) break;
                    this.mLastInjectedDownEventTime = 0L;
                    break;
                }
                case 7: 
                case 9: 
                case 10: {
                    if (this.mLastInjectedHoverEvent != null) {
                        this.mLastInjectedHoverEvent.recycle();
                    }
                    this.mLastInjectedHoverEvent = MotionEvent.obtain(event);
                    if (this.mLastInjectedHoverEventForClick != null) {
                        this.mLastInjectedHoverEventForClick.recycle();
                    }
                    this.mLastInjectedHoverEventForClick = MotionEvent.obtain(event);
                }
            }
        }

        public void clear() {
            this.mInjectedPointersDown = 0;
        }

        public long getLastInjectedDownEventTime() {
            return this.mLastInjectedDownEventTime;
        }

        public int getInjectedPointerDownCount() {
            return Integer.bitCount(this.mInjectedPointersDown);
        }

        public int getInjectedPointersDown() {
            return this.mInjectedPointersDown;
        }

        public boolean isInjectedPointerDown(int pointerId) {
            int pointerFlag = 1 << pointerId;
            return (this.mInjectedPointersDown & pointerFlag) != 0;
        }

        public MotionEvent getLastInjectedHoverEvent() {
            return this.mLastInjectedHoverEvent;
        }

        public MotionEvent getLastInjectedHoverEventForClick() {
            return this.mLastInjectedHoverEventForClick;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("=========================");
            builder.append("\nDown pointers #");
            builder.append(Integer.bitCount(this.mInjectedPointersDown));
            builder.append(" [ ");
            for (int i = 0; i < 32; ++i) {
                if ((this.mInjectedPointersDown & i) == 0) continue;
                builder.append(i);
                builder.append(" ");
            }
            builder.append("]");
            builder.append("\n=========================");
            return builder.toString();
        }
    }

    private class SendAccessibilityEventDelayed
    implements Runnable {
        private final int mEventType;
        private final int mDelay;

        public SendAccessibilityEventDelayed(int eventType, int delay) {
            this.mEventType = eventType;
            this.mDelay = delay;
        }

        public void cancel() {
            TouchExplorer.this.mHandler.removeCallbacks(this);
        }

        public void post() {
            TouchExplorer.this.mHandler.postDelayed(this, this.mDelay);
        }

        public boolean isPending() {
            return TouchExplorer.this.mHandler.hasCallbacks(this);
        }

        public void forceSendAndRemove() {
            if (this.isPending()) {
                this.run();
                this.cancel();
            }
        }

        public void run() {
            TouchExplorer.this.sendAccessibilityEvent(this.mEventType);
        }
    }

    class SendHoverExitDelayed
    implements Runnable {
        private final String LOG_TAG_SEND_HOVER_DELAYED = "SendHoverExitDelayed";
        private MotionEvent mPrototype;
        private int mPointerIdBits;
        private int mPolicyFlags;

        SendHoverExitDelayed() {
        }

        public void post(MotionEvent prototype, int pointerIdBits, int policyFlags) {
            this.cancel();
            this.mPrototype = MotionEvent.obtain(prototype);
            this.mPointerIdBits = pointerIdBits;
            this.mPolicyFlags = policyFlags;
            TouchExplorer.this.mHandler.postDelayed(this, TouchExplorer.this.mDetermineUserIntentTimeout);
        }

        public void cancel() {
            if (this.isPending()) {
                TouchExplorer.this.mHandler.removeCallbacks(this);
                this.clear();
            }
        }

        private boolean isPending() {
            return TouchExplorer.this.mHandler.hasCallbacks(this);
        }

        private void clear() {
            this.mPrototype.recycle();
            this.mPrototype = null;
            this.mPointerIdBits = -1;
            this.mPolicyFlags = 0;
        }

        public void forceSendAndRemove() {
            if (this.isPending()) {
                this.run();
                this.cancel();
            }
        }

        public void run() {
            TouchExplorer.this.sendMotionEvent(this.mPrototype, 10, this.mPointerIdBits, this.mPolicyFlags);
            if (!TouchExplorer.this.mSendTouchExplorationEndDelayed.isPending()) {
                TouchExplorer.this.mSendTouchExplorationEndDelayed.cancel();
                TouchExplorer.this.mSendTouchExplorationEndDelayed.post();
            }
            if (TouchExplorer.this.mSendTouchInteractionEndDelayed.isPending()) {
                TouchExplorer.this.mSendTouchInteractionEndDelayed.cancel();
                TouchExplorer.this.mSendTouchInteractionEndDelayed.post();
            }
            this.clear();
        }
    }

    class SendHoverEnterAndMoveDelayed
    implements Runnable {
        private final String LOG_TAG_SEND_HOVER_DELAYED = "SendHoverEnterAndMoveDelayed";
        private final List<MotionEvent> mEvents = new ArrayList<MotionEvent>();
        private int mPointerIdBits;
        private int mPolicyFlags;

        SendHoverEnterAndMoveDelayed() {
        }

        public void post(MotionEvent event, boolean touchExplorationInProgress, int pointerIdBits, int policyFlags) {
            this.cancel();
            this.addEvent(event);
            this.mPointerIdBits = pointerIdBits;
            this.mPolicyFlags = policyFlags;
            TouchExplorer.this.mHandler.postDelayed(this, TouchExplorer.this.mDetermineUserIntentTimeout);
        }

        public void addEvent(MotionEvent event) {
            this.mEvents.add(MotionEvent.obtain(event));
        }

        public void cancel() {
            if (this.isPending()) {
                TouchExplorer.this.mHandler.removeCallbacks(this);
                this.clear();
            }
        }

        private boolean isPending() {
            return TouchExplorer.this.mHandler.hasCallbacks(this);
        }

        private void clear() {
            this.mPointerIdBits = -1;
            this.mPolicyFlags = 0;
            int eventCount = this.mEvents.size();
            for (int i = eventCount - 1; i >= 0; --i) {
                this.mEvents.remove(i).recycle();
            }
        }

        public void forceSendAndRemove() {
            if (this.isPending()) {
                this.run();
                this.cancel();
            }
        }

        public void run() {
            TouchExplorer.this.sendAccessibilityEvent(512);
            if (!this.mEvents.isEmpty()) {
                TouchExplorer.this.sendMotionEvent(this.mEvents.get(0), 9, this.mPointerIdBits, this.mPolicyFlags);
                int eventCount = this.mEvents.size();
                for (int i = 1; i < eventCount; ++i) {
                    TouchExplorer.this.sendMotionEvent(this.mEvents.get(i), 7, this.mPointerIdBits, this.mPolicyFlags);
                }
            }
            this.clear();
        }
    }

    private final class PerformLongPressDelayed
    implements Runnable {
        private MotionEvent mEvent;
        private int mPolicyFlags;

        private PerformLongPressDelayed() {
        }

        public void post(MotionEvent prototype, int policyFlags) {
            this.mEvent = MotionEvent.obtain(prototype);
            this.mPolicyFlags = policyFlags;
            TouchExplorer.this.mHandler.postDelayed(this, ViewConfiguration.getLongPressTimeout());
        }

        public void cancel() {
            if (this.mEvent != null) {
                TouchExplorer.this.mHandler.removeCallbacks(this);
                this.clear();
            }
        }

        private boolean isPending() {
            return TouchExplorer.this.mHandler.hasCallbacks(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            int clickLocationY;
            int clickLocationX;
            if (TouchExplorer.this.mReceivedPointerTracker.getLastReceivedEvent().getPointerCount() == 0) {
                return;
            }
            int pointerId = this.mEvent.getPointerId(this.mEvent.getActionIndex());
            int pointerIndex = this.mEvent.findPointerIndex(pointerId);
            MotionEvent lastExploreEvent = TouchExplorer.this.mInjectedPointerTracker.getLastInjectedHoverEventForClick();
            if (lastExploreEvent == null) {
                Rect focusBounds = TouchExplorer.this.mTempRect;
                if (!TouchExplorer.this.mAms.getAccessibilityFocusBoundsInActiveWindow(focusBounds)) return;
                clickLocationX = focusBounds.centerX();
                clickLocationY = focusBounds.centerY();
            } else {
                int lastExplorePointerIndex = lastExploreEvent.getActionIndex();
                clickLocationX = (int)lastExploreEvent.getX(lastExplorePointerIndex);
                clickLocationY = (int)lastExploreEvent.getY(lastExplorePointerIndex);
                Rect activeWindowBounds = TouchExplorer.this.mTempRect;
                if (TouchExplorer.this.mLastTouchedWindowId == TouchExplorer.this.mAms.getActiveWindowId()) {
                    TouchExplorer.this.mAms.getActiveWindowBounds(activeWindowBounds);
                    if (activeWindowBounds.contains(clickLocationX, clickLocationY)) {
                        Rect focusBounds = TouchExplorer.this.mTempRect;
                        if (TouchExplorer.this.mAms.getAccessibilityFocusBoundsInActiveWindow(focusBounds) && !focusBounds.contains(clickLocationX, clickLocationY)) {
                            clickLocationX = focusBounds.centerX();
                            clickLocationY = focusBounds.centerY();
                        }
                    }
                }
            }
            TouchExplorer.this.mLongPressingPointerId = pointerId;
            TouchExplorer.this.mLongPressingPointerDeltaX = (int)this.mEvent.getX(pointerIndex) - clickLocationX;
            TouchExplorer.this.mLongPressingPointerDeltaY = (int)this.mEvent.getY(pointerIndex) - clickLocationY;
            TouchExplorer.this.sendHoverExitAndTouchExplorationGestureEndIfNeeded(this.mPolicyFlags);
            TouchExplorer.this.mCurrentState = 4;
            TouchExplorer.this.sendDownForAllNotInjectedPointers(this.mEvent, this.mPolicyFlags);
            this.clear();
        }

        private void clear() {
            this.mEvent.recycle();
            this.mEvent = null;
            this.mPolicyFlags = 0;
        }
    }

    private final class ExitGestureDetectionModeDelayed
    implements Runnable {
        private ExitGestureDetectionModeDelayed() {
        }

        public void post() {
            TouchExplorer.this.mHandler.postDelayed(this, 2000L);
        }

        public void cancel() {
            TouchExplorer.this.mHandler.removeCallbacks(this);
        }

        public void run() {
            TouchExplorer.this.sendAccessibilityEvent(524288);
            TouchExplorer.this.sendAccessibilityEvent(512);
            TouchExplorer.this.clear();
        }
    }

    private class DoubleTapDetector {
        private MotionEvent mDownEvent;
        private MotionEvent mFirstTapEvent;

        private DoubleTapDetector() {
        }

        public void onMotionEvent(MotionEvent event, int policyFlags) {
            int actionIndex = event.getActionIndex();
            int action = event.getActionMasked();
            switch (action) {
                case 0: 
                case 5: {
                    if (this.mFirstTapEvent != null && !GestureUtils.isSamePointerContext(this.mFirstTapEvent, event)) {
                        this.clear();
                    }
                    this.mDownEvent = MotionEvent.obtain(event);
                    break;
                }
                case 1: 
                case 6: {
                    if (this.mDownEvent == null) {
                        return;
                    }
                    if (!GestureUtils.isSamePointerContext(this.mDownEvent, event)) {
                        this.clear();
                        return;
                    }
                    if (GestureUtils.isTap(this.mDownEvent, event, TouchExplorer.this.mTapTimeout, TouchExplorer.this.mTouchSlop, actionIndex)) {
                        if (this.mFirstTapEvent == null || GestureUtils.isTimedOut(this.mFirstTapEvent, event, TouchExplorer.this.mDoubleTapTimeout)) {
                            this.mFirstTapEvent = MotionEvent.obtain(event);
                            this.mDownEvent.recycle();
                            this.mDownEvent = null;
                            return;
                        }
                        if (GestureUtils.isMultiTap(this.mFirstTapEvent, event, TouchExplorer.this.mDoubleTapTimeout, TouchExplorer.this.mDoubleTapSlop, actionIndex)) {
                            this.onDoubleTap(event, policyFlags);
                            this.mFirstTapEvent.recycle();
                            this.mFirstTapEvent = null;
                            this.mDownEvent.recycle();
                            this.mDownEvent = null;
                            return;
                        }
                        this.mFirstTapEvent.recycle();
                        this.mFirstTapEvent = null;
                    } else if (this.mFirstTapEvent != null) {
                        this.mFirstTapEvent.recycle();
                        this.mFirstTapEvent = null;
                    }
                    this.mDownEvent.recycle();
                    this.mDownEvent = null;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onDoubleTap(MotionEvent secondTapUp, int policyFlags) {
            int clickLocationY;
            int clickLocationX;
            if (secondTapUp.getPointerCount() > 2) {
                return;
            }
            TouchExplorer.this.mSendHoverEnterAndMoveDelayed.cancel();
            TouchExplorer.this.mSendHoverExitDelayed.cancel();
            TouchExplorer.this.mPerformLongPressDelayed.cancel();
            if (TouchExplorer.this.mSendTouchExplorationEndDelayed.isPending()) {
                TouchExplorer.this.mSendTouchExplorationEndDelayed.forceSendAndRemove();
            }
            if (TouchExplorer.this.mSendTouchInteractionEndDelayed.isPending()) {
                TouchExplorer.this.mSendTouchInteractionEndDelayed.forceSendAndRemove();
            }
            int pointerId = secondTapUp.getPointerId(secondTapUp.getActionIndex());
            int pointerIndex = secondTapUp.findPointerIndex(pointerId);
            MotionEvent lastExploreEvent = TouchExplorer.this.mInjectedPointerTracker.getLastInjectedHoverEventForClick();
            if (lastExploreEvent == null) {
                Rect focusBounds = TouchExplorer.this.mTempRect;
                if (!TouchExplorer.this.mAms.getAccessibilityFocusBoundsInActiveWindow(focusBounds)) return;
                clickLocationX = focusBounds.centerX();
                clickLocationY = focusBounds.centerY();
            } else {
                int lastExplorePointerIndex = lastExploreEvent.getActionIndex();
                clickLocationX = (int)lastExploreEvent.getX(lastExplorePointerIndex);
                clickLocationY = (int)lastExploreEvent.getY(lastExplorePointerIndex);
                Rect activeWindowBounds = TouchExplorer.this.mTempRect;
                if (TouchExplorer.this.mLastTouchedWindowId == TouchExplorer.this.mAms.getActiveWindowId()) {
                    TouchExplorer.this.mAms.getActiveWindowBounds(activeWindowBounds);
                    if (activeWindowBounds.contains(clickLocationX, clickLocationY)) {
                        Rect focusBounds = TouchExplorer.this.mTempRect;
                        if (TouchExplorer.this.mAms.getAccessibilityFocusBoundsInActiveWindow(focusBounds) && !focusBounds.contains(clickLocationX, clickLocationY)) {
                            clickLocationX = focusBounds.centerX();
                            clickLocationY = focusBounds.centerY();
                        }
                    }
                }
            }
            MotionEvent.PointerProperties[] properties = new MotionEvent.PointerProperties[]{new MotionEvent.PointerProperties()};
            secondTapUp.getPointerProperties(pointerIndex, properties[0]);
            MotionEvent.PointerCoords[] coords = new MotionEvent.PointerCoords[]{new MotionEvent.PointerCoords()};
            coords[0].x = clickLocationX;
            coords[0].y = clickLocationY;
            MotionEvent event = MotionEvent.obtain(secondTapUp.getDownTime(), secondTapUp.getEventTime(), 0, 1, properties, coords, 0, 0, 1.0f, 1.0f, secondTapUp.getDeviceId(), 0, secondTapUp.getSource(), secondTapUp.getFlags());
            TouchExplorer.this.sendActionDownAndUp(event, policyFlags);
            event.recycle();
        }

        public void clear() {
            if (this.mDownEvent != null) {
                this.mDownEvent.recycle();
                this.mDownEvent = null;
            }
            if (this.mFirstTapEvent != null) {
                this.mFirstTapEvent.recycle();
                this.mFirstTapEvent = null;
            }
        }

        public boolean firstTapDetected() {
            return this.mFirstTapEvent != null && SystemClock.uptimeMillis() - this.mFirstTapEvent.getEventTime() < (long)TouchExplorer.this.mDoubleTapTimeout;
        }
    }
}

