/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.IThumbnailReceiver;
import android.app.ResultInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseIntArray;
import com.android.internal.app.HeavyWeightSwitcherActivity;
import com.android.internal.os.TransferPipe;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.PendingThumbnailsRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskRecord;
import com.android.server.am.UserStartedState;
import com.android.server.wm.WindowManagerService;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActivityStackSupervisor {
    static final boolean DEBUG = false;
    static final boolean DEBUG_ADD_REMOVE = false;
    static final boolean DEBUG_APP = false;
    static final boolean DEBUG_SAVED_STATE = false;
    static final boolean DEBUG_STATES = false;
    static final boolean DEBUG_IDLE = false;
    public static final int HOME_STACK_ID = 0;
    static final int IDLE_TIMEOUT = 10000;
    static final int SLEEP_TIMEOUT = 5000;
    static final int LAUNCH_TIMEOUT = 10000;
    static final int IDLE_TIMEOUT_MSG = 100;
    static final int IDLE_NOW_MSG = 101;
    static final int RESUME_TOP_ACTIVITY_MSG = 102;
    static final int SLEEP_TIMEOUT_MSG = 103;
    static final int LAUNCH_TIMEOUT_MSG = 104;
    static final boolean VALIDATE_WAKE_LOCK_CALLER = false;
    final ActivityManagerService mService;
    final Context mContext;
    final Looper mLooper;
    final ActivityStackSupervisorHandler mHandler;
    WindowManagerService mWindowManager;
    boolean mDismissKeyguardOnNextActivity = false;
    private int mLastStackId = 0;
    private int mCurTaskId = 0;
    private int mCurrentUser;
    private ActivityStack mHomeStack;
    private ActivityStack mFocusedStack;
    private ArrayList<ActivityStack> mStacks = new ArrayList();
    private static final int STACK_STATE_HOME_IN_FRONT = 0;
    private static final int STACK_STATE_HOME_TO_BACK = 1;
    private static final int STACK_STATE_HOME_IN_BACK = 2;
    private static final int STACK_STATE_HOME_TO_FRONT = 3;
    private int mStackState = 0;
    final ArrayList<ActivityRecord> mWaitingVisibleActivities = new ArrayList();
    final ArrayList<IActivityManager.WaitResult> mWaitingActivityVisible = new ArrayList();
    final ArrayList<IActivityManager.WaitResult> mWaitingActivityLaunched = new ArrayList();
    final ArrayList<ActivityRecord> mStoppingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mFinishingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mGoingToSleepActivities = new ArrayList();
    final ArrayList<ActivityRecord> mCancelledThumbnails = new ArrayList();
    final ArrayList<UserStartedState> mStartingUsers = new ArrayList();
    boolean mUserLeaving = false;
    boolean mSleepTimeout = false;
    final PowerManager.WakeLock mLaunchingActivity;
    final PowerManager.WakeLock mGoingToSleep;
    SparseIntArray mUserStackInFront = new SparseIntArray(2);

    public ActivityStackSupervisor(ActivityManagerService service, Context context, Looper looper) {
        this.mService = service;
        this.mContext = context;
        this.mLooper = looper;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mGoingToSleep = pm.newWakeLock(1, "ActivityManager-Sleep");
        this.mHandler = new ActivityStackSupervisorHandler(looper);
        this.mLaunchingActivity = pm.newWakeLock(1, "ActivityManager-Launch");
        this.mLaunchingActivity.setReferenceCounted(false);
    }

    void setWindowManager(WindowManagerService wm) {
        this.mWindowManager = wm;
        this.mHomeStack = new ActivityStack(this.mService, this.mContext, this.mLooper, 0);
        this.mStacks.add(this.mHomeStack);
    }

    void dismissKeyguard() {
        if (this.mDismissKeyguardOnNextActivity) {
            this.mDismissKeyguardOnNextActivity = false;
            this.mWindowManager.dismissKeyguard();
        }
    }

    ActivityStack getFocusedStack() {
        if (this.mFocusedStack == null) {
            return this.mHomeStack;
        }
        switch (this.mStackState) {
            case 0: 
            case 3: {
                return this.mHomeStack;
            }
        }
        return this.mFocusedStack;
    }

    ActivityStack getLastStack() {
        switch (this.mStackState) {
            case 0: 
            case 1: {
                return this.mHomeStack;
            }
        }
        return this.mFocusedStack;
    }

    boolean isFrontStack(ActivityStack stack) {
        return !(stack.isHomeStack() ^ this.getFocusedStack().isHomeStack());
    }

    void moveHomeStack(boolean toFront) {
        boolean homeInFront = this.isFrontStack(this.mHomeStack);
        if (homeInFront ^ toFront) {
            this.mStackState = homeInFront ? 1 : 3;
        }
    }

    void moveHomeToTop() {
        this.moveHomeStack(true);
        this.mHomeStack.moveHomeTaskToTop();
    }

    boolean resumeHomeActivity(ActivityRecord prev) {
        ActivityRecord r;
        this.moveHomeToTop();
        if (prev != null) {
            prev.task.mOnTopOfHome = false;
        }
        if ((r = this.mHomeStack.topRunningActivityLocked(null)) != null && r.isHomeActivity()) {
            this.mService.setFocusedActivityLocked(r);
            return this.resumeTopActivitiesLocked(this.mHomeStack, prev, null);
        }
        return this.mService.startHomeActivityLocked(this.mCurrentUser);
    }

    void setDismissKeyguard(boolean dismiss) {
        this.mDismissKeyguardOnNextActivity = dismiss;
    }

    TaskRecord anyTaskForIdLocked(int id2) {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            TaskRecord task = stack.taskForIdLocked(id2);
            if (task == null) continue;
            return task;
        }
        return null;
    }

    ActivityRecord isInAnyStackLocked(IBinder token) {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityRecord r = this.mStacks.get(stackNdx).isInStackLocked(token);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    int getNextTaskId() {
        do {
            ++this.mCurTaskId;
            if (this.mCurTaskId > 0) continue;
            this.mCurTaskId = 1;
        } while (this.anyTaskForIdLocked(this.mCurTaskId) != null);
        return this.mCurTaskId;
    }

    void removeTask(TaskRecord task) {
        this.mWindowManager.removeTask(task.taskId);
        ActivityStack stack = task.stack;
        ActivityRecord r = stack.mResumedActivity;
        if (r != null && r.task == task) {
            stack.mResumedActivity = null;
        }
        if (stack.removeTask(task) && !stack.isHomeStack()) {
            this.mStacks.remove(stack);
            int stackId = stack.mStackId;
            int nextStackId = this.mWindowManager.removeStack(stackId);
            if (this.mFocusedStack == null || this.mFocusedStack.mStackId == stackId) {
                this.mFocusedStack = nextStackId == 0 ? null : this.getStack(nextStackId);
            }
        }
    }

    ActivityRecord resumedAppLocked() {
        ActivityStack stack = this.getFocusedStack();
        if (stack == null) {
            return null;
        }
        ActivityRecord resumedActivity = stack.mResumedActivity;
        if (!(resumedActivity != null && resumedActivity.app != null || (resumedActivity = stack.mPausingActivity) != null && resumedActivity.app != null)) {
            resumedActivity = stack.topRunningActivityLocked(null);
        }
        return resumedActivity;
    }

    boolean attachApplicationLocked(ProcessRecord app, boolean headless) throws Exception {
        boolean didSomething = false;
        String processName = app.processName;
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityRecord hr;
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (!this.isFrontStack(stack) || (hr = stack.topRunningActivityLocked(null)) == null || hr.app != null || app.uid != hr.info.applicationInfo.uid || !processName.equals(hr.processName)) continue;
            try {
                if (headless) {
                    Slog.e("ActivityManager", "Starting activities not supported on headless device: " + hr);
                    continue;
                }
                if (!this.realStartActivityLocked(hr, app, true, true)) continue;
                didSomething = true;
                continue;
            }
            catch (Exception e) {
                Slog.w("ActivityManager", "Exception in new application when starting activity " + hr.intent.getComponent().flattenToShortString(), e);
                throw e;
            }
        }
        if (!didSomething) {
            this.ensureActivitiesVisibleLocked(null, 0);
        }
        return didSomething;
    }

    boolean allResumedActivitiesIdle() {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityRecord resumedActivity;
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (!this.isFrontStack(stack) || (resumedActivity = stack.mResumedActivity) != null && resumedActivity.idle) continue;
            return false;
        }
        return true;
    }

    boolean allResumedActivitiesComplete() {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityRecord r;
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (!this.isFrontStack(stack) || (r = stack.mResumedActivity) == null || r.state == ActivityStack.ActivityState.RESUMED) continue;
            return false;
        }
        switch (this.mStackState) {
            case 1: {
                this.mStackState = 2;
                break;
            }
            case 3: {
                this.mStackState = 0;
            }
        }
        return true;
    }

    boolean allResumedActivitiesVisible() {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            ActivityRecord r = stack.mResumedActivity;
            if (r == null || r.nowVisible && !r.waitingVisible) continue;
            return false;
        }
        return true;
    }

    boolean pauseBackStacks(boolean userLeaving) {
        boolean someActivityPaused = false;
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (this.isFrontStack(stack) || stack.mResumedActivity == null) continue;
            stack.startPausingLocked(userLeaving, false);
            someActivityPaused = true;
        }
        return someActivityPaused;
    }

    boolean allPausedActivitiesComplete() {
        boolean pausing = true;
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            ActivityRecord r = stack.mPausingActivity;
            if (r == null || r.state == ActivityStack.ActivityState.PAUSED || r.state == ActivityStack.ActivityState.STOPPED || r.state == ActivityStack.ActivityState.STOPPING) continue;
            return false;
        }
        return pausing;
    }

    void reportActivityVisibleLocked(ActivityRecord r) {
        for (int i = this.mWaitingActivityVisible.size() - 1; i >= 0; --i) {
            IActivityManager.WaitResult w = this.mWaitingActivityVisible.get(i);
            w.timeout = false;
            if (r != null) {
                w.who = new ComponentName(r.info.packageName, r.info.name);
            }
            w.thisTime = w.totalTime = SystemClock.uptimeMillis() - w.thisTime;
        }
        this.mService.notifyAll();
        this.dismissKeyguard();
    }

    void reportActivityLaunchedLocked(boolean timeout, ActivityRecord r, long thisTime, long totalTime) {
        for (int i = this.mWaitingActivityLaunched.size() - 1; i >= 0; --i) {
            IActivityManager.WaitResult w = this.mWaitingActivityLaunched.remove(i);
            w.timeout = timeout;
            if (r != null) {
                w.who = new ComponentName(r.info.packageName, r.info.name);
            }
            w.thisTime = thisTime;
            w.totalTime = totalTime;
        }
        this.mService.notifyAll();
    }

    ActivityRecord topRunningActivityLocked() {
        ActivityStack focusedStack = this.getFocusedStack();
        ActivityRecord r = focusedStack.topRunningActivityLocked(null);
        if (r != null) {
            return r;
        }
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (stack == focusedStack || !this.isFrontStack(stack) || (r = stack.topRunningActivityLocked(null)) == null) continue;
            return r;
        }
        return null;
    }

    ActivityRecord getTasksLocked(int maxNum, IThumbnailReceiver receiver, PendingThumbnailsRecord pending, List<ActivityManager.RunningTaskInfo> list) {
        ActivityRecord r = null;
        int numStacks = this.mStacks.size();
        ArrayList[] runningTaskLists = new ArrayList[numStacks];
        for (int stackNdx = numStacks - 1; stackNdx >= 0; --stackNdx) {
            ArrayList<ActivityManager.RunningTaskInfo> stackTaskList;
            ActivityStack stack = this.mStacks.get(stackNdx);
            runningTaskLists[stackNdx] = stackTaskList = new ArrayList<ActivityManager.RunningTaskInfo>();
            ActivityRecord ar = stack.getTasksLocked(receiver, pending, stackTaskList);
            if (!this.isFrontStack(stack)) continue;
            r = ar;
        }
        while (maxNum > 0) {
            long mostRecentActiveTime = Long.MIN_VALUE;
            ArrayList selectedStackList = null;
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                long lastActiveTime;
                ArrayList stackTaskList = runningTaskLists[stackNdx];
                if (stackTaskList.isEmpty() || (lastActiveTime = ((ActivityManager.RunningTaskInfo)stackTaskList.get((int)0)).lastActiveTime) <= mostRecentActiveTime) continue;
                mostRecentActiveTime = lastActiveTime;
                selectedStackList = stackTaskList;
            }
            if (selectedStackList == null) break;
            list.add((ActivityManager.RunningTaskInfo)selectedStackList.remove(0));
            --maxNum;
        }
        return r;
    }

    ActivityInfo resolveActivity(Intent intent, String resolvedType, int startFlags, String profileFile, ParcelFileDescriptor profileFd, int userId) {
        ActivityInfo aInfo;
        try {
            ResolveInfo rInfo = AppGlobals.getPackageManager().resolveIntent(intent, resolvedType, 66560, userId);
            aInfo = rInfo != null ? rInfo.activityInfo : null;
        }
        catch (RemoteException e) {
            aInfo = null;
        }
        if (aInfo != null) {
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            if ((startFlags & 2) != 0 && !aInfo.processName.equals("system")) {
                this.mService.setDebugApp(aInfo.processName, true, false);
            }
            if ((startFlags & 4) != 0 && !aInfo.processName.equals("system")) {
                this.mService.setOpenGlTraceApp(aInfo.applicationInfo, aInfo.processName);
            }
            if (profileFile != null && !aInfo.processName.equals("system")) {
                this.mService.setProfileApp(aInfo.applicationInfo, aInfo.processName, profileFile, profileFd, (startFlags & 8) != 0);
            }
        }
        return aInfo;
    }

    void startHomeActivity(Intent intent, ActivityInfo aInfo) {
        this.moveHomeToTop();
        this.startActivityLocked(null, intent, null, aInfo, null, null, 0, 0, 0, null, 0, null, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivityMayWait(IApplicationThread caller, int callingUid, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, String profileFile, ParcelFileDescriptor profileFd, IActivityManager.WaitResult outResult, Configuration config, Bundle options, int userId) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        boolean componentSpecified = intent.getComponent() != null;
        intent = new Intent(intent);
        ActivityInfo aInfo = this.resolveActivity(intent, resolvedType, startFlags, profileFile, profileFd, userId);
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            int callingPid;
            if (callingUid >= 0) {
                callingPid = -1;
            } else if (caller == null) {
                callingPid = Binder.getCallingPid();
                callingUid = Binder.getCallingUid();
            } else {
                callingUid = -1;
                callingPid = -1;
            }
            ActivityStack stack = this.getFocusedStack();
            stack.mConfigWillChange = config != null && this.mService.mConfiguration.diff(config) != 0;
            long origId = Binder.clearCallingIdentity();
            if (aInfo != null && (aInfo.applicationInfo.flags & 0x10000000) != 0 && aInfo.processName.equals(aInfo.applicationInfo.packageName) && this.mService.mHeavyWeightProcess != null && (this.mService.mHeavyWeightProcess.info.uid != aInfo.applicationInfo.uid || !this.mService.mHeavyWeightProcess.processName.equals(aInfo.processName))) {
                int realCallingUid = callingUid;
                if (caller != null) {
                    ProcessRecord callerApp = this.mService.getRecordForAppLocked(caller);
                    if (callerApp != null) {
                        realCallingUid = callerApp.info.uid;
                    } else {
                        Slog.w("ActivityManager", "Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString());
                        ActivityOptions.abort(options);
                        return -4;
                    }
                }
                IIntentSender target = this.mService.getIntentSenderLocked(2, "android", realCallingUid, userId, null, null, 0, new Intent[]{intent}, new String[]{resolvedType}, 0x50000000, null);
                Intent newIntent = new Intent();
                if (requestCode >= 0) {
                    newIntent.putExtra("has_result", true);
                }
                newIntent.putExtra("intent", new IntentSender(target));
                if (this.mService.mHeavyWeightProcess.activities.size() > 0) {
                    ActivityRecord hist = this.mService.mHeavyWeightProcess.activities.get(0);
                    newIntent.putExtra("cur_app", hist.packageName);
                    newIntent.putExtra("cur_task", hist.task.taskId);
                }
                newIntent.putExtra("new_app", aInfo.packageName);
                newIntent.setFlags(intent.getFlags());
                newIntent.setClassName("android", HeavyWeightSwitcherActivity.class.getName());
                intent = newIntent;
                resolvedType = null;
                caller = null;
                callingUid = Binder.getCallingUid();
                callingPid = Binder.getCallingPid();
                componentSpecified = true;
                try {
                    ResolveInfo rInfo = AppGlobals.getPackageManager().resolveIntent(intent, null, 66560, userId);
                    aInfo = rInfo != null ? rInfo.activityInfo : null;
                    aInfo = this.mService.getActivityInfoForUser(aInfo, userId);
                }
                catch (RemoteException e) {
                    aInfo = null;
                }
            }
            int res = this.startActivityLocked(caller, intent, resolvedType, aInfo, resultTo, resultWho, requestCode, callingPid, callingUid, callingPackage, startFlags, options, componentSpecified, null);
            if (stack.mConfigWillChange) {
                this.mService.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
                stack.mConfigWillChange = false;
                this.mService.updateConfigurationLocked(config, null, false, false);
            }
            Binder.restoreCallingIdentity(origId);
            if (outResult != null) {
                outResult.result = res;
                if (res == 0) {
                    this.mWaitingActivityLaunched.add(outResult);
                    do {
                        try {
                            this.mService.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    } while (!outResult.timeout && outResult.who == null);
                } else if (res == 2) {
                    ActivityRecord r = stack.topRunningActivityLocked(null);
                    if (r.nowVisible) {
                        outResult.timeout = false;
                        outResult.who = new ComponentName(r.info.packageName, r.info.name);
                        outResult.totalTime = 0L;
                        outResult.thisTime = 0L;
                    } else {
                        outResult.thisTime = SystemClock.uptimeMillis();
                        this.mWaitingActivityVisible.add(outResult);
                        do {
                            try {
                                this.mService.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        } while (!outResult.timeout && outResult.who == null);
                    }
                }
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final int startActivities(IApplicationThread caller, int callingUid, String callingPackage, Intent[] intents, String[] resolvedTypes, IBinder resultTo, Bundle options, int userId) {
        long origId;
        block17: {
            int n;
            block16: {
                int callingPid;
                if (intents == null) {
                    throw new NullPointerException("intents is null");
                }
                if (resolvedTypes == null) {
                    throw new NullPointerException("resolvedTypes is null");
                }
                if (intents.length != resolvedTypes.length) {
                    throw new IllegalArgumentException("intents are length different than resolvedTypes");
                }
                if (callingUid >= 0) {
                    callingPid = -1;
                } else if (caller == null) {
                    callingPid = Binder.getCallingPid();
                    callingUid = Binder.getCallingUid();
                } else {
                    callingUid = -1;
                    callingPid = -1;
                }
                origId = Binder.clearCallingIdentity();
                try {
                    ActivityManagerService activityManagerService = this.mService;
                    synchronized (activityManagerService) {
                        ActivityRecord[] outActivity = new ActivityRecord[1];
                        for (int i = 0; i < intents.length; ++i) {
                            Intent intent = intents[i];
                            if (intent == null) continue;
                            if (intent != null && intent.hasFileDescriptors()) {
                                throw new IllegalArgumentException("File descriptors passed in Intent");
                            }
                            boolean componentSpecified = intent.getComponent() != null;
                            intent = new Intent(intent);
                            ActivityInfo aInfo = this.resolveActivity(intent, resolvedTypes[i], 0, null, null, userId);
                            if ((aInfo = this.mService.getActivityInfoForUser(aInfo, userId)) != null && (aInfo.applicationInfo.flags & 0x10000000) != 0) {
                                throw new IllegalArgumentException("FLAG_CANT_SAVE_STATE not supported here");
                            }
                            Bundle theseOptions = options != null && i == intents.length - 1 ? options : null;
                            int res = this.startActivityLocked(caller, intent, resolvedTypes[i], aInfo, resultTo, null, -1, callingPid, callingUid, callingPackage, 0, theseOptions, componentSpecified, outActivity);
                            if (res < 0) {
                                n = res;
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 5, 15] lbl35 : MonitorExitStatement: MONITOREXIT : var12_11
                                Object var23_20 = null;
                                break block16;
                            }
                            resultTo = outActivity[0] != null ? outActivity[0].appToken : null;
                        }
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var23_22 = null;
                    Binder.restoreCallingIdentity(origId);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity(origId);
            return n;
        }
        Object var23_21 = null;
        Binder.restoreCallingIdentity(origId);
        return 0;
    }

    final boolean realStartActivityLocked(ActivityRecord r, ProcessRecord app, boolean andResume, boolean checkConfig) throws RemoteException {
        r.startFreezingScreenLocked(app, 0);
        this.mWindowManager.setAppVisibility(r.appToken, true);
        r.startLaunchTickingLocked();
        if (checkConfig) {
            Configuration config = this.mWindowManager.updateOrientationFromAppTokens(this.mService.mConfiguration, r.mayFreezeScreenLocked(app) ? r.appToken : null);
            this.mService.updateConfigurationLocked(config, r, false, false);
        }
        r.app = app;
        app.waitingToKill = null;
        ++r.launchCount;
        r.lastLaunchTime = SystemClock.uptimeMillis();
        int idx = app.activities.indexOf(r);
        if (idx < 0) {
            app.activities.add(r);
        }
        this.mService.updateLruProcessLocked(app, true, true);
        ActivityStack stack = r.task.stack;
        try {
            boolean profileAutoStop;
            ParcelFileDescriptor profileFd;
            String profileFile;
            ArrayList<Intent> newIntents;
            ArrayList<ResultInfo> results;
            block21: {
                if (app.thread == null) {
                    throw new RemoteException();
                }
                results = null;
                newIntents = null;
                if (andResume) {
                    results = r.results;
                    newIntents = r.newIntents;
                }
                if (andResume) {
                    EventLog.writeEvent(30006, r.userId, System.identityHashCode(r), r.task.taskId, r.shortComponentName);
                }
                if (r.isHomeActivity() && r.isNotResolverActivity()) {
                    this.mService.mHomeProcess = r.task.mActivities.get((int)0).app;
                }
                this.mService.ensurePackageDexOpt(r.intent.getComponent().getPackageName());
                r.sleeping = false;
                r.forceNewConfig = false;
                this.mService.showAskCompatModeDialogLocked(r);
                r.compat = this.mService.compatibilityInfoForPackageLocked(r.info.applicationInfo);
                profileFile = null;
                profileFd = null;
                profileAutoStop = false;
                if (this.mService.mProfileApp != null && this.mService.mProfileApp.equals(app.processName) && (this.mService.mProfileProc == null || this.mService.mProfileProc == app)) {
                    this.mService.mProfileProc = app;
                    profileFile = this.mService.mProfileFile;
                    profileFd = this.mService.mProfileFd;
                    profileAutoStop = this.mService.mAutoStopProfiler;
                }
                app.hasShownUi = true;
                app.pendingUiClean = true;
                if (profileFd != null) {
                    try {
                        profileFd = profileFd.dup();
                    }
                    catch (IOException e) {
                        if (profileFd == null) break block21;
                        try {
                            profileFd.close();
                        }
                        catch (IOException o) {
                            // empty catch block
                        }
                        profileFd = null;
                    }
                }
            }
            app.forceProcessStateUpTo(2);
            app.thread.scheduleLaunchActivity(new Intent(r.intent), r.appToken, System.identityHashCode(r), r.info, new Configuration(this.mService.mConfiguration), r.compat, app.repProcState, r.icicle, results, newIntents, !andResume, this.mService.isNextTransitionForward(), profileFile, profileFd, profileAutoStop);
            if ((app.info.flags & 0x10000000) != 0 && app.processName.equals(app.info.packageName)) {
                if (this.mService.mHeavyWeightProcess != null && this.mService.mHeavyWeightProcess != app) {
                    Slog.w("ActivityManager", "Starting new heavy weight process " + app + " when already running " + this.mService.mHeavyWeightProcess);
                }
                this.mService.mHeavyWeightProcess = app;
                Message msg = this.mService.mHandler.obtainMessage(24);
                msg.obj = r;
                this.mService.mHandler.sendMessage(msg);
            }
        }
        catch (RemoteException e) {
            if (r.launchFailed) {
                Slog.e("ActivityManager", "Second failure launching " + r.intent.getComponent().flattenToShortString() + ", giving up", e);
                this.mService.appDiedLocked(app, app.pid, app.thread);
                stack.requestFinishActivityLocked(r.appToken, 0, null, "2nd-crash", false);
                return false;
            }
            app.activities.remove(r);
            throw e;
        }
        r.launchFailed = false;
        if (stack.updateLRUListLocked(r)) {
            Slog.w("ActivityManager", "Activity " + r + " being launched, but already in LRU list");
        }
        if (andResume) {
            stack.minimalResumeActivityLocked(r);
        } else {
            r.state = ActivityStack.ActivityState.STOPPED;
            r.stopped = true;
        }
        if (this.isFrontStack(stack)) {
            this.mService.startSetupActivityLocked();
        }
        return true;
    }

    void startSpecificActivityLocked(ActivityRecord r, boolean andResume, boolean checkConfig) {
        ProcessRecord app = this.mService.getProcessRecordLocked(r.processName, r.info.applicationInfo.uid, true);
        r.task.stack.setLaunchTime(r);
        if (app != null && app.thread != null) {
            try {
                app.addPackage(r.info.packageName, this.mService.mProcessStats);
                this.realStartActivityLocked(r, app, andResume, checkConfig);
                return;
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Exception when starting activity " + r.intent.getComponent().flattenToShortString(), e);
            }
        }
        this.mService.startProcessLocked(r.processName, r.info.applicationInfo, true, 0, "activity", r.intent.getComponent(), false, false, true);
    }

    final int startActivityLocked(IApplicationThread caller, Intent intent, String resolvedType, ActivityInfo aInfo, IBinder resultTo, String resultWho, int requestCode, int callingPid, int callingUid, String callingPackage, int startFlags, Bundle options, boolean componentSpecified, ActivityRecord[] outActivity) {
        boolean abort;
        int err = 0;
        ProcessRecord callerApp = null;
        if (caller != null) {
            callerApp = this.mService.getRecordForAppLocked(caller);
            if (callerApp != null) {
                callingPid = callerApp.pid;
                callingUid = callerApp.info.uid;
            } else {
                Slog.w("ActivityManager", "Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString());
                err = -4;
            }
        }
        if (err == 0) {
            int userId = aInfo != null ? UserHandle.getUserId(aInfo.applicationInfo.uid) : 0;
            Slog.i("ActivityManager", "START u" + userId + " {" + intent.toShortString(true, true, true, false) + "} from pid " + (callerApp != null ? callerApp.pid : callingPid));
        }
        ActivityRecord sourceRecord = null;
        ActivityRecord resultRecord = null;
        if (resultTo != null && (sourceRecord = this.isInAnyStackLocked(resultTo)) != null && requestCode >= 0 && !sourceRecord.finishing) {
            resultRecord = sourceRecord;
        }
        ActivityStack resultStack = resultRecord == null ? null : resultRecord.task.stack;
        int launchFlags = intent.getFlags();
        if ((launchFlags & 0x2000000) != 0 && sourceRecord != null) {
            if (requestCode >= 0) {
                ActivityOptions.abort(options);
                return -3;
            }
            resultRecord = sourceRecord.resultTo;
            resultWho = sourceRecord.resultWho;
            requestCode = sourceRecord.requestCode;
            sourceRecord.resultTo = null;
            if (resultRecord != null) {
                resultRecord.removeResultsLocked(sourceRecord, resultWho, requestCode);
            }
        }
        if (err == 0 && intent.getComponent() == null) {
            err = -1;
        }
        if (err == 0 && aInfo == null) {
            err = -2;
        }
        if (err != 0) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            this.setDismissKeyguard(false);
            ActivityOptions.abort(options);
            return err;
        }
        int startAnyPerm = this.mService.checkPermission("android.permission.START_ANY_ACTIVITY", callingPid, callingUid);
        int componentPerm = this.mService.checkComponentPermission(aInfo.permission, callingPid, callingUid, aInfo.applicationInfo.uid, aInfo.exported);
        if (startAnyPerm != 0 && componentPerm != 0) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            this.setDismissKeyguard(false);
            String msg = !aInfo.exported ? "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " not exported from uid " + aInfo.applicationInfo.uid : "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + aInfo.permission;
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        boolean bl = abort = !this.mService.mIntentFirewall.checkStartActivity(intent, callingUid, callingPid, resolvedType, aInfo.applicationInfo);
        if (this.mService.mController != null) {
            try {
                Intent watchIntent = intent.cloneFilter();
                abort |= !this.mService.mController.activityStarting(watchIntent, aInfo.applicationInfo.packageName);
            }
            catch (RemoteException e) {
                this.mService.mController = null;
            }
        }
        if (abort) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            this.setDismissKeyguard(false);
            ActivityOptions.abort(options);
            return 0;
        }
        ActivityRecord r = new ActivityRecord(this.mService, callerApp, callingUid, callingPackage, intent, resolvedType, aInfo, this.mService.mConfiguration, resultRecord, resultWho, requestCode, componentSpecified, this);
        if (outActivity != null) {
            outActivity[0] = r;
        }
        ActivityStack stack = this.getFocusedStack();
        if (!(stack.mResumedActivity != null && stack.mResumedActivity.info.applicationInfo.uid == callingUid || this.mService.checkAppSwitchAllowedLocked(callingPid, callingUid, "Activity start"))) {
            ActivityManagerService.PendingActivityLaunch pal = new ActivityManagerService.PendingActivityLaunch(r, sourceRecord, startFlags, stack);
            this.mService.mPendingActivityLaunches.add(pal);
            this.setDismissKeyguard(false);
            ActivityOptions.abort(options);
            return 4;
        }
        if (this.mService.mDidAppSwitch) {
            this.mService.mAppSwitchesAllowedTime = 0L;
        } else {
            this.mService.mDidAppSwitch = true;
        }
        this.mService.doPendingActivityLaunchesLocked(false);
        err = this.startActivityUncheckedLocked(r, sourceRecord, startFlags, true, options);
        if (this.allPausedActivitiesComplete()) {
            this.dismissKeyguard();
        }
        return err;
    }

    ActivityStack adjustStackFocus(ActivityRecord r) {
        TaskRecord task = r.task;
        if (r.isApplicationActivity() || task != null && task.isApplicationTask()) {
            if (task != null) {
                if (this.mFocusedStack != task.stack) {
                    this.mFocusedStack = task.stack;
                }
                return this.mFocusedStack;
            }
            if (this.mFocusedStack != null) {
                return this.mFocusedStack;
            }
            for (int stackNdx = this.mStacks.size() - 1; stackNdx > 0; --stackNdx) {
                ActivityStack stack = this.mStacks.get(stackNdx);
                if (stack.isHomeStack()) continue;
                this.mFocusedStack = stack;
                return this.mFocusedStack;
            }
            int stackId = this.mService.createStack(-1, 0, 6, 1.0f);
            this.mFocusedStack = this.getStack(stackId);
            return this.mFocusedStack;
        }
        return this.mHomeStack;
    }

    void setFocusedStack(ActivityRecord r) {
        if (r == null) {
            return;
        }
        if (!r.isApplicationActivity() || r.task != null && !r.task.isApplicationTask()) {
            if (this.mStackState != 0) {
                this.mStackState = 3;
            }
        } else {
            this.mFocusedStack = r.task.stack;
            if (this.mStackState != 2) {
                this.mStackState = 1;
            }
        }
    }

    final int startActivityUncheckedLocked(ActivityRecord r, ActivityRecord sourceRecord, int startFlags, boolean doResume, Bundle options) {
        ActivityRecord top;
        ActivityStack targetStack;
        ActivityStack sourceStack;
        ActivityRecord notTop;
        Intent intent = r.intent;
        int callingUid = r.launchedFromUid;
        int launchFlags = intent.getFlags();
        boolean bl = this.mUserLeaving = (launchFlags & 0x40000) == 0;
        if (!doResume) {
            r.delayedResume = true;
        }
        ActivityRecord activityRecord = notTop = (launchFlags & 0x1000000) != 0 ? r : null;
        if ((startFlags & 1) != 0) {
            ActivityRecord checkedCaller = sourceRecord;
            if (checkedCaller == null) {
                checkedCaller = this.getFocusedStack().topRunningNonDelayedActivityLocked(notTop);
            }
            if (!checkedCaller.realActivity.equals(r.realActivity)) {
                startFlags &= 0xFFFFFFFE;
            }
        }
        if (sourceRecord == null) {
            if ((launchFlags & 0x10000000) == 0) {
                Slog.w("ActivityManager", "startActivity called from non-Activity context; forcing Intent.FLAG_ACTIVITY_NEW_TASK for: " + intent);
                launchFlags |= 0x10000000;
            }
        } else if (sourceRecord.launchMode == 3) {
            launchFlags |= 0x10000000;
        } else if (r.launchMode == 3 || r.launchMode == 2) {
            launchFlags |= 0x10000000;
        }
        if (sourceRecord != null) {
            if (sourceRecord.finishing) {
                if ((launchFlags & 0x10000000) == 0) {
                    Slog.w("ActivityManager", "startActivity called from finishing " + sourceRecord + "; forcing " + "Intent.FLAG_ACTIVITY_NEW_TASK for: " + intent);
                    launchFlags |= 0x10000000;
                }
                sourceRecord = null;
                sourceStack = null;
            } else {
                sourceStack = sourceRecord.task.stack;
            }
        } else {
            sourceStack = null;
        }
        if (r.resultTo != null && (launchFlags & 0x10000000) != 0) {
            Slog.w("ActivityManager", "Activity is launching as a new task, so cancelling activity result.");
            r.resultTo.task.stack.sendActivityResultLocked(-1, r.resultTo, r.resultWho, r.requestCode, 0, null);
            r.resultTo = null;
        }
        boolean addingToTask = false;
        boolean movedHome = false;
        TaskRecord reuseTask = null;
        if (((launchFlags & 0x10000000) != 0 && (launchFlags & 0x8000000) == 0 || r.launchMode == 2 || r.launchMode == 3) && r.resultTo == null) {
            ActivityRecord intentActivity;
            ActivityRecord activityRecord2 = intentActivity = r.launchMode != 3 ? this.findTaskLocked(r) : this.findActivityLocked(intent, r.info);
            if (intentActivity != null) {
                ActivityStack lastStack;
                ActivityRecord curTop;
                if (r.task == null) {
                    r.task = intentActivity.task;
                }
                targetStack = intentActivity.task.stack;
                targetStack.mLastPausedActivity = null;
                this.moveHomeStack(targetStack.isHomeStack());
                if (intentActivity.task.intent == null) {
                    intentActivity.task.setIntent(intent, r.info);
                }
                ActivityRecord activityRecord3 = curTop = (lastStack = this.getLastStack()) == null ? null : lastStack.topRunningNonDelayedActivityLocked(notTop);
                if (curTop != null && (curTop.task != intentActivity.task || curTop.task != lastStack.topTask())) {
                    r.intent.addFlags(0x400000);
                    if (sourceRecord == null || sourceStack.topActivity() != null && sourceStack.topActivity().task == sourceRecord.task) {
                        movedHome = true;
                        if ((launchFlags & 0x10004000) == 0x10004000) {
                            intentActivity.task.mOnTopOfHome = true;
                        }
                        targetStack.moveTaskToFrontLocked(intentActivity.task, r, options);
                        options = null;
                    }
                }
                if ((launchFlags & 0x200000) != 0) {
                    intentActivity = targetStack.resetTaskIfNeededLocked(intentActivity, r);
                }
                if ((startFlags & 1) != 0) {
                    if (doResume) {
                        this.resumeTopActivitiesLocked(targetStack, null, options);
                    } else {
                        ActivityOptions.abort(options);
                    }
                    if (r.task == null) {
                        Slog.v("ActivityManager", "startActivityUncheckedLocked: task left null", new RuntimeException("here").fillInStackTrace());
                    }
                    return 1;
                }
                if ((launchFlags & 0x10008000) == 0x10008000) {
                    reuseTask = intentActivity.task;
                    reuseTask.performClearTaskLocked();
                    reuseTask.setIntent(r.intent, r.info);
                } else if ((launchFlags & 0x4000000) != 0 || r.launchMode == 2 || r.launchMode == 3) {
                    top = intentActivity.task.performClearTaskLocked(r, launchFlags);
                    if (top != null) {
                        if (top.frontOfTask) {
                            top.task.setIntent(r.intent, r.info);
                        }
                        ActivityStack.logStartActivity(30003, r, top.task);
                        top.deliverNewIntentLocked(callingUid, r.intent);
                    } else {
                        addingToTask = true;
                        sourceRecord = intentActivity;
                    }
                } else if (r.realActivity.equals(intentActivity.task.realActivity)) {
                    if (((launchFlags & 0x20000000) != 0 || r.launchMode == 1) && intentActivity.realActivity.equals(r.realActivity)) {
                        ActivityStack.logStartActivity(30003, r, intentActivity.task);
                        if (intentActivity.frontOfTask) {
                            intentActivity.task.setIntent(r.intent, r.info);
                        }
                        intentActivity.deliverNewIntentLocked(callingUid, r.intent);
                    } else if (!r.intent.filterEquals(intentActivity.task.intent)) {
                        addingToTask = true;
                        sourceRecord = intentActivity;
                    }
                } else if ((launchFlags & 0x200000) == 0) {
                    addingToTask = true;
                    sourceRecord = intentActivity;
                } else if (!intentActivity.task.rootWasReset) {
                    intentActivity.task.setIntent(r.intent, r.info);
                }
                if (!addingToTask && reuseTask == null) {
                    if (doResume) {
                        targetStack.resumeTopActivityLocked(null, options);
                    } else {
                        ActivityOptions.abort(options);
                    }
                    if (r.task == null) {
                        Slog.v("ActivityManager", "startActivityUncheckedLocked: task left null", new RuntimeException("here").fillInStackTrace());
                    }
                    return 2;
                }
            }
        }
        if (r.packageName != null) {
            ActivityStack topStack = this.getFocusedStack();
            ActivityRecord top2 = topStack.topRunningNonDelayedActivityLocked(notTop);
            if (top2 != null && r.resultTo == null && top2.realActivity.equals(r.realActivity) && top2.userId == r.userId && top2.app != null && top2.app.thread != null && ((launchFlags & 0x20000000) != 0 || r.launchMode == 1 || r.launchMode == 2)) {
                ActivityStack.logStartActivity(30003, top2, top2.task);
                topStack.mLastPausedActivity = null;
                if (doResume) {
                    this.resumeTopActivitiesLocked();
                }
                ActivityOptions.abort(options);
                if ((startFlags & 1) != 0) {
                    if (r.task == null) {
                        Slog.v("ActivityManager", "startActivityUncheckedLocked: task left null", new RuntimeException("here").fillInStackTrace());
                    }
                    return 1;
                }
                top2.deliverNewIntentLocked(callingUid, r.intent);
                if (r.task == null) {
                    Slog.v("ActivityManager", "startActivityUncheckedLocked: task left null", new RuntimeException("here").fillInStackTrace());
                }
                return 3;
            }
        } else {
            if (r.resultTo != null) {
                r.resultTo.task.stack.sendActivityResultLocked(-1, r.resultTo, r.resultWho, r.requestCode, 0, null);
            }
            ActivityOptions.abort(options);
            if (r.task == null) {
                Slog.v("ActivityManager", "startActivityUncheckedLocked: task left null", new RuntimeException("here").fillInStackTrace());
            }
            return -2;
        }
        boolean newTask = false;
        boolean keepCurTransition = false;
        if (r.resultTo == null && !addingToTask && (launchFlags & 0x10000000) != 0) {
            targetStack = this.adjustStackFocus(r);
            this.moveHomeStack(targetStack.isHomeStack());
            if (reuseTask == null) {
                r.setTask(targetStack.createTaskRecord(this.getNextTaskId(), r.info, intent, true), null, true);
            } else {
                r.setTask(reuseTask, reuseTask, true);
            }
            newTask = true;
            if (!movedHome && (launchFlags & 0x10004000) == 0x10004000) {
                r.task.mOnTopOfHome = true;
            }
        } else if (sourceRecord != null) {
            TaskRecord sourceTask = sourceRecord.task;
            targetStack = sourceTask.stack;
            this.moveHomeStack(targetStack.isHomeStack());
            if (!addingToTask && (launchFlags & 0x4000000) != 0) {
                top = sourceTask.performClearTaskLocked(r, launchFlags);
                keepCurTransition = true;
                if (top != null) {
                    ActivityStack.logStartActivity(30003, r, top.task);
                    top.deliverNewIntentLocked(callingUid, r.intent);
                    targetStack.mLastPausedActivity = null;
                    if (doResume) {
                        targetStack.resumeTopActivityLocked(null);
                    }
                    ActivityOptions.abort(options);
                    if (r.task == null) {
                        Slog.w("ActivityManager", "startActivityUncheckedLocked: task left null", new RuntimeException("here").fillInStackTrace());
                    }
                    return 3;
                }
            } else if (!addingToTask && (launchFlags & 0x20000) != 0 && (top = sourceTask.findActivityInHistoryLocked(r)) != null) {
                TaskRecord task = top.task;
                task.moveActivityToFrontLocked(top);
                ActivityStack.logStartActivity(30003, r, task);
                top.updateOptionsLocked(options);
                top.deliverNewIntentLocked(callingUid, r.intent);
                targetStack.mLastPausedActivity = null;
                if (doResume) {
                    targetStack.resumeTopActivityLocked(null);
                }
                return 3;
            }
            r.setTask(sourceTask, sourceRecord.thumbHolder, false);
        } else {
            targetStack = this.adjustStackFocus(r);
            this.moveHomeStack(targetStack.isHomeStack());
            ActivityRecord prev = targetStack.topActivity();
            r.setTask(prev != null ? prev.task : targetStack.createTaskRecord(this.getNextTaskId(), r.info, intent, true), null, true);
        }
        this.mService.grantUriPermissionFromIntentLocked(callingUid, r.packageName, intent, r.getUriPermissionsLocked());
        if (newTask) {
            EventLog.writeEvent(30004, r.userId, r.task.taskId);
        }
        ActivityStack.logStartActivity(30005, r, r.task);
        targetStack.mLastPausedActivity = null;
        targetStack.startActivityLocked(r, newTask, doResume, keepCurTransition, options);
        this.mService.setFocusedActivityLocked(r);
        return 0;
    }

    void acquireLaunchWakelock() {
        this.mLaunchingActivity.acquire();
        if (!this.mHandler.hasMessages(104)) {
            this.mHandler.sendEmptyMessageDelayed(104, 10000L);
        }
    }

    final ActivityRecord activityIdleInternalLocked(final IBinder token, boolean fromTimeout, Configuration config) {
        int i;
        ArrayList<ActivityRecord> thumbnails;
        int NT;
        ArrayList<ActivityRecord> stops = null;
        ArrayList<ActivityRecord> finishes = null;
        ArrayList<UserStartedState> startingUsers = null;
        int NS = 0;
        int NF = 0;
        IApplicationThread sendThumbnail = null;
        boolean booting = false;
        boolean enableScreen = false;
        boolean activityRemoved = false;
        ActivityRecord r = ActivityRecord.forToken(token);
        if (r != null) {
            this.mHandler.removeMessages(100, r);
            r.finishLaunchTickingLocked();
            if (fromTimeout) {
                this.reportActivityLaunchedLocked(fromTimeout, r, -1L, -1L);
            }
            if (config != null) {
                r.configuration = config;
            }
            r.idle = true;
            if (r.thumbnailNeeded && r.app != null && r.app.thread != null) {
                sendThumbnail = r.app.thread;
                r.thumbnailNeeded = false;
            }
            if (!this.mService.mBooted && this.isFrontStack(r.task.stack)) {
                this.mService.mBooted = true;
                enableScreen = true;
            }
        }
        if (this.allResumedActivitiesIdle()) {
            if (r != null) {
                this.mService.scheduleAppGcsLocked();
            }
            if (this.mLaunchingActivity.isHeld()) {
                this.mHandler.removeMessages(104);
                this.mLaunchingActivity.release();
            }
            this.ensureActivitiesVisibleLocked(null, 0);
        }
        NS = (stops = this.processStoppingActivitiesLocked(true)) != null ? stops.size() : 0;
        NF = this.mFinishingActivities.size();
        if (NF > 0) {
            finishes = new ArrayList<ActivityRecord>(this.mFinishingActivities);
            this.mFinishingActivities.clear();
        }
        if ((NT = this.mCancelledThumbnails.size()) > 0) {
            thumbnails = new ArrayList<ActivityRecord>(this.mCancelledThumbnails);
            this.mCancelledThumbnails.clear();
        } else {
            thumbnails = null;
        }
        if (this.isFrontStack(this.mHomeStack)) {
            booting = this.mService.mBooting;
            this.mService.mBooting = false;
        }
        if (this.mStartingUsers.size() > 0) {
            startingUsers = new ArrayList<UserStartedState>(this.mStartingUsers);
            this.mStartingUsers.clear();
        }
        final IApplicationThread thumbnailThread = sendThumbnail;
        this.mHandler.post(new Runnable(){

            public void run() {
                if (thumbnailThread != null) {
                    try {
                        thumbnailThread.requestThumbnail(token);
                    }
                    catch (Exception e) {
                        Slog.w("ActivityManager", "Exception thrown when requesting thumbnail", e);
                        ActivityStackSupervisor.this.mService.sendPendingThumbnail(null, token, null, null, true);
                    }
                }
                for (int i = 0; i < NT; ++i) {
                    ActivityRecord r = (ActivityRecord)thumbnails.get(i);
                    ActivityStackSupervisor.this.mService.sendPendingThumbnail(r, null, null, null, true);
                }
            }
        });
        for (i = 0; i < NS; ++i) {
            r = stops.get(i);
            ActivityStack stack = r.task.stack;
            if (r.finishing) {
                stack.finishCurrentActivityLocked(r, 0, false);
                continue;
            }
            stack.stopActivityLocked(r);
        }
        for (i = 0; i < NF; ++i) {
            r = finishes.get(i);
            activityRemoved |= r.task.stack.destroyActivityLocked(r, true, false, "finish-idle");
        }
        if (booting) {
            this.mService.finishBooting();
        } else if (startingUsers != null) {
            for (i = 0; i < startingUsers.size(); ++i) {
                this.mService.finishUserSwitch(startingUsers.get(i));
            }
        }
        this.mService.trimApplications();
        if (enableScreen) {
            this.mService.enableScreenAfterBoot();
        }
        if (activityRemoved) {
            this.resumeTopActivitiesLocked();
        }
        return r;
    }

    boolean handleAppDiedLocked(ProcessRecord app) {
        boolean hasVisibleActivities = false;
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            hasVisibleActivities |= this.mStacks.get(stackNdx).handleAppDiedLocked(app);
        }
        return hasVisibleActivities;
    }

    void closeSystemDialogsLocked() {
        int numStacks = this.mStacks.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            stack.closeSystemDialogsLocked();
        }
    }

    void removeUserLocked(int userId) {
        this.mUserStackInFront.delete(userId);
    }

    boolean forceStopPackageLocked(String name, boolean doit, boolean evenPersistent, int userId) {
        boolean didSomething = false;
        int numStacks = this.mStacks.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (!stack.forceStopPackageLocked(name, doit, evenPersistent, userId)) continue;
            didSomething = true;
        }
        return didSomething;
    }

    void updatePreviousProcessLocked(ActivityRecord r) {
        ProcessRecord fgApp = null;
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (!this.isFrontStack(stack)) continue;
            if (stack.mResumedActivity != null) {
                fgApp = stack.mResumedActivity.app;
                break;
            }
            if (stack.mPausingActivity == null) break;
            fgApp = stack.mPausingActivity.app;
            break;
        }
        if (r.app != null && fgApp != null && r.app != fgApp && r.lastVisibleTime > this.mService.mPreviousProcessVisibleTime && r.app != this.mService.mHomeProcess) {
            this.mService.mPreviousProcess = r.app;
            this.mService.mPreviousProcessVisibleTime = r.lastVisibleTime;
        }
    }

    boolean resumeTopActivitiesLocked() {
        return this.resumeTopActivitiesLocked(null, null, null);
    }

    boolean resumeTopActivitiesLocked(ActivityStack targetStack, ActivityRecord target, Bundle targetOptions) {
        if (targetStack == null) {
            targetStack = this.getFocusedStack();
        }
        boolean result = false;
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (!this.isFrontStack(stack)) continue;
            if (stack == targetStack) {
                result = stack.resumeTopActivityLocked(target, targetOptions);
                continue;
            }
            stack.resumeTopActivityLocked(null);
        }
        return result;
    }

    void finishTopRunningActivityLocked(ProcessRecord app) {
        int numStacks = this.mStacks.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            stack.finishTopRunningActivityLocked(app);
        }
    }

    void findTaskToMoveToFrontLocked(int taskId, int flags, Bundle options) {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            if (!this.mStacks.get(stackNdx).findTaskToMoveToFrontLocked(taskId, flags, options)) continue;
            return;
        }
    }

    ActivityStack getStack(int stackId) {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (stack.getStackId() != stackId) continue;
            return stack;
        }
        return null;
    }

    ArrayList<ActivityStack> getStacks() {
        return new ArrayList<ActivityStack>(this.mStacks);
    }

    int createStack() {
        do {
            if (++this.mLastStackId > 0) continue;
            this.mLastStackId = 1;
        } while (this.getStack(this.mLastStackId) != null);
        this.mStacks.add(new ActivityStack(this.mService, this.mContext, this.mLooper, this.mLastStackId));
        return this.mLastStackId;
    }

    void moveTaskToStack(int taskId, int stackId, boolean toTop) {
        TaskRecord task = this.anyTaskForIdLocked(taskId);
        if (task == null) {
            return;
        }
        ActivityStack stack = this.getStack(stackId);
        if (stack == null) {
            Slog.w("ActivityManager", "moveTaskToStack: no stack for id=" + stackId);
            return;
        }
        this.removeTask(task);
        stack.addTask(task, toTop);
        this.mWindowManager.addTask(taskId, stackId, toTop);
        this.resumeTopActivitiesLocked();
    }

    ActivityRecord findTaskLocked(ActivityRecord r) {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityRecord ar;
            ActivityStack stack = this.mStacks.get(stackNdx);
            if (!r.isApplicationActivity() && !stack.isHomeStack() || (ar = stack.findTaskLocked(r)) == null) continue;
            return ar;
        }
        return null;
    }

    ActivityRecord findActivityLocked(Intent intent, ActivityInfo info) {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityRecord ar = this.mStacks.get(stackNdx).findActivityLocked(intent, info);
            if (ar == null) continue;
            return ar;
        }
        return null;
    }

    void goingToSleepLocked() {
        this.scheduleSleepTimeout();
        if (!this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.acquire();
            if (this.mLaunchingActivity.isHeld()) {
                this.mLaunchingActivity.release();
                this.mService.mHandler.removeMessages(104);
            }
        }
        this.checkReadyForSleepLocked();
    }

    boolean shutdownLocked(int timeout) {
        boolean timedout;
        block4: {
            timedout = false;
            this.goingToSleepLocked();
            long endTime = System.currentTimeMillis() + (long)timeout;
            while (true) {
                boolean cantShutdown = false;
                for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
                    cantShutdown |= this.mStacks.get(stackNdx).checkReadyForSleepLocked();
                }
                if (!cantShutdown) break block4;
                long timeRemaining = endTime - System.currentTimeMillis();
                if (timeRemaining <= 0L) break;
                try {
                    this.mService.wait(timeRemaining);
                }
                catch (InterruptedException e) {}
            }
            Slog.w("ActivityManager", "Activity manager shutdown timed out");
            timedout = true;
        }
        this.mSleepTimeout = true;
        this.checkReadyForSleepLocked();
        return timedout;
    }

    void comeOutOfSleepIfNeededLocked() {
        this.removeSleepTimeouts();
        if (this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.release();
        }
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            stack.awakeFromSleepingLocked();
            if (!this.isFrontStack(stack)) continue;
            this.resumeTopActivitiesLocked();
        }
        this.mGoingToSleepActivities.clear();
    }

    void activitySleptLocked(ActivityRecord r) {
        this.mGoingToSleepActivities.remove(r);
        this.checkReadyForSleepLocked();
    }

    void checkReadyForSleepLocked() {
        if (!this.mService.isSleepingOrShuttingDown()) {
            return;
        }
        if (!this.mSleepTimeout) {
            boolean dontSleep = false;
            for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
                dontSleep |= this.mStacks.get(stackNdx).checkReadyForSleepLocked();
            }
            if (this.mStoppingActivities.size() > 0) {
                this.scheduleIdleLocked();
                dontSleep = true;
            }
            if (this.mGoingToSleepActivities.size() > 0) {
                dontSleep = true;
            }
            if (dontSleep) {
                return;
            }
        }
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            this.mStacks.get(stackNdx).goToSleep();
        }
        this.removeSleepTimeouts();
        if (this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.release();
        }
        if (this.mService.mShuttingDown) {
            this.mService.notifyAll();
        }
    }

    boolean reportResumedActivityLocked(ActivityRecord r) {
        ActivityStack stack = r.task.stack;
        if (this.isFrontStack(stack)) {
            this.mService.updateUsageStats(r, true);
        }
        if (this.allResumedActivitiesComplete()) {
            this.ensureActivitiesVisibleLocked(null, 0);
            this.mWindowManager.executeAppTransition();
            return true;
        }
        return false;
    }

    void handleAppCrashLocked(ProcessRecord app) {
        int numStacks = this.mStacks.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            stack.handleAppCrashLocked(app);
        }
    }

    void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges) {
        ActivityStack stack;
        int stackNdx;
        boolean showHomeBehindStack = false;
        for (stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            stack = this.mStacks.get(stackNdx);
            if (!this.isFrontStack(stack)) continue;
            showHomeBehindStack = stack.ensureActivitiesVisibleLocked(starting, configChanges);
        }
        for (stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            stack = this.mStacks.get(stackNdx);
            if (this.isFrontStack(stack)) continue;
            stack.ensureActivitiesVisibleLocked(starting, configChanges, showHomeBehindStack);
        }
    }

    void scheduleDestroyAllActivities(ProcessRecord app, String reason) {
        int numStacks = this.mStacks.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            stack.scheduleDestroyActivities(app, false, reason);
        }
    }

    boolean switchUserLocked(int userId, UserStartedState uss) {
        this.mUserStackInFront.put(this.mCurrentUser, this.getFocusedStack().getStackId());
        int restoreStackId = this.mUserStackInFront.get(userId, 0);
        this.mCurrentUser = userId;
        this.mStartingUsers.add(uss);
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            this.mStacks.get(stackNdx).switchUserLocked(userId);
        }
        ActivityStack stack = this.getStack(restoreStackId);
        if (stack == null) {
            stack = this.mHomeStack;
        }
        boolean homeInFront = stack.isHomeStack();
        this.moveHomeStack(homeInFront);
        this.mWindowManager.moveTaskToTop(stack.topTask().taskId);
        return homeInFront;
    }

    final ArrayList<ActivityRecord> processStoppingActivitiesLocked(boolean remove) {
        int N = this.mStoppingActivities.size();
        if (N <= 0) {
            return null;
        }
        ArrayList<ActivityRecord> stops = null;
        boolean nowVisible = this.allResumedActivitiesVisible();
        for (int i = 0; i < N; ++i) {
            ActivityRecord s = this.mStoppingActivities.get(i);
            if (s.waitingVisible && nowVisible) {
                this.mWaitingVisibleActivities.remove(s);
                s.waitingVisible = false;
                if (s.finishing) {
                    this.mWindowManager.setAppVisibility(s.appToken, false);
                }
            }
            if (s.waitingVisible && !this.mService.isSleepingOrShuttingDown() || !remove) continue;
            if (stops == null) {
                stops = new ArrayList<ActivityRecord>();
            }
            stops.add(s);
            this.mStoppingActivities.remove(i);
            --N;
            --i;
        }
        return stops;
    }

    void validateTopActivitiesLocked() {
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack.ActivityState state;
            ActivityStack stack = this.mStacks.get(stackNdx);
            ActivityRecord r = stack.topRunningActivityLocked(null);
            ActivityStack.ActivityState activityState = state = r == null ? ActivityStack.ActivityState.DESTROYED : r.state;
            if (this.isFrontStack(stack)) {
                if (r == null) {
                    Slog.e("ActivityManager", "validateTop...: null top activity, stack=" + stack);
                    continue;
                }
                ActivityRecord pausing = stack.mPausingActivity;
                if (pausing != null && pausing == r) {
                    Slog.e("ActivityManager", "validateTop...: top stack has pausing activity r=" + r + " state=" + (Object)((Object)state));
                }
                if (state == ActivityStack.ActivityState.INITIALIZING || state == ActivityStack.ActivityState.RESUMED) continue;
                Slog.e("ActivityManager", "validateTop...: activity in front not resumed r=" + r + " state=" + (Object)((Object)state));
                continue;
            }
            ActivityRecord resumed = stack.mResumedActivity;
            if (resumed != null && resumed == r) {
                Slog.e("ActivityManager", "validateTop...: back stack has resumed activity r=" + r + " state=" + (Object)((Object)state));
            }
            if (r == null || state != ActivityStack.ActivityState.INITIALIZING && state != ActivityStack.ActivityState.RESUMED) continue;
            Slog.e("ActivityManager", "validateTop...: activity in back resumed r=" + r + " state=" + (Object)((Object)state));
        }
    }

    private static String stackStateToString(int stackState) {
        switch (stackState) {
            case 0: {
                return "STACK_STATE_HOME_IN_FRONT";
            }
            case 1: {
                return "STACK_STATE_HOME_TO_BACK";
            }
            case 2: {
                return "STACK_STATE_HOME_IN_BACK";
            }
            case 3: {
                return "STACK_STATE_HOME_TO_FRONT";
            }
        }
        return "Unknown stackState=" + stackState;
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mDismissKeyguardOnNextActivity:");
        pw.println(this.mDismissKeyguardOnNextActivity);
        pw.print(prefix);
        pw.print("mStackState=");
        pw.println(ActivityStackSupervisor.stackStateToString(this.mStackState));
        pw.print(prefix);
        pw.println("mSleepTimeout: " + this.mSleepTimeout);
        pw.print(prefix);
        pw.println("mCurTaskId: " + this.mCurTaskId);
        pw.print(prefix);
        pw.println("mUserStackInFront: " + this.mUserStackInFront);
    }

    ArrayList<ActivityRecord> getDumpActivitiesLocked(String name) {
        return this.getFocusedStack().getDumpActivitiesLocked(name);
    }

    static boolean printThisActivity(PrintWriter pw, ActivityRecord activity, String dumpPackage, boolean needSep, String prefix) {
        if (activity != null && (dumpPackage == null || dumpPackage.equals(activity.packageName))) {
            if (needSep) {
                pw.println();
            }
            pw.print(prefix);
            pw.println(activity);
            return true;
        }
        return false;
    }

    boolean dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        boolean printed = false;
        boolean needSep = false;
        int numStacks = this.mStacks.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            StringBuilder stackHeader = new StringBuilder(128);
            stackHeader.append("  Stack #");
            stackHeader.append(this.mStacks.indexOf(stack));
            stackHeader.append(":");
            printed |= stack.dumpActivitiesLocked(fd, pw, dumpAll, dumpClient, dumpPackage, needSep, stackHeader.toString());
            needSep = printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, stack.mLRUActivities, "    ", "Run", false, !dumpAll, false, dumpPackage, true, "    Running activities (most recent first):", null);
            boolean pr = ActivityStackSupervisor.printThisActivity(pw, stack.mPausingActivity, dumpPackage, needSep, "    mPausingActivity: ");
            if (pr) {
                printed = true;
                needSep = false;
            }
            if (pr = ActivityStackSupervisor.printThisActivity(pw, stack.mResumedActivity, dumpPackage, needSep, "    mResumedActivity: ")) {
                printed = true;
                needSep = false;
            }
            if (dumpAll) {
                pr = ActivityStackSupervisor.printThisActivity(pw, stack.mLastPausedActivity, dumpPackage, needSep, "    mLastPausedActivity: ");
                if (pr) {
                    printed = true;
                    needSep = true;
                }
                printed |= ActivityStackSupervisor.printThisActivity(pw, stack.mLastNoHistoryActivity, dumpPackage, needSep, "    mLastNoHistoryActivity: ");
            }
            needSep = printed;
        }
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mFinishingActivities, "  ", "Fin", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to finish:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mStoppingActivities, "  ", "Stop", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to stop:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mWaitingVisibleActivities, "  ", "Wait", false, !dumpAll, false, dumpPackage, true, "  Activities waiting for another to become visible:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mGoingToSleepActivities, "  ", "Sleep", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to sleep:", null);
        return printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mGoingToSleepActivities, "  ", "Sleep", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to sleep:", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean dumpHistoryList(FileDescriptor fd, PrintWriter pw, List<ActivityRecord> list, String prefix, String label, boolean complete, boolean brief, boolean client, String dumpPackage, boolean needNL, String header1, String header2) {
        TaskRecord lastTask = null;
        String innerPrefix = null;
        String[] args = null;
        boolean printed = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean full;
            ActivityRecord r = list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.packageName)) continue;
            if (innerPrefix == null) {
                innerPrefix = prefix + "      ";
                args = new String[]{};
            }
            printed = true;
            boolean bl = full = !brief && (complete || !r.isInHistory());
            if (needNL) {
                pw.println("");
                needNL = false;
            }
            if (header1 != null) {
                pw.println(header1);
                header1 = null;
            }
            if (header2 != null) {
                pw.println(header2);
                header2 = null;
            }
            if (lastTask != r.task) {
                lastTask = r.task;
                pw.print(prefix);
                pw.print(full ? "* " : "  ");
                pw.println(lastTask);
                if (full) {
                    lastTask.dump(pw, prefix + "  ");
                } else if (complete && lastTask.intent != null) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(lastTask.intent.toInsecureStringWithClip());
                }
            }
            pw.print(prefix);
            pw.print(full ? "  * " : "    ");
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(r);
            if (full) {
                r.dump(pw, innerPrefix);
            } else if (complete) {
                pw.print(innerPrefix);
                pw.println(r.intent.toInsecureString());
                if (r.app != null) {
                    pw.print(innerPrefix);
                    pw.println(r.app);
                }
            }
            if (!client || r.app == null || r.app.thread == null) continue;
            pw.flush();
            try {
                Object var21_22;
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpActivity(tp.getWriteFd().getFileDescriptor(), r.appToken, innerPrefix, args);
                    tp.go(fd, 2000L);
                    var21_22 = null;
                    tp.kill();
                }
                catch (Throwable throwable) {
                    var21_22 = null;
                    tp.kill();
                    throw throwable;
                }
            }
            catch (IOException e) {
                pw.println(innerPrefix + "Failure while dumping the activity: " + e);
            }
            catch (RemoteException e) {
                pw.println(innerPrefix + "Got a RemoteException while dumping the activity");
            }
            needNL = true;
        }
        return printed;
    }

    void scheduleIdleTimeoutLocked(ActivityRecord next) {
        Message msg = this.mHandler.obtainMessage(100, next);
        this.mHandler.sendMessageDelayed(msg, 10000L);
    }

    final void scheduleIdleLocked() {
        this.mHandler.sendEmptyMessage(101);
    }

    void removeTimeoutsForActivityLocked(ActivityRecord r) {
        this.mHandler.removeMessages(100, r);
    }

    final void scheduleResumeTopActivities() {
        this.mHandler.sendEmptyMessage(102);
    }

    void removeSleepTimeouts() {
        this.mSleepTimeout = false;
        this.mHandler.removeMessages(103);
    }

    final void scheduleSleepTimeout() {
        this.removeSleepTimeouts();
        this.mHandler.sendEmptyMessageDelayed(103, 5000L);
    }

    private final class ActivityStackSupervisorHandler
    extends Handler {
        public ActivityStackSupervisorHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void activityIdleInternal(ActivityRecord r) {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                ActivityStackSupervisor.this.activityIdleInternalLocked(r != null ? r.appToken : null, true, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    if (ActivityStackSupervisor.this.mService.mDidDexOpt) {
                        ActivityStackSupervisor.this.mService.mDidDexOpt = false;
                        Message nmsg = ActivityStackSupervisor.this.mHandler.obtainMessage(100);
                        nmsg.obj = msg.obj;
                        ActivityStackSupervisor.this.mHandler.sendMessageDelayed(nmsg, 10000L);
                        return;
                    }
                    this.activityIdleInternal((ActivityRecord)msg.obj);
                    break;
                }
                case 101: {
                    this.activityIdleInternal((ActivityRecord)msg.obj);
                    break;
                }
                case 102: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        ActivityStackSupervisor.this.resumeTopActivitiesLocked();
                        break;
                    }
                }
                case 103: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        if (ActivityStackSupervisor.this.mService.isSleepingOrShuttingDown()) {
                            Slog.w("ActivityManager", "Sleep timeout!  Sleeping now.");
                            ActivityStackSupervisor.this.mSleepTimeout = true;
                            ActivityStackSupervisor.this.checkReadyForSleepLocked();
                        }
                        break;
                    }
                }
                case 104: {
                    if (ActivityStackSupervisor.this.mService.mDidDexOpt) {
                        ActivityStackSupervisor.this.mService.mDidDexOpt = false;
                        ActivityStackSupervisor.this.mHandler.sendEmptyMessageDelayed(104, 10000L);
                        return;
                    }
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        if (ActivityStackSupervisor.this.mLaunchingActivity.isHeld()) {
                            Slog.w("ActivityManager", "Launch timeout has expired, giving up wake lock!");
                            ActivityStackSupervisor.this.mLaunchingActivity.release();
                        }
                        break;
                    }
                }
            }
        }
    }
}

