/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.dreams;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.dreams.IDreamManager;
import android.util.Slog;
import com.android.internal.util.DumpUtils;
import com.android.server.dreams.DreamController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import libcore.util.Objects;

public final class DreamManagerService
extends IDreamManager.Stub {
    private static final boolean DEBUG = false;
    private static final String TAG = "DreamManagerService";
    private final Object mLock = new Object();
    private final Context mContext;
    private final DreamHandler mHandler;
    private final DreamController mController;
    private final PowerManager mPowerManager;
    private Binder mCurrentDreamToken;
    private ComponentName mCurrentDreamName;
    private int mCurrentDreamUserId;
    private boolean mCurrentDreamIsTest;
    private final DreamController.Listener mControllerListener = new DreamController.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDreamStopped(Binder token) {
            Object object = DreamManagerService.this.mLock;
            synchronized (object) {
                if (DreamManagerService.this.mCurrentDreamToken == token) {
                    DreamManagerService.this.cleanupDreamLocked();
                }
            }
        }
    };

    public DreamManagerService(Context context, Handler mainHandler) {
        this.mContext = context;
        this.mHandler = new DreamHandler(mainHandler.getLooper());
        this.mController = new DreamController(context, this.mHandler, this.mControllerListener);
        this.mPowerManager = (PowerManager)context.getSystemService("power");
    }

    public void systemRunning() {
        this.mContext.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                Object object = DreamManagerService.this.mLock;
                synchronized (object) {
                    DreamManagerService.this.stopDreamLocked();
                }
            }
        }, new IntentFilter("android.intent.action.USER_SWITCHED"), null, this.mHandler);
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump DreamManager from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("DREAM MANAGER (dumpsys dreams)");
        pw.println();
        pw.println("mCurrentDreamToken=" + this.mCurrentDreamToken);
        pw.println("mCurrentDreamName=" + this.mCurrentDreamName);
        pw.println("mCurrentDreamUserId=" + this.mCurrentDreamUserId);
        pw.println("mCurrentDreamIsTest=" + this.mCurrentDreamIsTest);
        pw.println();
        DumpUtils.dumpAsync(this.mHandler, new DumpUtils.Dump(){

            public void dump(PrintWriter pw) {
                DreamManagerService.this.mController.dump(pw);
            }
        }, pw, 200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentName[] getDreamComponents() {
        ComponentName[] componentNameArray;
        this.checkPermission("android.permission.READ_DREAM_STATE");
        int userId = UserHandle.getCallingUserId();
        long ident = Binder.clearCallingIdentity();
        try {
            componentNameArray = this.getDreamComponentsForUser(userId);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
        return componentNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDreamComponents(ComponentName[] componentNames) {
        this.checkPermission("android.permission.WRITE_DREAM_STATE");
        int userId = UserHandle.getCallingUserId();
        long ident = Binder.clearCallingIdentity();
        try {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "screensaver_components", DreamManagerService.componentsToString(componentNames), userId);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentName getDefaultDreamComponent() {
        ComponentName componentName;
        this.checkPermission("android.permission.READ_DREAM_STATE");
        int userId = UserHandle.getCallingUserId();
        long ident = Binder.clearCallingIdentity();
        try {
            String name = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "screensaver_default_component", userId);
            componentName = name == null ? null : ComponentName.unflattenFromString(name);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
        return componentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDreaming() {
        this.checkPermission("android.permission.READ_DREAM_STATE");
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentDreamToken != null && !this.mCurrentDreamIsTest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dream() {
        this.checkPermission("android.permission.WRITE_DREAM_STATE");
        long ident = Binder.clearCallingIdentity();
        try {
            long time = SystemClock.uptimeMillis();
            this.mPowerManager.userActivity(time, true);
            this.mPowerManager.nap(time);
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDream(ComponentName dream) {
        int currentUserId;
        this.checkPermission("android.permission.WRITE_DREAM_STATE");
        if (dream == null) {
            throw new IllegalArgumentException("dream must not be null");
        }
        int callingUserId = UserHandle.getCallingUserId();
        if (callingUserId != (currentUserId = ActivityManager.getCurrentUser())) {
            Slog.w(TAG, "Aborted attempt to start a test dream while a different  user is active: callingUserId=" + callingUserId + ", currentUserId=" + currentUserId);
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.startDreamLocked(dream, true, callingUserId);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaken() {
        this.checkPermission("android.permission.WRITE_DREAM_STATE");
        long ident = Binder.clearCallingIdentity();
        try {
            long time = SystemClock.uptimeMillis();
            this.mPowerManager.userActivity(time, false);
            this.stopDream();
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishSelf(IBinder token) {
        if (token == null) {
            throw new IllegalArgumentException("token must not be null");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCurrentDreamToken == token) {
                    this.stopDreamLocked();
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDream() {
        int userId = ActivityManager.getCurrentUser();
        ComponentName dream = this.chooseDreamForUser(userId);
        if (dream != null) {
            Object object = this.mLock;
            synchronized (object) {
                this.startDreamLocked(dream, false, userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDream() {
        Object object = this.mLock;
        synchronized (object) {
            this.stopDreamLocked();
        }
    }

    private ComponentName chooseDreamForUser(int userId) {
        ComponentName[] dreams = this.getDreamComponentsForUser(userId);
        return dreams != null && dreams.length != 0 ? dreams[0] : null;
    }

    private ComponentName[] getDreamComponentsForUser(int userId) {
        ComponentName defaultDream;
        String names = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "screensaver_components", userId);
        ComponentName[] components = DreamManagerService.componentsFromString(names);
        ArrayList<ComponentName> validComponents = new ArrayList<ComponentName>();
        if (components != null) {
            for (ComponentName component : components) {
                if (this.serviceExists(component)) {
                    validComponents.add(component);
                    continue;
                }
                Slog.w(TAG, "Dream " + component + " does not exist");
            }
        }
        if (validComponents.isEmpty() && (defaultDream = this.getDefaultDreamComponent()) != null) {
            Slog.w(TAG, "Falling back to default dream " + defaultDream);
            validComponents.add(defaultDream);
        }
        return validComponents.toArray(new ComponentName[validComponents.size()]);
    }

    private boolean serviceExists(ComponentName name) {
        try {
            return name != null && this.mContext.getPackageManager().getServiceInfo(name, 0) != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private void startDreamLocked(final ComponentName name, final boolean isTest, final int userId) {
        Binder newToken;
        if (Objects.equal(this.mCurrentDreamName, name) && this.mCurrentDreamIsTest == isTest && this.mCurrentDreamUserId == userId) {
            return;
        }
        this.stopDreamLocked();
        this.mCurrentDreamToken = newToken = new Binder();
        this.mCurrentDreamName = name;
        this.mCurrentDreamIsTest = isTest;
        this.mCurrentDreamUserId = userId;
        this.mHandler.post(new Runnable(){

            public void run() {
                DreamManagerService.this.mController.startDream(newToken, name, isTest, userId);
            }
        });
    }

    private void stopDreamLocked() {
        if (this.mCurrentDreamToken != null) {
            this.cleanupDreamLocked();
            this.mHandler.post(new Runnable(){

                public void run() {
                    DreamManagerService.this.mController.stopDream();
                }
            });
        }
    }

    private void cleanupDreamLocked() {
        this.mCurrentDreamToken = null;
        this.mCurrentDreamName = null;
        this.mCurrentDreamIsTest = false;
        this.mCurrentDreamUserId = 0;
    }

    private void checkPermission(String permission2) {
        if (this.mContext.checkCallingOrSelfPermission(permission2) != 0) {
            throw new SecurityException("Access denied to process: " + Binder.getCallingPid() + ", must have permission " + permission2);
        }
    }

    private static String componentsToString(ComponentName[] componentNames) {
        StringBuilder names = new StringBuilder();
        if (componentNames != null) {
            for (ComponentName componentName : componentNames) {
                if (names.length() > 0) {
                    names.append(',');
                }
                names.append(componentName.flattenToString());
            }
        }
        return names.toString();
    }

    private static ComponentName[] componentsFromString(String names) {
        if (names == null) {
            return null;
        }
        String[] namesArray = names.split(",");
        ComponentName[] componentNames = new ComponentName[namesArray.length];
        for (int i = 0; i < namesArray.length; ++i) {
            componentNames[i] = ComponentName.unflattenFromString(namesArray[i]);
        }
        return componentNames;
    }

    private final class DreamHandler
    extends Handler {
        public DreamHandler(Looper looper) {
            super(looper, null, true);
        }
    }
}

