/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.admin.IDevicePolicyManager;
import android.app.backup.IBackupManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ContainerEncryptionParams;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.ManifestDigest;
import android.content.pm.PackageCleanItem;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInfoLite;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.PackageUserState;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.VerificationParams;
import android.content.pm.VerifierDeviceIdentity;
import android.content.pm.VerifierInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.security.KeyStore;
import android.security.SystemKeyStore;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.LogPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.Display;
import android.view.WindowManager;
import com.android.internal.app.IMediaContainerService;
import com.android.internal.app.ResolverActivity;
import com.android.internal.content.NativeLibraryHelper;
import com.android.internal.content.PackageHelper;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.DeviceStorageMonitorService;
import com.android.server.IntentResolver;
import com.android.server.Watchdog;
import com.android.server.pm.BasePermission;
import com.android.server.pm.GrantedPermissions;
import com.android.server.pm.Installer;
import com.android.server.pm.KeySetManager;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageVerificationResponse;
import com.android.server.pm.PackageVerificationState;
import com.android.server.pm.PreferredActivity;
import com.android.server.pm.PreferredIntentResolver;
import com.android.server.pm.SELinuxMMAC;
import com.android.server.pm.Settings;
import com.android.server.pm.SharedUserSetting;
import com.android.server.pm.UserManagerService;
import dalvik.system.DexFile;
import dalvik.system.StaleDexCacheError;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.io.StructStat;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManagerService
extends IPackageManager.Stub {
    static final String TAG = "PackageManager";
    static final boolean DEBUG_SETTINGS = false;
    static final boolean DEBUG_PREFERRED = false;
    static final boolean DEBUG_UPGRADE = false;
    private static final boolean DEBUG_INSTALL = false;
    private static final boolean DEBUG_REMOVE = false;
    private static final boolean DEBUG_BROADCASTS = false;
    private static final boolean DEBUG_SHOW_INFO = false;
    private static final boolean DEBUG_PACKAGE_INFO = false;
    private static final boolean DEBUG_INTENT_MATCHING = false;
    private static final boolean DEBUG_PACKAGE_SCANNING = false;
    private static final boolean DEBUG_APP_DIR_OBSERVER = false;
    private static final boolean DEBUG_VERIFY = false;
    private static final int RADIO_UID = 1001;
    private static final int LOG_UID = 1007;
    private static final int NFC_UID = 1027;
    private static final int BLUETOOTH_UID = 1002;
    private static final int SHELL_UID = 2000;
    private static final boolean GET_CERTIFICATES = true;
    private static final int REMOVE_EVENTS = 584;
    private static final int ADD_EVENTS = 136;
    private static final int OBSERVER_EVENTS = 712;
    private static final String INSTALL_PACKAGE_SUFFIX = "-";
    static final int SCAN_MONITOR = 1;
    static final int SCAN_NO_DEX = 2;
    static final int SCAN_FORCE_DEX = 4;
    static final int SCAN_UPDATE_SIGNATURE = 8;
    static final int SCAN_NEW_INSTALL = 16;
    static final int SCAN_NO_PATHS = 32;
    static final int SCAN_UPDATE_TIME = 64;
    static final int SCAN_DEFER_DEX = 128;
    static final int SCAN_BOOTING = 256;
    static final int REMOVE_CHATTY = 65536;
    private static final boolean DEFAULT_VERIFY_ENABLE = true;
    private static final long DEFAULT_VERIFICATION_TIMEOUT = 10000L;
    private static final int DEFAULT_VERIFICATION_RESPONSE = 1;
    static final String DEFAULT_CONTAINER_PACKAGE = "com.android.defcontainer";
    static final ComponentName DEFAULT_CONTAINER_COMPONENT = new ComponentName("com.android.defcontainer", "com.android.defcontainer.DefaultContainerService");
    private static final String PACKAGE_MIME_TYPE = "application/vnd.android.package-archive";
    private static final String LIB_DIR_NAME = "lib";
    static final String mTempContainerPrefix = "smdl2tmp";
    final HandlerThread mHandlerThread = new HandlerThread("PackageManager", 10);
    final PackageHandler mHandler;
    final int mSdkVersion = Build.VERSION.SDK_INT;
    final String mSdkCodename = "REL".equals(Build.VERSION.CODENAME) ? null : Build.VERSION.CODENAME;
    final Context mContext;
    final boolean mFactoryTest;
    final boolean mOnlyCore;
    final boolean mNoDexOpt;
    final DisplayMetrics mMetrics;
    final int mDefParseFlags;
    final String[] mSeparateProcesses;
    final File mAppDataDir;
    final File mUserAppDataDir;
    final String mAsecInternalPath;
    final FileObserver mFrameworkInstallObserver;
    final FileObserver mSystemInstallObserver;
    final FileObserver mPrivilegedInstallObserver;
    final FileObserver mVendorInstallObserver;
    final FileObserver mAppInstallObserver;
    final FileObserver mDrmAppInstallObserver;
    final Installer mInstaller;
    final File mAppInstallDir;
    private File mAppLibInstallDir;
    final File mDrmAppPrivateInstallDir;
    final Object mInstallLock = new Object();
    final HashMap<String, PackageParser.Package> mAppDirs = new HashMap();
    File mScanningPath;
    int mLastScanError;
    final HashMap<String, PackageParser.Package> mPackages = new HashMap();
    final Settings mSettings;
    boolean mRestoredSettings;
    int[] mGlobalGids;
    final SparseArray<HashSet<String>> mSystemPermissions = new SparseArray();
    final HashMap<String, SharedLibraryEntry> mSharedLibraries = new HashMap();
    String[] mTmpSharedLibraries = null;
    final HashMap<String, FeatureInfo> mAvailableFeatures = new HashMap();
    boolean mFoundPolicyFile;
    final ActivityIntentResolver mActivities = new ActivityIntentResolver();
    final ActivityIntentResolver mReceivers = new ActivityIntentResolver();
    final ServiceIntentResolver mServices = new ServiceIntentResolver();
    final ProviderIntentResolver mProviders = new ProviderIntentResolver();
    final HashMap<String, PackageParser.Provider> mProvidersByAuthority = new HashMap();
    final HashMap<ComponentName, PackageParser.Instrumentation> mInstrumentation = new HashMap();
    final HashMap<String, PackageParser.PermissionGroup> mPermissionGroups = new HashMap();
    final HashSet<String> mTransferedPackages = new HashSet();
    final HashSet<String> mProtectedBroadcasts = new HashSet();
    final SparseArray<PackageVerificationState> mPendingVerification = new SparseArray();
    HashSet<PackageParser.Package> mDeferredDexOpt = null;
    private int mPendingVerificationToken = 0;
    boolean mSystemReady;
    boolean mSafeMode;
    boolean mHasSystemUidErrors;
    ApplicationInfo mAndroidApplication;
    final ActivityInfo mResolveActivity = new ActivityInfo();
    final ResolveInfo mResolveInfo = new ResolveInfo();
    ComponentName mResolveComponentName;
    PackageParser.Package mPlatformPackage;
    ComponentName mCustomResolverComponentName;
    boolean mResolverReplaced = false;
    final PendingPackageBroadcasts mPendingBroadcasts = new PendingPackageBroadcasts();
    private IMediaContainerService mContainerService = null;
    static final int SEND_PENDING_BROADCAST = 1;
    static final int MCS_BOUND = 3;
    static final int END_COPY = 4;
    static final int INIT_COPY = 5;
    static final int MCS_UNBIND = 6;
    static final int START_CLEANING_PACKAGE = 7;
    static final int FIND_INSTALL_LOC = 8;
    static final int POST_INSTALL = 9;
    static final int MCS_RECONNECT = 10;
    static final int MCS_GIVE_UP = 11;
    static final int UPDATED_MEDIA_STATUS = 12;
    static final int WRITE_SETTINGS = 13;
    static final int WRITE_PACKAGE_RESTRICTIONS = 14;
    static final int PACKAGE_VERIFIED = 15;
    static final int CHECK_PENDING_VERIFICATION = 16;
    static final int WRITE_SETTINGS_DELAY = 10000;
    static final int BROADCAST_DELAY = 10000;
    static UserManagerService sUserManager;
    private HashSet<Integer> mDirtyUsers = new HashSet();
    private final DefaultContainerConnection mDefContainerConn = new DefaultContainerConnection();
    final SparseArray<PostInstallData> mRunningInstalls = new SparseArray();
    int mNextInstallToken = 1;
    private final String mRequiredVerifierPackage;
    static final int DEX_OPT_SKIPPED = 0;
    static final int DEX_OPT_PERFORMED = 1;
    static final int DEX_OPT_DEFERRED = 2;
    static final int DEX_OPT_FAILED = -1;
    static final int UPDATE_PERMISSIONS_ALL = 1;
    static final int UPDATE_PERMISSIONS_REPLACE_PKG = 2;
    static final int UPDATE_PERMISSIONS_REPLACE_ALL = 4;
    private static final Comparator<ResolveInfo> mResolvePrioritySorter;
    private static final Comparator<ProviderInfo> mProviderInitOrderSorter;
    static final boolean DEBUG_SD_INSTALL = false;
    private static final String SD_ENCRYPTION_KEYSTORE_NAME = "AppsOnSD";
    private static final String SD_ENCRYPTION_ALGORITHM = "AES";
    private boolean mMediaMounted = false;

    void scheduleWriteSettingsLocked() {
        if (!this.mHandler.hasMessages(13)) {
            this.mHandler.sendEmptyMessageDelayed(13, 10000L);
        }
    }

    void scheduleWritePackageRestrictionsLocked(int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.mDirtyUsers.add(userId);
        if (!this.mHandler.hasMessages(14)) {
            this.mHandler.sendEmptyMessageDelayed(14, 10000L);
        }
    }

    public static final IPackageManager main(Context context, Installer installer, boolean factoryTest, boolean onlyCore) {
        PackageManagerService m = new PackageManagerService(context, installer, factoryTest, onlyCore);
        ServiceManager.addService("package", m);
        return m;
    }

    static String[] splitString(String str, char sep) {
        int count = 1;
        int i = 0;
        while ((i = str.indexOf(sep, i)) >= 0) {
            ++count;
            ++i;
        }
        String[] res = new String[count];
        i = 0;
        count = 0;
        int lastI = 0;
        while ((i = str.indexOf(sep, i)) >= 0) {
            res[count] = str.substring(lastI, i);
            ++count;
            lastI = ++i;
        }
        res[count] = str.substring(lastI, str.length());
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageManagerService(Context context, Installer installer, boolean factoryTest, boolean onlyCore) {
        EventLog.writeEvent(3060, SystemClock.uptimeMillis());
        if (this.mSdkVersion <= 0) {
            Slog.w(TAG, "**** ro.build.version.sdk not set!");
        }
        this.mContext = context;
        this.mFactoryTest = factoryTest;
        this.mOnlyCore = onlyCore;
        this.mNoDexOpt = "eng".equals(SystemProperties.get("ro.build.type"));
        this.mMetrics = new DisplayMetrics();
        this.mSettings = new Settings(context);
        this.mSettings.addSharedUserLPw("android.uid.system", 1000, 0x40000001);
        this.mSettings.addSharedUserLPw("android.uid.phone", 1001, 0x40000001);
        this.mSettings.addSharedUserLPw("android.uid.log", 1007, 0x40000001);
        this.mSettings.addSharedUserLPw("android.uid.nfc", 1027, 0x40000001);
        this.mSettings.addSharedUserLPw("android.uid.bluetooth", 1002, 0x40000001);
        this.mSettings.addSharedUserLPw("android.uid.shell", 2000, 0x40000001);
        String separateProcesses = SystemProperties.get("debug.separate_processes");
        if (separateProcesses != null && separateProcesses.length() > 0) {
            if ("*".equals(separateProcesses)) {
                this.mDefParseFlags = 8;
                this.mSeparateProcesses = null;
                Slog.w(TAG, "Running with debug.separate_processes: * (ALL)");
            } else {
                this.mDefParseFlags = 0;
                this.mSeparateProcesses = separateProcesses.split(",");
                Slog.w(TAG, "Running with debug.separate_processes: " + separateProcesses);
            }
        } else {
            this.mDefParseFlags = 0;
            this.mSeparateProcesses = null;
        }
        this.mInstaller = installer;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display d = wm.getDefaultDisplay();
        d.getMetrics(this.mMetrics);
        Object object = this.mInstallLock;
        synchronized (object) {
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                boolean regrantPermissions;
                File dalvikCacheDir;
                String[] files;
                this.mHandlerThread.start();
                this.mHandler = new PackageHandler(this.mHandlerThread.getLooper());
                Watchdog.getInstance().addThread(this.mHandler, this.mHandlerThread.getName());
                File dataDir = Environment.getDataDirectory();
                this.mAppDataDir = new File(dataDir, "data");
                this.mAppInstallDir = new File(dataDir, "app");
                this.mAppLibInstallDir = new File(dataDir, "app-lib");
                this.mAsecInternalPath = new File(dataDir, "app-asec").getPath();
                this.mUserAppDataDir = new File(dataDir, "user");
                this.mDrmAppPrivateInstallDir = new File(dataDir, "app-private");
                sUserManager = new UserManagerService(context, this, this.mInstallLock, this.mPackages);
                this.readPermissions();
                this.mFoundPolicyFile = SELinuxMMAC.readInstallPolicy();
                this.mRestoredSettings = this.mSettings.readLPw(this, sUserManager.getUsers(false), this.mSdkVersion, this.mOnlyCore);
                String customResolverActivity = Resources.getSystem().getString(17039417);
                if (TextUtils.isEmpty(customResolverActivity)) {
                    customResolverActivity = null;
                } else {
                    this.mCustomResolverComponentName = ComponentName.unflattenFromString(customResolverActivity);
                }
                long startTime = SystemClock.uptimeMillis();
                EventLog.writeEvent(3070, startTime);
                int scanMode = 417;
                if (this.mNoDexOpt) {
                    Slog.w(TAG, "Running ENG build: no pre-dexopt!");
                    scanMode |= 2;
                }
                HashSet<String> alreadyDexOpted = new HashSet<String>();
                String bootClassPath = System.getProperty("java.boot.class.path");
                if (bootClassPath != null) {
                    String[] paths = PackageManagerService.splitString(bootClassPath, ':');
                    for (int i = 0; i < paths.length; ++i) {
                        alreadyDexOpted.add(paths[i]);
                    }
                } else {
                    Slog.w(TAG, "No BOOTCLASSPATH found!");
                }
                boolean didDexOpt = false;
                if (this.mSharedLibraries.size() > 0) {
                    Iterator<SharedLibraryEntry> libs = this.mSharedLibraries.values().iterator();
                    while (libs.hasNext()) {
                        String lib = libs.next().path;
                        if (lib == null) continue;
                        try {
                            if (!DexFile.isDexOptNeeded(lib)) continue;
                            alreadyDexOpted.add(lib);
                            this.mInstaller.dexopt(lib, 1000, true);
                            didDexOpt = true;
                        }
                        catch (FileNotFoundException e) {
                            Slog.w(TAG, "Library not found: " + lib);
                        }
                        catch (IOException e) {
                            Slog.w(TAG, "Cannot dexopt " + lib + "; is it an APK or JAR? " + e.getMessage());
                        }
                    }
                }
                File frameworkDir = new File(Environment.getRootDirectory(), "framework");
                alreadyDexOpted.add(frameworkDir.getPath() + "/framework-res.apk");
                alreadyDexOpted.add(frameworkDir.getPath() + "/core-libart.jar");
                String[] frameworkFiles = frameworkDir.list();
                if (frameworkFiles != null) {
                    for (int i = 0; i < frameworkFiles.length; ++i) {
                        File libPath = new File(frameworkDir, frameworkFiles[i]);
                        String path = libPath.getPath();
                        if (alreadyDexOpted.contains(path) || !path.endsWith(".apk") && !path.endsWith(".jar")) continue;
                        try {
                            if (!DexFile.isDexOptNeeded(path)) continue;
                            this.mInstaller.dexopt(path, 1000, true);
                            didDexOpt = true;
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            Slog.w(TAG, "Jar not found: " + path);
                            continue;
                        }
                        catch (IOException e) {
                            Slog.w(TAG, "Exception reading jar: " + path, e);
                        }
                    }
                }
                if (didDexOpt && (files = (dalvikCacheDir = new File(dataDir, "dalvik-cache")).list()) != null) {
                    for (int i = 0; i < files.length; ++i) {
                        String fn = files[i];
                        if (!fn.startsWith("data@app@") && !fn.startsWith("data@app-private@")) continue;
                        Slog.i(TAG, "Pruning dalvik file: " + fn);
                        new File(dalvikCacheDir, fn).delete();
                    }
                }
                this.mFrameworkInstallObserver = new AppDirObserver(frameworkDir.getPath(), 712, true, false);
                this.mFrameworkInstallObserver.startWatching();
                this.scanDirLI(frameworkDir, 65, scanMode | 2, 0L);
                File privilegedAppDir = new File(Environment.getRootDirectory(), "priv-app");
                this.mPrivilegedInstallObserver = new AppDirObserver(privilegedAppDir.getPath(), 712, true, true);
                this.mPrivilegedInstallObserver.startWatching();
                this.scanDirLI(privilegedAppDir, 193, scanMode, 0L);
                File systemAppDir = new File(Environment.getRootDirectory(), "app");
                this.mSystemInstallObserver = new AppDirObserver(systemAppDir.getPath(), 712, true, false);
                this.mSystemInstallObserver.startWatching();
                this.scanDirLI(systemAppDir, 65, scanMode, 0L);
                File vendorAppDir = new File("/vendor/app");
                this.mVendorInstallObserver = new AppDirObserver(vendorAppDir.getPath(), 712, true, false);
                this.mVendorInstallObserver.startWatching();
                this.scanDirLI(vendorAppDir, 65, scanMode, 0L);
                this.mInstaller.moveFiles();
                ArrayList<String> possiblyDeletedUpdatedSystemApps = new ArrayList<String>();
                if (!this.mOnlyCore) {
                    Iterator<PackageSetting> psit = this.mSettings.mPackages.values().iterator();
                    while (psit.hasNext()) {
                        PackageSetting ps = psit.next();
                        if ((ps.pkgFlags & 1) == 0) continue;
                        PackageParser.Package scannedPkg = this.mPackages.get(ps.name);
                        if (scannedPkg != null) {
                            if (!this.mSettings.isDisabledSystemPackageLPr(ps.name)) continue;
                            Slog.i(TAG, "Expecting better updatd system app for " + ps.name + "; removing system app");
                            this.removePackageLI(ps, true);
                            continue;
                        }
                        if (!this.mSettings.isDisabledSystemPackageLPr(ps.name)) {
                            psit.remove();
                            String msg = "System package " + ps.name + " no longer exists; wiping its data";
                            PackageManagerService.reportSettingsProblem(5, msg);
                            this.removeDataDirsLI(ps.name);
                            continue;
                        }
                        PackageSetting disabledPs = this.mSettings.getDisabledSystemPkgLPr(ps.name);
                        if (disabledPs.codePath != null && disabledPs.codePath.exists()) continue;
                        possiblyDeletedUpdatedSystemApps.add(ps.name);
                    }
                }
                ArrayList<PackageSetting> deletePkgsList = this.mSettings.getListOfIncompleteInstallPackagesLPr();
                for (int i = 0; i < deletePkgsList.size(); ++i) {
                    this.cleanupInstallFailedPackage(deletePkgsList.get(i));
                }
                this.deleteTempPackageFiles();
                this.mSettings.pruneSharedUsersLPw();
                if (!this.mOnlyCore) {
                    EventLog.writeEvent(3080, SystemClock.uptimeMillis());
                    this.mAppInstallObserver = new AppDirObserver(this.mAppInstallDir.getPath(), 712, false, false);
                    this.mAppInstallObserver.startWatching();
                    this.scanDirLI(this.mAppInstallDir, 0, scanMode, 0L);
                    this.mDrmAppInstallObserver = new AppDirObserver(this.mDrmAppPrivateInstallDir.getPath(), 712, false, false);
                    this.mDrmAppInstallObserver.startWatching();
                    this.scanDirLI(this.mDrmAppPrivateInstallDir, 16, scanMode, 0L);
                    for (String deletedAppName : possiblyDeletedUpdatedSystemApps) {
                        String msg;
                        PackageParser.Package deletedPkg = this.mPackages.get(deletedAppName);
                        this.mSettings.removeDisabledSystemPackageLPw(deletedAppName);
                        if (deletedPkg == null) {
                            msg = "Updated system package " + deletedAppName + " no longer exists; wiping its data";
                            this.removeDataDirsLI(deletedAppName);
                        } else {
                            msg = "Updated system app + " + deletedAppName + " no longer present; removing system privileges for " + deletedAppName;
                            deletedPkg.applicationInfo.flags &= 0xFFFFFFFE;
                            PackageSetting deletedPs = this.mSettings.mPackages.get(deletedAppName);
                            deletedPs.pkgFlags &= 0xFFFFFFFE;
                        }
                        PackageManagerService.reportSettingsProblem(5, msg);
                    }
                } else {
                    this.mAppInstallObserver = null;
                    this.mDrmAppInstallObserver = null;
                }
                this.updateAllSharedLibrariesLPw();
                EventLog.writeEvent(3090, SystemClock.uptimeMillis());
                Slog.i(TAG, "Time to scan packages: " + (float)(SystemClock.uptimeMillis() - startTime) / 1000.0f + " seconds");
                boolean bl = regrantPermissions = this.mSettings.mInternalSdkPlatform != this.mSdkVersion;
                if (regrantPermissions) {
                    Slog.i(TAG, "Platform changed from " + this.mSettings.mInternalSdkPlatform + " to " + this.mSdkVersion + "; regranting permissions for internal storage");
                }
                this.mSettings.mInternalSdkPlatform = this.mSdkVersion;
                this.updatePermissionsLPw(null, null, 1 | (regrantPermissions ? 6 : 0));
                if (!this.mRestoredSettings && !onlyCore) {
                    this.mSettings.readDefaultPreferredAppsLPw(this, 0);
                }
                this.mSettings.writeLPr();
                EventLog.writeEvent(3100, SystemClock.uptimeMillis());
                Runtime.getRuntime().gc();
                this.mRequiredVerifierPackage = this.getRequiredVerifierLPr();
            }
        }
    }

    @Override
    public boolean isFirstBoot() {
        return !this.mRestoredSettings;
    }

    @Override
    public boolean isOnlyCoreApps() {
        return this.mOnlyCore;
    }

    private String getRequiredVerifierLPr() {
        Intent verification = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
        List<ResolveInfo> receivers = this.queryIntentReceivers(verification, PACKAGE_MIME_TYPE, 512, 0);
        String requiredVerifier = null;
        int N = receivers.size();
        for (int i = 0; i < N; ++i) {
            GrantedPermissions gp;
            String packageName;
            PackageSetting ps;
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || (ps = this.mSettings.mPackages.get(packageName = info.activityInfo.packageName)) == null) continue;
            GrantedPermissions grantedPermissions = gp = ps.sharedUser != null ? ps.sharedUser : ps;
            if (!gp.grantedPermissions.contains("android.permission.PACKAGE_VERIFICATION_AGENT")) continue;
            if (requiredVerifier != null) {
                throw new RuntimeException("There can be only one required verifier");
            }
            requiredVerifier = packageName;
        }
        return requiredVerifier;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException) && !(e instanceof IllegalArgumentException)) {
                Slog.wtf(TAG, "Package Manager Crash", e);
            }
            throw e;
        }
    }

    void cleanupInstallFailedPackage(PackageSetting ps) {
        Slog.i(TAG, "Cleaning up incompletely installed app: " + ps.name);
        this.removeDataDirsLI(ps.name);
        if (ps.codePath != null && !ps.codePath.delete()) {
            Slog.w(TAG, "Unable to remove old code file: " + ps.codePath);
        }
        if (ps.resourcePath != null && !ps.resourcePath.delete() && !ps.resourcePath.equals(ps.codePath)) {
            Slog.w(TAG, "Unable to remove old code file: " + ps.resourcePath);
        }
        this.mSettings.removePackageLPw(ps.name);
    }

    void readPermissions() {
        File libraryDir = new File(Environment.getRootDirectory(), "etc/permissions");
        if (!libraryDir.exists() || !libraryDir.isDirectory()) {
            Slog.w(TAG, "No directory " + libraryDir + ", skipping");
            return;
        }
        if (!libraryDir.canRead()) {
            Slog.w(TAG, "Directory " + libraryDir + " cannot be read");
            return;
        }
        for (File f : libraryDir.listFiles()) {
            if (f.getPath().endsWith("etc/permissions/platform.xml")) continue;
            if (!f.getPath().endsWith(".xml")) {
                Slog.i(TAG, "Non-xml file " + f + " in " + libraryDir + " directory, ignoring");
                continue;
            }
            if (!f.canRead()) {
                Slog.w(TAG, "Permissions library file " + f + " cannot be read");
                continue;
            }
            this.readPermissionsFromXml(f);
        }
        File permFile = new File(Environment.getRootDirectory(), "etc/permissions/platform.xml");
        this.readPermissionsFromXml(permFile);
    }

    private void readPermissionsFromXml(File permFile) {
        FileReader permReader = null;
        try {
            permReader = new FileReader(permFile);
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "Couldn't find or open permissions file " + permFile);
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(permReader);
            XmlUtils.beginDocument(parser, "permissions");
            while (true) {
                String perm;
                XmlUtils.nextElement(parser);
                if (parser.getEventType() == 1) break;
                String name = parser.getName();
                if ("group".equals(name)) {
                    String gidStr = parser.getAttributeValue(null, "gid");
                    if (gidStr != null) {
                        int gid = Process.getGidForName(gidStr);
                        this.mGlobalGids = ArrayUtils.appendInt(this.mGlobalGids, gid);
                    } else {
                        Slog.w(TAG, "<group> without gid at " + parser.getPositionDescription());
                    }
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("permission".equals(name)) {
                    perm = parser.getAttributeValue(null, "name");
                    if (perm == null) {
                        Slog.w(TAG, "<permission> without name at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    perm = perm.intern();
                    this.readPermission(parser, perm);
                    continue;
                }
                if ("assign-permission".equals(name)) {
                    perm = parser.getAttributeValue(null, "name");
                    if (perm == null) {
                        Slog.w(TAG, "<assign-permission> without name at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    String uidStr = parser.getAttributeValue(null, "uid");
                    if (uidStr == null) {
                        Slog.w(TAG, "<assign-permission> without uid at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    int uid = Process.getUidForName(uidStr);
                    if (uid < 0) {
                        Slog.w(TAG, "<assign-permission> with unknown uid \"" + uidStr + "\" at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    perm = perm.intern();
                    HashSet<String> perms = this.mSystemPermissions.get(uid);
                    if (perms == null) {
                        perms = new HashSet();
                        this.mSystemPermissions.put(uid, perms);
                    }
                    perms.add(perm);
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("library".equals(name)) {
                    String lname = parser.getAttributeValue(null, "name");
                    String lfile = parser.getAttributeValue(null, "file");
                    if (lname == null) {
                        Slog.w(TAG, "<library> without name at " + parser.getPositionDescription());
                    } else if (lfile == null) {
                        Slog.w(TAG, "<library> without file at " + parser.getPositionDescription());
                    } else {
                        this.mSharedLibraries.put(lname, new SharedLibraryEntry(lfile, null));
                    }
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                if ("feature".equals(name)) {
                    String fname = parser.getAttributeValue(null, "name");
                    if (fname == null) {
                        Slog.w(TAG, "<feature> without name at " + parser.getPositionDescription());
                    } else {
                        FeatureInfo fi = new FeatureInfo();
                        fi.name = fname;
                        this.mAvailableFeatures.put(fname, fi);
                    }
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
            }
            permReader.close();
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Got execption parsing permissions.", e);
        }
        catch (IOException e) {
            Slog.w(TAG, "Got execption parsing permissions.", e);
        }
    }

    void readPermission(XmlPullParser parser, String name) throws IOException, XmlPullParserException {
        int type;
        BasePermission bp = this.mSettings.mPermissions.get(name = name.intern());
        if (bp == null) {
            bp = new BasePermission(name, null, 1);
            this.mSettings.mPermissions.put(name, bp);
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("group".equals(tagName)) {
                String gidStr = parser.getAttributeValue(null, "gid");
                if (gidStr != null) {
                    int gid = Process.getGidForName(gidStr);
                    bp.gids = ArrayUtils.appendInt(bp.gids, gid);
                } else {
                    Slog.w(TAG, "<group> without gid at " + parser.getPositionDescription());
                }
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    static int[] appendInts(int[] cur, int[] add) {
        if (add == null) {
            return cur;
        }
        if (cur == null) {
            return add;
        }
        int N = add.length;
        for (int i = 0; i < N; ++i) {
            cur = ArrayUtils.appendInt(cur, add[i]);
        }
        return cur;
    }

    static int[] removeInts(int[] cur, int[] rem) {
        if (rem == null) {
            return cur;
        }
        if (cur == null) {
            return cur;
        }
        int N = rem.length;
        for (int i = 0; i < N; ++i) {
            cur = ArrayUtils.removeInt(cur, rem[i]);
        }
        return cur;
    }

    PackageInfo generatePackageInfo(PackageParser.Package p, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = (PackageSetting)p.mExtras;
        if (ps == null) {
            return null;
        }
        GrantedPermissions gp = ps.sharedUser != null ? ps.sharedUser : ps;
        PackageUserState state = ps.readUserState(userId);
        return PackageParser.generatePackageInfo(p, gp.gids, flags, ps.firstInstallTime, ps.lastUpdateTime, gp.grantedPermissions, state, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageInfo getPackageInfo(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, "get package info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                return this.generatePackageInfo(p, flags, userId);
            }
            if ((flags & 0x2000) != 0) {
                return this.generatePackageInfoFromSettingsLPw(packageName, flags, userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] currentToCanonicalPackageNames(String[] names) {
        String[] out = new String[names.length];
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (int i = names.length - 1; i >= 0; --i) {
                PackageSetting ps = this.mSettings.mPackages.get(names[i]);
                out[i] = ps != null && ps.realName != null ? ps.realName : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] canonicalToCurrentPackageNames(String[] names) {
        String[] out = new String[names.length];
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (int i = names.length - 1; i >= 0; --i) {
                String cur = this.mSettings.mRenamedPackages.get(names[i]);
                out[i] = cur != null ? cur : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageUid(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return -1;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, "get package uid");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                return UserHandle.getUid(userId, p.applicationInfo.uid);
            }
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || ps.pkg == null || ps.pkg.applicationInfo == null) {
                return -1;
            }
            p = ps.pkg;
            int n = p != null ? UserHandle.getUid(userId, p.applicationInfo.uid) : -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getPackageGids(String packageName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageSetting ps = (PackageSetting)p.mExtras;
                return ps.getGids();
            }
        }
        return new int[0];
    }

    static final PermissionInfo generatePermissionInfo(BasePermission bp, int flags) {
        if (bp.perm != null) {
            return PackageParser.generatePermissionInfo(bp.perm, flags);
        }
        PermissionInfo pi = new PermissionInfo();
        pi.name = bp.name;
        pi.packageName = bp.sourcePackage;
        pi.nonLocalizedLabel = bp.name;
        pi.protectionLevel = bp.protectionLevel;
        return pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionInfo getPermissionInfo(String name, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            BasePermission p = this.mSettings.mPermissions.get(name);
            if (p != null) {
                return PackageManagerService.generatePermissionInfo(p, flags);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PermissionInfo> queryPermissionsByGroup(String group, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<PermissionInfo> out = new ArrayList<PermissionInfo>(10);
            for (BasePermission p : this.mSettings.mPermissions.values()) {
                if (group == null) {
                    if (p.perm != null && p.perm.info.group != null) continue;
                    out.add(PackageManagerService.generatePermissionInfo(p, flags));
                    continue;
                }
                if (p.perm == null || !group.equals(p.perm.info.group)) continue;
                out.add(PackageParser.generatePermissionInfo(p.perm, flags));
            }
            if (out.size() > 0) {
                return out;
            }
            return this.mPermissionGroups.containsKey(group) ? out : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return PackageParser.generatePermissionGroupInfo(this.mPermissionGroups.get(name), flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            int N = this.mPermissionGroups.size();
            ArrayList<PermissionGroupInfo> out = new ArrayList<PermissionGroupInfo>(N);
            for (PackageParser.PermissionGroup pg : this.mPermissionGroups.values()) {
                out.add(PackageParser.generatePermissionGroupInfo(pg, flags));
            }
            return out;
        }
    }

    private ApplicationInfo generateApplicationInfoFromSettingsLPw(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null) {
            if (ps.pkg == null) {
                PackageInfo pInfo = this.generatePackageInfoFromSettingsLPw(packageName, flags, userId);
                if (pInfo != null) {
                    return pInfo.applicationInfo;
                }
                return null;
            }
            return PackageParser.generateApplicationInfo(ps.pkg, flags, ps.readUserState(userId), userId);
        }
        return null;
    }

    private PackageInfo generatePackageInfoFromSettingsLPw(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null) {
            PackageParser.Package pkg = ps.pkg;
            if (pkg == null) {
                if ((flags & 0x2000) == 0) {
                    return null;
                }
                pkg = new PackageParser.Package(packageName);
                pkg.applicationInfo.packageName = packageName;
                pkg.applicationInfo.flags = ps.pkgFlags | 0x1000000;
                pkg.applicationInfo.publicSourceDir = ps.resourcePathString;
                pkg.applicationInfo.sourceDir = ps.codePathString;
                pkg.applicationInfo.dataDir = this.getDataPathForPackage(packageName, 0).getPath();
                pkg.applicationInfo.nativeLibraryDir = ps.nativeLibraryPathString;
            }
            return this.generatePackageInfo(pkg, flags, userId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationInfo getApplicationInfo(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, "get application info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId);
            }
            if ("android".equals(packageName) || "system".equals(packageName)) {
                return this.mAndroidApplication;
            }
            if ((flags & 0x2000) != 0) {
                return this.generateApplicationInfoFromSettingsLPw(packageName, flags, userId);
            }
        }
        return null;
    }

    @Override
    public void freeStorageAndNotify(final long freeStorageSize, final IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", null);
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int retCode = -1;
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    retCode = PackageManagerService.this.mInstaller.freeCache(freeStorageSize);
                    if (retCode < 0) {
                        Slog.w(PackageManagerService.TAG, "Couldn't clear application caches");
                    }
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(null, retCode >= 0);
                    }
                    catch (RemoteException e) {
                        Slog.w(PackageManagerService.TAG, "RemoveException when invoking call back");
                    }
                }
            }
        });
    }

    @Override
    public void freeStorage(final long freeStorageSize, final IntentSender pi) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", null);
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int retCode = -1;
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    retCode = PackageManagerService.this.mInstaller.freeCache(freeStorageSize);
                    if (retCode < 0) {
                        Slog.w(PackageManagerService.TAG, "Couldn't clear application caches");
                    }
                }
                if (pi != null) {
                    try {
                        int code = retCode >= 0 ? 1 : 0;
                        pi.sendIntent(null, code, null, null, null);
                    }
                    catch (IntentSender.SendIntentException e1) {
                        Slog.i(PackageManagerService.TAG, "Failed to send pending intent");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityInfo getActivityInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, "get activity info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mActivities.mActivities.get(component);
            if (a != null && this.mSettings.isEnabledLPr(a.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateActivityInfo(a, flags, ps.readUserState(userId), userId);
            }
            if (this.mResolveComponentName.equals(component)) {
                return this.mResolveActivity;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityInfo getReceiverInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, "get receiver info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mReceivers.mActivities.get(component);
            if (a != null && this.mSettings.isEnabledLPr(a.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateActivityInfo(a, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo getServiceInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, "get service info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Service s = (PackageParser.Service)this.mServices.mServices.get(component);
            if (s != null && this.mSettings.isEnabledLPr(s.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateServiceInfo(s, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderInfo getProviderInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, "get provider info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Provider p = (PackageParser.Provider)this.mProviders.mProviders.get(component);
            if (p != null && this.mSettings.isEnabledLPr(p.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSystemSharedLibraryNames() {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Set<String> libSet = this.mSharedLibraries.keySet();
            int size = libSet.size();
            if (size > 0) {
                String[] libs = new String[size];
                libSet.toArray(libs);
                return libs;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureInfo[] getSystemAvailableFeatures() {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Collection<FeatureInfo> featSet = this.mAvailableFeatures.values();
            int size = featSet.size();
            if (size > 0) {
                FeatureInfo[] features = new FeatureInfo[size + 1];
                featSet.toArray(features);
                FeatureInfo fi = new FeatureInfo();
                fi.reqGlEsVersion = SystemProperties.getInt("ro.opengles.version", 0);
                features[size] = fi;
                return features;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSystemFeature(String name) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mAvailableFeatures.containsKey(name);
        }
    }

    private void checkValidCaller(int uid, int userId) {
        if (UserHandle.getUserId(uid) == userId || uid == 1000 || uid == 0) {
            return;
        }
        throw new SecurityException("Caller uid=" + uid + " is not privileged to communicate with user=" + userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkPermission(String permName, String pkgName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(pkgName);
            if (p != null && p.mExtras != null) {
                PackageSetting ps = (PackageSetting)p.mExtras;
                if (ps.sharedUser != null) {
                    if (ps.sharedUser.grantedPermissions.contains(permName)) {
                        return 0;
                    }
                } else if (ps.grantedPermissions.contains(permName)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkUidPermission(String permName, int uid) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj != null) {
                GrantedPermissions gp = (GrantedPermissions)obj;
                if (gp.grantedPermissions.contains(permName)) {
                    return 0;
                }
            } else {
                HashSet<String> perms = this.mSystemPermissions.get(uid);
                if (perms != null && perms.contains(permName)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    private void enforceCrossUserPermission(int callingUid, int userId, boolean requireFullPermission, String message) {
        if (userId < 0) {
            throw new IllegalArgumentException("Invalid userId " + userId);
        }
        if (userId == UserHandle.getUserId(callingUid)) {
            return;
        }
        if (callingUid != 1000 && callingUid != 0) {
            if (requireFullPermission) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
            } else {
                try {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
                }
                catch (SecurityException se) {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", message);
                }
            }
        }
    }

    private BasePermission findPermissionTreeLP(String permName) {
        for (BasePermission bp : this.mSettings.mPermissionTrees.values()) {
            if (!permName.startsWith(bp.name) || permName.length() <= bp.name.length() || permName.charAt(bp.name.length()) != '.') continue;
            return bp;
        }
        return null;
    }

    private BasePermission checkPermissionTreeLP(String permName) {
        BasePermission bp;
        if (permName != null && (bp = this.findPermissionTreeLP(permName)) != null) {
            if (bp.uid == UserHandle.getAppId(Binder.getCallingUid())) {
                return bp;
            }
            throw new SecurityException("Calling uid " + Binder.getCallingUid() + " is not allowed to add to permission tree " + bp.name + " owned by uid " + bp.uid);
        }
        throw new SecurityException("No permission tree found for " + permName);
    }

    static boolean compareStrings(CharSequence s1, CharSequence s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        if (s1.getClass() != s2.getClass()) {
            return false;
        }
        return s1.equals(s2);
    }

    static boolean comparePermissionInfos(PermissionInfo pi1, PermissionInfo pi2) {
        if (pi1.icon != pi2.icon) {
            return false;
        }
        if (pi1.logo != pi2.logo) {
            return false;
        }
        if (pi1.protectionLevel != pi2.protectionLevel) {
            return false;
        }
        if (!PackageManagerService.compareStrings(pi1.name, pi2.name)) {
            return false;
        }
        if (!PackageManagerService.compareStrings(pi1.nonLocalizedLabel, pi2.nonLocalizedLabel)) {
            return false;
        }
        return PackageManagerService.compareStrings(pi1.packageName, pi2.packageName);
    }

    boolean addPermissionLocked(PermissionInfo info, boolean async) {
        if (info.labelRes == 0 && info.nonLocalizedLabel == null) {
            throw new SecurityException("Label must be specified in permission");
        }
        BasePermission tree = this.checkPermissionTreeLP(info.name);
        BasePermission bp = this.mSettings.mPermissions.get(info.name);
        boolean added = bp == null;
        boolean changed = true;
        int fixedLevel = PermissionInfo.fixProtectionLevel(info.protectionLevel);
        if (added) {
            bp = new BasePermission(info.name, tree.sourcePackage, 2);
        } else {
            if (bp.type != 2) {
                throw new SecurityException("Not allowed to modify non-dynamic permission " + info.name);
            }
            if (bp.protectionLevel == fixedLevel && bp.perm.owner.equals(tree.perm.owner) && bp.uid == tree.uid && PackageManagerService.comparePermissionInfos(bp.perm.info, info)) {
                changed = false;
            }
        }
        bp.protectionLevel = fixedLevel;
        info = new PermissionInfo(info);
        info.protectionLevel = fixedLevel;
        bp.perm = new PackageParser.Permission(tree.perm.owner, info);
        bp.perm.info.packageName = tree.perm.info.packageName;
        bp.uid = tree.uid;
        if (added) {
            this.mSettings.mPermissions.put(info.name, bp);
        }
        if (changed) {
            if (!async) {
                this.mSettings.writeLPr();
            } else {
                this.scheduleWriteSettingsLocked();
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermission(PermissionInfo info) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.addPermissionLocked(info, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermissionAsync(PermissionInfo info) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.addPermissionLocked(info, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(String name) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.checkPermissionTreeLP(name);
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp != null) {
                if (bp.type != 2) {
                    throw new SecurityException("Not allowed to modify non-dynamic permission " + name);
                }
                this.mSettings.mPermissions.remove(name);
                this.mSettings.writeLPr();
            }
        }
    }

    private static void checkGrantRevokePermissions(PackageParser.Package pkg, BasePermission bp) {
        boolean isDevelopment;
        int index = pkg.requestedPermissions.indexOf(bp.name);
        if (index == -1) {
            throw new SecurityException("Package " + pkg.packageName + " has not requested permission " + bp.name);
        }
        boolean isNormal = (bp.protectionLevel & 0xF) == 0;
        boolean isDangerous = (bp.protectionLevel & 0xF) == 1;
        boolean bl = isDevelopment = (bp.protectionLevel & 0x20) != 0;
        if (!(isNormal || isDangerous || isDevelopment)) {
            throw new SecurityException("Permission " + bp.name + " is not a changeable permission type");
        }
        if ((isNormal || isDangerous) && pkg.requestedPermissionsRequired.get(index).booleanValue()) {
            throw new SecurityException("Can't change " + bp.name + ". It is required by the application");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantPermission(String packageName, String permissionName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_REVOKE_PERMISSIONS", null);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            GrantedPermissions gp;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            BasePermission bp = this.mSettings.mPermissions.get(permissionName);
            if (bp == null) {
                throw new IllegalArgumentException("Unknown permission: " + permissionName);
            }
            PackageManagerService.checkGrantRevokePermissions(pkg, bp);
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (ps == null) {
                return;
            }
            GrantedPermissions grantedPermissions = gp = ps.sharedUser != null ? ps.sharedUser : ps;
            if (gp.grantedPermissions.add(permissionName)) {
                if (ps.haveGids) {
                    gp.gids = PackageManagerService.appendInts(gp.gids, bp.gids);
                }
                this.mSettings.writeLPr();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void revokePermission(String packageName, String permissionName) {
        int changedAppId = -1;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            GrantedPermissions gp;
            BasePermission bp;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            if (pkg.applicationInfo.uid != Binder.getCallingUid()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_REVOKE_PERMISSIONS", null);
            }
            if ((bp = this.mSettings.mPermissions.get(permissionName)) == null) {
                throw new IllegalArgumentException("Unknown permission: " + permissionName);
            }
            PackageManagerService.checkGrantRevokePermissions(pkg, bp);
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (ps == null) {
                return;
            }
            GrantedPermissions grantedPermissions = gp = ps.sharedUser != null ? ps.sharedUser : ps;
            if (gp.grantedPermissions.remove(permissionName)) {
                gp.grantedPermissions.remove(permissionName);
                if (ps.haveGids) {
                    gp.gids = PackageManagerService.removeInts(gp.gids, bp.gids);
                }
                this.mSettings.writeLPr();
                changedAppId = ps.appId;
            }
        }
        if (changedAppId < 0) return;
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am == null) return;
        int callingUserId = UserHandle.getCallingUserId();
        long ident = Binder.clearCallingIdentity();
        try {
            try {
                int[] users;
                for (int user : users = sUserManager.getUserIds()) {
                    am.killUid(UserHandle.getUid(user, changedAppId), "revoke " + permissionName);
                }
                Object var14_16 = null;
            }
            catch (RemoteException e) {
                Object var14_17 = null;
                Binder.restoreCallingIdentity(ident);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            Binder.restoreCallingIdentity(ident);
            throw throwable;
        }
        Binder.restoreCallingIdentity(ident);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtectedBroadcast(String actionName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mProtectedBroadcasts.contains(actionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkSignatures(String pkg1, String pkg2) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p1 = this.mPackages.get(pkg1);
            PackageParser.Package p2 = this.mPackages.get(pkg2);
            if (p1 == null || p1.mExtras == null || p2 == null || p2.mExtras == null) {
                return -4;
            }
            return PackageManagerService.compareSignatures(p1.mSignatures, p2.mSignatures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int checkUidSignatures(int uid1, int uid2) {
        uid1 = UserHandle.getAppId(uid1);
        uid2 = UserHandle.getAppId(uid2);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Signature[] s2;
            Signature[] s1;
            Object obj = this.mSettings.getUserIdLPr(uid1);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                s1 = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                s1 = ((PackageSetting)obj).signatures.mSignatures;
            }
            obj = this.mSettings.getUserIdLPr(uid2);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                s2 = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                s2 = ((PackageSetting)obj).signatures.mSignatures;
            }
            return PackageManagerService.compareSignatures(s1, s2);
        }
    }

    static int compareSignatures(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return s2 == null ? 1 : -1;
        }
        if (s2 == null) {
            return -2;
        }
        HashSet<Signature> set1 = new HashSet<Signature>();
        for (Signature sig : s1) {
            set1.add(sig);
        }
        HashSet<Signature> set2 = new HashSet<Signature>();
        for (Signature sig : s2) {
            set2.add(sig);
        }
        if (set1.equals(set2)) {
            return 0;
        }
        return -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPackagesForUid(int uid) {
        uid = UserHandle.getAppId(uid);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(uid);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                int N = sus.packages.size();
                String[] res = new String[N];
                Iterator<PackageSetting> it = sus.packages.iterator();
                int i = 0;
                while (it.hasNext()) {
                    res[i++] = it.next().name;
                }
                return res;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return new String[]{ps.name};
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameForUid(int uid) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.name + ":" + sus.userId;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.name;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUidForSharedUser(String sharedUserName) {
        if (sharedUserName == null) {
            return -1;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            SharedUserSetting suid = this.mSettings.getSharedUserLPw(sharedUserName, 0, false);
            if (suid == null) {
                return -1;
            }
            return suid.userId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFlagsForUid(int uid) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.pkgFlags;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.pkgFlags;
            }
        }
        return 0;
    }

    @Override
    public ResolveInfo resolveIntent(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, "resolve intent");
        List<ResolveInfo> query = this.queryIntentActivities(intent, resolvedType, flags, userId);
        return this.chooseBestActivity(intent, resolvedType, flags, query, userId);
    }

    @Override
    public void setLastChosenActivity(Intent intent, String resolvedType, int flags, IntentFilter filter, int match, ComponentName activity) {
        int userId = UserHandle.getCallingUserId();
        intent.setComponent(null);
        List<ResolveInfo> query = this.queryIntentActivities(intent, resolvedType, flags, userId);
        this.findPreferredActivity(intent, resolvedType, flags, query, 0, false, true, false, userId);
        this.addPreferredActivityInternal(filter, match, null, activity, false, userId);
    }

    @Override
    public ResolveInfo getLastChosenActivity(Intent intent, String resolvedType, int flags) {
        int userId = UserHandle.getCallingUserId();
        List<ResolveInfo> query = this.queryIntentActivities(intent, resolvedType, flags, userId);
        return this.findPreferredActivity(intent, resolvedType, flags, query, 0, false, false, false, userId);
    }

    private ResolveInfo chooseBestActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int userId) {
        if (query != null) {
            int N = query.size();
            if (N == 1) {
                return query.get(0);
            }
            if (N > 1) {
                boolean debug = (intent.getFlags() & 8) != 0;
                ResolveInfo r0 = query.get(0);
                ResolveInfo r1 = query.get(1);
                if (debug) {
                    Slog.v(TAG, r0.activityInfo.name + "=" + r0.priority + " vs " + r1.activityInfo.name + "=" + r1.priority);
                }
                if (r0.priority != r1.priority || r0.preferredOrder != r1.preferredOrder || r0.isDefault != r1.isDefault) {
                    return query.get(0);
                }
                ResolveInfo ri = this.findPreferredActivity(intent, resolvedType, flags, query, r0.priority, true, false, debug, userId);
                if (ri != null) {
                    return ri;
                }
                if (userId != 0) {
                    ri = new ResolveInfo(this.mResolveInfo);
                    ri.activityInfo = new ActivityInfo(ri.activityInfo);
                    ri.activityInfo.applicationInfo = new ApplicationInfo(ri.activityInfo.applicationInfo);
                    ri.activityInfo.applicationInfo.uid = UserHandle.getUid(userId, UserHandle.getAppId(ri.activityInfo.applicationInfo.uid));
                    return ri;
                }
                return this.mResolveInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResolveInfo findPreferredActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int priority, boolean always, boolean removeMatches, boolean debug, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            List prefs;
            if (intent.getSelector() != null) {
                intent = intent.getSelector();
            }
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.get(userId);
            if (debug) {
                Slog.v(TAG, "Looking for preferred activities...");
            }
            List list = pir != null ? pir.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId) : (prefs = null);
            if (prefs != null && prefs.size() > 0) {
                int match = 0;
                if (debug) {
                    Slog.v(TAG, "Figuring out best match...");
                }
                int N = query.size();
                for (int j = 0; j < N; ++j) {
                    ResolveInfo ri = query.get(j);
                    if (debug) {
                        Slog.v(TAG, "Match for " + ri.activityInfo + ": 0x" + Integer.toHexString(match));
                    }
                    if (ri.match <= match) continue;
                    match = ri.match;
                }
                if (debug) {
                    Slog.v(TAG, "Best match: 0x" + Integer.toHexString(match));
                }
                match &= 0xFFF0000;
                int M = prefs.size();
                block4: for (int i = 0; i < M; ++i) {
                    PreferredActivity pa = (PreferredActivity)prefs.get(i);
                    if (debug) {
                        Slog.v(TAG, "Checking PreferredActivity ds=" + (pa.countDataSchemes() > 0 ? pa.getDataScheme(0) : "<none>") + "\n  component=" + pa.mPref.mComponent);
                        pa.dump(new LogPrinter(2, TAG, 3), "  ");
                    }
                    if (pa.mPref.mMatch != match) {
                        if (!debug) continue;
                        Slog.v(TAG, "Skipping bad match " + Integer.toHexString(pa.mPref.mMatch));
                        continue;
                    }
                    if (always && !pa.mPref.mAlways) {
                        if (!debug) continue;
                        Slog.v(TAG, "Skipping mAlways=false entry");
                        continue;
                    }
                    ActivityInfo ai = this.getActivityInfo(pa.mPref.mComponent, flags | 0x200, userId);
                    if (debug) {
                        Slog.v(TAG, "Found preferred activity:");
                        if (ai != null) {
                            ai.dump(new LogPrinter(2, TAG, 3), "  ");
                        } else {
                            Slog.v(TAG, "  null");
                        }
                    }
                    if (ai == null) {
                        Slog.w(TAG, "Removing dangling preferred activity: " + pa.mPref.mComponent);
                        pir.removeFilter(pa);
                        continue;
                    }
                    for (int j = 0; j < N; ++j) {
                        ResolveInfo ri = query.get(j);
                        if (!ri.activityInfo.applicationInfo.packageName.equals(ai.applicationInfo.packageName) || !ri.activityInfo.name.equals(ai.name)) continue;
                        if (removeMatches) {
                            pir.removeFilter(pa);
                            continue block4;
                        }
                        if (always && !pa.mPref.sameSet(query, priority)) {
                            Slog.i(TAG, "Result set changed, dropping preferred activity for " + intent + " type " + resolvedType);
                            pir.removeFilter(pa);
                            PreferredActivity lastChosen = new PreferredActivity(pa, pa.mPref.mMatch, null, pa.mPref.mComponent, false);
                            pir.addFilter(lastChosen);
                            this.mSettings.writePackageRestrictionsLPr(userId);
                            return null;
                        }
                        if (debug) {
                            Slog.v(TAG, "Returning preferred activity: " + ri.activityInfo.packageName + "/" + ri.activityInfo.name);
                        }
                        this.mSettings.writePackageRestrictionsLPr(userId);
                        return ri;
                    }
                }
            }
            this.mSettings.writePackageRestrictionsLPr(userId);
        }
        if (debug) {
            Slog.v(TAG, "No preferred activity to return");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentActivities(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, "query intent activities");
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getActivityInfo(comp, flags, userId);
            if (ai != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.activityInfo = ai;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mActivities.queryIntent(intent, resolvedType, flags, userId);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mActivities.queryIntentForPackage(intent, resolvedType, flags, pkg.activities, userId);
            }
            return new ArrayList<ResolveInfo>();
        }
    }

    @Override
    public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, String[] specificTypes, Intent intent, String resolvedType, int flags, int userId) {
        int N;
        int i;
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, "query intent activity options");
        String resultsAction = intent.getAction();
        List<ResolveInfo> results = this.queryIntentActivities(intent, resolvedType, flags | 0x40, userId);
        int specificsPos = 0;
        if (specifics != null) {
            for (i = 0; i < specifics.length; ++i) {
                Intent sintent = specifics[i];
                if (sintent == null) continue;
                String action = sintent.getAction();
                if (resultsAction != null && resultsAction.equals(action)) {
                    action = null;
                }
                ResolveInfo ri = null;
                ActivityInfo ai = null;
                ComponentName comp = sintent.getComponent();
                if (comp == null) {
                    ri = this.resolveIntent(sintent, specificTypes != null ? specificTypes[i] : null, flags, userId);
                    if (ri == null) continue;
                    if (ri == this.mResolveInfo) {
                        // empty if block
                    }
                    ai = ri.activityInfo;
                    comp = new ComponentName(ai.applicationInfo.packageName, ai.name);
                } else {
                    ai = this.getActivityInfo(comp, flags, userId);
                    if (ai == null) continue;
                }
                N = results.size();
                for (int j = specificsPos; j < N; ++j) {
                    ResolveInfo sri = results.get(j);
                    if ((!sri.activityInfo.name.equals(comp.getClassName()) || !sri.activityInfo.applicationInfo.packageName.equals(comp.getPackageName())) && (action == null || !sri.filter.matchAction(action))) continue;
                    results.remove(j);
                    if (ri == null) {
                        ri = sri;
                    }
                    --j;
                    --N;
                }
                if (ri == null) {
                    ri = new ResolveInfo();
                    ri.activityInfo = ai;
                }
                results.add(specificsPos, ri);
                ri.specificIndex = i;
                ++specificsPos;
            }
        }
        N = results.size();
        for (i = specificsPos; i < N - 1; ++i) {
            Iterator<String> it;
            ResolveInfo rii = results.get(i);
            if (rii.filter == null || (it = rii.filter.actionsIterator()) == null) continue;
            while (it.hasNext()) {
                String action = it.next();
                if (resultsAction != null && resultsAction.equals(action)) continue;
                for (int j = i + 1; j < N; ++j) {
                    ResolveInfo rij = results.get(j);
                    if (rij.filter == null || !rij.filter.hasAction(action)) continue;
                    results.remove(j);
                    --j;
                    --N;
                }
            }
            if ((flags & 0x40) != 0) continue;
            rii.filter = null;
        }
        if (caller != null) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                ActivityInfo ainfo = results.get((int)i).activityInfo;
                if (!caller.getPackageName().equals(ainfo.applicationInfo.packageName) || !caller.getClassName().equals(ainfo.name)) continue;
                results.remove(i);
                break;
            }
        }
        if ((flags & 0x40) == 0) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                results.get((int)i).filter = null;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentReceivers(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getReceiverInfo(comp, flags, userId);
            if (ai != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.activityInfo = ai;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mReceivers.queryIntent(intent, resolvedType, flags, userId);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mReceivers.queryIntentForPackage(intent, resolvedType, flags, pkg.receivers, userId);
            }
            return null;
        }
    }

    @Override
    public ResolveInfo resolveService(Intent intent, String resolvedType, int flags, int userId) {
        List<ResolveInfo> query = this.queryIntentServices(intent, resolvedType, flags, userId);
        if (!sUserManager.exists(userId)) {
            return null;
        }
        if (query != null && query.size() >= 1) {
            return query.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentServices(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ServiceInfo si = this.getServiceInfo(comp, flags, userId);
            if (si != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.serviceInfo = si;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mServices.queryIntent(intent, resolvedType, flags, userId);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mServices.queryIntentForPackage(intent, resolvedType, flags, pkg.services, userId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentContentProviders(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ProviderInfo pi = this.getProviderInfo(comp, flags, userId);
            if (pi != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.providerInfo = pi;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mProviders.queryIntent(intent, resolvedType, flags, userId);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mProviders.queryIntentForPackage(intent, resolvedType, flags, pkg.providers, userId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInfo> getInstalledPackages(int flags, int userId) {
        boolean listUninstalled = (flags & 0x2000) != 0;
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, "get installed packages");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<PackageInfo> list;
            if (listUninstalled) {
                list = new ArrayList(this.mSettings.mPackages.size());
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    PackageInfo pi = ps.pkg != null ? this.generatePackageInfo(ps.pkg, flags, userId) : this.generatePackageInfoFromSettingsLPw(ps.name, flags, userId);
                    if (pi == null) continue;
                    list.add(pi);
                }
            } else {
                list = new ArrayList<PackageInfo>(this.mPackages.size());
                for (PackageParser.Package p : this.mPackages.values()) {
                    PackageInfo pi = this.generatePackageInfo(p, flags, userId);
                    if (pi == null) continue;
                    list.add(pi);
                }
            }
            return new ParceledListSlice<PackageInfo>(list);
        }
    }

    private void addPackageHoldingPermissions(ArrayList<PackageInfo> list, PackageSetting ps, String[] permissions, boolean[] tmp, int flags, int userId) {
        int numMatch = 0;
        GrantedPermissions gp = ps.sharedUser != null ? ps.sharedUser : ps;
        for (int i = 0; i < permissions.length; ++i) {
            if (gp.grantedPermissions.contains(permissions[i])) {
                tmp[i] = true;
                ++numMatch;
                continue;
            }
            tmp[i] = false;
        }
        if (numMatch == 0) {
            return;
        }
        PackageInfo pi = ps.pkg != null ? this.generatePackageInfo(ps.pkg, flags, userId) : this.generatePackageInfoFromSettingsLPw(ps.name, flags, userId);
        if ((flags & 0x1000) == 0) {
            if (numMatch == permissions.length) {
                pi.requestedPermissions = permissions;
            } else {
                pi.requestedPermissions = new String[numMatch];
                numMatch = 0;
                for (int i = 0; i < permissions.length; ++i) {
                    if (!tmp[i]) continue;
                    pi.requestedPermissions[numMatch] = permissions[i];
                    ++numMatch;
                }
            }
        }
        list.add(pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        boolean listUninstalled = (flags & 0x2000) != 0;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
            boolean[] tmpBools = new boolean[permissions.length];
            if (listUninstalled) {
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    this.addPackageHoldingPermissions(list, ps, permissions, tmpBools, flags, userId);
                }
            } else {
                for (PackageParser.Package pkg : this.mPackages.values()) {
                    PackageSetting ps = (PackageSetting)pkg.mExtras;
                    if (ps == null) continue;
                    this.addPackageHoldingPermissions(list, ps, permissions, tmpBools, flags, userId);
                }
            }
            return new ParceledListSlice<PackageInfo>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ApplicationInfo> getInstalledApplications(int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        boolean listUninstalled = (flags & 0x2000) != 0;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<ApplicationInfo> list;
            if (listUninstalled) {
                list = new ArrayList(this.mSettings.mPackages.size());
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    ApplicationInfo ai = ps.pkg != null ? PackageParser.generateApplicationInfo(ps.pkg, flags, ps.readUserState(userId), userId) : this.generateApplicationInfoFromSettingsLPw(ps.name, flags, userId);
                    if (ai == null) continue;
                    list.add(ai);
                }
            } else {
                list = new ArrayList<ApplicationInfo>(this.mPackages.size());
                for (PackageParser.Package p : this.mPackages.values()) {
                    ApplicationInfo ai;
                    if (p.mExtras == null || (ai = PackageParser.generateApplicationInfo(p, flags, ((PackageSetting)p.mExtras).readUserState(userId), userId)) == null) continue;
                    list.add(ai);
                }
            }
            return new ParceledListSlice<ApplicationInfo>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApplicationInfo> getPersistentApplications(int flags) {
        ArrayList<ApplicationInfo> finalList = new ArrayList<ApplicationInfo>();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Iterator<PackageParser.Package> i = this.mPackages.values().iterator();
            int userId = UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ApplicationInfo ai;
                PackageSetting ps;
                PackageParser.Package p = i.next();
                if (p.applicationInfo == null || (p.applicationInfo.flags & 8) == 0 || this.mSafeMode && !PackageManagerService.isSystemApp(p) || (ps = this.mSettings.mPackages.get(p.packageName)) == null || (ai = PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                finalList.add(ai);
            }
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderInfo resolveContentProvider(String name, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Provider provider = this.mProvidersByAuthority.get(name);
            PackageSetting ps = provider != null ? this.mSettings.mPackages.get(provider.owner.packageName) : null;
            return ps != null && this.mSettings.isEnabledLPr(provider.info, flags, userId) && (!this.mSafeMode || (provider.info.applicationInfo.flags & 1) != 0) ? PackageParser.generateProviderInfo(provider, flags, ps.readUserState(userId), userId) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void querySyncProviders(List<String> outNames, List<ProviderInfo> outInfo) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Iterator<Map.Entry<String, PackageParser.Provider>> i = this.mProvidersByAuthority.entrySet().iterator();
            int userId = UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ProviderInfo info;
                Map.Entry<String, PackageParser.Provider> entry = i.next();
                PackageParser.Provider p = entry.getValue();
                PackageSetting ps = this.mSettings.mPackages.get(p.owner.packageName);
                if (ps == null || !p.syncable || this.mSafeMode && (p.info.applicationInfo.flags & 1) == 0 || (info = PackageParser.generateProviderInfo(p, 0, ps.readUserState(userId), userId)) == null) continue;
                outNames.add(entry.getKey());
                outInfo.add(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        ArrayList<ProviderInfo> finalList = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            int userId;
            Iterator i = this.mProviders.mProviders.values().iterator();
            int n = userId = processName != null ? UserHandle.getUserId(uid) : UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ProviderInfo info;
                PackageParser.Provider p = (PackageParser.Provider)i.next();
                PackageSetting ps = this.mSettings.mPackages.get(p.owner.packageName);
                if (ps == null || p.info.authority == null || processName != null && (!p.info.processName.equals(processName) || !UserHandle.isSameApp(p.info.applicationInfo.uid, uid)) || !this.mSettings.isEnabledLPr(p.info, flags, userId) || this.mSafeMode && (p.info.applicationInfo.flags & 1) == 0) continue;
                if (finalList == null) {
                    finalList = new ArrayList<ProviderInfo>(3);
                }
                if ((info = PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                finalList.add(info);
            }
        }
        if (finalList != null) {
            Collections.sort(finalList, mProviderInitOrderSorter);
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstrumentationInfo getInstrumentationInfo(ComponentName name, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Instrumentation i = this.mInstrumentation.get(name);
            return PackageParser.generateInstrumentationInfo(i, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        ArrayList<InstrumentationInfo> finalList = new ArrayList<InstrumentationInfo>();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (PackageParser.Instrumentation p : this.mInstrumentation.values()) {
                InstrumentationInfo ii;
                if (targetPackage != null && !targetPackage.equals(p.info.targetPackage) || (ii = PackageParser.generateInstrumentationInfo(p, flags)) == null) continue;
                finalList.add(ii);
            }
        }
        return finalList;
    }

    private void scanDirLI(File dir, int flags, int scanMode, long currentTime) {
        String[] files = dir.list();
        if (files == null) {
            Log.d(TAG, "No files in app dir " + dir);
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            PackageParser.Package pkg;
            File file = new File(dir, files[i]);
            if (!PackageManagerService.isPackageFilename(files[i]) || (pkg = this.scanPackageLI(file, flags | 4, scanMode, currentTime, null)) != null || (flags & 1) != 0 || this.mLastScanError != -2) continue;
            Slog.w(TAG, "Cleaning up failed install of " + file);
            file.delete();
        }
    }

    private static File getSettingsProblemFile() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File fname = new File(systemDir, "uiderrors.txt");
        return fname;
    }

    static void reportSettingsProblem(int priority, String msg) {
        try {
            File fname = PackageManagerService.getSettingsProblemFile();
            FileOutputStream out = new FileOutputStream(fname, true);
            FastPrintWriter pw = new FastPrintWriter(out);
            SimpleDateFormat formatter = new SimpleDateFormat();
            String dateString = formatter.format(new Date(System.currentTimeMillis()));
            pw.println(dateString + ": " + msg);
            ((PrintWriter)pw).close();
            FileUtils.setPermissions(fname.toString(), 508, -1, -1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Slog.println(priority, TAG, msg);
    }

    private boolean collectCertificatesLI(PackageParser pp, PackageSetting ps, PackageParser.Package pkg, File srcFile, int parseFlags) {
        if (ps != null && ps.codePath.equals(srcFile) && ps.timeStamp == srcFile.lastModified()) {
            if (ps.signatures.mSignatures != null && ps.signatures.mSignatures.length != 0) {
                pkg.mSignatures = ps.signatures.mSignatures;
                return true;
            }
            Slog.w(TAG, "PackageSetting for " + ps.name + " is missing signatures.  Collecting certs again to recover them.");
        } else {
            Log.i(TAG, srcFile.toString() + " changed; collecting certs");
        }
        if (!pp.collectCertificates(pkg, parseFlags)) {
            this.mLastScanError = pp.getParseError();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageLI(File scanFile, int parseFlags, int scanMode, long currentTime, UserHandle user) {
        PackageSetting updatedPkg;
        HashMap<String, PackageParser.Package> oldName;
        this.mLastScanError = 1;
        String scanPath = scanFile.getPath();
        PackageParser pp = new PackageParser(scanPath);
        pp.setSeparateProcesses(this.mSeparateProcesses);
        pp.setOnlyCoreApps(this.mOnlyCore);
        PackageParser.Package pkg = pp.parsePackage(scanFile, scanPath, this.mMetrics, parseFlags |= this.mDefParseFlags);
        if (pkg == null) {
            this.mLastScanError = pp.getParseError();
            return null;
        }
        PackageSetting ps = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            oldName = this.mSettings.mRenamedPackages.get(pkg.packageName);
            if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName)) {
                ps = this.mSettings.peekPackageLPr((String)((Object)oldName));
            }
            if (ps == null) {
                ps = this.mSettings.peekPackageLPr(pkg.packageName);
            }
            updatedPkg = this.mSettings.getDisabledSystemPkgLPr(ps != null ? ps.name : pkg.packageName);
        }
        if (updatedPkg != null && (parseFlags & 1) != 0 && ps != null && !ps.codePath.equals(scanFile)) {
            if (pkg.mVersionCode < ps.versionCode) {
                Log.i(TAG, "Package " + ps.name + " at " + scanFile + " ignored: updated version " + ps.versionCode + " better than this " + pkg.mVersionCode);
                if (!updatedPkg.codePath.equals(scanFile)) {
                    Slog.w(TAG, "Code path for hidden system pkg : " + ps.name + " changing from " + updatedPkg.codePathString + " to " + scanFile);
                    updatedPkg.codePath = scanFile;
                    updatedPkg.codePathString = scanFile.toString();
                    if (PackageManagerService.locationIsPrivileged(scanFile)) {
                        updatedPkg.pkgFlags |= 0x40000000;
                    }
                }
                updatedPkg.pkg = pkg;
                this.mLastScanError = -5;
                return null;
            }
            hashMap = this.mPackages;
            synchronized (hashMap) {
                this.mPackages.remove(ps.name);
            }
            Slog.w(TAG, "Package " + ps.name + " at " + scanFile + "reverting from " + ps.codePathString + ": new version " + pkg.mVersionCode + " better than installed " + ps.versionCode);
            InstallArgs args = this.createInstallArgs(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, ps.nativeLibraryPathString);
            oldName = this.mInstallLock;
            synchronized (oldName) {
                args.cleanUpResourcesLI();
            }
            oldName = this.mPackages;
            synchronized (oldName) {
                this.mSettings.enableSystemPackageLPw(ps.name);
            }
        }
        if (updatedPkg != null) {
            parseFlags |= 1;
        }
        if (!this.collectCertificatesLI(pp, ps, pkg, scanFile, parseFlags)) {
            Slog.w(TAG, "Failed verifying certificates for package:" + pkg.packageName);
            return null;
        }
        boolean shouldHideSystemApp = false;
        if (updatedPkg == null && ps != null && (parseFlags & 0x40) != 0 && !PackageManagerService.isSystemApp(ps)) {
            if (PackageManagerService.compareSignatures(ps.signatures.mSignatures, pkg.mSignatures) != 0) {
                this.deletePackageLI(pkg.packageName, null, true, null, null, 0, null, false);
                ps = null;
            } else if (pkg.mVersionCode < ps.versionCode) {
                shouldHideSystemApp = true;
            } else {
                Slog.w(TAG, "Package " + ps.name + " at " + scanFile + "reverting from " + ps.codePathString + ": new version " + pkg.mVersionCode + " better than installed " + ps.versionCode);
                InstallArgs args = this.createInstallArgs(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, ps.nativeLibraryPathString);
                Object object = this.mInstallLock;
                synchronized (object) {
                    args.cleanUpResourcesLI();
                }
            }
        }
        if ((parseFlags & 0x40) == 0 && ps != null && !ps.codePath.equals(ps.resourcePath)) {
            parseFlags |= 0x10;
        }
        String codePath = null;
        String resPath = null;
        if ((parseFlags & 0x10) != 0) {
            if (ps != null && ps.resourcePathString != null) {
                resPath = ps.resourcePathString;
            } else {
                Slog.e(TAG, "Resource path not set for pkg : " + pkg.packageName);
            }
        } else {
            resPath = pkg.mScanPath;
        }
        codePath = pkg.mScanPath;
        PackageManagerService.setApplicationInfoPaths(pkg, codePath, resPath);
        PackageParser.Package scannedPkg = this.scanPackageLI(pkg, parseFlags, scanMode | 8, currentTime, user);
        if (shouldHideSystemApp) {
            HashMap<String, PackageParser.Package> hashMap2 = this.mPackages;
            synchronized (hashMap2) {
                this.grantPermissionsLPw(pkg, true);
                this.mSettings.disableSystemPackageLPw(pkg.packageName);
            }
        }
        return scannedPkg;
    }

    private static void setApplicationInfoPaths(PackageParser.Package pkg, String destCodePath, String destResPath) {
        pkg.mPath = pkg.mScanPath = destCodePath;
        pkg.applicationInfo.sourceDir = destCodePath;
        pkg.applicationInfo.publicSourceDir = destResPath;
    }

    private static String fixProcessName(String defProcessName, String processName, int uid) {
        if (processName == null) {
            return defProcessName;
        }
        return processName;
    }

    private boolean verifySignaturesLP(PackageSetting pkgSetting, PackageParser.Package pkg) {
        if (pkgSetting.signatures.mSignatures != null && PackageManagerService.compareSignatures(pkgSetting.signatures.mSignatures, pkg.mSignatures) != 0) {
            Slog.e(TAG, "Package " + pkg.packageName + " signatures do not match the previously installed version; ignoring!");
            this.mLastScanError = -7;
            return false;
        }
        if (pkgSetting.sharedUser != null && pkgSetting.sharedUser.signatures.mSignatures != null && PackageManagerService.compareSignatures(pkgSetting.sharedUser.signatures.mSignatures, pkg.mSignatures) != 0) {
            Slog.e(TAG, "Package " + pkg.packageName + " has no signatures that match those in shared user " + pkgSetting.sharedUser.name + "; ignoring!");
            this.mLastScanError = -8;
            return false;
        }
        return true;
    }

    private static final void enforceSystemOrRoot(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0) {
            throw new SecurityException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBootDexOpt() {
        HashSet<PackageParser.Package> pkgs = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            pkgs = this.mDeferredDexOpt;
            this.mDeferredDexOpt = null;
        }
        if (pkgs != null) {
            int i = 0;
            for (PackageParser.Package pkg : pkgs) {
                if (!this.isFirstBoot()) {
                    ++i;
                    try {
                        ActivityManagerNative.getDefault().showBootMessage(this.mContext.getResources().getString(17040398, i, pkgs.size()), true);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                PackageParser.Package p = pkg;
                Object object = this.mInstallLock;
                synchronized (object) {
                    if (!p.mDidDexOpt) {
                        this.performDexOptLI(p, false, false, true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performDexOpt(String packageName) {
        PackageParser.Package p;
        PackageManagerService.enforceSystemOrRoot("Only the system can request dexopt be performed");
        if (!this.mNoDexOpt) {
            return false;
        }
        Object object = this.mPackages;
        synchronized (object) {
            p = this.mPackages.get(packageName);
            if (p == null || p.mDidDexOpt) {
                return false;
            }
        }
        object = this.mInstallLock;
        synchronized (object) {
            return this.performDexOptLI(p, false, false, true) == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDexOptLibsLI(ArrayList<String> libs, boolean forceDex, boolean defer, HashSet<String> done) {
        for (int i = 0; i < libs.size(); ++i) {
            PackageParser.Package libPkg;
            String libName;
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                libName = libs.get(i);
                SharedLibraryEntry lib = this.mSharedLibraries.get(libName);
                libPkg = lib != null && lib.apk != null ? this.mPackages.get(lib.apk) : null;
            }
            if (libPkg == null || done.contains(libName)) continue;
            this.performDexOptLI(libPkg, forceDex, defer, done);
        }
    }

    private int performDexOptLI(PackageParser.Package pkg, boolean forceDex, boolean defer, HashSet<String> done) {
        boolean performed = false;
        if (done != null) {
            done.add(pkg.packageName);
            if (pkg.usesLibraries != null) {
                this.performDexOptLibsLI(pkg.usesLibraries, forceDex, defer, done);
            }
            if (pkg.usesOptionalLibraries != null) {
                this.performDexOptLibsLI(pkg.usesOptionalLibraries, forceDex, defer, done);
            }
        }
        if ((pkg.applicationInfo.flags & 4) != 0) {
            String path = pkg.mScanPath;
            int ret = 0;
            try {
                if (forceDex || DexFile.isDexOptNeeded(path)) {
                    if (!forceDex && defer) {
                        if (this.mDeferredDexOpt == null) {
                            this.mDeferredDexOpt = new HashSet();
                        }
                        this.mDeferredDexOpt.add(pkg);
                        return 2;
                    }
                    Log.i(TAG, "Running dexopt on: " + pkg.applicationInfo.packageName);
                    int sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
                    ret = this.mInstaller.dexopt(path, sharedGid, !PackageManagerService.isForwardLocked(pkg));
                    pkg.mDidDexOpt = true;
                    performed = true;
                }
            }
            catch (FileNotFoundException e) {
                Slog.w(TAG, "Apk not found for dexopt: " + path);
                ret = -1;
            }
            catch (IOException e) {
                Slog.w(TAG, "IOException reading apk: " + path, e);
                ret = -1;
            }
            catch (StaleDexCacheError e) {
                Slog.w(TAG, "StaleDexCacheError when reading apk: " + path, e);
                ret = -1;
            }
            catch (Exception e) {
                Slog.w(TAG, "Exception when doing dexopt : ", e);
                ret = -1;
            }
            if (ret < 0) {
                return -1;
            }
        }
        return performed ? 1 : 0;
    }

    private int performDexOptLI(PackageParser.Package pkg, boolean forceDex, boolean defer, boolean inclDependencies) {
        HashSet<String> done;
        boolean performed = false;
        if (inclDependencies && (pkg.usesLibraries != null || pkg.usesOptionalLibraries != null)) {
            done = new HashSet<String>();
            done.add(pkg.packageName);
        } else {
            done = null;
        }
        return this.performDexOptLI(pkg, forceDex, defer, done);
    }

    private boolean verifyPackageUpdateLPr(PackageSetting oldPkg, PackageParser.Package newPkg) {
        if ((oldPkg.pkgFlags & 1) == 0) {
            Slog.w(TAG, "Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package not in system partition");
            return false;
        }
        if (this.mPackages.get(oldPkg.name) != null) {
            Slog.w(TAG, "Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package still exists");
            return false;
        }
        return true;
    }

    File getDataPathForUser(int userId) {
        return new File(this.mUserAppDataDir.getAbsolutePath() + File.separator + userId);
    }

    private File getDataPathForPackage(String packageName, int userId) {
        if (userId == 0) {
            return new File(this.mAppDataDir, packageName);
        }
        return new File(this.mUserAppDataDir.getAbsolutePath() + File.separator + userId + File.separator + packageName);
    }

    private int createDataDirsLI(String packageName, int uid, String seinfo) {
        int[] users = sUserManager.getUserIds();
        int res = this.mInstaller.install(packageName, uid, uid, seinfo);
        if (res < 0) {
            return res;
        }
        for (int user : users) {
            if (user == 0 || (res = this.mInstaller.createUserData(packageName, UserHandle.getUid(user, uid), user)) >= 0) continue;
            return res;
        }
        return res;
    }

    private int removeDataDirsLI(String packageName) {
        int[] users = sUserManager.getUserIds();
        int res = 0;
        for (int user : users) {
            int resInner = this.mInstaller.remove(packageName, user);
            if (resInner >= 0) continue;
            res = resInner;
        }
        File nativeLibraryFile = new File(this.mAppLibInstallDir, packageName);
        NativeLibraryHelper.removeNativeBinariesFromDirLI(nativeLibraryFile);
        if (!nativeLibraryFile.delete()) {
            Slog.w(TAG, "Couldn't delete native library directory " + nativeLibraryFile.getPath());
        }
        return res;
    }

    private int addSharedLibraryLPw(SharedLibraryEntry file, int num, PackageParser.Package changingLib) {
        if (file.path != null) {
            this.mTmpSharedLibraries[num] = file.path;
            return num + 1;
        }
        PackageParser.Package p = this.mPackages.get(file.apk);
        if (changingLib != null && changingLib.packageName.equals(file.apk) && (p == null || p.packageName.equals(changingLib.packageName))) {
            p = changingLib;
        }
        if (p != null) {
            String path = p.mPath;
            for (int i = 0; i < num; ++i) {
                if (!this.mTmpSharedLibraries[i].equals(path)) continue;
                return num;
            }
            this.mTmpSharedLibraries[num] = p.mPath;
            return num + 1;
        }
        return num;
    }

    private boolean updateSharedLibrariesLPw(PackageParser.Package pkg, PackageParser.Package changingLib) {
        if (pkg.usesLibraries != null || pkg.usesOptionalLibraries != null) {
            SharedLibraryEntry file;
            int i;
            if (this.mTmpSharedLibraries == null || this.mTmpSharedLibraries.length < this.mSharedLibraries.size()) {
                this.mTmpSharedLibraries = new String[this.mSharedLibraries.size()];
            }
            int num = 0;
            int N = pkg.usesLibraries != null ? pkg.usesLibraries.size() : 0;
            for (i = 0; i < N; ++i) {
                file = this.mSharedLibraries.get(pkg.usesLibraries.get(i));
                if (file == null) {
                    Slog.e(TAG, "Package " + pkg.packageName + " requires unavailable shared library " + pkg.usesLibraries.get(i) + "; failing!");
                    this.mLastScanError = -9;
                    return false;
                }
                num = this.addSharedLibraryLPw(file, num, changingLib);
            }
            N = pkg.usesOptionalLibraries != null ? pkg.usesOptionalLibraries.size() : 0;
            for (i = 0; i < N; ++i) {
                file = this.mSharedLibraries.get(pkg.usesOptionalLibraries.get(i));
                if (file == null) {
                    Slog.w(TAG, "Package " + pkg.packageName + " desires unavailable shared library " + pkg.usesOptionalLibraries.get(i) + "; ignoring!");
                    continue;
                }
                num = this.addSharedLibraryLPw(file, num, changingLib);
            }
            if (num > 0) {
                pkg.usesLibraryFiles = new String[num];
                System.arraycopy(this.mTmpSharedLibraries, 0, pkg.usesLibraryFiles, 0, num);
            } else {
                pkg.usesLibraryFiles = null;
            }
        }
        return true;
    }

    private static boolean hasString(List<String> list, List<String> which) {
        if (list == null) {
            return false;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            for (int j = which.size() - 1; j >= 0; --j) {
                if (!which.get(j).equals(list.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void updateAllSharedLibrariesLPw() {
        for (PackageParser.Package pkg : this.mPackages.values()) {
            this.updateSharedLibrariesLPw(pkg, null);
        }
    }

    private ArrayList<PackageParser.Package> updateAllSharedLibrariesLPw(PackageParser.Package changingPkg) {
        ArrayList<PackageParser.Package> res = null;
        for (PackageParser.Package pkg : this.mPackages.values()) {
            if (!PackageManagerService.hasString(pkg.usesLibraries, changingPkg.libraryNames) && !PackageManagerService.hasString(pkg.usesOptionalLibraries, changingPkg.libraryNames)) continue;
            if (res == null) {
                res = new ArrayList<PackageParser.Package>();
            }
            res.add(pkg);
            this.updateSharedLibrariesLPw(pkg, changingPkg);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageLI(PackageParser.Package pkg, int parseFlags, int scanMode, long currentTime, UserHandle user) {
        String path;
        boolean forceDex;
        long scanFileTime;
        String pkgName;
        PackageSetting pkgSetting;
        block164: {
            HashMap<String, PackageParser.Package> prefix;
            File dataPath;
            File scanFile = new File(pkg.mScanPath);
            if (scanFile == null || pkg.applicationInfo.sourceDir == null || pkg.applicationInfo.publicSourceDir == null) {
                Slog.w(TAG, " Code and resource paths haven't been set correctly");
                this.mLastScanError = -2;
                return null;
            }
            this.mScanningPath = scanFile;
            if ((parseFlags & 1) != 0) {
                pkg.applicationInfo.flags |= 1;
            }
            if ((parseFlags & 0x80) != 0) {
                pkg.applicationInfo.flags |= 0x40000000;
            }
            if (this.mCustomResolverComponentName != null && this.mCustomResolverComponentName.getPackageName().equals(pkg.packageName)) {
                this.setUpCustomResolverActivity(pkg);
            }
            if (pkg.packageName.equals("android")) {
                HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                synchronized (hashMap) {
                    if (this.mAndroidApplication != null) {
                        Slog.w(TAG, "*************************************************");
                        Slog.w(TAG, "Core android package being redefined.  Skipping.");
                        Slog.w(TAG, " file=" + this.mScanningPath);
                        Slog.w(TAG, "*************************************************");
                        this.mLastScanError = -5;
                        return null;
                    }
                    this.mPlatformPackage = pkg;
                    pkg.mVersionCode = this.mSdkVersion;
                    this.mAndroidApplication = pkg.applicationInfo;
                    if (!this.mResolverReplaced) {
                        this.mResolveActivity.applicationInfo = this.mAndroidApplication;
                        this.mResolveActivity.name = ResolverActivity.class.getName();
                        this.mResolveActivity.packageName = this.mAndroidApplication.packageName;
                        this.mResolveActivity.processName = "system:ui";
                        this.mResolveActivity.launchMode = 0;
                        this.mResolveActivity.flags = 32;
                        this.mResolveActivity.theme = 16974606;
                        this.mResolveActivity.exported = true;
                        this.mResolveActivity.enabled = true;
                        this.mResolveInfo.activityInfo = this.mResolveActivity;
                        this.mResolveInfo.priority = 0;
                        this.mResolveInfo.preferredOrder = 0;
                        this.mResolveInfo.match = 0;
                        this.mResolveComponentName = new ComponentName(this.mAndroidApplication.packageName, this.mResolveActivity.name);
                    }
                }
            }
            if (this.mPackages.containsKey(pkg.packageName) || this.mSharedLibraries.containsKey(pkg.packageName)) {
                Slog.w(TAG, "Application package " + pkg.packageName + " already installed.  Skipping duplicate.");
                this.mLastScanError = -5;
                return null;
            }
            File destCodeFile = new File(pkg.applicationInfo.sourceDir);
            File destResourceFile = new File(pkg.applicationInfo.publicSourceDir);
            SharedUserSetting suid = null;
            pkgSetting = null;
            if (!PackageManagerService.isSystemApp(pkg)) {
                pkg.mOriginalPackages = null;
                pkg.mRealPackage = null;
                pkg.mAdoptPermissions = null;
            }
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                String msg;
                int i;
                if ((parseFlags & 0x40) == 0 && !this.updateSharedLibrariesLPw(pkg, null)) {
                    return null;
                }
                if (pkg.mSharedUserId != null && (suid = this.mSettings.getSharedUserLPw(pkg.mSharedUserId, 0, true)) == null) {
                    Slog.w(TAG, "Creating application package " + pkg.packageName + " for shared user failed");
                    this.mLastScanError = -4;
                    return null;
                }
                PackageSetting origPackage = null;
                String realName = null;
                if (pkg.mOriginalPackages != null) {
                    String renamed = this.mSettings.mRenamedPackages.get(pkg.mRealPackage);
                    if (pkg.mOriginalPackages.contains(renamed)) {
                        realName = pkg.mRealPackage;
                        if (!pkg.packageName.equals(renamed)) {
                            pkg.setPackageName(renamed);
                        }
                    } else {
                        for (i = pkg.mOriginalPackages.size() - 1; i >= 0; --i) {
                            origPackage = this.mSettings.peekPackageLPr(pkg.mOriginalPackages.get(i));
                            if (origPackage == null) continue;
                            if (!this.verifyPackageUpdateLPr(origPackage, pkg)) {
                                origPackage = null;
                                continue;
                            }
                            if (origPackage.sharedUser == null || origPackage.sharedUser.name.equals(pkg.mSharedUserId)) break;
                            Slog.w(TAG, "Unable to migrate data from " + origPackage.name + " to " + pkg.packageName + ": old uid " + origPackage.sharedUser.name + " differs from " + pkg.mSharedUserId);
                            origPackage = null;
                        }
                    }
                }
                if (this.mTransferedPackages.contains(pkg.packageName)) {
                    Slog.w(TAG, "Package " + pkg.packageName + " was transferred to another, but its .apk remains");
                }
                if ((pkgSetting = this.mSettings.getPackageLPw(pkg, origPackage, realName, suid, destCodeFile, destResourceFile, pkg.applicationInfo.nativeLibraryDir, pkg.applicationInfo.flags, user, false)) == null) {
                    Slog.w(TAG, "Creating application package " + pkg.packageName + " failed");
                    this.mLastScanError = -4;
                    return null;
                }
                if (pkgSetting.origPackage != null) {
                    pkg.setPackageName(origPackage.name);
                    msg = "New package " + pkgSetting.realName + " renamed to replace old package " + pkgSetting.name;
                    PackageManagerService.reportSettingsProblem(5, msg);
                    this.mTransferedPackages.add(origPackage.name);
                    pkgSetting.origPackage = null;
                }
                if (realName != null) {
                    this.mTransferedPackages.add(pkg.packageName);
                }
                if (this.mSettings.isDisabledSystemPackageLPr(pkg.packageName)) {
                    pkg.applicationInfo.flags |= 0x80;
                }
                if (this.mFoundPolicyFile) {
                    SELinuxMMAC.assignSeinfoValue(pkg);
                }
                pkg.applicationInfo.uid = pkgSetting.appId;
                pkg.mExtras = pkgSetting;
                if (!this.verifySignaturesLP(pkgSetting, pkg)) {
                    if ((parseFlags & 0x40) == 0) {
                        return null;
                    }
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                    if (pkgSetting.sharedUser != null && PackageManagerService.compareSignatures(pkgSetting.sharedUser.signatures.mSignatures, pkg.mSignatures) != 0) {
                        Log.w(TAG, "Signature mismatch for shared user : " + pkgSetting.sharedUser);
                        this.mLastScanError = -104;
                        return null;
                    }
                    msg = "System package " + pkg.packageName + " signature changed; retaining data.";
                    PackageManagerService.reportSettingsProblem(5, msg);
                }
                if ((scanMode & 0x10) != 0) {
                    int N = pkg.providers.size();
                    for (i = 0; i < N; ++i) {
                        PackageParser.Provider p = pkg.providers.get(i);
                        if (p.info.authority == null) continue;
                        String[] names = p.info.authority.split(";");
                        for (int j = 0; j < names.length; ++j) {
                            if (!this.mProvidersByAuthority.containsKey(names[j])) continue;
                            PackageParser.Provider other = this.mProvidersByAuthority.get(names[j]);
                            Slog.w(TAG, "Can't install because provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + ") is already used by " + (other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?"));
                            this.mLastScanError = -13;
                            return null;
                        }
                    }
                }
                if (pkg.mAdoptPermissions != null) {
                    for (int i2 = pkg.mAdoptPermissions.size() - 1; i2 >= 0; --i2) {
                        String origName = pkg.mAdoptPermissions.get(i2);
                        PackageSetting orig = this.mSettings.peekPackageLPr(origName);
                        if (orig == null || !this.verifyPackageUpdateLPr(orig, pkg)) continue;
                        Slog.i(TAG, "Adopting permissions from " + origName + " to " + pkg.packageName);
                        this.mSettings.transferPermissionsLPw(origName, pkg.packageName);
                    }
                }
            }
            pkgName = pkg.packageName;
            scanFileTime = scanFile.lastModified();
            forceDex = (scanMode & 4) != 0;
            pkg.applicationInfo.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.packageName, pkg.applicationInfo.processName, pkg.applicationInfo.uid);
            if (this.mPlatformPackage == pkg) {
                dataPath = new File(Environment.getDataDirectory(), "system");
                pkg.applicationInfo.dataDir = dataPath.getPath();
            } else {
                dataPath = this.getDataPathForPackage(pkg.packageName, 0);
                boolean uidError = false;
                if (dataPath.exists()) {
                    int currentUid = 0;
                    try {
                        StructStat stat = Libcore.os.stat(dataPath.getPath());
                        currentUid = stat.st_uid;
                    }
                    catch (ErrnoException e) {
                        Slog.e(TAG, "Couldn't stat path " + dataPath.getPath(), e);
                    }
                    if (currentUid != pkg.applicationInfo.uid) {
                        int ret;
                        boolean recovered = false;
                        if (currentUid == 0 && (ret = this.mInstaller.fixUid(pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.uid)) >= 0) {
                            recovered = true;
                            String msg = "Package " + pkg.packageName + " unexpectedly changed to uid 0; recovered to " + pkg.applicationInfo.uid;
                            PackageManagerService.reportSettingsProblem(5, msg);
                        }
                        if (!(recovered || (parseFlags & 1) == 0 && (scanMode & 0x100) == 0)) {
                            ret = this.removeDataDirsLI(pkgName);
                            if (ret >= 0) {
                                prefix = (parseFlags & 1) != 0 ? "System package " : "Third party package ";
                                String msg = (String)((Object)prefix) + pkg.packageName + " has changed from uid: " + currentUid + " to " + pkg.applicationInfo.uid + "; old data erased";
                                PackageManagerService.reportSettingsProblem(5, msg);
                                recovered = true;
                                ret = this.createDataDirsLI(pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.seinfo);
                                if (ret == -1) {
                                    msg = prefix + pkg.packageName + " could not have data directory re-created after delete.";
                                    PackageManagerService.reportSettingsProblem(5, msg);
                                    this.mLastScanError = -4;
                                    return null;
                                }
                            }
                            if (!recovered) {
                                this.mHasSystemUidErrors = true;
                            }
                        } else if (!recovered) {
                            this.mLastScanError = -24;
                            return null;
                        }
                        if (!recovered) {
                            pkg.applicationInfo.nativeLibraryDir = pkg.applicationInfo.dataDir = "/mismatched_uid/settings_" + pkg.applicationInfo.uid + "/fs_" + currentUid;
                            String msg = "Package " + pkg.packageName + " has mismatched uid: " + currentUid + " on disk, " + pkg.applicationInfo.uid + " in settings";
                            prefix = this.mPackages;
                            synchronized (prefix) {
                                this.mSettings.mReadMessages.append(msg);
                                this.mSettings.mReadMessages.append('\n');
                                uidError = true;
                                if (!pkgSetting.uidError) {
                                    PackageManagerService.reportSettingsProblem(6, msg);
                                }
                            }
                        }
                    }
                    pkg.applicationInfo.dataDir = dataPath.getPath();
                } else {
                    int ret = this.createDataDirsLI(pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.seinfo);
                    if (ret < 0) {
                        this.mLastScanError = -4;
                        return null;
                    }
                    if (dataPath.exists()) {
                        pkg.applicationInfo.dataDir = dataPath.getPath();
                    } else {
                        Slog.w(TAG, "Unable to create data directory: " + dataPath);
                        pkg.applicationInfo.dataDir = null;
                    }
                }
                if (pkg.applicationInfo.nativeLibraryDir == null && pkg.applicationInfo.dataDir != null) {
                    if (pkgSetting.nativeLibraryPathString == null) {
                        this.setInternalAppNativeLibraryPath(pkg, pkgSetting);
                    } else {
                        pkg.applicationInfo.nativeLibraryDir = pkgSetting.nativeLibraryPathString;
                    }
                }
                pkgSetting.uidError = uidError;
            }
            path = scanFile.getPath();
            if (pkg.applicationInfo.nativeLibraryDir != null) {
                try {
                    File nativeLibraryDir = new File(pkg.applicationInfo.nativeLibraryDir);
                    String dataPathString = dataPath.getCanonicalPath();
                    if (PackageManagerService.isSystemApp(pkg) && !PackageManagerService.isUpdatedSystemApp(pkg)) {
                        if (NativeLibraryHelper.removeNativeBinariesFromDirLI(nativeLibraryDir)) {
                            Log.i(TAG, "removed obsolete native libraries for system package " + path);
                        }
                        break block164;
                    }
                    if (!PackageManagerService.isForwardLocked(pkg) && !PackageManagerService.isExternal(pkg)) {
                        if (nativeLibraryDir.getPath().startsWith(dataPathString)) {
                            this.setInternalAppNativeLibraryPath(pkg, pkgSetting);
                            nativeLibraryDir = new File(pkg.applicationInfo.nativeLibraryDir);
                        }
                        try {
                            if (PackageManagerService.copyNativeLibrariesForInternalApp(scanFile, nativeLibraryDir) != 1) {
                                Slog.e(TAG, "Unable to copy native libraries");
                                this.mLastScanError = -110;
                                return null;
                            }
                        }
                        catch (IOException e) {
                            Slog.e(TAG, "Unable to copy native libraries", e);
                            this.mLastScanError = -110;
                            return null;
                        }
                    }
                    int[] userIds = sUserManager.getUserIds();
                    prefix = this.mInstallLock;
                    synchronized (prefix) {
                        for (int userId : userIds) {
                            if (this.mInstaller.linkNativeLibraryDirectory(pkg.packageName, pkg.applicationInfo.nativeLibraryDir, userId) >= 0) continue;
                            Slog.w(TAG, "Failed linking native library dir (user=" + userId + ")");
                            this.mLastScanError = -110;
                            return null;
                        }
                    }
                }
                catch (IOException ioe) {
                    Slog.e(TAG, "Unable to get canonical file " + ioe.toString());
                }
            }
        }
        pkg.mScanPath = path;
        if ((scanMode & 2) == 0 && this.performDexOptLI(pkg, forceDex, (scanMode & 0x80) != 0, false) == -1) {
            this.mLastScanError = -11;
            return null;
        }
        if (this.mFactoryTest && pkg.requestedPermissions.contains("android.permission.FACTORY_TEST")) {
            pkg.applicationInfo.flags |= 0x10;
        }
        ArrayList<PackageParser.Package> clientLibPkgs = null;
        HashMap<String, PackageParser.Package> dataPathString = this.mPackages;
        synchronized (dataPathString) {
            if ((pkg.applicationInfo.flags & 1) != 0 && pkg.libraryNames != null) {
                for (int i = 0; i < pkg.libraryNames.size(); ++i) {
                    String name = pkg.libraryNames.get(i);
                    boolean allowed = false;
                    if (PackageManagerService.isUpdatedSystemApp(pkg)) {
                        PackageSetting sysPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
                        if (sysPs.pkg != null && sysPs.pkg.libraryNames != null) {
                            for (int j = 0; j < sysPs.pkg.libraryNames.size(); ++j) {
                                if (!name.equals(sysPs.pkg.libraryNames.get(j))) continue;
                                allowed = true;
                                allowed = true;
                                break;
                            }
                        }
                    } else {
                        allowed = true;
                    }
                    if (allowed) {
                        if (!this.mSharedLibraries.containsKey(name)) {
                            this.mSharedLibraries.put(name, new SharedLibraryEntry(null, pkg.packageName));
                            continue;
                        }
                        if (name.equals(pkg.packageName)) continue;
                        Slog.w(TAG, "Package " + pkg.packageName + " library " + name + " already exists; skipping");
                        continue;
                    }
                    Slog.w(TAG, "Package " + pkg.packageName + " declares lib " + name + " that is not declared on system image; skipping");
                }
                if ((scanMode & 0x100) == 0) {
                    clientLibPkgs = this.updateAllSharedLibrariesLPw(pkg);
                }
            }
        }
        if (clientLibPkgs != null && (scanMode & 2) == 0) {
            for (int i = 0; i < clientLibPkgs.size(); ++i) {
                PackageParser.Package clientPkg = clientLibPkgs.get(i);
                if (this.performDexOptLI(clientPkg, forceDex, (scanMode & 0x80) != 0, false) != -1) continue;
                this.mLastScanError = -11;
                return null;
            }
        }
        if ((parseFlags & 2) != 0) {
            if (PackageManagerService.isForwardLocked(pkg) || PackageManagerService.isExternal(pkg)) {
                int[] uidArray = new int[]{pkg.applicationInfo.uid};
                ArrayList<String> pkgList = new ArrayList<String>(1);
                pkgList.add(pkg.applicationInfo.packageName);
                this.sendResourcesChangedBroadcast(false, true, pkgList, uidArray, null);
            }
            this.killApplication(pkg.applicationInfo.packageName, pkg.applicationInfo.uid, "update pkg");
        }
        if (clientLibPkgs != null) {
            for (int i = 0; i < clientLibPkgs.size(); ++i) {
                PackageParser.Package clientPkg = clientLibPkgs.get(i);
                this.killApplication(clientPkg.applicationInfo.packageName, clientPkg.applicationInfo.uid, "update lib");
            }
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            int i;
            if ((scanMode & 1) != 0) {
                this.mAppDirs.put(pkg.mPath, pkg);
            }
            this.mSettings.insertPackageSettingLPw(pkgSetting, pkg);
            this.mPackages.put(pkg.applicationInfo.packageName, pkg);
            Iterator<PackageCleanItem> iter = this.mSettings.mPackagesToBeCleaned.iterator();
            while (iter.hasNext()) {
                PackageCleanItem item = iter.next();
                if (!pkgName.equals(item.packageName)) continue;
                iter.remove();
            }
            if (currentTime != 0L) {
                if (pkgSetting.firstInstallTime == 0L) {
                    pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = currentTime;
                } else if ((scanMode & 0x40) != 0) {
                    pkgSetting.lastUpdateTime = currentTime;
                }
            } else if (pkgSetting.firstInstallTime == 0L) {
                pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = scanFileTime;
            } else if ((parseFlags & 0x40) != 0 && scanFileTime != pkgSetting.timeStamp) {
                pkgSetting.lastUpdateTime = scanFileTime;
            }
            KeySetManager ksm = this.mSettings.mKeySetManager;
            try {
                ksm.addSigningKeySetToPackage(pkg.packageName, pkg.mSigningKeys);
                if (pkg.mKeySetMapping != null) {
                    for (Map.Entry<String, Set<PublicKey>> entry : pkg.mKeySetMapping.entrySet()) {
                        if (entry.getValue() == null) continue;
                        ksm.addDefinedKeySetToPackage(pkg.packageName, entry.getValue(), entry.getKey());
                    }
                }
            }
            catch (NullPointerException e) {
                Slog.e(TAG, "Could not add KeySet to " + pkg.packageName, e);
            }
            catch (IllegalArgumentException e) {
                Slog.e(TAG, "Could not add KeySet to malformed package" + pkg.packageName, e);
            }
            int N = pkg.providers.size();
            StringBuilder r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Provider p = pkg.providers.get(i);
                p.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, p.info.processName, pkg.applicationInfo.uid);
                this.mProviders.addProvider(p);
                p.syncable = p.info.isSyncable;
                if (p.info.authority != null) {
                    String[] names = p.info.authority.split(";");
                    p.info.authority = null;
                    for (int j = 0; j < names.length; ++j) {
                        if (j == 1 && p.syncable) {
                            p = new PackageParser.Provider(p);
                            p.syncable = false;
                        }
                        if (!this.mProvidersByAuthority.containsKey(names[j])) {
                            this.mProvidersByAuthority.put(names[j], p);
                            if (p.info.authority == null) {
                                p.info.authority = names[j];
                                continue;
                            }
                            p.info.authority = p.info.authority + ";" + names[j];
                            continue;
                        }
                        PackageParser.Provider other = this.mProvidersByAuthority.get(names[j]);
                        Slog.w(TAG, "Skipping provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + "): name already used by " + (other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?"));
                    }
                }
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(p.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.services.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Service s = pkg.services.get(i);
                s.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, s.info.processName, pkg.applicationInfo.uid);
                this.mServices.addService(s);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(s.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.receivers.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Activity a = pkg.receivers.get(i);
                a.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, a.info.processName, pkg.applicationInfo.uid);
                this.mReceivers.addActivity(a, "receiver");
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.activities.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Activity a = pkg.activities.get(i);
                a.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, a.info.processName, pkg.applicationInfo.uid);
                this.mActivities.addActivity(a, "activity");
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissionGroups.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.PermissionGroup pg = pkg.permissionGroups.get(i);
                PackageParser.PermissionGroup cur = this.mPermissionGroups.get(pg.info.name);
                if (cur == null) {
                    this.mPermissionGroups.put(pg.info.name, pg);
                    if ((parseFlags & 2) == 0) continue;
                    if (r == null) {
                        r = new StringBuilder(256);
                    } else {
                        r.append(' ');
                    }
                    r.append(pg.info.name);
                    continue;
                }
                Slog.w(TAG, "Permission group " + pg.info.name + " from package " + pg.info.packageName + " ignored: original from " + cur.info.packageName);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append("DUP:");
                r.append(pg.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissions.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Permission p = pkg.permissions.get(i);
                HashMap<String, BasePermission> permissionMap = p.tree ? this.mSettings.mPermissionTrees : this.mSettings.mPermissions;
                p.group = this.mPermissionGroups.get(p.info.group);
                if (p.info.group == null || p.group != null) {
                    BasePermission bp = permissionMap.get(p.info.name);
                    if (bp == null) {
                        bp = new BasePermission(p.info.name, p.info.packageName, 0);
                        permissionMap.put(p.info.name, bp);
                    }
                    if (bp.perm == null) {
                        if (bp.sourcePackage == null || bp.sourcePackage.equals(p.info.packageName)) {
                            BasePermission tree = this.findPermissionTreeLP(p.info.name);
                            if (tree == null || tree.sourcePackage.equals(p.info.packageName)) {
                                bp.packageSetting = pkgSetting;
                                bp.perm = p;
                                bp.uid = pkg.applicationInfo.uid;
                                if ((parseFlags & 2) != 0) {
                                    if (r == null) {
                                        r = new StringBuilder(256);
                                    } else {
                                        r.append(' ');
                                    }
                                    r.append(p.info.name);
                                }
                            } else {
                                Slog.w(TAG, "Permission " + p.info.name + " from package " + p.info.packageName + " ignored: base tree " + tree.name + " is from package " + tree.sourcePackage);
                            }
                        } else {
                            Slog.w(TAG, "Permission " + p.info.name + " from package " + p.info.packageName + " ignored: original from " + bp.sourcePackage);
                        }
                    } else if ((parseFlags & 2) != 0) {
                        if (r == null) {
                            r = new StringBuilder(256);
                        } else {
                            r.append(' ');
                        }
                        r.append("DUP:");
                        r.append(p.info.name);
                    }
                    if (bp.perm != p) continue;
                    bp.protectionLevel = p.info.protectionLevel;
                    continue;
                }
                Slog.w(TAG, "Permission " + p.info.name + " from package " + p.info.packageName + " ignored: no group " + p.group);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.instrumentation.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Instrumentation a = pkg.instrumentation.get(i);
                a.info.packageName = pkg.applicationInfo.packageName;
                a.info.sourceDir = pkg.applicationInfo.sourceDir;
                a.info.publicSourceDir = pkg.applicationInfo.publicSourceDir;
                a.info.dataDir = pkg.applicationInfo.dataDir;
                a.info.nativeLibraryDir = pkg.applicationInfo.nativeLibraryDir;
                this.mInstrumentation.put(a.getComponentName(), a);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(a.info.name);
            }
            if (r != null) {
                // empty if block
            }
            if (pkg.protectedBroadcasts != null) {
                N = pkg.protectedBroadcasts.size();
                for (i = 0; i < N; ++i) {
                    this.mProtectedBroadcasts.add(pkg.protectedBroadcasts.get(i));
                }
            }
            pkgSetting.setTimeStamp(scanFileTime);
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpCustomResolverActivity(PackageParser.Package pkg) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.mResolverReplaced = true;
            this.mResolveActivity.applicationInfo = pkg.applicationInfo;
            this.mResolveActivity.name = this.mCustomResolverComponentName.getClassName();
            this.mResolveActivity.packageName = pkg.applicationInfo.packageName;
            this.mResolveActivity.processName = null;
            this.mResolveActivity.launchMode = 0;
            this.mResolveActivity.flags = 288;
            this.mResolveActivity.theme = 0;
            this.mResolveActivity.exported = true;
            this.mResolveActivity.enabled = true;
            this.mResolveInfo.activityInfo = this.mResolveActivity;
            this.mResolveInfo.priority = 0;
            this.mResolveInfo.preferredOrder = 0;
            this.mResolveInfo.match = 0;
            this.mResolveComponentName = this.mCustomResolverComponentName;
            Slog.i(TAG, "Replacing default ResolverActivity with custom activity: " + this.mResolveComponentName);
        }
    }

    private void setInternalAppNativeLibraryPath(PackageParser.Package pkg, PackageSetting pkgSetting) {
        String nativeLibraryPath;
        String apkLibPath = PackageManagerService.getApkName(pkgSetting.codePathString);
        pkg.applicationInfo.nativeLibraryDir = nativeLibraryPath = new File(this.mAppLibInstallDir, apkLibPath).getPath();
        pkgSetting.nativeLibraryPathString = nativeLibraryPath;
    }

    private static int copyNativeLibrariesForInternalApp(File scanFile, File nativeLibraryDir) throws IOException {
        if (!nativeLibraryDir.isDirectory()) {
            nativeLibraryDir.delete();
            if (!nativeLibraryDir.mkdir()) {
                throw new IOException("Cannot create " + nativeLibraryDir.getPath());
            }
            try {
                Libcore.os.chmod(nativeLibraryDir.getPath(), OsConstants.S_IRWXU | OsConstants.S_IRGRP | OsConstants.S_IXGRP | OsConstants.S_IROTH | OsConstants.S_IXOTH);
            }
            catch (ErrnoException e) {
                throw new IOException("Cannot chmod native library directory " + nativeLibraryDir.getPath(), e);
            }
        } else if (!SELinux.restorecon(nativeLibraryDir)) {
            throw new IOException("Cannot set SELinux context for " + nativeLibraryDir.getPath());
        }
        return NativeLibraryHelper.copyNativeBinariesIfNeededLI(scanFile, nativeLibraryDir);
    }

    private void killApplication(String pkgName, int appId, String reason) {
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                am.killApplicationWithAppId(pkgName, appId, reason);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePackageLI(PackageSetting ps, boolean chatty) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package pkg;
            this.mPackages.remove(ps.name);
            if (ps.codePathString != null) {
                this.mAppDirs.remove(ps.codePathString);
            }
            if ((pkg = ps.pkg) != null) {
                this.cleanPackageDataStructuresLILPw(pkg, chatty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInstalledPackageLI(PackageParser.Package pkg, boolean chatty) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.mPackages.remove(pkg.applicationInfo.packageName);
            if (pkg.mPath != null) {
                this.mAppDirs.remove(pkg.mPath);
            }
            this.cleanPackageDataStructuresLILPw(pkg, chatty);
        }
    }

    void cleanPackageDataStructuresLILPw(PackageParser.Package pkg, boolean chatty) {
        PackageParser.Component a;
        PackageParser.Component p;
        int i;
        int N = pkg.providers.size();
        StringBuilder r = null;
        for (i = 0; i < N; ++i) {
            p = pkg.providers.get(i);
            this.mProviders.removeProvider((PackageParser.Provider)p);
            if (p.info.authority == null) continue;
            String[] names = p.info.authority.split(";");
            for (int j = 0; j < names.length; ++j) {
                if (this.mProvidersByAuthority.get(names[j]) != p) continue;
                this.mProvidersByAuthority.remove(names[j]);
            }
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.services.size();
        r = null;
        for (i = 0; i < N; ++i) {
            PackageParser.Service s = pkg.services.get(i);
            this.mServices.removeService(s);
            if (!chatty) continue;
            if (r == null) {
                r = new StringBuilder(256);
            } else {
                r.append(' ');
            }
            r.append(s.info.name);
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.receivers.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.receivers.get(i);
            this.mReceivers.removeActivity((PackageParser.Activity)a, "receiver");
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.activities.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.activities.get(i);
            this.mActivities.removeActivity((PackageParser.Activity)a, "activity");
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.permissions.size();
        r = null;
        for (i = 0; i < N; ++i) {
            p = pkg.permissions.get(i);
            BasePermission bp = this.mSettings.mPermissions.get(((PackageParser.Permission)p).info.name);
            if (bp == null) {
                bp = this.mSettings.mPermissionTrees.get(((PackageParser.Permission)p).info.name);
            }
            if (bp == null || bp.perm != p) continue;
            bp.perm = null;
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.instrumentation.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.instrumentation.get(i);
            this.mInstrumentation.remove(a.getComponentName());
        }
        if (r != null) {
            // empty if block
        }
        r = null;
        if ((pkg.applicationInfo.flags & 1) != 0 && pkg.libraryNames != null) {
            for (i = 0; i < pkg.libraryNames.size(); ++i) {
                String name = pkg.libraryNames.get(i);
                SharedLibraryEntry cur = this.mSharedLibraries.get(name);
                if (cur == null || cur.apk == null || !cur.apk.equals(pkg.packageName)) continue;
                this.mSharedLibraries.remove(name);
            }
        }
        if (r != null) {
            // empty if block
        }
    }

    private static final boolean isPackageFilename(String name) {
        return name != null && name.endsWith(".apk");
    }

    private static boolean hasPermission(PackageParser.Package pkgInfo, String perm) {
        for (int i = pkgInfo.permissions.size() - 1; i >= 0; --i) {
            if (!pkgInfo.permissions.get((int)i).info.name.equals(perm)) continue;
            return true;
        }
        return false;
    }

    private void updatePermissionsLPw(String changingPkg, PackageParser.Package pkgInfo, int flags) {
        BasePermission bp;
        Iterator<BasePermission> it = this.mSettings.mPermissionTrees.values().iterator();
        while (it.hasNext()) {
            bp = it.next();
            if (bp.packageSetting == null) {
                bp.packageSetting = this.mSettings.mPackages.get(bp.sourcePackage);
            }
            if (bp.packageSetting == null) {
                Slog.w(TAG, "Removing dangling permission tree: " + bp.name + " from package " + bp.sourcePackage);
                it.remove();
                continue;
            }
            if (changingPkg == null || !changingPkg.equals(bp.sourcePackage) || pkgInfo != null && PackageManagerService.hasPermission(pkgInfo, bp.name)) continue;
            Slog.i(TAG, "Removing old permission tree: " + bp.name + " from package " + bp.sourcePackage);
            flags |= 1;
            it.remove();
        }
        it = this.mSettings.mPermissions.values().iterator();
        while (it.hasNext()) {
            BasePermission tree;
            bp = it.next();
            if (bp.type == 2 && bp.packageSetting == null && bp.pendingInfo != null && (tree = this.findPermissionTreeLP(bp.name)) != null && tree.perm != null) {
                bp.packageSetting = tree.packageSetting;
                bp.perm = new PackageParser.Permission(tree.perm.owner, new PermissionInfo(bp.pendingInfo));
                bp.perm.info.packageName = tree.perm.info.packageName;
                bp.perm.info.name = bp.name;
                bp.uid = tree.uid;
            }
            if (bp.packageSetting == null) {
                bp.packageSetting = this.mSettings.mPackages.get(bp.sourcePackage);
            }
            if (bp.packageSetting == null) {
                Slog.w(TAG, "Removing dangling permission: " + bp.name + " from package " + bp.sourcePackage);
                it.remove();
                continue;
            }
            if (changingPkg == null || !changingPkg.equals(bp.sourcePackage) || pkgInfo != null && PackageManagerService.hasPermission(pkgInfo, bp.name)) continue;
            Slog.i(TAG, "Removing old permission: " + bp.name + " from package " + bp.sourcePackage);
            flags |= 1;
            it.remove();
        }
        if ((flags & 1) != 0) {
            for (PackageParser.Package pkg : this.mPackages.values()) {
                if (pkg == pkgInfo) continue;
                this.grantPermissionsLPw(pkg, (flags & 4) != 0);
            }
        }
        if (pkgInfo != null) {
            this.grantPermissionsLPw(pkgInfo, (flags & 2) != 0);
        }
    }

    private void grantPermissionsLPw(PackageParser.Package pkg, boolean replace) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        GrantedPermissions gp = ps.sharedUser != null ? ps.sharedUser : ps;
        HashSet<String> origPermissions = gp.grantedPermissions;
        boolean changedPermission = false;
        if (replace) {
            ps.permissionsFixed = false;
            if (gp == ps) {
                origPermissions = new HashSet<String>(gp.grantedPermissions);
                gp.grantedPermissions.clear();
                gp.gids = this.mGlobalGids;
            }
        }
        if (gp.gids == null) {
            gp.gids = this.mGlobalGids;
        }
        int N = pkg.requestedPermissions.size();
        for (int i = 0; i < N; ++i) {
            boolean allowed;
            String name = pkg.requestedPermissions.get(i);
            boolean required = pkg.requestedPermissionsRequired.get(i);
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null || bp.packageSetting == null) {
                Slog.w(TAG, "Unknown permission " + name + " in package " + pkg.packageName);
                continue;
            }
            String perm = bp.name;
            boolean allowedSig = false;
            int level = bp.protectionLevel & 0xF;
            if (level == 0 || level == 1) {
                allowed = required || origPermissions.contains(perm) || PackageManagerService.isSystemApp(ps) && !PackageManagerService.isUpdatedSystemApp(ps);
            } else if (bp.packageSetting == null) {
                allowed = false;
            } else if (level == 2) {
                allowed = this.grantSignaturePermission(perm, pkg, bp, origPermissions);
                if (allowed) {
                    allowedSig = true;
                }
            } else {
                allowed = false;
            }
            if (allowed) {
                if (!PackageManagerService.isSystemApp(ps) && ps.permissionsFixed && !allowedSig && !gp.grantedPermissions.contains(perm)) {
                    allowed = this.isNewPlatformPermissionForPackage(perm, pkg);
                }
                if (allowed) {
                    if (!gp.grantedPermissions.contains(perm)) {
                        changedPermission = true;
                        gp.grantedPermissions.add(perm);
                        gp.gids = PackageManagerService.appendInts(gp.gids, bp.gids);
                        continue;
                    }
                    if (ps.haveGids) continue;
                    gp.gids = PackageManagerService.appendInts(gp.gids, bp.gids);
                    continue;
                }
                Slog.w(TAG, "Not granting permission " + perm + " to package " + pkg.packageName + " because it was previously installed without");
                continue;
            }
            if (gp.grantedPermissions.remove(perm)) {
                changedPermission = true;
                gp.gids = PackageManagerService.removeInts(gp.gids, bp.gids);
                Slog.i(TAG, "Un-granting permission " + perm + " from package " + pkg.packageName + " (protectionLevel=" + bp.protectionLevel + " flags=0x" + Integer.toHexString(pkg.applicationInfo.flags) + ")");
                continue;
            }
            Slog.w(TAG, "Not granting permission " + perm + " to package " + pkg.packageName + " (protectionLevel=" + bp.protectionLevel + " flags=0x" + Integer.toHexString(pkg.applicationInfo.flags) + ")");
        }
        if ((changedPermission || replace) && !ps.permissionsFixed && !PackageManagerService.isSystemApp(ps) || PackageManagerService.isUpdatedSystemApp(ps)) {
            ps.permissionsFixed = true;
        }
        ps.haveGids = true;
    }

    private boolean isNewPlatformPermissionForPackage(String perm, PackageParser.Package pkg) {
        boolean allowed = false;
        for (PackageParser.NewPermissionInfo npi : PackageParser.NEW_PERMISSIONS) {
            if (!npi.name.equals(perm) || pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) continue;
            allowed = true;
            Log.i(TAG, "Auto-granting " + perm + " to old pkg " + pkg.packageName);
            break;
        }
        return allowed;
    }

    private boolean grantSignaturePermission(String perm, PackageParser.Package pkg, BasePermission bp, HashSet<String> origPermissions) {
        boolean allowed;
        boolean bl = allowed = PackageManagerService.compareSignatures(bp.packageSetting.signatures.mSignatures, pkg.mSignatures) == 0 || PackageManagerService.compareSignatures(this.mPlatformPackage.mSignatures, pkg.mSignatures) == 0;
        if (!allowed && (bp.protectionLevel & 0x10) != 0 && PackageManagerService.isSystemApp(pkg)) {
            if (PackageManagerService.isUpdatedSystemApp(pkg)) {
                GrantedPermissions origGp;
                PackageSetting sysPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
                GrantedPermissions grantedPermissions = origGp = sysPs.sharedUser != null ? sysPs.sharedUser : sysPs;
                if (origGp.grantedPermissions.contains(perm)) {
                    allowed = true;
                } else if (sysPs.pkg != null && sysPs.isPrivileged()) {
                    for (int j = 0; j < sysPs.pkg.requestedPermissions.size(); ++j) {
                        if (!perm.equals(sysPs.pkg.requestedPermissions.get(j))) continue;
                        allowed = true;
                        break;
                    }
                }
            } else {
                allowed = PackageManagerService.isPrivilegedApp(pkg);
            }
        }
        if (!allowed && (bp.protectionLevel & 0x20) != 0) {
            allowed = origPermissions.contains(perm);
        }
        return allowed;
    }

    static final void sendPackageBroadcast(String action, String pkg, Bundle extras, String targetPkg, IIntentReceiver finishedReceiver, int[] userIds) {
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                if (userIds == null) {
                    userIds = am.getRunningUserIds();
                }
                for (int id2 : userIds) {
                    int uid;
                    Intent intent = new Intent(action, pkg != null ? Uri.fromParts("package", pkg, null) : null);
                    if (extras != null) {
                        intent.putExtras(extras);
                    }
                    if (targetPkg != null) {
                        intent.setPackage(targetPkg);
                    }
                    if ((uid = intent.getIntExtra("android.intent.extra.UID", -1)) > 0 && UserHandle.getUserId(uid) != id2) {
                        uid = UserHandle.getUid(id2, UserHandle.getAppId(uid));
                        intent.putExtra("android.intent.extra.UID", uid);
                    }
                    intent.putExtra("android.intent.extra.user_handle", id2);
                    intent.addFlags(0x4000000);
                    am.broadcastIntent(null, intent, null, finishedReceiver, 0, null, null, null, -1, finishedReceiver != null, false, id2);
                }
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    private boolean isExternalMediaAvailable() {
        return this.mMediaMounted || Environment.isExternalStorageEmulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageCleanItem nextPackageToClean(PackageCleanItem lastPackage) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (!this.isExternalMediaAvailable()) {
                return null;
            }
            ArrayList<PackageCleanItem> pkgs = this.mSettings.mPackagesToBeCleaned;
            if (lastPackage != null) {
                pkgs.remove(lastPackage);
            }
            if (pkgs.size() > 0) {
                return pkgs.get(0);
            }
        }
        return null;
    }

    void schedulePackageCleaning(String packageName, int userId, boolean andCode) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, userId, andCode ? 1 : 0, packageName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleaningPackages() {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (!this.isExternalMediaAvailable()) {
                return;
            }
            if (this.mSettings.mPackagesToBeCleaned.isEmpty()) {
                return;
            }
        }
        Intent intent = new Intent("android.content.pm.CLEAN_EXTERNAL_STORAGE");
        intent.setComponent(DEFAULT_CONTAINER_COMPONENT);
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                am.startService(null, intent, null, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void installPackage(Uri packageURI, IPackageInstallObserver observer, int flags) {
        this.installPackage(packageURI, observer, flags, null);
    }

    @Override
    public void installPackage(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName) {
        this.installPackageWithVerification(packageURI, observer, flags, installerPackageName, null, null, null);
    }

    @Override
    public void installPackageWithVerification(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName, Uri verificationURI, ManifestDigest manifestDigest, ContainerEncryptionParams encryptionParams) {
        VerificationParams verificationParams = new VerificationParams(verificationURI, null, null, -1, manifestDigest);
        this.installPackageWithVerificationAndEncryption(packageURI, observer, flags, installerPackageName, verificationParams, encryptionParams);
    }

    @Override
    public void installPackageWithVerificationAndEncryption(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName, VerificationParams verificationParams, ContainerEncryptionParams encryptionParams) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
        int uid = Binder.getCallingUid();
        if (this.isUserRestricted(UserHandle.getUserId(uid), "no_install_apps")) {
            try {
                observer.packageInstalled("", -111);
            }
            catch (RemoteException re) {
                // empty catch block
            }
            return;
        }
        UserHandle user = (flags & 0x40) != 0 ? UserHandle.ALL : new UserHandle(UserHandle.getUserId(uid));
        int filteredFlags = uid == 2000 || uid == 0 ? flags | 0x20 : flags & 0xFFFFFFDF;
        verificationParams.setInstallerUid(uid);
        Message msg = this.mHandler.obtainMessage(5);
        msg.obj = new InstallParams(packageURI, observer, filteredFlags, installerPackageName, verificationParams, encryptionParams, user);
        this.mHandler.sendMessage(msg);
    }

    private void sendPackageAddedForUser(String packageName, PackageSetting pkgSetting, int userId) {
        Bundle extras = new Bundle(1);
        extras.putInt("android.intent.extra.UID", UserHandle.getUid(userId, pkgSetting.appId));
        PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, null, null, new int[]{userId});
        try {
            boolean isSystem;
            IActivityManager am = ActivityManagerNative.getDefault();
            boolean bl = isSystem = PackageManagerService.isSystemApp(pkgSetting) || PackageManagerService.isUpdatedSystemApp(pkgSetting);
            if (isSystem && am.isUserRunning(userId, false)) {
                Intent bcIntent = new Intent("android.intent.action.BOOT_COMPLETED").addFlags(32).setPackage(packageName);
                am.broadcastIntent(null, bcIntent, null, null, 0, null, null, null, -1, false, false, userId);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Unable to bootstrap installed package", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean setApplicationBlockedSettingAsUser(String packageName, boolean blocked, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        int uid = Binder.getCallingUid();
        if (UserHandle.getUserId(uid) != userId) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "setApplicationBlockedSetting for user " + userId);
        }
        if (blocked && this.isPackageDeviceAdmin(packageName, userId)) {
            Slog.w(TAG, "Not blocking package " + packageName + ": has active device admin");
            return false;
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            boolean sendAdded = false;
            boolean sendRemoved = false;
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            // MONITORENTER : hashMap
            PackageSetting pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting == null) {
                boolean bl = false;
                // MONITOREXIT : hashMap
                Object var14_12 = null;
                Binder.restoreCallingIdentity(callingId);
                return bl;
            }
            if (pkgSetting.getBlocked(userId) != blocked) {
                pkgSetting.setBlocked(blocked, userId);
                this.mSettings.writePackageRestrictionsLPr(userId);
                if (blocked) {
                    sendRemoved = true;
                } else {
                    sendAdded = true;
                }
            }
            // MONITOREXIT : hashMap
            if (sendAdded) {
                this.sendPackageAddedForUser(packageName, pkgSetting, userId);
                boolean bl = true;
                Object var14_13 = null;
                Binder.restoreCallingIdentity(callingId);
                return bl;
            }
            if (sendRemoved) {
                this.killApplication(packageName, UserHandle.getUid(userId, pkgSetting.appId), "blocking pkg");
                this.sendPackageBlockedForUser(packageName, pkgSetting, userId);
            }
            Object var14_14 = null;
            Binder.restoreCallingIdentity(callingId);
            return false;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            Binder.restoreCallingIdentity(callingId);
            throw throwable;
        }
    }

    private void sendPackageBlockedForUser(String packageName, PackageSetting pkgSetting, int userId) {
        PackageRemovedInfo info = new PackageRemovedInfo();
        info.removedPackage = packageName;
        info.removedUsers = new int[]{userId};
        info.uid = UserHandle.getUid(userId, pkgSetting.appId);
        info.sendBroadcast(false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getApplicationBlockedSettingAsUser(String packageName, int userId) {
        boolean bl;
        long callingId;
        block8: {
            boolean bl2;
            block7: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
                int uid = Binder.getCallingUid();
                if (UserHandle.getUserId(uid) != userId) {
                    this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "getApplicationBlocked for user " + userId);
                }
                callingId = Binder.clearCallingIdentity();
                try {
                    HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                    synchronized (hashMap) {
                        PackageSetting pkgSetting = this.mSettings.mPackages.get(packageName);
                        if (pkgSetting == null) {
                            bl2 = true;
                            // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl12 : MonitorExitStatement: MONITOREXIT : var7_5
                            Object var11_9 = null;
                            break block7;
                        }
                        bl = pkgSetting.getBlocked(userId);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    Binder.restoreCallingIdentity(callingId);
                    throw throwable;
                }
            }
            Binder.restoreCallingIdentity(callingId);
            return bl2;
        }
        Object var11_10 = null;
        Binder.restoreCallingIdentity(callingId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int installExistingPackageAsUser(String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
        int uid = Binder.getCallingUid();
        if (UserHandle.getUserId(uid) != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "installExistingPackage for user " + userId);
        }
        if (this.isUserRestricted(userId, "no_install_apps")) {
            return -111;
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            boolean sendAdded = false;
            Bundle extras = new Bundle(1);
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            // MONITORENTER : hashMap
            PackageSetting pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting == null) {
                int n = -3;
                // MONITOREXIT : hashMap
                Object var13_10 = null;
                Binder.restoreCallingIdentity(callingId);
                return n;
            }
            if (!pkgSetting.getInstalled(userId)) {
                pkgSetting.setInstalled(true, userId);
                pkgSetting.setBlocked(false, userId);
                this.mSettings.writePackageRestrictionsLPr(userId);
                sendAdded = true;
            }
            // MONITOREXIT : hashMap
            if (sendAdded) {
                this.sendPackageAddedForUser(packageName, pkgSetting, userId);
            }
            Object var13_11 = null;
            Binder.restoreCallingIdentity(callingId);
            return 1;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            Binder.restoreCallingIdentity(callingId);
            throw throwable;
        }
    }

    private boolean isUserRestricted(int userId, String restrictionKey) {
        Bundle restrictions = sUserManager.getUserRestrictions(userId);
        if (restrictions.getBoolean(restrictionKey, false)) {
            Log.w(TAG, "User is restricted: " + restrictionKey);
            return true;
        }
        return false;
    }

    @Override
    public void verifyPendingInstall(int id2, int verificationCode) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can verify applications");
        Message msg = this.mHandler.obtainMessage(15);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCode, Binder.getCallingUid());
        msg.arg1 = id2;
        msg.obj = response;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can extend verification timeouts");
        PackageVerificationState state = this.mPendingVerification.get(id2);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCodeAtTimeout, Binder.getCallingUid());
        if (millisecondsToDelay > 3600000L) {
            millisecondsToDelay = 3600000L;
        }
        if (millisecondsToDelay < 0L) {
            millisecondsToDelay = 0L;
        }
        if (verificationCodeAtTimeout != 1 && verificationCodeAtTimeout != -1) {
            verificationCodeAtTimeout = -1;
        }
        if (state != null && !state.timeoutExtended()) {
            state.extendTimeout();
            Message msg = this.mHandler.obtainMessage(15);
            msg.arg1 = id2;
            msg.obj = response;
            this.mHandler.sendMessageDelayed(msg, millisecondsToDelay);
        }
    }

    private void broadcastPackageVerified(int verificationId, Uri packageUri, int verificationCode, UserHandle user) {
        Intent intent = new Intent("android.intent.action.PACKAGE_VERIFIED");
        intent.setDataAndType(packageUri, PACKAGE_MIME_TYPE);
        intent.addFlags(1);
        intent.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
        intent.putExtra("android.content.pm.extra.VERIFICATION_RESULT", verificationCode);
        this.mContext.sendBroadcastAsUser(intent, user, "android.permission.PACKAGE_VERIFICATION_AGENT");
    }

    private ComponentName matchComponentForVerifier(String packageName, List<ResolveInfo> receivers) {
        ActivityInfo targetReceiver = null;
        int NR = receivers.size();
        for (int i = 0; i < NR; ++i) {
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || !packageName.equals(info.activityInfo.packageName)) continue;
            targetReceiver = info.activityInfo;
            break;
        }
        if (targetReceiver == null) {
            return null;
        }
        return new ComponentName(targetReceiver.packageName, targetReceiver.name);
    }

    private List<ComponentName> matchVerifiers(PackageInfoLite pkgInfo, List<ResolveInfo> receivers, PackageVerificationState verificationState) {
        if (pkgInfo.verifiers.length == 0) {
            return null;
        }
        int N = pkgInfo.verifiers.length;
        ArrayList<ComponentName> sufficientVerifiers = new ArrayList<ComponentName>(N + 1);
        for (int i = 0; i < N; ++i) {
            int verifierUid;
            VerifierInfo verifierInfo = pkgInfo.verifiers[i];
            ComponentName comp = this.matchComponentForVerifier(verifierInfo.packageName, receivers);
            if (comp == null || (verifierUid = this.getUidForVerifier(verifierInfo)) == -1) continue;
            sufficientVerifiers.add(comp);
            verificationState.addSufficientVerifier(verifierUid);
        }
        return sufficientVerifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForVerifier(VerifierInfo verifierInfo) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            byte[] expectedPublicKey;
            PackageParser.Package pkg = this.mPackages.get(verifierInfo.packageName);
            if (pkg == null) {
                return -1;
            }
            if (pkg.mSignatures.length != 1) {
                Slog.i(TAG, "Verifier package " + verifierInfo.packageName + " has more than one signature; ignoring");
                return -1;
            }
            try {
                Signature verifierSig = pkg.mSignatures[0];
                PublicKey publicKey = verifierSig.getPublicKey();
                expectedPublicKey = publicKey.getEncoded();
            }
            catch (CertificateException e) {
                return -1;
            }
            byte[] actualPublicKey = verifierInfo.publicKey.getEncoded();
            if (!Arrays.equals(actualPublicKey, expectedPublicKey)) {
                Slog.i(TAG, "Verifier package " + verifierInfo.packageName + " does not have the expected public key; ignoring");
                return -1;
            }
            return pkg.applicationInfo.uid;
        }
    }

    @Override
    public void finishPackageInstall(int token) {
        PackageManagerService.enforceSystemOrRoot("Only the system is allowed to finish installs");
        Message msg = this.mHandler.obtainMessage(9, token, 0);
        this.mHandler.sendMessage(msg);
    }

    private long getVerificationTimeout() {
        return Settings.Global.getLong(this.mContext.getContentResolver(), "verifier_timeout", 10000L);
    }

    private int getDefaultVerificationResponse() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "verifier_default_response", 1);
    }

    private boolean isVerificationEnabled(int flags) {
        if ((flags & 0x20) != 0) {
            if (ActivityManager.isRunningInTestHarness()) {
                return false;
            }
            if (Settings.Global.getInt(this.mContext.getContentResolver(), "verifier_verify_adb_installs", 1) == 0) {
                return false;
            }
        }
        return Settings.Global.getInt(this.mContext.getContentResolver(), "package_verifier_enable", 1) == 1;
    }

    private int getUnknownSourcesSettings() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "install_non_market_apps", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInstallerPackageName(String targetPackage, String installerPackageName) {
        int uid = Binder.getCallingUid();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting setting;
            Signature[] callerSignature;
            Object obj;
            PackageSetting installerPackageSetting;
            PackageSetting targetPackageSetting = this.mSettings.mPackages.get(targetPackage);
            if (targetPackageSetting == null) {
                throw new IllegalArgumentException("Unknown target package: " + targetPackage);
            }
            if (installerPackageName != null) {
                installerPackageSetting = this.mSettings.mPackages.get(installerPackageName);
                if (installerPackageSetting == null) {
                    throw new IllegalArgumentException("Unknown installer package: " + installerPackageName);
                }
            } else {
                installerPackageSetting = null;
            }
            if ((obj = this.mSettings.getUserIdLPr(uid)) == null) throw new SecurityException("Unknown calling uid " + uid);
            if (obj instanceof SharedUserSetting) {
                callerSignature = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) throw new SecurityException("Bad object " + obj + " for uid " + uid);
                callerSignature = ((PackageSetting)obj).signatures.mSignatures;
            }
            if (installerPackageSetting != null && PackageManagerService.compareSignatures(callerSignature, installerPackageSetting.signatures.mSignatures) != 0) {
                throw new SecurityException("Caller does not have same cert as new installer package " + installerPackageName);
            }
            if (targetPackageSetting.installerPackageName != null && (setting = this.mSettings.mPackages.get(targetPackageSetting.installerPackageName)) != null && PackageManagerService.compareSignatures(callerSignature, setting.signatures.mSignatures) != 0) {
                throw new SecurityException("Caller does not have same cert as old installer package " + targetPackageSetting.installerPackageName);
            }
            targetPackageSetting.installerPackageName = installerPackageName;
            this.scheduleWriteSettingsLocked();
            return;
        }
    }

    private void processPendingInstall(final InstallArgs args, final int currentStatus) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean doRestore;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                PackageInstalledInfo res = new PackageInstalledInfo();
                res.returnCode = currentStatus;
                res.uid = -1;
                res.pkg = null;
                res.removedInfo = new PackageRemovedInfo();
                if (res.returnCode == 1) {
                    args.doPreInstall(res.returnCode);
                    Object object = PackageManagerService.this.mInstallLock;
                    synchronized (object) {
                        PackageManagerService.this.installPackageLI(args, true, res);
                    }
                    args.doPostInstall(res.returnCode, res.uid);
                }
                boolean update = res.removedInfo.removedPackage != null;
                boolean bl = doRestore = !update && res.pkg != null && res.pkg.applicationInfo.backupAgentName != null;
                if (PackageManagerService.this.mNextInstallToken < 0) {
                    PackageManagerService.this.mNextInstallToken = 1;
                }
                int token = PackageManagerService.this.mNextInstallToken++;
                PostInstallData data = new PostInstallData(args, res);
                PackageManagerService.this.mRunningInstalls.put(token, data);
                if (res.returnCode == 1 && doRestore) {
                    IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                    if (bm != null) {
                        try {
                            bm.restoreAtInstall(res.pkg.applicationInfo.packageName, token);
                        }
                        catch (RemoteException e) {
                        }
                        catch (Exception e) {
                            Slog.e(PackageManagerService.TAG, "Exception trying to enqueue restore", e);
                            doRestore = false;
                        }
                    } else {
                        Slog.e(PackageManagerService.TAG, "Backup Manager not found!");
                        doRestore = false;
                    }
                }
                if (!doRestore) {
                    Message msg = PackageManagerService.this.mHandler.obtainMessage(9, token, 0);
                    PackageManagerService.this.mHandler.sendMessage(msg);
                }
            }
        });
    }

    private static long calculateDirectorySize(IMediaContainerService mcs, File[] paths) throws RemoteException {
        long result = 0L;
        for (File path : paths) {
            result += mcs.calculateDirectorySize(path.getAbsolutePath());
        }
        return result;
    }

    private static void clearDirectory(IMediaContainerService mcs, File[] paths) {
        for (File path : paths) {
            try {
                mcs.clearDirectory(path.getAbsolutePath());
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    private static boolean installOnSd(int flags) {
        if ((flags & 0x10) != 0) {
            return false;
        }
        return (flags & 8) != 0;
    }

    private static boolean installForwardLocked(int flags) {
        return (flags & 1) != 0;
    }

    private InstallArgs createInstallArgs(InstallParams params) {
        if (PackageManagerService.installOnSd(params.flags) || params.isForwardLocked()) {
            return new AsecInstallArgs(params);
        }
        return new FileInstallArgs(params);
    }

    private InstallArgs createInstallArgs(int flags, String fullCodePath, String fullResourcePath, String nativeLibraryPath) {
        boolean isInAsec = PackageManagerService.installOnSd(flags) ? true : PackageManagerService.installForwardLocked(flags) && !fullCodePath.startsWith(this.mDrmAppPrivateInstallDir.getAbsolutePath());
        if (isInAsec) {
            return new AsecInstallArgs(fullCodePath, fullResourcePath, nativeLibraryPath, PackageManagerService.installOnSd(flags), PackageManagerService.installForwardLocked(flags));
        }
        return new FileInstallArgs(fullCodePath, fullResourcePath, nativeLibraryPath);
    }

    private InstallArgs createInstallArgs(Uri packageURI, int flags, String pkgName, String dataDir) {
        if (PackageManagerService.installOnSd(flags) || PackageManagerService.installForwardLocked(flags)) {
            String cid = PackageManagerService.getNextCodePath(packageURI.getPath(), pkgName, "/pkg.apk");
            return new AsecInstallArgs(packageURI, cid, PackageManagerService.installOnSd(flags), PackageManagerService.installForwardLocked(flags));
        }
        return new FileInstallArgs(packageURI, pkgName, dataDir);
    }

    private boolean isAsecExternal(String cid) {
        String asecPath = PackageHelper.getSdFilesystem(cid);
        return !asecPath.startsWith(this.mAsecInternalPath);
    }

    static String cidFromCodePath(String fullCodePath) {
        int eidx = fullCodePath.lastIndexOf("/");
        String subStr1 = fullCodePath.substring(0, eidx);
        int sidx = subStr1.lastIndexOf("/");
        return subStr1.substring(sidx + 1, eidx);
    }

    static String getAsecPackageName(String packageCid) {
        int idx = packageCid.lastIndexOf(INSTALL_PACKAGE_SUFFIX);
        if (idx == -1) {
            return packageCid;
        }
        return packageCid.substring(0, idx);
    }

    private static String getNextCodePath(String oldCodePath, String prefix, String suffix) {
        String idxStr = "";
        int idx = 1;
        if (oldCodePath != null) {
            int sidx;
            String subStr = oldCodePath;
            if (subStr.endsWith(suffix)) {
                subStr = subStr.substring(0, subStr.length() - suffix.length());
            }
            if ((sidx = subStr.lastIndexOf(prefix)) != -1 && (subStr = subStr.substring(sidx + prefix.length())) != null) {
                if (subStr.startsWith(INSTALL_PACKAGE_SUFFIX)) {
                    subStr = subStr.substring(INSTALL_PACKAGE_SUFFIX.length());
                }
                try {
                    idx = Integer.parseInt(subStr);
                    idx = idx <= 1 ? ++idx : --idx;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        idxStr = INSTALL_PACKAGE_SUFFIX + Integer.toString(idx);
        return prefix + idxStr;
    }

    private static boolean ignoreCodePath(String fullPathStr) {
        String apkName = PackageManagerService.getApkName(fullPathStr);
        int idx = apkName.lastIndexOf(INSTALL_PACKAGE_SUFFIX);
        if (idx != -1 && idx + 1 < apkName.length()) {
            String version = apkName.substring(idx + 1);
            try {
                Integer.parseInt(version);
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return false;
    }

    static String getApkName(String codePath) {
        if (codePath == null) {
            return null;
        }
        int sidx = codePath.lastIndexOf("/");
        int eidx = codePath.lastIndexOf(".");
        if (eidx == -1) {
            eidx = codePath.length();
        } else if (eidx == 0) {
            Slog.w(TAG, " Invalid code path, " + codePath + " Not a valid apk name");
            return null;
        }
        return codePath.substring(sidx + 1, eidx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installNewPackageLI(PackageParser.Package pkg, int parseFlags, int scanMode, UserHandle user, String installerPackageName, PackageInstalledInfo res) {
        String pkgName = pkg.packageName;
        boolean dataDirExists = this.getDataPathForPackage(pkg.packageName, 0).exists();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mSettings.mRenamedPackages.containsKey(pkgName)) {
                Slog.w(TAG, "Attempt to re-install " + pkgName + " without first uninstalling package running as " + this.mSettings.mRenamedPackages.get(pkgName));
                res.returnCode = -1;
                return;
            }
            if (this.mPackages.containsKey(pkgName) || this.mAppDirs.containsKey(pkg.mPath)) {
                Slog.w(TAG, "Attempt to re-install " + pkgName + " without first uninstalling.");
                res.returnCode = -1;
                return;
            }
        }
        this.mLastScanError = 1;
        PackageParser.Package newPackage = this.scanPackageLI(pkg, parseFlags, scanMode, System.currentTimeMillis(), user);
        if (newPackage == null) {
            Slog.w(TAG, "Package couldn't be installed in " + pkg.mPath);
            res.returnCode = this.mLastScanError;
            if (res.returnCode == 1) {
                res.returnCode = -2;
            }
        } else {
            this.updateSettingsLI(newPackage, installerPackageName, null, null, res);
            if (res.returnCode != 1) {
                this.deletePackageLI(pkgName, UserHandle.ALL, false, null, null, dataDirExists ? 1 : 0, res.removedInfo, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replacePackageLI(PackageParser.Package pkg, int parseFlags, int scanMode, UserHandle user, String installerPackageName, PackageInstalledInfo res) {
        boolean[] perUserInstalled;
        int[] allUsers;
        PackageParser.Package oldPackage;
        String pkgName = pkg.packageName;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            oldPackage = this.mPackages.get(pkgName);
            if (PackageManagerService.compareSignatures(oldPackage.mSignatures, pkg.mSignatures) != 0) {
                Slog.w(TAG, "New package has a different signature: " + pkgName);
                res.returnCode = -104;
                return;
            }
            PackageSetting ps = this.mSettings.mPackages.get(pkgName);
            allUsers = sUserManager.getUserIds();
            perUserInstalled = new boolean[allUsers.length];
            for (int i = 0; i < allUsers.length; ++i) {
                perUserInstalled[i] = ps != null ? ps.getInstalled(allUsers[i]) : false;
            }
        }
        boolean sysPkg = PackageManagerService.isSystemApp(oldPackage);
        if (sysPkg) {
            this.replaceSystemPackageLI(oldPackage, pkg, parseFlags, scanMode, user, allUsers, perUserInstalled, installerPackageName, res);
        } else {
            this.replaceNonSystemPackageLI(oldPackage, pkg, parseFlags, scanMode, user, allUsers, perUserInstalled, installerPackageName, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceNonSystemPackageLI(PackageParser.Package deletedPackage, PackageParser.Package pkg, int parseFlags, int scanMode, UserHandle user, int[] allUsers, boolean[] perUserInstalled, String installerPackageName, PackageInstalledInfo res) {
        PackageParser.Package newPackage = null;
        String pkgName = deletedPackage.packageName;
        boolean deletedPkg = true;
        boolean updatedSettings = false;
        long origUpdateTime = pkg.mExtras != null ? ((PackageSetting)pkg.mExtras).lastUpdateTime : 0L;
        if (!this.deletePackageLI(pkgName, null, true, null, null, 1, res.removedInfo, true)) {
            res.returnCode = -10;
            deletedPkg = false;
        } else {
            this.mLastScanError = 1;
            newPackage = this.scanPackageLI(pkg, parseFlags, scanMode | 0x40, System.currentTimeMillis(), user);
            if (newPackage == null) {
                Slog.w(TAG, "Package couldn't be installed in " + pkg.mPath);
                res.returnCode = this.mLastScanError;
                if (res.returnCode == 1) {
                    res.returnCode = -2;
                }
            } else {
                this.updateSettingsLI(newPackage, installerPackageName, allUsers, perUserInstalled, res);
                updatedSettings = true;
            }
        }
        if (res.returnCode != 1) {
            if (updatedSettings) {
                this.deletePackageLI(pkgName, null, true, allUsers, perUserInstalled, 1, res.removedInfo, true);
            }
            if (deletedPkg) {
                int oldScanMode;
                File restoreFile = new File(deletedPackage.mPath);
                boolean oldOnSd = PackageManagerService.isExternal(deletedPackage);
                int oldParseFlags = this.mDefParseFlags | 2 | (PackageManagerService.isForwardLocked(deletedPackage) ? 16 : 0) | (oldOnSd ? 32 : 0);
                if (this.scanPackageLI(restoreFile, oldParseFlags, oldScanMode = (oldOnSd ? 0 : 1) | 8 | 0x40, origUpdateTime, null) == null) {
                    Slog.e(TAG, "Failed to restore package : " + pkgName + " after failed upgrade");
                    return;
                }
                HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                synchronized (hashMap) {
                    this.updatePermissionsLPw(deletedPackage.packageName, deletedPackage, 1);
                    this.mSettings.writeLPr();
                }
                Slog.i(TAG, "Successfully restored package : " + pkgName + " after failed upgrade");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSystemPackageLI(PackageParser.Package deletedPackage, PackageParser.Package pkg, int parseFlags, int scanMode, UserHandle user, int[] allUsers, boolean[] perUserInstalled, String installerPackageName, PackageInstalledInfo res) {
        PackageSetting oldPkgSetting;
        PackageParser.Package oldPkg;
        PackageParser.Package newPackage = null;
        boolean updatedSettings = false;
        parseFlags |= 3;
        if ((deletedPackage.applicationInfo.flags & 0x40000000) != 0) {
            parseFlags |= 0x80;
        }
        String packageName = deletedPackage.packageName;
        res.returnCode = -10;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            oldPkg = this.mPackages.get(packageName);
            oldPkgSetting = this.mSettings.mPackages.get(packageName);
            if (oldPkg == null || oldPkg.applicationInfo == null || oldPkgSetting == null) {
                Slog.w(TAG, "Couldn't find package:" + packageName + " information");
                return;
            }
        }
        this.killApplication(packageName, oldPkg.applicationInfo.uid, "replace sys pkg");
        res.removedInfo.uid = oldPkg.applicationInfo.uid;
        res.removedInfo.removedPackage = packageName;
        this.removePackageLI(oldPkgSetting, true);
        hashMap = this.mPackages;
        synchronized (hashMap) {
            res.removedInfo.args = !this.mSettings.disableSystemPackageLPw(packageName) && deletedPackage != null ? this.createInstallArgs(0, deletedPackage.applicationInfo.sourceDir, deletedPackage.applicationInfo.publicSourceDir, deletedPackage.applicationInfo.nativeLibraryDir) : null;
        }
        this.mLastScanError = 1;
        pkg.applicationInfo.flags |= 0x80;
        newPackage = this.scanPackageLI(pkg, parseFlags, scanMode, 0L, user);
        if (newPackage == null) {
            Slog.w(TAG, "Package couldn't be installed in " + pkg.mPath);
            res.returnCode = this.mLastScanError;
            if (res.returnCode == 1) {
                res.returnCode = -2;
            }
        } else {
            if (newPackage.mExtras != null) {
                PackageSetting newPkgSetting = (PackageSetting)newPackage.mExtras;
                newPkgSetting.firstInstallTime = oldPkgSetting.firstInstallTime;
                newPkgSetting.lastUpdateTime = System.currentTimeMillis();
            }
            this.updateSettingsLI(newPackage, installerPackageName, allUsers, perUserInstalled, res);
            updatedSettings = true;
        }
        if (res.returnCode != 1) {
            if (newPackage != null) {
                this.removeInstalledPackageLI(newPackage, true);
            }
            this.scanPackageLI(oldPkg, parseFlags, 9, 0L, user);
            hashMap = this.mPackages;
            synchronized (hashMap) {
                if (updatedSettings) {
                    this.mSettings.enableSystemPackageLPw(packageName);
                    this.mSettings.setInstallerPackageName(packageName, oldPkgSetting.installerPackageName);
                }
                this.mSettings.writeLPr();
            }
        }
    }

    private int moveDexFilesLI(PackageParser.Package newPackage) {
        int retCode;
        if ((newPackage.applicationInfo.flags & 4) != 0 && (retCode = this.mInstaller.movedex(newPackage.mScanPath, newPackage.mPath)) != 0) {
            if (this.mNoDexOpt) {
                Slog.i(TAG, "dex file doesn't exist, skipping move: " + newPackage.mPath);
            } else {
                Slog.e(TAG, "Couldn't rename dex file: " + newPackage.mPath);
                return -4;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSettingsLI(PackageParser.Package newPackage, String installerPackageName, int[] allUsers, boolean[] perUserInstalled, PackageInstalledInfo res) {
        String pkgName = newPackage.packageName;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.mSettings.setInstallStatus(pkgName, 0);
            this.mSettings.writeLPr();
        }
        res.returnCode = this.moveDexFilesLI(newPackage);
        if (res.returnCode != 1) {
            return;
        }
        hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting ps;
            this.updatePermissionsLPw(newPackage.packageName, newPackage, 2 | (newPackage.permissions.size() > 0 ? 1 : 0));
            if (PackageManagerService.isSystemApp(newPackage) && (ps = this.mSettings.mPackages.get(pkgName)) != null) {
                if (res.origUsers != null) {
                    for (int userHandle : res.origUsers) {
                        ps.setEnabled(0, userHandle, installerPackageName);
                    }
                }
                if (allUsers != null && perUserInstalled != null) {
                    for (int i = 0; i < allUsers.length; ++i) {
                        ps.setInstalled(perUserInstalled[i], allUsers[i]);
                    }
                }
            }
            res.name = pkgName;
            res.uid = newPackage.applicationInfo.uid;
            res.pkg = newPackage;
            this.mSettings.setInstallStatus(pkgName, 1);
            this.mSettings.setInstallerPackageName(pkgName, installerPackageName);
            res.returnCode = 1;
            this.mSettings.writeLPr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPackageLI(InstallArgs args, boolean newInstall, PackageInstalledInfo res) {
        PackageSetting ps;
        int pFlags = args.flags;
        String installerPackageName = args.installerPackageName;
        File tmpPackageFile = new File(args.getCodePath());
        boolean forwardLocked = (pFlags & 1) != 0;
        boolean onSd = (pFlags & 8) != 0;
        boolean replace = false;
        int scanMode = (onSd ? 0 : 1) | 4 | 8 | (newInstall ? 16 : 0);
        res.returnCode = 1;
        int parseFlags = this.mDefParseFlags | 2 | (forwardLocked ? 16 : 0) | (onSd ? 32 : 0);
        PackageParser pp = new PackageParser(tmpPackageFile.getPath());
        pp.setSeparateProcesses(this.mSeparateProcesses);
        PackageParser.Package pkg = pp.parsePackage(tmpPackageFile, null, this.mMetrics, parseFlags);
        if (pkg == null) {
            res.returnCode = pp.getParseError();
            return;
        }
        String pkgName = res.name = pkg.packageName;
        if ((pkg.applicationInfo.flags & 0x100) != 0 && (pFlags & 4) == 0) {
            res.returnCode = -15;
            return;
        }
        if (!pp.collectCertificates(pkg, parseFlags)) {
            res.returnCode = pp.getParseError();
            return;
        }
        if (args.manifestDigest != null && !args.manifestDigest.equals(pkg.manifestDigest)) {
            res.returnCode = -23;
            return;
        }
        pp = null;
        String oldCodePath = null;
        boolean systemApp = false;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if ((pFlags & 2) != 0) {
                String oldName = this.mSettings.mRenamedPackages.get(pkgName);
                if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName) && this.mPackages.containsKey(oldName)) {
                    pkg.setPackageName(oldName);
                    pkgName = pkg.packageName;
                    replace = true;
                } else if (this.mPackages.containsKey(pkgName)) {
                    replace = true;
                }
            }
            if ((ps = this.mSettings.mPackages.get(pkgName)) != null) {
                oldCodePath = this.mSettings.mPackages.get((Object)pkgName).codePathString;
                if (ps.pkg != null && ps.pkg.applicationInfo != null) {
                    systemApp = (ps.pkg.applicationInfo.flags & 1) != 0;
                }
                res.origUsers = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
            }
        }
        if (systemApp && onSd) {
            Slog.w(TAG, "Cannot install updates to system apps on sdcard");
            res.returnCode = -19;
            return;
        }
        if (!args.doRename(res.returnCode, pkgName, oldCodePath)) {
            res.returnCode = -4;
            return;
        }
        PackageManagerService.setApplicationInfoPaths(pkg, args.getCodePath(), args.getResourcePath());
        pkg.applicationInfo.nativeLibraryDir = args.getNativeLibraryPath();
        if (replace) {
            this.replacePackageLI(pkg, parseFlags, scanMode, args.user, installerPackageName, res);
        } else {
            this.installNewPackageLI(pkg, parseFlags, scanMode, args.user, installerPackageName, res);
        }
        hashMap = this.mPackages;
        synchronized (hashMap) {
            ps = this.mSettings.mPackages.get(pkgName);
            if (ps != null) {
                res.newUsers = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
            }
        }
    }

    private static boolean isForwardLocked(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x20000000) != 0;
    }

    private boolean isForwardLocked(PackageSetting ps) {
        return (ps.pkgFlags & 0x20000000) != 0;
    }

    private static boolean isExternal(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x40000) != 0;
    }

    private static boolean isExternal(PackageSetting ps) {
        return (ps.pkgFlags & 0x40000) != 0;
    }

    private static boolean isSystemApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 1) != 0;
    }

    private static boolean isPrivilegedApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x40000000) != 0;
    }

    private static boolean isSystemApp(ApplicationInfo info) {
        return (info.flags & 1) != 0;
    }

    private static boolean isSystemApp(PackageSetting ps) {
        return (ps.pkgFlags & 1) != 0;
    }

    private static boolean isUpdatedSystemApp(PackageSetting ps) {
        return (ps.pkgFlags & 0x80) != 0;
    }

    private static boolean isUpdatedSystemApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x80) != 0;
    }

    private int packageFlagsToInstallFlags(PackageSetting ps) {
        int installFlags = 0;
        if (PackageManagerService.isExternal(ps)) {
            installFlags |= 8;
        }
        if (this.isForwardLocked(ps)) {
            installFlags |= 1;
        }
        return installFlags;
    }

    private void deleteTempPackageFiles() {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("vmdl") && name.endsWith(".tmp");
            }
        };
        PackageManagerService.deleteTempPackageFilesInDirectory(this.mAppInstallDir, filter);
        PackageManagerService.deleteTempPackageFilesInDirectory(this.mDrmAppPrivateInstallDir, filter);
    }

    private static final void deleteTempPackageFilesInDirectory(File directory, FilenameFilter filter) {
        String[] tmpFilesList = directory.list(filter);
        if (tmpFilesList == null) {
            return;
        }
        for (int i = 0; i < tmpFilesList.length; ++i) {
            File tmpFile = new File(directory, tmpFilesList[i]);
            tmpFile.delete();
        }
    }

    private File createTempPackageFile(File installDir) {
        File tmpPackageFile;
        try {
            tmpPackageFile = File.createTempFile("vmdl", ".tmp", installDir);
        }
        catch (IOException e) {
            Slog.e(TAG, "Couldn't create temp file for downloaded package file.");
            return null;
        }
        try {
            FileUtils.setPermissions(tmpPackageFile.getCanonicalPath(), 384, -1, -1);
            if (!SELinux.restorecon(tmpPackageFile)) {
                return null;
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Trouble getting the canoncical path for a temp file.");
            return null;
        }
        return tmpPackageFile;
    }

    @Override
    public void deletePackageAsUser(final String packageName, final IPackageDeleteObserver observer, final int userId, final int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_PACKAGES", null);
        int uid = Binder.getCallingUid();
        if (UserHandle.getUserId(uid) != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "deletePackage for user " + userId);
        }
        if (this.isUserRestricted(userId, "no_uninstall_apps")) {
            try {
                observer.packageDeleted(packageName, -3);
            }
            catch (RemoteException re) {
                // empty catch block
            }
            return;
        }
        this.mHandler.post(new Runnable(){

            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int returnCode = PackageManagerService.this.deletePackageX(packageName, userId, flags);
                if (observer != null) {
                    try {
                        observer.packageDeleted(packageName, returnCode);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    private boolean isPackageDeviceAdmin(String packageName, int userId) {
        IDevicePolicyManager dpm = IDevicePolicyManager.Stub.asInterface(ServiceManager.getService("device_policy"));
        try {
            if (dpm != null && (dpm.packageHasActiveAdmins(packageName, userId) || dpm.isDeviceOwner(packageName))) {
                return true;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deletePackageX(String packageName, int userId, int flags) {
        boolean res;
        boolean[] perUserInstalled;
        int[] allUsers;
        PackageRemovedInfo info = new PackageRemovedInfo();
        if (this.isPackageDeviceAdmin(packageName, userId)) {
            Slog.w(TAG, "Not removing package " + packageName + ": has active device admin");
            return -2;
        }
        boolean removedForAllUsers = false;
        boolean systemUpdate = false;
        Object object = this.mPackages;
        synchronized (object) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            allUsers = sUserManager.getUserIds();
            perUserInstalled = new boolean[allUsers.length];
            for (int i = 0; i < allUsers.length; ++i) {
                perUserInstalled[i] = ps != null ? ps.getInstalled(allUsers[i]) : false;
            }
        }
        object = this.mInstallLock;
        synchronized (object) {
            res = this.deletePackageLI(packageName, (flags & 2) != 0 ? UserHandle.ALL : new UserHandle(userId), true, allUsers, perUserInstalled, flags | 0x10000, info, true);
            systemUpdate = info.isRemovedPackageSystemUpdate;
            if (res && !systemUpdate && this.mPackages.get(packageName) == null) {
                removedForAllUsers = true;
            }
        }
        if (res) {
            info.sendBroadcast(true, systemUpdate, removedForAllUsers);
            if (systemUpdate) {
                Bundle extras = new Bundle(1);
                extras.putInt("android.intent.extra.UID", info.removedAppId >= 0 ? info.removedAppId : info.uid);
                extras.putBoolean("android.intent.extra.REPLACING", true);
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, null, null, null);
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", packageName, extras, null, null, null);
                PackageManagerService.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, packageName, null, null);
            }
        }
        Runtime.getRuntime().gc();
        if (info.args != null) {
            object = this.mInstallLock;
            synchronized (object) {
                info.args.doPostDeleteLI(true);
            }
        }
        return res ? 1 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePackageDataLI(PackageSetting ps, int[] allUserHandles, boolean[] perUserInstalled, PackageRemovedInfo outInfo, int flags, boolean writeSettings) {
        PackageSetting deletedPs;
        String packageName = ps.name;
        this.removePackageLI(ps, (flags & 0x10000) != 0);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            deletedPs = this.mSettings.mPackages.get(packageName);
            if (outInfo != null) {
                outInfo.removedPackage = packageName;
                outInfo.removedUsers = deletedPs != null ? deletedPs.queryInstalledUsers(sUserManager.getUserIds(), true) : null;
            }
        }
        if ((flags & 1) == 0) {
            this.removeDataDirsLI(packageName);
            this.schedulePackageCleaning(packageName, -1, true);
        }
        hashMap = this.mPackages;
        synchronized (hashMap) {
            if (deletedPs != null) {
                if ((flags & 1) == 0) {
                    if (outInfo != null) {
                        outInfo.removedAppId = this.mSettings.removePackageLPw(packageName);
                    }
                    if (deletedPs != null) {
                        this.updatePermissionsLPw(deletedPs.name, null, 0);
                        if (deletedPs.sharedUser != null) {
                            this.mSettings.updateSharedUserPermsLPw(deletedPs, this.mGlobalGids);
                        }
                    }
                    this.clearPackagePreferredActivitiesLPw(deletedPs.name, -1);
                }
                if (allUserHandles != null && perUserInstalled != null) {
                    for (int i = 0; i < allUserHandles.length; ++i) {
                        ps.setInstalled(perUserInstalled[i], allUserHandles[i]);
                    }
                }
            }
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
        }
        if (outInfo != null) {
            PackageManagerService.removeKeystoreDataIfNeeded(-1, outInfo.removedAppId);
        }
    }

    static boolean locationIsPrivileged(File path) {
        try {
            String privilegedAppDir = new File(Environment.getRootDirectory(), "priv-app").getCanonicalPath();
            return path.getCanonicalPath().startsWith(privilegedAppDir);
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to access code path " + path);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteSystemPackageLI(PackageSetting newPs, int[] allUserHandles, boolean[] perUserInstalled, int flags, PackageRemovedInfo outInfo, boolean writeSettings) {
        PackageParser.Package newPkg;
        boolean applyUserRestrictions = allUserHandles != null && perUserInstalled != null;
        PackageSetting disabledPs = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            disabledPs = this.mSettings.getDisabledSystemPkgLPr(newPs.name);
        }
        if (disabledPs == null) {
            Slog.w(TAG, "Attempt to delete unknown system package " + newPs.name);
            return false;
        }
        outInfo.isRemovedPackageSystemUpdate = true;
        flags = disabledPs.versionCode < newPs.versionCode ? (flags &= 0xFFFFFFFE) : (flags |= 1);
        boolean ret = this.deleteInstalledPackageLI(newPs, true, flags, allUserHandles, perUserInstalled, outInfo, writeSettings);
        if (!ret) {
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap2 = this.mPackages;
        synchronized (hashMap2) {
            this.mSettings.enableSystemPackageLPw(newPs.name);
            NativeLibraryHelper.removeNativeBinariesLI(newPs.nativeLibraryPathString);
        }
        int parseFlags = 5;
        if (PackageManagerService.locationIsPrivileged(disabledPs.codePath)) {
            parseFlags |= 0x80;
        }
        if ((newPkg = this.scanPackageLI(disabledPs.codePath, parseFlags, 33, 0L, null)) == null) {
            Slog.w(TAG, "Failed to restore system package:" + newPs.name + " with error:" + this.mLastScanError);
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap3 = this.mPackages;
        synchronized (hashMap3) {
            this.updatePermissionsLPw(newPkg.packageName, newPkg, 3);
            if (applyUserRestrictions) {
                PackageSetting ps = this.mSettings.mPackages.get(newPkg.packageName);
                for (int i = 0; i < allUserHandles.length; ++i) {
                    ps.setInstalled(perUserInstalled[i], allUserHandles[i]);
                }
                this.mSettings.writeAllUsersPackageRestrictionsLPr();
            }
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
        }
        return true;
    }

    private boolean deleteInstalledPackageLI(PackageSetting ps, boolean deleteCodeAndResources, int flags, int[] allUserHandles, boolean[] perUserInstalled, PackageRemovedInfo outInfo, boolean writeSettings) {
        if (outInfo != null) {
            outInfo.uid = ps.appId;
        }
        this.removePackageDataLI(ps, allUserHandles, perUserInstalled, outInfo, flags, writeSettings);
        if (deleteCodeAndResources && outInfo != null) {
            outInfo.args = this.createInstallArgs(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, ps.nativeLibraryPathString);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePackageLI(String packageName, UserHandle user, boolean deleteCodeAndResources, int[] allUserHandles, boolean[] perUserInstalled, int flags, PackageRemovedInfo outInfo, boolean writeSettings) {
        PackageSetting ps;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        boolean dataOnly = false;
        int removeUser = -1;
        int appId = -1;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                return false;
            }
            if (!(PackageManagerService.isSystemApp(ps) && (flags & 4) == 0 || user == null || user.getIdentifier() == -1)) {
                ps.setUserState(user.getIdentifier(), 0, false, true, true, false, null, null, null);
                if (!PackageManagerService.isSystemApp(ps)) {
                    if (ps.isAnyInstalled(sUserManager.getUserIds())) {
                        removeUser = user.getIdentifier();
                        appId = ps.appId;
                        this.mSettings.writePackageRestrictionsLPr(removeUser);
                    } else {
                        ps.setInstalled(true, user.getIdentifier());
                    }
                } else {
                    removeUser = user.getIdentifier();
                    appId = ps.appId;
                    this.mSettings.writePackageRestrictionsLPr(removeUser);
                }
            }
        }
        if (removeUser >= 0) {
            if (outInfo != null) {
                outInfo.removedPackage = packageName;
                outInfo.removedAppId = appId;
                outInfo.removedUsers = new int[]{removeUser};
            }
            this.mInstaller.clearUserData(packageName, removeUser);
            PackageManagerService.removeKeystoreDataIfNeeded(removeUser, appId);
            this.schedulePackageCleaning(packageName, removeUser, false);
            return true;
        }
        if (dataOnly) {
            this.removePackageDataLI(ps, null, null, outInfo, flags, writeSettings);
            return true;
        }
        boolean ret = false;
        this.mSettings.mKeySetManager.removeAppKeySetData(packageName);
        if (PackageManagerService.isSystemApp(ps)) {
            ret = this.deleteSystemPackageLI(ps, allUserHandles, perUserInstalled, flags, outInfo, writeSettings);
        } else {
            this.killApplication(packageName, ps.appId, "uninstall pkg");
            ret = this.deleteInstalledPackageLI(ps, deleteCodeAndResources, flags, allUserHandles, perUserInstalled, outInfo, writeSettings);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExternalStorageDataSync(String packageName, int userId, boolean allData) {
        boolean mounted;
        if (Environment.isExternalStorageEmulated()) {
            mounted = true;
        } else {
            String status = Environment.getExternalStorageState();
            boolean bl = mounted = status.equals("mounted") || status.equals("mounted_ro");
        }
        if (!mounted) {
            return;
        }
        Intent containerIntent = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
        int[] users = userId == -1 ? sUserManager.getUserIds() : new int[]{userId};
        ClearStorageConnection conn = new ClearStorageConnection();
        if (this.mContext.bindServiceAsUser(containerIntent, conn, 1, UserHandle.OWNER)) {
            try {
                for (int curUser : users) {
                    long timeout = SystemClock.uptimeMillis() + 5000L;
                    ClearStorageConnection clearStorageConnection = conn;
                    synchronized (clearStorageConnection) {
                        long now = SystemClock.uptimeMillis();
                        while (conn.mContainerService == null && now < timeout) {
                            try {
                                conn.wait(timeout - now);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    if (conn.mContainerService == null) {
                        Object var20_17 = null;
                        this.mContext.unbindService(conn);
                        return;
                    }
                    Environment.UserEnvironment userEnv = new Environment.UserEnvironment(curUser);
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppCacheDirs(packageName));
                    if (!allData) continue;
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppDataDirs(packageName));
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppMediaDirs(packageName));
                }
            }
            catch (Throwable throwable) {
                Object var20_19 = null;
                this.mContext.unbindService(conn);
                throw throwable;
            }
            Object var20_18 = null;
            this.mContext.unbindService(conn);
            {
            }
        }
    }

    @Override
    public void clearApplicationUserData(final String packageName, final IPackageDataObserver observer, final int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_USER_DATA", null);
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, "clear application data");
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DeviceStorageMonitorService dsm;
                boolean succeeded;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    succeeded = PackageManagerService.this.clearApplicationUserDataLI(packageName, userId);
                }
                PackageManagerService.this.clearExternalStorageDataSync(packageName, userId, true);
                if (succeeded && (dsm = (DeviceStorageMonitorService)ServiceManager.getService("devicestoragemonitor")) != null) {
                    dsm.updateMemory();
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, succeeded);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearApplicationUserDataLI(String packageName, int userId) {
        int appId;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        boolean dataOnly = false;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p == null) {
                dataOnly = true;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null || ps.pkg == null) {
                    Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                    return false;
                }
                p = ps.pkg;
            }
            if (!dataOnly) {
                if (p == null) {
                    Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                    return false;
                }
                ApplicationInfo applicationInfo = p.applicationInfo;
                if (applicationInfo == null) {
                    Slog.w(TAG, "Package " + packageName + " has no applicationInfo.");
                    return false;
                }
            }
            appId = p != null && p.applicationInfo != null ? p.applicationInfo.uid : -1;
        }
        int retCode = this.mInstaller.clearUserData(packageName, userId);
        if (retCode < 0) {
            Slog.w(TAG, "Couldn't remove cache files for package: " + packageName);
            return false;
        }
        PackageManagerService.removeKeystoreDataIfNeeded(userId, appId);
        return true;
    }

    private static void removeKeystoreDataIfNeeded(int userId, int appId) {
        if (appId < 0) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance();
        if (keyStore != null) {
            if (userId == -1) {
                for (int individual : sUserManager.getUserIds()) {
                    keyStore.clearUid(UserHandle.getUid(individual, appId));
                }
            } else {
                keyStore.clearUid(UserHandle.getUid(userId, appId));
            }
        } else {
            Slog.w(TAG, "Could not contact keystore to clear entries for app id " + appId);
        }
    }

    @Override
    public void deleteApplicationCacheFiles(final String packageName, final IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_CACHE_FILES", null);
        final int userId = UserHandle.getCallingUserId();
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean succeded;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    succeded = PackageManagerService.this.deleteApplicationCacheFilesLI(packageName, userId);
                }
                PackageManagerService.this.clearExternalStorageDataSync(packageName, userId, false);
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, succeded);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteApplicationCacheFilesLI(String packageName, int userId) {
        PackageParser.Package p;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            p = this.mPackages.get(packageName);
        }
        if (p == null) {
            Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
            return false;
        }
        ApplicationInfo applicationInfo = p.applicationInfo;
        if (applicationInfo == null) {
            Slog.w(TAG, "Package " + packageName + " has no applicationInfo.");
            return false;
        }
        int retCode = this.mInstaller.deleteCacheFiles(packageName, userId);
        if (retCode < 0) {
            Slog.w(TAG, "Couldn't remove cache files for package: " + packageName + " u" + userId);
            return false;
        }
        return true;
    }

    @Override
    public void getPackageSizeInfo(String packageName, int userHandle, IPackageStatsObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GET_PACKAGE_SIZE", null);
        PackageStats stats = new PackageStats(packageName, userHandle);
        Message msg = this.mHandler.obtainMessage(5);
        msg.obj = new MeasureParams(stats, observer);
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPackageSizeInfoLI(String packageName, int userHandle, PackageStats pStats) {
        int res;
        PackageParser.Package p;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to get size of null packageName.");
            return false;
        }
        boolean dataOnly = false;
        String libDirPath = null;
        String asecPath = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String secureContainerId;
            p = this.mPackages.get(packageName);
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (p == null) {
                dataOnly = true;
                if (ps == null || ps.pkg == null) {
                    Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                    return false;
                }
                p = ps.pkg;
            }
            if (ps != null) {
                libDirPath = ps.nativeLibraryPathString;
            }
            if (p != null && (PackageManagerService.isExternal(p) || PackageManagerService.isForwardLocked(p)) && (secureContainerId = PackageManagerService.cidFromCodePath(p.applicationInfo.sourceDir)) != null) {
                asecPath = PackageHelper.getSdFilesystem(secureContainerId);
            }
        }
        String publicSrcDir = null;
        if (!dataOnly) {
            ApplicationInfo applicationInfo = p.applicationInfo;
            if (applicationInfo == null) {
                Slog.w(TAG, "Package " + packageName + " has no applicationInfo.");
                return false;
            }
            if (PackageManagerService.isForwardLocked(p)) {
                publicSrcDir = applicationInfo.publicSourceDir;
            }
        }
        if ((res = this.mInstaller.getSizeInfo(packageName, userHandle, p.mPath, libDirPath, publicSrcDir, asecPath, pStats)) < 0) {
            return false;
        }
        if (!PackageManagerService.isExternal(p)) {
            pStats.codeSize += pStats.externalCodeSize;
            pStats.externalCodeSize = 0L;
        }
        return true;
    }

    @Override
    public void addPackageToPreferred(String packageName) {
        Slog.w(TAG, "addPackageToPreferred: this is now a no-op");
    }

    @Override
    public void removePackageFromPreferred(String packageName) {
        Slog.w(TAG, "removePackageFromPreferred: this is now a no-op");
    }

    @Override
    public List<PackageInfo> getPreferredPackages(int flags) {
        return new ArrayList<PackageInfo>();
    }

    private int getUidTargetSdkVersionLockedLPr(int uid) {
        Object obj = this.mSettings.getUserIdLPr(uid);
        if (obj instanceof SharedUserSetting) {
            SharedUserSetting sus = (SharedUserSetting)obj;
            int vers = 10000;
            for (PackageSetting ps : sus.packages) {
                int v;
                if (ps.pkg == null || (v = ps.pkg.applicationInfo.targetSdkVersion) >= vers) continue;
                vers = v;
            }
            return vers;
        }
        if (obj instanceof PackageSetting) {
            PackageSetting ps = (PackageSetting)obj;
            if (ps.pkg != null) {
                return ps.pkg.applicationInfo.targetSdkVersion;
            }
        }
        return 10000;
    }

    @Override
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        this.addPreferredActivityInternal(filter, match, set, activity, true, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPreferredActivityInternal(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, boolean always, int userId) {
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, "add preferred activity");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                    Slog.w(TAG, "Ignoring addPreferredActivity() from uid " + callingUid);
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            Slog.i(TAG, "Adding preferred activity " + activity + " for user " + userId + " :");
            filter.dump(new LogPrinter(4, TAG), "  ");
            this.mSettings.editPreferredActivitiesLPw(userId).addFilter(new PreferredActivity(filter, match, set, activity, always));
            this.mSettings.writePackageRestrictionsLPr(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        if (filter.countActions() != 1) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have only 1 action.");
        }
        if (filter.countDataAuthorities() != 0 || filter.countDataPaths() != 0 || filter.countDataSchemes() != 0 || filter.countDataTypes() != 0) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have no data authorities, paths, schemes or types.");
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(Binder.getCallingUid()) < 8) {
                    Slog.w(TAG, "Ignoring replacePreferredActivity() from uid " + Binder.getCallingUid());
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            int callingUserId = UserHandle.getCallingUserId();
            ArrayList<PreferredActivity> removed = null;
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.get(callingUserId);
            if (pir != null) {
                Iterator it = pir.filterIterator();
                String action = filter.getAction(0);
                String category = filter.getCategory(0);
                while (it.hasNext()) {
                    PreferredActivity pa = (PreferredActivity)it.next();
                    if (!pa.getAction(0).equals(action) || !pa.getCategory(0).equals(category)) continue;
                    if (removed == null) {
                        removed = new ArrayList<PreferredActivity>();
                    }
                    removed.add(pa);
                }
                if (removed != null) {
                    for (int i = 0; i < removed.size(); ++i) {
                        PreferredActivity pa = (PreferredActivity)removed.get(i);
                        pir.removeFilter(pa);
                    }
                }
            }
            this.addPreferredActivityInternal(filter, match, set, activity, true, callingUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePreferredActivities(String packageName) {
        int uid = Binder.getCallingUid();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            int user;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if ((pkg == null || pkg.applicationInfo.uid != uid) && this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(Binder.getCallingUid()) < 8) {
                    Slog.w(TAG, "Ignoring clearPackagePreferredActivities() from uid " + Binder.getCallingUid());
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            if (this.clearPackagePreferredActivitiesLPw(packageName, user = UserHandle.getCallingUserId())) {
                this.mSettings.writePackageRestrictionsLPr(user);
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    boolean clearPackagePreferredActivitiesLPw(String packageName, int userId) {
        ArrayList<PreferredActivity> removed = null;
        boolean changed = false;
        for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
            int thisUserId = this.mSettings.mPreferredActivities.keyAt(i);
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
            if (userId != -1 && userId != thisUserId) continue;
            Iterator it = pir.filterIterator();
            while (it.hasNext()) {
                PreferredActivity pa = (PreferredActivity)it.next();
                if (packageName != null && (!pa.mPref.mComponent.getPackageName().equals(packageName) || !pa.mPref.mAlways)) continue;
                if (removed == null) {
                    removed = new ArrayList<PreferredActivity>();
                }
                removed.add(pa);
            }
            if (removed == null) continue;
            for (int j = 0; j < removed.size(); ++j) {
                PreferredActivity pa = (PreferredActivity)removed.get(j);
                pir.removeFilter(pa);
            }
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetPreferredActivities(int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            int user = UserHandle.getCallingUserId();
            this.clearPackagePreferredActivitiesLPw(null, user);
            this.mSettings.readDefaultPreferredAppsLPw(this, user);
            this.mSettings.writePackageRestrictionsLPr(user);
            this.scheduleWriteSettingsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        int num = 0;
        int userId = UserHandle.getCallingUserId();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.get(userId);
            if (pir != null) {
                Iterator it = pir.filterIterator();
                while (it.hasNext()) {
                    PreferredActivity pa = (PreferredActivity)it.next();
                    if (packageName != null && (!pa.mPref.mComponent.getPackageName().equals(packageName) || !pa.mPref.mAlways)) continue;
                    if (outFilters != null) {
                        outFilters.add(new IntentFilter(pa));
                    }
                    if (outActivities == null) continue;
                    outActivities.add(pa.mPref.mComponent);
                }
            }
        }
        return num;
    }

    @Override
    public ComponentName getHomeActivities(List<ResolveInfo> allHomeCandidates) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        int callingUserId = UserHandle.getCallingUserId();
        List<ResolveInfo> list = this.queryIntentActivities(intent, null, 128, callingUserId);
        ResolveInfo preferred = this.findPreferredActivity(intent, null, 0, list, 0, true, false, false, callingUserId);
        allHomeCandidates.clear();
        if (list != null) {
            for (ResolveInfo ri : list) {
                allHomeCandidates.add(ri);
            }
        }
        return preferred == null || preferred.activityInfo == null ? null : new ComponentName(preferred.activityInfo.packageName, preferred.activityInfo.name);
    }

    @Override
    public void setApplicationEnabledSetting(String appPackageName, int newState, int flags, int userId, String callingPackage) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        if (callingPackage == null) {
            callingPackage = Integer.toString(Binder.getCallingUid());
        }
        this.setEnabledSetting(appPackageName, null, newState, flags, userId, callingPackage);
    }

    @Override
    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.setEnabledSetting(componentName.getPackageName(), componentName.getClassName(), newState, flags, userId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabledSetting(String packageName, String className, int newState, int flags, int userId, String callingPackage) {
        ArrayList<String> components;
        PackageSetting pkgSetting;
        if (newState != 0 && newState != 1 && newState != 2 && newState != 3 && newState != 4) {
            throw new IllegalArgumentException("Invalid new component state: " + newState);
        }
        int uid = Binder.getCallingUid();
        int permission2 = this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        this.enforceCrossUserPermission(uid, userId, false, "set enabled");
        boolean allowedByPermission = permission2 == 0;
        boolean sendNow = false;
        boolean isApp = className == null;
        String componentName = isApp ? packageName : className;
        int packageUid = -1;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            boolean newPackage;
            pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting == null) {
                if (className == null) {
                    throw new IllegalArgumentException("Unknown package: " + packageName);
                }
                throw new IllegalArgumentException("Unknown component: " + packageName + "/" + className);
            }
            if (!allowedByPermission && !UserHandle.isSameApp(uid, pkgSetting.appId)) {
                throw new SecurityException("Permission Denial: attempt to change component state from pid=" + Binder.getCallingPid() + ", uid=" + uid + ", package uid=" + pkgSetting.appId);
            }
            if (className == null) {
                if (pkgSetting.getEnabled(userId) == newState) {
                    return;
                }
                if (newState == 0 || newState == 1) {
                    callingPackage = null;
                }
                pkgSetting.setEnabled(newState, userId, callingPackage);
            } else {
                PackageParser.Package pkg = pkgSetting.pkg;
                if (pkg == null || !pkg.hasComponentClassName(className)) {
                    if (pkg.applicationInfo.targetSdkVersion >= 16) {
                        throw new IllegalArgumentException("Component class " + className + " does not exist in " + packageName);
                    }
                    Slog.w(TAG, "Failed setComponentEnabledSetting: component class " + className + " does not exist in " + packageName);
                }
                switch (newState) {
                    case 1: {
                        if (pkgSetting.enableComponentLPw(className, userId)) break;
                        return;
                    }
                    case 2: {
                        if (pkgSetting.disableComponentLPw(className, userId)) break;
                        return;
                    }
                    case 0: {
                        if (pkgSetting.restoreComponentLPw(className, userId)) break;
                        return;
                    }
                    default: {
                        Slog.e(TAG, "Invalid new component state: " + newState);
                        return;
                    }
                }
            }
            this.mSettings.writePackageRestrictionsLPr(userId);
            components = this.mPendingBroadcasts.get(userId, packageName);
            boolean bl = newPackage = components == null;
            if (newPackage) {
                components = new ArrayList();
            }
            if (!components.contains(componentName)) {
                components.add(componentName);
            }
            if ((flags & 1) == 0) {
                sendNow = true;
                this.mPendingBroadcasts.remove(userId, packageName);
            } else {
                if (newPackage) {
                    this.mPendingBroadcasts.put(userId, packageName, components);
                }
                if (!this.mHandler.hasMessages(1)) {
                    this.mHandler.sendEmptyMessageDelayed(1, 10000L);
                }
            }
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            if (sendNow) {
                packageUid = UserHandle.getUid(userId, pkgSetting.appId);
                this.sendPackageChangedBroadcast(packageName, (flags & 1) != 0, components, packageUid);
            }
            Object var20_21 = null;
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            Binder.restoreCallingIdentity(callingId);
            throw throwable;
        }
        Binder.restoreCallingIdentity(callingId);
    }

    private void sendPackageChangedBroadcast(String packageName, boolean killFlag, ArrayList<String> componentNames, int packageUid) {
        Bundle extras = new Bundle(4);
        extras.putString("android.intent.extra.changed_component_name", componentNames.get(0));
        String[] nameList = new String[componentNames.size()];
        componentNames.toArray(nameList);
        extras.putStringArray("android.intent.extra.changed_component_name_list", nameList);
        extras.putBoolean("android.intent.extra.DONT_KILL_APP", killFlag);
        extras.putInt("android.intent.extra.UID", packageUid);
        PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_CHANGED", packageName, extras, null, null, new int[]{UserHandle.getUserId(packageUid)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageStoppedState(String packageName, boolean stopped, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        int uid = Binder.getCallingUid();
        int permission2 = this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        boolean allowedByPermission = permission2 == 0;
        this.enforceCrossUserPermission(uid, userId, true, "stop package");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mSettings.setPackageStoppedStateLPw(packageName, stopped, allowedByPermission, uid, userId)) {
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInstallerPackageName(String packageName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getInstallerPackageNameLPr(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getApplicationEnabledSetting(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return 2;
        }
        int uid = Binder.getCallingUid();
        this.enforceCrossUserPermission(uid, userId, false, "get enabled");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getApplicationEnabledSettingLPr(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getComponentEnabledSetting(ComponentName componentName, int userId) {
        if (!sUserManager.exists(userId)) {
            return 2;
        }
        int uid = Binder.getCallingUid();
        this.enforceCrossUserPermission(uid, userId, false, "get component enabled");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getComponentEnabledSettingLPr(componentName, userId);
        }
    }

    @Override
    public void enterSafeMode() {
        PackageManagerService.enforceSystemOrRoot("Only the system can request entering safe mode");
        if (!this.mSystemReady) {
            this.mSafeMode = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemReady() {
        this.mSystemReady = true;
        boolean compatibilityModeEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "compatibility_mode", 1) == 1;
        PackageParser.setCompatibilityModeEnabled(compatibilityModeEnabled);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<PreferredActivity> removed = new ArrayList<PreferredActivity>();
            for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
                PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
                removed.clear();
                for (PreferredActivity pa : pir.filterSet()) {
                    if (this.mActivities.mActivities.get(pa.mPref.mComponent) != null) continue;
                    removed.add(pa);
                }
                if (removed.size() <= 0) continue;
                for (int j = 0; j < removed.size(); ++j) {
                    PreferredActivity pa;
                    pa = (PreferredActivity)removed.get(i);
                    Slog.w(TAG, "Removing dangling preferred activity: " + pa.mPref.mComponent);
                    pir.removeFilter(pa);
                }
                this.mSettings.writePackageRestrictionsLPr(this.mSettings.mPreferredActivities.keyAt(i));
            }
        }
        sUserManager.systemReady();
    }

    @Override
    public boolean isSafeMode() {
        return this.mSafeMode;
    }

    @Override
    public boolean hasSystemUidErrors() {
        return this.mHasSystemUidErrors;
    }

    static String arrayToString(int[] array2) {
        StringBuffer buf = new StringBuffer(128);
        buf.append('[');
        if (array2 != null) {
            for (int i = 0; i < array2.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(array2[i]);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ActivityManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        DumpState dumpState = new DumpState();
        boolean fullPreferred = false;
        String packageName = null;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) continue;
            if ("-h".equals(opt)) {
                pw.println("Package manager dump options:");
                pw.println("  [-h] [-f] [cmd] ...");
                pw.println("    -f: print details of intent filters");
                pw.println("    -h: print this help");
                pw.println("  cmd may be one of:");
                pw.println("    l[ibraries]: list known shared libraries");
                pw.println("    f[ibraries]: list device features");
                pw.println("    r[esolvers]: dump intent resolvers");
                pw.println("    perm[issions]: dump permissions");
                pw.println("    pref[erred]: print preferred package settings");
                pw.println("    preferred-xml [--full]: print preferred package settings as xml");
                pw.println("    prov[iders]: dump content providers");
                pw.println("    p[ackages]: dump installed packages");
                pw.println("    s[hared-users]: dump shared user IDs");
                pw.println("    m[essages]: print collected runtime messages");
                pw.println("    v[erifiers]: print package verifier info");
                pw.println("    <package.name>: info about given package");
                pw.println("    k[eysets]: print known keysets");
                return;
            }
            if ("-f".equals(opt)) {
                dumpState.setOptionEnabled(1);
                continue;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("android".equals(cmd) || cmd.contains(".")) {
                packageName = cmd;
                dumpState.setOptionEnabled(1);
            } else if ("l".equals(cmd) || "libraries".equals(cmd)) {
                dumpState.setDump(1);
            } else if ("f".equals(cmd) || "features".equals(cmd)) {
                dumpState.setDump(2);
            } else if ("r".equals(cmd) || "resolvers".equals(cmd)) {
                dumpState.setDump(4);
            } else if ("perm".equals(cmd) || "permissions".equals(cmd)) {
                dumpState.setDump(8);
            } else if ("pref".equals(cmd) || "preferred".equals(cmd)) {
                dumpState.setDump(512);
            } else if ("preferred-xml".equals(cmd)) {
                dumpState.setDump(1024);
                if (opti < args.length && "--full".equals(args[opti])) {
                    fullPreferred = true;
                    ++opti;
                }
            } else if ("p".equals(cmd) || "packages".equals(cmd)) {
                dumpState.setDump(16);
            } else if ("s".equals(cmd) || "shared-users".equals(cmd)) {
                dumpState.setDump(32);
            } else if ("prov".equals(cmd) || "providers".equals(cmd)) {
                dumpState.setDump(128);
            } else if ("m".equals(cmd) || "messages".equals(cmd)) {
                dumpState.setDump(64);
            } else if ("v".equals(cmd) || "verifiers".equals(cmd)) {
                dumpState.setDump(256);
            } else if ("k".equals(cmd) || "keysets".equals(cmd)) {
                dumpState.setDump(2048);
            }
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            block82: {
                if (dumpState.isDumping(256) && packageName == null) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println();
                    }
                    pw.println("Verifiers:");
                    pw.print("  Required: ");
                    pw.print(this.mRequiredVerifierPackage);
                    pw.print(" (uid=");
                    pw.print(this.getPackageUid(this.mRequiredVerifierPackage, 0));
                    pw.println(")");
                }
                if (dumpState.isDumping(1) && packageName == null) {
                    boolean printedHeader = false;
                    for (String string2 : this.mSharedLibraries.keySet()) {
                        SharedLibraryEntry ent = this.mSharedLibraries.get(string2);
                        if (!printedHeader) {
                            if (dumpState.onTitlePrinted()) {
                                pw.println();
                            }
                            pw.println("Libraries:");
                            printedHeader = true;
                        }
                        pw.print("  ");
                        pw.print(string2);
                        pw.print(" -> ");
                        if (ent.path != null) {
                            pw.print("(jar) ");
                            pw.print(ent.path);
                        } else {
                            pw.print("(apk) ");
                            pw.print(ent.apk);
                        }
                        pw.println();
                    }
                }
                if (dumpState.isDumping(2) && packageName == null) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println();
                    }
                    pw.println("Features:");
                    for (String name : this.mAvailableFeatures.keySet()) {
                        pw.print("  ");
                        pw.println(name);
                    }
                }
                if (dumpState.isDumping(4)) {
                    if (this.mActivities.dump(pw, dumpState.getTitlePrinted() ? "\nActivity Resolver Table:" : "Activity Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                        dumpState.setTitlePrinted(true);
                    }
                    if (this.mReceivers.dump(pw, dumpState.getTitlePrinted() ? "\nReceiver Resolver Table:" : "Receiver Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                        dumpState.setTitlePrinted(true);
                    }
                    if (this.mServices.dump(pw, dumpState.getTitlePrinted() ? "\nService Resolver Table:" : "Service Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                        dumpState.setTitlePrinted(true);
                    }
                    if (this.mProviders.dump(pw, dumpState.getTitlePrinted() ? "\nProvider Resolver Table:" : "Provider Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                        dumpState.setTitlePrinted(true);
                    }
                }
                if (dumpState.isDumping(512)) {
                    for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
                        PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
                        int n = this.mSettings.mPreferredActivities.keyAt(i);
                        if (!pir.dump(pw, dumpState.getTitlePrinted() ? "\nPreferred Activities User " + n + ":" : "Preferred Activities User " + n + ":", "  ", packageName, true)) continue;
                        dumpState.setTitlePrinted(true);
                    }
                }
                if (dumpState.isDumping(1024)) {
                    pw.flush();
                    FileOutputStream fout = new FileOutputStream(fd);
                    BufferedOutputStream str = new BufferedOutputStream(fout);
                    FastXmlSerializer fastXmlSerializer = new FastXmlSerializer();
                    try {
                        fastXmlSerializer.setOutput(str, "utf-8");
                        fastXmlSerializer.startDocument(null, true);
                        fastXmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                        this.mSettings.writePreferredActivitiesLPr(fastXmlSerializer, 0, fullPreferred);
                        fastXmlSerializer.endDocument();
                        fastXmlSerializer.flush();
                    }
                    catch (IllegalArgumentException e) {
                        pw.println("Failed writing: " + e);
                    }
                    catch (IllegalStateException e) {
                        pw.println("Failed writing: " + e);
                    }
                    catch (IOException e) {
                        pw.println("Failed writing: " + e);
                    }
                }
                if (dumpState.isDumping(8)) {
                    this.mSettings.dumpPermissionsLPr(pw, packageName, dumpState);
                }
                if (dumpState.isDumping(128)) {
                    boolean printedSomething = false;
                    for (PackageParser.Provider provider : this.mProviders.mProviders.values()) {
                        if (packageName != null && !packageName.equals(provider.info.packageName)) continue;
                        if (!printedSomething) {
                            if (dumpState.onTitlePrinted()) {
                                pw.println();
                            }
                            pw.println("Registered ContentProviders:");
                            printedSomething = true;
                        }
                        pw.print("  ");
                        provider.printComponentShortName(pw);
                        pw.println(":");
                        pw.print("    ");
                        pw.println(provider.toString());
                    }
                    printedSomething = false;
                    for (Map.Entry entry : this.mProvidersByAuthority.entrySet()) {
                        PackageParser.Provider p = (PackageParser.Provider)entry.getValue();
                        if (packageName != null && !packageName.equals(p.info.packageName)) continue;
                        if (!printedSomething) {
                            if (dumpState.onTitlePrinted()) {
                                pw.println();
                            }
                            pw.println("ContentProvider Authorities:");
                            printedSomething = true;
                        }
                        pw.print("  [");
                        pw.print((String)entry.getKey());
                        pw.println("]:");
                        pw.print("    ");
                        pw.println(p.toString());
                        if (p.info == null || p.info.applicationInfo == null) continue;
                        String appInfo = p.info.applicationInfo.toString();
                        pw.print("      applicationInfo=");
                        pw.println(appInfo);
                    }
                }
                if (dumpState.isDumping(2048)) {
                    this.mSettings.mKeySetManager.dump(pw, packageName, dumpState);
                }
                if (dumpState.isDumping(16)) {
                    this.mSettings.dumpPackagesLPr(pw, packageName, dumpState);
                }
                if (dumpState.isDumping(32)) {
                    this.mSettings.dumpSharedUsersLPr(pw, packageName, dumpState);
                }
                if (!dumpState.isDumping(64) || packageName != null) return;
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.mSettings.dumpReadMessagesLPr(pw, dumpState);
                pw.println();
                pw.println("Package warning messages:");
                File fname = PackageManagerService.getSettingsProblemFile();
                FileInputStream in = null;
                in = new FileInputStream(fname);
                int n = in.available();
                byte[] data = new byte[n];
                in.read(data);
                pw.print(new String(data));
                Object var15_27 = null;
                if (in == null) return;
                try {
                    in.close();
                }
                catch (IOException e) {}
                {
                    break block82;
                    catch (FileNotFoundException fileNotFoundException) {
                        Object var15_28 = null;
                        if (in == null) return;
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                        break block82;
                    }
                    catch (IOException iOException) {
                        Object var15_29 = null;
                        if (in == null) return;
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var15_30 = null;
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return;
        }
    }

    private String getEncryptKey() {
        try {
            String sdEncKey = SystemKeyStore.getInstance().retrieveKeyHexString(SD_ENCRYPTION_KEYSTORE_NAME);
            if (sdEncKey == null && (sdEncKey = SystemKeyStore.getInstance().generateNewKeyHexString(128, SD_ENCRYPTION_ALGORITHM, SD_ENCRYPTION_KEYSTORE_NAME)) == null) {
                Slog.e(TAG, "Failed to create encryption keys");
                return null;
            }
            return sdEncKey;
        }
        catch (NoSuchAlgorithmException nsae) {
            Slog.e(TAG, "Failed to create encryption keys with exception: " + nsae);
            return null;
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Failed to retrieve encryption keys with exception: " + ioe);
            return null;
        }
    }

    static String getTempContainerId() {
        int tmpIdx = 1;
        String[] list = PackageHelper.getSecureContainerList();
        if (list != null) {
            for (String name : list) {
                if (name == null || !name.startsWith(mTempContainerPrefix)) continue;
                String subStr = name.substring(mTempContainerPrefix.length());
                try {
                    int cid = Integer.parseInt(subStr);
                    if (cid < tmpIdx) continue;
                    tmpIdx = cid + 1;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return mTempContainerPrefix + tmpIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExternalMediaStatus(final boolean mediaStatus, final boolean reportStatus) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("Media status can only be updated by the system");
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Log.i(TAG, "Updating external media status from " + (this.mMediaMounted ? "mounted" : "unmounted") + " to " + (mediaStatus ? "mounted" : "unmounted"));
            if (mediaStatus == this.mMediaMounted) {
                Message msg = this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, -1);
                this.mHandler.sendMessage(msg);
                return;
            }
            this.mMediaMounted = mediaStatus;
        }
        this.mHandler.post(new Runnable(){

            public void run() {
                PackageManagerService.this.updateExternalMediaStatusInner(mediaStatus, reportStatus, true);
            }
        });
    }

    public void scanAvailableAsecs() {
        this.updateExternalMediaStatusInner(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExternalMediaStatusInner(boolean isMounted, boolean reportStatus, boolean externalStorage) {
        int[] uidArr = null;
        HashSet<String> removeCids = new HashSet<String>();
        HashMap<AsecInstallArgs, String> processCids = new HashMap<AsecInstallArgs, String>();
        String[] list = PackageHelper.getSecureContainerList();
        if (list == null || list.length == 0) {
            Log.i(TAG, "No secure containers on sdcard");
        } else {
            int[] uidList = new int[list.length];
            int num = 0;
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                for (String cid : list) {
                    String pkgName = PackageManagerService.getAsecPackageName(cid);
                    if (pkgName == null) {
                        removeCids.add(cid);
                        continue;
                    }
                    PackageSetting ps = this.mSettings.mPackages.get(pkgName);
                    if (ps == null) {
                        Log.i(TAG, "Deleting container with no matching settings " + cid);
                        removeCids.add(cid);
                        continue;
                    }
                    if (externalStorage && !isMounted && !PackageManagerService.isExternal(ps)) continue;
                    AsecInstallArgs args = new AsecInstallArgs(cid, this.isForwardLocked(ps));
                    if (ps.codePathString != null && ps.codePathString.equals(args.getCodePath())) {
                        processCids.put(args, ps.codePathString);
                        int uid = ps.appId;
                        if (uid == -1) continue;
                        uidList[num++] = uid;
                        continue;
                    }
                    Log.i(TAG, "Deleting stale container for " + cid);
                    removeCids.add(cid);
                }
            }
            if (num > 0) {
                Arrays.sort(uidList, 0, num);
                uidArr = new int[num];
                uidArr[0] = uidList[0];
                int di = 0;
                for (int i = 1; i < num; ++i) {
                    if (uidList[i - 1] == uidList[i]) continue;
                    uidArr[di++] = uidList[i];
                }
            }
        }
        if (isMounted) {
            this.loadMediaPackages(processCids, uidArr, removeCids);
            this.startCleaningPackages();
        } else {
            this.unloadMediaPackages(processCids, uidArr, reportStatus);
        }
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, ArrayList<String> pkgList, int[] uidArr, IIntentReceiver finishedReceiver) {
        int size = pkgList.size();
        if (size > 0) {
            Bundle extras = new Bundle();
            extras.putStringArray("android.intent.extra.changed_package_list", pkgList.toArray(new String[size]));
            if (uidArr != null) {
                extras.putIntArray("android.intent.extra.changed_uid_list", uidArr);
            }
            if (replacing && !mediaStatus) {
                extras.putBoolean("android.intent.extra.REPLACING", replacing);
            }
            String action = mediaStatus ? "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE" : "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE";
            PackageManagerService.sendPackageBroadcast(action, null, extras, null, finishedReceiver, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void loadMediaPackages(HashMap<AsecInstallArgs, String> processCids, int[] uidArr, HashSet<String> removeCids) {
        boolean regrantPermissions;
        ArrayList<String> pkgList = new ArrayList<String>();
        Set<AsecInstallArgs> keys = processCids.keySet();
        boolean doGc = false;
        for (AsecInstallArgs args : keys) {
            Object var18_17;
            String codePath = processCids.get(args);
            int retCode = -18;
            try {
                if (args.doPreInstall(1) != 1) {
                    Slog.e(TAG, "Failed to mount cid : " + args.cid + " when installing from sdcard");
                    var18_17 = null;
                    if (retCode == 1) continue;
                    removeCids.add(args.cid);
                    continue;
                }
                if (codePath == null || !codePath.equals(args.getCodePath())) {
                    Slog.e(TAG, "Container " + args.cid + " cachepath " + args.getCodePath() + " does not match one in settings " + codePath);
                    var18_17 = null;
                    if (retCode == 1) continue;
                    removeCids.add(args.cid);
                    continue;
                }
                int parseFlags = this.mDefParseFlags;
                if (args.isExternal()) {
                    parseFlags |= 0x20;
                }
                if (args.isFwdLocked()) {
                    parseFlags |= 0x10;
                }
                doGc = true;
                Object object = this.mInstallLock;
                // MONITORENTER : object
                PackageParser.Package pkg = this.scanPackageLI(new File(codePath), parseFlags, 0, 0L, null);
                if (pkg != null) {
                    HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                    // MONITORENTER : hashMap
                    retCode = 1;
                    pkgList.add(pkg.packageName);
                    args.doPostInstall(1, pkg.applicationInfo.uid);
                    // MONITOREXIT : hashMap
                } else {
                    Slog.i(TAG, "Failed to install pkg from  " + codePath + " from sdcard");
                }
                // MONITOREXIT : object
                var18_17 = null;
                if (retCode == 1) continue;
                removeCids.add(args.cid);
            }
            catch (Throwable throwable) {
                var18_17 = null;
                if (retCode == 1) throw throwable;
                removeCids.add(args.cid);
                throw throwable;
            }
        }
        Iterator<String> i$ = this.mPackages;
        // MONITORENTER : i$
        boolean bl = regrantPermissions = this.mSettings.mExternalSdkPlatform != this.mSdkVersion;
        if (regrantPermissions) {
            Slog.i(TAG, "Platform changed from " + this.mSettings.mExternalSdkPlatform + " to " + this.mSdkVersion + "; regranting permissions for external storage");
        }
        this.mSettings.mExternalSdkPlatform = this.mSdkVersion;
        this.updatePermissionsLPw(null, null, 1 | (regrantPermissions ? 6 : 0));
        this.mSettings.writeLPr();
        // MONITOREXIT : i$
        if (pkgList.size() > 0) {
            this.sendResourcesChangedBroadcast(true, false, pkgList, uidArr, null);
        }
        if (doGc) {
            Runtime.getRuntime().gc();
        }
        if (removeCids == null) return;
        i$ = removeCids.iterator();
        while (i$.hasNext()) {
            String cid = i$.next();
            if (cid.startsWith(mTempContainerPrefix)) {
                Log.i(TAG, "Destroying stale temporary container " + cid);
                PackageHelper.destroySdDir(cid);
                continue;
            }
            Log.w(TAG, "Container " + cid + " is stale");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllContainers(Set<AsecInstallArgs> cidArgs) {
        for (AsecInstallArgs arg : cidArgs) {
            Object object = this.mInstallLock;
            synchronized (object) {
                arg.doPostDeleteLI(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadMediaPackages(HashMap<AsecInstallArgs, String> processCids, int[] uidArr, final boolean reportStatus) {
        ArrayList<String> pkgList = new ArrayList<String>();
        ArrayList<AsecInstallArgs> failedList = new ArrayList<AsecInstallArgs>();
        final Set<AsecInstallArgs> keys = processCids.keySet();
        for (AsecInstallArgs args : keys) {
            String pkgName = args.getPackageName();
            PackageRemovedInfo outInfo = new PackageRemovedInfo();
            Object object = this.mInstallLock;
            synchronized (object) {
                boolean res = this.deletePackageLI(pkgName, null, false, null, null, 1, outInfo, false);
                if (res) {
                    pkgList.add(pkgName);
                } else {
                    Slog.e(TAG, "Failed to delete pkg from sdcard : " + pkgName);
                    failedList.add(args);
                }
            }
        }
        HashMap<String, PackageParser.Package> i$ = this.mPackages;
        synchronized (i$) {
            this.mSettings.writeLPr();
        }
        if (pkgList.size() > 0) {
            this.sendResourcesChangedBroadcast(false, false, pkgList, uidArr, new IIntentReceiver.Stub(){

                public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    Message msg = PackageManagerService.this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, 1, keys);
                    PackageManagerService.this.mHandler.sendMessage(msg);
                }
            });
        } else {
            Message msg = this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, -1, keys);
            this.mHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void movePackage(String packageName, IPackageMoveObserver observer, int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOVE_PACKAGE", null);
        UserHandle user = new UserHandle(UserHandle.getCallingUserId());
        int returnCode = 1;
        int currFlags = 0;
        int newFlags = 0;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                returnCode = -2;
            } else if (pkg.applicationInfo != null && PackageManagerService.isSystemApp(pkg)) {
                Slog.w(TAG, "Cannot move system application");
                returnCode = -3;
            } else if (pkg.mOperationPending) {
                Slog.w(TAG, "Attempt to move package which has pending operations");
                returnCode = -7;
            } else {
                if ((flags & 2) != 0 && (flags & 1) != 0) {
                    Slog.w(TAG, "Ambigous flags specified for move location.");
                    returnCode = -5;
                } else {
                    newFlags = (flags & 2) != 0 ? 8 : 16;
                    int n = currFlags = PackageManagerService.isExternal(pkg) ? 8 : 16;
                    if (newFlags == currFlags) {
                        Slog.w(TAG, "No move required. Trying to move to same location");
                        returnCode = -5;
                    } else if (PackageManagerService.isForwardLocked(pkg)) {
                        currFlags |= 1;
                        newFlags |= 1;
                    }
                }
                if (returnCode == 1) {
                    pkg.mOperationPending = true;
                }
            }
            if (returnCode != 1) {
                this.processPendingMove(new MoveParams(null, observer, 0, packageName, null, -1, user), returnCode);
            } else {
                Message msg = this.mHandler.obtainMessage(5);
                InstallArgs srcArgs = this.createInstallArgs(currFlags, pkg.applicationInfo.sourceDir, pkg.applicationInfo.publicSourceDir, pkg.applicationInfo.nativeLibraryDir);
                MoveParams mp = new MoveParams(srcArgs, observer, newFlags, packageName, pkg.applicationInfo.dataDir, pkg.applicationInfo.uid, user);
                msg.obj = mp;
                this.mHandler.sendMessage(msg);
            }
        }
    }

    private void processPendingMove(final MoveParams mp, final int currentStatus) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IPackageMoveObserver observer;
                Object uidArr;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int returnCode = currentStatus;
                if (currentStatus == 1) {
                    uidArr = null;
                    ArrayList<String> pkgList = null;
                    Object object = PackageManagerService.this.mPackages;
                    synchronized (object) {
                        PackageParser.Package pkg = PackageManagerService.this.mPackages.get(mp.packageName);
                        if (pkg == null) {
                            Slog.w(PackageManagerService.TAG, " Package " + mp.packageName + " doesn't exist. Aborting move");
                            returnCode = -2;
                        } else if (!mp.srcArgs.getCodePath().equals(pkg.applicationInfo.sourceDir)) {
                            Slog.w(PackageManagerService.TAG, "Package " + mp.packageName + " code path changed from " + mp.srcArgs.getCodePath() + " to " + pkg.applicationInfo.sourceDir + " Aborting move and returning error");
                            returnCode = -6;
                        } else {
                            uidArr = new int[]{pkg.applicationInfo.uid};
                            pkgList = new ArrayList<String>();
                            pkgList.add(mp.packageName);
                        }
                    }
                    if (returnCode == 1) {
                        PackageManagerService.this.sendResourcesChangedBroadcast(false, true, pkgList, (int[])uidArr, null);
                        object = PackageManagerService.this.mInstallLock;
                        synchronized (object) {
                            HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
                            synchronized (hashMap) {
                                PackageParser.Package pkg = PackageManagerService.this.mPackages.get(mp.packageName);
                                if (pkg == null) {
                                    Slog.w(PackageManagerService.TAG, " Package " + mp.packageName + " doesn't exist. Aborting move");
                                    returnCode = -2;
                                } else if (!mp.srcArgs.getCodePath().equals(pkg.applicationInfo.sourceDir)) {
                                    Slog.w(PackageManagerService.TAG, "Package " + mp.packageName + " code path changed from " + mp.srcArgs.getCodePath() + " to " + pkg.applicationInfo.sourceDir + " Aborting move and returning error");
                                    returnCode = -6;
                                } else {
                                    int[] users;
                                    String oldCodePath = pkg.mPath;
                                    String newCodePath = mp.targetArgs.getCodePath();
                                    String newResPath = mp.targetArgs.getResourcePath();
                                    String newNativePath = mp.targetArgs.getNativeLibraryPath();
                                    File newNativeDir = new File(newNativePath);
                                    if (!PackageManagerService.isForwardLocked(pkg) && !PackageManagerService.isExternal(pkg)) {
                                        NativeLibraryHelper.copyNativeBinariesIfNeededLI(new File(newCodePath), newNativeDir);
                                    }
                                    for (int user : users = sUserManager.getUserIds()) {
                                        if (PackageManagerService.this.mInstaller.linkNativeLibraryDirectory(pkg.packageName, newNativePath, user) >= 0) continue;
                                        returnCode = -1;
                                    }
                                    if (returnCode == 1) {
                                        pkg.mPath = newCodePath;
                                        if (PackageManagerService.this.moveDexFilesLI(pkg) != 1) {
                                            pkg.mPath = pkg.mScanPath;
                                            returnCode = -1;
                                        }
                                    }
                                    if (returnCode == 1) {
                                        pkg.mScanPath = newCodePath;
                                        pkg.applicationInfo.sourceDir = newCodePath;
                                        pkg.applicationInfo.publicSourceDir = newResPath;
                                        pkg.applicationInfo.nativeLibraryDir = newNativePath;
                                        PackageSetting ps = (PackageSetting)pkg.mExtras;
                                        ps.codePath = new File(pkg.applicationInfo.sourceDir);
                                        ps.codePathString = ps.codePath.getPath();
                                        ps.resourcePath = new File(pkg.applicationInfo.publicSourceDir);
                                        ps.resourcePathString = ps.resourcePath.getPath();
                                        ps.nativeLibraryPathString = newNativePath;
                                        pkg.applicationInfo.flags = (mp.flags & 8) != 0 ? (pkg.applicationInfo.flags |= 0x40000) : (pkg.applicationInfo.flags &= 0xFFFBFFFF);
                                        ps.setFlags(pkg.applicationInfo.flags);
                                        PackageManagerService.this.mAppDirs.remove(oldCodePath);
                                        PackageManagerService.this.mAppDirs.put(newCodePath, pkg);
                                        PackageManagerService.this.mSettings.writeLPr();
                                    }
                                }
                            }
                        }
                        PackageManagerService.this.sendResourcesChangedBroadcast(true, false, pkgList, (int[])uidArr, null);
                    }
                }
                if (returnCode != 1) {
                    if (mp.targetArgs != null) {
                        mp.targetArgs.doPostInstall(-110, -1);
                    }
                } else {
                    Runtime.getRuntime().gc();
                    uidArr = PackageManagerService.this.mInstallLock;
                    synchronized (uidArr) {
                        mp.srcArgs.doPostDeleteLI(true);
                    }
                }
                if (returnCode != -7) {
                    uidArr = PackageManagerService.this.mPackages;
                    synchronized (uidArr) {
                        PackageParser.Package pkg = PackageManagerService.this.mPackages.get(mp.packageName);
                        if (pkg != null) {
                            pkg.mOperationPending = false;
                        }
                    }
                }
                if ((observer = mp.observer) != null) {
                    try {
                        observer.packageMoved(mp.packageName, returnCode);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    @Override
    public boolean setInstallLocation(int loc) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", null);
        if (this.getInstallLocation() == loc) {
            return true;
        }
        if (loc == 0 || loc == 1 || loc == 2) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "default_install_location", loc);
            return true;
        }
        return false;
    }

    @Override
    public int getInstallLocation() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "default_install_location", 0);
    }

    void cleanUpUserLILPw(int userHandle) {
        this.mDirtyUsers.remove(userHandle);
        this.mSettings.removeUserLPr(userHandle);
        this.mPendingBroadcasts.remove(userHandle);
        if (this.mInstaller != null) {
            this.mInstaller.removeUserDataDirs(userHandle);
        }
    }

    void createNewUserLILPw(int userHandle, File path) {
        if (this.mInstaller != null) {
            this.mSettings.createNewUserLILPw(this, this.mInstaller, userHandle, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can read the verifier device identity");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getVerifierDeviceIdentityLPw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setPermissionEnforced(String permission2, boolean enforced) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_REVOKE_PERMISSIONS", null);
        if (!"android.permission.READ_EXTERNAL_STORAGE".equals(permission2)) throw new IllegalArgumentException("No selective enforcement for " + permission2);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mSettings.mReadExternalStorageEnforced == null || this.mSettings.mReadExternalStorageEnforced != enforced) {
                this.mSettings.mReadExternalStorageEnforced = enforced;
                this.mSettings.writeLPr();
            }
        }
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am == null) return;
        long token = Binder.clearCallingIdentity();
        try {
            try {
                am.killProcessesBelowForeground("setPermissionEnforcement");
            }
            catch (RemoteException e) {
                Object var8_6 = null;
                Binder.restoreCallingIdentity(token);
                return;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
    }

    @Override
    @Deprecated
    public boolean isPermissionEnforced(String permission2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStorageLow() {
        boolean bl;
        long token = Binder.clearCallingIdentity();
        try {
            DeviceStorageMonitorService dsm = (DeviceStorageMonitorService)ServiceManager.getService("devicestoragemonitor");
            bl = dsm.isMemoryLow();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        Binder.restoreCallingIdentity(token);
        return bl;
    }

    static {
        mResolvePrioritySorter = new Comparator<ResolveInfo>(){

            @Override
            public int compare(ResolveInfo r1, ResolveInfo r2) {
                int v1 = r1.priority;
                int v2 = r2.priority;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                v1 = r1.preferredOrder;
                v2 = r2.preferredOrder;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                if (r1.isDefault != r2.isDefault) {
                    return r1.isDefault ? -1 : 1;
                }
                v1 = r1.match;
                v2 = r2.match;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                if (r1.system != r2.system) {
                    return r1.system ? -1 : 1;
                }
                return 0;
            }
        };
        mProviderInitOrderSorter = new Comparator<ProviderInfo>(){

            @Override
            public int compare(ProviderInfo p1, ProviderInfo p2) {
                int v1 = p1.initOrder;
                int v2 = p2.initOrder;
                return v1 > v2 ? -1 : (v1 < v2 ? 1 : 0);
            }
        };
    }

    static class DumpState {
        public static final int DUMP_LIBS = 1;
        public static final int DUMP_FEATURES = 2;
        public static final int DUMP_RESOLVERS = 4;
        public static final int DUMP_PERMISSIONS = 8;
        public static final int DUMP_PACKAGES = 16;
        public static final int DUMP_SHARED_USERS = 32;
        public static final int DUMP_MESSAGES = 64;
        public static final int DUMP_PROVIDERS = 128;
        public static final int DUMP_VERIFIERS = 256;
        public static final int DUMP_PREFERRED = 512;
        public static final int DUMP_PREFERRED_XML = 1024;
        public static final int DUMP_KEYSETS = 2048;
        public static final int OPTION_SHOW_FILTERS = 1;
        private int mTypes;
        private int mOptions;
        private boolean mTitlePrinted;
        private SharedUserSetting mSharedUser;

        DumpState() {
        }

        public boolean isDumping(int type) {
            if (this.mTypes == 0 && type != 1024) {
                return true;
            }
            return (this.mTypes & type) != 0;
        }

        public void setDump(int type) {
            this.mTypes |= type;
        }

        public boolean isOptionEnabled(int option) {
            return (this.mOptions & option) != 0;
        }

        public void setOptionEnabled(int option) {
            this.mOptions |= option;
        }

        public boolean onTitlePrinted() {
            boolean printed = this.mTitlePrinted;
            this.mTitlePrinted = true;
            return printed;
        }

        public boolean getTitlePrinted() {
            return this.mTitlePrinted;
        }

        public void setTitlePrinted(boolean enabled) {
            this.mTitlePrinted = enabled;
        }

        public SharedUserSetting getSharedUser() {
            return this.mSharedUser;
        }

        public void setSharedUser(SharedUserSetting user) {
            this.mSharedUser = user;
        }
    }

    private final class ClearStorageConnection
    implements ServiceConnection {
        IMediaContainerService mContainerService;

        private ClearStorageConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            ClearStorageConnection clearStorageConnection = this;
            synchronized (clearStorageConnection) {
                this.mContainerService = IMediaContainerService.Stub.asInterface(service);
                this.notifyAll();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }

    static class PackageRemovedInfo {
        String removedPackage;
        int uid = -1;
        int removedAppId = -1;
        int[] removedUsers = null;
        boolean isRemovedPackageSystemUpdate = false;
        InstallArgs args = null;

        PackageRemovedInfo() {
        }

        void sendBroadcast(boolean fullRemove, boolean replacing, boolean removedForAllUsers) {
            Bundle extras = new Bundle(1);
            extras.putInt("android.intent.extra.UID", this.removedAppId >= 0 ? this.removedAppId : this.uid);
            extras.putBoolean("android.intent.extra.DATA_REMOVED", fullRemove);
            if (replacing) {
                extras.putBoolean("android.intent.extra.REPLACING", true);
            }
            extras.putBoolean("android.intent.extra.REMOVED_FOR_ALL_USERS", removedForAllUsers);
            if (this.removedPackage != null) {
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REMOVED", this.removedPackage, extras, null, null, this.removedUsers);
                if (fullRemove && !replacing) {
                    PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_FULLY_REMOVED", this.removedPackage, extras, null, null, this.removedUsers);
                }
            }
            if (this.removedAppId >= 0) {
                PackageManagerService.sendPackageBroadcast("android.intent.action.UID_REMOVED", null, extras, null, null, this.removedUsers);
            }
        }
    }

    class PackageInstalledInfo {
        String name;
        int uid;
        int[] origUsers;
        int[] newUsers;
        PackageParser.Package pkg;
        int returnCode;
        PackageRemovedInfo removedInfo;

        PackageInstalledInfo() {
        }
    }

    class AsecInstallArgs
    extends InstallArgs {
        static final String RES_FILE_NAME = "pkg.apk";
        static final String PUBLIC_RES_FILE_NAME = "res.zip";
        String cid;
        String packagePath;
        String resourcePath;
        String libraryPath;

        AsecInstallArgs(InstallParams params) {
            super(params.getPackageUri(), params.observer, params.flags, params.installerPackageName, params.getManifestDigest(), params.getUser());
        }

        AsecInstallArgs(String fullCodePath, String fullResourcePath, String nativeLibraryPath, boolean isExternal, boolean isForwardLocked) {
            super(null, null, (isExternal ? 8 : 0) | (isForwardLocked ? 1 : 0), null, null, null);
            int eidx = fullCodePath.lastIndexOf("/");
            String subStr1 = fullCodePath.substring(0, eidx);
            int sidx = subStr1.lastIndexOf("/");
            this.cid = subStr1.substring(sidx + 1, eidx);
            this.setCachePath(subStr1);
        }

        AsecInstallArgs(String cid, boolean isForwardLocked) {
            super(null, null, (PackageManagerService.this.isAsecExternal(cid) ? 8 : 0) | (isForwardLocked ? 1 : 0), null, null, null);
            this.cid = cid;
            this.setCachePath(PackageHelper.getSdDir(cid));
        }

        AsecInstallArgs(Uri packageURI, String cid, boolean isExternal, boolean isForwardLocked) {
            super(packageURI, null, (isExternal ? 8 : 0) | (isForwardLocked ? 1 : 0), null, null, null);
            this.cid = cid;
        }

        void createCopyFile() {
            this.cid = PackageManagerService.getTempContainerId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkFreeStorage(IMediaContainerService imcs) throws RemoteException {
            try {
                PackageManagerService.this.mContext.grantUriPermission(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, this.packageURI, 1);
                boolean bl = imcs.checkExternalFreeStorage(this.packageURI, this.isFwdLocked());
                Object var4_3 = null;
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                throw throwable;
            }
        }

        private final boolean isExternal() {
            return (this.flags & 8) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int copyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            String newCachePath;
            if (temp) {
                this.createCopyFile();
            } else {
                PackageHelper.destroySdDir(this.cid);
            }
            try {
                PackageManagerService.this.mContext.grantUriPermission(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, this.packageURI, 1);
                newCachePath = imcs.copyResourceToContainer(this.packageURI, this.cid, PackageManagerService.this.getEncryptKey(), RES_FILE_NAME, PUBLIC_RES_FILE_NAME, this.isExternal(), this.isFwdLocked());
                Object var5_4 = null;
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                throw throwable;
            }
            if (newCachePath != null) {
                this.setCachePath(newCachePath);
                return 1;
            }
            return -18;
        }

        String getCodePath() {
            return this.packagePath;
        }

        String getResourcePath() {
            return this.resourcePath;
        }

        String getNativeLibraryPath() {
            return this.libraryPath;
        }

        int doPreInstall(int status) {
            if (status != 1) {
                PackageHelper.destroySdDir(this.cid);
            } else {
                boolean mounted = PackageHelper.isContainerMounted(this.cid);
                if (!mounted) {
                    String newCachePath = PackageHelper.mountSdDir(this.cid, PackageManagerService.this.getEncryptKey(), 1000);
                    if (newCachePath != null) {
                        this.setCachePath(newCachePath);
                    } else {
                        return -18;
                    }
                }
            }
            return status;
        }

        boolean doRename(int status, String pkgName, String oldCodePath) {
            String newCacheId = PackageManagerService.getNextCodePath(oldCodePath, pkgName, "/pkg.apk");
            String newCachePath = null;
            if (PackageHelper.isContainerMounted(this.cid) && !PackageHelper.unMountSdDir(this.cid)) {
                Slog.i(PackageManagerService.TAG, "Failed to unmount " + this.cid + " before renaming");
                return false;
            }
            if (!PackageHelper.renameSdDir(this.cid, newCacheId)) {
                Slog.e(PackageManagerService.TAG, "Failed to rename " + this.cid + " to " + newCacheId + " which might be stale. Will try to clean up.");
                if (!PackageHelper.destroySdDir(newCacheId)) {
                    Slog.e(PackageManagerService.TAG, "Very strange. Cannot clean up stale container " + newCacheId);
                    return false;
                }
                if (!PackageHelper.renameSdDir(this.cid, newCacheId)) {
                    Slog.e(PackageManagerService.TAG, "Failed to rename " + this.cid + " to " + newCacheId + " inspite of cleaning it up.");
                    return false;
                }
            }
            if (!PackageHelper.isContainerMounted(newCacheId)) {
                Slog.w(PackageManagerService.TAG, "Mounting container " + newCacheId);
                newCachePath = PackageHelper.mountSdDir(newCacheId, PackageManagerService.this.getEncryptKey(), 1000);
            } else {
                newCachePath = PackageHelper.getSdDir(newCacheId);
            }
            if (newCachePath == null) {
                Slog.w(PackageManagerService.TAG, "Failed to get cache path for  " + newCacheId);
                return false;
            }
            Log.i(PackageManagerService.TAG, "Succesfully renamed " + this.cid + " to " + newCacheId + " at new path: " + newCachePath);
            this.cid = newCacheId;
            this.setCachePath(newCachePath);
            return true;
        }

        private void setCachePath(String newCachePath) {
            File cachePath = new File(newCachePath);
            this.libraryPath = new File(cachePath, PackageManagerService.LIB_DIR_NAME).getPath();
            this.packagePath = new File(cachePath, RES_FILE_NAME).getPath();
            this.resourcePath = this.isFwdLocked() ? new File(cachePath, PUBLIC_RES_FILE_NAME).getPath() : this.packagePath;
        }

        int doPostInstall(int status, int uid) {
            if (status != 1) {
                this.cleanUp();
            } else {
                String protectedFile;
                int groupOwner;
                if (this.isFwdLocked()) {
                    groupOwner = UserHandle.getSharedAppGid(uid);
                    protectedFile = RES_FILE_NAME;
                } else {
                    groupOwner = -1;
                    protectedFile = null;
                }
                if (uid < 10000 || !PackageHelper.fixSdPermissions(this.cid, groupOwner, protectedFile)) {
                    Slog.e(PackageManagerService.TAG, "Failed to finalize " + this.cid);
                    PackageHelper.destroySdDir(this.cid);
                    return -18;
                }
                boolean mounted = PackageHelper.isContainerMounted(this.cid);
                if (!mounted) {
                    PackageHelper.mountSdDir(this.cid, PackageManagerService.this.getEncryptKey(), Process.myUid());
                }
            }
            return status;
        }

        private void cleanUp() {
            PackageHelper.destroySdDir(this.cid);
        }

        void cleanUpResourcesLI() {
            String sourceFile = this.getCodePath();
            int retCode = PackageManagerService.this.mInstaller.rmdex(sourceFile);
            if (retCode < 0) {
                Slog.w(PackageManagerService.TAG, "Couldn't remove dex file for package:  at location " + sourceFile.toString() + ", retcode=" + retCode);
            }
            this.cleanUp();
        }

        boolean matchContainer(String app) {
            return this.cid.startsWith(app);
        }

        String getPackageName() {
            return PackageManagerService.getAsecPackageName(this.cid);
        }

        boolean doPostDeleteLI(boolean delete) {
            boolean ret = false;
            boolean mounted = PackageHelper.isContainerMounted(this.cid);
            if (mounted) {
                ret = PackageHelper.unMountSdDir(this.cid);
            }
            if (ret && delete) {
                this.cleanUpResourcesLI();
            }
            return ret;
        }

        int doPreCopy() {
            if (this.isFwdLocked() && !PackageHelper.fixSdPermissions(this.cid, PackageManagerService.this.getPackageUid(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, 0), RES_FILE_NAME)) {
                return -18;
            }
            return 1;
        }

        int doPostCopy(int uid) {
            if (this.isFwdLocked() && (uid < 10000 || !PackageHelper.fixSdPermissions(this.cid, UserHandle.getSharedAppGid(uid), RES_FILE_NAME))) {
                Slog.e(PackageManagerService.TAG, "Failed to finalize " + this.cid);
                PackageHelper.destroySdDir(this.cid);
                return -18;
            }
            return 1;
        }
    }

    class FileInstallArgs
    extends InstallArgs {
        File installDir;
        String codeFileName;
        String resourceFileName;
        String libraryPath;
        boolean created;

        FileInstallArgs(InstallParams params) {
            super(params.getPackageUri(), params.observer, params.flags, params.installerPackageName, params.getManifestDigest(), params.getUser());
            this.created = false;
        }

        FileInstallArgs(String fullCodePath, String fullResourcePath, String nativeLibraryPath) {
            super(null, null, 0, null, null, null);
            this.created = false;
            File codeFile = new File(fullCodePath);
            this.installDir = codeFile.getParentFile();
            this.codeFileName = fullCodePath;
            this.resourceFileName = fullResourcePath;
            this.libraryPath = nativeLibraryPath;
        }

        FileInstallArgs(Uri packageURI, String pkgName, String dataDir) {
            super(packageURI, null, 0, null, null, null);
            this.created = false;
            this.installDir = this.isFwdLocked() ? PackageManagerService.this.mDrmAppPrivateInstallDir : PackageManagerService.this.mAppInstallDir;
            String apkName = PackageManagerService.getNextCodePath(null, pkgName, ".apk");
            this.codeFileName = new File(this.installDir, apkName + ".apk").getPath();
            this.resourceFileName = this.getResourcePathFromCodePath();
            this.libraryPath = new File(PackageManagerService.this.mAppLibInstallDir, pkgName).getPath();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkFreeStorage(IMediaContainerService imcs) throws RemoteException {
            long lowThreshold;
            DeviceStorageMonitorService dsm = (DeviceStorageMonitorService)ServiceManager.getService("devicestoragemonitor");
            if (dsm == null) {
                Log.w(PackageManagerService.TAG, "Couldn't get low memory threshold; no free limit imposed");
                lowThreshold = 0L;
            } else {
                if (dsm.isMemoryLow()) {
                    Log.w(PackageManagerService.TAG, "Memory is reported as being too low; aborting package install");
                    return false;
                }
                lowThreshold = dsm.getMemoryLowThreshold();
            }
            try {
                PackageManagerService.this.mContext.grantUriPermission(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, this.packageURI, 1);
                boolean bl = imcs.checkInternalFreeStorage(this.packageURI, this.isFwdLocked(), lowThreshold);
                Object var7_5 = null;
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                throw throwable;
            }
        }

        String getCodePath() {
            return this.codeFileName;
        }

        void createCopyFile() {
            this.installDir = this.isFwdLocked() ? PackageManagerService.this.mDrmAppPrivateInstallDir : PackageManagerService.this.mAppInstallDir;
            this.codeFileName = PackageManagerService.this.createTempPackageFile(this.installDir).getPath();
            this.resourceFileName = this.getResourcePathFromCodePath();
            this.libraryPath = this.getLibraryPathFromCodePath();
            this.created = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int copyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            if (temp) {
                this.createCopyFile();
            }
            File codeFile = new File(this.codeFileName);
            if (!this.created) {
                try {
                    codeFile.createNewFile();
                    if (!this.setPermissions()) {
                        return -4;
                    }
                }
                catch (IOException e) {
                    Slog.w(PackageManagerService.TAG, "Failed to create file " + codeFile);
                    return -4;
                }
            }
            ParcelFileDescriptor out = null;
            try {
                out = ParcelFileDescriptor.open(codeFile, 0x30000000);
            }
            catch (FileNotFoundException e) {
                Slog.e(PackageManagerService.TAG, "Failed to create file descriptor for : " + this.codeFileName);
                return -4;
            }
            int ret = -4;
            try {
                PackageManagerService.this.mContext.grantUriPermission(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, this.packageURI, 1);
                ret = imcs.copyResource(this.packageURI, null, out);
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                IoUtils.closeQuietly(out);
                PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
                throw throwable;
            }
            IoUtils.closeQuietly(out);
            PackageManagerService.this.mContext.revokeUriPermission(this.packageURI, 1);
            if (this.isFwdLocked()) {
                File destResourceFile = new File(this.getResourcePath());
                try {
                    PackageHelper.extractPublicFiles(this.codeFileName, destResourceFile);
                }
                catch (IOException e) {
                    Slog.e(PackageManagerService.TAG, "Couldn't create a new zip file for the public parts of a forward-locked app.");
                    destResourceFile.delete();
                    return -4;
                }
            }
            File nativeLibraryFile = new File(this.getNativeLibraryPath());
            Slog.i(PackageManagerService.TAG, "Copying native libraries to " + nativeLibraryFile.getPath());
            if (nativeLibraryFile.exists()) {
                NativeLibraryHelper.removeNativeBinariesFromDirLI(nativeLibraryFile);
                nativeLibraryFile.delete();
            }
            try {
                int copyRet = PackageManagerService.copyNativeLibrariesForInternalApp(codeFile, nativeLibraryFile);
                if (copyRet != 1) {
                    return copyRet;
                }
            }
            catch (IOException e) {
                Slog.e(PackageManagerService.TAG, "Copying native libraries failed", e);
                ret = -110;
            }
            return ret;
        }

        int doPreInstall(int status) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        boolean doRename(int status, String pkgName, String oldCodePath) {
            if (status != 1) {
                this.cleanUp();
                return false;
            }
            File oldCodeFile = new File(this.getCodePath());
            File oldResourceFile = new File(this.getResourcePath());
            File oldLibraryFile = new File(this.getNativeLibraryPath());
            String apkName = PackageManagerService.getNextCodePath(oldCodePath, pkgName, ".apk");
            File newCodeFile = new File(this.installDir, apkName + ".apk");
            if (!oldCodeFile.renameTo(newCodeFile)) {
                return false;
            }
            this.codeFileName = newCodeFile.getPath();
            File newResFile = new File(this.getResourcePathFromCodePath());
            if (this.isFwdLocked() && !oldResourceFile.renameTo(newResFile)) {
                return false;
            }
            this.resourceFileName = newResFile.getPath();
            File newLibraryFile = new File(this.getLibraryPathFromCodePath());
            if (newLibraryFile.exists()) {
                NativeLibraryHelper.removeNativeBinariesFromDirLI(newLibraryFile);
                newLibraryFile.delete();
            }
            if (!oldLibraryFile.renameTo(newLibraryFile)) {
                Slog.e(PackageManagerService.TAG, "Cannot rename native library directory " + oldLibraryFile.getPath() + " to " + newLibraryFile.getPath());
                return false;
            }
            this.libraryPath = newLibraryFile.getPath();
            if (!this.setPermissions()) {
                return false;
            }
            return SELinux.restorecon(newCodeFile);
        }

        int doPostInstall(int status, int uid) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        String getResourcePath() {
            return this.resourceFileName;
        }

        private String getResourcePathFromCodePath() {
            String codePath = this.getCodePath();
            if (this.isFwdLocked()) {
                StringBuilder sb = new StringBuilder();
                sb.append(PackageManagerService.this.mAppInstallDir.getPath());
                sb.append('/');
                sb.append(PackageManagerService.getApkName(codePath));
                sb.append(".zip");
                if (codePath.endsWith(".tmp")) {
                    sb.append(".tmp");
                }
                return sb.toString();
            }
            return codePath;
        }

        private String getLibraryPathFromCodePath() {
            return new File(PackageManagerService.this.mAppLibInstallDir, PackageManagerService.getApkName(this.getCodePath())).getPath();
        }

        String getNativeLibraryPath() {
            if (this.libraryPath == null) {
                this.libraryPath = this.getLibraryPathFromCodePath();
            }
            return this.libraryPath;
        }

        private boolean cleanUp() {
            boolean ret = true;
            String sourceDir = this.getCodePath();
            String publicSourceDir = this.getResourcePath();
            if (sourceDir != null) {
                File sourceFile = new File(sourceDir);
                if (!sourceFile.exists()) {
                    Slog.w(PackageManagerService.TAG, "Package source " + sourceDir + " does not exist.");
                    ret = false;
                }
                sourceFile.delete();
            }
            if (publicSourceDir != null && !publicSourceDir.equals(sourceDir)) {
                File publicSourceFile = new File(publicSourceDir);
                if (!publicSourceFile.exists()) {
                    Slog.w(PackageManagerService.TAG, "Package public source " + publicSourceFile + " does not exist.");
                }
                if (publicSourceFile.exists()) {
                    publicSourceFile.delete();
                }
            }
            if (this.libraryPath != null) {
                File nativeLibraryFile = new File(this.libraryPath);
                NativeLibraryHelper.removeNativeBinariesFromDirLI(nativeLibraryFile);
                if (!nativeLibraryFile.delete()) {
                    Slog.w(PackageManagerService.TAG, "Couldn't delete native library directory " + this.libraryPath);
                }
            }
            return ret;
        }

        void cleanUpResourcesLI() {
            int retCode;
            String sourceDir = this.getCodePath();
            if (this.cleanUp() && (retCode = PackageManagerService.this.mInstaller.rmdex(sourceDir)) < 0) {
                Slog.w(PackageManagerService.TAG, "Couldn't remove dex file for package:  at location " + sourceDir + ", retcode=" + retCode);
            }
        }

        private boolean setPermissions() {
            if (!this.isFwdLocked()) {
                int filePermissions = 420;
                int retCode = FileUtils.setPermissions(this.getCodePath(), 420, -1, -1);
                if (retCode != 0) {
                    Slog.e(PackageManagerService.TAG, "Couldn't set new package file permissions for " + this.getCodePath() + ". The return code was: " + retCode);
                    return false;
                }
                return true;
            }
            return true;
        }

        boolean doPostDeleteLI(boolean delete) {
            this.cleanUpResourcesLI();
            return true;
        }
    }

    static abstract class InstallArgs {
        final IPackageInstallObserver observer;
        final int flags;
        final Uri packageURI;
        final String installerPackageName;
        final ManifestDigest manifestDigest;
        final UserHandle user;

        InstallArgs(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName, ManifestDigest manifestDigest, UserHandle user) {
            this.packageURI = packageURI;
            this.flags = flags;
            this.observer = observer;
            this.installerPackageName = installerPackageName;
            this.manifestDigest = manifestDigest;
            this.user = user;
        }

        abstract void createCopyFile();

        abstract int copyApk(IMediaContainerService var1, boolean var2) throws RemoteException;

        abstract int doPreInstall(int var1);

        abstract boolean doRename(int var1, String var2, String var3);

        abstract int doPostInstall(int var1, int var2);

        abstract String getCodePath();

        abstract String getResourcePath();

        abstract String getNativeLibraryPath();

        abstract void cleanUpResourcesLI();

        abstract boolean doPostDeleteLI(boolean var1);

        abstract boolean checkFreeStorage(IMediaContainerService var1) throws RemoteException;

        int doPreCopy() {
            return 1;
        }

        int doPostCopy(int uid) {
            return 1;
        }

        protected boolean isFwdLocked() {
            return (this.flags & 1) != 0;
        }

        UserHandle getUser() {
            return this.user;
        }
    }

    class MoveParams
    extends HandlerParams {
        final IPackageMoveObserver observer;
        final int flags;
        final String packageName;
        final InstallArgs srcArgs;
        final InstallArgs targetArgs;
        int uid;
        int mRet;

        MoveParams(InstallArgs srcArgs, IPackageMoveObserver observer, int flags, String packageName, String dataDir, int uid, UserHandle user) {
            super(user);
            this.srcArgs = srcArgs;
            this.observer = observer;
            this.flags = flags;
            this.packageName = packageName;
            this.uid = uid;
            if (srcArgs != null) {
                Uri packageUri = Uri.fromFile(new File(srcArgs.getCodePath()));
                this.targetArgs = PackageManagerService.this.createInstallArgs(packageUri, flags, packageName, dataDir);
            } else {
                this.targetArgs = null;
            }
        }

        public String toString() {
            return "MoveParams{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
        }

        public void handleStartCopy() throws RemoteException {
            this.mRet = -4;
            if (!this.targetArgs.checkFreeStorage(PackageManagerService.this.mContainerService)) {
                Log.w(PackageManagerService.TAG, "Insufficient storage to install");
                return;
            }
            this.mRet = this.srcArgs.doPreCopy();
            if (this.mRet != 1) {
                return;
            }
            this.mRet = this.targetArgs.copyApk(PackageManagerService.this.mContainerService, false);
            if (this.mRet != 1) {
                this.srcArgs.doPostCopy(this.uid);
                return;
            }
            this.mRet = this.srcArgs.doPostCopy(this.uid);
            if (this.mRet != 1) {
                return;
            }
            this.mRet = this.targetArgs.doPreInstall(this.mRet);
            if (this.mRet != 1) {
                return;
            }
        }

        void handleReturnCode() {
            this.targetArgs.doPostInstall(this.mRet, this.uid);
            int currentStatus = -6;
            if (this.mRet == 1) {
                currentStatus = 1;
            } else if (this.mRet == -4) {
                currentStatus = -1;
            }
            PackageManagerService.this.processPendingMove(this, currentStatus);
        }

        void handleServiceError() {
            this.mRet = -110;
        }
    }

    class InstallParams
    extends HandlerParams {
        final IPackageInstallObserver observer;
        int flags;
        private final Uri mPackageURI;
        final String installerPackageName;
        final VerificationParams verificationParams;
        private InstallArgs mArgs;
        private int mRet;
        private File mTempPackage;
        final ContainerEncryptionParams encryptionParams;

        InstallParams(Uri packageURI, IPackageInstallObserver observer, int flags, String installerPackageName, VerificationParams verificationParams, ContainerEncryptionParams encryptionParams, UserHandle user) {
            super(user);
            this.mPackageURI = packageURI;
            this.flags = flags;
            this.observer = observer;
            this.installerPackageName = installerPackageName;
            this.verificationParams = verificationParams;
            this.encryptionParams = encryptionParams;
        }

        public String toString() {
            return "InstallParams{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mPackageURI + "}";
        }

        public ManifestDigest getManifestDigest() {
            if (this.verificationParams == null) {
                return null;
            }
            return this.verificationParams.getManifestDigest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int installLocationPolicy(PackageInfoLite pkgLite, int flags) {
            String packageName = pkgLite.packageName;
            int installLocation = pkgLite.installLocation;
            boolean onSd = (flags & 8) != 0;
            HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
            synchronized (hashMap) {
                PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                if (pkg != null) {
                    if ((flags & 2) != 0) {
                        if ((flags & 0x80) == 0 && pkgLite.versionCode < pkg.mVersionCode) {
                            Slog.w(PackageManagerService.TAG, "Can't install update of " + packageName + " update version " + pkgLite.versionCode + " is older than installed version " + pkg.mVersionCode);
                            return -7;
                        }
                        if ((pkg.applicationInfo.flags & 1) != 0) {
                            if (onSd) {
                                Slog.w(PackageManagerService.TAG, "Cannot install update to system app on sdcard");
                                return -3;
                            }
                            return 1;
                        }
                        if (onSd) {
                            return 2;
                        }
                        if (installLocation == 1) {
                            return 1;
                        }
                        if (installLocation != 2) {
                            if (PackageManagerService.isExternal(pkg)) {
                                return 2;
                            }
                            return 1;
                        }
                    } else {
                        return -4;
                    }
                }
            }
            if (onSd) {
                return 2;
            }
            return pkgLite.recommendedInstallLocation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStartCopy() throws RemoteException {
            InstallArgs args;
            int ret = 1;
            boolean onSd = (this.flags & 8) != 0;
            boolean onInt = (this.flags & 0x10) != 0;
            PackageInfoLite pkgLite = null;
            if (onInt && onSd) {
                Slog.w(PackageManagerService.TAG, "Conflicting flags specified for installing on both internal and external");
                ret = -19;
            } else {
                long lowThreshold;
                DeviceStorageMonitorService dsm = (DeviceStorageMonitorService)ServiceManager.getService("devicestoragemonitor");
                if (dsm == null) {
                    Log.w(PackageManagerService.TAG, "Couldn't get low memory threshold; no free limit imposed");
                    lowThreshold = 0L;
                } else {
                    lowThreshold = dsm.getMemoryLowThreshold();
                }
                try {
                    File packageFile;
                    PackageManagerService.this.mContext.grantUriPermission(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, this.mPackageURI, 1);
                    if (this.encryptionParams != null || !"file".equals(this.mPackageURI.getScheme())) {
                        this.mTempPackage = PackageManagerService.this.createTempPackageFile(PackageManagerService.this.mDrmAppPrivateInstallDir);
                        if (this.mTempPackage != null) {
                            ParcelFileDescriptor out;
                            try {
                                out = ParcelFileDescriptor.open(this.mTempPackage, 0x30000000);
                            }
                            catch (FileNotFoundException e) {
                                out = null;
                                Slog.e(PackageManagerService.TAG, "Failed to create temporary file for : " + this.mPackageURI);
                            }
                            ret = PackageManagerService.this.mContainerService.copyResource(this.mPackageURI, this.encryptionParams, out);
                            IoUtils.closeQuietly(out);
                            packageFile = this.mTempPackage;
                            FileUtils.setPermissions(packageFile.getAbsolutePath(), 420, -1, -1);
                        } else {
                            packageFile = null;
                        }
                    } else {
                        packageFile = new File(this.mPackageURI.getPath());
                    }
                    if (packageFile != null) {
                        String packageFilePath = packageFile.getAbsolutePath();
                        pkgLite = PackageManagerService.this.mContainerService.getMinimalPackageInfo(packageFilePath, this.flags, lowThreshold);
                        if (pkgLite.recommendedInstallLocation == -1) {
                            long size = PackageManagerService.this.mContainerService.calculateInstalledSize(packageFilePath, this.isForwardLocked());
                            if (PackageManagerService.this.mInstaller.freeCache(size + lowThreshold) >= 0) {
                                pkgLite = PackageManagerService.this.mContainerService.getMinimalPackageInfo(packageFilePath, this.flags, lowThreshold);
                            }
                            if (pkgLite.recommendedInstallLocation == -6) {
                                pkgLite.recommendedInstallLocation = -1;
                            }
                        }
                    }
                    Object var13_15 = null;
                    PackageManagerService.this.mContext.revokeUriPermission(this.mPackageURI, 1);
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    PackageManagerService.this.mContext.revokeUriPermission(this.mPackageURI, 1);
                    throw throwable;
                }
            }
            if (ret == 1) {
                int loc = pkgLite.recommendedInstallLocation;
                if (loc == -3) {
                    ret = -19;
                } else if (loc == -4) {
                    ret = -1;
                } else if (loc == -1) {
                    ret = -4;
                } else if (loc == -2) {
                    ret = -2;
                } else if (loc == -6) {
                    ret = -3;
                } else if (loc == -5) {
                    ret = -20;
                } else {
                    loc = this.installLocationPolicy(pkgLite, this.flags);
                    if (loc == -7) {
                        ret = -25;
                    } else if (!onSd && !onInt) {
                        if (loc == 2) {
                            this.flags |= 8;
                            this.flags &= 0xFFFFFFEF;
                        } else {
                            this.flags |= 0x10;
                            this.flags &= 0xFFFFFFF7;
                        }
                    }
                }
            }
            this.mArgs = args = PackageManagerService.this.createInstallArgs(this);
            if (ret == 1) {
                int requiredUid;
                int userIdentifier = this.getUser().getIdentifier();
                if (userIdentifier == -1 && (this.flags & 0x20) != 0) {
                    userIdentifier = 0;
                }
                int n = requiredUid = PackageManagerService.this.mRequiredVerifierPackage == null ? -1 : PackageManagerService.this.getPackageUid(PackageManagerService.this.mRequiredVerifierPackage, userIdentifier);
                if (requiredUid != -1 && PackageManagerService.this.isVerificationEnabled(this.flags)) {
                    Intent verification = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
                    verification.setDataAndType(this.getPackageUri(), PackageManagerService.PACKAGE_MIME_TYPE);
                    verification.addFlags(1);
                    List<ResolveInfo> receivers = PackageManagerService.this.queryIntentReceivers(verification, PackageManagerService.PACKAGE_MIME_TYPE, 512, 0);
                    final int verificationId = PackageManagerService.this.mPendingVerificationToken++;
                    verification.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_PACKAGE", this.installerPackageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALL_FLAGS", this.flags);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_PACKAGE_NAME", pkgLite.packageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_VERSION_CODE", pkgLite.versionCode);
                    if (this.verificationParams != null) {
                        if (this.verificationParams.getVerificationURI() != null) {
                            verification.putExtra("android.content.pm.extra.VERIFICATION_URI", this.verificationParams.getVerificationURI());
                        }
                        if (this.verificationParams.getOriginatingURI() != null) {
                            verification.putExtra("android.intent.extra.ORIGINATING_URI", this.verificationParams.getOriginatingURI());
                        }
                        if (this.verificationParams.getReferrer() != null) {
                            verification.putExtra("android.intent.extra.REFERRER", this.verificationParams.getReferrer());
                        }
                        if (this.verificationParams.getOriginatingUid() >= 0) {
                            verification.putExtra("android.intent.extra.ORIGINATING_UID", this.verificationParams.getOriginatingUid());
                        }
                        if (this.verificationParams.getInstallerUid() >= 0) {
                            verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_UID", this.verificationParams.getInstallerUid());
                        }
                    }
                    PackageVerificationState verificationState = new PackageVerificationState(requiredUid, args);
                    PackageManagerService.this.mPendingVerification.append(verificationId, verificationState);
                    List sufficientVerifiers = PackageManagerService.this.matchVerifiers(pkgLite, receivers, verificationState);
                    if (sufficientVerifiers != null) {
                        int N = sufficientVerifiers.size();
                        if (N == 0) {
                            Slog.i(PackageManagerService.TAG, "Additional verifiers required, but none installed.");
                            ret = -22;
                        } else {
                            for (int i = 0; i < N; ++i) {
                                ComponentName verifierComponent = (ComponentName)sufficientVerifiers.get(i);
                                Intent sufficientIntent = new Intent(verification);
                                sufficientIntent.setComponent(verifierComponent);
                                PackageManagerService.this.mContext.sendBroadcastAsUser(sufficientIntent, this.getUser());
                            }
                        }
                    }
                    ComponentName requiredVerifierComponent = PackageManagerService.this.matchComponentForVerifier(PackageManagerService.this.mRequiredVerifierPackage, receivers);
                    if (ret == 1 && PackageManagerService.this.mRequiredVerifierPackage != null) {
                        verification.setComponent(requiredVerifierComponent);
                        PackageManagerService.this.mContext.sendOrderedBroadcastAsUser(verification, this.getUser(), "android.permission.PACKAGE_VERIFICATION_AGENT", new BroadcastReceiver(){

                            public void onReceive(Context context, Intent intent) {
                                Message msg = PackageManagerService.this.mHandler.obtainMessage(16);
                                msg.arg1 = verificationId;
                                PackageManagerService.this.mHandler.sendMessageDelayed(msg, PackageManagerService.this.getVerificationTimeout());
                            }
                        }, null, 0, null, null);
                        this.mArgs = null;
                    }
                } else {
                    ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                }
            }
            this.mRet = ret;
        }

        void handleReturnCode() {
            if (this.mArgs != null) {
                PackageManagerService.this.processPendingInstall(this.mArgs, this.mRet);
                if (this.mTempPackage != null && !this.mTempPackage.delete()) {
                    Slog.w(PackageManagerService.TAG, "Couldn't delete temporary file: " + this.mTempPackage.getAbsolutePath());
                }
            }
        }

        void handleServiceError() {
            this.mArgs = PackageManagerService.this.createInstallArgs(this);
            this.mRet = -110;
        }

        public boolean isForwardLocked() {
            return (this.flags & 1) != 0;
        }

        public Uri getPackageUri() {
            if (this.mTempPackage != null) {
                return Uri.fromFile(this.mTempPackage);
            }
            return this.mPackageURI;
        }
    }

    class MeasureParams
    extends HandlerParams {
        private final PackageStats mStats;
        private boolean mSuccess;
        private final IPackageStatsObserver mObserver;

        public MeasureParams(PackageStats stats, IPackageStatsObserver observer) {
            super(new UserHandle(stats.userHandle));
            this.mObserver = observer;
            this.mStats = stats;
        }

        public String toString() {
            return "MeasureParams{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mStats.packageName + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleStartCopy() throws RemoteException {
            boolean mounted;
            Object object = PackageManagerService.this.mInstallLock;
            synchronized (object) {
                this.mSuccess = PackageManagerService.this.getPackageSizeInfoLI(this.mStats.packageName, this.mStats.userHandle, this.mStats);
            }
            if (Environment.isExternalStorageEmulated()) {
                mounted = true;
            } else {
                String status = Environment.getExternalStorageState();
                boolean bl = mounted = "mounted".equals(status) || "mounted_ro".equals(status);
            }
            if (mounted) {
                Environment.UserEnvironment userEnv = new Environment.UserEnvironment(this.mStats.userHandle);
                this.mStats.externalCacheSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppCacheDirs(this.mStats.packageName));
                this.mStats.externalDataSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppDataDirs(this.mStats.packageName));
                this.mStats.externalDataSize -= this.mStats.externalCacheSize;
                this.mStats.externalMediaSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppMediaDirs(this.mStats.packageName));
                this.mStats.externalObbSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppObbDirs(this.mStats.packageName));
            }
        }

        void handleReturnCode() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onGetStatsCompleted(this.mStats, this.mSuccess);
                }
                catch (RemoteException e) {
                    Slog.i(PackageManagerService.TAG, "Observer no longer exists.");
                }
            }
        }

        void handleServiceError() {
            Slog.e(PackageManagerService.TAG, "Could not measure application " + this.mStats.packageName + " external storage");
        }
    }

    private abstract class HandlerParams {
        private static final int MAX_RETRIES = 4;
        private int mRetries = 0;
        private final UserHandle mUser;

        HandlerParams(UserHandle user) {
            this.mUser = user;
        }

        UserHandle getUser() {
            return this.mUser;
        }

        final boolean startCopy() {
            boolean res;
            try {
                if (++this.mRetries > 4) {
                    Slog.w(PackageManagerService.TAG, "Failed to invoke remote methods on default container service. Giving up");
                    PackageManagerService.this.mHandler.sendEmptyMessage(11);
                    this.handleServiceError();
                    return false;
                }
                this.handleStartCopy();
                res = true;
            }
            catch (RemoteException e) {
                PackageManagerService.this.mHandler.sendEmptyMessage(10);
                res = false;
            }
            this.handleReturnCode();
            return res;
        }

        final void serviceError() {
            this.handleServiceError();
            this.handleReturnCode();
        }

        abstract void handleStartCopy() throws RemoteException;

        abstract void handleServiceError();

        abstract void handleReturnCode();
    }

    private final class AppDirObserver
    extends FileObserver {
        private final String mRootDir;
        private final boolean mIsRom;
        private final boolean mIsPrivileged;

        public AppDirObserver(String path, int mask, boolean isrom, boolean isPrivileged) {
            super(path, mask);
            this.mRootDir = path;
            this.mIsRom = isrom;
            this.mIsPrivileged = isPrivileged;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(int event, String path) {
            Bundle extras;
            String removedPackage = null;
            int removedAppId = -1;
            int[] removedUsers = null;
            String addedPackage = null;
            int addedAppId = -1;
            int[] addedUsers = null;
            Object object = PackageManagerService.this.mInstallLock;
            synchronized (object) {
                String fullPathStr = null;
                File fullPath = null;
                if (path != null) {
                    fullPath = new File(this.mRootDir, path);
                    fullPathStr = fullPath.getPath();
                }
                if (!PackageManagerService.isPackageFilename(path)) {
                    return;
                }
                if (PackageManagerService.ignoreCodePath(fullPathStr)) {
                    return;
                }
                PackageParser.Package p = null;
                PackageSetting ps = null;
                HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
                synchronized (hashMap) {
                    p = PackageManagerService.this.mAppDirs.get(fullPathStr);
                    if (p != null) {
                        ps = PackageManagerService.this.mSettings.mPackages.get(p.applicationInfo.packageName);
                        removedUsers = ps != null ? ps.queryInstalledUsers(sUserManager.getUserIds(), true) : sUserManager.getUserIds();
                    }
                    addedUsers = sUserManager.getUserIds();
                }
                if ((event & 0x248) != 0 && ps != null) {
                    PackageManagerService.this.removePackageLI(ps, true);
                    removedPackage = ps.name;
                    removedAppId = ps.appId;
                }
                if ((event & 0x88) != 0 && p == null) {
                    int flags = 6;
                    if (this.mIsRom) {
                        flags |= 0x41;
                        if (this.mIsPrivileged) {
                            flags |= 0x80;
                        }
                    }
                    if ((p = PackageManagerService.this.scanPackageLI(fullPath, flags, 97, System.currentTimeMillis(), UserHandle.ALL)) != null) {
                        HashMap<String, PackageParser.Package> hashMap2 = PackageManagerService.this.mPackages;
                        synchronized (hashMap2) {
                            PackageManagerService.this.updatePermissionsLPw(p.packageName, p, p.permissions.size() > 0 ? 1 : 0);
                        }
                        addedPackage = p.applicationInfo.packageName;
                        addedAppId = UserHandle.getAppId(p.applicationInfo.uid);
                    }
                }
                HashMap<String, PackageParser.Package> hashMap3 = PackageManagerService.this.mPackages;
                synchronized (hashMap3) {
                    PackageManagerService.this.mSettings.writeLPr();
                }
            }
            if (removedPackage != null) {
                extras = new Bundle(1);
                extras.putInt("android.intent.extra.UID", removedAppId);
                extras.putBoolean("android.intent.extra.DATA_REMOVED", false);
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REMOVED", removedPackage, extras, null, null, removedUsers);
            }
            if (addedPackage != null) {
                extras = new Bundle(1);
                extras.putInt("android.intent.extra.UID", addedAppId);
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", addedPackage, extras, null, null, addedUsers);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProviderIntentResolver
    extends IntentResolver<PackageParser.ProviderIntentInfo, ResolveInfo> {
        private final HashMap<ComponentName, PackageParser.Provider> mProviders = new HashMap();
        private int mFlags;

        private ProviderIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Provider> packageProviders, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageProviders == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageProviders.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageProviders.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ProviderIntentInfo[] array2 = new PackageParser.ProviderIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addProvider(PackageParser.Provider p) {
            this.mProviders.put(p.getComponentName(), p);
            int NI = p.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ProviderIntentInfo intent = (PackageParser.ProviderIntentInfo)p.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Provider " + p.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeProvider(PackageParser.Provider p) {
            this.mProviders.remove(p.getComponentName());
            int NI = p.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ProviderIntentInfo intent = (PackageParser.ProviderIntentInfo)p.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ProviderIntentInfo filter, List<ResolveInfo> dest) {
            ProviderInfo filterPi = filter.provider.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ProviderInfo destPi = dest.get((int)i).providerInfo;
                if (destPi.name != filterPi.name || destPi.packageName != filterPi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ProviderIntentInfo[] newArray(int size) {
            return new PackageParser.ProviderIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ProviderIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.provider.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ProviderIntentInfo info) {
            return packageName.equals(info.provider.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ProviderIntentInfo filter, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            PackageParser.ProviderIntentInfo info = filter;
            if (!PackageManagerService.this.mSettings.isEnabledLPr(info.provider.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Provider provider = info.provider;
            if (PackageManagerService.this.mSafeMode && (provider.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            PackageSetting ps = (PackageSetting)provider.owner.mExtras;
            if (ps == null) {
                return null;
            }
            ProviderInfo pi = PackageParser.generateProviderInfo(provider, this.mFlags, ps.readUserState(userId), userId);
            if (pi == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.providerInfo = pi;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = provider.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = PackageManagerService.isSystemApp(res.providerInfo.applicationInfo);
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ProviderIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.provider)));
            out.print(' ');
            filter.provider.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ServiceIntentResolver
    extends IntentResolver<PackageParser.ServiceIntentInfo, ResolveInfo> {
        private final HashMap<ComponentName, PackageParser.Service> mServices = new HashMap();
        private int mFlags;

        private ServiceIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Service> packageServices, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageServices == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageServices.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageServices.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ServiceIntentInfo[] array2 = new PackageParser.ServiceIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addService(PackageParser.Service s) {
            this.mServices.put(s.getComponentName(), s);
            int NI = s.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Service " + s.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeService(PackageParser.Service s) {
            this.mServices.remove(s.getComponentName());
            int NI = s.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ServiceIntentInfo filter, List<ResolveInfo> dest) {
            ServiceInfo filterSi = filter.service.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ServiceInfo destAi = dest.get((int)i).serviceInfo;
                if (destAi.name != filterSi.name || destAi.packageName != filterSi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ServiceIntentInfo[] newArray(int size) {
            return new PackageParser.ServiceIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ServiceIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.service.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ServiceIntentInfo info) {
            return packageName.equals(info.service.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ServiceIntentInfo filter, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            PackageParser.ServiceIntentInfo info = filter;
            if (!PackageManagerService.this.mSettings.isEnabledLPr(info.service.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Service service = info.service;
            if (PackageManagerService.this.mSafeMode && (service.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            PackageSetting ps = (PackageSetting)service.owner.mExtras;
            if (ps == null) {
                return null;
            }
            ServiceInfo si = PackageParser.generateServiceInfo(service, this.mFlags, ps.readUserState(userId), userId);
            if (si == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.serviceInfo = si;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = service.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = PackageManagerService.isSystemApp(res.serviceInfo.applicationInfo);
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ServiceIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.service)));
            out.print(' ');
            filter.service.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ActivityIntentResolver
    extends IntentResolver<PackageParser.ActivityIntentInfo, ResolveInfo> {
        private final HashMap<ComponentName, PackageParser.Activity> mActivities = new HashMap();
        private int mFlags;

        ActivityIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Activity> packageActivities, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageActivities == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageActivities.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageActivities.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ActivityIntentInfo[] array2 = new PackageParser.ActivityIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addActivity(PackageParser.Activity a, String type) {
            boolean systemApp = PackageManagerService.isSystemApp(a.info.applicationInfo);
            this.mActivities.put(a.getComponentName(), a);
            int NI = a.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                if (!systemApp && intent.getPriority() > 0 && "activity".equals(type)) {
                    intent.setPriority(0);
                    Log.w(PackageManagerService.TAG, "Package " + a.info.applicationInfo.packageName + " has activity " + a.className + " with priority > 0, forcing to 0");
                }
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Activity " + a.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeActivity(PackageParser.Activity a, String type) {
            this.mActivities.remove(a.getComponentName());
            int NI = a.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ActivityIntentInfo filter, List<ResolveInfo> dest) {
            ActivityInfo filterAi = filter.activity.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ActivityInfo destAi = dest.get((int)i).activityInfo;
                if (destAi.name != filterAi.name || destAi.packageName != filterAi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ActivityIntentInfo[] newArray(int size) {
            return new PackageParser.ActivityIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ActivityIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.activity.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ActivityIntentInfo info) {
            return packageName.equals(info.activity.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ActivityIntentInfo info, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (!PackageManagerService.this.mSettings.isEnabledLPr(info.activity.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Activity activity = info.activity;
            if (PackageManagerService.this.mSafeMode && (activity.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            PackageSetting ps = (PackageSetting)activity.owner.mExtras;
            if (ps == null) {
                return null;
            }
            ActivityInfo ai = PackageParser.generateActivityInfo(activity, this.mFlags, ps.readUserState(userId), userId);
            if (ai == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.activityInfo = ai;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = info;
            }
            res.priority = info.getPriority();
            res.preferredOrder = activity.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = PackageManagerService.isSystemApp(res.activityInfo.applicationInfo);
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ActivityIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.activity)));
            out.print(' ');
            filter.activity.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }
    }

    class PackageHandler
    extends Handler {
        private boolean mBound;
        final ArrayList<HandlerParams> mPendingInstalls;

        private boolean connectToService() {
            Intent service = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
            Process.setThreadPriority(0);
            if (PackageManagerService.this.mContext.bindServiceAsUser(service, PackageManagerService.this.mDefContainerConn, 1, UserHandle.OWNER)) {
                Process.setThreadPriority(10);
                this.mBound = true;
                return true;
            }
            Process.setThreadPriority(10);
            return false;
        }

        private void disconnectService() {
            PackageManagerService.this.mContainerService = null;
            this.mBound = false;
            Process.setThreadPriority(0);
            PackageManagerService.this.mContext.unbindService(PackageManagerService.this.mDefContainerConn);
            Process.setThreadPriority(10);
        }

        PackageHandler(Looper looper) {
            super(looper);
            this.mBound = false;
            this.mPendingInstalls = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            try {
                this.doHandleMessage(msg);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Process.setThreadPriority(10);
                throw throwable;
            }
            Process.setThreadPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doHandleMessage(Message msg) {
            switch (msg.what) {
                case 5: {
                    HandlerParams params = (HandlerParams)msg.obj;
                    int idx = this.mPendingInstalls.size();
                    if (!this.mBound) {
                        if (!this.connectToService()) {
                            Slog.e(PackageManagerService.TAG, "Failed to bind to media container service");
                            params.serviceError();
                            return;
                        }
                        this.mPendingInstalls.add(idx, params);
                        break;
                    }
                    this.mPendingInstalls.add(idx, params);
                    if (idx != 0) break;
                    PackageManagerService.this.mHandler.sendEmptyMessage(3);
                    break;
                }
                case 3: {
                    if (msg.obj != null) {
                        PackageManagerService.this.mContainerService = (IMediaContainerService)msg.obj;
                    }
                    if (PackageManagerService.this.mContainerService == null) {
                        Slog.e(PackageManagerService.TAG, "Cannot bind to media container service");
                        for (HandlerParams params : this.mPendingInstalls) {
                            params.serviceError();
                        }
                        this.mPendingInstalls.clear();
                        break;
                    }
                    if (this.mPendingInstalls.size() > 0) {
                        HandlerParams params = this.mPendingInstalls.get(0);
                        if (params == null || !params.startCopy()) break;
                        if (this.mPendingInstalls.size() > 0) {
                            this.mPendingInstalls.remove(0);
                        }
                        if (this.mPendingInstalls.size() == 0) {
                            if (!this.mBound) break;
                            this.removeMessages(6);
                            Message ubmsg = this.obtainMessage(6);
                            this.sendMessageDelayed(ubmsg, 10000L);
                            break;
                        }
                        PackageManagerService.this.mHandler.sendEmptyMessage(3);
                        break;
                    }
                    Slog.w(PackageManagerService.TAG, "Empty queue");
                    break;
                }
                case 10: {
                    if (this.mPendingInstalls.size() <= 0) break;
                    if (this.mBound) {
                        this.disconnectService();
                    }
                    if (this.connectToService()) break;
                    Slog.e(PackageManagerService.TAG, "Failed to bind to media container service");
                    for (HandlerParams params : this.mPendingInstalls) {
                        params.serviceError();
                    }
                    this.mPendingInstalls.clear();
                    break;
                }
                case 6: {
                    if (this.mPendingInstalls.size() == 0 && PackageManagerService.this.mPendingVerification.size() == 0) {
                        if (!this.mBound) break;
                        this.disconnectService();
                        break;
                    }
                    if (this.mPendingInstalls.size() <= 0) break;
                    PackageManagerService.this.mHandler.sendEmptyMessage(3);
                    break;
                }
                case 11: {
                    this.mPendingInstalls.remove(0);
                    break;
                }
                case 1: {
                    int[] uids;
                    ArrayList[] components;
                    String[] packages;
                    int size = 0;
                    Process.setThreadPriority(0);
                    HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
                    synchronized (hashMap) {
                        if (PackageManagerService.this.mPendingBroadcasts == null) {
                            return;
                        }
                        size = PackageManagerService.this.mPendingBroadcasts.size();
                        if (size <= 0) {
                            return;
                        }
                        packages = new String[size];
                        components = new ArrayList[size];
                        uids = new int[size];
                        int i = 0;
                        for (int n = 0; n < PackageManagerService.this.mPendingBroadcasts.userIdCount(); ++n) {
                            int packageUserId = PackageManagerService.this.mPendingBroadcasts.userIdAt(n);
                            Iterator<Map.Entry<String, ArrayList<String>>> it = PackageManagerService.this.mPendingBroadcasts.packagesForUserId(packageUserId).entrySet().iterator();
                            while (it.hasNext() && i < size) {
                                Map.Entry<String, ArrayList<String>> ent = it.next();
                                packages[i] = ent.getKey();
                                components[i] = ent.getValue();
                                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(ent.getKey());
                                uids[i] = ps != null ? UserHandle.getUid(packageUserId, ps.appId) : -1;
                                ++i;
                            }
                        }
                        size = i;
                        PackageManagerService.this.mPendingBroadcasts.clear();
                    }
                    for (int i = 0; i < size; ++i) {
                        PackageManagerService.this.sendPackageChangedBroadcast(packages[i], true, components[i], uids[i]);
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 7: {
                    Process.setThreadPriority(0);
                    String packageName = (String)msg.obj;
                    int userId = msg.arg1;
                    boolean andCode = msg.arg2 != 0;
                    HashMap<String, PackageParser.Package> uids = PackageManagerService.this.mPackages;
                    synchronized (uids) {
                        if (userId == -1) {
                            int[] users;
                            for (int user : users = sUserManager.getUserIds()) {
                                PackageManagerService.this.mSettings.addPackageToCleanLPw(new PackageCleanItem(user, packageName, andCode));
                            }
                        } else {
                            PackageManagerService.this.mSettings.addPackageToCleanLPw(new PackageCleanItem(userId, packageName, andCode));
                        }
                    }
                    Process.setThreadPriority(10);
                    PackageManagerService.this.startCleaningPackages();
                    break;
                }
                case 9: {
                    PostInstallData data = PackageManagerService.this.mRunningInstalls.get(msg.arg1);
                    PackageManagerService.this.mRunningInstalls.delete(msg.arg1);
                    boolean deleteOld = false;
                    if (data != null) {
                        Object extras;
                        InstallArgs args = data.args;
                        PackageInstalledInfo res = data.res;
                        if (res.returnCode == 1) {
                            boolean update;
                            int[] firstUsers;
                            res.removedInfo.sendBroadcast(false, true, false);
                            extras = new Bundle(1);
                            ((Bundle)extras).putInt("android.intent.extra.UID", res.uid);
                            int[] updateUsers = new int[]{};
                            if (res.origUsers == null || res.origUsers.length == 0) {
                                firstUsers = res.newUsers;
                            } else {
                                firstUsers = new int[]{};
                                for (int i = 0; i < res.newUsers.length; ++i) {
                                    int user = res.newUsers[i];
                                    boolean isNew = true;
                                    for (int j = 0; j < res.origUsers.length; ++j) {
                                        if (res.origUsers[j] != user) continue;
                                        isNew = false;
                                        break;
                                    }
                                    if (isNew) {
                                        int[] newFirst = new int[firstUsers.length + 1];
                                        System.arraycopy(firstUsers, 0, newFirst, 0, firstUsers.length);
                                        newFirst[firstUsers.length] = user;
                                        firstUsers = newFirst;
                                        continue;
                                    }
                                    int[] newUpdate = new int[updateUsers.length + 1];
                                    System.arraycopy(updateUsers, 0, newUpdate, 0, updateUsers.length);
                                    newUpdate[updateUsers.length] = user;
                                    updateUsers = newUpdate;
                                }
                            }
                            PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", res.pkg.applicationInfo.packageName, (Bundle)extras, null, null, firstUsers);
                            boolean bl = update = res.removedInfo.removedPackage != null;
                            if (update) {
                                ((Bundle)extras).putBoolean("android.intent.extra.REPLACING", true);
                            }
                            PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", res.pkg.applicationInfo.packageName, (Bundle)extras, null, null, updateUsers);
                            if (update) {
                                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", res.pkg.applicationInfo.packageName, (Bundle)extras, null, null, updateUsers);
                                PackageManagerService.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, res.pkg.applicationInfo.packageName, null, updateUsers);
                                if (PackageManagerService.isForwardLocked(res.pkg) || PackageManagerService.isExternal(res.pkg)) {
                                    int[] uidArray = new int[]{res.pkg.applicationInfo.uid};
                                    ArrayList<String> pkgList = new ArrayList<String>(1);
                                    pkgList.add(res.pkg.applicationInfo.packageName);
                                    PackageManagerService.this.sendResourcesChangedBroadcast(true, false, pkgList, uidArray, null);
                                }
                            }
                            if (res.removedInfo.args != null) {
                                deleteOld = true;
                            }
                            EventLog.writeEvent(3110, PackageManagerService.this.getUnknownSourcesSettings());
                        }
                        Runtime.getRuntime().gc();
                        if (deleteOld) {
                            extras = PackageManagerService.this.mInstallLock;
                            synchronized (extras) {
                                res.removedInfo.args.doPostDeleteLI(true);
                            }
                        }
                        if (args.observer == null) break;
                        try {
                            args.observer.packageInstalled(res.name, res.returnCode);
                        }
                        catch (RemoteException e) {
                            Slog.i(PackageManagerService.TAG, "Observer no longer exists.");
                        }
                        break;
                    }
                    Slog.e(PackageManagerService.TAG, "Bogus post-install token " + msg.arg1);
                    break;
                }
                case 12: {
                    boolean doGc;
                    boolean reportStatus = msg.arg1 == 1;
                    boolean bl = doGc = msg.arg2 == 1;
                    if (doGc) {
                        Runtime.getRuntime().gc();
                    }
                    if (msg.obj != null) {
                        Set args = (Set)msg.obj;
                        PackageManagerService.this.unloadAllContainers(args);
                    }
                    if (!reportStatus) break;
                    try {
                        PackageHelper.getMountService().finishMediaUpdate();
                    }
                    catch (RemoteException e) {
                        Log.e(PackageManagerService.TAG, "MountService not running?");
                    }
                    break;
                }
                case 13: {
                    Process.setThreadPriority(0);
                    HashMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(13);
                        this.removeMessages(14);
                        PackageManagerService.this.mSettings.writeLPr();
                        PackageManagerService.this.mDirtyUsers.clear();
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 14: {
                    Process.setThreadPriority(0);
                    HashMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(14);
                        Iterator i$ = PackageManagerService.this.mDirtyUsers.iterator();
                        while (i$.hasNext()) {
                            int userId = (Integer)i$.next();
                            PackageManagerService.this.mSettings.writePackageRestrictionsLPr(userId);
                        }
                        PackageManagerService.this.mDirtyUsers.clear();
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 16: {
                    int verificationId = msg.arg1;
                    PackageVerificationState state = PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null || state.timeoutExtended()) break;
                    InstallArgs args = state.getInstallArgs();
                    Slog.i(PackageManagerService.TAG, "Verification timed out for " + args.packageURI.toString());
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    int ret = -22;
                    if (PackageManagerService.this.getDefaultVerificationResponse() == 1) {
                        Slog.i(PackageManagerService.TAG, "Continuing with installation of " + args.packageURI.toString());
                        state.setVerifierResponse(Binder.getCallingUid(), 2);
                        PackageManagerService.this.broadcastPackageVerified(verificationId, args.packageURI, 1, state.getInstallArgs().getUser());
                        try {
                            ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                        }
                        catch (RemoteException e) {
                            Slog.e(PackageManagerService.TAG, "Could not contact the ContainerService");
                        }
                    } else {
                        PackageManagerService.this.broadcastPackageVerified(verificationId, args.packageURI, -1, state.getInstallArgs().getUser());
                    }
                    PackageManagerService.this.processPendingInstall(args, ret);
                    PackageManagerService.this.mHandler.sendEmptyMessage(6);
                    break;
                }
                case 15: {
                    int ret;
                    int verificationId = msg.arg1;
                    PackageVerificationState state = PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null) {
                        Slog.w(PackageManagerService.TAG, "Invalid verification token " + verificationId + " received");
                        break;
                    }
                    PackageVerificationResponse response = (PackageVerificationResponse)msg.obj;
                    state.setVerifierResponse(response.callerUid, response.code);
                    if (!state.isVerificationComplete()) break;
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    InstallArgs args = state.getInstallArgs();
                    if (state.isInstallAllowed()) {
                        ret = -110;
                        PackageManagerService.this.broadcastPackageVerified(verificationId, args.packageURI, response.code, state.getInstallArgs().getUser());
                        try {
                            ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                        }
                        catch (RemoteException e) {
                            Slog.e(PackageManagerService.TAG, "Could not contact the ContainerService");
                        }
                    } else {
                        ret = -22;
                    }
                    PackageManagerService.this.processPendingInstall(args, ret);
                    PackageManagerService.this.mHandler.sendEmptyMessage(6);
                    break;
                }
            }
        }
    }

    class PostInstallData {
        public InstallArgs args;
        public PackageInstalledInfo res;

        PostInstallData(InstallArgs _a, PackageInstalledInfo _r) {
            this.args = _a;
            this.res = _r;
        }
    }

    class DefaultContainerConnection
    implements ServiceConnection {
        DefaultContainerConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            IMediaContainerService imcs = IMediaContainerService.Stub.asInterface(service);
            PackageManagerService.this.mHandler.sendMessage(PackageManagerService.this.mHandler.obtainMessage(3, imcs));
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PendingPackageBroadcasts {
        final SparseArray<HashMap<String, ArrayList<String>>> mUidMap = new SparseArray(2);

        public ArrayList<String> get(int userId, String packageName) {
            HashMap<String, ArrayList<String>> packages = this.getOrAllocate(userId);
            return packages.get(packageName);
        }

        public void put(int userId, String packageName, ArrayList<String> components) {
            HashMap<String, ArrayList<String>> packages = this.getOrAllocate(userId);
            packages.put(packageName, components);
        }

        public void remove(int userId, String packageName) {
            HashMap<String, ArrayList<String>> packages = this.mUidMap.get(userId);
            if (packages != null) {
                packages.remove(packageName);
            }
        }

        public void remove(int userId) {
            this.mUidMap.remove(userId);
        }

        public int userIdCount() {
            return this.mUidMap.size();
        }

        public int userIdAt(int n) {
            return this.mUidMap.keyAt(n);
        }

        public HashMap<String, ArrayList<String>> packagesForUserId(int userId) {
            return this.mUidMap.get(userId);
        }

        public int size() {
            int num = 0;
            for (int i = 0; i < this.mUidMap.size(); ++i) {
                num += this.mUidMap.valueAt(i).size();
            }
            return num;
        }

        public void clear() {
            this.mUidMap.clear();
        }

        private HashMap<String, ArrayList<String>> getOrAllocate(int userId) {
            HashMap<String, ArrayList<String>> map = this.mUidMap.get(userId);
            if (map == null) {
                map = new HashMap();
                this.mUidMap.put(userId, map);
            }
            return map;
        }
    }

    static final class SharedLibraryEntry {
        final String path;
        final String apk;

        SharedLibraryEntry(String _path, String _apk) {
            this.path = _path;
            this.apk = _apk;
        }
    }
}

