/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.print;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.print.IPrintSpooler;
import android.print.IPrintSpoolerCallbacks;
import android.print.IPrintSpoolerClient;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.util.Slog;
import android.util.TimedRemoteCaller;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.TimeoutException;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemotePrintSpooler {
    private static final String LOG_TAG = "RemotePrintSpooler";
    private static final boolean DEBUG = false;
    private static final long BIND_SPOOLER_SERVICE_TIMEOUT = 10000L;
    private final Object mLock = new Object();
    private final GetPrintJobInfosCaller mGetPrintJobInfosCaller = new GetPrintJobInfosCaller();
    private final GetPrintJobInfoCaller mGetPrintJobInfoCaller = new GetPrintJobInfoCaller();
    private final SetPrintJobStateCaller mSetPrintJobStatusCaller = new SetPrintJobStateCaller();
    private final SetPrintJobTagCaller mSetPrintJobTagCaller = new SetPrintJobTagCaller();
    private final ServiceConnection mServiceConnection = new MyServiceConnection();
    private final Context mContext;
    private final UserHandle mUserHandle;
    private final PrintSpoolerClient mClient;
    private final Intent mIntent;
    private final PrintSpoolerCallbacks mCallbacks;
    private IPrintSpooler mRemoteInstance;
    private boolean mDestroyed;
    private boolean mCanUnbind;

    public RemotePrintSpooler(Context context, int userId, PrintSpoolerCallbacks callbacks) {
        this.mContext = context;
        this.mUserHandle = new UserHandle(userId);
        this.mCallbacks = callbacks;
        this.mClient = new PrintSpoolerClient(this);
        this.mIntent = new Intent();
        this.mIntent.setComponent(new ComponentName("com.android.printspooler", "com.android.printspooler.PrintSpoolerService"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List<PrintJobInfo> getPrintJobInfos(ComponentName componentName, int state, int appId) {
        Object object;
        this.throwIfCalledOnMainThread();
        List<PrintJobInfo> list = this.mLock;
        synchronized (list) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            try {
                list = this.mGetPrintJobInfosCaller.getPrintJobInfos(this.getRemoteInstanceLazy(), componentName, state, appId);
                Object var7_7 = null;
                object = this.mLock;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error getting print jobs.", re);
                Object var7_8 = null;
                Object object2 = this.mLock;
                synchronized (object2) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return null;
                }
            }
            catch (TimeoutException te) {
                Slog.e(LOG_TAG, "Error getting print jobs.", te);
                Object var7_9 = null;
                Object object3 = this.mLock;
                synchronized (object3) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            Object object4 = this.mLock;
            synchronized (object4) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
                throw throwable;
            }
        }
        synchronized (object) {
            this.mCanUnbind = true;
            this.mLock.notifyAll();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void createPrintJob(PrintJobInfo printJob) {
        Object object;
        this.throwIfCalledOnMainThread();
        Object object2 = this.mLock;
        synchronized (object2) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            try {
                this.getRemoteInstanceLazy().createPrintJob(printJob);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error creating print job.", re);
                Object var5_6 = null;
                Object object3 = this.mLock;
                synchronized (object3) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return;
                }
            }
            catch (TimeoutException te) {
                Slog.e(LOG_TAG, "Error creating print job.", te);
                Object var5_7 = null;
                Object object4 = this.mLock;
                synchronized (object4) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return;
                }
            }
            Object var5_5 = null;
            object = this.mLock;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            Object object5 = this.mLock;
            synchronized (object5) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
                throw throwable;
            }
        }
        synchronized (object) {
            this.mCanUnbind = true;
            this.mLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writePrintJobData(ParcelFileDescriptor fd, PrintJobId printJobId) {
        this.throwIfCalledOnMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            try {
                this.getRemoteInstanceLazy().writePrintJobData(fd, printJobId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error writing print job data.", re);
                Object var6_7 = null;
                IoUtils.closeQuietly(fd);
                Object object3 = this.mLock;
                synchronized (object3) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return;
                }
            }
            catch (TimeoutException te) {
                Slog.e(LOG_TAG, "Error writing print job data.", te);
                Object var6_8 = null;
                IoUtils.closeQuietly(fd);
                Object object4 = this.mLock;
                synchronized (object4) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return;
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            IoUtils.closeQuietly(fd);
            Object object5 = this.mLock;
            synchronized (object5) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
                throw throwable;
            }
        }
        IoUtils.closeQuietly(fd);
        Object object2 = this.mLock;
        synchronized (object2) {
            this.mCanUnbind = true;
            this.mLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final PrintJobInfo getPrintJobInfo(PrintJobId printJobId, int appId) {
        Object object;
        this.throwIfCalledOnMainThread();
        Object object2 = this.mLock;
        synchronized (object2) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            try {
                object2 = this.mGetPrintJobInfoCaller.getPrintJobInfo(this.getRemoteInstanceLazy(), printJobId, appId);
                Object var6_6 = null;
                object = this.mLock;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error getting print job info.", re);
                Object var6_7 = null;
                Object object3 = this.mLock;
                synchronized (object3) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return null;
                }
            }
            catch (TimeoutException te) {
                Slog.e(LOG_TAG, "Error getting print job info.", te);
                Object var6_8 = null;
                Object object4 = this.mLock;
                synchronized (object4) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Object object5 = this.mLock;
            synchronized (object5) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
                throw throwable;
            }
        }
        synchronized (object) {
            this.mCanUnbind = true;
            this.mLock.notifyAll();
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean setPrintJobState(PrintJobId printJobId, int state, String error) {
        Object object;
        boolean bl;
        this.throwIfCalledOnMainThread();
        Object object2 = this.mLock;
        synchronized (object2) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            try {
                bl = this.mSetPrintJobStatusCaller.setPrintJobState(this.getRemoteInstanceLazy(), printJobId, state, error);
                Object var7_8 = null;
                object = this.mLock;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error setting print job state.", re);
                Object var7_9 = null;
                Object object3 = this.mLock;
                synchronized (object3) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return false;
                }
            }
            catch (TimeoutException te) {
                Slog.e(LOG_TAG, "Error setting print job state.", te);
                Object var7_10 = null;
                Object object4 = this.mLock;
                synchronized (object4) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            Object object5 = this.mLock;
            synchronized (object5) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
                throw throwable;
            }
        }
        synchronized (object) {
            this.mCanUnbind = true;
            this.mLock.notifyAll();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean setPrintJobTag(PrintJobId printJobId, String tag) {
        Object object;
        boolean bl;
        this.throwIfCalledOnMainThread();
        Object object2 = this.mLock;
        synchronized (object2) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            try {
                bl = this.mSetPrintJobTagCaller.setPrintJobTag(this.getRemoteInstanceLazy(), printJobId, tag);
                Object var6_7 = null;
                object = this.mLock;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error setting print job tag.", re);
                Object var6_8 = null;
                Object object3 = this.mLock;
                synchronized (object3) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return false;
                }
            }
            catch (TimeoutException te) {
                Slog.e(LOG_TAG, "Error setting print job tag.", te);
                Object var6_9 = null;
                Object object4 = this.mLock;
                synchronized (object4) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            Object object5 = this.mLock;
            synchronized (object5) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
                throw throwable;
            }
        }
        synchronized (object) {
            this.mCanUnbind = true;
            this.mLock.notifyAll();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setPrintJobCancelling(PrintJobId printJobId, boolean cancelling) {
        Object object;
        this.throwIfCalledOnMainThread();
        Object object2 = this.mLock;
        synchronized (object2) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            try {
                this.getRemoteInstanceLazy().setPrintJobCancelling(printJobId, cancelling);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error setting print job cancelling.", re);
                Object var6_7 = null;
                Object object3 = this.mLock;
                synchronized (object3) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return;
                }
            }
            catch (TimeoutException te) {
                Slog.e(LOG_TAG, "Error setting print job cancelling.", te);
                Object var6_8 = null;
                Object object4 = this.mLock;
                synchronized (object4) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return;
                }
            }
            Object var6_6 = null;
            object = this.mLock;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Object object5 = this.mLock;
            synchronized (object5) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
                throw throwable;
            }
        }
        synchronized (object) {
            this.mCanUnbind = true;
            this.mLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void removeObsoletePrintJobs() {
        Object object;
        this.throwIfCalledOnMainThread();
        Object object2 = this.mLock;
        synchronized (object2) {
            this.throwIfDestroyedLocked();
            this.mCanUnbind = false;
        }
        try {
            try {
                this.getRemoteInstanceLazy().removeObsoletePrintJobs();
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error removing obsolete print jobs .", re);
                Object var4_5 = null;
                Object object3 = this.mLock;
                synchronized (object3) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return;
                }
            }
            catch (TimeoutException te) {
                Slog.e(LOG_TAG, "Error removing obsolete print jobs .", te);
                Object var4_6 = null;
                Object object4 = this.mLock;
                synchronized (object4) {
                    this.mCanUnbind = true;
                    this.mLock.notifyAll();
                    return;
                }
            }
            Object var4_4 = null;
            object = this.mLock;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            Object object5 = this.mLock;
            synchronized (object5) {
                this.mCanUnbind = true;
                this.mLock.notifyAll();
                throw throwable;
            }
        }
        synchronized (object) {
            this.mCanUnbind = true;
            this.mLock.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        this.throwIfCalledOnMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.unbindLocked();
            this.mDestroyed = true;
            this.mCanUnbind = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.append(prefix).append("destroyed=").append(String.valueOf(this.mDestroyed)).println();
            pw.append(prefix).append("bound=").append(this.mRemoteInstance != null ? "true" : "false").println();
            pw.flush();
            try {
                this.getRemoteInstanceLazy().asBinder().dump(fd, new String[]{prefix});
            }
            catch (TimeoutException te) {
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAllPrintJobsHandled() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            this.unbindLocked();
        }
    }

    private void onPrintJobStateChanged(PrintJobInfo printJob) {
        this.mCallbacks.onPrintJobStateChanged(printJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPrintSpooler getRemoteInstanceLazy() throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRemoteInstance != null) {
                return this.mRemoteInstance;
            }
            this.bindLocked();
            return this.mRemoteInstance;
        }
    }

    private void bindLocked() throws TimeoutException {
        if (this.mRemoteInstance != null) {
            return;
        }
        this.mContext.bindServiceAsUser(this.mIntent, this.mServiceConnection, 1, this.mUserHandle);
        long startMillis = SystemClock.uptimeMillis();
        while (this.mRemoteInstance == null) {
            long elapsedMillis = SystemClock.uptimeMillis() - startMillis;
            long remainingMillis = 10000L - elapsedMillis;
            if (remainingMillis <= 0L) {
                throw new TimeoutException("Cannot get spooler!");
            }
            try {
                this.mLock.wait(remainingMillis);
            }
            catch (InterruptedException ie) {}
        }
        this.mCanUnbind = true;
        this.mLock.notifyAll();
    }

    private void unbindLocked() {
        if (this.mRemoteInstance == null) {
            return;
        }
        while (true) {
            if (this.mCanUnbind) {
                this.clearClientLocked();
                this.mRemoteInstance = null;
                this.mContext.unbindService(this.mServiceConnection);
                return;
            }
            try {
                this.mLock.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void setClientLocked() {
        try {
            this.mRemoteInstance.setClient(this.mClient);
        }
        catch (RemoteException re) {
            Slog.d(LOG_TAG, "Error setting print spooler client", re);
        }
    }

    private void clearClientLocked() {
        try {
            this.mRemoteInstance.setClient(null);
        }
        catch (RemoteException re) {
            Slog.d(LOG_TAG, "Error clearing print spooler client", re);
        }
    }

    private void throwIfDestroyedLocked() {
        if (this.mDestroyed) {
            throw new IllegalStateException("Cannot interact with a destroyed instance.");
        }
    }

    private void throwIfCalledOnMainThread() {
        if (Thread.currentThread() == this.mContext.getMainLooper().getThread()) {
            throw new RuntimeException("Cannot invoke on the main thread");
        }
    }

    private static final class PrintSpoolerClient
    extends IPrintSpoolerClient.Stub {
        private final WeakReference<RemotePrintSpooler> mWeakSpooler;

        public PrintSpoolerClient(RemotePrintSpooler spooler) {
            this.mWeakSpooler = new WeakReference<RemotePrintSpooler>(spooler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPrintJobQueued(PrintJobInfo printJob) {
            RemotePrintSpooler spooler = (RemotePrintSpooler)this.mWeakSpooler.get();
            if (spooler != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    spooler.mCallbacks.onPrintJobQueued(printJob);
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    Binder.restoreCallingIdentity(identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAllPrintJobsForServiceHandled(ComponentName printService) {
            RemotePrintSpooler spooler = (RemotePrintSpooler)this.mWeakSpooler.get();
            if (spooler != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    spooler.mCallbacks.onAllPrintJobsForServiceHandled(printService);
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    Binder.restoreCallingIdentity(identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAllPrintJobsHandled() {
            RemotePrintSpooler spooler = (RemotePrintSpooler)this.mWeakSpooler.get();
            if (spooler != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    spooler.onAllPrintJobsHandled();
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    Binder.restoreCallingIdentity(identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPrintJobStateChanged(PrintJobInfo printJob) {
            RemotePrintSpooler spooler = (RemotePrintSpooler)this.mWeakSpooler.get();
            if (spooler != null) {
                long identity = Binder.clearCallingIdentity();
                try {
                    spooler.onPrintJobStateChanged(printJob);
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    Binder.restoreCallingIdentity(identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
                {
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BasePrintSpoolerServiceCallbacks
    extends IPrintSpoolerCallbacks.Stub {
        private BasePrintSpoolerServiceCallbacks() {
        }

        @Override
        public void onGetPrintJobInfosResult(List<PrintJobInfo> printJobIds, int sequence) {
        }

        @Override
        public void onGetPrintJobInfoResult(PrintJobInfo printJob, int sequence) {
        }

        @Override
        public void onCancelPrintJobResult(boolean canceled, int sequence) {
        }

        @Override
        public void onSetPrintJobStateResult(boolean success, int sequece) {
        }

        @Override
        public void onSetPrintJobTagResult(boolean success, int sequence) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SetPrintJobTagCaller
    extends TimedRemoteCaller<Boolean> {
        private final IPrintSpoolerCallbacks mCallback = new BasePrintSpoolerServiceCallbacks(){

            public void onSetPrintJobTagResult(boolean success, int sequence) {
                SetPrintJobTagCaller.this.onRemoteMethodResult(success, sequence);
            }
        };

        public SetPrintJobTagCaller() {
            super(5000L);
        }

        public boolean setPrintJobTag(IPrintSpooler target, PrintJobId printJobId, String tag) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            target.setPrintJobTag(printJobId, tag, this.mCallback, sequence);
            return (Boolean)this.getResultTimed(sequence);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SetPrintJobStateCaller
    extends TimedRemoteCaller<Boolean> {
        private final IPrintSpoolerCallbacks mCallback = new BasePrintSpoolerServiceCallbacks(){

            public void onSetPrintJobStateResult(boolean success, int sequence) {
                SetPrintJobStateCaller.this.onRemoteMethodResult(success, sequence);
            }
        };

        public SetPrintJobStateCaller() {
            super(5000L);
        }

        public boolean setPrintJobState(IPrintSpooler target, PrintJobId printJobId, int status, String error) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            target.setPrintJobState(printJobId, status, error, this.mCallback, sequence);
            return (Boolean)this.getResultTimed(sequence);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetPrintJobInfoCaller
    extends TimedRemoteCaller<PrintJobInfo> {
        private final IPrintSpoolerCallbacks mCallback = new BasePrintSpoolerServiceCallbacks(){

            public void onGetPrintJobInfoResult(PrintJobInfo printJob, int sequence) {
                GetPrintJobInfoCaller.this.onRemoteMethodResult(printJob, sequence);
            }
        };

        public GetPrintJobInfoCaller() {
            super(5000L);
        }

        public PrintJobInfo getPrintJobInfo(IPrintSpooler target, PrintJobId printJobId, int appId) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            target.getPrintJobInfo(printJobId, this.mCallback, appId, sequence);
            return (PrintJobInfo)this.getResultTimed(sequence);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetPrintJobInfosCaller
    extends TimedRemoteCaller<List<PrintJobInfo>> {
        private final IPrintSpoolerCallbacks mCallback = new BasePrintSpoolerServiceCallbacks(){

            @Override
            public void onGetPrintJobInfosResult(List<PrintJobInfo> printJobs, int sequence) {
                GetPrintJobInfosCaller.this.onRemoteMethodResult(printJobs, sequence);
            }
        };

        public GetPrintJobInfosCaller() {
            super(5000L);
        }

        public List<PrintJobInfo> getPrintJobInfos(IPrintSpooler target, ComponentName componentName, int state, int appId) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            target.getPrintJobInfos(this.mCallback, componentName, state, appId, sequence);
            return (List)this.getResultTimed(sequence);
        }
    }

    private final class MyServiceConnection
    implements ServiceConnection {
        private MyServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = RemotePrintSpooler.this.mLock;
            synchronized (object) {
                RemotePrintSpooler.this.mRemoteInstance = IPrintSpooler.Stub.asInterface(service);
                RemotePrintSpooler.this.setClientLocked();
                RemotePrintSpooler.this.mLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName name) {
            Object object = RemotePrintSpooler.this.mLock;
            synchronized (object) {
                RemotePrintSpooler.this.clearClientLocked();
                RemotePrintSpooler.this.mRemoteInstance = null;
            }
        }
    }

    public static interface PrintSpoolerCallbacks {
        public void onPrintJobQueued(PrintJobInfo var1);

        public void onAllPrintJobsForServiceHandled(ComponentName var1);

        public void onPrintJobStateChanged(PrintJobInfo var1);
    }
}

