/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wifi;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiStateMachine;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.WorkSource;
import android.provider.Settings;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.wifi.WifiService;
import com.android.server.wifi.WifiSettingsStore;
import java.io.FileDescriptor;
import java.io.PrintWriter;

class WifiController
extends StateMachine {
    private static final String TAG = "WifiController";
    private static final boolean DBG = false;
    private Context mContext;
    private boolean mScreenOff;
    private boolean mDeviceIdle;
    private int mPluggedType;
    private int mStayAwakeConditions;
    private long mIdleMillis;
    private int mSleepPolicy;
    private boolean mFirstUserSignOnSeen = false;
    private AlarmManager mAlarmManager;
    private PendingIntent mIdleIntent;
    private static final int IDLE_REQUEST = 0;
    private static final long DEFAULT_IDLE_MS = 900000L;
    private static final long DEFAULT_REENABLE_DELAY_MS = 500L;
    private static final long DEFER_MARGIN_MS = 5L;
    NetworkInfo mNetworkInfo = new NetworkInfo(1, 0, "WIFI", "");
    private static final String ACTION_DEVICE_IDLE = "com.android.server.WifiManager.action.DEVICE_IDLE";
    final WifiStateMachine mWifiStateMachine;
    final WifiSettingsStore mSettingsStore;
    final WifiService.LockList mLocks;
    private final WorkSource mTmpWorkSource = new WorkSource();
    private long mReEnableDelayMillis;
    private static final int BASE = 155648;
    static final int CMD_EMERGENCY_MODE_CHANGED = 155649;
    static final int CMD_SCREEN_ON = 155650;
    static final int CMD_SCREEN_OFF = 155651;
    static final int CMD_BATTERY_CHANGED = 155652;
    static final int CMD_DEVICE_IDLE = 155653;
    static final int CMD_LOCKS_CHANGED = 155654;
    static final int CMD_SCAN_ALWAYS_MODE_CHANGED = 155655;
    static final int CMD_WIFI_TOGGLED = 155656;
    static final int CMD_AIRPLANE_TOGGLED = 155657;
    static final int CMD_SET_AP = 155658;
    static final int CMD_DEFERRED_TOGGLE = 155659;
    static final int CMD_USER_PRESENT = 155660;
    private DefaultState mDefaultState = new DefaultState();
    private StaEnabledState mStaEnabledState = new StaEnabledState();
    private ApStaDisabledState mApStaDisabledState = new ApStaDisabledState();
    private StaDisabledWithScanState mStaDisabledWithScanState = new StaDisabledWithScanState();
    private ApEnabledState mApEnabledState = new ApEnabledState();
    private DeviceActiveState mDeviceActiveState = new DeviceActiveState();
    private DeviceInactiveState mDeviceInactiveState = new DeviceInactiveState();
    private ScanOnlyLockHeldState mScanOnlyLockHeldState = new ScanOnlyLockHeldState();
    private FullLockHeldState mFullLockHeldState = new FullLockHeldState();
    private FullHighPerfLockHeldState mFullHighPerfLockHeldState = new FullHighPerfLockHeldState();
    private NoLockHeldState mNoLockHeldState = new NoLockHeldState();
    private EcmState mEcmState = new EcmState();

    WifiController(Context context, WifiService service, Looper looper) {
        super(TAG, looper);
        this.mContext = context;
        this.mWifiStateMachine = service.mWifiStateMachine;
        this.mSettingsStore = service.mSettingsStore;
        this.mLocks = service.mLocks;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent idleIntent = new Intent(ACTION_DEVICE_IDLE, null);
        this.mIdleIntent = PendingIntent.getBroadcast(this.mContext, 0, idleIntent, 0);
        this.addState(this.mDefaultState);
        this.addState(this.mApStaDisabledState, this.mDefaultState);
        this.addState(this.mStaEnabledState, this.mDefaultState);
        this.addState(this.mDeviceActiveState, this.mStaEnabledState);
        this.addState(this.mDeviceInactiveState, this.mStaEnabledState);
        this.addState(this.mScanOnlyLockHeldState, this.mDeviceInactiveState);
        this.addState(this.mFullLockHeldState, this.mDeviceInactiveState);
        this.addState(this.mFullHighPerfLockHeldState, this.mDeviceInactiveState);
        this.addState(this.mNoLockHeldState, this.mDeviceInactiveState);
        this.addState(this.mStaDisabledWithScanState, this.mDefaultState);
        this.addState(this.mApEnabledState, this.mDefaultState);
        this.addState(this.mEcmState, this.mDefaultState);
        if (this.mSettingsStore.isScanAlwaysAvailable()) {
            this.setInitialState(this.mStaDisabledWithScanState);
        } else {
            this.setInitialState(this.mApStaDisabledState);
        }
        this.setLogRecSize(100);
        this.setLogOnlyTransitions(false);
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_DEVICE_IDLE);
        filter.addAction("android.net.wifi.STATE_CHANGE");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals(WifiController.ACTION_DEVICE_IDLE)) {
                    WifiController.this.sendMessage(155653);
                } else if (action.equals("android.net.wifi.STATE_CHANGE")) {
                    WifiController.this.mNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                }
            }
        }, new IntentFilter(filter));
        this.initializeAndRegisterForSettingsChange(looper);
    }

    private void initializeAndRegisterForSettingsChange(Looper looper) {
        Handler handler = new Handler(looper);
        this.readStayAwakeConditions();
        this.registerForStayAwakeModeChange(handler);
        this.readWifiIdleTime();
        this.registerForWifiIdleTimeChange(handler);
        this.readWifiSleepPolicy();
        this.registerForWifiSleepPolicyChange(handler);
        this.readWifiReEnableDelay();
    }

    private void readStayAwakeConditions() {
        this.mStayAwakeConditions = Settings.Global.getInt(this.mContext.getContentResolver(), "stay_on_while_plugged_in", 0);
    }

    private void readWifiIdleTime() {
        this.mIdleMillis = Settings.Global.getLong(this.mContext.getContentResolver(), "wifi_idle_ms", 900000L);
    }

    private void readWifiSleepPolicy() {
        this.mSleepPolicy = Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_sleep_policy", 2);
    }

    private void readWifiReEnableDelay() {
        this.mReEnableDelayMillis = Settings.Global.getLong(this.mContext.getContentResolver(), "wifi_reenable_delay", 500L);
    }

    private void registerForStayAwakeModeChange(Handler handler) {
        ContentObserver contentObserver = new ContentObserver(handler){

            public void onChange(boolean selfChange) {
                WifiController.this.readStayAwakeConditions();
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("stay_on_while_plugged_in"), false, contentObserver);
    }

    private void registerForWifiIdleTimeChange(Handler handler) {
        ContentObserver contentObserver = new ContentObserver(handler){

            public void onChange(boolean selfChange) {
                WifiController.this.readWifiIdleTime();
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("wifi_idle_ms"), false, contentObserver);
    }

    private void registerForWifiSleepPolicyChange(Handler handler) {
        ContentObserver contentObserver = new ContentObserver(handler){

            public void onChange(boolean selfChange) {
                WifiController.this.readWifiSleepPolicy();
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("wifi_sleep_policy"), false, contentObserver);
    }

    private boolean shouldWifiStayAwake(int pluggedType) {
        if (this.mSleepPolicy == 2) {
            return true;
        }
        if (this.mSleepPolicy == 1 && pluggedType != 0) {
            return true;
        }
        return this.shouldDeviceStayAwake(pluggedType);
    }

    private boolean shouldDeviceStayAwake(int pluggedType) {
        return (this.mStayAwakeConditions & pluggedType) != 0;
    }

    private void updateBatteryWorkSource() {
        this.mTmpWorkSource.clear();
        if (this.mDeviceIdle) {
            this.mLocks.updateWorkSource(this.mTmpWorkSource);
        }
        this.mWifiStateMachine.updateBatteryWorkSource(this.mTmpWorkSource);
    }

    private void checkLocksAndTransitionWhenDeviceIdle() {
        if (this.mLocks.hasLocks()) {
            switch (this.mLocks.getStrongestLockMode()) {
                case 1: {
                    this.transitionTo(this.mFullLockHeldState);
                    break;
                }
                case 3: {
                    this.transitionTo(this.mFullHighPerfLockHeldState);
                    break;
                }
                case 2: {
                    this.transitionTo(this.mScanOnlyLockHeldState);
                    break;
                }
                default: {
                    this.loge("Illegal lock " + this.mLocks.getStrongestLockMode());
                    break;
                }
            }
        } else if (this.mSettingsStore.isScanAlwaysAvailable()) {
            this.transitionTo(this.mScanOnlyLockHeldState);
        } else {
            this.transitionTo(this.mNoLockHeldState);
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        pw.println("mScreenOff " + this.mScreenOff);
        pw.println("mDeviceIdle " + this.mDeviceIdle);
        pw.println("mPluggedType " + this.mPluggedType);
        pw.println("mIdleMillis " + this.mIdleMillis);
        pw.println("mSleepPolicy " + this.mSleepPolicy);
    }

    class NoLockHeldState
    extends State {
        NoLockHeldState() {
        }

        public void enter() {
            WifiController.this.mWifiStateMachine.setDriverStart(false);
        }
    }

    class FullHighPerfLockHeldState
    extends State {
        FullHighPerfLockHeldState() {
        }

        public void enter() {
            WifiController.this.mWifiStateMachine.setOperationalMode(1);
            WifiController.this.mWifiStateMachine.setDriverStart(true);
            WifiController.this.mWifiStateMachine.setHighPerfModeEnabled(true);
        }
    }

    class FullLockHeldState
    extends State {
        FullLockHeldState() {
        }

        public void enter() {
            WifiController.this.mWifiStateMachine.setOperationalMode(1);
            WifiController.this.mWifiStateMachine.setDriverStart(true);
            WifiController.this.mWifiStateMachine.setHighPerfModeEnabled(false);
        }
    }

    class ScanOnlyLockHeldState
    extends State {
        ScanOnlyLockHeldState() {
        }

        public void enter() {
            WifiController.this.mWifiStateMachine.setOperationalMode(2);
            WifiController.this.mWifiStateMachine.setDriverStart(true);
        }
    }

    class DeviceInactiveState
    extends State {
        DeviceInactiveState() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 155654: {
                    WifiController.this.checkLocksAndTransitionWhenDeviceIdle();
                    WifiController.this.updateBatteryWorkSource();
                    return true;
                }
                case 155650: {
                    WifiController.this.transitionTo(WifiController.this.mDeviceActiveState);
                    return false;
                }
            }
            return false;
        }
    }

    class DeviceActiveState
    extends State {
        DeviceActiveState() {
        }

        public void enter() {
            WifiController.this.mWifiStateMachine.setOperationalMode(1);
            WifiController.this.mWifiStateMachine.setDriverStart(true);
            WifiController.this.mWifiStateMachine.setHighPerfModeEnabled(false);
        }

        public boolean processMessage(Message msg) {
            if (msg.what == 155653) {
                WifiController.this.checkLocksAndTransitionWhenDeviceIdle();
            } else if (msg.what == 155660) {
                if (!WifiController.this.mFirstUserSignOnSeen) {
                    WifiController.this.mWifiStateMachine.reloadTlsNetworksAndReconnect();
                }
                WifiController.this.mFirstUserSignOnSeen = true;
                return true;
            }
            return false;
        }
    }

    class EcmState
    extends State {
        EcmState() {
        }

        public void enter() {
            WifiController.this.mWifiStateMachine.setSupplicantRunning(false);
        }

        public boolean processMessage(Message msg) {
            if (msg.what == 155649 && msg.arg1 == 0) {
                if (WifiController.this.mSettingsStore.isWifiToggleEnabled()) {
                    if (!WifiController.this.mDeviceIdle) {
                        WifiController.this.transitionTo(WifiController.this.mDeviceActiveState);
                    } else {
                        WifiController.this.checkLocksAndTransitionWhenDeviceIdle();
                    }
                } else if (WifiController.this.mSettingsStore.isScanAlwaysAvailable()) {
                    WifiController.this.transitionTo(WifiController.this.mStaDisabledWithScanState);
                } else {
                    WifiController.this.transitionTo(WifiController.this.mApStaDisabledState);
                }
                return true;
            }
            return false;
        }
    }

    class ApEnabledState
    extends State {
        ApEnabledState() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 155657: {
                    if (!WifiController.this.mSettingsStore.isAirplaneModeOn()) break;
                    WifiController.this.mWifiStateMachine.setHostApRunning(null, false);
                    WifiController.this.transitionTo(WifiController.this.mApStaDisabledState);
                    break;
                }
                case 155658: {
                    if (msg.arg1 != 0) break;
                    WifiController.this.mWifiStateMachine.setHostApRunning(null, false);
                    WifiController.this.transitionTo(WifiController.this.mApStaDisabledState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class StaDisabledWithScanState
    extends State {
        private int mDeferredEnableSerialNumber = 0;
        private boolean mHaveDeferredEnable = false;
        private long mDisabledTimestamp;

        StaDisabledWithScanState() {
        }

        public void enter() {
            WifiController.this.mWifiStateMachine.setSupplicantRunning(true);
            WifiController.this.mWifiStateMachine.setOperationalMode(3);
            WifiController.this.mWifiStateMachine.setDriverStart(true);
            this.mDisabledTimestamp = SystemClock.elapsedRealtime();
            ++this.mDeferredEnableSerialNumber;
            this.mHaveDeferredEnable = false;
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 155656: {
                    if (!WifiController.this.mSettingsStore.isWifiToggleEnabled()) break;
                    if (this.doDeferEnable(msg)) {
                        if (this.mHaveDeferredEnable) {
                            ++this.mDeferredEnableSerialNumber;
                        }
                        this.mHaveDeferredEnable = !this.mHaveDeferredEnable;
                        break;
                    }
                    if (!WifiController.this.mDeviceIdle) {
                        WifiController.this.transitionTo(WifiController.this.mDeviceActiveState);
                        break;
                    }
                    WifiController.this.checkLocksAndTransitionWhenDeviceIdle();
                    break;
                }
                case 155657: {
                    if (WifiController.this.mSettingsStore.isAirplaneModeOn() && !WifiController.this.mSettingsStore.isWifiToggleEnabled()) {
                        WifiController.this.transitionTo(WifiController.this.mApStaDisabledState);
                    }
                }
                case 155655: {
                    if (WifiController.this.mSettingsStore.isScanAlwaysAvailable()) break;
                    WifiController.this.transitionTo(WifiController.this.mApStaDisabledState);
                    break;
                }
                case 155658: {
                    if (msg.arg1 != 1) break;
                    WifiController.this.deferMessage(msg);
                    WifiController.this.transitionTo(WifiController.this.mApStaDisabledState);
                    break;
                }
                case 155659: {
                    if (msg.arg1 != this.mDeferredEnableSerialNumber) {
                        WifiController.this.log("DEFERRED_TOGGLE ignored due to serial mismatch");
                        break;
                    }
                    WifiController.this.logd("DEFERRED_TOGGLE handled");
                    WifiController.this.sendMessage((Message)msg.obj);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private boolean doDeferEnable(Message msg) {
            long delaySoFar = SystemClock.elapsedRealtime() - this.mDisabledTimestamp;
            if (delaySoFar >= WifiController.this.mReEnableDelayMillis) {
                return false;
            }
            WifiController.this.log("WifiController msg " + msg + " deferred for " + (WifiController.this.mReEnableDelayMillis - delaySoFar) + "ms");
            Message deferredMsg = WifiController.this.obtainMessage(155659);
            deferredMsg.obj = Message.obtain(msg);
            deferredMsg.arg1 = ++this.mDeferredEnableSerialNumber;
            WifiController.this.sendMessageDelayed(deferredMsg, WifiController.this.mReEnableDelayMillis - delaySoFar + 5L);
            return true;
        }
    }

    class StaEnabledState
    extends State {
        StaEnabledState() {
        }

        public void enter() {
            WifiController.this.mWifiStateMachine.setSupplicantRunning(true);
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 155656: {
                    if (WifiController.this.mSettingsStore.isWifiToggleEnabled()) break;
                    if (WifiController.this.mSettingsStore.isScanAlwaysAvailable()) {
                        WifiController.this.transitionTo(WifiController.this.mStaDisabledWithScanState);
                        break;
                    }
                    WifiController.this.transitionTo(WifiController.this.mApStaDisabledState);
                    break;
                }
                case 155657: {
                    if (WifiController.this.mSettingsStore.isWifiToggleEnabled()) break;
                    WifiController.this.transitionTo(WifiController.this.mApStaDisabledState);
                    break;
                }
                case 155649: {
                    if (msg.arg1 == 1) {
                        WifiController.this.transitionTo(WifiController.this.mEcmState);
                        break;
                    }
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class ApStaDisabledState
    extends State {
        private int mDeferredEnableSerialNumber = 0;
        private boolean mHaveDeferredEnable = false;
        private long mDisabledTimestamp;

        ApStaDisabledState() {
        }

        public void enter() {
            WifiController.this.mWifiStateMachine.setSupplicantRunning(false);
            this.mDisabledTimestamp = SystemClock.elapsedRealtime();
            ++this.mDeferredEnableSerialNumber;
            this.mHaveDeferredEnable = false;
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 155656: 
                case 155657: {
                    if (!WifiController.this.mSettingsStore.isWifiToggleEnabled()) break;
                    if (this.doDeferEnable(msg)) {
                        if (this.mHaveDeferredEnable) {
                            ++this.mDeferredEnableSerialNumber;
                        }
                        this.mHaveDeferredEnable = !this.mHaveDeferredEnable;
                        break;
                    }
                    if (!WifiController.this.mDeviceIdle) {
                        WifiController.this.transitionTo(WifiController.this.mDeviceActiveState);
                        break;
                    }
                    WifiController.this.checkLocksAndTransitionWhenDeviceIdle();
                    break;
                }
                case 155655: {
                    if (!WifiController.this.mSettingsStore.isScanAlwaysAvailable()) break;
                    WifiController.this.transitionTo(WifiController.this.mStaDisabledWithScanState);
                    break;
                }
                case 155658: {
                    if (msg.arg1 != 1) break;
                    WifiController.this.mWifiStateMachine.setHostApRunning((WifiConfiguration)msg.obj, true);
                    WifiController.this.transitionTo(WifiController.this.mApEnabledState);
                    break;
                }
                case 155659: {
                    if (msg.arg1 != this.mDeferredEnableSerialNumber) {
                        WifiController.this.log("DEFERRED_TOGGLE ignored due to serial mismatch");
                        break;
                    }
                    WifiController.this.log("DEFERRED_TOGGLE handled");
                    WifiController.this.sendMessage((Message)msg.obj);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private boolean doDeferEnable(Message msg) {
            long delaySoFar = SystemClock.elapsedRealtime() - this.mDisabledTimestamp;
            if (delaySoFar >= WifiController.this.mReEnableDelayMillis) {
                return false;
            }
            WifiController.this.log("WifiController msg " + msg + " deferred for " + (WifiController.this.mReEnableDelayMillis - delaySoFar) + "ms");
            Message deferredMsg = WifiController.this.obtainMessage(155659);
            deferredMsg.obj = Message.obtain(msg);
            deferredMsg.arg1 = ++this.mDeferredEnableSerialNumber;
            WifiController.this.sendMessageDelayed(deferredMsg, WifiController.this.mReEnableDelayMillis - delaySoFar + 5L);
            return true;
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 155650: {
                    WifiController.this.mAlarmManager.cancel(WifiController.this.mIdleIntent);
                    WifiController.this.mScreenOff = false;
                    WifiController.this.mDeviceIdle = false;
                    WifiController.this.updateBatteryWorkSource();
                    break;
                }
                case 155651: {
                    WifiController.this.mScreenOff = true;
                    if (WifiController.this.shouldWifiStayAwake(WifiController.this.mPluggedType)) break;
                    if (WifiController.this.mNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTED) {
                        WifiController.this.mAlarmManager.set(0, System.currentTimeMillis() + WifiController.this.mIdleMillis, WifiController.this.mIdleIntent);
                        break;
                    }
                    WifiController.this.sendMessage(155653);
                    break;
                }
                case 155653: {
                    WifiController.this.mDeviceIdle = true;
                    WifiController.this.updateBatteryWorkSource();
                    break;
                }
                case 155652: {
                    int pluggedType = msg.arg1;
                    if (WifiController.this.mScreenOff && WifiController.this.shouldWifiStayAwake(WifiController.this.mPluggedType) && !WifiController.this.shouldWifiStayAwake(pluggedType)) {
                        long triggerTime = System.currentTimeMillis() + WifiController.this.mIdleMillis;
                        WifiController.this.mAlarmManager.set(0, triggerTime, WifiController.this.mIdleIntent);
                    }
                    WifiController.this.mPluggedType = pluggedType;
                    break;
                }
                case 155649: 
                case 155654: 
                case 155655: 
                case 155656: 
                case 155657: 
                case 155658: {
                    break;
                }
                case 155660: {
                    WifiController.this.mFirstUserSignOnSeen = true;
                    break;
                }
                case 155659: {
                    WifiController.this.log("DEFERRED_TOGGLE ignored due to state change");
                    break;
                }
                default: {
                    throw new RuntimeException("WifiController.handleMessage " + msg.what);
                }
            }
            return true;
        }
    }
}

