/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Handler;
import android.os.IRemoteCallback;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import com.android.internal.R;
import com.android.internal.util.DumpUtils;
import com.android.server.AttributeCache;
import java.io.PrintWriter;

public class AppTransition
implements DumpUtils.Dump {
    private static final String TAG = "AppTransition";
    private static final boolean DEBUG_APP_TRANSITIONS = false;
    private static final boolean DEBUG_ANIM = false;
    public static final int TRANSIT_ENTER_MASK = 4096;
    public static final int TRANSIT_EXIT_MASK = 8192;
    public static final int TRANSIT_UNSET = -1;
    public static final int TRANSIT_NONE = 0;
    public static final int TRANSIT_ACTIVITY_OPEN = 4102;
    public static final int TRANSIT_ACTIVITY_CLOSE = 8199;
    public static final int TRANSIT_TASK_OPEN = 4104;
    public static final int TRANSIT_TASK_CLOSE = 8201;
    public static final int TRANSIT_TASK_TO_FRONT = 4106;
    public static final int TRANSIT_TASK_TO_BACK = 8203;
    public static final int TRANSIT_WALLPAPER_CLOSE = 8204;
    public static final int TRANSIT_WALLPAPER_OPEN = 4109;
    public static final int TRANSIT_WALLPAPER_INTRA_OPEN = 4110;
    public static final int TRANSIT_WALLPAPER_INTRA_CLOSE = 8207;
    private static final float RECENTS_THUMBNAIL_FADEOUT_FRACTION = 0.25f;
    private static final long DEFAULT_APP_TRANSITION_DURATION = 250L;
    private final Context mContext;
    private final Handler mH;
    private int mNextAppTransition = -1;
    private static final int NEXT_TRANSIT_TYPE_NONE = 0;
    private static final int NEXT_TRANSIT_TYPE_CUSTOM = 1;
    private static final int NEXT_TRANSIT_TYPE_SCALE_UP = 2;
    private static final int NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_UP = 3;
    private static final int NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_DOWN = 4;
    private int mNextAppTransitionType = 0;
    private String mNextAppTransitionPackage;
    private Bitmap mNextAppTransitionThumbnail;
    private boolean mNextAppTransitionScaleUp;
    private IRemoteCallback mNextAppTransitionCallback;
    private int mNextAppTransitionEnter;
    private int mNextAppTransitionExit;
    private int mNextAppTransitionStartX;
    private int mNextAppTransitionStartY;
    private int mNextAppTransitionStartWidth;
    private int mNextAppTransitionStartHeight;
    private static final int APP_STATE_IDLE = 0;
    private static final int APP_STATE_READY = 1;
    private static final int APP_STATE_RUNNING = 2;
    private static final int APP_STATE_TIMEOUT = 3;
    private int mAppTransitionState = 0;
    private final int mConfigShortAnimTime;
    private final Interpolator mDecelerateInterpolator;
    private final Interpolator mThumbnailFadeoutInterpolator;
    private int mCurrentUserId = 0;

    AppTransition(Context context, Handler h) {
        this.mContext = context;
        this.mH = h;
        this.mConfigShortAnimTime = context.getResources().getInteger(0x10E0000);
        this.mDecelerateInterpolator = AnimationUtils.loadInterpolator(context, 17563651);
        this.mThumbnailFadeoutInterpolator = new Interpolator(){

            public float getInterpolation(float input) {
                if (input < 0.25f) {
                    return input / 0.25f;
                }
                return 1.0f;
            }
        };
    }

    boolean isTransitionSet() {
        return this.mNextAppTransition != -1;
    }

    boolean isTransitionNone() {
        return this.mNextAppTransition == 0;
    }

    boolean isTransitionEqual(int transit) {
        return this.mNextAppTransition == transit;
    }

    int getAppTransition() {
        return this.mNextAppTransition;
    }

    void setAppTransition(int transit) {
        this.mNextAppTransition = transit;
    }

    boolean isReady() {
        return this.mAppTransitionState == 1 || this.mAppTransitionState == 3;
    }

    void setReady() {
        this.mAppTransitionState = 1;
    }

    boolean isRunning() {
        return this.mAppTransitionState == 2;
    }

    void setIdle() {
        this.mAppTransitionState = 0;
    }

    boolean isTimeout() {
        return this.mAppTransitionState == 3;
    }

    void setTimeout() {
        this.mAppTransitionState = 3;
    }

    Bitmap getNextAppTransitionThumbnail() {
        return this.mNextAppTransitionThumbnail;
    }

    void getStartingPoint(Point outPoint) {
        outPoint.x = this.mNextAppTransitionStartX;
        outPoint.y = this.mNextAppTransitionStartY;
    }

    void prepare() {
        if (!this.isRunning()) {
            this.mAppTransitionState = 0;
        }
    }

    void goodToGo() {
        this.mNextAppTransition = -1;
        this.mAppTransitionState = 2;
    }

    void clear() {
        this.mNextAppTransitionType = 0;
        this.mNextAppTransitionPackage = null;
        this.mNextAppTransitionThumbnail = null;
    }

    void freeze() {
        this.setAppTransition(-1);
        this.clear();
        this.setReady();
    }

    private AttributeCache.Entry getCachedAnimations(WindowManager.LayoutParams lp) {
        if (lp != null && lp.windowAnimations != 0) {
            String packageName = lp.packageName != null ? lp.packageName : "android";
            int resId = lp.windowAnimations;
            if ((resId & 0xFF000000) == 0x1000000) {
                packageName = "android";
            }
            return AttributeCache.instance().get(packageName, resId, R.styleable.WindowAnimation, this.mCurrentUserId);
        }
        return null;
    }

    private AttributeCache.Entry getCachedAnimations(String packageName, int resId) {
        if (packageName != null) {
            if ((resId & 0xFF000000) == 0x1000000) {
                packageName = "android";
            }
            return AttributeCache.instance().get(packageName, resId, R.styleable.WindowAnimation, this.mCurrentUserId);
        }
        return null;
    }

    Animation loadAnimation(WindowManager.LayoutParams lp, int animAttr) {
        AttributeCache.Entry ent;
        int anim2 = 0;
        Context context = this.mContext;
        if (animAttr >= 0 && (ent = this.getCachedAnimations(lp)) != null) {
            context = ent.context;
            anim2 = ent.array.getResourceId(animAttr, 0);
        }
        if (anim2 != 0) {
            return AnimationUtils.loadAnimation(context, anim2);
        }
        return null;
    }

    private Animation loadAnimation(String packageName, int resId) {
        AttributeCache.Entry ent;
        int anim2 = 0;
        Context context = this.mContext;
        if (resId >= 0 && (ent = this.getCachedAnimations(packageName, resId)) != null) {
            context = ent.context;
            anim2 = resId;
        }
        if (anim2 != 0) {
            return AnimationUtils.loadAnimation(context, anim2);
        }
        return null;
    }

    private static float computePivot(int startPos, float finalScale) {
        float denom = finalScale - 1.0f;
        if (Math.abs(denom) < 1.0E-4f) {
            return startPos;
        }
        return (float)(-startPos) / denom;
    }

    private Animation createScaleUpAnimationLocked(int transit, boolean enter, int appWidth, int appHeight) {
        long duration;
        Animation a = null;
        if (enter) {
            float scaleW = (float)this.mNextAppTransitionStartWidth / (float)appWidth;
            float scaleH = (float)this.mNextAppTransitionStartHeight / (float)appHeight;
            ScaleAnimation scale = new ScaleAnimation(scaleW, 1.0f, scaleH, 1.0f, AppTransition.computePivot(this.mNextAppTransitionStartX, scaleW), AppTransition.computePivot(this.mNextAppTransitionStartY, scaleH));
            scale.setInterpolator(this.mDecelerateInterpolator);
            AlphaAnimation alpha = new AlphaAnimation(0.0f, 1.0f);
            alpha.setInterpolator(this.mThumbnailFadeoutInterpolator);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(scale);
            set.addAnimation(alpha);
            set.setDetachWallpaper(true);
            a = set;
        } else if (transit == 4110 || transit == 8207) {
            a = new AlphaAnimation(1.0f, 0.0f);
            a.setDetachWallpaper(true);
        } else {
            a = new AlphaAnimation(1.0f, 1.0f);
        }
        switch (transit) {
            case 4102: 
            case 8199: {
                duration = this.mConfigShortAnimTime;
                break;
            }
            default: {
                duration = 250L;
            }
        }
        a.setDuration(duration);
        a.setFillAfter(true);
        a.setInterpolator(this.mDecelerateInterpolator);
        a.initialize(appWidth, appHeight, appWidth, appHeight);
        return a;
    }

    Animation createThumbnailAnimationLocked(int transit, boolean enter, boolean thumb, int appWidth, int appHeight) {
        long duration;
        Animation a;
        float scaleW;
        float thumbHeight;
        int thumbWidthI = this.mNextAppTransitionThumbnail.getWidth();
        float thumbWidth = thumbWidthI > 0 ? (float)thumbWidthI : 1.0f;
        int thumbHeightI = this.mNextAppTransitionThumbnail.getHeight();
        float f = thumbHeight = thumbHeightI > 0 ? (float)thumbHeightI : 1.0f;
        if (thumb) {
            if (this.mNextAppTransitionScaleUp) {
                scaleW = (float)appWidth / thumbWidth;
                float scaleH = (float)appHeight / thumbHeight;
                ScaleAnimation scale = new ScaleAnimation(1.0f, scaleW, 1.0f, scaleH, AppTransition.computePivot(this.mNextAppTransitionStartX, 1.0f / scaleW), AppTransition.computePivot(this.mNextAppTransitionStartY, 1.0f / scaleH));
                scale.setInterpolator(this.mDecelerateInterpolator);
                AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
                alpha.setInterpolator(this.mThumbnailFadeoutInterpolator);
                AnimationSet set = new AnimationSet(false);
                set.addAnimation(scale);
                set.addAnimation(alpha);
                a = set;
            } else {
                scaleW = (float)appWidth / thumbWidth;
                float scaleH = (float)appHeight / thumbHeight;
                a = new ScaleAnimation(scaleW, 1.0f, scaleH, 1.0f, AppTransition.computePivot(this.mNextAppTransitionStartX, 1.0f / scaleW), AppTransition.computePivot(this.mNextAppTransitionStartY, 1.0f / scaleH));
            }
        } else if (enter) {
            if (this.mNextAppTransitionScaleUp) {
                scaleW = thumbWidth / (float)appWidth;
                float scaleH = thumbHeight / (float)appHeight;
                a = new ScaleAnimation(scaleW, 1.0f, scaleH, 1.0f, AppTransition.computePivot(this.mNextAppTransitionStartX, scaleW), AppTransition.computePivot(this.mNextAppTransitionStartY, scaleH));
            } else {
                a = new AlphaAnimation(1.0f, 1.0f);
            }
        } else if (this.mNextAppTransitionScaleUp) {
            a = transit == 4110 ? new AlphaAnimation(1.0f, 0.0f) : new AlphaAnimation(1.0f, 1.0f);
        } else {
            scaleW = thumbWidth / (float)appWidth;
            float scaleH = thumbHeight / (float)appHeight;
            ScaleAnimation scale = new ScaleAnimation(1.0f, scaleW, 1.0f, scaleH, AppTransition.computePivot(this.mNextAppTransitionStartX, scaleW), AppTransition.computePivot(this.mNextAppTransitionStartY, scaleH));
            AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
            AnimationSet set = new AnimationSet(true);
            set.addAnimation(scale);
            set.addAnimation(alpha);
            set.setZAdjustment(1);
            a = set;
        }
        switch (transit) {
            case 4102: 
            case 8199: {
                duration = this.mConfigShortAnimTime;
                break;
            }
            default: {
                duration = 250L;
            }
        }
        a.setDuration(duration);
        a.setFillAfter(true);
        a.setInterpolator(this.mDecelerateInterpolator);
        a.initialize(appWidth, appHeight, appWidth, appHeight);
        return a;
    }

    Animation loadAnimation(WindowManager.LayoutParams lp, int transit, boolean enter, int appWidth, int appHeight) {
        Animation a;
        if (this.mNextAppTransitionType == 1) {
            a = this.loadAnimation(this.mNextAppTransitionPackage, enter ? this.mNextAppTransitionEnter : this.mNextAppTransitionExit);
        } else if (this.mNextAppTransitionType == 2) {
            a = this.createScaleUpAnimationLocked(transit, enter, appWidth, appHeight);
        } else if (this.mNextAppTransitionType == 3 || this.mNextAppTransitionType == 4) {
            this.mNextAppTransitionScaleUp = this.mNextAppTransitionType == 3;
            a = this.createThumbnailAnimationLocked(transit, enter, false, appWidth, appHeight);
        } else {
            int animAttr = 0;
            switch (transit) {
                case 4102: {
                    animAttr = enter ? 4 : 5;
                    break;
                }
                case 8199: {
                    animAttr = enter ? 6 : 7;
                    break;
                }
                case 4104: {
                    animAttr = enter ? 8 : 9;
                    break;
                }
                case 8201: {
                    animAttr = enter ? 10 : 11;
                    break;
                }
                case 4106: {
                    animAttr = enter ? 12 : 13;
                    break;
                }
                case 8203: {
                    animAttr = enter ? 14 : 15;
                    break;
                }
                case 4109: {
                    animAttr = enter ? 16 : 17;
                    break;
                }
                case 8204: {
                    animAttr = enter ? 18 : 19;
                    break;
                }
                case 4110: {
                    animAttr = enter ? 20 : 21;
                    break;
                }
                case 8207: {
                    animAttr = enter ? 22 : 23;
                }
            }
            a = animAttr != 0 ? this.loadAnimation(lp, animAttr) : null;
        }
        return a;
    }

    void postAnimationCallback() {
        if (this.mNextAppTransitionCallback != null) {
            this.mH.sendMessage(this.mH.obtainMessage(26, this.mNextAppTransitionCallback));
            this.mNextAppTransitionCallback = null;
        }
    }

    void overridePendingAppTransition(String packageName, int enterAnim, int exitAnim, IRemoteCallback startedCallback) {
        if (this.isTransitionSet()) {
            this.mNextAppTransitionType = 1;
            this.mNextAppTransitionPackage = packageName;
            this.mNextAppTransitionThumbnail = null;
            this.mNextAppTransitionEnter = enterAnim;
            this.mNextAppTransitionExit = exitAnim;
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = startedCallback;
        } else {
            this.postAnimationCallback();
        }
    }

    void overridePendingAppTransitionScaleUp(int startX, int startY, int startWidth, int startHeight) {
        if (this.isTransitionSet()) {
            this.mNextAppTransitionType = 2;
            this.mNextAppTransitionPackage = null;
            this.mNextAppTransitionThumbnail = null;
            this.mNextAppTransitionStartX = startX;
            this.mNextAppTransitionStartY = startY;
            this.mNextAppTransitionStartWidth = startWidth;
            this.mNextAppTransitionStartHeight = startHeight;
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = null;
        }
    }

    void overridePendingAppTransitionThumb(Bitmap srcThumb, int startX, int startY, IRemoteCallback startedCallback, boolean scaleUp) {
        if (this.isTransitionSet()) {
            this.mNextAppTransitionType = scaleUp ? 3 : 4;
            this.mNextAppTransitionPackage = null;
            this.mNextAppTransitionThumbnail = srcThumb;
            this.mNextAppTransitionScaleUp = scaleUp;
            this.mNextAppTransitionStartX = startX;
            this.mNextAppTransitionStartY = startY;
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = startedCallback;
        } else {
            this.postAnimationCallback();
        }
    }

    public String toString() {
        return "mNextAppTransition=0x" + Integer.toHexString(this.mNextAppTransition);
    }

    public static String appTransitionToString(int transition) {
        switch (transition) {
            case -1: {
                return "TRANSIT_UNSET";
            }
            case 0: {
                return "TRANSIT_NONE";
            }
            case 8192: {
                return "TRANSIT_EXIT_MASK";
            }
            case 4102: {
                return "TRANSIT_ACTIVITY_OPEN";
            }
            case 8199: {
                return "TRANSIT_ACTIVITY_CLOSE";
            }
            case 4104: {
                return "TRANSIT_TASK_OPEN";
            }
            case 8201: {
                return "TRANSIT_TASK_CLOSE";
            }
            case 4106: {
                return "TRANSIT_TASK_TO_FRONT";
            }
            case 8203: {
                return "TRANSIT_TASK_TO_BACK";
            }
            case 8204: {
                return "TRANSIT_WALLPAPER_CLOSE";
            }
            case 4109: {
                return "TRANSIT_WALLPAPER_OPEN";
            }
            case 4110: {
                return "TRANSIT_WALLPAPER_INTRA_OPEN";
            }
            case 8207: {
                return "TRANSIT_WALLPAPER_INTRA_CLOSE";
            }
        }
        return "<UNKNOWN>";
    }

    private String appStateToString() {
        switch (this.mAppTransitionState) {
            case 0: {
                return "APP_STATE_IDLE";
            }
            case 1: {
                return "APP_STATE_READY";
            }
            case 2: {
                return "APP_STATE_RUNNING";
            }
            case 3: {
                return "APP_STATE_TIMEOUT";
            }
        }
        return "unknown state=" + this.mAppTransitionState;
    }

    private String transitTypeToString() {
        switch (this.mNextAppTransitionType) {
            case 0: {
                return "NEXT_TRANSIT_TYPE_NONE";
            }
            case 1: {
                return "NEXT_TRANSIT_TYPE_CUSTOM";
            }
            case 2: {
                return "NEXT_TRANSIT_TYPE_SCALE_UP";
            }
            case 3: {
                return "NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_UP";
            }
            case 4: {
                return "NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_DOWN";
            }
        }
        return "unknown type=" + this.mNextAppTransitionType;
    }

    public void dump(PrintWriter pw) {
        pw.print(" " + this);
        pw.print("  mAppTransitionState=");
        pw.println(this.appStateToString());
        if (this.mNextAppTransitionType != 0) {
            pw.print("  mNextAppTransitionType=");
            pw.println(this.transitTypeToString());
        }
        switch (this.mNextAppTransitionType) {
            case 1: {
                pw.print("  mNextAppTransitionPackage=");
                pw.println(this.mNextAppTransitionPackage);
                pw.print("  mNextAppTransitionEnter=0x");
                pw.print(Integer.toHexString(this.mNextAppTransitionEnter));
                pw.print(" mNextAppTransitionExit=0x");
                pw.println(Integer.toHexString(this.mNextAppTransitionExit));
                break;
            }
            case 2: {
                pw.print("  mNextAppTransitionStartX=");
                pw.print(this.mNextAppTransitionStartX);
                pw.print(" mNextAppTransitionStartY=");
                pw.println(this.mNextAppTransitionStartY);
                pw.print("  mNextAppTransitionStartWidth=");
                pw.print(this.mNextAppTransitionStartWidth);
                pw.print(" mNextAppTransitionStartHeight=");
                pw.println(this.mNextAppTransitionStartHeight);
                break;
            }
            case 3: 
            case 4: {
                pw.print("  mNextAppTransitionThumbnail=");
                pw.print(this.mNextAppTransitionThumbnail);
                pw.print(" mNextAppTransitionStartX=");
                pw.print(this.mNextAppTransitionStartX);
                pw.print(" mNextAppTransitionStartY=");
                pw.println(this.mNextAppTransitionStartY);
                pw.print("  mNextAppTransitionScaleUp=");
                pw.println(this.mNextAppTransitionScaleUp);
            }
        }
        if (this.mNextAppTransitionCallback != null) {
            pw.print("  mNextAppTransitionCallback=");
            pw.println(this.mNextAppTransitionCallback);
        }
    }

    public void setCurrentUser(int newUserId) {
        this.mCurrentUserId = newUserId;
    }
}

