/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gles_jni;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.google.android.gles_jni.EGLContextImpl;
import com.google.android.gles_jni.EGLDisplayImpl;
import com.google.android.gles_jni.EGLSurfaceImpl;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EGLImpl
implements EGL10 {
    private EGLContextImpl mContext = new EGLContextImpl(-1);
    private EGLDisplayImpl mDisplay = new EGLDisplayImpl(-1);
    private EGLSurfaceImpl mSurface = new EGLSurfaceImpl(-1);

    public native boolean eglInitialize(EGLDisplay var1, int[] var2);

    public native boolean eglQueryContext(EGLDisplay var1, EGLContext var2, int var3, int[] var4);

    public native boolean eglQuerySurface(EGLDisplay var1, EGLSurface var2, int var3, int[] var4);

    public native boolean eglReleaseThread();

    public native boolean eglChooseConfig(EGLDisplay var1, int[] var2, EGLConfig[] var3, int var4, int[] var5);

    public native boolean eglGetConfigAttrib(EGLDisplay var1, EGLConfig var2, int var3, int[] var4);

    public native boolean eglGetConfigs(EGLDisplay var1, EGLConfig[] var2, int var3, int[] var4);

    public native int eglGetError();

    public native boolean eglDestroyContext(EGLDisplay var1, EGLContext var2);

    public native boolean eglDestroySurface(EGLDisplay var1, EGLSurface var2);

    public native boolean eglMakeCurrent(EGLDisplay var1, EGLSurface var2, EGLSurface var3, EGLContext var4);

    public native String eglQueryString(EGLDisplay var1, int var2);

    public native boolean eglSwapBuffers(EGLDisplay var1, EGLSurface var2);

    public native boolean eglTerminate(EGLDisplay var1);

    public native boolean eglCopyBuffers(EGLDisplay var1, EGLSurface var2, Object var3);

    public native boolean eglWaitGL();

    public native boolean eglWaitNative(int var1, Object var2);

    public static native int getInitCount(EGLDisplay var0);

    public EGLContext eglCreateContext(EGLDisplay display, EGLConfig config, EGLContext share_context, int[] attrib_list) {
        int eglContextId = this._eglCreateContext(display, config, share_context, attrib_list);
        if (eglContextId == 0) {
            return EGL10.EGL_NO_CONTEXT;
        }
        return new EGLContextImpl(eglContextId);
    }

    public EGLSurface eglCreatePbufferSurface(EGLDisplay display, EGLConfig config, int[] attrib_list) {
        int eglSurfaceId = this._eglCreatePbufferSurface(display, config, attrib_list);
        if (eglSurfaceId == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        return new EGLSurfaceImpl(eglSurfaceId);
    }

    public EGLSurface eglCreatePixmapSurface(EGLDisplay display, EGLConfig config, Object native_pixmap, int[] attrib_list) {
        EGLSurfaceImpl sur = new EGLSurfaceImpl();
        this._eglCreatePixmapSurface(sur, display, config, native_pixmap, attrib_list);
        if (sur.mEGLSurface == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        return sur;
    }

    public EGLSurface eglCreateWindowSurface(EGLDisplay display, EGLConfig config, Object native_window, int[] attrib_list) {
        int eglSurfaceId;
        Surface sur = null;
        if (native_window instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)native_window;
            sur = surfaceView.getHolder().getSurface();
        } else if (native_window instanceof SurfaceHolder) {
            SurfaceHolder holder = (SurfaceHolder)native_window;
            sur = holder.getSurface();
        } else if (native_window instanceof Surface) {
            sur = (Surface)native_window;
        }
        if (sur != null) {
            eglSurfaceId = this._eglCreateWindowSurface(display, config, sur, attrib_list);
        } else if (native_window instanceof SurfaceTexture) {
            eglSurfaceId = this._eglCreateWindowSurfaceTexture(display, config, native_window, attrib_list);
        } else {
            throw new UnsupportedOperationException("eglCreateWindowSurface() can only be called with an instance of Surface, SurfaceView, SurfaceHolder or SurfaceTexture at the moment.");
        }
        if (eglSurfaceId == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        return new EGLSurfaceImpl(eglSurfaceId);
    }

    public synchronized EGLDisplay eglGetDisplay(Object native_display) {
        int value = this._eglGetDisplay(native_display);
        if (value == 0) {
            return EGL10.EGL_NO_DISPLAY;
        }
        if (this.mDisplay.mEGLDisplay != value) {
            this.mDisplay = new EGLDisplayImpl(value);
        }
        return this.mDisplay;
    }

    public synchronized EGLContext eglGetCurrentContext() {
        int value = this._eglGetCurrentContext();
        if (value == 0) {
            return EGL10.EGL_NO_CONTEXT;
        }
        if (this.mContext.mEGLContext != value) {
            this.mContext = new EGLContextImpl(value);
        }
        return this.mContext;
    }

    public synchronized EGLDisplay eglGetCurrentDisplay() {
        int value = this._eglGetCurrentDisplay();
        if (value == 0) {
            return EGL10.EGL_NO_DISPLAY;
        }
        if (this.mDisplay.mEGLDisplay != value) {
            this.mDisplay = new EGLDisplayImpl(value);
        }
        return this.mDisplay;
    }

    public synchronized EGLSurface eglGetCurrentSurface(int readdraw) {
        int value = this._eglGetCurrentSurface(readdraw);
        if (value == 0) {
            return EGL10.EGL_NO_SURFACE;
        }
        if (this.mSurface.mEGLSurface != value) {
            this.mSurface = new EGLSurfaceImpl(value);
        }
        return this.mSurface;
    }

    private native int _eglCreateContext(EGLDisplay var1, EGLConfig var2, EGLContext var3, int[] var4);

    private native int _eglCreatePbufferSurface(EGLDisplay var1, EGLConfig var2, int[] var3);

    private native void _eglCreatePixmapSurface(EGLSurface var1, EGLDisplay var2, EGLConfig var3, Object var4, int[] var5);

    private native int _eglCreateWindowSurface(EGLDisplay var1, EGLConfig var2, Object var3, int[] var4);

    private native int _eglCreateWindowSurfaceTexture(EGLDisplay var1, EGLConfig var2, Object var3, int[] var4);

    private native int _eglGetDisplay(Object var1);

    private native int _eglGetCurrentContext();

    private native int _eglGetCurrentDisplay();

    private native int _eglGetCurrentSurface(int var1);

    private static native void _nativeClassInit();

    static {
        EGLImpl._nativeClassInit();
    }
}

