/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterOutputStream
extends FilterOutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    protected final Inflater inf;
    protected final byte[] buf;
    private boolean closed = false;

    public InflaterOutputStream(OutputStream out) {
        this(out, new Inflater());
    }

    public InflaterOutputStream(OutputStream out, Inflater inf) {
        this(out, inf, 1024);
    }

    public InflaterOutputStream(OutputStream out, Inflater inf, int bufferSize) {
        super(out);
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        if (inf == null) {
            throw new NullPointerException("inf == null");
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize <= 0: " + bufferSize);
        }
        this.inf = inf;
        this.buf = new byte[bufferSize];
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            this.inf.end();
            this.out.close();
            this.closed = true;
        }
    }

    public void flush() throws IOException {
        this.finish();
        this.out.flush();
    }

    public void finish() throws IOException {
        this.checkClosed();
        this.write();
    }

    public void write(int b) throws IOException, ZipException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] bytes, int offset, int byteCount) throws IOException, ZipException {
        this.checkClosed();
        Arrays.checkOffsetAndCount(bytes.length, offset, byteCount);
        this.inf.setInput(bytes, offset, byteCount);
        this.write();
    }

    private void write() throws IOException, ZipException {
        try {
            int inflated;
            while ((inflated = this.inf.inflate(this.buf)) > 0) {
                this.out.write(this.buf, 0, inflated);
            }
        }
        catch (DataFormatException e) {
            throw new ZipException();
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
    }
}

