/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.NioUtils;
import libcore.io.ErrnoException;
import libcore.io.GaiException;
import libcore.io.Os;
import libcore.io.StructAddrinfo;
import libcore.io.StructFlock;
import libcore.io.StructGroupReq;
import libcore.io.StructLinger;
import libcore.io.StructPasswd;
import libcore.io.StructPollfd;
import libcore.io.StructStat;
import libcore.io.StructStatVfs;
import libcore.io.StructTimeval;
import libcore.io.StructUcred;
import libcore.io.StructUtsname;
import libcore.util.MutableInt;
import libcore.util.MutableLong;

public final class Posix
implements Os {
    Posix() {
    }

    public native FileDescriptor accept(FileDescriptor var1, InetSocketAddress var2) throws ErrnoException, SocketException;

    public native boolean access(String var1, int var2) throws ErrnoException;

    public native void bind(FileDescriptor var1, InetAddress var2, int var3) throws ErrnoException, SocketException;

    public native void chmod(String var1, int var2) throws ErrnoException;

    public native void chown(String var1, int var2, int var3) throws ErrnoException;

    public native void close(FileDescriptor var1) throws ErrnoException;

    public native void connect(FileDescriptor var1, InetAddress var2, int var3) throws ErrnoException, SocketException;

    public native FileDescriptor dup(FileDescriptor var1) throws ErrnoException;

    public native FileDescriptor dup2(FileDescriptor var1, int var2) throws ErrnoException;

    public native String[] environ();

    public native void execv(String var1, String[] var2) throws ErrnoException;

    public native void execve(String var1, String[] var2, String[] var3) throws ErrnoException;

    public native void fchmod(FileDescriptor var1, int var2) throws ErrnoException;

    public native void fchown(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    public native int fcntlVoid(FileDescriptor var1, int var2) throws ErrnoException;

    public native int fcntlLong(FileDescriptor var1, int var2, long var3) throws ErrnoException;

    public native int fcntlFlock(FileDescriptor var1, int var2, StructFlock var3) throws ErrnoException;

    public native void fdatasync(FileDescriptor var1) throws ErrnoException;

    public native StructStat fstat(FileDescriptor var1) throws ErrnoException;

    public native StructStatVfs fstatvfs(FileDescriptor var1) throws ErrnoException;

    public native void fsync(FileDescriptor var1) throws ErrnoException;

    public native void ftruncate(FileDescriptor var1, long var2) throws ErrnoException;

    public native String gai_strerror(int var1);

    public native InetAddress[] getaddrinfo(String var1, StructAddrinfo var2) throws GaiException;

    public native int getegid();

    public native int geteuid();

    public native int getgid();

    public native String getenv(String var1);

    public native String getnameinfo(InetAddress var1, int var2) throws GaiException;

    public native SocketAddress getpeername(FileDescriptor var1) throws ErrnoException;

    public native int getpid();

    public native int getppid();

    public native StructPasswd getpwnam(String var1) throws ErrnoException;

    public native StructPasswd getpwuid(int var1) throws ErrnoException;

    public native SocketAddress getsockname(FileDescriptor var1) throws ErrnoException;

    public native int getsockoptByte(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    public native InetAddress getsockoptInAddr(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    public native int getsockoptInt(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    public native StructLinger getsockoptLinger(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    public native StructTimeval getsockoptTimeval(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    public native StructUcred getsockoptUcred(FileDescriptor var1, int var2, int var3) throws ErrnoException;

    public native int gettid();

    public native int getuid();

    public native String if_indextoname(int var1);

    public native InetAddress inet_pton(int var1, String var2);

    public native InetAddress ioctlInetAddress(FileDescriptor var1, int var2, String var3) throws ErrnoException;

    public native int ioctlInt(FileDescriptor var1, int var2, MutableInt var3) throws ErrnoException;

    public native boolean isatty(FileDescriptor var1);

    public native void kill(int var1, int var2) throws ErrnoException;

    public native void lchown(String var1, int var2, int var3) throws ErrnoException;

    public native void listen(FileDescriptor var1, int var2) throws ErrnoException;

    public native long lseek(FileDescriptor var1, long var2, int var4) throws ErrnoException;

    public native StructStat lstat(String var1) throws ErrnoException;

    public native void mincore(long var1, long var3, byte[] var5) throws ErrnoException;

    public native void mkdir(String var1, int var2) throws ErrnoException;

    public native void mlock(long var1, long var3) throws ErrnoException;

    public native long mmap(long var1, long var3, int var5, int var6, FileDescriptor var7, long var8) throws ErrnoException;

    public native void msync(long var1, long var3, int var5) throws ErrnoException;

    public native void munlock(long var1, long var3) throws ErrnoException;

    public native void munmap(long var1, long var3) throws ErrnoException;

    public native FileDescriptor open(String var1, int var2, int var3) throws ErrnoException;

    public native FileDescriptor[] pipe() throws ErrnoException;

    public native int poll(StructPollfd[] var1, int var2) throws ErrnoException;

    public int pread(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException {
        if (buffer.isDirect()) {
            return this.preadBytes(fd, buffer, buffer.position(), buffer.remaining(), offset);
        }
        return this.preadBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining(), offset);
    }

    public int pread(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException {
        return this.preadBytes(fd, bytes, byteOffset, byteCount, offset);
    }

    private native int preadBytes(FileDescriptor var1, Object var2, int var3, int var4, long var5) throws ErrnoException;

    public int pwrite(FileDescriptor fd, ByteBuffer buffer, long offset) throws ErrnoException {
        if (buffer.isDirect()) {
            return this.pwriteBytes(fd, buffer, buffer.position(), buffer.remaining(), offset);
        }
        return this.pwriteBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining(), offset);
    }

    public int pwrite(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, long offset) throws ErrnoException {
        return this.pwriteBytes(fd, bytes, byteOffset, byteCount, offset);
    }

    private native int pwriteBytes(FileDescriptor var1, Object var2, int var3, int var4, long var5) throws ErrnoException;

    public int read(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException {
        if (buffer.isDirect()) {
            return this.readBytes(fd, buffer, buffer.position(), buffer.remaining());
        }
        return this.readBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining());
    }

    public int read(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException {
        return this.readBytes(fd, bytes, byteOffset, byteCount);
    }

    private native int readBytes(FileDescriptor var1, Object var2, int var3, int var4) throws ErrnoException;

    public native int readv(FileDescriptor var1, Object[] var2, int[] var3, int[] var4) throws ErrnoException;

    public int recvfrom(FileDescriptor fd, ByteBuffer buffer, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        if (buffer.isDirect()) {
            return this.recvfromBytes(fd, buffer, buffer.position(), buffer.remaining(), flags, srcAddress);
        }
        return this.recvfromBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining(), flags, srcAddress);
    }

    public int recvfrom(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetSocketAddress srcAddress) throws ErrnoException, SocketException {
        return this.recvfromBytes(fd, bytes, byteOffset, byteCount, flags, srcAddress);
    }

    private native int recvfromBytes(FileDescriptor var1, Object var2, int var3, int var4, int var5, InetSocketAddress var6) throws ErrnoException, SocketException;

    public native void remove(String var1) throws ErrnoException;

    public native void rename(String var1, String var2) throws ErrnoException;

    public native long sendfile(FileDescriptor var1, FileDescriptor var2, MutableLong var3, long var4) throws ErrnoException;

    public int sendto(FileDescriptor fd, ByteBuffer buffer, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        if (buffer.isDirect()) {
            return this.sendtoBytes(fd, buffer, buffer.position(), buffer.remaining(), flags, inetAddress, port);
        }
        return this.sendtoBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining(), flags, inetAddress, port);
    }

    public int sendto(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount, int flags, InetAddress inetAddress, int port) throws ErrnoException, SocketException {
        return this.sendtoBytes(fd, bytes, byteOffset, byteCount, flags, inetAddress, port);
    }

    private native int sendtoBytes(FileDescriptor var1, Object var2, int var3, int var4, int var5, InetAddress var6, int var7) throws ErrnoException, SocketException;

    public native void setegid(int var1) throws ErrnoException;

    public native void setenv(String var1, String var2, boolean var3) throws ErrnoException;

    public native void seteuid(int var1) throws ErrnoException;

    public native void setgid(int var1) throws ErrnoException;

    public native int setsid() throws ErrnoException;

    public native void setsockoptByte(FileDescriptor var1, int var2, int var3, int var4) throws ErrnoException;

    public native void setsockoptIfreq(FileDescriptor var1, int var2, int var3, String var4) throws ErrnoException;

    public native void setsockoptInt(FileDescriptor var1, int var2, int var3, int var4) throws ErrnoException;

    public native void setsockoptIpMreqn(FileDescriptor var1, int var2, int var3, int var4) throws ErrnoException;

    public native void setsockoptGroupReq(FileDescriptor var1, int var2, int var3, StructGroupReq var4) throws ErrnoException;

    public native void setsockoptLinger(FileDescriptor var1, int var2, int var3, StructLinger var4) throws ErrnoException;

    public native void setsockoptTimeval(FileDescriptor var1, int var2, int var3, StructTimeval var4) throws ErrnoException;

    public native void setuid(int var1) throws ErrnoException;

    public native void shutdown(FileDescriptor var1, int var2) throws ErrnoException;

    public native FileDescriptor socket(int var1, int var2, int var3) throws ErrnoException;

    public native void socketpair(int var1, int var2, int var3, FileDescriptor var4, FileDescriptor var5) throws ErrnoException;

    public native StructStat stat(String var1) throws ErrnoException;

    public native StructStatVfs statvfs(String var1) throws ErrnoException;

    public native String strerror(int var1);

    public native String strsignal(int var1);

    public native void symlink(String var1, String var2) throws ErrnoException;

    public native long sysconf(int var1);

    public native void tcdrain(FileDescriptor var1) throws ErrnoException;

    public native void tcsendbreak(FileDescriptor var1, int var2) throws ErrnoException;

    public int umask(int mask) {
        if ((mask & 0x1FF) != mask) {
            throw new IllegalArgumentException("Invalid umask: " + mask);
        }
        return this.umaskImpl(mask);
    }

    private native int umaskImpl(int var1);

    public native StructUtsname uname();

    public native void unsetenv(String var1) throws ErrnoException;

    public native int waitpid(int var1, MutableInt var2, int var3) throws ErrnoException;

    public int write(FileDescriptor fd, ByteBuffer buffer) throws ErrnoException {
        if (buffer.isDirect()) {
            return this.writeBytes(fd, buffer, buffer.position(), buffer.remaining());
        }
        return this.writeBytes(fd, NioUtils.unsafeArray(buffer), NioUtils.unsafeArrayOffset(buffer) + buffer.position(), buffer.remaining());
    }

    public int write(FileDescriptor fd, byte[] bytes, int byteOffset, int byteCount) throws ErrnoException {
        return this.writeBytes(fd, bytes, byteOffset, byteCount);
    }

    private native int writeBytes(FileDescriptor var1, Object var2, int var3, int var4) throws ErrnoException;

    public native int writev(FileDescriptor var1, Object[] var2, int[] var3, int[] var4) throws ErrnoException;
}

