/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicLruCache<K, V> {
    private final LinkedHashMap<K, V> map;
    private final int maxSize;

    public BasicLruCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    public final synchronized V get(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        V result = this.map.get(key);
        if (result != null) {
            return result;
        }
        result = this.create(key);
        if (result != null) {
            this.map.put(key, result);
            this.trimToSize(this.maxSize);
        }
        return result;
    }

    public final synchronized V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        V previous = this.map.put(key, value);
        this.trimToSize(this.maxSize);
        return previous;
    }

    private void trimToSize(int maxSize) {
        while (this.map.size() > maxSize) {
            Map.Entry<K, V> toEvict = this.map.eldest();
            K key = toEvict.getKey();
            V value = toEvict.getValue();
            this.map.remove(key);
            this.entryEvicted(key, value);
        }
    }

    protected void entryEvicted(K key, V value) {
    }

    protected V create(K key) {
        return null;
    }

    public final synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    public final synchronized void evictAll() {
        this.trimToSize(0);
    }
}

