/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IAlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.RemoteException;
import android.os.WorkSource;

public class AlarmManager {
    private static final String TAG = "AlarmManager";
    public static final int RTC_WAKEUP = 0;
    public static final int RTC = 1;
    public static final int ELAPSED_REALTIME_WAKEUP = 2;
    public static final int ELAPSED_REALTIME = 3;
    public static final long WINDOW_EXACT = 0L;
    public static final long WINDOW_HEURISTIC = -1L;
    private final IAlarmManager mService;
    private final boolean mAlwaysExact;
    @Deprecated
    public static final long INTERVAL_FIFTEEN_MINUTES = 900000L;
    @Deprecated
    public static final long INTERVAL_HALF_HOUR = 1800000L;
    @Deprecated
    public static final long INTERVAL_HOUR = 3600000L;
    @Deprecated
    public static final long INTERVAL_HALF_DAY = 43200000L;
    @Deprecated
    public static final long INTERVAL_DAY = 86400000L;

    AlarmManager(IAlarmManager service, Context ctx) {
        this.mService = service;
        int sdkVersion = ctx.getApplicationInfo().targetSdkVersion;
        this.mAlwaysExact = sdkVersion < 19;
    }

    private long legacyExactLength() {
        return this.mAlwaysExact ? 0L : -1L;
    }

    public void set(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, this.legacyExactLength(), 0L, operation, null);
    }

    public void setRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, this.legacyExactLength(), intervalMillis, operation, null);
    }

    public void setWindow(int type, long windowStartMillis, long windowLengthMillis, PendingIntent operation) {
        this.setImpl(type, windowStartMillis, windowLengthMillis, 0L, operation, null);
    }

    public void setExact(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, 0L, 0L, operation, null);
    }

    public void set(int type, long triggerAtMillis, long windowMillis, long intervalMillis, PendingIntent operation, WorkSource workSource) {
        this.setImpl(type, triggerAtMillis, windowMillis, intervalMillis, operation, workSource);
    }

    private void setImpl(int type, long triggerAtMillis, long windowMillis, long intervalMillis, PendingIntent operation, WorkSource workSource) {
        if (triggerAtMillis < 0L) {
            triggerAtMillis = 0L;
        }
        try {
            this.mService.set(type, triggerAtMillis, windowMillis, intervalMillis, operation, workSource);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Deprecated
    public void setInexactRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, -1L, intervalMillis, operation, null);
    }

    public void cancel(PendingIntent operation) {
        try {
            this.mService.remove(operation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setTime(long millis) {
        try {
            this.mService.setTime(millis);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setTimeZone(String timeZone) {
        try {
            this.mService.setTimeZone(timeZone);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

