/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class BackupHelperDispatcher {
    private static final String TAG = "BackupHelperDispatcher";
    TreeMap<String, BackupHelper> mHelpers = new TreeMap();

    public void addHelper(String keyPrefix, BackupHelper helper) {
        this.mHelpers.put(keyPrefix, helper);
    }

    public void performBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) throws IOException {
        Header header = new Header();
        TreeMap helpers = (TreeMap)this.mHelpers.clone();
        FileDescriptor oldStateFD = null;
        FileDescriptor newStateFD = newState.getFileDescriptor();
        if (oldState != null) {
            int err;
            oldStateFD = oldState.getFileDescriptor();
            while ((err = BackupHelperDispatcher.readHeader_native(header, oldStateFD)) >= 0) {
                if (err != 0) continue;
                BackupHelper helper = (BackupHelper)helpers.get(header.keyPrefix);
                Log.d(TAG, "handling existing helper '" + header.keyPrefix + "' " + helper);
                if (helper != null) {
                    this.doOneBackup(oldState, data, newState, header, helper);
                    helpers.remove(header.keyPrefix);
                    continue;
                }
                BackupHelperDispatcher.skipChunk_native(oldStateFD, header.chunkSize);
            }
        }
        for (Map.Entry entry : helpers.entrySet()) {
            header.keyPrefix = (String)entry.getKey();
            Log.d(TAG, "handling new helper '" + header.keyPrefix + "'");
            BackupHelper helper = (BackupHelper)entry.getValue();
            this.doOneBackup(oldState, data, newState, header, helper);
        }
    }

    private void doOneBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState, Header header, BackupHelper helper) throws IOException {
        FileDescriptor newStateFD = newState.getFileDescriptor();
        int pos = BackupHelperDispatcher.allocateHeader_native(header, newStateFD);
        if (pos < 0) {
            throw new IOException("allocateHeader_native failed (error " + pos + ")");
        }
        data.setKeyPrefix(header.keyPrefix);
        helper.performBackup(oldState, data, newState);
        int err = BackupHelperDispatcher.writeHeader_native(header, newStateFD, pos);
        if (err != 0) {
            throw new IOException("writeHeader_native failed (error " + err + ")");
        }
    }

    public void performRestore(BackupDataInput input, int appVersionCode, ParcelFileDescriptor newState) throws IOException {
        boolean alreadyComplained = false;
        BackupDataInputStream stream = new BackupDataInputStream(input);
        while (input.readNextHeader()) {
            String rawKey = input.getKey();
            int pos = rawKey.indexOf(58);
            if (pos > 0) {
                String prefix = rawKey.substring(0, pos);
                BackupHelper helper = this.mHelpers.get(prefix);
                if (helper != null) {
                    stream.dataSize = input.getDataSize();
                    stream.key = rawKey.substring(pos + 1);
                    helper.restoreEntity(stream);
                } else if (!alreadyComplained) {
                    Log.w(TAG, "Couldn't find helper for: '" + rawKey + "'");
                    alreadyComplained = true;
                }
            } else if (!alreadyComplained) {
                Log.w(TAG, "Entity with no prefix: '" + rawKey + "'");
                alreadyComplained = true;
            }
            input.skipEntityData();
        }
        for (BackupHelper helper : this.mHelpers.values()) {
            helper.writeNewStateDescription(newState);
        }
    }

    private static native int readHeader_native(Header var0, FileDescriptor var1);

    private static native int skipChunk_native(FileDescriptor var0, int var1);

    private static native int allocateHeader_native(Header var0, FileDescriptor var1);

    private static native int writeHeader_native(Header var0, FileDescriptor var1, int var2);

    private static class Header {
        int chunkSize;
        String keyPrefix;

        private Header() {
        }
    }
}

