/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothProfile;
import android.content.Context;
import android.net.BaseNetworkStateTracker;
import android.net.DhcpResults;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class BluetoothTetheringDataTracker
extends BaseNetworkStateTracker {
    private static final String NETWORKTYPE = "BLUETOOTH_TETHER";
    private static final String TAG = "BluetoothTethering";
    private static final boolean DBG = true;
    private static final boolean VDBG = true;
    private AtomicBoolean mTeardownRequested = new AtomicBoolean(false);
    private AtomicBoolean mPrivateDnsRouteSet = new AtomicBoolean(false);
    private AtomicInteger mDefaultGatewayAddr = new AtomicInteger(0);
    private AtomicBoolean mDefaultRouteSet = new AtomicBoolean(false);
    private final Object mLinkPropertiesLock = new Object();
    private final Object mNetworkInfoLock = new Object();
    private BluetoothPan mBluetoothPan;
    private static String mRevTetheredIface;
    private Handler mCsHandler;
    private static BluetoothTetheringDataTracker sInstance;
    private BtdtHandler mBtdtHandler;
    private AtomicReference<AsyncChannel> mAsyncChannel = new AtomicReference<Object>(null);
    private BluetoothProfile.ServiceListener mProfileServiceListener = new BluetoothProfile.ServiceListener(){

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            BluetoothTetheringDataTracker.this.mBluetoothPan = (BluetoothPan)proxy;
        }

        public void onServiceDisconnected(int profile) {
            BluetoothTetheringDataTracker.this.mBluetoothPan = null;
        }
    };

    private BluetoothTetheringDataTracker() {
        this.mNetworkInfo = new NetworkInfo(7, 0, NETWORKTYPE, "");
        this.mLinkProperties = new LinkProperties();
        this.mLinkCapabilities = new LinkCapabilities();
        this.mNetworkInfo.setIsAvailable(false);
        this.setTeardownRequested(false);
    }

    public static synchronized BluetoothTetheringDataTracker getInstance() {
        if (sInstance == null) {
            sInstance = new BluetoothTetheringDataTracker();
        }
        return sInstance;
    }

    public Object Clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested.set(isRequested);
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested.get();
    }

    public void startMonitoring(Context context, Handler target) {
        Log.d(TAG, "startMonitoring: target: " + target);
        this.mContext = context;
        this.mCsHandler = target;
        Log.d(TAG, "startMonitoring: mCsHandler: " + this.mCsHandler);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.getProfileProxy(this.mContext, this.mProfileServiceListener, 5);
        }
        this.mBtdtHandler = new BtdtHandler(target.getLooper(), this);
    }

    public boolean teardown() {
        this.mTeardownRequested.set(true);
        if (this.mBluetoothPan != null) {
            for (BluetoothDevice device : this.mBluetoothPan.getConnectedDevices()) {
                this.mBluetoothPan.disconnect(device);
            }
        }
        return true;
    }

    public void captivePortalCheckComplete() {
    }

    public void captivePortalCheckCompleted(boolean isCaptivePortal) {
    }

    public boolean reconnect() {
        this.mTeardownRequested.set(false);
        return true;
    }

    public boolean setRadio(boolean turnOn) {
        return true;
    }

    public synchronized boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    public int startUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public int stopUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public void setUserDataEnable(boolean enabled) {
        Log.w(TAG, "ignoring setUserDataEnable(" + enabled + ")");
    }

    public void setPolicyDataEnable(boolean enabled) {
        Log.w(TAG, "ignoring setPolicyDataEnable(" + enabled + ")");
    }

    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet.get();
    }

    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet.set(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkInfo getNetworkInfo() {
        Object object = this.mNetworkInfoLock;
        synchronized (object) {
            return new NetworkInfo(this.mNetworkInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkProperties getLinkProperties() {
        Object object = this.mLinkPropertiesLock;
        synchronized (object) {
            return new LinkProperties(this.mLinkProperties);
        }
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mLinkCapabilities);
    }

    public int getDefaultGatewayAddr() {
        return this.mDefaultGatewayAddr.get();
    }

    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet.get();
    }

    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet.set(enabled);
    }

    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    private static short countPrefixLength(byte[] mask) {
        short count = 0;
        for (byte b : mask) {
            for (int i = 0; i < 8; ++i) {
                if ((b & 1 << i) == 0) continue;
                count = (short)(count + 1);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startReverseTether(final LinkProperties linkProperties) {
        if (linkProperties == null || TextUtils.isEmpty(linkProperties.getInterfaceName())) {
            Log.e(TAG, "attempted to reverse tether with empty interface");
            return;
        }
        Object object = this.mLinkPropertiesLock;
        synchronized (object) {
            if (this.mLinkProperties.getInterfaceName() != null) {
                Log.e(TAG, "attempted to reverse tether while already in process");
                return;
            }
            this.mLinkProperties = linkProperties;
        }
        Thread dhcpThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DhcpResults dhcpResults = new DhcpResults();
                boolean success = NetworkUtils.runDhcp(linkProperties.getInterfaceName(), dhcpResults);
                Object object = BluetoothTetheringDataTracker.this.mLinkPropertiesLock;
                synchronized (object) {
                    if (linkProperties.getInterfaceName() != BluetoothTetheringDataTracker.this.mLinkProperties.getInterfaceName()) {
                        Log.e(BluetoothTetheringDataTracker.TAG, "obsolete DHCP run aborted");
                        return;
                    }
                    if (!success) {
                        Log.e(BluetoothTetheringDataTracker.TAG, "DHCP request error:" + NetworkUtils.getDhcpError());
                        return;
                    }
                    BluetoothTetheringDataTracker.this.mLinkProperties = dhcpResults.linkProperties;
                    Object object2 = BluetoothTetheringDataTracker.this.mNetworkInfoLock;
                    synchronized (object2) {
                        BluetoothTetheringDataTracker.this.mNetworkInfo.setIsAvailable(true);
                        BluetoothTetheringDataTracker.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, null);
                        if (BluetoothTetheringDataTracker.this.mCsHandler != null) {
                            Message msg = BluetoothTetheringDataTracker.this.mCsHandler.obtainMessage(458752, new NetworkInfo(BluetoothTetheringDataTracker.this.mNetworkInfo));
                            msg.sendToTarget();
                        }
                    }
                    return;
                }
            }
        });
        dhcpThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopReverseTether() {
        Object object = this.mLinkPropertiesLock;
        synchronized (object) {
            if (TextUtils.isEmpty(this.mLinkProperties.getInterfaceName())) {
                Log.e(TAG, "attempted to stop reverse tether with nothing tethered");
                return;
            }
            NetworkUtils.stopDhcp(this.mLinkProperties.getInterfaceName());
            this.mLinkProperties.clear();
            Object object2 = this.mNetworkInfoLock;
            synchronized (object2) {
                this.mNetworkInfo.setIsAvailable(false);
                this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                if (this.mCsHandler != null) {
                    this.mCsHandler.obtainMessage(458752, new NetworkInfo(this.mNetworkInfo)).sendToTarget();
                }
            }
        }
    }

    public void setDependencyMet(boolean met) {
    }

    public void addStackedLink(LinkProperties link) {
        this.mLinkProperties.addStackedLink(link);
    }

    public void removeStackedLink(LinkProperties link) {
        this.mLinkProperties.removeStackedLink(link);
    }

    public void supplyMessenger(Messenger messenger) {
        if (messenger != null) {
            new AsyncChannel().connect(this.mContext, (Handler)this.mBtdtHandler, messenger);
        }
    }

    static class BtdtHandler
    extends Handler {
        private AsyncChannel mStackChannel;
        private final BluetoothTetheringDataTracker mBtdt;

        BtdtHandler(Looper looper, BluetoothTetheringDataTracker parent) {
            super(looper);
            this.mBtdt = parent;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    Log.d(BluetoothTetheringDataTracker.TAG, "got CMD_CHANNEL_HALF_CONNECTED");
                    if (msg.arg1 != 0) break;
                    AsyncChannel ac = (AsyncChannel)msg.obj;
                    if (!this.mBtdt.mAsyncChannel.compareAndSet(null, ac)) {
                        Log.e(BluetoothTetheringDataTracker.TAG, "Trying to set mAsyncChannel twice!");
                        break;
                    }
                    ac.sendMessage(69633);
                    break;
                }
                case 69636: {
                    Log.d(BluetoothTetheringDataTracker.TAG, "got CMD_CHANNEL_DISCONNECTED");
                    this.mBtdt.stopReverseTether();
                    this.mBtdt.mAsyncChannel.set(null);
                    break;
                }
                case 458756: {
                    LinkProperties linkProperties = (LinkProperties)msg.obj;
                    Log.d(BluetoothTetheringDataTracker.TAG, "got EVENT_NETWORK_CONNECTED, " + linkProperties);
                    this.mBtdt.startReverseTether(linkProperties);
                    break;
                }
                case 458757: {
                    LinkProperties linkProperties = (LinkProperties)msg.obj;
                    Log.d(BluetoothTetheringDataTracker.TAG, "got EVENT_NETWORK_DISCONNECTED, " + linkProperties);
                    this.mBtdt.stopReverseTether();
                }
            }
        }
    }
}

