/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;

public class MergeCursor
extends AbstractCursor {
    private DataSetObserver mObserver = new DataSetObserver(){

        public void onChanged() {
            MergeCursor.this.mPos = -1;
        }

        public void onInvalidated() {
            MergeCursor.this.mPos = -1;
        }
    };
    private Cursor mCursor;
    private Cursor[] mCursors;

    public MergeCursor(Cursor[] cursors) {
        this.mCursors = cursors;
        this.mCursor = cursors[0];
        for (int i = 0; i < this.mCursors.length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].registerDataSetObserver(this.mObserver);
        }
    }

    public int getCount() {
        int count = 0;
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            count += this.mCursors[i].getCount();
        }
        return count;
    }

    public boolean onMove(int oldPosition, int newPosition) {
        this.mCursor = null;
        int cursorStartPos = 0;
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            if (newPosition < cursorStartPos + this.mCursors[i].getCount()) {
                this.mCursor = this.mCursors[i];
                break;
            }
            cursorStartPos += this.mCursors[i].getCount();
        }
        if (this.mCursor != null) {
            boolean ret = this.mCursor.moveToPosition(newPosition - cursorStartPos);
            return ret;
        }
        return false;
    }

    public String getString(int column) {
        return this.mCursor.getString(column);
    }

    public short getShort(int column) {
        return this.mCursor.getShort(column);
    }

    public int getInt(int column) {
        return this.mCursor.getInt(column);
    }

    public long getLong(int column) {
        return this.mCursor.getLong(column);
    }

    public float getFloat(int column) {
        return this.mCursor.getFloat(column);
    }

    public double getDouble(int column) {
        return this.mCursor.getDouble(column);
    }

    public int getType(int column) {
        return this.mCursor.getType(column);
    }

    public boolean isNull(int column) {
        return this.mCursor.isNull(column);
    }

    public byte[] getBlob(int column) {
        return this.mCursor.getBlob(column);
    }

    public String[] getColumnNames() {
        if (this.mCursor != null) {
            return this.mCursor.getColumnNames();
        }
        return new String[0];
    }

    public void deactivate() {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].deactivate();
        }
        super.deactivate();
    }

    public void close() {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].close();
        }
        super.close();
    }

    public void registerContentObserver(ContentObserver observer) {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].registerContentObserver(observer);
        }
    }

    public void unregisterContentObserver(ContentObserver observer) {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].unregisterContentObserver(observer);
        }
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].registerDataSetObserver(observer);
        }
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null) continue;
            this.mCursors[i].unregisterDataSetObserver(observer);
        }
    }

    public boolean requery() {
        int length = this.mCursors.length;
        for (int i = 0; i < length; ++i) {
            if (this.mCursors[i] == null || this.mCursors[i].requery()) continue;
            return false;
        }
        return true;
    }
}

