/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedVectorDrawable
extends Drawable
implements Animatable {
    private static final String LOGTAG = AnimatedVectorDrawable.class.getSimpleName();
    private static final String ANIMATED_VECTOR = "animated-vector";
    private static final String TARGET = "target";
    private static final boolean DBG_ANIMATION_VECTOR_DRAWABLE = false;
    private AnimatedVectorDrawableState mAnimatedVectorState;
    private boolean mMutated;

    public AnimatedVectorDrawable() {
        this.mAnimatedVectorState = new AnimatedVectorDrawableState(null);
    }

    private AnimatedVectorDrawable(AnimatedVectorDrawableState state, Resources res, Resources.Theme theme) {
        this.mAnimatedVectorState = new AnimatedVectorDrawableState(state);
        if (theme != null && this.canApplyTheme()) {
            this.applyTheme(theme);
        }
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mAnimatedVectorState.mVectorDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mAnimatedVectorState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mAnimatedVectorState;
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mAnimatedVectorState.mChangingConfigurations;
    }

    @Override
    public void draw(Canvas canvas) {
        this.mAnimatedVectorState.mVectorDrawable.draw(canvas);
        if (this.isStarted()) {
            this.invalidateSelf();
        }
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        this.mAnimatedVectorState.mVectorDrawable.setBounds(bounds);
    }

    @Override
    protected boolean onStateChange(int[] state) {
        return this.mAnimatedVectorState.mVectorDrawable.setState(state);
    }

    @Override
    protected boolean onLevelChange(int level) {
        return this.mAnimatedVectorState.mVectorDrawable.setLevel(level);
    }

    @Override
    public int getAlpha() {
        return this.mAnimatedVectorState.mVectorDrawable.getAlpha();
    }

    @Override
    public void setAlpha(int alpha) {
        this.mAnimatedVectorState.mVectorDrawable.setAlpha(alpha);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mAnimatedVectorState.mVectorDrawable.setColorFilter(colorFilter);
    }

    public void setTintList(ColorStateList tint) {
        this.mAnimatedVectorState.mVectorDrawable.setTintList(tint);
    }

    public void setHotspot(float x, float y) {
        this.mAnimatedVectorState.mVectorDrawable.setHotspot(x, y);
    }

    public void setHotspotBounds(int left, int top, int right, int bottom) {
        this.mAnimatedVectorState.mVectorDrawable.setHotspotBounds(left, top, right, bottom);
    }

    public void setTintMode(PorterDuff.Mode tintMode) {
        this.mAnimatedVectorState.mVectorDrawable.setTintMode(tintMode);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        this.mAnimatedVectorState.mVectorDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    @Override
    public void setLayoutDirection(int layoutDirection) {
        this.mAnimatedVectorState.mVectorDrawable.setLayoutDirection(layoutDirection);
    }

    @Override
    public boolean isStateful() {
        return this.mAnimatedVectorState.mVectorDrawable.isStateful();
    }

    @Override
    public int getOpacity() {
        return this.mAnimatedVectorState.mVectorDrawable.getOpacity();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicWidth();
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mAnimatedVectorState.mVectorDrawable.getIntrinsicHeight();
    }

    public void getOutline(Outline outline) {
        this.mAnimatedVectorState.mVectorDrawable.getOutline(outline);
    }

    public void inflate(Resources res, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        float pathErrorScale = 1.0f;
        while (eventType != 1) {
            if (eventType == 2) {
                TypedArray a;
                String tagName = parser.getName();
                if (ANIMATED_VECTOR.equals(tagName)) {
                    a = AnimatedVectorDrawable.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])R.styleable.AnimatedVectorDrawable);
                    int drawableRes = a.getResourceId(0, 0);
                    if (drawableRes != 0) {
                        VectorDrawable vectorDrawable = (VectorDrawable)res.getDrawable(drawableRes, theme).mutate();
                        vectorDrawable.setAllowCaching(false);
                        pathErrorScale = vectorDrawable.getPixelSize();
                        this.mAnimatedVectorState.mVectorDrawable = vectorDrawable;
                    }
                    a.recycle();
                } else if (TARGET.equals(tagName)) {
                    a = AnimatedVectorDrawable.obtainAttributes((Resources)res, (Resources.Theme)theme, (AttributeSet)attrs, (int[])R.styleable.AnimatedVectorDrawableTarget);
                    String target = a.getString(0);
                    int id2 = a.getResourceId(1, 0);
                    if (id2 != 0) {
                        Animator objectAnimator = AnimatorInflater.loadAnimator((Resources)res, (Resources.Theme)theme, (int)id2, (float)pathErrorScale);
                        this.setupAnimatorsForTarget(target, objectAnimator);
                    }
                    a.recycle();
                }
            }
            eventType = parser.next();
        }
    }

    public boolean canApplyTheme() {
        return super.canApplyTheme() || this.mAnimatedVectorState != null && this.mAnimatedVectorState.mVectorDrawable != null && this.mAnimatedVectorState.mVectorDrawable.canApplyTheme();
    }

    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        VectorDrawable vectorDrawable = this.mAnimatedVectorState.mVectorDrawable;
        if (vectorDrawable != null && vectorDrawable.canApplyTheme()) {
            vectorDrawable.applyTheme(t);
        }
    }

    private void setupAnimatorsForTarget(String name, Animator animator2) {
        Object target = this.mAnimatedVectorState.mVectorDrawable.getTargetByName(name);
        animator2.setTarget(target);
        if (this.mAnimatedVectorState.mAnimators == null) {
            this.mAnimatedVectorState.mAnimators = new ArrayList();
            this.mAnimatedVectorState.mTargetNameMap = new ArrayMap();
        }
        this.mAnimatedVectorState.mAnimators.add(animator2);
        this.mAnimatedVectorState.mTargetNameMap.put(animator2, name);
    }

    @Override
    public boolean isRunning() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            if (!animator2.isRunning()) continue;
            return true;
        }
        return false;
    }

    private boolean isStarted() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            if (!animator2.isStarted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void start() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            if (animator2.isStarted()) continue;
            animator2.start();
        }
        this.invalidateSelf();
    }

    @Override
    public void stop() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            animator2.end();
        }
    }

    public void reverse() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            if (animator2.canReverse()) {
                animator2.reverse();
                continue;
            }
            Log.w(LOGTAG, "AnimatedVectorDrawable can't reverse()");
        }
    }

    public boolean canReverse() {
        ArrayList<Animator> animators = this.mAnimatedVectorState.mAnimators;
        int size = animators.size();
        for (int i = 0; i < size; ++i) {
            Animator animator2 = animators.get(i);
            if (animator2.canReverse()) continue;
            return false;
        }
        return true;
    }

    private static class AnimatedVectorDrawableState
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        VectorDrawable mVectorDrawable;
        ArrayList<Animator> mAnimators;
        ArrayMap<Animator, String> mTargetNameMap;

        public AnimatedVectorDrawableState(AnimatedVectorDrawableState copy) {
            if (copy != null) {
                this.mChangingConfigurations = copy.mChangingConfigurations;
                if (copy.mVectorDrawable != null) {
                    this.mVectorDrawable = (VectorDrawable)copy.mVectorDrawable.getConstantState().newDrawable();
                    this.mVectorDrawable.mutate();
                    this.mVectorDrawable.setAllowCaching(false);
                    this.mVectorDrawable.setBounds(copy.mVectorDrawable.getBounds());
                }
                if (copy.mAnimators != null) {
                    int numAnimators = copy.mAnimators.size();
                    this.mAnimators = new ArrayList(numAnimators);
                    this.mTargetNameMap = new ArrayMap(numAnimators);
                    for (int i = 0; i < numAnimators; ++i) {
                        Animator anim2 = copy.mAnimators.get(i);
                        Animator animClone = anim2.clone();
                        String targetName = copy.mTargetNameMap.get(anim2);
                        Object targetObject = this.mVectorDrawable.getTargetByName(targetName);
                        animClone.setTarget(targetObject);
                        this.mAnimators.add(animClone);
                        this.mTargetNameMap.put(animClone, targetName);
                    }
                }
            } else {
                this.mVectorDrawable = new VectorDrawable();
            }
        }

        @Override
        public Drawable newDrawable() {
            return new AnimatedVectorDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new AnimatedVectorDrawable(this, res, null);
        }

        public Drawable newDrawable(Resources res, Resources.Theme theme) {
            return new AnimatedVectorDrawable(this, res, theme);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

