/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.graphics.Rect;
import android.hardware.camera2.impl.MetadataMarshalClass;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataMarshalRect
implements MetadataMarshalClass<Rect> {
    private static final int SIZE = 16;

    @Override
    public int marshal(Rect value, ByteBuffer buffer, int nativeType, boolean sizeOnly) {
        if (sizeOnly) {
            return 16;
        }
        buffer.putInt(value.left);
        buffer.putInt(value.top);
        buffer.putInt(value.width());
        buffer.putInt(value.height());
        return 16;
    }

    @Override
    public Rect unmarshal(ByteBuffer buffer, int nativeType) {
        int left = buffer.getInt();
        int top = buffer.getInt();
        int width = buffer.getInt();
        int height = buffer.getInt();
        int right = left + width;
        int bottom = top + height;
        return new Rect(left, top, right, bottom);
    }

    @Override
    public Class<Rect> getMarshalingClass() {
        return Rect.class;
    }

    @Override
    public boolean isNativeTypeSupported(int nativeType) {
        return nativeType == 1;
    }

    @Override
    public int getNativeSize(int nativeType) {
        return 16;
    }
}

