/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.AudioRoutesInfo;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioRoutesObserver;
import android.media.IAudioService;
import android.media.IRemoteControlClient;
import android.media.IRemoteControlDisplay;
import android.media.IRemoteVolumeObserver;
import android.media.IRingtonePlayer;
import android.media.MediaFocusControl;
import android.media.MediaPlayer;
import android.media.Rating;
import android.media.SoundPool;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.Vibrator;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.VolumePanel;
import android.view.WindowManager;
import com.android.internal.telephony.ITelephony;
import com.android.internal.util.XmlUtils;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xmlpull.v1.XmlPullParserException;

public class AudioService
extends IAudioService.Stub {
    private static final String TAG = "AudioService";
    protected static final boolean DEBUG_RC = false;
    protected static final boolean DEBUG_VOL = false;
    private static final int PERSIST_DELAY = 500;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final AppOpsManager mAppOps;
    private final boolean mVoiceCapable;
    private VolumePanel mVolumePanel;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int MSG_SET_DEVICE_VOLUME = 0;
    private static final int MSG_PERSIST_VOLUME = 1;
    private static final int MSG_PERSIST_MASTER_VOLUME = 2;
    private static final int MSG_PERSIST_RINGER_MODE = 3;
    private static final int MSG_MEDIA_SERVER_DIED = 4;
    private static final int MSG_PLAY_SOUND_EFFECT = 5;
    private static final int MSG_BTA2DP_DOCK_TIMEOUT = 6;
    private static final int MSG_LOAD_SOUND_EFFECTS = 7;
    private static final int MSG_SET_FORCE_USE = 8;
    private static final int MSG_BT_HEADSET_CNCT_FAILED = 9;
    private static final int MSG_SET_ALL_VOLUMES = 10;
    private static final int MSG_PERSIST_MASTER_VOLUME_MUTE = 11;
    private static final int MSG_REPORT_NEW_ROUTES = 12;
    private static final int MSG_SET_FORCE_BT_A2DP_USE = 13;
    private static final int MSG_CHECK_MUSIC_ACTIVE = 14;
    private static final int MSG_BROADCAST_AUDIO_BECOMING_NOISY = 15;
    private static final int MSG_CONFIGURE_SAFE_MEDIA_VOLUME = 16;
    private static final int MSG_CONFIGURE_SAFE_MEDIA_VOLUME_FORCED = 17;
    private static final int MSG_PERSIST_SAFE_VOLUME_STATE = 18;
    private static final int MSG_BROADCAST_BT_CONNECTION_STATE = 19;
    private static final int MSG_UNLOAD_SOUND_EFFECTS = 20;
    private static final int MSG_SET_WIRED_DEVICE_CONNECTION_STATE = 100;
    private static final int MSG_SET_A2DP_CONNECTION_STATE = 101;
    private static final int BTA2DP_DOCK_TIMEOUT_MILLIS = 8000;
    private static final int BT_HEADSET_CNCT_TIMEOUT_MS = 3000;
    private AudioSystemThread mAudioSystemThread;
    private AudioHandler mAudioHandler;
    private VolumeStreamState[] mStreamStates;
    private SettingsObserver mSettingsObserver;
    private int mMode = 0;
    private final Object mSettingsLock = new Object();
    private SoundPool mSoundPool;
    private final Object mSoundEffectsLock = new Object();
    private static final int NUM_SOUNDPOOL_CHANNELS = 4;
    private static final int MAX_MASTER_VOLUME = 100;
    private static final int MAX_BATCH_VOLUME_ADJUST_STEPS = 4;
    private static final String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    private static final List<String> SOUND_EFFECT_FILES = new ArrayList<String>();
    private final int[][] SOUND_EFFECT_FILES_MAP = new int[10][2];
    private static final int[] MAX_STREAM_VOLUME = new int[]{5, 7, 7, 15, 7, 7, 15, 7, 15, 15};
    private final int[] STREAM_VOLUME_ALIAS = new int[]{0, 2, 2, 3, 4, 2, 6, 2, 2, 3};
    private final int[] STREAM_VOLUME_ALIAS_NON_VOICE = new int[]{0, 3, 2, 3, 4, 2, 6, 3, 3, 3};
    private int[] mStreamVolumeAlias;
    private static final int[] STEAM_VOLUME_OPS = new int[]{34, 36, 35, 36, 37, 38, 39, 36, 36, 36};
    private final boolean mUseFixedVolume;
    private final String[] STREAM_NAMES = new String[]{"STREAM_VOICE_CALL", "STREAM_SYSTEM", "STREAM_RING", "STREAM_MUSIC", "STREAM_ALARM", "STREAM_NOTIFICATION", "STREAM_BLUETOOTH_SCO", "STREAM_SYSTEM_ENFORCED", "STREAM_DTMF", "STREAM_TTS"};
    private final AudioSystem.ErrorCallback mAudioSystemCallback = new AudioSystem.ErrorCallback(){

        public void onError(int error) {
            switch (error) {
                case 100: {
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 4, 1, 0, 0, null, 0);
                    break;
                }
            }
        }
    };
    private int mRingerMode;
    private int mRingerModeAffectedStreams = 0;
    private int mRingerModeMutedStreams;
    private int mMuteAffectedStreams;
    private int mVibrateSetting;
    private final boolean mHasVibrator;
    private final BroadcastReceiver mReceiver = new AudioServiceBroadcastReceiver();
    private final HashMap<Integer, String> mConnectedDevices = new HashMap();
    private int mForcedUseForComm;
    private final boolean mUseMasterVolume;
    private final int[] mMasterVolumeRamp;
    private final ArrayList<SetModeDeathHandler> mSetModeDeathHandlers = new ArrayList();
    private final ArrayList<ScoClient> mScoClients = new ArrayList();
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mBluetoothHeadsetDevice;
    private int mScoAudioState;
    private static final int SCO_STATE_INACTIVE = 0;
    private static final int SCO_STATE_ACTIVATE_REQ = 1;
    private static final int SCO_STATE_ACTIVE_INTERNAL = 3;
    private static final int SCO_STATE_DEACTIVATE_REQ = 5;
    private static final int SCO_STATE_ACTIVE_EXTERNAL = 2;
    private static final int SCO_STATE_DEACTIVATE_EXT_REQ = 4;
    private int mScoAudioMode;
    private static final int SCO_MODE_VIRTUAL_CALL = 0;
    private static final int SCO_MODE_RAW = 1;
    private int mScoConnectionState;
    private boolean mBootCompleted;
    private SoundPoolCallback mSoundPoolCallBack;
    private SoundPoolListenerThread mSoundPoolListenerThread;
    private Looper mSoundPoolLooper = null;
    private static int sSoundEffectVolumeDb;
    private static final int DEFAULT_STREAM_TYPE_OVERRIDE_DELAY_MS = 5000;
    private int mPrevVolDirection = 0;
    private KeyguardManager mKeyguardManager;
    private int mVolumeControlStream = -1;
    private final Object mForceControlStreamLock = new Object();
    private ForceControlStreamClient mForceControlStreamClient = null;
    private volatile IRingtonePlayer mRingtonePlayer;
    private int mDeviceOrientation = 0;
    private int mDeviceRotation = 0;
    private boolean mBluetoothA2dpEnabled;
    private final Object mBluetoothA2dpEnabledLock = new Object();
    final AudioRoutesInfo mCurAudioRoutes = new AudioRoutesInfo();
    final RemoteCallbackList<IAudioRoutesObserver> mRoutesObservers = new RemoteCallbackList();
    public static final int STREAM_REMOTE_MUSIC = -200;
    final int mFixedVolumeDevices = 31744;
    private final boolean mMonitorOrientation;
    private final boolean mMonitorRotation;
    private boolean mDockAudioMediaEnabled = true;
    private int mDockState = 0;
    private StreamVolumeCommand mPendingVolumeCommand;
    private PowerManager.WakeLock mAudioEventWakeLock;
    private final MediaFocusControl mMediaFocusControl;
    private BluetoothA2dp mA2dp;
    private final Object mA2dpAvrcpLock = new Object();
    private boolean mAvrcpAbsVolSupported = false;
    private static final String TAG_AUDIO_ASSETS = "audio_assets";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_GROUP = "group";
    private static final String ATTR_GROUP_NAME = "name";
    private static final String TAG_ASSET = "asset";
    private static final String ATTR_ASSET_ID = "id";
    private static final String ATTR_ASSET_FILE = "file";
    private static final String ASSET_FILE_VERSION = "1.0";
    private static final String GROUP_TOUCH_SOUNDS = "touch_sounds";
    private static final int SOUND_EFECTS_LOAD_TIMEOUT_MS = 5000;
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            switch (profile) {
                case 2: {
                    Object object = AudioService.this.mA2dpAvrcpLock;
                    synchronized (object) {
                        AudioService.this.mA2dp = (BluetoothA2dp)proxy;
                        List<BluetoothDevice> deviceList = AudioService.this.mA2dp.getConnectedDevices();
                        if (deviceList.size() > 0) {
                            BluetoothDevice btDevice = deviceList.get(0);
                            HashMap hashMap = AudioService.this.mConnectedDevices;
                            synchronized (hashMap) {
                                int state = AudioService.this.mA2dp.getConnectionState(btDevice);
                                int delay = AudioService.this.checkSendBecomingNoisyIntent(128, state == 2 ? 1 : 0);
                                AudioService.this.queueMsgUnderWakeLock(AudioService.this.mAudioHandler, 101, state, 0, btDevice, delay);
                            }
                        }
                        break;
                    }
                }
                case 1: {
                    ArrayList arrayList = AudioService.this.mScoClients;
                    synchronized (arrayList) {
                        AudioService.this.mAudioHandler.removeMessages(9);
                        AudioService.this.mBluetoothHeadset = (BluetoothHeadset)proxy;
                        List<BluetoothDevice> deviceList = AudioService.this.mBluetoothHeadset.getConnectedDevices();
                        if (deviceList.size() > 0) {
                            AudioService.this.mBluetoothHeadsetDevice = deviceList.get(0);
                        } else {
                            AudioService.this.mBluetoothHeadsetDevice = null;
                        }
                        AudioService.this.checkScoAudioState();
                        if (AudioService.this.mScoAudioState == 1 || AudioService.this.mScoAudioState == 5 || AudioService.this.mScoAudioState == 4) {
                            boolean status = false;
                            if (AudioService.this.mBluetoothHeadsetDevice != null) {
                                switch (AudioService.this.mScoAudioState) {
                                    case 1: {
                                        AudioService.this.mScoAudioState = 3;
                                        if (AudioService.this.mScoAudioMode == 1) {
                                            status = AudioService.this.mBluetoothHeadset.connectAudio();
                                            break;
                                        }
                                        status = AudioService.this.mBluetoothHeadset.startScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                        break;
                                    }
                                    case 5: {
                                        if (AudioService.this.mScoAudioMode == 1) {
                                            status = AudioService.this.mBluetoothHeadset.disconnectAudio();
                                            break;
                                        }
                                        status = AudioService.this.mBluetoothHeadset.stopScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                        break;
                                    }
                                    case 4: {
                                        status = AudioService.this.mBluetoothHeadset.stopVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                                    }
                                }
                            }
                            if (!status) {
                                AudioService.sendMsg(AudioService.this.mAudioHandler, 9, 0, 0, 0, null, 0);
                            }
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(int profile) {
            switch (profile) {
                case 2: {
                    Object object = AudioService.this.mA2dpAvrcpLock;
                    synchronized (object) {
                        AudioService.this.mA2dp = null;
                        HashMap hashMap = AudioService.this.mConnectedDevices;
                        synchronized (hashMap) {
                            if (AudioService.this.mConnectedDevices.containsKey(128)) {
                                AudioService.this.makeA2dpDeviceUnavailableNow((String)AudioService.this.mConnectedDevices.get(128));
                            }
                        }
                    }
                }
                case 1: {
                    ArrayList arrayList = AudioService.this.mScoClients;
                    synchronized (arrayList) {
                        AudioService.this.mBluetoothHeadset = null;
                        break;
                    }
                }
            }
        }
    };
    int mBecomingNoisyIntentDevices = 32652;
    private String mDockAddress;
    private final int SAFE_MEDIA_VOLUME_NOT_CONFIGURED = 0;
    private final int SAFE_MEDIA_VOLUME_DISABLED = 1;
    private final int SAFE_MEDIA_VOLUME_INACTIVE = 2;
    private final int SAFE_MEDIA_VOLUME_ACTIVE = 3;
    private Integer mSafeMediaVolumeState;
    private int mMcc = 0;
    private int mSafeMediaVolumeIndex;
    private final int mSafeMediaVolumeDevices = 12;
    private int mMusicActiveMs;
    private static final int UNSAFE_VOLUME_MUSIC_ACTIVE_MS_MAX = 72000000;
    private static final int MUSIC_ACTIVE_POLL_PERIOD_MS = 60000;
    private static final int SAFE_VOLUME_CONFIGURE_TIMEOUT_MS = 30000;
    private Boolean mCameraSoundForced;
    private static final String[] RINGER_MODE_NAMES;

    public AudioService(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mVoiceCapable = this.mContext.getResources().getBoolean(17891385);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mAudioEventWakeLock = pm.newWakeLock(1, "handleAudioEvent");
        Vibrator vibrator = (Vibrator)context.getSystemService("vibrator");
        this.mHasVibrator = vibrator == null ? false : vibrator.hasVibrator();
        AudioService.MAX_STREAM_VOLUME[0] = SystemProperties.getInt("ro.config.vc_call_vol_steps", MAX_STREAM_VOLUME[0]);
        sSoundEffectVolumeDb = context.getResources().getInteger(17694724);
        this.mVolumePanel = new VolumePanel(context, this);
        this.mForcedUseForComm = 0;
        this.createAudioSystemThread();
        this.mMediaFocusControl = new MediaFocusControl(this.mAudioHandler.getLooper(), this.mContext, this.mVolumePanel, this);
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        boolean cameraSoundForced = this.mContext.getResources().getBoolean(17891411);
        this.mCameraSoundForced = new Boolean(cameraSoundForced);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 4, cameraSoundForced ? 11 : 0, null, 0);
        this.mSafeMediaVolumeState = new Integer(Settings.Global.getInt(this.mContentResolver, "audio_safe_volume_state", 0));
        this.mSafeMediaVolumeIndex = this.mContext.getResources().getInteger(17694788) * 10;
        this.mUseFixedVolume = this.mContext.getResources().getBoolean(17891414);
        this.updateStreamVolumeAlias(false);
        this.readPersistedSettings();
        this.mSettingsObserver = new SettingsObserver();
        this.createStreamStates();
        AudioService.readAndSetLowRamDevice();
        this.mRingerModeMutedStreams = 0;
        this.setRingerModeInt(this.getRingerMode(), false);
        IntentFilter intentFilter = new IntentFilter("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        intentFilter.addAction("android.intent.action.USB_AUDIO_ACCESSORY_PLUG");
        intentFilter.addAction("android.intent.action.USB_AUDIO_DEVICE_PLUG");
        intentFilter.addAction("android.intent.action.BOOT_COMPLETED");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mMonitorOrientation = SystemProperties.getBoolean("ro.audio.monitorOrientation", false);
        if (this.mMonitorOrientation) {
            Log.v(TAG, "monitoring device orientation");
            this.setOrientationForAudioSystem();
        }
        this.mMonitorRotation = SystemProperties.getBoolean("ro.audio.monitorRotation", false);
        if (this.mMonitorRotation) {
            this.mDeviceRotation = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
            Log.v(TAG, "monitoring device rotation, initial=" + this.mDeviceRotation);
            this.setRotationForAudioSystem();
        }
        context.registerReceiver(this.mReceiver, intentFilter);
        this.mUseMasterVolume = context.getResources().getBoolean(0x1110011);
        this.restoreMasterVolume();
        this.mMasterVolumeRamp = context.getResources().getIntArray(17235978);
    }

    private void createAudioSystemThread() {
        this.mAudioSystemThread = new AudioSystemThread();
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAudioHandlerCreation() {
        AudioService audioService = this;
        synchronized (audioService) {
            while (this.mAudioHandler == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "Interrupted while waiting on volume handler.");
                }
            }
        }
    }

    private void checkAllAliasStreamVolumes() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            if (streamType != this.mStreamVolumeAlias[streamType]) {
                this.mStreamStates[streamType].setAllIndexes(this.mStreamStates[this.mStreamVolumeAlias[streamType]]);
            }
            if (this.mStreamStates[streamType].isMuted()) continue;
            this.mStreamStates[streamType].applyAllVolumes();
        }
    }

    private void createStreamStates() {
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        this.mStreamStates = new VolumeStreamState[numStreamTypes];
        VolumeStreamState[] streams = this.mStreamStates;
        for (int i = 0; i < numStreamTypes; ++i) {
            streams[i] = new VolumeStreamState(Settings.System.VOLUME_SETTINGS[this.mStreamVolumeAlias[i]], i);
        }
        this.checkAllAliasStreamVolumes();
    }

    private void dumpStreamStates(PrintWriter pw) {
        pw.println("\nStream volumes (device: index)");
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int i = 0; i < numStreamTypes; ++i) {
            pw.println("- " + this.STREAM_NAMES[i] + ":");
            this.mStreamStates[i].dump(pw);
            pw.println("");
        }
        pw.print("\n- mute affected streams = 0x");
        pw.println(Integer.toHexString(this.mMuteAffectedStreams));
    }

    private void updateStreamVolumeAlias(boolean updateVolumes) {
        int dtmfStreamAlias;
        if (this.mVoiceCapable) {
            this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS;
            dtmfStreamAlias = 2;
        } else {
            this.mStreamVolumeAlias = this.STREAM_VOLUME_ALIAS_NON_VOICE;
            dtmfStreamAlias = 3;
        }
        if (this.isInCommunication()) {
            dtmfStreamAlias = 0;
            this.mRingerModeAffectedStreams &= 0xFFFFFEFF;
        } else {
            this.mRingerModeAffectedStreams |= 0x100;
        }
        this.mStreamVolumeAlias[8] = dtmfStreamAlias;
        if (updateVolumes) {
            this.mStreamStates[8].setAllIndexes(this.mStreamStates[dtmfStreamAlias]);
            this.setRingerModeInt(this.getRingerMode(), false);
            AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[8], 0);
        }
    }

    private void readDockAudioSettings(ContentResolver cr) {
        boolean bl = this.mDockAudioMediaEnabled = Settings.Global.getInt(cr, "dock_audio_media_enabled", 0) == 1;
        this.mBecomingNoisyIntentDevices = this.mDockAudioMediaEnabled ? (this.mBecomingNoisyIntentDevices |= 0x800) : (this.mBecomingNoisyIntentDevices &= 0xFFFFF7FF);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 3, this.mDockAudioMediaEnabled ? 8 : 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPersistedSettings() {
        boolean masterMute;
        ContentResolver cr = this.mContentResolver;
        int ringerModeFromSettings = Settings.Global.getInt(cr, "mode_ringer", 2);
        int ringerMode = ringerModeFromSettings;
        if (!AudioManager.isValidRingerMode(ringerMode)) {
            ringerMode = 2;
        }
        if (ringerMode == 1 && !this.mHasVibrator) {
            ringerMode = 0;
        }
        if (ringerMode != ringerModeFromSettings) {
            Settings.Global.putInt(cr, "mode_ringer", ringerMode);
        }
        if (this.mUseFixedVolume) {
            ringerMode = 2;
        }
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mRingerMode = ringerMode;
            this.mVibrateSetting = AudioService.getValueForVibrateSetting(0, 1, this.mHasVibrator ? 2 : 0);
            this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, 0, this.mHasVibrator ? 2 : 0);
            this.updateRingerModeAffectedStreams();
            this.readDockAudioSettings(cr);
        }
        this.mMuteAffectedStreams = Settings.System.getIntForUser(cr, "mute_streams_affected", 14, -2);
        boolean bl = masterMute = Settings.System.getIntForUser(cr, "volume_master_mute", 0, -2) == 1;
        if (this.mUseFixedVolume) {
            masterMute = false;
            AudioSystem.setMasterVolume(1.0f);
        }
        AudioSystem.setMasterMute(masterMute);
        this.broadcastMasterMuteStatus(masterMute);
        this.broadcastRingerMode(ringerMode);
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
        this.mMediaFocusControl.restoreMediaButtonReceiver();
    }

    private int rescaleIndex(int index, int srcStream, int dstStream) {
        return (index * this.mStreamStates[dstStream].getMaxIndex() + this.mStreamStates[srcStream].getMaxIndex() / 2) / this.mStreamStates[srcStream].getMaxIndex();
    }

    public boolean isLocalOrRemoteMusicActive() {
        if (AudioSystem.isStreamActive(3, 0)) {
            return true;
        }
        if (this.mMediaFocusControl.checkUpdateRemoteStateIfActive(3)) {
            return true;
        }
        return AudioSystem.isStreamActiveRemotely(3, 0);
    }

    public void adjustVolume(int direction, int flags, String callingPackage) {
        this.adjustSuggestedStreamVolume(direction, Integer.MIN_VALUE, flags, callingPackage);
    }

    public void adjustLocalOrRemoteStreamVolume(int streamType, int direction, String callingPackage) {
        if (AudioSystem.isStreamActive(3, 0)) {
            this.adjustStreamVolume(3, direction, 0, callingPackage);
        } else if (this.mMediaFocusControl.checkUpdateRemoteStateIfActive(3)) {
            this.mMediaFocusControl.adjustRemoteVolume(3, direction, 0);
        }
    }

    public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags, String callingPackage) {
        int streamType = this.mVolumeControlStream != -1 ? this.mVolumeControlStream : this.getActiveStreamType(suggestedStreamType);
        if (streamType != -200 && (flags & 4) != 0 && (this.mStreamVolumeAlias[streamType] != 2 || this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked())) {
            flags &= 0xFFFFFFFB;
        }
        if (streamType == -200) {
            this.mMediaFocusControl.adjustRemoteVolume(3, direction, flags &= 0xFFFFFFDB);
        } else {
            this.adjustStreamVolume(streamType, direction, flags, callingPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustStreamVolume(int streamType, int direction, int flags, String callingPackage) {
        int step;
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidDirection(direction);
        this.ensureValidStreamType(streamType);
        int streamTypeAlias = this.mStreamVolumeAlias[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int device = this.getDeviceForStream(streamTypeAlias);
        int aliasIndex = streamState.getIndex(device);
        boolean adjustVolume = true;
        if ((device & 0x380) == 0 && (flags & 0x40) != 0) {
            return;
        }
        if (this.mAppOps.noteOp(STEAM_VOLUME_OPS[streamTypeAlias], Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.mPendingVolumeCommand = null;
        }
        flags &= 0xFFFFFFDF;
        if (streamTypeAlias == 3 && (device & 0x7C00) != 0) {
            flags |= 0x20;
            step = this.mSafeMediaVolumeState == 3 && (device & 0xC) != 0 ? this.mSafeMediaVolumeIndex : streamState.getMaxIndex();
            if (aliasIndex != 0) {
                aliasIndex = step;
            }
        } else {
            step = this.rescaleIndex(10, streamType, streamTypeAlias);
        }
        if ((flags & 2) != 0 || streamTypeAlias == this.getMasterStreamType()) {
            int ringerMode = this.getRingerMode();
            if (ringerMode == 1) {
                flags &= 0xFFFFFFEF;
            }
            adjustVolume = this.checkForRingerModeChange(aliasIndex, direction, step);
        }
        int oldIndex = this.mStreamStates[streamType].getIndex(device);
        if (adjustVolume && direction != 0) {
            if (streamTypeAlias == 3 && (device & 0x380) != 0 && (flags & 0x40) == 0) {
                Object object = this.mA2dpAvrcpLock;
                synchronized (object) {
                    if (this.mA2dp != null && this.mAvrcpAbsVolSupported) {
                        this.mA2dp.adjustAvrcpAbsoluteVolume(direction);
                    }
                }
            }
            if (direction == 1 && !this.checkSafeMediaVolume(streamTypeAlias, aliasIndex + step, device)) {
                Log.e(TAG, "adjustStreamVolume() safe volume index = " + oldIndex);
                this.mVolumePanel.postDisplaySafeVolumeWarning(flags);
            } else if (streamState.adjustIndex(direction * step, device)) {
                AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
            }
        }
        int index = this.mStreamStates[streamType].getIndex(device);
        this.sendVolumeUpdate(streamType, oldIndex, index, flags);
    }

    public void adjustMasterVolume(int steps, int flags, String callingPackage) {
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidSteps(steps);
        int volume = Math.round(AudioSystem.getMasterVolume() * 100.0f);
        int delta = 0;
        int numSteps = Math.abs(steps);
        int direction = steps > 0 ? 1 : -1;
        for (int i = 0; i < numSteps; ++i) {
            delta = this.findVolumeDelta(direction, volume);
            volume += delta;
        }
        this.setMasterVolume(volume, flags, callingPackage);
    }

    private void onSetStreamVolume(int streamType, int index, int flags, int device) {
        this.setStreamVolumeInt(this.mStreamVolumeAlias[streamType], index, device, false);
        if ((flags & 2) != 0 || this.mStreamVolumeAlias[streamType] == this.getMasterStreamType()) {
            int newRingerMode = index == 0 ? (this.mHasVibrator ? 1 : 0) : 2;
            this.setRingerMode(newRingerMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamVolume(int streamType, int index, int flags, String callingPackage) {
        int oldIndex;
        if (this.mUseFixedVolume) {
            return;
        }
        this.ensureValidStreamType(streamType);
        int streamTypeAlias = this.mStreamVolumeAlias[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int device = this.getDeviceForStream(streamType);
        if ((device & 0x380) == 0 && (flags & 0x40) != 0) {
            return;
        }
        if (this.mAppOps.noteOp(STEAM_VOLUME_OPS[streamTypeAlias], Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.mPendingVolumeCommand = null;
            oldIndex = streamState.getIndex(device);
            index = this.rescaleIndex(index * 10, streamType, streamTypeAlias);
            if (streamTypeAlias == 3 && (device & 0x380) != 0 && (flags & 0x40) == 0) {
                Object object = this.mA2dpAvrcpLock;
                synchronized (object) {
                    if (this.mA2dp != null && this.mAvrcpAbsVolSupported) {
                        this.mA2dp.setAvrcpAbsoluteVolume(index);
                    }
                }
            }
            flags &= 0xFFFFFFDF;
            if (streamTypeAlias == 3 && (device & 0x7C00) != 0) {
                flags |= 0x20;
                if (index != 0) {
                    index = this.mSafeMediaVolumeState == 3 && (device & 0xC) != 0 ? this.mSafeMediaVolumeIndex : streamState.getMaxIndex();
                }
            }
            if (!this.checkSafeMediaVolume(streamTypeAlias, index, device)) {
                this.mVolumePanel.postDisplaySafeVolumeWarning(flags);
                this.mPendingVolumeCommand = new StreamVolumeCommand(streamType, index, flags, device);
            } else {
                this.onSetStreamVolume(streamType, index, flags, device);
                index = this.mStreamStates[streamType].getIndex(device);
            }
        }
        this.sendVolumeUpdate(streamType, oldIndex, index, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceVolumeControlStream(int streamType, IBinder cb) {
        Object object = this.mForceControlStreamLock;
        synchronized (object) {
            this.mVolumeControlStream = streamType;
            if (this.mVolumeControlStream == -1) {
                if (this.mForceControlStreamClient != null) {
                    this.mForceControlStreamClient.release();
                    this.mForceControlStreamClient = null;
                }
            } else {
                this.mForceControlStreamClient = new ForceControlStreamClient(cb);
            }
        }
    }

    private int findVolumeDelta(int direction, int volume) {
        int delta;
        block4: {
            block5: {
                delta = 0;
                if (direction != 1) break block5;
                if (volume == 100) {
                    return 0;
                }
                delta = this.mMasterVolumeRamp[1];
                for (int i = this.mMasterVolumeRamp.length - 1; i > 1; i -= 2) {
                    if (volume < this.mMasterVolumeRamp[i - 1]) continue;
                    delta = this.mMasterVolumeRamp[i];
                    break block4;
                }
                break block4;
            }
            if (direction != -1) break block4;
            if (volume == 0) {
                return 0;
            }
            int length = this.mMasterVolumeRamp.length;
            delta = -this.mMasterVolumeRamp[length - 1];
            for (int i = 2; i < length; i += 2) {
                if (volume > this.mMasterVolumeRamp[i]) continue;
                delta = -this.mMasterVolumeRamp[i - 1];
                break;
            }
        }
        return delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBroadcastToAll(Intent intent) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcastToAll(Intent intent) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void sendVolumeUpdate(int streamType, int oldIndex, int index, int flags) {
        if (!this.mVoiceCapable && streamType == 2) {
            streamType = 5;
        }
        this.mVolumePanel.postVolumeChanged(streamType, flags);
        if ((flags & 0x20) == 0) {
            oldIndex = (oldIndex + 5) / 10;
            index = (index + 5) / 10;
            Intent intent = new Intent("android.media.VOLUME_CHANGED_ACTION");
            intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", streamType);
            intent.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", index);
            intent.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", oldIndex);
            this.sendBroadcastToAll(intent);
        }
    }

    private void sendMasterVolumeUpdate(int flags, int oldVolume, int newVolume) {
        this.mVolumePanel.postMasterVolumeChanged(flags);
        Intent intent = new Intent("android.media.MASTER_VOLUME_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_PREV_MASTER_VOLUME_VALUE", oldVolume);
        intent.putExtra("android.media.EXTRA_MASTER_VOLUME_VALUE", newVolume);
        this.sendBroadcastToAll(intent);
    }

    private void sendMasterMuteUpdate(boolean muted, int flags) {
        this.mVolumePanel.postMasterMuteChanged(flags);
        this.broadcastMasterMuteStatus(muted);
    }

    private void broadcastMasterMuteStatus(boolean muted) {
        Intent intent = new Intent("android.media.MASTER_MUTE_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_MASTER_VOLUME_MUTED", muted);
        intent.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(intent);
    }

    private void setStreamVolumeInt(int streamType, int index, int device, boolean force) {
        VolumeStreamState streamState = this.mStreamStates[streamType];
        if (streamState.setIndex(index, device) || force) {
            AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
        }
    }

    public void setStreamSolo(int streamType, boolean state, IBinder cb) {
        if (this.mUseFixedVolume) {
            return;
        }
        for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
            if (!this.isStreamAffectedByMute(stream) || stream == streamType) continue;
            this.mStreamStates[stream].mute(cb, state);
        }
    }

    public void setStreamMute(int streamType, boolean state, IBinder cb) {
        if (this.mUseFixedVolume) {
            return;
        }
        if (this.isStreamAffectedByMute(streamType)) {
            this.mStreamStates[streamType].mute(cb, state);
        }
    }

    public boolean isStreamMute(int streamType) {
        return this.mStreamStates[streamType].isMuted();
    }

    public void setMasterMute(boolean state, int flags, IBinder cb) {
        if (this.mUseFixedVolume) {
            return;
        }
        if (state != AudioSystem.getMasterMute()) {
            AudioSystem.setMasterMute(state);
            AudioService.sendMsg(this.mAudioHandler, 11, 0, state ? 1 : 0, 0, null, 500);
            this.sendMasterMuteUpdate(state, flags);
        }
    }

    public boolean isMasterMute() {
        return AudioSystem.getMasterMute();
    }

    protected static int getMaxStreamVolume(int streamType) {
        return MAX_STREAM_VOLUME[streamType];
    }

    public int getStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        int device = this.getDeviceForStream(streamType);
        int index = this.mStreamStates[streamType].getIndex(device);
        if (this.mStreamStates[streamType].isMuted()) {
            index = 0;
        }
        if (index != 0 && this.mStreamVolumeAlias[streamType] == 3 && (device & 0x7C00) != 0) {
            index = this.mStreamStates[streamType].getMaxIndex();
        }
        return (index + 5) / 10;
    }

    public int getMasterVolume() {
        if (this.isMasterMute()) {
            return 0;
        }
        return this.getLastAudibleMasterVolume();
    }

    public void setMasterVolume(int volume, int flags, String callingPackage) {
        if (this.mUseFixedVolume) {
            return;
        }
        if (this.mAppOps.noteOp(33, Binder.getCallingUid(), callingPackage) != 0) {
            return;
        }
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        this.doSetMasterVolume((float)volume / 100.0f, flags);
    }

    private void doSetMasterVolume(float volume, int flags) {
        if (!AudioSystem.getMasterMute()) {
            int oldVolume = this.getMasterVolume();
            AudioSystem.setMasterVolume(volume);
            int newVolume = this.getMasterVolume();
            if (newVolume != oldVolume) {
                AudioService.sendMsg(this.mAudioHandler, 2, 0, Math.round(volume * 1000.0f), 0, null, 500);
            }
            this.sendMasterVolumeUpdate(flags, oldVolume, newVolume);
        }
    }

    public int getStreamMaxVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].getMaxIndex() + 5) / 10;
    }

    public int getMasterMaxVolume() {
        return 100;
    }

    public int getLastAudibleStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        int device = this.getDeviceForStream(streamType);
        return (this.mStreamStates[streamType].getIndex(device) + 5) / 10;
    }

    public int getLastAudibleMasterVolume() {
        return Math.round(AudioSystem.getMasterVolume() * 100.0f);
    }

    public int getMasterStreamType() {
        if (this.mVoiceCapable) {
            return 2;
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRingerMode() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mRingerMode;
        }
    }

    private void ensureValidRingerMode(int ringerMode) {
        if (!AudioManager.isValidRingerMode(ringerMode)) {
            throw new IllegalArgumentException("Bad ringer mode " + ringerMode);
        }
    }

    public void setRingerMode(int ringerMode) {
        if (this.mUseFixedVolume) {
            return;
        }
        if (ringerMode == 1 && !this.mHasVibrator) {
            ringerMode = 0;
        }
        if (ringerMode != this.getRingerMode()) {
            this.setRingerModeInt(ringerMode, true);
            this.broadcastRingerMode(ringerMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRingerModeInt(int ringerMode, boolean persist) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mRingerMode = ringerMode;
        }
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
            if (this.isStreamMutedByRingerMode(streamType)) {
                if (this.isStreamAffectedByRingerMode(streamType) && ringerMode != 2) continue;
                if (this.mVoiceCapable && this.mStreamVolumeAlias[streamType] == 2) {
                    VolumeStreamState volumeStreamState = this.mStreamStates[streamType];
                    synchronized (volumeStreamState) {
                        Set set = this.mStreamStates[streamType].mIndex.entrySet();
                        for (Map.Entry entry : set) {
                            if ((Integer)entry.getValue() != 0) continue;
                            entry.setValue(10);
                        }
                    }
                }
                this.mStreamStates[streamType].mute(null, false);
                this.mRingerModeMutedStreams &= ~(1 << streamType);
                continue;
            }
            if (!this.isStreamAffectedByRingerMode(streamType) || ringerMode == 2) continue;
            this.mStreamStates[streamType].mute(null, true);
            this.mRingerModeMutedStreams |= 1 << streamType;
        }
        if (persist) {
            AudioService.sendMsg(this.mAudioHandler, 3, 0, 0, 0, null, 500);
        }
    }

    private void restoreMasterVolume() {
        float volume;
        if (this.mUseFixedVolume) {
            AudioSystem.setMasterVolume(1.0f);
            return;
        }
        if (this.mUseMasterVolume && (volume = Settings.System.getFloatForUser(this.mContentResolver, "volume_master", -1.0f, -2)) >= 0.0f) {
            AudioSystem.setMasterVolume(volume);
        }
    }

    public boolean shouldVibrate(int vibrateType) {
        if (!this.mHasVibrator) {
            return false;
        }
        switch (this.getVibrateSetting(vibrateType)) {
            case 1: {
                return this.getRingerMode() != 0;
            }
            case 2: {
                return this.getRingerMode() == 1;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public int getVibrateSetting(int vibrateType) {
        if (!this.mHasVibrator) {
            return 0;
        }
        return this.mVibrateSetting >> vibrateType * 2 & 3;
    }

    public void setVibrateSetting(int vibrateType, int vibrateSetting) {
        if (!this.mHasVibrator) {
            return;
        }
        this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, vibrateType, vibrateSetting);
        this.broadcastVibrateSetting(vibrateType);
    }

    public static int getValueForVibrateSetting(int existingValue, int vibrateType, int vibrateSetting) {
        existingValue &= ~(3 << vibrateType * 2);
        return existingValue |= (vibrateSetting & 3) << vibrateType * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode, IBinder cb) {
        if (!this.checkAudioSettingsPermission("setMode()")) {
            return;
        }
        if (mode < -1 || mode >= 4) {
            return;
        }
        int newModeOwnerPid = 0;
        ArrayList<SetModeDeathHandler> arrayList = this.mSetModeDeathHandlers;
        synchronized (arrayList) {
            if (mode == -1) {
                mode = this.mMode;
            }
            newModeOwnerPid = this.setModeInt(mode, cb, Binder.getCallingPid());
        }
        if (newModeOwnerPid != 0) {
            this.disconnectBluetoothSco(newModeOwnerPid);
        }
    }

    int setModeInt(int mode, IBinder cb, int pid) {
        int newModeOwnerPid = 0;
        if (cb == null) {
            Log.e(TAG, "setModeInt() called with null binder");
            return newModeOwnerPid;
        }
        SetModeDeathHandler hdlr = null;
        Iterator<SetModeDeathHandler> iter = this.mSetModeDeathHandlers.iterator();
        while (iter.hasNext()) {
            SetModeDeathHandler h = iter.next();
            if (h.getPid() != pid) continue;
            hdlr = h;
            iter.remove();
            hdlr.getBinder().unlinkToDeath(hdlr, 0);
            break;
        }
        int status = 0;
        do {
            if (mode == 0) {
                if (!this.mSetModeDeathHandlers.isEmpty()) {
                    hdlr = this.mSetModeDeathHandlers.get(0);
                    cb = hdlr.getBinder();
                    mode = hdlr.getMode();
                }
            } else {
                if (hdlr == null) {
                    hdlr = new SetModeDeathHandler(cb, pid);
                }
                try {
                    cb.linkToDeath(hdlr, 0);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "setMode() could not link to " + cb + " binder death");
                }
                this.mSetModeDeathHandlers.add(0, hdlr);
                hdlr.setMode(mode);
            }
            if (mode != this.mMode) {
                status = AudioSystem.setPhoneState(mode);
                if (status == 0) {
                    this.mMode = mode;
                    continue;
                }
                if (hdlr != null) {
                    this.mSetModeDeathHandlers.remove(hdlr);
                    cb.unlinkToDeath(hdlr, 0);
                }
                mode = 0;
                continue;
            }
            status = 0;
        } while (status != 0 && !this.mSetModeDeathHandlers.isEmpty());
        if (status == 0) {
            int streamType;
            if (mode != 0) {
                if (this.mSetModeDeathHandlers.isEmpty()) {
                    Log.e(TAG, "setMode() different from MODE_NORMAL with empty mode client stack");
                } else {
                    newModeOwnerPid = this.mSetModeDeathHandlers.get(0).getPid();
                }
            }
            if ((streamType = this.getActiveStreamType(Integer.MIN_VALUE)) == -200) {
                streamType = 3;
            }
            int device = this.getDeviceForStream(streamType);
            int index = this.mStreamStates[this.mStreamVolumeAlias[streamType]].getIndex(device);
            this.setStreamVolumeInt(this.mStreamVolumeAlias[streamType], index, device, true);
            this.updateStreamVolumeAlias(true);
        }
        return newModeOwnerPid;
    }

    public int getMode() {
        return this.mMode;
    }

    private void loadTouchSoundAssetDefaults() {
        SOUND_EFFECT_FILES.add("Effect_Tick.ogg");
        for (int i = 0; i < 10; ++i) {
            this.SOUND_EFFECT_FILES_MAP[i][0] = 0;
            this.SOUND_EFFECT_FILES_MAP[i][1] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTouchSoundAssets() {
        block17: {
            XmlResourceParser parser = null;
            if (!SOUND_EFFECT_FILES.isEmpty()) {
                return;
            }
            this.loadTouchSoundAssetDefaults();
            try {
                String element;
                boolean inTouchSoundsGroup;
                block18: {
                    String name;
                    parser = this.mContext.getResources().getXml(0x10F0001);
                    XmlUtils.beginDocument(parser, TAG_AUDIO_ASSETS);
                    String version = parser.getAttributeValue(null, ATTR_VERSION);
                    inTouchSoundsGroup = false;
                    if (!ASSET_FILE_VERSION.equals(version)) break block17;
                    do {
                        XmlUtils.nextElement(parser);
                        element = parser.getName();
                        if (element == null) break block18;
                    } while (!element.equals(TAG_GROUP) || !GROUP_TOUCH_SOUNDS.equals(name = parser.getAttributeValue(null, ATTR_GROUP_NAME)));
                    inTouchSoundsGroup = true;
                }
                while (inTouchSoundsGroup) {
                    XmlUtils.nextElement(parser);
                    element = parser.getName();
                    if (element == null) {
                        break;
                    }
                    if (!element.equals(TAG_ASSET)) break;
                    String id2 = parser.getAttributeValue(null, ATTR_ASSET_ID);
                    String file = parser.getAttributeValue(null, ATTR_ASSET_FILE);
                    try {
                        Field field = AudioManager.class.getField(id2);
                        int fx = field.getInt(null);
                    }
                    catch (Exception e) {
                        Log.w(TAG, "Invalid touch sound ID: " + id2);
                        continue;
                    }
                    int i = SOUND_EFFECT_FILES.indexOf(file);
                    if (i == -1) {
                        i = SOUND_EFFECT_FILES.size();
                        SOUND_EFFECT_FILES.add(file);
                    }
                    this.SOUND_EFFECT_FILES_MAP[fx][0] = i;
                }
            }
            catch (Resources.NotFoundException e) {
                Log.w(TAG, "audio assets file not found", e);
            }
            catch (XmlPullParserException e) {
                Log.w(TAG, "XML parser exception reading touch sound assets", e);
            }
            catch (IOException e) {
                Log.w(TAG, "I/O exception reading touch sound assets", e);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
    }

    public void playSoundEffect(int effectType) {
        this.playSoundEffectVolume(effectType, -1.0f);
    }

    public void playSoundEffectVolume(int effectType, float volume) {
        AudioService.sendMsg(this.mAudioHandler, 5, 2, effectType, (int)(volume * 1000.0f), null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSoundEffects() {
        LoadSoundEffectReply reply;
        int attempts = 3;
        LoadSoundEffectReply loadSoundEffectReply = reply = new LoadSoundEffectReply();
        synchronized (loadSoundEffectReply) {
            AudioService.sendMsg(this.mAudioHandler, 7, 2, 0, 0, reply, 0);
            while (reply.mStatus == 1 && attempts-- > 0) {
                try {
                    reply.wait(5000L);
                }
                catch (InterruptedException e) {
                    Log.w(TAG, "loadSoundEffects Interrupted while waiting sound pool loaded.");
                }
            }
        }
        return reply.mStatus == 0;
    }

    public void unloadSoundEffects() {
        AudioService.sendMsg(this.mAudioHandler, 20, 2, 0, 0, null, 0);
    }

    public void reloadAudioSettings() {
        this.readAudioSettings(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAudioSettings(boolean userSwitch) {
        this.readPersistedSettings();
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            VolumeStreamState streamState = this.mStreamStates[streamType];
            if (userSwitch && this.mStreamVolumeAlias[streamType] == 3) continue;
            VolumeStreamState volumeStreamState = streamState;
            synchronized (volumeStreamState) {
                streamState.readSettings();
                if (streamState.isMuted() && (!this.isStreamAffectedByMute(streamType) && !this.isStreamMutedByRingerMode(streamType) || this.mUseFixedVolume)) {
                    int size = streamState.mDeathHandlers.size();
                    for (int i = 0; i < size; ++i) {
                        ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mMuteCount = 1;
                        ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mute(false);
                    }
                }
                continue;
            }
        }
        this.setRingerModeInt(this.getRingerMode(), false);
        this.checkAllAliasStreamVolumes();
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            if (this.mSafeMediaVolumeState == 3) {
                this.enforceSafeMediaVolume();
            }
        }
    }

    public void setSpeakerphoneOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setSpeakerphoneOn()")) {
            return;
        }
        if (on) {
            if (this.mForcedUseForComm == 3) {
                AudioService.sendMsg(this.mAudioHandler, 8, 2, 2, 0, null, 0);
            }
            this.mForcedUseForComm = 1;
        } else if (this.mForcedUseForComm == 1) {
            this.mForcedUseForComm = 0;
        }
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 0, this.mForcedUseForComm, null, 0);
    }

    public boolean isSpeakerphoneOn() {
        return this.mForcedUseForComm == 1;
    }

    public void setBluetoothScoOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setBluetoothScoOn()")) {
            return;
        }
        if (on) {
            this.mForcedUseForComm = 3;
        } else if (this.mForcedUseForComm == 3) {
            this.mForcedUseForComm = 0;
        }
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 0, this.mForcedUseForComm, null, 0);
        AudioService.sendMsg(this.mAudioHandler, 8, 2, 2, this.mForcedUseForComm, null, 0);
    }

    public boolean isBluetoothScoOn() {
        return this.mForcedUseForComm == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBluetoothA2dpOn(boolean on) {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            this.mBluetoothA2dpEnabled = on;
            AudioService.sendMsg(this.mAudioHandler, 13, 2, 1, this.mBluetoothA2dpEnabled ? 0 : 10, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBluetoothA2dpOn() {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            return this.mBluetoothA2dpEnabled;
        }
    }

    public void startBluetoothSco(IBinder cb, int targetSdkVersion) {
        if (!this.checkAudioSettingsPermission("startBluetoothSco()") || !this.mBootCompleted) {
            return;
        }
        ScoClient client = this.getScoClient(cb, true);
        long ident = Binder.clearCallingIdentity();
        client.incCount(targetSdkVersion);
        Binder.restoreCallingIdentity(ident);
    }

    public void stopBluetoothSco(IBinder cb) {
        if (!this.checkAudioSettingsPermission("stopBluetoothSco()") || !this.mBootCompleted) {
            return;
        }
        ScoClient client = this.getScoClient(cb, false);
        long ident = Binder.clearCallingIdentity();
        if (client != null) {
            client.decCount();
        }
        Binder.restoreCallingIdentity(ident);
    }

    private void checkScoAudioState() {
        if (this.mBluetoothHeadset != null && this.mBluetoothHeadsetDevice != null && this.mScoAudioState == 0 && this.mBluetoothHeadset.getAudioState(this.mBluetoothHeadsetDevice) != 10) {
            this.mScoAudioState = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScoClient getScoClient(IBinder cb, boolean create) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient client = null;
            int size = this.mScoClients.size();
            for (int i = 0; i < size; ++i) {
                client = this.mScoClients.get(i);
                if (client.getBinder() != cb) continue;
                return client;
            }
            if (create) {
                client = new ScoClient(cb);
                this.mScoClients.add(client);
            }
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllScoClients(int exceptPid, boolean stopSco) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient savedClient = null;
            int size = this.mScoClients.size();
            for (int i = 0; i < size; ++i) {
                ScoClient cl = this.mScoClients.get(i);
                if (cl.getPid() != exceptPid) {
                    cl.clearCount(stopSco);
                    continue;
                }
                savedClient = cl;
            }
            this.mScoClients.clear();
            if (savedClient != null) {
                this.mScoClients.add(savedClient);
            }
        }
    }

    private boolean getBluetoothHeadset() {
        boolean result = false;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            result = adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
        }
        AudioService.sendMsg(this.mAudioHandler, 9, 0, 0, 0, null, result ? 3000 : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectBluetoothSco(int exceptPid) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.checkScoAudioState();
            if (this.mScoAudioState == 2 || this.mScoAudioState == 4) {
                if (this.mBluetoothHeadsetDevice != null) {
                    if (this.mBluetoothHeadset != null) {
                        if (!this.mBluetoothHeadset.stopVoiceRecognition(this.mBluetoothHeadsetDevice)) {
                            AudioService.sendMsg(this.mAudioHandler, 9, 0, 0, 0, null, 0);
                        }
                    } else if (this.mScoAudioState == 2 && this.getBluetoothHeadset()) {
                        this.mScoAudioState = 4;
                    }
                }
            } else {
                this.clearAllScoClients(exceptPid, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetBluetoothSco() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.clearAllScoClients(0, false);
            this.mScoAudioState = 0;
            this.broadcastScoConnectionState(0);
        }
    }

    private void broadcastScoConnectionState(int state) {
        AudioService.sendMsg(this.mAudioHandler, 19, 2, state, 0, null, 0);
    }

    private void onBroadcastScoConnectionState(int state) {
        if (state != this.mScoConnectionState) {
            Intent newIntent = new Intent("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", state);
            newIntent.putExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", this.mScoConnectionState);
            this.sendStickyBroadcastToAll(newIntent);
            this.mScoConnectionState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCheckMusicActive() {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            int device;
            if (this.mSafeMediaVolumeState == 2 && ((device = this.getDeviceForStream(3)) & 0xC) != 0) {
                AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                int index = this.mStreamStates[3].getIndex(device);
                if (AudioSystem.isStreamActive(3, 0) && index > this.mSafeMediaVolumeIndex) {
                    this.mMusicActiveMs += 60000;
                    if (this.mMusicActiveMs > 72000000) {
                        this.setSafeMediaVolumeEnabled(true);
                        this.mMusicActiveMs = 0;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConfigureSafeVolume(boolean force) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            int mcc = this.mContext.getResources().getConfiguration().mcc;
            if (this.mMcc != mcc || this.mMcc == 0 && force) {
                int persistedState;
                this.mSafeMediaVolumeIndex = this.mContext.getResources().getInteger(17694788) * 10;
                boolean safeMediaVolumeEnabled = this.mContext.getResources().getBoolean(0x1110051);
                if (safeMediaVolumeEnabled) {
                    persistedState = 3;
                    if (this.mSafeMediaVolumeState != 2) {
                        this.mSafeMediaVolumeState = 3;
                        this.enforceSafeMediaVolume();
                    }
                } else {
                    persistedState = 1;
                    this.mSafeMediaVolumeState = 1;
                }
                this.mMcc = mcc;
                AudioService.sendMsg(this.mAudioHandler, 18, 2, persistedState, 0, null, 0);
            }
        }
    }

    private boolean checkForRingerModeChange(int oldIndex, int direction, int step) {
        boolean adjustVolumeIndex = true;
        int ringerMode = this.getRingerMode();
        switch (ringerMode) {
            case 2: {
                if (direction != -1) break;
                if (this.mHasVibrator) {
                    if (step > oldIndex || oldIndex >= 2 * step) break;
                    ringerMode = 1;
                    break;
                }
                if (oldIndex >= step || this.mPrevVolDirection == -1) break;
                ringerMode = 0;
                break;
            }
            case 1: {
                if (!this.mHasVibrator) {
                    Log.e(TAG, "checkForRingerModeChange() current ringer mode is vibratebut no vibrator is present");
                    break;
                }
                if (direction == -1) {
                    if (this.mPrevVolDirection != -1) {
                        ringerMode = 0;
                    }
                } else if (direction == 1) {
                    ringerMode = 2;
                }
                adjustVolumeIndex = false;
                break;
            }
            case 0: {
                if (direction == 1) {
                    ringerMode = this.mHasVibrator ? 1 : 2;
                }
                adjustVolumeIndex = false;
                break;
            }
            default: {
                Log.e(TAG, "checkForRingerModeChange() wrong ringer mode: " + ringerMode);
            }
        }
        this.setRingerMode(ringerMode);
        this.mPrevVolDirection = direction;
        return adjustVolumeIndex;
    }

    public boolean isStreamAffectedByRingerMode(int streamType) {
        return (this.mRingerModeAffectedStreams & 1 << streamType) != 0;
    }

    private boolean isStreamMutedByRingerMode(int streamType) {
        return (this.mRingerModeMutedStreams & 1 << streamType) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateRingerModeAffectedStreams() {
        int ringerModeAffectedStreams = Settings.System.getIntForUser(this.mContentResolver, "mode_ringer_streams_affected", 166, -2);
        ringerModeAffectedStreams |= 0x26;
        ringerModeAffectedStreams = this.mVoiceCapable ? (ringerModeAffectedStreams &= 0xFFFFFFF7) : (ringerModeAffectedStreams |= 8);
        Boolean bl = this.mCameraSoundForced;
        synchronized (bl) {
            ringerModeAffectedStreams = this.mCameraSoundForced.booleanValue() ? (ringerModeAffectedStreams &= 0xFFFFFF7F) : (ringerModeAffectedStreams |= 0x80);
        }
        ringerModeAffectedStreams = this.mStreamVolumeAlias[8] == 2 ? (ringerModeAffectedStreams |= 0x100) : (ringerModeAffectedStreams &= 0xFFFFFEFF);
        if (ringerModeAffectedStreams != this.mRingerModeAffectedStreams) {
            Settings.System.putIntForUser(this.mContentResolver, "mode_ringer_streams_affected", ringerModeAffectedStreams, -2);
            this.mRingerModeAffectedStreams = ringerModeAffectedStreams;
            return true;
        }
        return false;
    }

    public boolean isStreamAffectedByMute(int streamType) {
        return (this.mMuteAffectedStreams & 1 << streamType) != 0;
    }

    private void ensureValidDirection(int direction) {
        if (direction < -1 || direction > 1) {
            throw new IllegalArgumentException("Bad direction " + direction);
        }
    }

    private void ensureValidSteps(int steps) {
        if (Math.abs(steps) > 4) {
            throw new IllegalArgumentException("Bad volume adjust steps " + steps);
        }
    }

    private void ensureValidStreamType(int streamType) {
        if (streamType < 0 || streamType >= this.mStreamStates.length) {
            throw new IllegalArgumentException("Bad stream type " + streamType);
        }
    }

    private boolean isInCommunication() {
        boolean isOffhook = false;
        if (this.mVoiceCapable) {
            try {
                ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
                if (phone != null) {
                    isOffhook = phone.isOffhook();
                }
            }
            catch (RemoteException e) {
                Log.w(TAG, "Couldn't connect to phone service", e);
            }
        }
        return isOffhook || this.getMode() == 3;
    }

    private boolean isAfMusicActiveRecently(int delay_ms) {
        return AudioSystem.isStreamActive(3, delay_ms) || AudioSystem.isStreamActiveRemotely(3, delay_ms);
    }

    private int getActiveStreamType(int suggestedStreamType) {
        if (this.mVoiceCapable) {
            if (this.isInCommunication()) {
                if (AudioSystem.getForceUse(0) == 3) {
                    return 6;
                }
                return 0;
            }
            if (suggestedStreamType == Integer.MIN_VALUE) {
                if (this.isAfMusicActiveRecently(5000)) {
                    return 3;
                }
                if (this.mMediaFocusControl.checkUpdateRemoteStateIfActive(3)) {
                    return -200;
                }
                return 2;
            }
            if (this.isAfMusicActiveRecently(0)) {
                return 3;
            }
            return suggestedStreamType;
        }
        if (this.isInCommunication()) {
            if (AudioSystem.getForceUse(0) == 3) {
                return 6;
            }
            return 0;
        }
        if (AudioSystem.isStreamActive(5, 5000) || AudioSystem.isStreamActive(2, 5000)) {
            return 5;
        }
        if (suggestedStreamType == Integer.MIN_VALUE) {
            if (this.isAfMusicActiveRecently(5000)) {
                return 3;
            }
            if (this.mMediaFocusControl.checkUpdateRemoteStateIfActive(3)) {
                return -200;
            }
            return 3;
        }
        return suggestedStreamType;
    }

    private void broadcastRingerMode(int ringerMode) {
        Intent broadcast = new Intent("android.media.RINGER_MODE_CHANGED");
        broadcast.putExtra("android.media.EXTRA_RINGER_MODE", ringerMode);
        broadcast.addFlags(0x24000000);
        this.sendStickyBroadcastToAll(broadcast);
    }

    private void broadcastVibrateSetting(int vibrateType) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent broadcast = new Intent("android.media.VIBRATE_SETTING_CHANGED");
            broadcast.putExtra("android.media.EXTRA_VIBRATE_TYPE", vibrateType);
            broadcast.putExtra("android.media.EXTRA_VIBRATE_SETTING", this.getVibrateSetting(vibrateType));
            this.sendBroadcastToAll(broadcast);
        }
    }

    private void queueMsgUnderWakeLock(Handler handler, int msg, int arg1, int arg2, Object obj, int delay) {
        long ident = Binder.clearCallingIdentity();
        this.mAudioEventWakeLock.acquire();
        Binder.restoreCallingIdentity(ident);
        AudioService.sendMsg(handler, msg, 2, arg1, arg2, obj, delay);
    }

    private static void sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delay);
    }

    boolean checkAudioSettingsPermission(String method) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        String msg = "Audio Settings Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        Log.w(TAG, msg);
        return false;
    }

    private int getDeviceForStream(int stream) {
        int device = AudioSystem.getDevicesForStream(stream);
        if ((device & device - 1) != 0) {
            device = (device & 2) != 0 ? 2 : (device &= 0x380);
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWiredDeviceConnectionState(int device, int state, String name) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            int delay = this.checkSendBecomingNoisyIntent(device, state);
            this.queueMsgUnderWakeLock(this.mAudioHandler, 100, device, state, name, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBluetoothA2dpDeviceConnectionState(BluetoothDevice device, int state) {
        int delay;
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            delay = this.checkSendBecomingNoisyIntent(128, state == 2 ? 1 : 0);
            this.queueMsgUnderWakeLock(this.mAudioHandler, 101, state, 0, device, delay);
        }
        return delay;
    }

    private void makeA2dpDeviceAvailable(String address) {
        VolumeStreamState streamState = this.mStreamStates[3];
        AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, streamState, 0);
        this.setBluetoothA2dpOnInt(true);
        AudioSystem.setDeviceConnectionState(128, 1, address);
        AudioSystem.setParameters("A2dpSuspended=false");
        this.mConnectedDevices.put(new Integer(128), address);
    }

    private void onSendBecomingNoisyIntent() {
        this.sendBroadcastToAll(new Intent("android.media.AUDIO_BECOMING_NOISY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeA2dpDeviceUnavailableNow(String address) {
        Object object = this.mA2dpAvrcpLock;
        synchronized (object) {
            this.mAvrcpAbsVolSupported = false;
        }
        AudioSystem.setDeviceConnectionState(128, 0, address);
        this.mConnectedDevices.remove(128);
    }

    private void makeA2dpDeviceUnavailableLater(String address) {
        AudioSystem.setParameters("A2dpSuspended=true");
        this.mConnectedDevices.remove(128);
        Message msg = this.mAudioHandler.obtainMessage(6, address);
        this.mAudioHandler.sendMessageDelayed(msg, 8000L);
    }

    private void cancelA2dpDeviceTimeout() {
        this.mAudioHandler.removeMessages(6);
    }

    private boolean hasScheduledA2dpDockTimeout() {
        return this.mAudioHandler.hasMessages(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetA2dpConnectionState(BluetoothDevice btDevice, int state) {
        if (btDevice == null) {
            return;
        }
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean isConnected;
            boolean bl = isConnected = this.mConnectedDevices.containsKey(128) && this.mConnectedDevices.get(128).equals(address);
            if (isConnected && state != 2) {
                if (btDevice.isBluetoothDock()) {
                    if (state == 0) {
                        this.makeA2dpDeviceUnavailableLater(address);
                    }
                } else {
                    this.makeA2dpDeviceUnavailableNow(address);
                }
                AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
                synchronized (audioRoutesInfo) {
                    if (this.mCurAudioRoutes.mBluetoothName != null) {
                        this.mCurAudioRoutes.mBluetoothName = null;
                        AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                    }
                }
            }
            if (!isConnected && state == 2) {
                if (btDevice.isBluetoothDock()) {
                    this.cancelA2dpDeviceTimeout();
                    this.mDockAddress = address;
                } else if (this.hasScheduledA2dpDockTimeout()) {
                    this.cancelA2dpDeviceTimeout();
                    this.makeA2dpDeviceUnavailableNow(this.mDockAddress);
                }
                this.makeA2dpDeviceAvailable(address);
                AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
                synchronized (audioRoutesInfo) {
                    String name = btDevice.getAliasName();
                    if (!TextUtils.equals(this.mCurAudioRoutes.mBluetoothName, name)) {
                        this.mCurAudioRoutes.mBluetoothName = name;
                        AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void avrcpSupportsAbsoluteVolume(String address, boolean support) {
        Object object = this.mA2dpAvrcpLock;
        synchronized (object) {
            this.mAvrcpAbsVolSupported = support;
            VolumeStreamState streamState = this.mStreamStates[3];
            AudioService.sendMsg(this.mAudioHandler, 0, 2, 128, 0, streamState, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleDeviceConnection(boolean connected, int device, String params) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean isConnected;
            boolean bl = isConnected = this.mConnectedDevices.containsKey(device) && (params.isEmpty() || this.mConnectedDevices.get(device).equals(params));
            if (isConnected && !connected) {
                AudioSystem.setDeviceConnectionState(device, 0, this.mConnectedDevices.get(device));
                this.mConnectedDevices.remove(device);
                return true;
            }
            if (!isConnected && connected) {
                AudioSystem.setDeviceConnectionState(device, 1, params);
                this.mConnectedDevices.put(new Integer(device), params);
                return true;
            }
        }
        return false;
    }

    private int checkSendBecomingNoisyIntent(int device, int state) {
        int delay = 0;
        if (state == 0 && (device & this.mBecomingNoisyIntentDevices) != 0) {
            int devices = 0;
            for (int dev : this.mConnectedDevices.keySet()) {
                if ((dev & this.mBecomingNoisyIntentDevices) == 0) continue;
                devices |= dev;
            }
            if (devices == device) {
                AudioService.sendMsg(this.mAudioHandler, 15, 0, 0, 0, null, 0);
                delay = 1000;
            }
        }
        if (this.mAudioHandler.hasMessages(101) || this.mAudioHandler.hasMessages(100)) {
            delay = 1000;
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDeviceConnectionIntent(int device, int state, String name) {
        Intent intent = new Intent();
        intent.putExtra("state", state);
        intent.putExtra(ATTR_GROUP_NAME, name);
        intent.addFlags(0x40000000);
        int connType = 0;
        if (device == 4) {
            connType = 1;
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 1);
        } else if (device == 8) {
            connType = 2;
            intent.setAction("android.intent.action.HEADSET_PLUG");
            intent.putExtra("microphone", 0);
        } else if (device == 2048) {
            connType = 4;
            intent.setAction("android.intent.action.ANALOG_AUDIO_DOCK_PLUG");
        } else if (device == 4096) {
            connType = 4;
            intent.setAction("android.intent.action.DIGITAL_AUDIO_DOCK_PLUG");
        } else if (device == 1024) {
            connType = 8;
            intent.setAction("android.intent.action.HDMI_AUDIO_PLUG");
        }
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            if (connType != 0) {
                int newConn = this.mCurAudioRoutes.mMainType;
                newConn = state != 0 ? (newConn |= connType) : (newConn &= ~connType);
                if (newConn != this.mCurAudioRoutes.mMainType) {
                    this.mCurAudioRoutes.mMainType = newConn;
                    AudioService.sendMsg(this.mAudioHandler, 12, 1, 0, 0, null, 0);
                }
            }
        }
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerNative.broadcastStickyIntent(intent, null, -1);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetWiredDeviceConnectionState(int device, int state, String name) {
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            if (state == 0 && (device == 4 || device == 8)) {
                this.setBluetoothA2dpOnInt(true);
            }
            boolean isUsb = (device & 0x6000) != 0;
            this.handleDeviceConnection(state == 1, device, isUsb ? name : "");
            if (state != 0) {
                if (device == 4 || device == 8) {
                    this.setBluetoothA2dpOnInt(false);
                }
                if ((device & 0xC) != 0) {
                    AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                }
            }
            if (!isUsb) {
                this.sendDeviceConnectionIntent(device, state, name);
            }
        }
    }

    public boolean registerRemoteController(IRemoteControlDisplay rcd, int w, int h, ComponentName listenerComp) {
        return this.mMediaFocusControl.registerRemoteController(rcd, w, h, listenerComp);
    }

    public boolean registerRemoteControlDisplay(IRemoteControlDisplay rcd, int w, int h) {
        return this.mMediaFocusControl.registerRemoteControlDisplay(rcd, w, h);
    }

    public void unregisterRemoteControlDisplay(IRemoteControlDisplay rcd) {
        this.mMediaFocusControl.unregisterRemoteControlDisplay(rcd);
    }

    public void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay rcd, int w, int h) {
        this.mMediaFocusControl.remoteControlDisplayUsesBitmapSize(rcd, w, h);
    }

    public void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay rcd, boolean wantsSync) {
        this.mMediaFocusControl.remoteControlDisplayWantsPlaybackPositionSync(rcd, wantsSync);
    }

    public void registerMediaButtonEventReceiverForCalls(ComponentName c) {
        this.mMediaFocusControl.registerMediaButtonEventReceiverForCalls(c);
    }

    public void unregisterMediaButtonEventReceiverForCalls() {
        this.mMediaFocusControl.unregisterMediaButtonEventReceiverForCalls();
    }

    public void registerMediaButtonIntent(PendingIntent pi, ComponentName c, IBinder token) {
        this.mMediaFocusControl.registerMediaButtonIntent(pi, c, token);
    }

    public void unregisterMediaButtonIntent(PendingIntent pi) {
        this.mMediaFocusControl.unregisterMediaButtonIntent(pi);
    }

    public int registerRemoteControlClient(PendingIntent mediaIntent, IRemoteControlClient rcClient, String callingPckg) {
        return this.mMediaFocusControl.registerRemoteControlClient(mediaIntent, rcClient, callingPckg);
    }

    public void unregisterRemoteControlClient(PendingIntent mediaIntent, IRemoteControlClient rcClient) {
        this.mMediaFocusControl.unregisterRemoteControlClient(mediaIntent, rcClient);
    }

    public void setRemoteControlClientPlaybackPosition(int generationId, long timeMs) {
        this.mMediaFocusControl.setRemoteControlClientPlaybackPosition(generationId, timeMs);
    }

    public void updateRemoteControlClientMetadata(int generationId, int key, Rating value) {
        this.mMediaFocusControl.updateRemoteControlClientMetadata(generationId, key, value);
    }

    public void registerRemoteVolumeObserverForRcc(int rccId, IRemoteVolumeObserver rvo) {
        this.mMediaFocusControl.registerRemoteVolumeObserverForRcc(rccId, rvo);
    }

    public int getRemoteStreamVolume() {
        return this.mMediaFocusControl.getRemoteStreamVolume();
    }

    public int getRemoteStreamMaxVolume() {
        return this.mMediaFocusControl.getRemoteStreamMaxVolume();
    }

    public void setRemoteStreamVolume(int index) {
        this.mMediaFocusControl.setRemoteStreamVolume(index);
    }

    public void setPlaybackStateForRcc(int rccId, int state, long timeMs, float speed) {
        this.mMediaFocusControl.setPlaybackStateForRcc(rccId, state, timeMs, speed);
    }

    public void setPlaybackInfoForRcc(int rccId, int what, int value) {
        this.mMediaFocusControl.setPlaybackInfoForRcc(rccId, what, value);
    }

    public void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        this.mMediaFocusControl.dispatchMediaKeyEvent(keyEvent);
    }

    public void dispatchMediaKeyEventUnderWakelock(KeyEvent keyEvent) {
        this.mMediaFocusControl.dispatchMediaKeyEventUnderWakelock(keyEvent);
    }

    public int requestAudioFocus(int mainStreamType, int durationHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName) {
        return this.mMediaFocusControl.requestAudioFocus(mainStreamType, durationHint, cb, fd, clientId, callingPackageName);
    }

    public int abandonAudioFocus(IAudioFocusDispatcher fd, String clientId) {
        return this.mMediaFocusControl.abandonAudioFocus(fd, clientId);
    }

    public void unregisterAudioFocusClient(String clientId) {
        this.mMediaFocusControl.unregisterAudioFocusClient(clientId);
    }

    public int getCurrentAudioFocus() {
        return this.mMediaFocusControl.getCurrentAudioFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConfigurationChanged(Context context) {
        try {
            int newRotation;
            int newOrientation;
            Configuration config = context.getResources().getConfiguration();
            if (this.mMonitorOrientation && (newOrientation = config.orientation) != this.mDeviceOrientation) {
                this.mDeviceOrientation = newOrientation;
                this.setOrientationForAudioSystem();
            }
            if (this.mMonitorRotation && (newRotation = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation()) != this.mDeviceRotation) {
                this.mDeviceRotation = newRotation;
                this.setRotationForAudioSystem();
            }
            AudioService.sendMsg(this.mAudioHandler, 16, 0, 0, 0, null, 0);
            boolean cameraSoundForced = this.mContext.getResources().getBoolean(17891411);
            Object object = this.mSettingsLock;
            synchronized (object) {
                Boolean bl = this.mCameraSoundForced;
                synchronized (bl) {
                    if (cameraSoundForced != this.mCameraSoundForced) {
                        this.mCameraSoundForced = cameraSoundForced;
                        VolumeStreamState s = this.mStreamStates[7];
                        if (cameraSoundForced) {
                            s.setAllIndexesToMax();
                            this.mRingerModeAffectedStreams &= 0xFFFFFF7F;
                        } else {
                            s.setAllIndexes(this.mStreamStates[1]);
                            this.mRingerModeAffectedStreams |= 0x80;
                        }
                        this.setRingerModeInt(this.getRingerMode(), false);
                        AudioService.sendMsg(this.mAudioHandler, 8, 2, 4, cameraSoundForced ? 11 : 0, null, 0);
                        AudioService.sendMsg(this.mAudioHandler, 10, 2, 0, 0, this.mStreamStates[7], 0);
                    }
                }
            }
            this.mVolumePanel.setLayoutDirection(config.getLayoutDirection());
        }
        catch (Exception e) {
            Log.e(TAG, "Error handling configuration change: ", e);
        }
    }

    private void setOrientationForAudioSystem() {
        switch (this.mDeviceOrientation) {
            case 2: {
                AudioSystem.setParameters("orientation=landscape");
                break;
            }
            case 1: {
                AudioSystem.setParameters("orientation=portrait");
                break;
            }
            case 3: {
                AudioSystem.setParameters("orientation=square");
                break;
            }
            case 0: {
                AudioSystem.setParameters("orientation=undefined");
                break;
            }
            default: {
                Log.e(TAG, "Unknown orientation");
            }
        }
    }

    private void setRotationForAudioSystem() {
        switch (this.mDeviceRotation) {
            case 0: {
                AudioSystem.setParameters("rotation=0");
                break;
            }
            case 1: {
                AudioSystem.setParameters("rotation=90");
                break;
            }
            case 2: {
                AudioSystem.setParameters("rotation=180");
                break;
            }
            case 3: {
                AudioSystem.setParameters("rotation=270");
                break;
            }
            default: {
                Log.e(TAG, "Unknown device rotation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBluetoothA2dpOnInt(boolean on) {
        Object object = this.mBluetoothA2dpEnabledLock;
        synchronized (object) {
            this.mBluetoothA2dpEnabled = on;
            this.mAudioHandler.removeMessages(13);
            AudioSystem.setForceUse(1, this.mBluetoothA2dpEnabled ? 0 : 10);
        }
    }

    public void setRingtonePlayer(IRingtonePlayer player) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REMOTE_AUDIO_PLAYBACK", null);
        this.mRingtonePlayer = player;
    }

    public IRingtonePlayer getRingtonePlayer() {
        return this.mRingtonePlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioRoutesInfo startWatchingRoutes(IAudioRoutesObserver observer) {
        AudioRoutesInfo audioRoutesInfo = this.mCurAudioRoutes;
        synchronized (audioRoutesInfo) {
            AudioRoutesInfo routes = new AudioRoutesInfo(this.mCurAudioRoutes);
            this.mRoutesObservers.register(observer);
            return routes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSafeMediaVolumeEnabled(boolean on) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            if (this.mSafeMediaVolumeState != 0 && this.mSafeMediaVolumeState != 1) {
                if (on && this.mSafeMediaVolumeState == 2) {
                    this.mSafeMediaVolumeState = 3;
                    this.enforceSafeMediaVolume();
                } else if (!on && this.mSafeMediaVolumeState == 3) {
                    this.mSafeMediaVolumeState = 2;
                    this.mMusicActiveMs = 0;
                    AudioService.sendMsg(this.mAudioHandler, 14, 0, 0, 0, null, 60000);
                }
            }
        }
    }

    private void enforceSafeMediaVolume() {
        VolumeStreamState streamState = this.mStreamStates[3];
        int devices = 12;
        int i = 0;
        while (devices != 0) {
            int device;
            if (((device = 1 << i++) & devices) == 0) continue;
            int index = streamState.getIndex(device);
            if (index > this.mSafeMediaVolumeIndex) {
                streamState.setIndex(this.mSafeMediaVolumeIndex, device);
                AudioService.sendMsg(this.mAudioHandler, 0, 2, device, 0, streamState, 0);
            }
            devices &= ~device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSafeMediaVolume(int streamType, int index, int device) {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            return this.mSafeMediaVolumeState != 3 || this.mStreamVolumeAlias[streamType] != 3 || (device & 0xC) == 0 || index <= this.mSafeMediaVolumeIndex;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableSafeMediaVolume() {
        Integer n = this.mSafeMediaVolumeState;
        synchronized (n) {
            this.setSafeMediaVolumeEnabled(false);
            if (this.mPendingVolumeCommand != null) {
                this.onSetStreamVolume(this.mPendingVolumeCommand.mStreamType, this.mPendingVolumeCommand.mIndex, this.mPendingVolumeCommand.mFlags, this.mPendingVolumeCommand.mDevice);
                this.mPendingVolumeCommand = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCameraSoundForced() {
        Boolean bl = this.mCameraSoundForced;
        synchronized (bl) {
            return this.mCameraSoundForced;
        }
    }

    private void dumpRingerMode(PrintWriter pw) {
        pw.println("\nRinger mode: ");
        pw.println("- mode: " + RINGER_MODE_NAMES[this.mRingerMode]);
        pw.print("- ringer mode affected streams = 0x");
        pw.println(Integer.toHexString(this.mRingerModeAffectedStreams));
        pw.print("- ringer mode muted streams = 0x");
        pw.println(Integer.toHexString(this.mRingerModeMutedStreams));
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        this.mMediaFocusControl.dump(pw);
        this.dumpStreamStates(pw);
        this.dumpRingerMode(pw);
        pw.println("\nAudio routes:");
        pw.print("  mMainType=0x");
        pw.println(Integer.toHexString(this.mCurAudioRoutes.mMainType));
        pw.print("  mBluetoothName=");
        pw.println(this.mCurAudioRoutes.mBluetoothName);
    }

    private static void readAndSetLowRamDevice() {
        int status = AudioSystem.setLowRamDevice(ActivityManager.isLowRamDeviceStatic());
        if (status != 0) {
            Log.w(TAG, "AudioFlinger informed of device's low RAM attribute; status " + status);
        }
    }

    static {
        RINGER_MODE_NAMES = new String[]{"SILENT", "VIBRATE", "NORMAL"};
    }

    private class AudioServiceBroadcastReceiver
    extends BroadcastReceiver {
        private AudioServiceBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.DOCK_EVENT")) {
                int config;
                int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                switch (dockState) {
                    case 1: {
                        config = 7;
                        break;
                    }
                    case 2: {
                        config = 6;
                        break;
                    }
                    case 3: {
                        config = 8;
                        break;
                    }
                    case 4: {
                        config = 9;
                        break;
                    }
                    default: {
                        config = 0;
                    }
                }
                if (dockState != 3 && (dockState != 0 || AudioService.this.mDockState != 3)) {
                    AudioSystem.setForceUse(3, config);
                }
                AudioService.this.mDockState = dockState;
            } else if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                boolean connected;
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                int device = 16;
                String address = null;
                BluetoothDevice btDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (btDevice == null) {
                    return;
                }
                address = btDevice.getAddress();
                BluetoothClass btClass = btDevice.getBluetoothClass();
                if (btClass != null) {
                    switch (btClass.getDeviceClass()) {
                        case 1028: 
                        case 1032: {
                            device = 32;
                            break;
                        }
                        case 1056: {
                            device = 64;
                        }
                    }
                }
                if (!BluetoothAdapter.checkBluetoothAddress(address)) {
                    address = "";
                }
                boolean bl = connected = state == 2;
                if (AudioService.this.handleDeviceConnection(connected, device, address)) {
                    ArrayList arrayList = AudioService.this.mScoClients;
                    synchronized (arrayList) {
                        if (connected) {
                            AudioService.this.mBluetoothHeadsetDevice = btDevice;
                        } else {
                            AudioService.this.mBluetoothHeadsetDevice = null;
                            AudioService.this.resetBluetoothSco();
                        }
                    }
                }
            } else if (action.equals("android.intent.action.USB_AUDIO_ACCESSORY_PLUG") || action.equals("android.intent.action.USB_AUDIO_DEVICE_PLUG")) {
                int state = intent.getIntExtra("state", 0);
                int alsaCard = intent.getIntExtra("card", -1);
                int alsaDevice = intent.getIntExtra("device", -1);
                String params = alsaCard == -1 && alsaDevice == -1 ? "" : "card=" + alsaCard + ";device=" + alsaDevice;
                int device = action.equals("android.intent.action.USB_AUDIO_ACCESSORY_PLUG") ? 8192 : 16384;
                Log.v(AudioService.TAG, "Broadcast Receiver: Got " + (action.equals("android.intent.action.USB_AUDIO_ACCESSORY_PLUG") ? "ACTION_USB_AUDIO_ACCESSORY_PLUG" : "ACTION_USB_AUDIO_DEVICE_PLUG") + ", state = " + state + ", card: " + alsaCard + ", device: " + alsaDevice);
                AudioService.this.setWiredDeviceConnectionState(device, state, params);
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                boolean broadcast = false;
                int scoAudioState = -1;
                ArrayList params = AudioService.this.mScoClients;
                synchronized (params) {
                    int btState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    if (!(AudioService.this.mScoClients.isEmpty() || AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 1 && AudioService.this.mScoAudioState != 5)) {
                        broadcast = true;
                    }
                    switch (btState) {
                        case 12: {
                            scoAudioState = 1;
                            if (AudioService.this.mScoAudioState == 3 || AudioService.this.mScoAudioState == 5 || AudioService.this.mScoAudioState == 4) break;
                            AudioService.this.mScoAudioState = 2;
                            break;
                        }
                        case 10: {
                            scoAudioState = 0;
                            AudioService.this.mScoAudioState = 0;
                            AudioService.this.clearAllScoClients(0, false);
                            break;
                        }
                        case 11: {
                            if (AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 5 && AudioService.this.mScoAudioState != 4) {
                                AudioService.this.mScoAudioState = 2;
                            }
                        }
                        default: {
                            broadcast = false;
                        }
                    }
                }
                if (broadcast) {
                    AudioService.this.broadcastScoConnectionState(scoAudioState);
                    Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                    newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", scoAudioState);
                    AudioService.this.sendStickyBroadcastToAll(newIntent);
                }
            } else if (action.equals("android.intent.action.BOOT_COMPLETED")) {
                AudioService.this.mBootCompleted = true;
                AudioService.sendMsg(AudioService.this.mAudioHandler, 7, 2, 0, 0, null, 0);
                AudioService.this.mKeyguardManager = (KeyguardManager)AudioService.this.mContext.getSystemService("keyguard");
                AudioService.this.mScoConnectionState = -1;
                AudioService.this.resetBluetoothSco();
                AudioService.this.getBluetoothHeadset();
                Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                AudioService.this.sendStickyBroadcastToAll(newIntent);
                BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                if (adapter != null) {
                    adapter.getProfileProxy(AudioService.this.mContext, AudioService.this.mBluetoothProfileServiceListener, 2);
                }
                AudioService.sendMsg(AudioService.this.mAudioHandler, 17, 0, 0, 0, null, 30000);
            } else if (action.equals("android.intent.action.SCREEN_ON")) {
                AudioSystem.setParameters("screen_state=on");
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                AudioSystem.setParameters("screen_state=off");
            } else if (action.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                AudioService.this.handleConfigurationChanged(context);
            } else if (action.equals("android.intent.action.USER_SWITCHED")) {
                AudioService.sendMsg(AudioService.this.mAudioHandler, 15, 0, 0, 0, null, 0);
                AudioService.this.mMediaFocusControl.discardAudioFocusOwner();
                AudioService.this.readAudioSettings(true);
                AudioService.sendMsg(AudioService.this.mAudioHandler, 10, 2, 0, 0, AudioService.this.mStreamStates[3], 0);
            }
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver() {
            super(new Handler());
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("mode_ringer_streams_affected"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("dock_audio_media_enabled"), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                if (AudioService.this.updateRingerModeAffectedStreams()) {
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                }
                AudioService.this.readDockAudioSettings(AudioService.this.mContentResolver);
            }
        }
    }

    private class AudioHandler
    extends Handler {
        private AudioHandler() {
        }

        private void setDeviceVolume(VolumeStreamState streamState, int device) {
            streamState.applyDeviceVolume(device);
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || AudioService.this.mStreamVolumeAlias[streamType] != streamState.mStreamType) continue;
                AudioService.this.mStreamStates[streamType].applyDeviceVolume(AudioService.this.getDeviceForStream(streamType));
            }
            AudioService.sendMsg(AudioService.this.mAudioHandler, 1, 2, device, 0, streamState, 500);
        }

        private void setAllVolumes(VolumeStreamState streamState) {
            streamState.applyAllVolumes();
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || AudioService.this.mStreamVolumeAlias[streamType] != streamState.mStreamType) continue;
                AudioService.this.mStreamStates[streamType].applyAllVolumes();
            }
        }

        private void persistVolume(VolumeStreamState streamState, int device) {
            if (AudioService.this.mUseFixedVolume) {
                return;
            }
            Settings.System.putIntForUser(AudioService.this.mContentResolver, streamState.getSettingNameForDevice(device), (streamState.getIndex(device) + 5) / 10, -2);
        }

        private void persistRingerMode(int ringerMode) {
            if (AudioService.this.mUseFixedVolume) {
                return;
            }
            Settings.Global.putInt(AudioService.this.mContentResolver, "mode_ringer", ringerMode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onLoadSoundEffects() {
            int status;
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                int effect;
                if (!AudioService.this.mBootCompleted) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects() called before boot complete");
                    return false;
                }
                if (AudioService.this.mSoundPool != null) {
                    return true;
                }
                AudioService.this.loadTouchSoundAssets();
                AudioService.this.mSoundPool = new SoundPool(4, 1, 0);
                AudioService.this.mSoundPoolCallBack = null;
                AudioService.this.mSoundPoolListenerThread = new SoundPoolListenerThread();
                AudioService.this.mSoundPoolListenerThread.start();
                int attempts = 3;
                while (AudioService.this.mSoundPoolCallBack == null && attempts-- > 0) {
                    try {
                        AudioService.this.mSoundEffectsLock.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        Log.w(AudioService.TAG, "Interrupted while waiting sound pool listener thread.");
                    }
                }
                if (AudioService.this.mSoundPoolCallBack == null) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects() SoundPool listener or thread creation error");
                    if (AudioService.this.mSoundPoolLooper != null) {
                        AudioService.this.mSoundPoolLooper.quit();
                        AudioService.this.mSoundPoolLooper = null;
                    }
                    AudioService.this.mSoundPoolListenerThread = null;
                    AudioService.this.mSoundPool.release();
                    AudioService.this.mSoundPool = null;
                    return false;
                }
                int[] poolId = new int[SOUND_EFFECT_FILES.size()];
                for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.size(); ++fileIdx) {
                    poolId[fileIdx] = -1;
                }
                int numSamples = 0;
                for (effect = 0; effect < 10; ++effect) {
                    if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] == 0) continue;
                    if (poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]] == -1) {
                        String filePath = Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + (String)SOUND_EFFECT_FILES.get(AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]);
                        int sampleId = AudioService.this.mSoundPool.load(filePath, 0);
                        if (sampleId <= 0) {
                            Log.w(AudioService.TAG, "Soundpool could not load file: " + filePath);
                            continue;
                        }
                        ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = sampleId;
                        poolId[((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][0]] = sampleId;
                        ++numSamples;
                        continue;
                    }
                    ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]];
                }
                if (numSamples > 0) {
                    AudioService.this.mSoundPoolCallBack.setSamples(poolId);
                    attempts = 3;
                    status = 1;
                    while (status == 1 && attempts-- > 0) {
                        try {
                            AudioService.this.mSoundEffectsLock.wait(5000L);
                            status = AudioService.this.mSoundPoolCallBack.status();
                        }
                        catch (InterruptedException e) {
                            Log.w(AudioService.TAG, "Interrupted while waiting sound pool callback.");
                        }
                    }
                } else {
                    status = -1;
                }
                if (AudioService.this.mSoundPoolLooper != null) {
                    AudioService.this.mSoundPoolLooper.quit();
                    AudioService.this.mSoundPoolLooper = null;
                }
                AudioService.this.mSoundPoolListenerThread = null;
                if (status != 0) {
                    Log.w(AudioService.TAG, "onLoadSoundEffects(), Error " + status + " while loading samples");
                    for (effect = 0; effect < 10; ++effect) {
                        if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0) continue;
                        ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                    }
                    AudioService.this.mSoundPool.release();
                    AudioService.this.mSoundPool = null;
                }
            }
            return status == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onUnloadSoundEffects() {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                int[] poolId = new int[SOUND_EFFECT_FILES.size()];
                for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.size(); ++fileIdx) {
                    poolId[fileIdx] = 0;
                }
                for (int effect = 0; effect < 10; ++effect) {
                    if (AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0 || poolId[AudioService.this.SOUND_EFFECT_FILES_MAP[effect][0]] != 0) continue;
                    AudioService.this.mSoundPool.unload(AudioService.this.SOUND_EFFECT_FILES_MAP[effect][1]);
                    ((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                    poolId[((AudioService)AudioService.this).SOUND_EFFECT_FILES_MAP[effect][0]] = -1;
                }
                AudioService.this.mSoundPool.release();
                AudioService.this.mSoundPool = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPlaySoundEffect(int effectType, int volume) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                this.onLoadSoundEffects();
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                float volFloat = volume < 0 ? (float)Math.pow(10.0, (float)sSoundEffectVolumeDb / 20.0f) : (float)volume / 1000.0f;
                if (AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1] > 0) {
                    AudioService.this.mSoundPool.play(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1], volFloat, volFloat, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    try {
                        String filePath = Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + (String)SOUND_EFFECT_FILES.get(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][0]);
                        mediaPlayer.setDataSource(filePath);
                        mediaPlayer.setAudioStreamType(1);
                        mediaPlayer.prepare();
                        mediaPlayer.setVolume(volFloat);
                        mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                            public void onCompletion(MediaPlayer mp) {
                                AudioHandler.this.cleanupPlayer(mp);
                            }
                        });
                        mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                            public boolean onError(MediaPlayer mp, int what, int extra) {
                                AudioHandler.this.cleanupPlayer(mp);
                                return true;
                            }
                        });
                        mediaPlayer.start();
                    }
                    catch (IOException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IOException: " + ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IllegalArgumentException: " + ex);
                    }
                    catch (IllegalStateException ex) {
                        Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                    }
                }
            }
        }

        private void cleanupPlayer(MediaPlayer mp) {
            if (mp != null) {
                try {
                    mp.stop();
                    mp.release();
                }
                catch (IllegalStateException ex) {
                    Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                }
            }
        }

        private void setForceUse(int usage, int config) {
            AudioSystem.setForceUse(usage, config);
        }

        private void onPersistSafeVolumeState(int state) {
            Settings.Global.putInt(AudioService.this.mContentResolver, "audio_safe_volume_state", state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.setDeviceVolume((VolumeStreamState)msg.obj, msg.arg1);
                    break;
                }
                case 10: {
                    this.setAllVolumes((VolumeStreamState)msg.obj);
                    break;
                }
                case 1: {
                    this.persistVolume((VolumeStreamState)msg.obj, msg.arg1);
                    break;
                }
                case 2: {
                    if (AudioService.this.mUseFixedVolume) {
                        return;
                    }
                    Settings.System.putFloatForUser(AudioService.this.mContentResolver, "volume_master", (float)msg.arg1 / 1000.0f, -2);
                    break;
                }
                case 11: {
                    if (AudioService.this.mUseFixedVolume) {
                        return;
                    }
                    Settings.System.putIntForUser(AudioService.this.mContentResolver, "volume_master_mute", msg.arg1, -2);
                    break;
                }
                case 3: {
                    this.persistRingerMode(AudioService.this.getRingerMode());
                    break;
                }
                case 4: {
                    if (AudioSystem.checkAudioFlinger() != 0) {
                        Log.e(AudioService.TAG, "Media server died.");
                        AudioService.sendMsg(AudioService.this.mAudioHandler, 4, 1, 0, 0, null, 500);
                        break;
                    }
                    Log.e(AudioService.TAG, "Media server started.");
                    AudioSystem.setParameters("restarting=true");
                    AudioService.readAndSetLowRamDevice();
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    synchronized (hashMap) {
                        Set set = AudioService.this.mConnectedDevices.entrySet();
                        for (Map.Entry device : set) {
                            AudioSystem.setDeviceConnectionState((Integer)device.getKey(), 1, (String)device.getValue());
                        }
                    }
                    AudioSystem.setPhoneState(AudioService.this.mMode);
                    AudioSystem.setForceUse(0, AudioService.this.mForcedUseForComm);
                    AudioSystem.setForceUse(2, AudioService.this.mForcedUseForComm);
                    AudioSystem.setForceUse(4, AudioService.this.mCameraSoundForced != false ? 11 : 0);
                    int numStreamTypes = AudioSystem.getNumStreamTypes();
                    for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                        VolumeStreamState streamState = AudioService.this.mStreamStates[streamType];
                        AudioSystem.initStreamVolume(streamType, 0, (streamState.mIndexMax + 5) / 10);
                        streamState.applyAllVolumes();
                    }
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                    AudioService.this.restoreMasterVolume();
                    if (AudioService.this.mMonitorOrientation) {
                        AudioService.this.setOrientationForAudioSystem();
                    }
                    if (AudioService.this.mMonitorRotation) {
                        AudioService.this.setRotationForAudioSystem();
                    }
                    Object streamType = AudioService.this.mBluetoothA2dpEnabledLock;
                    synchronized (streamType) {
                        AudioSystem.setForceUse(1, AudioService.this.mBluetoothA2dpEnabled ? 0 : 10);
                    }
                    streamType = AudioService.this.mSettingsLock;
                    synchronized (streamType) {
                        AudioSystem.setForceUse(3, AudioService.this.mDockAudioMediaEnabled ? 8 : 0);
                    }
                    AudioSystem.setParameters("restarting=false");
                    break;
                }
                case 20: {
                    this.onUnloadSoundEffects();
                    break;
                }
                case 7: {
                    LoadSoundEffectReply reply;
                    boolean loaded = this.onLoadSoundEffects();
                    if (msg.obj == null) break;
                    LoadSoundEffectReply device = reply = (LoadSoundEffectReply)msg.obj;
                    synchronized (device) {
                        reply.mStatus = loaded ? 0 : -1;
                        reply.notify();
                        break;
                    }
                }
                case 5: {
                    this.onPlaySoundEffect(msg.arg1, msg.arg2);
                    break;
                }
                case 6: {
                    HashMap reply = AudioService.this.mConnectedDevices;
                    synchronized (reply) {
                        AudioService.this.makeA2dpDeviceUnavailableNow((String)msg.obj);
                        break;
                    }
                }
                case 8: 
                case 13: {
                    this.setForceUse(msg.arg1, msg.arg2);
                    break;
                }
                case 9: {
                    AudioService.this.resetBluetoothSco();
                    break;
                }
                case 100: {
                    AudioService.this.onSetWiredDeviceConnectionState(msg.arg1, msg.arg2, (String)msg.obj);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 101: {
                    AudioService.this.onSetA2dpConnectionState((BluetoothDevice)msg.obj, msg.arg1);
                    AudioService.this.mAudioEventWakeLock.release();
                    break;
                }
                case 12: {
                    int N = AudioService.this.mRoutesObservers.beginBroadcast();
                    if (N > 0) {
                        AudioRoutesInfo routes;
                        AudioRoutesInfo audioRoutesInfo = AudioService.this.mCurAudioRoutes;
                        synchronized (audioRoutesInfo) {
                            routes = new AudioRoutesInfo(AudioService.this.mCurAudioRoutes);
                        }
                        while (N > 0) {
                            IAudioRoutesObserver obs = AudioService.this.mRoutesObservers.getBroadcastItem(--N);
                            try {
                                obs.dispatchAudioRoutesChanged(routes);
                            }
                            catch (RemoteException e) {}
                        }
                    }
                    AudioService.this.mRoutesObservers.finishBroadcast();
                    break;
                }
                case 14: {
                    AudioService.this.onCheckMusicActive();
                    break;
                }
                case 15: {
                    AudioService.this.onSendBecomingNoisyIntent();
                    break;
                }
                case 16: 
                case 17: {
                    AudioService.this.onConfigureSafeVolume(msg.what == 17);
                    break;
                }
                case 18: {
                    this.onPersistSafeVolumeState(msg.arg1);
                    break;
                }
                case 19: {
                    AudioService.this.onBroadcastScoConnectionState(msg.arg1);
                }
            }
        }
    }

    private class AudioSystemThread
    extends Thread {
        AudioSystemThread() {
            super(AudioService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            AudioService audioService = AudioService.this;
            synchronized (audioService) {
                AudioService.this.mAudioHandler = new AudioHandler();
                AudioService.this.notify();
            }
            Looper.loop();
        }
    }

    public class VolumeStreamState {
        private final int mStreamType;
        private String mVolumeIndexSettingName;
        private int mIndexMax;
        private final ConcurrentHashMap<Integer, Integer> mIndex = new ConcurrentHashMap(8, 0.75f, 4);
        private ArrayList<VolumeDeathHandler> mDeathHandlers;

        private VolumeStreamState(String settingName, int streamType) {
            this.mVolumeIndexSettingName = settingName;
            this.mStreamType = streamType;
            this.mIndexMax = MAX_STREAM_VOLUME[streamType];
            AudioSystem.initStreamVolume(streamType, 0, this.mIndexMax);
            this.mIndexMax *= 10;
            this.mDeathHandlers = new ArrayList();
            this.readSettings();
        }

        public String getSettingNameForDevice(int device) {
            String name = this.mVolumeIndexSettingName;
            String suffix = AudioSystem.getDeviceName(device);
            if (suffix.isEmpty()) {
                return name;
            }
            return name + "_" + suffix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void readSettings() {
            if (AudioService.this.mUseFixedVolume) {
                this.mIndex.put(0x40000000, this.mIndexMax);
                return;
            }
            if (this.mStreamType == 1 || this.mStreamType == 7) {
                int index = 10 * AudioManager.DEFAULT_STREAM_VOLUME[this.mStreamType];
                Boolean bl = AudioService.this.mCameraSoundForced;
                synchronized (bl) {
                    if (AudioService.this.mCameraSoundForced.booleanValue()) {
                        index = this.mIndexMax;
                    }
                }
                this.mIndex.put(0x40000000, index);
                return;
            }
            int remainingDevices = 0x4000FFFF;
            int i = 0;
            while (remainingDevices != 0) {
                int device = 1 << i;
                if ((device & remainingDevices) != 0) {
                    remainingDevices &= ~device;
                    String name = this.getSettingNameForDevice(device);
                    int defaultIndex = device == 0x40000000 ? AudioManager.DEFAULT_STREAM_VOLUME[this.mStreamType] : -1;
                    int index = Settings.System.getIntForUser(AudioService.this.mContentResolver, name, defaultIndex, -2);
                    if (index != -1) {
                        if (AudioService.this.mStreamVolumeAlias[this.mStreamType] == 3 && (device & 0x7C00) != 0) {
                            this.mIndex.put(device, index != 0 ? this.mIndexMax : 0);
                        } else {
                            this.mIndex.put(device, this.getValidIndex(10 * index));
                        }
                    }
                }
                ++i;
            }
        }

        public void applyDeviceVolume(int device) {
            int index = this.isMuted() ? 0 : (AudioService.this.mStreamVolumeAlias[this.mStreamType] == 3 && (device & 0x380) != 0 && AudioService.this.mAvrcpAbsVolSupported ? (this.mIndexMax + 5) / 10 : (this.getIndex(device) + 5) / 10);
            AudioSystem.setStreamVolumeIndex(this.mStreamType, index, device);
        }

        public synchronized void applyAllVolumes() {
            int index = this.isMuted() ? 0 : (this.getIndex(0x40000000) + 5) / 10;
            AudioSystem.setStreamVolumeIndex(this.mStreamType, index, 0x40000000);
            Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
            for (Map.Entry<Integer, Integer> entry : set) {
                int device = entry.getKey();
                if (device == 0x40000000) continue;
                index = this.isMuted() ? 0 : (entry.getValue() + 5) / 10;
                AudioSystem.setStreamVolumeIndex(this.mStreamType, index, device);
            }
        }

        public boolean adjustIndex(int deltaIndex, int device) {
            return this.setIndex(this.getIndex(device) + deltaIndex, device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean setIndex(int index, int device) {
            int oldIndex = this.getIndex(device);
            index = this.getValidIndex(index);
            Boolean bl = AudioService.this.mCameraSoundForced;
            synchronized (bl) {
                if (this.mStreamType == 7 && AudioService.this.mCameraSoundForced.booleanValue()) {
                    index = this.mIndexMax;
                }
            }
            this.mIndex.put(device, index);
            if (oldIndex != index) {
                boolean currentDevice = device == AudioService.this.getDeviceForStream(this.mStreamType);
                int numStreamTypes = AudioSystem.getNumStreamTypes();
                for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                    if (streamType == this.mStreamType || AudioService.this.mStreamVolumeAlias[streamType] != this.mStreamType) continue;
                    int scaledIndex = AudioService.this.rescaleIndex(index, this.mStreamType, streamType);
                    AudioService.this.mStreamStates[streamType].setIndex(scaledIndex, device);
                    if (!currentDevice) continue;
                    AudioService.this.mStreamStates[streamType].setIndex(scaledIndex, AudioService.this.getDeviceForStream(streamType));
                }
                return true;
            }
            return false;
        }

        public synchronized int getIndex(int device) {
            Integer index = this.mIndex.get(device);
            if (index == null) {
                index = this.mIndex.get(0x40000000);
            }
            return index;
        }

        public int getMaxIndex() {
            return this.mIndexMax;
        }

        public synchronized void setAllIndexes(VolumeStreamState srcStream) {
            int srcStreamType = srcStream.getStreamType();
            int index = srcStream.getIndex(0x40000000);
            index = AudioService.this.rescaleIndex(index, srcStreamType, this.mStreamType);
            Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
            for (Map.Entry<Integer, Integer> entry : set) {
                entry.setValue(index);
            }
            set = srcStream.mIndex.entrySet();
            for (Map.Entry<Integer, Integer> entry : set) {
                int device = entry.getKey();
                index = entry.getValue();
                index = AudioService.this.rescaleIndex(index, srcStreamType, this.mStreamType);
                this.setIndex(index, device);
            }
        }

        public synchronized void setAllIndexesToMax() {
            Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
            for (Map.Entry<Integer, Integer> entry : set) {
                entry.setValue(this.mIndexMax);
            }
        }

        public synchronized void mute(IBinder cb, boolean state) {
            VolumeDeathHandler handler = this.getDeathHandler(cb, state);
            if (handler == null) {
                Log.e(AudioService.TAG, "Could not get client death handler for stream: " + this.mStreamType);
                return;
            }
            handler.mute(state);
        }

        public int getStreamType() {
            return this.mStreamType;
        }

        private int getValidIndex(int index) {
            if (index < 0) {
                return 0;
            }
            if (AudioService.this.mUseFixedVolume || index > this.mIndexMax) {
                return this.mIndexMax;
            }
            return index;
        }

        private synchronized int muteCount() {
            int count = 0;
            int size = this.mDeathHandlers.size();
            for (int i = 0; i < size; ++i) {
                count += this.mDeathHandlers.get(i).mMuteCount;
            }
            return count;
        }

        private synchronized boolean isMuted() {
            return this.muteCount() != 0;
        }

        private VolumeDeathHandler getDeathHandler(IBinder cb, boolean state) {
            VolumeDeathHandler handler;
            int size = this.mDeathHandlers.size();
            for (int i = 0; i < size; ++i) {
                handler = this.mDeathHandlers.get(i);
                if (cb != handler.mICallback) continue;
                return handler;
            }
            if (state) {
                handler = new VolumeDeathHandler(cb);
            } else {
                Log.w(AudioService.TAG, "stream was not muted by this client");
                handler = null;
            }
            return handler;
        }

        private void dump(PrintWriter pw) {
            pw.print("   Mute count: ");
            pw.println(this.muteCount());
            pw.print("   Current: ");
            Set<Map.Entry<Integer, Integer>> set = this.mIndex.entrySet();
            for (Map.Entry<Integer, Integer> entry : set) {
                pw.print(Integer.toHexString(entry.getKey()) + ": " + (entry.getValue() + 5) / 10 + ", ");
            }
        }

        private class VolumeDeathHandler
        implements IBinder.DeathRecipient {
            private IBinder mICallback;
            private int mMuteCount;

            VolumeDeathHandler(IBinder cb) {
                this.mICallback = cb;
            }

            /*
             * Unable to fully structure code
             */
            public void mute(boolean state) {
                updateVolume = false;
                if (state) {
                    if (this.mMuteCount == 0) {
                        try {
                            if (this.mICallback != null) {
                                this.mICallback.linkToDeath(this, 0);
                            }
                            VolumeStreamState.access$1700(VolumeStreamState.this).add(this);
                            if (VolumeStreamState.access$300(VolumeStreamState.this)) ** GOTO lbl17
                            updateVolume = true;
                        }
                        catch (RemoteException e) {
                            this.binderDied();
                            return;
                        }
                    } else {
                        Log.w("AudioService", "stream: " + VolumeStreamState.access$4200(VolumeStreamState.this) + " was already muted by this client");
                    }
lbl17:
                    // 3 sources

                    ++this.mMuteCount;
                } else if (this.mMuteCount == 0) {
                    Log.e("AudioService", "unexpected unmute for stream: " + VolumeStreamState.access$4200(VolumeStreamState.this));
                } else {
                    --this.mMuteCount;
                    if (this.mMuteCount == 0) {
                        VolumeStreamState.access$1700(VolumeStreamState.this).remove(this);
                        if (this.mICallback != null) {
                            this.mICallback.unlinkToDeath(this, 0);
                        }
                        if (!VolumeStreamState.access$300(VolumeStreamState.this)) {
                            updateVolume = true;
                        }
                    }
                }
                if (updateVolume) {
                    AudioService.access$100(AudioService.access$000(AudioService.this), 10, 2, 0, 0, VolumeStreamState.this, 0);
                }
            }

            public void binderDied() {
                Log.w(AudioService.TAG, "Volume service client died for stream: " + VolumeStreamState.this.mStreamType);
                if (this.mMuteCount != 0) {
                    this.mMuteCount = 1;
                    this.mute(false);
                }
            }
        }
    }

    private class ScoClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mCreatorPid;
        private int mStartcount;

        ScoClient(IBinder cb) {
            this.mCb = cb;
            this.mCreatorPid = Binder.getCallingPid();
            this.mStartcount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "SCO client died");
                int index = AudioService.this.mScoClients.indexOf(this);
                if (index < 0) {
                    Log.w(AudioService.TAG, "unregistered SCO client died");
                } else {
                    this.clearCount(true);
                    AudioService.this.mScoClients.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incCount(int targetSdkVersion) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                this.requestScoState(12, targetSdkVersion);
                if (this.mStartcount == 0) {
                    try {
                        this.mCb.linkToDeath(this, 0);
                    }
                    catch (RemoteException e) {
                        Log.w(AudioService.TAG, "ScoClient  incCount() could not link to " + this.mCb + " binder death");
                    }
                }
                ++this.mStartcount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount == 0) {
                    Log.w(AudioService.TAG, "ScoClient.decCount() already 0");
                } else {
                    --this.mStartcount;
                    if (this.mStartcount == 0) {
                        try {
                            this.mCb.unlinkToDeath(this, 0);
                        }
                        catch (NoSuchElementException e) {
                            Log.w(AudioService.TAG, "decCount() going to 0 but not registered to binder");
                        }
                    }
                    this.requestScoState(10, 0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCount(boolean stopSco) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount != 0) {
                    try {
                        this.mCb.unlinkToDeath(this, 0);
                    }
                    catch (NoSuchElementException e) {
                        Log.w(AudioService.TAG, "clearCount() mStartcount: " + this.mStartcount + " != 0 but not registered to binder");
                    }
                }
                this.mStartcount = 0;
                if (stopSco) {
                    this.requestScoState(10, 0);
                }
            }
        }

        public int getCount() {
            return this.mStartcount;
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        public int getPid() {
            return this.mCreatorPid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int totalCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int count = 0;
                int size = AudioService.this.mScoClients.size();
                for (int i = 0; i < size; ++i) {
                    count += ((ScoClient)AudioService.this.mScoClients.get(i)).getCount();
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requestScoState(int state, int targetSdkVersion) {
            AudioService.this.checkScoAudioState();
            if (this.totalCount() == 0) {
                if (state == 12) {
                    AudioService.this.broadcastScoConnectionState(2);
                    ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
                    synchronized (arrayList) {
                        if (!(!AudioService.this.mSetModeDeathHandlers.isEmpty() && ((SetModeDeathHandler)AudioService.this.mSetModeDeathHandlers.get(0)).getPid() != this.mCreatorPid || AudioService.this.mScoAudioState != 0 && AudioService.this.mScoAudioState != 5)) {
                            if (AudioService.this.mScoAudioState == 0) {
                                AudioService.this.mScoAudioMode = targetSdkVersion < 18 ? 0 : 1;
                                if (AudioService.this.mBluetoothHeadset != null && AudioService.this.mBluetoothHeadsetDevice != null) {
                                    boolean status = AudioService.this.mScoAudioMode == 1 ? AudioService.this.mBluetoothHeadset.connectAudio() : AudioService.this.mBluetoothHeadset.startScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                    if (status) {
                                        AudioService.this.mScoAudioState = 3;
                                    } else {
                                        AudioService.this.broadcastScoConnectionState(0);
                                    }
                                } else if (AudioService.this.getBluetoothHeadset()) {
                                    AudioService.this.mScoAudioState = 1;
                                }
                            } else {
                                AudioService.this.mScoAudioState = 3;
                                AudioService.this.broadcastScoConnectionState(1);
                            }
                        } else {
                            AudioService.this.broadcastScoConnectionState(0);
                        }
                    }
                } else if (state == 10 && (AudioService.this.mScoAudioState == 3 || AudioService.this.mScoAudioState == 1)) {
                    if (AudioService.this.mScoAudioState == 3) {
                        if (AudioService.this.mBluetoothHeadset != null && AudioService.this.mBluetoothHeadsetDevice != null) {
                            boolean status = AudioService.this.mScoAudioMode == 1 ? AudioService.this.mBluetoothHeadset.disconnectAudio() : AudioService.this.mBluetoothHeadset.stopScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                            if (!status) {
                                AudioService.this.mScoAudioState = 0;
                                AudioService.this.broadcastScoConnectionState(0);
                            }
                        } else if (AudioService.this.getBluetoothHeadset()) {
                            AudioService.this.mScoAudioState = 5;
                        }
                    } else {
                        AudioService.this.mScoAudioState = 0;
                        AudioService.this.broadcastScoConnectionState(0);
                    }
                }
            }
        }
    }

    private final class SoundPoolCallback
    implements SoundPool.OnLoadCompleteListener {
        int mStatus = 1;
        List<Integer> mSamples = new ArrayList<Integer>();

        private SoundPoolCallback() {
        }

        public int status() {
            return this.mStatus;
        }

        public void setSamples(int[] samples) {
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] <= 0) continue;
                this.mSamples.add(samples[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                int i = this.mSamples.indexOf(sampleId);
                if (i >= 0) {
                    this.mSamples.remove(i);
                }
                if (status != 0 || this.mSamples.isEmpty()) {
                    this.mStatus = status;
                    AudioService.this.mSoundEffectsLock.notify();
                }
            }
        }
    }

    class SoundPoolListenerThread
    extends Thread {
        public SoundPoolListenerThread() {
            super("SoundPoolListenerThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            AudioService.this.mSoundPoolLooper = Looper.myLooper();
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool != null) {
                    AudioService.this.mSoundPoolCallBack = new SoundPoolCallback();
                    AudioService.this.mSoundPool.setOnLoadCompleteListener(AudioService.this.mSoundPoolCallBack);
                }
                AudioService.this.mSoundEffectsLock.notify();
            }
            Looper.loop();
        }
    }

    class LoadSoundEffectReply {
        public int mStatus = 1;

        LoadSoundEffectReply() {
        }
    }

    private class SetModeDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mPid;
        private int mMode = 0;

        SetModeDeathHandler(IBinder cb, int pid) {
            this.mCb = cb;
            this.mPid = pid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            int newModeOwnerPid = 0;
            ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "setMode() client died");
                int index = AudioService.this.mSetModeDeathHandlers.indexOf(this);
                if (index < 0) {
                    Log.w(AudioService.TAG, "unregistered setMode() client died");
                } else {
                    newModeOwnerPid = AudioService.this.setModeInt(0, this.mCb, this.mPid);
                }
            }
            if (newModeOwnerPid != 0) {
                long ident = Binder.clearCallingIdentity();
                AudioService.this.disconnectBluetoothSco(newModeOwnerPid);
                Binder.restoreCallingIdentity(ident);
            }
        }

        public int getPid() {
            return this.mPid;
        }

        public void setMode(int mode) {
            this.mMode = mode;
        }

        public int getMode() {
            return this.mMode;
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private class ForceControlStreamClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        ForceControlStreamClient(IBinder cb) {
            if (cb != null) {
                try {
                    cb.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    Log.w(AudioService.TAG, "ForceControlStreamClient() could not link to " + cb + " binder death");
                    cb = null;
                }
            }
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Object object = AudioService.this.mForceControlStreamLock;
            synchronized (object) {
                Log.w(AudioService.TAG, "SCO client died");
                if (AudioService.this.mForceControlStreamClient != this) {
                    Log.w(AudioService.TAG, "unregistered control stream client died");
                } else {
                    AudioService.this.mForceControlStreamClient = null;
                    AudioService.this.mVolumeControlStream = -1;
                }
            }
        }

        public void release() {
            if (this.mCb != null) {
                this.mCb.unlinkToDeath(this, 0);
                this.mCb = null;
            }
        }
    }

    class StreamVolumeCommand {
        public final int mStreamType;
        public final int mIndex;
        public final int mFlags;
        public final int mDevice;

        StreamVolumeCommand(int streamType, int index, int flags, int device) {
            this.mStreamType = streamType;
            this.mIndex = index;
            this.mFlags = flags;
            this.mDevice = device;
        }
    }
}

