/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.media.AudioService;
import android.media.FocusRequester;
import android.media.IAudioFocusDispatcher;
import android.media.IRemoteControlClient;
import android.media.IRemoteControlDisplay;
import android.media.IRemoteVolumeObserver;
import android.media.Rating;
import android.media.VolumeController;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.Slog;
import android.view.KeyEvent;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class MediaFocusControl
implements PendingIntent.OnFinished {
    private static final String TAG = "MediaFocusControl";
    protected static final boolean DEBUG_RC = false;
    protected static final boolean DEBUG_VOL = false;
    private boolean mIsRinging = false;
    private final PowerManager.WakeLock mMediaEventWakeLock;
    private final MediaEventHandler mEventHandler;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final VolumeController mVolumeController;
    private final BroadcastReceiver mReceiver = new PackageIntentsReceiver();
    private final AppOpsManager mAppOps;
    private final KeyguardManager mKeyguardManager;
    private final AudioService mAudioService;
    private final NotificationListenerObserver mNotifListenerObserver;
    private static final Uri ENABLED_NOTIFICATION_LISTENERS_URI = Settings.Secure.getUriFor("enabled_notification_listeners");
    private static final int RCD_REG_FAILURE = 0;
    private static final int RCD_REG_SUCCESS_PERMISSION = 1;
    private static final int RCD_REG_SUCCESS_ENABLED_NOTIF = 2;
    private static final int MSG_PERSIST_MEDIABUTTONRECEIVER = 0;
    private static final int MSG_RCDISPLAY_CLEAR = 1;
    private static final int MSG_RCDISPLAY_UPDATE = 2;
    private static final int MSG_REEVALUATE_REMOTE = 3;
    private static final int MSG_RCC_NEW_PLAYBACK_INFO = 4;
    private static final int MSG_RCC_NEW_VOLUME_OBS = 5;
    private static final int MSG_PROMOTE_RCC = 6;
    private static final int MSG_RCC_NEW_PLAYBACK_STATE = 7;
    private static final int MSG_RCC_SEEK_REQUEST = 8;
    private static final int MSG_RCC_UPDATE_METADATA = 9;
    private static final int MSG_RCDISPLAY_INIT_INFO = 10;
    private static final int MSG_REEVALUATE_RCD = 11;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    protected static final String IN_VOICE_COMM_FOCUS_ID = "AudioFocus_For_Phone_Ring_And_Calls";
    private static final Object mAudioFocusLock = new Object();
    private static final Object mRingingLock = new Object();
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCallStateChanged(int state, String incomingNumber) {
            if (state == 1) {
                Object object = mRingingLock;
                synchronized (object) {
                    MediaFocusControl.this.mIsRinging = true;
                }
            }
            if (state == 2 || state == 0) {
                Object object = mRingingLock;
                synchronized (object) {
                    MediaFocusControl.this.mIsRinging = false;
                }
            }
        }
    };
    private final Stack<FocusRequester> mFocusStack = new Stack();
    private static final int VOICEBUTTON_ACTION_DISCARD_CURRENT_KEY_PRESS = 1;
    private static final int VOICEBUTTON_ACTION_START_VOICE_INPUT = 2;
    private static final int VOICEBUTTON_ACTION_SIMULATE_KEY_PRESS = 3;
    private final Object mVoiceEventLock = new Object();
    private boolean mVoiceButtonDown;
    private boolean mVoiceButtonHandled;
    private static final int WAKELOCK_RELEASE_ON_FINISHED = 1980;
    private static final String EXTRA_WAKELOCK_ACQUIRED = "android.media.AudioService.WAKELOCK_ACQUIRED";
    BroadcastReceiver mKeyEventDone = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            Bundle extras = intent.getExtras();
            if (extras == null) {
                return;
            }
            if (extras.containsKey(MediaFocusControl.EXTRA_WAKELOCK_ACQUIRED)) {
                MediaFocusControl.this.mMediaEventWakeLock.release();
            }
        }
    };
    private final Object mCurrentRcLock = new Object();
    private IRemoteControlClient mCurrentRcClient = null;
    private PendingIntent mCurrentRcClientIntent = null;
    private static final int RC_INFO_NONE = 0;
    private static final int RC_INFO_ALL = 15;
    private int mCurrentRcClientGen = 0;
    private static int sLastRccId = 0;
    private RemotePlaybackState mMainRemote;
    private boolean mMainRemoteIsActive;
    private boolean mHasRemotePlayback;
    private final Stack<RemoteControlStackEntry> mRCStack = new Stack();
    private ComponentName mMediaReceiverForCalls = null;
    private ArrayList<DisplayInfoForServer> mRcDisplays = new ArrayList(1);

    protected MediaFocusControl(Looper looper, Context cntxt, VolumeController volumeCtrl, AudioService as) {
        this.mEventHandler = new MediaEventHandler(looper);
        this.mContext = cntxt;
        this.mContentResolver = this.mContext.getContentResolver();
        this.mVolumeController = volumeCtrl;
        this.mAudioService = as;
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mMediaEventWakeLock = pm.newWakeLock(1, "handleMediaEvent");
        this.mMainRemote = new RemotePlaybackState(-1, AudioService.getMaxStreamVolume(3), AudioService.getMaxStreamVolume(3));
        TelephonyManager tmgr = (TelephonyManager)this.mContext.getSystemService("phone");
        tmgr.listen(this.mPhoneStateListener, 32);
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        pkgFilter.addAction("android.intent.action.PACKAGE_ADDED");
        pkgFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        pkgFilter.addAction("android.intent.action.PACKAGE_DATA_CLEARED");
        pkgFilter.addDataScheme("package");
        this.mContext.registerReceiver(this.mReceiver, pkgFilter);
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        this.mNotifListenerObserver = new NotificationListenerObserver();
        this.mHasRemotePlayback = false;
        this.mMainRemoteIsActive = false;
        this.postReevaluateRemote();
    }

    protected void dump(PrintWriter pw) {
        this.dumpFocusStack(pw);
        this.dumpRCStack(pw);
        this.dumpRCCStack(pw);
        this.dumpRCDList(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkRcdRegistrationAuthorization(ComponentName listenerComp) {
        if (0 == this.mContext.checkCallingOrSelfPermission("android.permission.MEDIA_CONTENT_CONTROL")) {
            return 1;
        }
        if (listenerComp != null) {
            long ident = Binder.clearCallingIdentity();
            try {
                int currentUser = ActivityManager.getCurrentUser();
                String enabledNotifListeners = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", currentUser);
                if (enabledNotifListeners != null) {
                    String[] components = enabledNotifListeners.split(":");
                    for (int i = 0; i < components.length; ++i) {
                        ComponentName component = ComponentName.unflattenFromString(components[i]);
                        if (component == null || !listenerComp.equals(component)) continue;
                        int n = 2;
                        return n;
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        return 0;
    }

    protected boolean registerRemoteController(IRemoteControlDisplay rcd, int w, int h, ComponentName listenerComp) {
        int reg = this.checkRcdRegistrationAuthorization(listenerComp);
        if (reg != 0) {
            this.registerRemoteControlDisplay_int(rcd, w, h, listenerComp);
            return true;
        }
        Slog.w(TAG, "Access denied to process: " + Binder.getCallingPid() + ", must have permission " + "android.permission.MEDIA_CONTENT_CONTROL" + " or be an enabled NotificationListenerService for registerRemoteController");
        return false;
    }

    protected boolean registerRemoteControlDisplay(IRemoteControlDisplay rcd, int w, int h) {
        int reg = this.checkRcdRegistrationAuthorization(null);
        if (reg != 0) {
            this.registerRemoteControlDisplay_int(rcd, w, h, null);
            return true;
        }
        Slog.w(TAG, "Access denied to process: " + Binder.getCallingPid() + ", must have permission " + "android.permission.MEDIA_CONTENT_CONTROL" + " to register IRemoteControlDisplay");
        return false;
    }

    private void postReevaluateRemoteControlDisplays() {
        MediaFocusControl.sendMsg(this.mEventHandler, 11, 2, 0, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReevaluateRemoteControlDisplays() {
        int currentUser = ActivityManager.getCurrentUser();
        String enabledNotifListeners = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", currentUser);
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                String[] enabledComponents = enabledNotifListeners == null ? null : enabledNotifListeners.split(":");
                for (DisplayInfoForServer di : this.mRcDisplays) {
                    if (di.mClientNotifListComp == null) continue;
                    boolean wasEnabled = di.mEnabled;
                    di.mEnabled = this.isComponentInStringArray(di.mClientNotifListComp, enabledComponents);
                    if (wasEnabled == di.mEnabled) continue;
                    try {
                        di.mRcDisplay.setEnabled(di.mEnabled);
                        this.enableRemoteControlDisplayForClient_syncRcStack(di.mRcDisplay, di.mEnabled);
                        if (!di.mEnabled) continue;
                        MediaFocusControl.sendMsg(this.mEventHandler, 10, 2, di.mArtworkExpectedWidth, di.mArtworkExpectedHeight, di.mRcDisplay, 0);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error en/disabling RCD: ", e);
                    }
                }
            }
        }
    }

    private boolean isComponentInStringArray(ComponentName comp, String[] enabledArray) {
        if (enabledArray == null || enabledArray.length == 0) {
            return false;
        }
        String compString = comp.flattenToString();
        for (int i = 0; i < enabledArray.length; ++i) {
            if (!compString.equals(enabledArray[i])) continue;
            return true;
        }
        return false;
    }

    private static void sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discardAudioFocusOwner() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (!this.mFocusStack.empty()) {
                FocusRequester exFocusOwner = this.mFocusStack.pop();
                exFocusOwner.handleFocusLoss(-1);
                exFocusOwner.release();
                Stack<RemoteControlStackEntry> stack = this.mRCStack;
                synchronized (stack) {
                    this.clearRemoteControlDisplay_syncAfRcs();
                }
            }
        }
    }

    private void notifyTopOfAudioFocusStack() {
        if (!this.mFocusStack.empty() && this.canReassignAudioFocus()) {
            this.mFocusStack.peek().handleFocusGain(1);
        }
    }

    private void propagateFocusLossFromGain_syncAf(int focusGain) {
        Iterator stackIterator = this.mFocusStack.iterator();
        while (stackIterator.hasNext()) {
            ((FocusRequester)stackIterator.next()).handleExternalFocusGain(focusGain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFocusStack(PrintWriter pw) {
        pw.println("\nAudio Focus stack entries (last is top of stack):");
        Object object = mAudioFocusLock;
        synchronized (object) {
            Iterator stackIterator = this.mFocusStack.iterator();
            while (stackIterator.hasNext()) {
                ((FocusRequester)stackIterator.next()).dump(pw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFocusStackEntry(String clientToRemove, boolean signal) {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().hasSameClient(clientToRemove)) {
            FocusRequester fr = this.mFocusStack.pop();
            fr.release();
            if (signal) {
                this.notifyTopOfAudioFocusStack();
                Stack<RemoteControlStackEntry> stack = this.mRCStack;
                synchronized (stack) {
                    this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
                }
            }
        } else {
            Iterator stackIterator = this.mFocusStack.iterator();
            while (stackIterator.hasNext()) {
                FocusRequester fr = (FocusRequester)stackIterator.next();
                if (!fr.hasSameClient(clientToRemove)) continue;
                Log.i(TAG, "AudioFocus  removeFocusStackEntry(): removing entry for " + clientToRemove);
                stackIterator.remove();
                fr.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFocusStackEntryForClient(IBinder cb) {
        boolean isTopOfStackForClientToRemove = !this.mFocusStack.isEmpty() && this.mFocusStack.peek().hasSameBinder(cb);
        Iterator stackIterator = this.mFocusStack.iterator();
        while (stackIterator.hasNext()) {
            FocusRequester fr = (FocusRequester)stackIterator.next();
            if (!fr.hasSameBinder(cb)) continue;
            Log.i(TAG, "AudioFocus  removeFocusStackEntry(): removing entry for " + cb);
            stackIterator.remove();
        }
        if (isTopOfStackForClientToRemove) {
            this.notifyTopOfAudioFocusStack();
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
            }
        }
    }

    private boolean canReassignAudioFocus() {
        return this.mFocusStack.isEmpty() || !this.mFocusStack.peek().hasSameClient(IN_VOICE_COMM_FOCUS_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCurrentAudioFocus() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (this.mFocusStack.empty()) {
                return 0;
            }
            return this.mFocusStack.peek().getGainRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int requestAudioFocus(int mainStreamType, int focusChangeHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName) {
        Log.i(TAG, " AudioFocus  requestAudioFocus() from " + clientId);
        if (!cb.pingBinder()) {
            Log.e(TAG, " AudioFocus DOA client for requestAudioFocus(), aborting.");
            return 0;
        }
        if (this.mAppOps.noteOp(32, Binder.getCallingUid(), callingPackageName) != 0) {
            return 0;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (!this.canReassignAudioFocus()) {
                return 0;
            }
            AudioFocusDeathHandler afdh = new AudioFocusDeathHandler(cb);
            try {
                cb.linkToDeath(afdh, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "AudioFocus  requestAudioFocus() could not link to " + cb + " binder death");
                return 0;
            }
            if (!this.mFocusStack.empty() && this.mFocusStack.peek().hasSameClient(clientId)) {
                if (this.mFocusStack.peek().getGainRequest() == focusChangeHint) {
                    cb.unlinkToDeath(afdh, 0);
                    return 1;
                }
                FocusRequester fr = this.mFocusStack.pop();
                fr.release();
            }
            this.removeFocusStackEntry(clientId, false);
            if (!this.mFocusStack.empty()) {
                this.propagateFocusLossFromGain_syncAf(focusChangeHint);
            }
            this.mFocusStack.push(new FocusRequester(mainStreamType, focusChangeHint, fd, cb, clientId, afdh, callingPackageName, Binder.getCallingUid()));
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int abandonAudioFocus(IAudioFocusDispatcher fl, String clientId) {
        Log.i(TAG, " AudioFocus  abandonAudioFocus() from " + clientId);
        try {
            Object object = mAudioFocusLock;
            synchronized (object) {
                this.removeFocusStackEntry(clientId, true);
            }
        }
        catch (ConcurrentModificationException cme) {
            Log.e(TAG, "FATAL EXCEPTION AudioFocus  abandonAudioFocus() caused " + cme);
            cme.printStackTrace();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterAudioFocusClient(String clientId) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            this.removeFocusStackEntry(clientId, false);
        }
    }

    protected void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        this.filterMediaKeyEvent(keyEvent, false);
    }

    protected void dispatchMediaKeyEventUnderWakelock(KeyEvent keyEvent) {
        this.filterMediaKeyEvent(keyEvent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        if (!MediaFocusControl.isValidMediaKeyEvent(keyEvent)) {
            Log.e(TAG, "not dispatching invalid media key event " + keyEvent);
            return;
        }
        Object object = mRingingLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                if (this.mMediaReceiverForCalls != null && (this.mIsRinging || this.mAudioService.getMode() == 2)) {
                    this.dispatchMediaKeyEventForCalls(keyEvent, needWakeLock);
                    return;
                }
            }
        }
        if (MediaFocusControl.isValidVoiceInputKeyCode(keyEvent.getKeyCode())) {
            this.filterVoiceInputKeyEvent(keyEvent, needWakeLock);
        } else {
            this.dispatchMediaKeyEvent(keyEvent, needWakeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMediaKeyEventForCalls(KeyEvent keyEvent, boolean needWakeLock) {
        Intent keyIntent = new Intent("android.intent.action.MEDIA_BUTTON", null);
        keyIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
        keyIntent.setPackage(this.mMediaReceiverForCalls.getPackageName());
        if (needWakeLock) {
            this.mMediaEventWakeLock.acquire();
            keyIntent.putExtra(EXTRA_WAKELOCK_ACQUIRED, 1980);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(keyIntent, UserHandle.ALL, null, this.mKeyEventDone, this.mEventHandler, -1, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        if (needWakeLock) {
            this.mMediaEventWakeLock.acquire();
        }
        Intent keyIntent = new Intent("android.intent.action.MEDIA_BUTTON", null);
        keyIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            if (!this.mRCStack.empty()) {
                try {
                    this.mRCStack.peek().mMediaIntent.send(this.mContext, needWakeLock ? 1980 : 0, keyIntent, this, this.mEventHandler);
                }
                catch (PendingIntent.CanceledException e) {
                    Log.e(TAG, "Error sending pending intent " + this.mRCStack.peek());
                    e.printStackTrace();
                }
            } else {
                if (needWakeLock) {
                    keyIntent.putExtra(EXTRA_WAKELOCK_ACQUIRED, 1980);
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mContext.sendOrderedBroadcastAsUser(keyIntent, UserHandle.ALL, null, this.mKeyEventDone, this.mEventHandler, -1, null, null);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterVoiceInputKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        int voiceButtonAction = 1;
        int keyAction = keyEvent.getAction();
        Object object = this.mVoiceEventLock;
        synchronized (object) {
            if (keyAction == 0) {
                if (keyEvent.getRepeatCount() == 0) {
                    this.mVoiceButtonDown = true;
                    this.mVoiceButtonHandled = false;
                } else if (this.mVoiceButtonDown && !this.mVoiceButtonHandled && (keyEvent.getFlags() & 0x80) != 0) {
                    this.mVoiceButtonHandled = true;
                    voiceButtonAction = 2;
                }
            } else if (keyAction == 1 && this.mVoiceButtonDown) {
                this.mVoiceButtonDown = false;
                if (!this.mVoiceButtonHandled && !keyEvent.isCanceled()) {
                    voiceButtonAction = 3;
                }
            }
        }
        switch (voiceButtonAction) {
            case 1: {
                break;
            }
            case 2: {
                this.startVoiceBasedInteractions(needWakeLock);
                break;
            }
            case 3: {
                this.sendSimulatedMediaButtonEvent(keyEvent, needWakeLock);
            }
        }
    }

    private void sendSimulatedMediaButtonEvent(KeyEvent originalKeyEvent, boolean needWakeLock) {
        KeyEvent keyEvent = KeyEvent.changeAction(originalKeyEvent, 0);
        this.dispatchMediaKeyEvent(keyEvent, needWakeLock);
        keyEvent = KeyEvent.changeAction(originalKeyEvent, 1);
        this.dispatchMediaKeyEvent(keyEvent, needWakeLock);
    }

    protected static boolean isMediaKeyCode(int keyCode) {
        switch (keyCode) {
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 222: {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidMediaKeyEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return false;
        }
        return MediaFocusControl.isMediaKeyCode(keyEvent.getKeyCode());
    }

    private static boolean isValidVoiceInputKeyCode(int keyCode) {
        return keyCode == 79;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startVoiceBasedInteractions(boolean needWakeLock) {
        boolean isLocked;
        Intent voiceIntent = null;
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        boolean bl = isLocked = this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked();
        if (!isLocked && pm.isScreenOn()) {
            voiceIntent = new Intent("android.speech.action.WEB_SEARCH");
            Log.i(TAG, "voice-based interactions: about to use ACTION_WEB_SEARCH");
        } else {
            voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
            voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", isLocked && this.mKeyguardManager.isKeyguardSecure());
            Log.i(TAG, "voice-based interactions: about to use ACTION_VOICE_SEARCH_HANDS_FREE");
        }
        if (needWakeLock) {
            this.mMediaEventWakeLock.acquire();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (voiceIntent != null) {
                voiceIntent.setFlags(0x10800000);
                this.mContext.startActivityAsUser(voiceIntent, UserHandle.CURRENT);
            }
        }
        catch (ActivityNotFoundException e) {
            Log.w(TAG, "No activity for search: " + e);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
            if (needWakeLock) {
                this.mMediaEventWakeLock.release();
            }
        }
    }

    public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
        if (resultCode == 1980) {
            this.mMediaEventWakeLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRCStack(PrintWriter pw) {
        pw.println("\nRemote Control stack entries (last is top of stack):");
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            for (RemoteControlStackEntry rcse : this.mRCStack) {
                pw.println("  pi: " + rcse.mMediaIntent + " -- pack: " + rcse.mCallingPackageName + "  -- ercvr: " + rcse.mReceiverComponent + "  -- client: " + rcse.mRcClient + "  -- uid: " + rcse.mCallingUid + "  -- type: " + rcse.mPlaybackType + "  state: " + rcse.mPlaybackState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRCCStack(PrintWriter pw) {
        pw.println("\nRemote Control Client stack entries (last is top of stack):");
        Object object = this.mRCStack;
        synchronized (object) {
            for (RemoteControlStackEntry rcse : this.mRCStack) {
                pw.println("  uid: " + rcse.mCallingUid + "  -- id: " + rcse.mRccId + "  -- type: " + rcse.mPlaybackType + "  -- state: " + rcse.mPlaybackState + "  -- vol handling: " + rcse.mPlaybackVolumeHandling + "  -- vol: " + rcse.mPlaybackVolume + "  -- volMax: " + rcse.mPlaybackVolumeMax + "  -- volObs: " + rcse.mRemoteVolumeObs);
            }
            Object object2 = this.mCurrentRcLock;
            synchronized (object2) {
                pw.println("\nCurrent remote control generation ID = " + this.mCurrentRcClientGen);
            }
        }
        object = this.mMainRemote;
        synchronized (object) {
            pw.println("\nRemote Volume State:");
            pw.println("  has remote: " + this.mHasRemotePlayback);
            pw.println("  is remote active: " + this.mMainRemoteIsActive);
            pw.println("  rccId: " + this.mMainRemote.mRccId);
            pw.println("  volume handling: " + (this.mMainRemote.mVolumeHandling == 0 ? "PLAYBACK_VOLUME_FIXED(0)" : "PLAYBACK_VOLUME_VARIABLE(1)"));
            pw.println("  volume: " + this.mMainRemote.mVolume);
            pw.println("  volume steps: " + this.mMainRemote.mVolumeMax);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRCDList(PrintWriter pw) {
        pw.println("\nRemote Control Display list entries:");
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            for (DisplayInfoForServer di : this.mRcDisplays) {
                pw.println("  IRCD: " + di.mRcDisplay + "  -- w:" + di.mArtworkExpectedWidth + "  -- h:" + di.mArtworkExpectedHeight + "  -- wantsPosSync:" + di.mWantsPositionSync + "  -- " + (di.mEnabled ? "enabled" : "disabled"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupMediaButtonReceiverForPackage(String packageName, boolean removeAll) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            RemoteControlStackEntry rcse;
            if (this.mRCStack.empty()) {
                return;
            }
            PackageManager pm = this.mContext.getPackageManager();
            RemoteControlStackEntry oldTop = this.mRCStack.peek();
            Iterator stackIterator = this.mRCStack.iterator();
            while (stackIterator.hasNext()) {
                rcse = (RemoteControlStackEntry)stackIterator.next();
                if (removeAll && packageName.equals(rcse.mMediaIntent.getCreatorPackage())) {
                    stackIterator.remove();
                    rcse.destroy();
                    continue;
                }
                if (rcse.mReceiverComponent == null) continue;
                try {
                    pm.getReceiverInfo(rcse.mReceiverComponent, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    stackIterator.remove();
                    rcse.destroy();
                }
            }
            if (this.mRCStack.empty()) {
                this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(0, 0, 0, null));
            } else if (oldTop != this.mRCStack.peek()) {
                rcse = this.mRCStack.peek();
                if (rcse.mReceiverComponent != null) {
                    this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(0, 0, 0, rcse.mReceiverComponent));
                }
            }
        }
    }

    protected void restoreMediaButtonReceiver() {
        String receiverName = Settings.System.getStringForUser(this.mContentResolver, "media_button_receiver", -2);
        if (null != receiverName && !receiverName.isEmpty()) {
            ComponentName eventReceiver = ComponentName.unflattenFromString(receiverName);
            if (eventReceiver == null) {
                return;
            }
            Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
            mediaButtonIntent.setComponent(eventReceiver);
            PendingIntent pi = PendingIntent.getBroadcast(this.mContext, 0, mediaButtonIntent, 0);
            this.registerMediaButtonIntent(pi, eventReceiver, null);
        }
    }

    private void pushMediaButtonReceiver_syncAfRcs(PendingIntent mediaIntent, ComponentName target, IBinder token) {
        if (!this.mRCStack.empty() && this.mRCStack.peek().mMediaIntent.equals(mediaIntent)) {
            return;
        }
        if (this.mAppOps.noteOp(31, Binder.getCallingUid(), mediaIntent.getCreatorPackage()) != 0) {
            return;
        }
        RemoteControlStackEntry rcse = null;
        boolean wasInsideStack = false;
        try {
            for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                if (!rcse.mMediaIntent.equals(mediaIntent)) continue;
                this.mRCStack.removeElementAt(index);
                wasInsideStack = true;
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.e(TAG, "Wrong index accessing media button stack, lock error? ", e);
        }
        if (!wasInsideStack) {
            rcse = new RemoteControlStackEntry(this, mediaIntent, target, token);
        }
        this.mRCStack.push(rcse);
        if (target != null) {
            this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(0, 0, 0, target));
        }
    }

    private void removeMediaButtonReceiver_syncAfRcs(PendingIntent pi) {
        try {
            for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                if (!rcse.mMediaIntent.equals(pi)) continue;
                rcse.destroy();
                this.mRCStack.removeElementAt(index);
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.e(TAG, "Wrong index accessing media button stack, lock error? ", e);
        }
    }

    private boolean isCurrentRcController(PendingIntent pi) {
        return !this.mRCStack.empty() && this.mRCStack.peek().mMediaIntent.equals(pi);
    }

    private void onHandlePersistMediaButtonReceiver(ComponentName receiver) {
        Settings.System.putStringForUser(this.mContentResolver, "media_button_receiver", receiver == null ? "" : receiver.flattenToString(), -2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewRcClientOnDisplays_syncRcsCurrc(int newClientGeneration, PendingIntent newMediaIntent, boolean clearing) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            if (this.mRcDisplays.size() > 0) {
                Iterator<DisplayInfoForServer> displayIterator = this.mRcDisplays.iterator();
                while (displayIterator.hasNext()) {
                    DisplayInfoForServer di = displayIterator.next();
                    try {
                        di.mRcDisplay.setCurrentClientId(newClientGeneration, newMediaIntent, clearing);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Dead display in setNewRcClientOnDisplays_syncRcsCurrc()", e);
                        di.release();
                        displayIterator.remove();
                    }
                }
            }
        }
    }

    private void setNewRcClientGenerationOnClients_syncRcsCurrc(int newClientGeneration) {
        Iterator stackIterator = this.mRCStack.iterator();
        while (stackIterator.hasNext()) {
            RemoteControlStackEntry se = (RemoteControlStackEntry)stackIterator.next();
            if (se == null || se.mRcClient == null) continue;
            try {
                se.mRcClient.setCurrentClientGenerationId(newClientGeneration);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Dead client in setNewRcClientGenerationOnClients_syncRcsCurrc()", e);
                stackIterator.remove();
                se.unlinkToRcClientDeath();
            }
        }
    }

    private void setNewRcClient_syncRcsCurrc(int newClientGeneration, PendingIntent newMediaIntent, boolean clearing) {
        this.setNewRcClientOnDisplays_syncRcsCurrc(newClientGeneration, newMediaIntent, clearing);
        this.setNewRcClientGenerationOnClients_syncRcsCurrc(newClientGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRcDisplayClear() {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                ++this.mCurrentRcClientGen;
                this.setNewRcClient_syncRcsCurrc(this.mCurrentRcClientGen, null, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRcDisplayUpdate(RemoteControlStackEntry rcse, int flags) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClient != null && this.mCurrentRcClient.equals(rcse.mRcClient)) {
                    ++this.mCurrentRcClientGen;
                    this.setNewRcClient_syncRcsCurrc(this.mCurrentRcClientGen, rcse.mMediaIntent, false);
                    try {
                        this.mCurrentRcClient.onInformationRequested(this.mCurrentRcClientGen, flags);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Current valid remote client is dead: " + e);
                        this.mCurrentRcClient = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRcDisplayInitInfo(IRemoteControlDisplay newRcd, int w, int h) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClient != null) {
                    try {
                        newRcd.setCurrentClientId(this.mCurrentRcClientGen, this.mCurrentRcClientIntent, false);
                        try {
                            this.mCurrentRcClient.informationRequestForDisplay(newRcd, w, h);
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Current valid remote client is dead: ", e);
                            this.mCurrentRcClient = null;
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Dead display in onRcDisplayInitInfo()", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRemoteControlDisplay_syncAfRcs() {
        Object object = this.mCurrentRcLock;
        synchronized (object) {
            this.mCurrentRcClient = null;
        }
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRemoteControlDisplay_syncAfRcs(int infoChangedFlags) {
        RemoteControlStackEntry rcse = this.mRCStack.peek();
        int infoFlagsAboutToBeUsed = infoChangedFlags;
        if (rcse.mRcClient == null) {
            this.clearRemoteControlDisplay_syncAfRcs();
            return;
        }
        Object object = this.mCurrentRcLock;
        synchronized (object) {
            if (!rcse.mRcClient.equals(this.mCurrentRcClient)) {
                infoFlagsAboutToBeUsed = 15;
            }
            this.mCurrentRcClient = rcse.mRcClient;
            this.mCurrentRcClientIntent = rcse.mMediaIntent;
        }
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(2, infoFlagsAboutToBeUsed, 0, rcse));
    }

    private void checkUpdateRemoteControlDisplay_syncAfRcs(int infoChangedFlags) {
        if (this.mRCStack.isEmpty() || this.mFocusStack.isEmpty()) {
            this.clearRemoteControlDisplay_syncAfRcs();
            return;
        }
        FocusRequester af = null;
        try {
            for (int index = this.mFocusStack.size() - 1; index >= 0; --index) {
                FocusRequester fr = (FocusRequester)this.mFocusStack.elementAt(index);
                if (fr.getStreamType() != 3 && fr.getGainRequest() != 1) continue;
                af = fr;
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.e(TAG, "Wrong index accessing audio focus stack when updating RCD: " + e);
            af = null;
        }
        if (af == null) {
            this.clearRemoteControlDisplay_syncAfRcs();
            return;
        }
        if (!af.hasSamePackage(this.mRCStack.peek().mCallingPackageName)) {
            this.clearRemoteControlDisplay_syncAfRcs();
            return;
        }
        if (!af.hasSameUid(this.mRCStack.peek().mCallingUid)) {
            this.clearRemoteControlDisplay_syncAfRcs();
            return;
        }
        this.updateRemoteControlDisplay_syncAfRcs(infoChangedFlags);
    }

    private void postPromoteRcc(int rccId) {
        MediaFocusControl.sendMsg(this.mEventHandler, 6, 0, rccId, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPromoteRcc(int rccId) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                if (!this.mRCStack.isEmpty() && this.mRCStack.peek().mRccId == rccId) {
                    return;
                }
                int indexToPromote = -1;
                try {
                    for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                        RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                        if (rcse.mRccId != rccId) continue;
                        indexToPromote = index;
                        break;
                    }
                    if (indexToPromote >= 0) {
                        RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.remove(indexToPromote);
                        this.mRCStack.push(rcse);
                        this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Log.e(TAG, "Wrong index accessing RC stack, lock error? ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerMediaButtonIntent(PendingIntent mediaIntent, ComponentName eventReceiver, IBinder token) {
        Log.i(TAG, "  Remote Control   registerMediaButtonIntent() for " + mediaIntent);
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                this.pushMediaButtonReceiver_syncAfRcs(mediaIntent, eventReceiver, token);
                this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterMediaButtonIntent(PendingIntent mediaIntent) {
        Log.i(TAG, "  Remote Control   unregisterMediaButtonIntent() for " + mediaIntent);
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                boolean topOfStackWillChange = this.isCurrentRcController(mediaIntent);
                this.removeMediaButtonReceiver_syncAfRcs(mediaIntent);
                if (topOfStackWillChange) {
                    this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerMediaButtonEventReceiverForCalls(ComponentName c) {
        if (this.mContext.checkCallingPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.e(TAG, "Invalid permissions to register media button receiver for calls");
            return;
        }
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            this.mMediaReceiverForCalls = c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterMediaButtonEventReceiverForCalls() {
        if (this.mContext.checkCallingPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.e(TAG, "Invalid permissions to unregister media button receiver for calls");
            return;
        }
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            this.mMediaReceiverForCalls = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int registerRemoteControlClient(PendingIntent mediaIntent, IRemoteControlClient rcClient, String callingPackageName) {
        int rccId = -1;
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                try {
                    for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                        RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                        if (!rcse.mMediaIntent.equals(mediaIntent)) continue;
                        if (rcse.mRcClientDeathHandler != null) {
                            rcse.unlinkToRcClientDeath();
                        }
                        rcse.mRcClient = rcClient;
                        rcse.mCallingPackageName = callingPackageName;
                        rcse.mCallingUid = Binder.getCallingUid();
                        if (rcClient == null) {
                            rcse.resetPlaybackInfo();
                            break;
                        }
                        rccId = rcse.mRccId;
                        if (this.mRcDisplays.size() > 0) {
                            this.plugRemoteControlDisplaysIntoClient_syncRcStack(rcse.mRcClient);
                        }
                        IBinder b = rcse.mRcClient.asBinder();
                        RcClientDeathHandler rcdh = new RcClientDeathHandler(b, rcse.mMediaIntent);
                        try {
                            b.linkToDeath(rcdh, 0);
                        }
                        catch (RemoteException e) {
                            Log.w(TAG, "registerRemoteControlClient() has a dead client " + b);
                            rcse.mRcClient = null;
                        }
                        rcse.mRcClientDeathHandler = rcdh;
                        break;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Log.e(TAG, "Wrong index accessing RC stack, lock error? ", e);
                }
                if (this.isCurrentRcController(mediaIntent)) {
                    this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
                }
            }
        }
        return rccId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterRemoteControlClient(PendingIntent mediaIntent, IRemoteControlClient rcClient) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                boolean topRccChange = false;
                try {
                    for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                        RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                        if (!rcse.mMediaIntent.equals(mediaIntent) || !rcClient.equals(rcse.mRcClient)) continue;
                        rcse.unlinkToRcClientDeath();
                        rcse.mRcClient = null;
                        rcse.mCallingPackageName = null;
                        topRccChange = index == this.mRCStack.size() - 1;
                        break;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Log.e(TAG, "Wrong index accessing RC stack, lock error? ", e);
                }
                if (topRccChange) {
                    this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
                }
            }
        }
    }

    private void plugRemoteControlDisplaysIntoClient_syncRcStack(IRemoteControlClient rcc) {
        for (DisplayInfoForServer di : this.mRcDisplays) {
            try {
                rcc.plugRemoteControlDisplay(di.mRcDisplay, di.mArtworkExpectedWidth, di.mArtworkExpectedHeight);
                if (!di.mWantsPositionSync) continue;
                rcc.setWantsSyncForDisplay(di.mRcDisplay, true);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error connecting RCD to RCC in RCC registration", e);
            }
        }
    }

    private void enableRemoteControlDisplayForClient_syncRcStack(IRemoteControlDisplay rcd, boolean enabled) {
        for (RemoteControlStackEntry rcse : this.mRCStack) {
            if (rcse.mRcClient == null) continue;
            try {
                rcse.mRcClient.enableRemoteControlDisplay(rcd, enabled);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error connecting RCD to client: ", e);
            }
        }
    }

    private boolean rcDisplayIsPluggedIn_syncRcStack(IRemoteControlDisplay rcd) {
        for (DisplayInfoForServer di : this.mRcDisplays) {
            if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRemoteControlDisplay_int(IRemoteControlDisplay rcd, int w, int h, ComponentName listenerComp) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                if (rcd == null || this.rcDisplayIsPluggedIn_syncRcStack(rcd)) {
                    return;
                }
                DisplayInfoForServer di = new DisplayInfoForServer(rcd, w, h);
                di.mEnabled = true;
                di.mClientNotifListComp = listenerComp;
                if (!di.init()) {
                    return;
                }
                this.mRcDisplays.add(di);
                for (RemoteControlStackEntry rcse : this.mRCStack) {
                    if (rcse.mRcClient == null) continue;
                    try {
                        rcse.mRcClient.plugRemoteControlDisplay(rcd, w, h);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error connecting RCD to client: ", e);
                    }
                }
                MediaFocusControl.sendMsg(this.mEventHandler, 10, 2, w, h, rcd, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterRemoteControlDisplay(IRemoteControlDisplay rcd) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            if (rcd == null) {
                return;
            }
            boolean displayWasPluggedIn = false;
            Iterator<DisplayInfoForServer> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext() && !displayWasPluggedIn) {
                DisplayInfoForServer di = displayIterator.next();
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
                displayWasPluggedIn = true;
                di.release();
                displayIterator.remove();
            }
            if (displayWasPluggedIn) {
                for (RemoteControlStackEntry rcse : this.mRCStack) {
                    if (rcse.mRcClient == null) continue;
                    try {
                        rcse.mRcClient.unplugRemoteControlDisplay(rcd);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error disconnecting remote control display to client: ", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay rcd, int w, int h) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Iterator<DisplayInfoForServer> displayIterator = this.mRcDisplays.iterator();
            boolean artworkSizeUpdate = false;
            while (displayIterator.hasNext() && !artworkSizeUpdate) {
                DisplayInfoForServer di = displayIterator.next();
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder()) || di.mArtworkExpectedWidth == w && di.mArtworkExpectedHeight == h) continue;
                di.mArtworkExpectedWidth = w;
                di.mArtworkExpectedHeight = h;
                artworkSizeUpdate = true;
            }
            if (artworkSizeUpdate) {
                for (RemoteControlStackEntry rcse : this.mRCStack) {
                    if (rcse.mRcClient == null) continue;
                    try {
                        rcse.mRcClient.setBitmapSizeForDisplay(rcd, w, h);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error setting bitmap size for RCD on RCC: ", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay rcd, boolean wantsSync) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            boolean rcdRegistered = false;
            for (DisplayInfoForServer di : this.mRcDisplays) {
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
                di.mWantsPositionSync = wantsSync;
                rcdRegistered = true;
                break;
            }
            if (!rcdRegistered) {
                return;
            }
            for (RemoteControlStackEntry rcse : this.mRCStack) {
                if (rcse.mRcClient == null) continue;
                try {
                    rcse.mRcClient.setWantsSyncForDisplay(rcd, wantsSync);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error setting position sync flag for RCD on RCC: ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemoteControlClientPlaybackPosition(int generationId, long timeMs) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClientGen != generationId) {
                    return;
                }
            }
        }
        MediaFocusControl.sendMsg(this.mEventHandler, 8, 0, generationId, 0, new Long(timeMs), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSetRemoteControlClientPlaybackPosition(int generationId, long timeMs) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClient != null && this.mCurrentRcClientGen == generationId) {
                    try {
                        this.mCurrentRcClient.seekTo(generationId, timeMs);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Current valid remote client is dead: " + e);
                        this.mCurrentRcClient = null;
                    }
                }
            }
        }
    }

    protected void updateRemoteControlClientMetadata(int genId, int key, Rating value) {
        MediaFocusControl.sendMsg(this.mEventHandler, 9, 2, genId, key, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdateRemoteControlClientMetadata(int genId, int key, Rating value) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClient != null && this.mCurrentRcClientGen == genId) {
                    try {
                        switch (key) {
                            case 0x10000001: {
                                this.mCurrentRcClient.updateMetadata(genId, key, value);
                                break;
                            }
                            default: {
                                Log.e(TAG, "unhandled metadata key " + key + " update for RCC " + genId);
                                break;
                            }
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Current valid remote client is dead", e);
                        this.mCurrentRcClient = null;
                    }
                }
            }
        }
    }

    protected void setPlaybackInfoForRcc(int rccId, int what, int value) {
        MediaFocusControl.sendMsg(this.mEventHandler, 4, 2, rccId, what, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewPlaybackInfoForRcc(int rccId, int key, int value) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            try {
                for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                    RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                    if (rcse.mRccId != rccId) continue;
                    switch (key) {
                        case 1: {
                            rcse.mPlaybackType = value;
                            this.postReevaluateRemote();
                            break;
                        }
                        case 2: {
                            rcse.mPlaybackVolume = value;
                            RemotePlaybackState remotePlaybackState = this.mMainRemote;
                            synchronized (remotePlaybackState) {
                                if (rccId == this.mMainRemote.mRccId) {
                                    this.mMainRemote.mVolume = value;
                                    this.mVolumeController.postHasNewRemotePlaybackInfo();
                                }
                                break;
                            }
                        }
                        case 3: {
                            rcse.mPlaybackVolumeMax = value;
                            RemotePlaybackState remotePlaybackState = this.mMainRemote;
                            synchronized (remotePlaybackState) {
                                if (rccId == this.mMainRemote.mRccId) {
                                    this.mMainRemote.mVolumeMax = value;
                                    this.mVolumeController.postHasNewRemotePlaybackInfo();
                                }
                                break;
                            }
                        }
                        case 4: {
                            rcse.mPlaybackVolumeHandling = value;
                            RemotePlaybackState remotePlaybackState = this.mMainRemote;
                            synchronized (remotePlaybackState) {
                                if (rccId == this.mMainRemote.mRccId) {
                                    this.mMainRemote.mVolumeHandling = value;
                                    this.mVolumeController.postHasNewRemotePlaybackInfo();
                                }
                                break;
                            }
                        }
                        case 5: {
                            rcse.mPlaybackStream = value;
                            break;
                        }
                        default: {
                            Log.e(TAG, "unhandled key " + key + " for RCC " + rccId);
                        }
                    }
                    return;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index mRCStack on onNewPlaybackInfoForRcc, lock error? ", e);
            }
        }
    }

    protected void setPlaybackStateForRcc(int rccId, int state, long timeMs, float speed) {
        MediaFocusControl.sendMsg(this.mEventHandler, 7, 2, rccId, state, new RccPlaybackState(state, timeMs, speed), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewPlaybackStateForRcc(int rccId, int state, RccPlaybackState newState) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            try {
                for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                    RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                    if (rcse.mRccId != rccId) continue;
                    rcse.mPlaybackState = newState;
                    RemotePlaybackState remotePlaybackState = this.mMainRemote;
                    synchronized (remotePlaybackState) {
                        if (rccId == this.mMainRemote.mRccId) {
                            this.mMainRemoteIsActive = MediaFocusControl.isPlaystateActive(state);
                            this.postReevaluateRemote();
                        }
                    }
                    if (!MediaFocusControl.isPlaystateActive(state)) continue;
                    this.postPromoteRcc(rccId);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index on mRCStack in onNewPlaybackStateForRcc, lock error? ", e);
            }
        }
    }

    protected void registerRemoteVolumeObserverForRcc(int rccId, IRemoteVolumeObserver rvo) {
        MediaFocusControl.sendMsg(this.mEventHandler, 5, 2, rccId, 0, rvo, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRegisterVolumeObserverForRcc(int rccId, IRemoteVolumeObserver rvo) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            try {
                for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                    RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                    if (rcse.mRccId != rccId) continue;
                    rcse.mRemoteVolumeObs = rvo;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index accessing media button stack, lock error? ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkUpdateRemoteStateIfActive(int streamType) {
        Object object = this.mRCStack;
        synchronized (object) {
            try {
                for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                    RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                    if (rcse.mPlaybackType != 1 || !MediaFocusControl.isPlaystateActive(rcse.mPlaybackState.mState) || rcse.mPlaybackStream != streamType) continue;
                    RemotePlaybackState remotePlaybackState = this.mMainRemote;
                    synchronized (remotePlaybackState) {
                        this.mMainRemote.mRccId = rcse.mRccId;
                        this.mMainRemote.mVolume = rcse.mPlaybackVolume;
                        this.mMainRemote.mVolumeMax = rcse.mPlaybackVolumeMax;
                        this.mMainRemote.mVolumeHandling = rcse.mPlaybackVolumeHandling;
                        this.mMainRemoteIsActive = true;
                    }
                    return true;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index accessing RC stack, lock error? ", e);
            }
        }
        object = this.mMainRemote;
        synchronized (object) {
            this.mMainRemoteIsActive = false;
        }
        return false;
    }

    private static boolean isPlaystateActive(int playState) {
        switch (playState) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustRemoteVolume(int streamType, int direction, int flags) {
        int rccId = -1;
        boolean volFixed = false;
        RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (!this.mMainRemoteIsActive) {
                return;
            }
            rccId = this.mMainRemote.mRccId;
            volFixed = this.mMainRemote.mVolumeHandling == 0;
        }
        if (!volFixed) {
            this.sendVolumeUpdateToRemote(rccId, direction);
        }
        this.mVolumeController.postRemoteVolumeChanged(streamType, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVolumeUpdateToRemote(int rccId, int direction) {
        if (direction == 0) {
            return;
        }
        IRemoteVolumeObserver rvo = null;
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            try {
                for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                    RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                    if (rcse.mRccId != rccId) continue;
                    rvo = rcse.mRemoteVolumeObs;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index accessing media button stack, lock error? ", e);
            }
        }
        if (rvo != null) {
            try {
                rvo.dispatchRemoteVolumeUpdate(direction, -1);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error dispatching relative volume update", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRemoteStreamMaxVolume() {
        RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId == -1) {
                return 0;
            }
            return this.mMainRemote.mVolumeMax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRemoteStreamVolume() {
        RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId == -1) {
                return 0;
            }
            return this.mMainRemote.mVolume;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemoteStreamVolume(int vol) {
        int rccId = -1;
        RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId == -1) {
                return;
            }
            rccId = this.mMainRemote.mRccId;
        }
        IRemoteVolumeObserver rvo = null;
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            try {
                for (int index = this.mRCStack.size() - 1; index >= 0; --index) {
                    RemoteControlStackEntry rcse = (RemoteControlStackEntry)this.mRCStack.elementAt(index);
                    if (rcse.mRccId != rccId) continue;
                    rvo = rcse.mRemoteVolumeObs;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index accessing media button stack, lock error? ", e);
            }
        }
        if (rvo != null) {
            try {
                rvo.dispatchRemoteVolumeUpdate(0, vol);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error dispatching absolute volume update", e);
            }
        }
    }

    private void postReevaluateRemote() {
        MediaFocusControl.sendMsg(this.mEventHandler, 3, 2, 0, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReevaluateRemote() {
        boolean hasRemotePlayback = false;
        Object object = this.mRCStack;
        synchronized (object) {
            for (RemoteControlStackEntry rcse : this.mRCStack) {
                if (rcse.mPlaybackType != 1) continue;
                hasRemotePlayback = true;
                break;
            }
        }
        object = this.mMainRemote;
        synchronized (object) {
            if (this.mHasRemotePlayback != hasRemotePlayback) {
                this.mHasRemotePlayback = hasRemotePlayback;
                this.mVolumeController.postRemoteSliderVisibility(hasRemotePlayback);
            }
        }
    }

    private class DisplayInfoForServer
    implements IBinder.DeathRecipient {
        private final IRemoteControlDisplay mRcDisplay;
        private final IBinder mRcDisplayBinder;
        private int mArtworkExpectedWidth = -1;
        private int mArtworkExpectedHeight = -1;
        private boolean mWantsPositionSync = false;
        private ComponentName mClientNotifListComp;
        private boolean mEnabled = true;

        public DisplayInfoForServer(IRemoteControlDisplay rcd, int w, int h) {
            this.mRcDisplay = rcd;
            this.mRcDisplayBinder = rcd.asBinder();
            this.mArtworkExpectedWidth = w;
            this.mArtworkExpectedHeight = h;
        }

        public boolean init() {
            try {
                this.mRcDisplayBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Log.w(MediaFocusControl.TAG, "registerRemoteControlDisplay() has a dead client " + this.mRcDisplayBinder);
                return false;
            }
            return true;
        }

        public void release() {
            try {
                this.mRcDisplayBinder.unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Log.e(MediaFocusControl.TAG, "Error in DisplaInfoForServer.relase()", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Stack stack = MediaFocusControl.this.mRCStack;
            synchronized (stack) {
                Log.w(MediaFocusControl.TAG, "RemoteControl: display " + this.mRcDisplay + " died");
                Iterator displayIterator = MediaFocusControl.this.mRcDisplays.iterator();
                while (displayIterator.hasNext()) {
                    DisplayInfoForServer di = (DisplayInfoForServer)displayIterator.next();
                    if (di.mRcDisplay != this.mRcDisplay) continue;
                    displayIterator.remove();
                    return;
                }
            }
        }
    }

    protected static class RemoteControlStackEntry
    implements IBinder.DeathRecipient {
        public int mRccId = -1;
        public final MediaFocusControl mController;
        public final PendingIntent mMediaIntent;
        public final ComponentName mReceiverComponent;
        public IBinder mToken;
        public String mCallingPackageName;
        public int mCallingUid;
        public IRemoteControlClient mRcClient;
        public RcClientDeathHandler mRcClientDeathHandler;
        public int mPlaybackType;
        public int mPlaybackVolume;
        public int mPlaybackVolumeMax;
        public int mPlaybackVolumeHandling;
        public int mPlaybackStream;
        public RccPlaybackState mPlaybackState;
        public IRemoteVolumeObserver mRemoteVolumeObs;

        public void resetPlaybackInfo() {
            this.mPlaybackType = 0;
            this.mPlaybackVolume = 15;
            this.mPlaybackVolumeMax = 15;
            this.mPlaybackVolumeHandling = 1;
            this.mPlaybackStream = 3;
            this.mPlaybackState.reset();
            this.mRemoteVolumeObs = null;
        }

        public RemoteControlStackEntry(MediaFocusControl controller, PendingIntent mediaIntent, ComponentName eventReceiver, IBinder token) {
            this.mController = controller;
            this.mMediaIntent = mediaIntent;
            this.mReceiverComponent = eventReceiver;
            this.mToken = token;
            this.mCallingUid = -1;
            this.mRcClient = null;
            this.mRccId = ++sLastRccId;
            this.mPlaybackState = new RccPlaybackState(1, -1L, 1.0f);
            this.resetPlaybackInfo();
            if (this.mToken != null) {
                try {
                    this.mToken.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.mController.mEventHandler.post(new Runnable(){

                        public void run() {
                            RemoteControlStackEntry.this.mController.unregisterMediaButtonIntent(RemoteControlStackEntry.this.mMediaIntent);
                        }
                    });
                }
            }
        }

        public void unlinkToRcClientDeath() {
            if (this.mRcClientDeathHandler != null && this.mRcClientDeathHandler.mCb != null) {
                try {
                    this.mRcClientDeathHandler.mCb.unlinkToDeath(this.mRcClientDeathHandler, 0);
                    this.mRcClientDeathHandler = null;
                }
                catch (NoSuchElementException e) {
                    Log.e(MediaFocusControl.TAG, "Encountered " + e + " in unlinkToRcClientDeath()");
                    e.printStackTrace();
                }
            }
        }

        public void destroy() {
            this.unlinkToRcClientDeath();
            if (this.mToken != null) {
                this.mToken.unlinkToDeath(this, 0);
                this.mToken = null;
            }
        }

        public void binderDied() {
            this.mController.unregisterMediaButtonIntent(this.mMediaIntent);
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }
    }

    private static class RccPlaybackState {
        public int mState;
        public long mPositionMs;
        public float mSpeed;

        public RccPlaybackState(int state, long positionMs, float speed) {
            this.mState = state;
            this.mPositionMs = positionMs;
            this.mSpeed = speed;
        }

        public void reset() {
            this.mState = 1;
            this.mPositionMs = -1L;
            this.mSpeed = 1.0f;
        }

        public String toString() {
            return this.stateToString() + ", " + this.posToString() + ", " + this.mSpeed + "X";
        }

        private String posToString() {
            if (this.mPositionMs == -1L) {
                return "PLAYBACK_POSITION_INVALID";
            }
            if (this.mPositionMs == -9216204211029966080L) {
                return "PLAYBACK_POSITION_ALWAYS_UNKNOWN";
            }
            return String.valueOf(this.mPositionMs) + "ms";
        }

        private String stateToString() {
            switch (this.mState) {
                case 0: {
                    return "PLAYSTATE_NONE";
                }
                case 1: {
                    return "PLAYSTATE_STOPPED";
                }
                case 2: {
                    return "PLAYSTATE_PAUSED";
                }
                case 3: {
                    return "PLAYSTATE_PLAYING";
                }
                case 4: {
                    return "PLAYSTATE_FAST_FORWARDING";
                }
                case 5: {
                    return "PLAYSTATE_REWINDING";
                }
                case 6: {
                    return "PLAYSTATE_SKIPPING_FORWARDS";
                }
                case 7: {
                    return "PLAYSTATE_SKIPPING_BACKWARDS";
                }
                case 8: {
                    return "PLAYSTATE_BUFFERING";
                }
                case 9: {
                    return "PLAYSTATE_ERROR";
                }
            }
            return "[invalid playstate]";
        }
    }

    private class RemotePlaybackState {
        int mRccId;
        int mVolume;
        int mVolumeMax;
        int mVolumeHandling;

        private RemotePlaybackState(int id2, int vol, int volMax) {
            this.mRccId = id2;
            this.mVolume = vol;
            this.mVolumeMax = volMax;
            this.mVolumeHandling = 1;
        }
    }

    private class RcClientDeathHandler
    implements IBinder.DeathRecipient {
        private final IBinder mCb;
        private final PendingIntent mMediaIntent;

        RcClientDeathHandler(IBinder cb, PendingIntent pi) {
            this.mCb = cb;
            this.mMediaIntent = pi;
        }

        public void binderDied() {
            Log.w(MediaFocusControl.TAG, "  RemoteControlClient died");
            MediaFocusControl.this.registerRemoteControlClient(this.mMediaIntent, null, null);
            MediaFocusControl.this.postReevaluateRemote();
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private class PackageIntentsReceiver
    extends BroadcastReceiver {
        private PackageIntentsReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String packageName;
            String action = intent.getAction();
            if (action.equals("android.intent.action.PACKAGE_REMOVED") || action.equals("android.intent.action.PACKAGE_DATA_CLEARED")) {
                String packageName2;
                if (!intent.getBooleanExtra("android.intent.extra.REPLACING", false) && (packageName2 = intent.getData().getSchemeSpecificPart()) != null) {
                    MediaFocusControl.this.cleanupMediaButtonReceiverForPackage(packageName2, true);
                }
            } else if ((action.equals("android.intent.action.PACKAGE_ADDED") || action.equals("android.intent.action.PACKAGE_CHANGED")) && (packageName = intent.getData().getSchemeSpecificPart()) != null) {
                MediaFocusControl.this.cleanupMediaButtonReceiverForPackage(packageName, false);
            }
        }
    }

    protected class AudioFocusDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        AudioFocusDeathHandler(IBinder cb) {
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Object object = mAudioFocusLock;
            synchronized (object) {
                Log.w(MediaFocusControl.TAG, "  AudioFocus   audio focus client died");
                MediaFocusControl.this.removeFocusStackEntryForClient(this.mCb);
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private class MediaEventHandler
    extends Handler {
        MediaEventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    MediaFocusControl.this.onHandlePersistMediaButtonReceiver((ComponentName)msg.obj);
                    break;
                }
                case 1: {
                    MediaFocusControl.this.onRcDisplayClear();
                    break;
                }
                case 2: {
                    MediaFocusControl.this.onRcDisplayUpdate((RemoteControlStackEntry)msg.obj, msg.arg1);
                    break;
                }
                case 3: {
                    MediaFocusControl.this.onReevaluateRemote();
                    break;
                }
                case 4: {
                    MediaFocusControl.this.onNewPlaybackInfoForRcc(msg.arg1, msg.arg2, (Integer)msg.obj);
                    break;
                }
                case 5: {
                    MediaFocusControl.this.onRegisterVolumeObserverForRcc(msg.arg1, (IRemoteVolumeObserver)msg.obj);
                    break;
                }
                case 7: {
                    MediaFocusControl.this.onNewPlaybackStateForRcc(msg.arg1, msg.arg2, (RccPlaybackState)msg.obj);
                    break;
                }
                case 8: {
                    MediaFocusControl.this.onSetRemoteControlClientPlaybackPosition(msg.arg1, (Long)msg.obj);
                    break;
                }
                case 9: {
                    MediaFocusControl.this.onUpdateRemoteControlClientMetadata(msg.arg1, msg.arg2, (Rating)msg.obj);
                    break;
                }
                case 6: {
                    MediaFocusControl.this.onPromoteRcc(msg.arg1);
                    break;
                }
                case 10: {
                    MediaFocusControl.this.onRcDisplayInitInfo((IRemoteControlDisplay)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 11: {
                    MediaFocusControl.this.onReevaluateRemoteControlDisplays();
                }
            }
        }
    }

    private class NotificationListenerObserver
    extends ContentObserver {
        NotificationListenerObserver() {
            super(MediaFocusControl.this.mEventHandler);
            MediaFocusControl.this.mContentResolver.registerContentObserver(Settings.Secure.getUriFor("enabled_notification_listeners"), false, this);
        }

        public void onChange(boolean selfChange, Uri uri) {
            if (!ENABLED_NOTIFICATION_LISTENERS_URI.equals(uri) || selfChange) {
                return;
            }
            MediaFocusControl.this.postReevaluateRemoteControlDisplays();
        }
    }
}

