/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.mtp.MtpDeviceInfo;
import android.mtp.MtpObjectInfo;
import android.mtp.MtpStorageInfo;

public final class MtpDevice {
    private static final String TAG = "MtpDevice";
    private final UsbDevice mDevice;
    private int mNativeContext;

    public MtpDevice(UsbDevice device) {
        this.mDevice = device;
    }

    public boolean open(UsbDeviceConnection connection) {
        boolean result = this.native_open(this.mDevice.getDeviceName(), connection.getFileDescriptor());
        if (!result) {
            connection.close();
        }
        return result;
    }

    public void close() {
        this.native_close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.native_close();
        }
        finally {
            super.finalize();
        }
    }

    public String getDeviceName() {
        return this.mDevice.getDeviceName();
    }

    public int getDeviceId() {
        return this.mDevice.getDeviceId();
    }

    public String toString() {
        return this.mDevice.getDeviceName();
    }

    public MtpDeviceInfo getDeviceInfo() {
        return this.native_get_device_info();
    }

    public int[] getStorageIds() {
        return this.native_get_storage_ids();
    }

    public int[] getObjectHandles(int storageId, int format, int objectHandle) {
        return this.native_get_object_handles(storageId, format, objectHandle);
    }

    public byte[] getObject(int objectHandle, int objectSize) {
        return this.native_get_object(objectHandle, objectSize);
    }

    public byte[] getThumbnail(int objectHandle) {
        return this.native_get_thumbnail(objectHandle);
    }

    public MtpStorageInfo getStorageInfo(int storageId) {
        return this.native_get_storage_info(storageId);
    }

    public MtpObjectInfo getObjectInfo(int objectHandle) {
        return this.native_get_object_info(objectHandle);
    }

    public boolean deleteObject(int objectHandle) {
        return this.native_delete_object(objectHandle);
    }

    public long getParent(int objectHandle) {
        return this.native_get_parent(objectHandle);
    }

    public long getStorageId(int objectHandle) {
        return this.native_get_storage_id(objectHandle);
    }

    public boolean importFile(int objectHandle, String destPath) {
        return this.native_import_file(objectHandle, destPath);
    }

    private native boolean native_open(String var1, int var2);

    private native void native_close();

    private native MtpDeviceInfo native_get_device_info();

    private native int[] native_get_storage_ids();

    private native MtpStorageInfo native_get_storage_info(int var1);

    private native int[] native_get_object_handles(int var1, int var2, int var3);

    private native MtpObjectInfo native_get_object_info(int var1);

    private native byte[] native_get_object(int var1, int var2);

    private native byte[] native_get_thumbnail(int var1);

    private native boolean native_delete_object(int var1);

    private native long native_get_parent(int var1);

    private native long native_get_storage_id(int var1);

    private native boolean native_import_file(int var1, String var2);

    static {
        System.loadLibrary("media_jni");
    }
}

