/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.BaseNetworkStateTracker;
import android.net.DhcpResults;
import android.net.InterfaceConfiguration;
import android.net.LinkCapabilities;
import android.net.LinkProperties;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.server.net.BaseNetworkObserver;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class EthernetDataTracker
extends BaseNetworkStateTracker {
    private static final String NETWORKTYPE = "ETHERNET";
    private static final String TAG = "Ethernet";
    private AtomicBoolean mTeardownRequested = new AtomicBoolean(false);
    private AtomicBoolean mPrivateDnsRouteSet = new AtomicBoolean(false);
    private AtomicInteger mDefaultGatewayAddr = new AtomicInteger(0);
    private AtomicBoolean mDefaultRouteSet = new AtomicBoolean(false);
    private static boolean mLinkUp;
    private InterfaceObserver mInterfaceObserver;
    private String mHwAddr;
    private Handler mCsHandler;
    private static EthernetDataTracker sInstance;
    private static String sIfaceMatch;
    private static String mIface;
    private INetworkManagementService mNMService;

    private EthernetDataTracker() {
        this.mNetworkInfo = new NetworkInfo(9, 0, NETWORKTYPE, "");
        this.mLinkProperties = new LinkProperties();
        this.mLinkCapabilities = new LinkCapabilities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interfaceAdded(String iface) {
        if (!iface.matches(sIfaceMatch)) {
            return;
        }
        Log.d(TAG, "Adding " + iface);
        EthernetDataTracker ethernetDataTracker = this;
        synchronized (ethernetDataTracker) {
            if (!mIface.isEmpty()) {
                return;
            }
            mIface = iface;
        }
        try {
            this.mNMService.setInterfaceUp(iface);
        }
        catch (Exception e) {
            Log.e(TAG, "Error upping interface " + iface + ": " + e);
        }
        this.mNetworkInfo.setIsAvailable(true);
        Message msg = this.mCsHandler.obtainMessage(458753, this.mNetworkInfo);
        msg.sendToTarget();
    }

    public void disconnect() {
        NetworkUtils.stopDhcp(mIface);
        this.mLinkProperties.clear();
        this.mNetworkInfo.setIsAvailable(false);
        this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, this.mHwAddr);
        Message msg = this.mCsHandler.obtainMessage(458753, this.mNetworkInfo);
        msg.sendToTarget();
        msg = this.mCsHandler.obtainMessage(458752, this.mNetworkInfo);
        msg.sendToTarget();
        IBinder b = ServiceManager.getService("network_management");
        INetworkManagementService service = INetworkManagementService.Stub.asInterface(b);
        try {
            service.clearInterfaceAddresses(mIface);
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to clear addresses or disable ipv6" + e);
        }
    }

    private void interfaceRemoved(String iface) {
        if (!iface.equals(mIface)) {
            return;
        }
        Log.d(TAG, "Removing " + iface);
        this.disconnect();
        mIface = "";
    }

    private void runDhcp() {
        Thread dhcpThread = new Thread(new Runnable(){

            public void run() {
                DhcpResults dhcpResults = new DhcpResults();
                if (!NetworkUtils.runDhcp(mIface, dhcpResults)) {
                    Log.e(EthernetDataTracker.TAG, "DHCP request error:" + NetworkUtils.getDhcpError());
                    return;
                }
                EthernetDataTracker.this.mLinkProperties = dhcpResults.linkProperties;
                EthernetDataTracker.this.mNetworkInfo.setIsAvailable(true);
                EthernetDataTracker.this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, EthernetDataTracker.this.mHwAddr);
                Message msg = EthernetDataTracker.this.mCsHandler.obtainMessage(458752, EthernetDataTracker.this.mNetworkInfo);
                msg.sendToTarget();
            }
        });
        dhcpThread.start();
    }

    public static synchronized EthernetDataTracker getInstance() {
        if (sInstance == null) {
            sInstance = new EthernetDataTracker();
        }
        return sInstance;
    }

    public Object Clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void setTeardownRequested(boolean isRequested) {
        this.mTeardownRequested.set(isRequested);
    }

    public boolean isTeardownRequested() {
        return this.mTeardownRequested.get();
    }

    public void startMonitoring(Context context, Handler target) {
        this.mContext = context;
        this.mCsHandler = target;
        IBinder b = ServiceManager.getService("network_management");
        this.mNMService = INetworkManagementService.Stub.asInterface(b);
        this.mInterfaceObserver = new InterfaceObserver(this);
        sIfaceMatch = context.getResources().getString(17039384);
        try {
            String[] ifaces;
            for (String iface : ifaces = this.mNMService.listInterfaces()) {
                if (!iface.matches(sIfaceMatch)) continue;
                mIface = iface;
                this.mNMService.setInterfaceUp(iface);
                InterfaceConfiguration config = this.mNMService.getInterfaceConfig(iface);
                mLinkUp = config.hasFlag("up");
                if (config != null && this.mHwAddr == null) {
                    this.mHwAddr = config.getHardwareAddress();
                    if (this.mHwAddr != null) {
                        this.mNetworkInfo.setExtraInfo(this.mHwAddr);
                    }
                }
                NetworkUtils.stopDhcp(mIface);
                this.reconnect();
                break;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not get list of interfaces " + e);
        }
        try {
            this.mNMService.registerObserver(this.mInterfaceObserver);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not register InterfaceObserver " + e);
        }
    }

    public boolean teardown() {
        this.mTeardownRequested.set(true);
        NetworkUtils.stopDhcp(mIface);
        return true;
    }

    public boolean reconnect() {
        if (mLinkUp) {
            this.mTeardownRequested.set(false);
            this.runDhcp();
        }
        return mLinkUp;
    }

    public void captivePortalCheckComplete() {
    }

    public void captivePortalCheckCompleted(boolean isCaptivePortal) {
    }

    public boolean setRadio(boolean turnOn) {
        return true;
    }

    public synchronized boolean isAvailable() {
        return this.mNetworkInfo.isAvailable();
    }

    public int startUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public int stopUsingNetworkFeature(String feature, int callingPid, int callingUid) {
        return -1;
    }

    public void setUserDataEnable(boolean enabled) {
        Log.w(TAG, "ignoring setUserDataEnable(" + enabled + ")");
    }

    public void setPolicyDataEnable(boolean enabled) {
        Log.w(TAG, "ignoring setPolicyDataEnable(" + enabled + ")");
    }

    public boolean isPrivateDnsRouteSet() {
        return this.mPrivateDnsRouteSet.get();
    }

    public void privateDnsRouteSet(boolean enabled) {
        this.mPrivateDnsRouteSet.set(enabled);
    }

    public synchronized NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public synchronized LinkProperties getLinkProperties() {
        return new LinkProperties(this.mLinkProperties);
    }

    public LinkCapabilities getLinkCapabilities() {
        return new LinkCapabilities(this.mLinkCapabilities);
    }

    public int getDefaultGatewayAddr() {
        return this.mDefaultGatewayAddr.get();
    }

    public boolean isDefaultRouteSet() {
        return this.mDefaultRouteSet.get();
    }

    public void defaultRouteSet(boolean enabled) {
        this.mDefaultRouteSet.set(enabled);
    }

    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    public void setDependencyMet(boolean met) {
    }

    public void addStackedLink(LinkProperties link) {
        this.mLinkProperties.addStackedLink(link);
    }

    public void removeStackedLink(LinkProperties link) {
        this.mLinkProperties.removeStackedLink(link);
    }

    public void supplyMessenger(Messenger messenger) {
    }

    static {
        sIfaceMatch = "";
        mIface = "";
    }

    private static class InterfaceObserver
    extends BaseNetworkObserver {
        private EthernetDataTracker mTracker;

        InterfaceObserver(EthernetDataTracker tracker) {
            this.mTracker = tracker;
        }

        public void interfaceStatusChanged(String iface, boolean up) {
            Log.d(EthernetDataTracker.TAG, "Interface status changed: " + iface + (up ? "up" : "down"));
        }

        public void interfaceLinkStateChanged(String iface, boolean up) {
            if (mIface.equals(iface)) {
                Log.d(EthernetDataTracker.TAG, "Interface " + iface + " link " + (up ? "up" : "down"));
                mLinkUp = up;
                this.mTracker.mNetworkInfo.setIsAvailable(up);
                if (up) {
                    this.mTracker.reconnect();
                } else {
                    this.mTracker.disconnect();
                }
            }
        }

        public void interfaceAdded(String iface) {
            this.mTracker.interfaceAdded(iface);
        }

        public void interfaceRemoved(String iface) {
            this.mTracker.interfaceRemoved(iface);
        }
    }
}

