/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;

public class LinkAddress
implements Parcelable {
    private InetAddress address;
    private int prefixLength;
    public static final Parcelable.Creator<LinkAddress> CREATOR = new Parcelable.Creator<LinkAddress>(){

        @Override
        public LinkAddress createFromParcel(Parcel in) {
            InetAddress address = null;
            int prefixLength = 0;
            if (in.readByte() == 1) {
                try {
                    address = InetAddress.getByAddress(in.createByteArray());
                    prefixLength = in.readInt();
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            return new LinkAddress(address, prefixLength);
        }

        public LinkAddress[] newArray(int size) {
            return new LinkAddress[size];
        }
    };

    private void init(InetAddress address, int prefixLength) {
        if (address == null || prefixLength < 0 || address instanceof Inet4Address && prefixLength > 32 || prefixLength > 128) {
            throw new IllegalArgumentException("Bad LinkAddress params " + address + "/" + prefixLength);
        }
        this.address = address;
        this.prefixLength = prefixLength;
    }

    public LinkAddress(InetAddress address, int prefixLength) {
        this.init(address, prefixLength);
    }

    public LinkAddress(InterfaceAddress interfaceAddress) {
        this.init(interfaceAddress.getAddress(), interfaceAddress.getNetworkPrefixLength());
    }

    public LinkAddress(String address) {
        InetAddress inetAddress = null;
        int prefixLength = -1;
        try {
            String[] pieces = address.split("/", 2);
            prefixLength = Integer.parseInt(pieces[1]);
            inetAddress = InetAddress.parseNumericAddress(pieces[0]);
        }
        catch (NullPointerException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (NumberFormatException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (inetAddress == null || prefixLength == -1) {
            throw new IllegalArgumentException("Bad LinkAddress params " + address);
        }
        this.init(inetAddress, prefixLength);
    }

    public String toString() {
        return this.address == null ? "" : this.address.getHostAddress() + "/" + this.prefixLength;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LinkAddress)) {
            return false;
        }
        LinkAddress linkAddress = (LinkAddress)obj;
        return this.address.equals(linkAddress.address) && this.prefixLength == linkAddress.prefixLength;
    }

    public int hashCode() {
        return (null == this.address ? 0 : this.address.hashCode()) + this.prefixLength;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getNetworkPrefixLength() {
        return this.prefixLength;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.address != null) {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.address.getAddress());
            dest.writeInt(this.prefixLength);
        } else {
            dest.writeByte((byte)0);
        }
    }
}

