/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.content.Intent;
import android.net.wifi.StateChangeResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiConfigStore;
import android.net.wifi.WifiStateMachine;
import android.os.Handler;
import android.os.Message;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.PrintWriter;

class SupplicantStateTracker
extends StateMachine {
    private static final String TAG = "SupplicantStateTracker";
    private static final boolean DBG = false;
    private WifiStateMachine mWifiStateMachine;
    private WifiConfigStore mWifiConfigStore;
    private int mAuthenticationFailuresCount = 0;
    private int mAssociationRejectCount = 0;
    private boolean mAuthFailureInSupplicantBroadcast = false;
    private static final int MAX_RETRIES_ON_AUTHENTICATION_FAILURE = 2;
    private static final int MAX_RETRIES_ON_ASSOCIATION_REJECT = 4;
    private boolean mNetworksDisabledDuringConnect = false;
    private Context mContext;
    private State mUninitializedState = new UninitializedState();
    private State mDefaultState = new DefaultState();
    private State mInactiveState = new InactiveState();
    private State mDisconnectState = new DisconnectedState();
    private State mScanState = new ScanState();
    private State mHandshakeState = new HandshakeState();
    private State mCompletedState = new CompletedState();
    private State mDormantState = new DormantState();

    public SupplicantStateTracker(Context c, WifiStateMachine wsm, WifiConfigStore wcs, Handler t) {
        super(TAG, t.getLooper());
        this.mContext = c;
        this.mWifiStateMachine = wsm;
        this.mWifiConfigStore = wcs;
        this.addState(this.mDefaultState);
        this.addState(this.mUninitializedState, this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mDisconnectState, this.mDefaultState);
        this.addState(this.mScanState, this.mDefaultState);
        this.addState(this.mHandshakeState, this.mDefaultState);
        this.addState(this.mCompletedState, this.mDefaultState);
        this.addState(this.mDormantState, this.mDefaultState);
        this.setInitialState(this.mUninitializedState);
        this.setLogRecSize(50);
        this.setLogOnlyTransitions(true);
        this.start();
    }

    private void handleNetworkConnectionFailure(int netId, int disableReason) {
        if (this.mNetworksDisabledDuringConnect) {
            this.mWifiConfigStore.enableAllNetworks();
            this.mNetworksDisabledDuringConnect = false;
        }
        this.mWifiConfigStore.disableNetwork(netId, disableReason);
    }

    private void transitionOnSupplicantStateChange(StateChangeResult stateChangeResult) {
        SupplicantState supState = stateChangeResult.state;
        switch (supState) {
            case DISCONNECTED: {
                this.transitionTo(this.mDisconnectState);
                break;
            }
            case INTERFACE_DISABLED: {
                break;
            }
            case SCANNING: {
                this.transitionTo(this.mScanState);
                break;
            }
            case AUTHENTICATING: 
            case ASSOCIATING: 
            case ASSOCIATED: 
            case FOUR_WAY_HANDSHAKE: 
            case GROUP_HANDSHAKE: {
                this.transitionTo(this.mHandshakeState);
                break;
            }
            case COMPLETED: {
                this.transitionTo(this.mCompletedState);
                break;
            }
            case DORMANT: {
                this.transitionTo(this.mDormantState);
                break;
            }
            case INACTIVE: {
                this.transitionTo(this.mInactiveState);
                break;
            }
            case UNINITIALIZED: 
            case INVALID: {
                this.transitionTo(this.mUninitializedState);
                break;
            }
            default: {
                Log.e(TAG, "Unknown supplicant state " + supState);
            }
        }
    }

    private void sendSupplicantStateChangedBroadcast(SupplicantState state, boolean failedAuth) {
        Intent intent = new Intent("android.net.wifi.supplicant.STATE_CHANGE");
        intent.addFlags(0x24000000);
        intent.putExtra("newState", state);
        if (failedAuth) {
            intent.putExtra("supplicantError", 1);
        }
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        pw.println("mAuthenticationFailuresCount " + this.mAuthenticationFailuresCount);
        pw.println("mAuthFailureInSupplicantBroadcast " + this.mAuthFailureInSupplicantBroadcast);
        pw.println("mNetworksDisabledDuringConnect " + this.mNetworksDisabledDuringConnect);
        pw.println();
    }

    class DormantState
    extends State {
        DormantState() {
        }

        public void enter() {
        }
    }

    class CompletedState
    extends State {
        CompletedState() {
        }

        public void enter() {
            SupplicantStateTracker.this.mAuthenticationFailuresCount = 0;
            SupplicantStateTracker.this.mAssociationRejectCount = 0;
            if (SupplicantStateTracker.this.mNetworksDisabledDuringConnect) {
                SupplicantStateTracker.this.mWifiConfigStore.enableAllNetworks();
                SupplicantStateTracker.this.mNetworksDisabledDuringConnect = false;
            }
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147462: {
                    StateChangeResult stateChangeResult = (StateChangeResult)message.obj;
                    SupplicantState state = stateChangeResult.state;
                    SupplicantStateTracker.this.sendSupplicantStateChangedBroadcast(state, SupplicantStateTracker.this.mAuthFailureInSupplicantBroadcast);
                    if (SupplicantState.isConnecting(state)) break;
                    SupplicantStateTracker.this.transitionOnSupplicantStateChange(stateChangeResult);
                    break;
                }
                case 131183: {
                    SupplicantStateTracker.this.sendSupplicantStateChangedBroadcast(SupplicantState.DISCONNECTED, false);
                    SupplicantStateTracker.this.transitionTo(SupplicantStateTracker.this.mUninitializedState);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class HandshakeState
    extends State {
        private static final int MAX_SUPPLICANT_LOOP_ITERATIONS = 4;
        private int mLoopDetectIndex;
        private int mLoopDetectCount;

        HandshakeState() {
        }

        public void enter() {
            this.mLoopDetectIndex = 0;
            this.mLoopDetectCount = 0;
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147462: {
                    StateChangeResult stateChangeResult = (StateChangeResult)message.obj;
                    SupplicantState state = stateChangeResult.state;
                    if (SupplicantState.isHandshakeState(state)) {
                        if (this.mLoopDetectIndex > state.ordinal()) {
                            ++this.mLoopDetectCount;
                        }
                        if (this.mLoopDetectCount > 4) {
                            Log.d(SupplicantStateTracker.TAG, "Supplicant loop detected, disabling network " + stateChangeResult.networkId);
                            SupplicantStateTracker.this.handleNetworkConnectionFailure(stateChangeResult.networkId, 3);
                        }
                        this.mLoopDetectIndex = state.ordinal();
                        SupplicantStateTracker.this.sendSupplicantStateChangedBroadcast(state, SupplicantStateTracker.this.mAuthFailureInSupplicantBroadcast);
                        break;
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    class ScanState
    extends State {
        ScanState() {
        }

        public void enter() {
        }
    }

    class DisconnectedState
    extends State {
        DisconnectedState() {
        }

        public void enter() {
            Message message = SupplicantStateTracker.this.getCurrentMessage();
            StateChangeResult stateChangeResult = (StateChangeResult)message.obj;
            if (SupplicantStateTracker.this.mAuthenticationFailuresCount >= 2) {
                Log.d(SupplicantStateTracker.TAG, "Failed to authenticate, disabling network " + stateChangeResult.networkId);
                SupplicantStateTracker.this.handleNetworkConnectionFailure(stateChangeResult.networkId, 3);
                SupplicantStateTracker.this.mAuthenticationFailuresCount = 0;
            } else if (SupplicantStateTracker.this.mAssociationRejectCount >= 4) {
                Log.d(SupplicantStateTracker.TAG, "Association getting rejected, disabling network " + stateChangeResult.networkId);
                SupplicantStateTracker.this.handleNetworkConnectionFailure(stateChangeResult.networkId, 4);
                SupplicantStateTracker.this.mAssociationRejectCount = 0;
            }
        }
    }

    class InactiveState
    extends State {
        InactiveState() {
        }

        public void enter() {
        }
    }

    class UninitializedState
    extends State {
        UninitializedState() {
        }

        public void enter() {
        }
    }

    class DefaultState
    extends State {
        DefaultState() {
        }

        public void enter() {
        }

        public boolean processMessage(Message message) {
            switch (message.what) {
                case 147463: {
                    SupplicantStateTracker.this.mAuthenticationFailuresCount++;
                    SupplicantStateTracker.this.mAuthFailureInSupplicantBroadcast = true;
                    break;
                }
                case 147462: {
                    StateChangeResult stateChangeResult = (StateChangeResult)message.obj;
                    SupplicantState state = stateChangeResult.state;
                    SupplicantStateTracker.this.sendSupplicantStateChangedBroadcast(state, SupplicantStateTracker.this.mAuthFailureInSupplicantBroadcast);
                    SupplicantStateTracker.this.mAuthFailureInSupplicantBroadcast = false;
                    SupplicantStateTracker.this.transitionOnSupplicantStateChange(stateChangeResult);
                    break;
                }
                case 131183: {
                    SupplicantStateTracker.this.transitionTo(SupplicantStateTracker.this.mUninitializedState);
                    break;
                }
                case 151553: {
                    SupplicantStateTracker.this.mNetworksDisabledDuringConnect = true;
                    SupplicantStateTracker.this.mAssociationRejectCount = 0;
                    break;
                }
                case 147499: {
                    SupplicantStateTracker.this.mAssociationRejectCount++;
                    break;
                }
                default: {
                    Log.e(SupplicantStateTracker.TAG, "Ignoring " + message);
                }
            }
            return true;
        }
    }
}

