/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.graphics.Color;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import java.util.Map;

public class ChangeText
extends Transition {
    private static final String LOG_TAG = "TextChange";
    private static final String PROPNAME_TEXT = "android:textchange:text";
    private static final String PROPNAME_TEXT_SELECTION_START = "android:textchange:textSelectionStart";
    private static final String PROPNAME_TEXT_SELECTION_END = "android:textchange:textSelectionEnd";
    private static final String PROPNAME_TEXT_COLOR = "android:textchange:textColor";
    private int mChangeBehavior = 0;
    public static final int CHANGE_BEHAVIOR_KEEP = 0;
    public static final int CHANGE_BEHAVIOR_OUT = 1;
    public static final int CHANGE_BEHAVIOR_IN = 2;
    public static final int CHANGE_BEHAVIOR_OUT_IN = 3;
    private static final String[] sTransitionProperties = new String[]{"android:textchange:text", "android:textchange:textSelectionStart", "android:textchange:textSelectionEnd"};

    public ChangeText setChangeBehavior(int changeBehavior) {
        if (changeBehavior >= 0 && changeBehavior <= 3) {
            this.mChangeBehavior = changeBehavior;
        }
        return this;
    }

    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public int getChangeBehavior() {
        return this.mChangeBehavior;
    }

    private void captureValues(TransitionValues transitionValues) {
        if (transitionValues.view instanceof TextView) {
            TextView textview = (TextView)transitionValues.view;
            transitionValues.values.put(PROPNAME_TEXT, textview.getText());
            if (textview instanceof EditText) {
                transitionValues.values.put(PROPNAME_TEXT_SELECTION_START, textview.getSelectionStart());
                transitionValues.values.put(PROPNAME_TEXT_SELECTION_END, textview.getSelectionEnd());
            }
            if (this.mChangeBehavior > 0) {
                transitionValues.values.put(PROPNAME_TEXT_COLOR, textview.getCurrentTextColor());
            }
        }
    }

    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        int endSelectionEnd;
        int endSelectionStart;
        int startSelectionEnd;
        int startSelectionStart;
        String endText;
        if (startValues == null || endValues == null || !(startValues.view instanceof TextView) || !(endValues.view instanceof TextView)) {
            return null;
        }
        final TextView view = (TextView)endValues.view;
        Map<String, Object> startVals = startValues.values;
        Map<String, Object> endVals = endValues.values;
        final String startText = startVals.get(PROPNAME_TEXT) != null ? (CharSequence)startVals.get(PROPNAME_TEXT) : "";
        CharSequence charSequence = endText = endVals.get(PROPNAME_TEXT) != null ? (CharSequence)endVals.get(PROPNAME_TEXT) : "";
        if (view instanceof EditText) {
            startSelectionStart = startVals.get(PROPNAME_TEXT_SELECTION_START) != null ? (Integer)startVals.get(PROPNAME_TEXT_SELECTION_START) : -1;
            startSelectionEnd = startVals.get(PROPNAME_TEXT_SELECTION_END) != null ? (Integer)startVals.get(PROPNAME_TEXT_SELECTION_END) : startSelectionStart;
            endSelectionStart = endVals.get(PROPNAME_TEXT_SELECTION_START) != null ? (Integer)endVals.get(PROPNAME_TEXT_SELECTION_START) : -1;
            endSelectionEnd = endVals.get(PROPNAME_TEXT_SELECTION_END) != null ? (Integer)endVals.get(PROPNAME_TEXT_SELECTION_END) : endSelectionStart;
        } else {
            endSelectionEnd = -1;
            endSelectionStart = -1;
            startSelectionEnd = -1;
            startSelectionStart = -1;
        }
        if (!startText.equals(endText)) {
            Animator anim2;
            int endColor;
            if (this.mChangeBehavior != 2) {
                view.setText(startText);
                if (view instanceof EditText) {
                    this.setSelection((EditText)view, startSelectionStart, startSelectionEnd);
                }
            }
            if (this.mChangeBehavior == 0) {
                endColor = 0;
                int startColor = 0;
                anim2 = ValueAnimator.ofFloat(0.0f, 1.0f);
                anim2.addListener(new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        if (startText.equals(view.getText())) {
                            view.setText(endText);
                            if (view instanceof EditText) {
                                ChangeText.this.setSelection((EditText)view, endSelectionStart, endSelectionEnd);
                            }
                        }
                    }
                });
            } else {
                final int startColor = (Integer)startVals.get(PROPNAME_TEXT_COLOR);
                endColor = (Integer)endVals.get(PROPNAME_TEXT_COLOR);
                ValueAnimator outAnim = null;
                ValueAnimator inAnim = null;
                if (this.mChangeBehavior == 3 || this.mChangeBehavior == 1) {
                    outAnim = ValueAnimator.ofInt(255, 0);
                    outAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            int currAlpha = (Integer)animation.getAnimatedValue();
                            view.setTextColor(currAlpha << 24 | startColor & 0xFF0000 | startColor & 0xFF00 | startColor & 0xFF);
                        }
                    });
                    outAnim.addListener(new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            if (startText.equals(view.getText())) {
                                view.setText(endText);
                                if (view instanceof EditText) {
                                    ChangeText.this.setSelection((EditText)view, endSelectionStart, endSelectionEnd);
                                }
                            }
                            view.setTextColor(endColor);
                        }
                    });
                }
                if (this.mChangeBehavior == 3 || this.mChangeBehavior == 2) {
                    inAnim = ValueAnimator.ofInt(0, 255);
                    inAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            int currAlpha = (Integer)animation.getAnimatedValue();
                            view.setTextColor(currAlpha << 24 | Color.red(endColor) << 16 | Color.green(endColor) << 8 | Color.red(endColor));
                        }
                    });
                    inAnim.addListener(new AnimatorListenerAdapter(){

                        public void onAnimationCancel(Animator animation) {
                            view.setTextColor(endColor);
                        }
                    });
                }
                if (outAnim != null && inAnim != null) {
                    anim2 = new AnimatorSet();
                    ((AnimatorSet)anim2).playSequentially(outAnim, inAnim);
                } else {
                    anim2 = outAnim != null ? outAnim : inAnim;
                }
            }
            Transition.TransitionListenerAdapter transitionListener = new Transition.TransitionListenerAdapter(){
                int mPausedColor = 0;

                public void onTransitionPause(Transition transition2) {
                    if (ChangeText.this.mChangeBehavior != 2) {
                        view.setText(endText);
                        if (view instanceof EditText) {
                            ChangeText.this.setSelection((EditText)view, endSelectionStart, endSelectionEnd);
                        }
                    }
                    if (ChangeText.this.mChangeBehavior > 0) {
                        this.mPausedColor = view.getCurrentTextColor();
                        view.setTextColor(endColor);
                    }
                }

                public void onTransitionResume(Transition transition2) {
                    if (ChangeText.this.mChangeBehavior != 2) {
                        view.setText(startText);
                        if (view instanceof EditText) {
                            ChangeText.this.setSelection((EditText)view, startSelectionStart, startSelectionEnd);
                        }
                    }
                    if (ChangeText.this.mChangeBehavior > 0) {
                        view.setTextColor(this.mPausedColor);
                    }
                }
            };
            this.addListener(transitionListener);
            return anim2;
        }
        return null;
    }

    private void setSelection(EditText editText, int start, int end) {
        if (start >= 0 && end >= 0) {
            editText.setSelection(start, end);
        }
    }
}

